// GENERATED FILE - DO NOT EDIT
// Generated by gen_swizzle_format_table.py using data from swizzle_format_data.json
//
// Copyright 2015 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// swizzle_format_info:
//   Provides information for swizzle format and a map from type->formatinfo
//

#include "libANGLE/renderer/d3d/d3d11/swizzle_format_info.h"

#include <GLES3/gl3.h>

namespace rx
{

namespace d3d11
{

SwizzleSizeType::SwizzleSizeType() : maxComponentSize(0), componentType(GL_NONE)
{
}

SwizzleSizeType::SwizzleSizeType(size_t maxComponentSize, GLenum componentType)
    : maxComponentSize(maxComponentSize), componentType(componentType)
{
}

bool SwizzleSizeType::operator<(const SwizzleSizeType &other) const
{
    return (maxComponentSize != other.maxComponentSize)
               ? (maxComponentSize < other.maxComponentSize)
               : (componentType < other.componentType);
}

SwizzleFormatInfo::SwizzleFormatInfo()
    : mTexFormat(DXGI_FORMAT_UNKNOWN),
      mSRVFormat(DXGI_FORMAT_UNKNOWN),
      mRTVFormat(DXGI_FORMAT_UNKNOWN)
{
}

SwizzleFormatInfo::SwizzleFormatInfo(DXGI_FORMAT texFormat,
                                     DXGI_FORMAT srvFormat,
                                     DXGI_FORMAT rtvFormat)
    : mTexFormat(texFormat), mSRVFormat(srvFormat), mRTVFormat(rtvFormat)
{
}

const SwizzleFormatInfo &GetSwizzleFormatInfo(GLuint maxBits, GLenum componentType)
{
    // clang-format off
    switch (componentType)
    {
        case GL_FLOAT:
        {
            switch (maxBits)
            {
                case 16:
                {
                    static const SwizzleFormatInfo formatInfo(DXGI_FORMAT_R16G16B16A16_FLOAT,
                                                              DXGI_FORMAT_R16G16B16A16_FLOAT,
                                                              DXGI_FORMAT_R16G16B16A16_FLOAT);
                    return formatInfo;
                }
                case 32:
                {
                    static const SwizzleFormatInfo formatInfo(DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                              DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                              DXGI_FORMAT_R32G32B32A32_FLOAT);
                    return formatInfo;
                }
                default:
                    break;
            }
        }
        case GL_INT:
        {
            switch (maxBits)
            {
                case 16:
                {
                    static const SwizzleFormatInfo formatInfo(DXGI_FORMAT_R16G16B16A16_SINT,
                                                              DXGI_FORMAT_R16G16B16A16_SINT,
                                                              DXGI_FORMAT_R16G16B16A16_SINT);
                    return formatInfo;
                }
                case 32:
                {
                    static const SwizzleFormatInfo formatInfo(DXGI_FORMAT_R32G32B32A32_SINT,
                                                              DXGI_FORMAT_R32G32B32A32_SINT,
                                                              DXGI_FORMAT_R32G32B32A32_SINT);
                    return formatInfo;
                }
                case 8:
                {
                    static const SwizzleFormatInfo formatInfo(DXGI_FORMAT_R8G8B8A8_SINT,
                                                              DXGI_FORMAT_R8G8B8A8_SINT,
                                                              DXGI_FORMAT_R8G8B8A8_SINT);
                    return formatInfo;
                }
                default:
                    break;
            }
        }
        case GL_SIGNED_NORMALIZED:
        {
            switch (maxBits)
            {
                case 8:
                {
                    static const SwizzleFormatInfo formatInfo(DXGI_FORMAT_R8G8B8A8_SNORM,
                                                              DXGI_FORMAT_R8G8B8A8_SNORM,
                                                              DXGI_FORMAT_R8G8B8A8_SNORM);
                    return formatInfo;
                }
                default:
                    break;
            }
        }
        case GL_UNSIGNED_INT:
        {
            switch (maxBits)
            {
                case 16:
                {
                    static const SwizzleFormatInfo formatInfo(DXGI_FORMAT_R16G16B16A16_UINT,
                                                              DXGI_FORMAT_R16G16B16A16_UINT,
                                                              DXGI_FORMAT_R16G16B16A16_UINT);
                    return formatInfo;
                }
                case 32:
                {
                    static const SwizzleFormatInfo formatInfo(DXGI_FORMAT_R32G32B32A32_UINT,
                                                              DXGI_FORMAT_R32G32B32A32_UINT,
                                                              DXGI_FORMAT_R32G32B32A32_UINT);
                    return formatInfo;
                }
                case 8:
                {
                    static const SwizzleFormatInfo formatInfo(DXGI_FORMAT_R8G8B8A8_UINT,
                                                              DXGI_FORMAT_R8G8B8A8_UINT,
                                                              DXGI_FORMAT_R8G8B8A8_UINT);
                    return formatInfo;
                }
                default:
                    break;
            }
        }
        case GL_UNSIGNED_NORMALIZED:
        {
            switch (maxBits)
            {
                case 16:
                {
                    static const SwizzleFormatInfo formatInfo(DXGI_FORMAT_R16G16B16A16_UNORM,
                                                              DXGI_FORMAT_R16G16B16A16_UNORM,
                                                              DXGI_FORMAT_R16G16B16A16_UNORM);
                    return formatInfo;
                }
                case 24:
                {
                    static const SwizzleFormatInfo formatInfo(DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                              DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                              DXGI_FORMAT_R32G32B32A32_FLOAT);
                    return formatInfo;
                }
                case 32:
                {
                    static const SwizzleFormatInfo formatInfo(DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                              DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                              DXGI_FORMAT_R32G32B32A32_FLOAT);
                    return formatInfo;
                }
                case 8:
                {
                    static const SwizzleFormatInfo formatInfo(DXGI_FORMAT_R8G8B8A8_UNORM,
                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                              DXGI_FORMAT_R8G8B8A8_UNORM);
                    return formatInfo;
                }
                default:
                    break;
            }
        }

        default:
        {
            static const SwizzleFormatInfo defaultInfo(DXGI_FORMAT_UNKNOWN,
                                                       DXGI_FORMAT_UNKNOWN,
                                                       DXGI_FORMAT_UNKNOWN);
            return defaultInfo;
        }
    }
    // clang-format on

}  // GetSwizzleFormatInfo

}  // namespace d3d11

}  // namespace rx
