// Copyright (c) 2006-2008 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef BASE_CPU_H_
#define BASE_CPU_H_

#include <string>

namespace base {

// Query information about the processor.
class CPU {
 public:
  // Constructor
  CPU();

  // Accessors for CPU information.
  const std::string& vendor_name() const { return cpu_vendor_; }
  int stepping() const { return stepping_; }
  int model() const { return model_; }
  int family() const { return family_; }
  int type() const { return type_; }
  int extended_model() const { return ext_model_; }
  int extended_family() const { return ext_family_; }

 private:
  // Query the processor for CPUID information.
  void Initialize();

  int type_;  // process type
  int family_;  // family of the processor
  int model_;  // model of processor
  int stepping_;  // processor revision number
  int ext_model_;
  int ext_family_;
  std::string cpu_vendor_;
};

}  // namespace base

#endif  // BASE_CPU_H_
