#!/bin/sh
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

# clean-config.sh - Removes all files generated by mozilla configure.
#    Only removes files from the topsrcdir. To clean up an objdir,
#    simply remove the directory and start over.
#
# Usage:
#    1. cd <topsrcdir>
#    2. build/autoconf/clean-config.sh
#
# Send comments, improvements, bugs to slamm@netscape.com

topsrcdir=`cd \`dirname $0\`/../..; pwd`

if [ ! -f configure.in ]; then
  echo "clean-config.sh only cleans the source tree. To run," 2>&1
  echo "  cd $topsrcdir; build/autoconf/clean-config.sh" 2>&1
  echo "  (To clean a separate objdir, simple remove the directory.)" 2>&1
  exit 1
fi

rm -fr \
    config-defs.h \
    config.cache \
    config.log \
    config.status \
    $NULL
