/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*****************************************************************************/
/* This is an automatically generated file. If you're not                    */
/* nsSiteSecurityService.cpp, you shouldn't be #including it.     */
/*****************************************************************************/

#include <stdint.h>
const PRTime gPreloadListExpirationTime = INT64_C(1475323172363000);

class nsSTSPreload
{
  public:
    const char *mHost;
    const bool mIncludeSubdomains;
};

static const nsSTSPreload kSTSPreloadList[] = {
  { "0.me.uk", true },
  { "007sascha.de", true },
  { "01electronica.com.ar", true },
  { "050media.nl", true },
  { "0513c.com", true },
  { "0au.de", true },
  { "0knowledge.de", true },
  { "0paste.com", true },
  { "0x.cx", true },
  { "0x.sk", true },
  { "0x0a.net", true },
  { "0x1337.eu", true },
  { "0x44.net", true },
  { "0x52.net", true },
  { "0x90.fi", true },
  { "0x90.io", true },
  { "0xa.in", true },
  { "0xee.eu", true },
  { "0xf00.ch", true },
  { "0xfc.de", true },
  { "0xn.de", true },
  { "1000minds.com", true },
  { "1001.best", true },
  { "1011100.com", true },
  { "1017scribes.com", true },
  { "1022996493.rsc.cdn77.org", true },
  { "10hz.de", true },
  { "123test.fr", true },
  { "126ium.moe", true },
  { "12vpn.org", true },
  { "1464424382.rsc.cdn77.org", true },
  { "14it.de", true },
  { "1750studios.com", true },
  { "17hats.com", true },
  { "188trafalgar.ca", true },
  { "18f.gov", true },
  { "1972969867.rsc.cdn77.org", true },
  { "1a-diamantscheiben.de", true },
  { "1a-jva.de", true },
  { "1a-vermessung.at", true },
  { "1a-werkstattgeraete.de", true },
  { "1co-jp.net", true },
  { "1cover.com", true },
  { "1cover.com.au", true },
  { "1hourproofreading.com", true },
  { "1km.ro", true },
  { "1p.ro", true },
  { "1q365a.com", true },
  { "1st-community.de", true },
  { "1stcapital.com.sg", true },
  { "1whw.co.uk", true },
  { "1xcess.com", true },
  { "2048game.co.uk", true },
  { "21.co.uk", true },
  { "247healthshop.com", true },
  { "24ip.com", true },
  { "24ip.de", true },
  { "24ip.fr", true },
  { "25daysof.io", true },
  { "2600hq.com", true },
  { "28spots.net", true },
  { "2bas.nl", true },
  { "2bis10.de", true },
  { "2brokegirls.org", true },
  { "2carpros.com", false },
  { "2gen.com", true },
  { "2kgwf.fi", true },
  { "2nains.ch", true },
  { "2nerds1bit.com", true },
  { "2or3.tk", true },
  { "2programmers.net", true },
  { "2ulcceria.nl", true },
  { "300m.com", true },
  { "301.website", true },
  { "314chan.org", true },
  { "321live.nl", true },
  { "33-km.ru", true },
  { "33drugstore.com", true },
  { "3473-wiki.de", true },
  { "35792.de", true },
  { "360gradus.com", true },
  { "365.or.jp", false },
  { "365beautyworld.com", true },
  { "365healthworld.com", true },
  { "368mibn.com", true },
  { "3chit.cf", true },
  { "3do3dont.com", true },
  { "3r.org.uk", true },
  { "3s-hosting.de", true },
  { "3timegear.com", true },
  { "403.ch", true },
  { "404.sh", true },
  { "42ms.org", true },
  { "4500.co.il", true },
  { "4679.space", false },
  { "4d2.xyz", true },
  { "4eyes.ch", true },
  { "4g-server.eu", false },
  { "4loc.us", true },
  { "4mm.org", true },
  { "4ourty2.org", true },
  { "4project.co.il", true },
  { "4sqsu.eu", true },
  { "4w-performers.link", false },
  { "4winds.pt", true },
  { "4x.fi", true },
  { "50plusnet.nl", true },
  { "57aromas.com", true },
  { "5apps.com", true },
  { "60ych.net", true },
  { "6120.eu", true },
  { "646.io", true },
  { "6660111.ru", true },
  { "692b8c32.de", true },
  { "6969.us", true },
  { "69square.com", true },
  { "700.az", true },
  { "7183.org", true },
  { "777coin.com", true },
  { "7kovrikov.ru", true },
  { "7sons.de", true },
  { "7thheavenrestaurant.com", true },
  { "83i.net", true },
  { "888azino.com", true },
  { "888sport.dk", true },
  { "888sport.it", true },
  { "8ack.de", true },
  { "8t8.eu", true },
  { "8thportsmouth.org.uk", true },
  { "911911.pw", true },
  { "91tianmi.com", false },
  { "92url.com", true },
  { "960news.ca", true },
  { "99511.fi", true },
  { "9point6.com", true },
  { "9vx.org", true },
  { "a-plus.space", true },
  { "a2nutrition.com.au", true },
  { "aa-tour.ru", true },
  { "aaeblog.com", true },
  { "aaeblog.org", true },
  { "aanmpc.com", true },
  { "aaoo.net", true },
  { "aapas.org.ar", true },
  { "aapp.space", true },
  { "aaron-gustafson.com", true },
  { "aaronkimmig.de", true },
  { "aaronsilber.me", true },
  { "aatf.us", true },
  { "aati.info", true },
  { "abacustech.co.jp", true },
  { "abareplace.com", true },
  { "abc.li", true },
  { "abcheck.se", true },
  { "abeestrada.com", true },
  { "aberdeenjudo.co.uk", true },
  { "abeus.com", true },
  { "abiapp.net", true },
  { "abilitylist.org", true },
  { "abilitynet.org.uk", true },
  { "abilymp06.net", true },
  { "abioniere.de", true },
  { "abiturma.de", true },
  { "abmahnhelfer.de", false },
  { "abmgood.com", true },
  { "abou.to", false },
  { "about.ge", true },
  { "aboutmyip.info", true },
  { "aboutmyproperty.ca", true },
  { "abrilect.com", true },
  { "abseits.org", true },
  { "absynthe-inquisition.fr", true },
  { "abthorpe.org", true },
  { "abtom.de", true },
  { "abury.fr", true },
  { "abury.me", true },
  { "ac-town.com", true },
  { "acabadosboston.com", true },
  { "accelerole.com", true },
  { "access-sofia.org", true },
  { "accessacademies.org", true },
  { "accounts-p.com", true },
  { "accounts.firefox.com", true },
  { "accounts.google.com", true },
  { "accuenergy.com", true },
  { "acheconcursos.com.br", true },
  { "achenar.net", true },
  { "acheritage.co.uk", true },
  { "achromatisch.de", true },
  { "acisonline.net", true },
  { "aclu.org", false },
  { "acnpacific.com", true },
  { "acorns.com", true },
  { "acr.im", true },
  { "acritelli.com", true },
  { "acrylicwifi.com", true },
  { "acsemb.org", true },
  { "acslimited.co.uk", true },
  { "activatemyiphone.com", true },
  { "activateplay.com", true },
  { "active.hu", false },
  { "actorsroom.com", true },
  { "actserv.co.ke", true },
  { "acuica.co.uk", false },
  { "acus.gov", true },
  { "ad-notam.pt", true },
  { "adam-kostecki.de", true },
  { "adambyers.com", true },
  { "adamgold.net", true },
  { "adamkaminski.com", true },
  { "adamkostecki.de", true },
  { "adamoutler.com", true },
  { "adamradocz.com", true },
  { "adamricheimer.com", true },
  { "adams.dk", true },
  { "adams.net", true },
  { "adamstas.com", true },
  { "adaptivemechanics.edu.au", true },
  { "adastra.re", true },
  { "adayinthelifeof.nl", true },
  { "adblock.ovh", true },
  { "adblockextreme.com", true },
  { "adblockextreme.org", true },
  { "addaxpetroleum.com", true },
  { "adderall.space", true },
  { "addstar.jp", true },
  { "adduono.com", true },
  { "addvocate.com", true },
  { "adec-emsa.ae", true },
  { "adelaides.com", true },
  { "adelevie.com", true },
  { "aderal.io", true },
  { "adevel.eu", true },
  { "adigitali.biz", true },
  { "adimaja.com", true },
  { "adiponectinsupplement.info", true },
  { "adiponectinsupplement.net", true },
  { "adjagu.org", true },
  { "adlershop.ch", true },
  { "adme.co.il", true },
  { "admin.fedoraproject.org", true },
  { "admin.google.com", true },
  { "admin.stg.fedoraproject.org", true },
  { "admitcard.co.in", true },
  { "admsel.ec", true },
  { "adoal.net", true },
  { "adopteunsiteflash.com", true },
  { "adorai.tk", true },
  { "adquisitio.co.uk", true },
  { "adquisitio.de", true },
  { "adquisitio.es", true },
  { "adquisitio.fr", true },
  { "adquisitio.in", true },
  { "adquisitio.it", true },
  { "adrenaline-gaming.ru", false },
  { "adrianajewelry.my", true },
  { "adrl.ca", true },
  { "adsfund.org", true },
  { "aduvi.de", true },
  { "advanced-online.eu", true },
  { "advancedseotool.it", true },
  { "advancis.net", true },
  { "advelty.cz", true },
  { "adventistdeploy.org", true },
  { "adventureforest.de", false },
  { "adver.top", true },
  { "adzuna.ca", true },
  { "adzuna.co.uk", true },
  { "adzuna.co.za", true },
  { "adzuna.com.au", true },
  { "adzuna.com.br", true },
  { "adzuna.de", true },
  { "adzuna.fr", true },
  { "adzuna.in", true },
  { "adzuna.nl", true },
  { "adzuna.pl", true },
  { "adzuna.ru", true },
  { "aegee-utrecht.nl", true },
  { "aeon.co", false },
  { "aerolog.co", true },
  { "aes256.ru", true },
  { "aeyoun.com", true },
  { "afb24.de", true },
  { "affiliateroyale.com", true },
  { "affilie.de", true },
  { "affinitysync.com", true },
  { "affordableazdivorce.com", true },
  { "aficotroceni.ro", true },
  { "afp548.com", true },
  { "africatravel.de", true },
  { "afrodigital.uk", true },
  { "afuh.de", true },
  { "afvallendoeje.nu", true },
  { "agalaxyfarfaraway.co.uk", true },
  { "ageg.ca", true },
  { "agenda-loto.net", true },
  { "agevio.com", true },
  { "agilebits.net", false },
  { "agonswim.com", true },
  { "agowa338.de", true },
  { "agroline.by", true },
  { "agwa.name", true },
  { "ahd.com", true },
  { "ahero4all.org", true },
  { "ahmad.works", false },
  { "ahmerjamilkhan.org", true },
  { "ahoyconference.com", true },
  { "ahri.ovh", true },
  { "ahwatukeefoothillsmontessori.com", true },
  { "ahxxm.com", true },
  { "aia.de", true },
  { "aids.gov", true },
  { "aie.de", true },
  { "aiesecarad.ro", true },
  { "aikido-linz.at", true },
  { "aikido-wels.at", true },
  { "airbly.com", true },
  { "airlea.com", true },
  { "airlinecheckins.com", true },
  { "airsoft.ch", true },
  { "aishnair.com", true },
  { "aisle3.space", true },
  { "aiticon.com", true },
  { "aivd.lol", true },
  { "aiwdirect.com", true },
  { "ajouin.com", true },
  { "akachanikuji.com", true },
  { "akaoma.com", false },
  { "akelius.de", true },
  { "akerek.hu", true },
  { "akhilindurti.com", false },
  { "akhras.at", true },
  { "akombakom.net", true },
  { "akostecki.de", true },
  { "akoww.de", true },
  { "akropolis-ravensburg.de", true },
  { "akselinurmio.fi", true },
  { "akstudentsfirst.org", true },
  { "aktiv-naturheilmittel.at", true },
  { "aktiv-naturheilmittel.ch", true },
  { "aktiv-naturheilmittel.de", true },
  { "aktivist.in", true },
  { "aladdin.ie", true },
  { "aladdinschools.appspot.com", true },
  { "alainwolf.ch", true },
  { "alainwolf.net", true },
  { "alair.cn", true },
  { "alaninkenya.org", true },
  { "alanlee.net", true },
  { "alanrickmanflipstable.com", true },
  { "alaricfavier.eu", true },
  { "alariel.de", true },
  { "alasta.info", true },
  { "alastyr.com", false },
  { "albertbogdanowicz.pl", true },
  { "albion2.org", true },
  { "alcazaar.com", true },
  { "aldes.co.za", true },
  { "aleax.me", true },
  { "alecpap.com", true },
  { "aleksib.fi", true },
  { "alela.fr", true },
  { "alertwire.com", true },
  { "alex-ross.co.uk", true },
  { "alexandra-schulze.de", true },
  { "alexandre.sh", true },
  { "alexbaker.org", true },
  { "alexei.su", true },
  { "alexgaynor.net", true },
  { "alexhaydock.co.uk", true },
  { "alexhd.de", true },
  { "alexisabarca.com", true },
  { "alexismeza.com", true },
  { "alexmerkel.com", true },
  { "alexmerkel.me", true },
  { "alexmerkel.xyz", true },
  { "alexn.org", true },
  { "alexsergeyev.com", true },
  { "alexsexton.com", true },
  { "alexvetter.de", true },
  { "alexwardweb.com", true },
  { "alexyang.me", true },
  { "alienstat.com", true },
  { "alittlebitcheeky.com", false },
  { "alkami.com", true },
  { "alkamitech.com", true },
  { "all.tf", false },
  { "all4os.com", true },
  { "allbenjoy.de", true },
  { "allcarepharmacy.com", true },
  { "allforyou.at", true },
  { "alliedfrozenstorage.com", true },
  { "allinnote.com", true },
  { "allmbw.com", true },
  { "alltheducks.com", true },
  { "allthethings.co.nz", true },
  { "allthingssquared.com", true },
  { "allthingswild.co.uk", true },
  { "almeria-si.fr", true },
  { "almeria.fr", true },
  { "alnitech.com", true },
  { "alocato.com", true },
  { "alpca.org", true },
  { "alpencam.com", true },
  { "alpencams.com", true },
  { "alpha-force.net", true },
  { "alphabuild.io", true },
  { "alphalabs.xyz", true },
  { "alphassl.de", true },
  { "alphatrash.de", true },
  { "alt-three.com", true },
  { "alt.org", true },
  { "altedirect.com", true },
  { "alterbaum.net", true },
  { "altesses.eu", true },
  { "altestore.com", true },
  { "altfire.ca", true },
  { "altonblom.com", true },
  { "altopia.com", true },
  { "aluroof.eu", true },
  { "alza.cz", true },
  { "alza.de", true },
  { "alza.sk", true },
  { "alzashop.com", true },
  { "am3.se", true },
  { "ama.ne.jp", true },
  { "amaforums.org", true },
  { "amateri.com", true },
  { "amavis.org", true },
  { "amazing-gaming.fr", true },
  { "ambiente.one", true },
  { "ambiq.nl", true },
  { "amcvega.com", true },
  { "amdouglas.com", true },
  { "amdouglas.uk", true },
  { "amees.me", true },
  { "american-truck-simulator.de", true },
  { "americanbio.com", true },
  { "americanworkwear.nl", true },
  { "americkykongres.cz", true },
  { "amerigroup.com", true },
  { "amerimarkdirect.com", true },
  { "amerimex.cc", true },
  { "amihub.com", true },
  { "amilx.com", true },
  { "amilx.org", true },
  { "amisharingstuff.com", true },
  { "amishsecurity.com", true },
  { "amitube.com", true },
  { "amnesy.fr", true },
  { "amoory.com", false },
  { "amv-crm.ru", true },
  { "anadoluefessk.org", true },
  { "anadoluefessporkulubu.org", true },
  { "anagra.ms", true },
  { "analytic-s.ml", true },
  { "ananke.io", true },
  { "anarka.org", true },
  { "anassiriphotography.com", false },
  { "anastasiafond.com", true },
  { "and-stuff.nl", true },
  { "and.com", true },
  { "anderslind.dk", true },
  { "andisadhdspot.com", true },
  { "andre-ballensiefen.de", true },
  { "andreaboero.it", true },
  { "andreas-kluge.eu", true },
  { "andreasfeusi.ch", true },
  { "andreaskluge.eu", true },
  { "andreasolsson.se", true },
  { "andreastoneman.com", true },
  { "andreigec.net", true },
  { "andrepicard.de", true },
  { "andrewbroekman.com", true },
  { "andrewhowden.com", true },
  { "andrewimeson.com", true },
  { "andrewmichaud.beer", true },
  { "andrewmichaud.com", true },
  { "andrewmichaud.me", true },
  { "andrewsun.com", true },
  { "andrewtebert.com", true },
  { "andrewthelott.net", true },
  { "andrewvoce.com", true },
  { "andrewx.net", true },
  { "andreypopp.com", true },
  { "andsat.org", true },
  { "anduril.de", true },
  { "anduril.eu", true },
  { "andyuk.org", true },
  { "anedot.com", true },
  { "anedot.xyz", true },
  { "anetaben.nl", true },
  { "anfsanchezo.me", true },
  { "anglictinatabor.cz", true },
  { "angrapa.ru", true },
  { "angristan.fr", true },
  { "angularjs.org", true },
  { "animalnet.de", false },
  { "anime.my", false },
  { "animesfusion.com.br", true },
  { "animesharp.com", true },
  { "aniplus.cf", true },
  { "aniplus.gq", true },
  { "aniplus.ml", true },
  { "anitaalbersen.nl", true },
  { "anitube-nocookie.ch", true },
  { "anitube.ch", true },
  { "ankakaak.com", true },
  { "ankarakart.com.tr", true },
  { "ankaraprofesyonelwebtasarim.com", true },
  { "ankarauzmanlarnakliyat.com", true },
  { "annahmeschluss.de", true },
  { "annarokina.com", true },
  { "annetta.com", true },
  { "annevankesteren.com", true },
  { "annevankesteren.nl", true },
  { "annevankesteren.org", true },
  { "annuaire-photographe.fr", true },
  { "anonboards.com", true },
  { "anoncom.net", true },
  { "anoneko.com", true },
  { "anonukradio.org", true },
  { "anonym-surfen.de", true },
  { "anonyme-spieler.at", true },
  { "anonymousstatecollegelulzsec.com", true },
  { "anook.com", true },
  { "another.ch", true },
  { "ansdell.info", true },
  { "ansdell.net", true },
  { "antarcti.co", true },
  { "anthenor.co.uk", true },
  { "antipolygraph.org", true },
  { "antocom.com", true },
  { "antoine-roux.fr", true },
  { "antoniomarques.eu", true },
  { "antons.io", true },
  { "anyprime.net", true },
  { "anyways.at", true },
  { "anzeiger.ag", true },
  { "ao-dev.com", true },
  { "ao2.it", true },
  { "aojf.fr", true },
  { "aopedeure.nl", true },
  { "aosus.org", true },
  { "apachehaus.de", false },
  { "apadvantage.com", true },
  { "apeasternpower.com", true },
  { "aperturesciencelabs.de", true },
  { "apervita.net", true },
  { "apexitsolutions.ca", true },
  { "api-geek.com", true },
  { "api.cloudflare.com", false },
  { "api.intercom.io", true },
  { "api.lookout.com", false },
  { "api.simple.com", false },
  { "api.xero.com", false },
  { "apis.google.com", true },
  { "apmg-certified.com", true },
  { "apmg-cyber.com", true },
  { "apn-einstellungen.de", true },
  { "apnakliyat.com", true },
  { "apolloyl.com", true },
  { "aponow.de", true },
  { "aposke.com", true },
  { "app-arena.com", true },
  { "app.lookout.com", false },
  { "app.manilla.com", true },
  { "app.recurly.com", true },
  { "app.simpletax.ca", false },
  { "app.yinxiang.com", false },
  { "appart.ninja", true },
  { "appartementhaus-badria.de", true },
  { "appchive.net", true },
  { "appdrinks.com", true },
  { "appengine.google.com", true },
  { "appharbor.com", true },
  { "apple-watch-zubehoer.de", true },
  { "appleoosa.com", true },
  { "applez.xyz", true },
  { "applic8.com", true },
  { "appmobile.io", true },
  { "appointed.at", true },
  { "appreciationkards.com", true },
  { "approbo.com", true },
  { "apps-for-fishing.com", true },
  { "apps.facebook.com", false },
  { "apps.fedoraproject.org", true },
  { "apps.stg.fedoraproject.org", true },
  { "appsdash.io", true },
  { "appson.co.uk", true },
  { "appuro.com", true },
  { "aprovpn.com", true },
  { "aprsdroid.org", true },
  { "aprz.de", true },
  { "apstudynotes.org", true },
  { "aquapoint.kiev.ua", true },
  { "aquilaguild.com", true },
  { "aradulconteaza.ro", true },
  { "aramido.de", true },
  { "aranycsillag.net", true },
  { "arawaza.com", true },
  { "arbeitskreis-asyl-eningen.de", true },
  { "arbitrary.ch", true },
  { "arboworks.com", true },
  { "archlinux.de", true },
  { "arctic.gov", true },
  { "ardtrade.ru", true },
  { "areafiftylan.nl", true },
  { "areatrend.com", true },
  { "arendburgers.nl", true },
  { "argh.io", true },
  { "arguggi.co.uk", true },
  { "arima.co.ke", true },
  { "aristocrates.co", true },
  { "arivo.com.br", false },
  { "arjandejong.eu", true },
  { "arksan.com.tr", true },
  { "arlen.io", true },
  { "arlen.se", true },
  { "armingrodon.de", true },
  { "armor.com", true },
  { "armory.consulting", true },
  { "armory.supplies", false },
  { "arnaudfeld.de", true },
  { "arnesolutions.com", true },
  { "arnor.org", true },
  { "aroonchande.com", true },
  { "arpa.ph", true },
  { "arrive.by", true },
  { "arrmaforum.com", true },
  { "arrowgrove.com", true },
  { "ars.toscana.it", true },
  { "art2web.net", true },
  { "artegusto.ru", true },
  { "arteseideias.com.pt", true },
  { "artetrama.com", true },
  { "articaexports.com", true },
  { "artifex21.com", true },
  { "artifex21.fr", true },
  { "artisanhd.com", true },
  { "artistnetwork.nl", true },
  { "artmoney.com", true },
  { "artofwhere.com", true },
  { "artspac.es", true },
  { "arturkohut.com", true },
  { "arty.name", true },
  { "arubasunsetbeach.com", true },
  { "arvamus.eu", true },
  { "arvid.io", true },
  { "arw.me", true },
  { "aryasenna.net", true },
  { "arzaroth.com", false },
  { "arzid.com", true },
  { "as.se", true },
  { "as200753.com", true },
  { "as200753.net", true },
  { "as9178.net", true },
  { "asandu.eu", true },
  { "asasuou.pw", true },
  { "ascamso.com", true },
  { "ascii.moe", true },
  { "asciitable.tips", true },
  { "aserver.co", true },
  { "ashutoshmishra.org", true },
  { "asianodor.com", true },
  { "ask.fedoraproject.org", true },
  { "ask.stg.fedoraproject.org", true },
  { "askfit.cz", true },
  { "askmagicconch.com", true },
  { "askwhy.cz", true },
  { "askwhy.eu", true },
  { "asm-x.com", true },
  { "asmui.ml", true },
  { "aspargesgaarden.no", true },
  { "aspires.co.jp", true },
  { "asr.li", true },
  { "asr.rocks", true },
  { "ass.org.au", true },
  { "assdecoeur.org", true },
  { "assekuranzjobs.de", true },
  { "astengox.com", true },
  { "astrolpost.com", true },
  { "astromelody.com", true },
  { "asun.co", true },
  { "asurepay.cc", true },
  { "at.search.yahoo.com", false },
  { "atavio.de", true },
  { "atbeckett.com", true },
  { "atc.io", true },
  { "atchleyjazz.com", true },
  { "atchleyjazz.org", true },
  { "atchleylab.org", true },
  { "ateli.com", true },
  { "atg.soy", true },
  { "atgseed.co.uk", true },
  { "atgseed.uk", true },
  { "ath0.org", true },
  { "athenelive.com", true },
  { "athensbusinessresources.us", true },
  { "athul.xyz", true },
  { "atishchenko.com", true },
  { "atisoft.biz", true },
  { "atisoft.com.tr", true },
  { "atisoft.net", true },
  { "atisoft.net.tr", true },
  { "atisoft.web.tr", true },
  { "atlantichomes.com.au", true },
  { "atlantischild.hu", true },
  { "atlassian.net", true },
  { "atletika.hu", true },
  { "atnis.com", true },
  { "atolm.net", true },
  { "atop.io", true },
  { "atrinik.org", true },
  { "atte.fi", true },
  { "attorney.org.il", true },
  { "aubiosales.com", true },
  { "aucubin.moe", false },
  { "audiovisualdevices.com.au", true },
  { "audisto.com", true },
  { "auditmatrix.com", true },
  { "auf-feindgebiet.de", true },
  { "aufmerksamkeitsstudie.com", true },
  { "augaware.org", true },
  { "augias.org", true },
  { "augiero.it", true },
  { "augustian-life.cz", true },
  { "augustiner-kantorei-erfurt.de", true },
  { "augustiner-kantorei.de", true },
  { "aujapan.ru", true },
  { "aukaraoke.su", true },
  { "aulo.in", false },
  { "aunali1.com", true },
  { "aurainfosec.com", true },
  { "aurainfosec.com.au", true },
  { "auraredeye.com", true },
  { "auraredshield.com", true },
  { "ausnah.me", true },
  { "ausschreibungen-suedtirol.it", true },
  { "aussiecable.org", true },
  { "aussiehq.com.au", true },
  { "auth.adult", true },
  { "authentication.io", true },
  { "authint.com", true },
  { "authoritynutrition.com", true },
  { "auto-anleitung.de", true },
  { "auto-serwis.zgorzelec.pl", true },
  { "autodeploy.it", true },
  { "autojuhos.sk", true },
  { "autokovrik-diskont.ru", true },
  { "autoledky.sk", true },
  { "automacity.com", true },
  { "autotsum.com", true },
  { "autumnwindsagility.com", true },
  { "ava-creative.de", true },
  { "avacariu.me", true },
  { "avalon-island.ru", true },
  { "avantmfg.com", true },
  { "avarty.com", true },
  { "avastantivirus.ro", true },
  { "avenueeyecare.com", true },
  { "avg.club", true },
  { "aviacao.pt", true },
  { "avinet.com", false },
  { "avmemo.com", true },
  { "avmo.pw", true },
  { "avmoo.com", true },
  { "avso.pw", true },
  { "avsox.com", true },
  { "avtovokzaly.ru", true },
  { "avxo.pw", true },
  { "awanderlustadventure.com", true },
  { "aww.moe", true },
  { "awxg.com", true },
  { "axka.com", false },
  { "axrec.de", true },
  { "aylak.com", true },
  { "ayurveda101.com", true },
  { "azabani.com", true },
  { "azazy.net", true },
  { "azimut.fr", true },
  { "azino777.ru", true },
  { "azirevpn.com", true },
  { "aztrix.me", true },
  { "azzag.co.uk", true },
  { "azzorti.com", true },
  { "b-root-force.de", true },
  { "b2and.com", false },
  { "b303.me", true },
  { "b64.club", true },
  { "baalsworld.de", true },
  { "babacasino.net", true },
  { "babarkata.com", true },
  { "babelfisch.eu", true },
  { "baby-click.de", true },
  { "babybee.ie", true },
  { "babyfotograf-schweiz.ch", true },
  { "babysaying.me", true },
  { "babystep.tv", true },
  { "bacchanallia.com", true },
  { "backeby.eu", true },
  { "backmountaingas.com", true },
  { "backscattering.de", true },
  { "backschues.net", true },
  { "bacontreeconsulting.com", true },
  { "bacula.jp", true },
  { "bad.horse", true },
  { "badbee.cc", true },
  { "badcronjob.com", true },
  { "badges.fedoraproject.org", true },
  { "badges.stg.fedoraproject.org", true },
  { "badhusky.com", true },
  { "badkamergigant.com", true },
  { "badlink.org", true },
  { "badoo.com", true },
  { "baer.im", true },
  { "baer.one", true },
  { "baffinlee.com", true },
  { "bagelsbakery.com", false },
  { "bah.im", false },
  { "baiker.info", true },
  { "baiyangliu.com", true },
  { "bajic.ch", true },
  { "bakabt.info", true },
  { "bakaweb.fr", true },
  { "balboa.io", true },
  { "balcan-underground.net", true },
  { "balikonos.cz", true },
  { "baliyano.com", true },
  { "balkonien.org", true },
  { "ball.holdings", true },
  { "ballmerpeak.org", true },
  { "ballotapi.com", true },
  { "bananabandy.com", true },
  { "bananium.fr", true },
  { "bancoctt.pt", true },
  { "bandb.xyz", true },
  { "bandrcrafts.com", true },
  { "bank.simple.com", false },
  { "bankcardoffer.com", true },
  { "bankersonline.com", true },
  { "bankin.com", true },
  { "bankofdenton.com", true },
  { "banqingdiao.com", true },
  { "baofengtech.com", true },
  { "barbaros.info", true },
  { "barbate.fr", true },
  { "barbu.family", true },
  { "barcodeberlin.com", true },
  { "barcoderealty.com", true },
  { "bardiharborow.com", true },
  { "barisi.me", true },
  { "barqo.co", true },
  { "barrelhead.org", true },
  { "barrett.ag", true },
  { "barrut.me", false },
  { "barslecht.com", true },
  { "barslecht.nl", true },
  { "bartel.ws", true },
  { "bartlamboo.nl", true },
  { "baruch.me", true },
  { "barunisystems.com", true },
  { "bashc.at", true },
  { "bashcode.ninja", true },
  { "baskettemple.com", true },
  { "basnieuwenhuizen.nl", true },
  { "basnoslovno.com.ua", true },
  { "basnoslovno.ru", true },
  { "bassh.net", false },
  { "bastianstalder.ch", true },
  { "baud.ninja", true },
  { "bautied.de", true },
  { "bayden.com", true },
  { "bayrisch-fuer-anfaenger.de", true },
  { "bazdell.com", true },
  { "bbdos.ru", true },
  { "bblovess.cn", true },
  { "bbnx.net", true },
  { "bbuio.com", true },
  { "bc-bd.org", true },
  { "bcbsmagentprofile.com", true },
  { "bcchack.com", true },
  { "bccx.com", true },
  { "bcdonadio.com", true },
  { "bcheng.cf", true },
  { "bckp.de", true },
  { "bcmlu.org", true },
  { "bcrook.com", false },
  { "bcswampcabins.com", true },
  { "bcsytv.com", true },
  { "bcweightlifting.ca", true },
  { "bdikaros-network.net", true },
  { "beachi.es", true },
  { "beaglewatch.com", true },
  { "beamitapp.com", true },
  { "beanjuice.me", true },
  { "beans-one.com", false },
  { "beardydave.com", true },
  { "beastowner.li", true },
  { "beautykat.ru", true },
  { "bebef.de", true },
  { "bebesurdoue.com", true },
  { "bedabox.com", true },
  { "bedeta.de", true },
  { "bedreid.dk", true },
  { "beeksnetwork.nl", true },
  { "beepan.com", true },
  { "beercandle.com", true },
  { "beeznest.com", true },
  { "beframed.ch", true },
  { "befundonline.de", true },
  { "behere.be", true },
  { "behoerden-online-dienste.de", true },
  { "beholdthehurricane.com", true },
  { "beier.io", true },
  { "beikeil.de", true },
  { "beinad.com", true },
  { "beinad.ru", true },
  { "belcompany.nl", false },
  { "believablebook.com", true },
  { "belliash.eu.org", true },
  { "belltower.io", true },
  { "belly-button-piercings.com", true },
  { "bely-mishka.by", true },
  { "bemyvictim.com", true },
  { "ben-energy.com", false },
  { "ben.ninja", true },
  { "benchling.com", true },
  { "bendechrai.com", true },
  { "bendemaree.com", true },
  { "bendingtheending.com", true },
  { "bendix.co", true },
  { "beneathvt.com", true },
  { "beneffy.com", true },
  { "benhartmann.de", true },
  { "benjamin.pe", true },
  { "benjaminblack.net", true },
  { "benjamins.com", true },
  { "benk.press", true },
  { "benmatthews.com.au", true },
  { "benni1.eu", true },
  { "benno.frl", true },
  { "benny003.de", true },
  { "benschnarr.com", true },
  { "bentertain.de", true },
  { "bentley.link", true },
  { "bentrask.com", true },
  { "benzkosmetik.de", true },
  { "beourvictim.com", true },
  { "beranovi.com", true },
  { "berger.work", true },
  { "bergstoneware.com", false },
  { "berlatih.com", true },
  { "berlin-kohlefrei.de", true },
  { "berlinleaks.com", false },
  { "bermeitinger.eu", true },
  { "bermytraq.bm", true },
  { "berr.yt", true },
  { "berra.se", true },
  { "berrymark.be", true },
  { "berst.cz", true },
  { "berthabailey.com", true },
  { "beryl.net", true },
  { "bespokestraps.com", true },
  { "best-wedding-quotes.com", true },
  { "bestbeards.ca", true },
  { "bestbrakes.com", true },
  { "bestessayhelp.com", true },
  { "besthost.cz", true },
  { "bestlashesandbrows.com", true },
  { "bestorangeseo.com", true },
  { "betaclean.fr", true },
  { "betafive.net", true },
  { "betaworx.de", true },
  { "betaworx.eu", true },
  { "betcafearena.ro", false },
  { "betlander.com", true },
  { "betonmoney.com", true },
  { "betpamm.com", true },
  { "betplanning.it", true },
  { "bettercrypto.org", true },
  { "betterhelp.com", true },
  { "bettingbusiness.ru", true },
  { "bettrlifeapp.com", true },
  { "bettween.com", true },
  { "betulashop.ch", true },
  { "bevinco2020.com", true },
  { "bevinsco.org", true },
  { "bexit-hosting.nl", true },
  { "bexit-security.eu", true },
  { "bexit-security.nl", true },
  { "bexit.nl", true },
  { "bexithosting.nl", true },
  { "beyuna.co.uk", true },
  { "beyuna.eu", true },
  { "beyuna.nl", true },
  { "bf.am", false },
  { "bfear.com", true },
  { "bfelob.gov", true },
  { "bfi.wien", false },
  { "bfw-online.de", true },
  { "bgcparkstad.nl", true },
  { "bgdaddy.com", true },
  { "bgmn.net", true },
  { "bgneuesheim.de", true },
  { "bhatia.at", true },
  { "bhtelecom.ba", true },
  { "bhuntr.com", true },
  { "biasmath.es", true },
  { "biathloncup.ru", true },
  { "bible-maroc.com", true },
  { "bible.ru", true },
  { "bibleonline.ru", true },
  { "biblerhymes.com", true },
  { "biblionaut.net", true },
  { "biddl.com", true },
  { "bielsa.me", true },
  { "bienenblog.cc", true },
  { "bienici.com", true },
  { "bierbaumer.net", true },
  { "biergaizi.info", true },
  { "big-andy.co.uk", true },
  { "big-black.de", true },
  { "bigbluedoor.net", true },
  { "bigbrownpromotions.com.au", true },
  { "bigclassaction.com", true },
  { "bight.ca", true },
  { "biguixhe.net", true },
  { "bike-shack.com", true },
  { "bikermusic.net", true },
  { "bikiniseli.com", true },
  { "bildermachr.de", true },
  { "bildiri.ci", true },
  { "bildschirmflackern.de", true },
  { "billaud.eu.org", true },
  { "billiger-mietwagen.de", true },
  { "billigssl.dk", true },
  { "billin.net", true },
  { "billogram.com", true },
  { "billpro.com", true },
  { "billpro.com.au", true },
  { "bilrom.com", true },
  { "bimbo.com", true },
  { "bimbobakeriesusa.com", true },
  { "binaryevolved.com", true },
  { "binarystud.io", true },
  { "bingofriends.com", true },
  { "bingostars.com", true },
  { "biodieseldata.com", true },
  { "bioemsan.cz", true },
  { "biofam.ru", true },
  { "biolindo.com", true },
  { "bionicspirit.com", true },
  { "biosbits.org", true },
  { "bioshome.de", true },
  { "biosignalanalytics.com", true },
  { "biosphere.cc", true },
  { "biou.me", true },
  { "bip.gov.sa", true },
  { "birdfeeder.online", true },
  { "birminghamsunset.com", true },
  { "bit-sentinel.com", true },
  { "bit.voyage", true },
  { "bit8.com", true },
  { "bitbeans.de", true },
  { "bitbr.net", true },
  { "bitbucket.org", false },
  { "bitchan.it", true },
  { "bitcoin-india.org", true },
  { "bitcoin.asia", true },
  { "bitcoin.ch", true },
  { "bitcoin.co.nz", true },
  { "bitcoin.de", true },
  { "bitcoin.im", true },
  { "bitcoin.info", true },
  { "bitcoin.us", true },
  { "bitcoinbitcoin.com", true },
  { "bitcoincore.org", true },
  { "bitcoinhk.org", true },
  { "bitcoinprivacy.net", true },
  { "bitcoinworld.me", true },
  { "bitcoinx.ro", true },
  { "bitex.la", true },
  { "bitf.ly", true },
  { "bitfactory.ws", true },
  { "bitfehler.net", true },
  { "bitfinder.nl", true },
  { "bitfuse.net", true },
  { "bitgo.com", true },
  { "bitheus.com", true },
  { "bitlish.com", true },
  { "bitmex.com", true },
  { "bitminter.com", true },
  { "bitmoe.com", true },
  { "bitmon.net", true },
  { "bitnet.io", true },
  { "bitok.com", true },
  { "bitpod.de", true },
  { "bitref.com", true },
  { "bitshaker.net", true },
  { "bitskins.co", true },
  { "bittersweetcandybowl.com", true },
  { "biurokarier.edu.pl", true },
  { "bivsi.com", true },
  { "bizcms.com", true },
  { "bjornhelmersson.se", true },
  { "bjornjohansen.no", true },
  { "bl4ckb0x.com", true },
  { "bl4ckb0x.de", true },
  { "bl4ckb0x.eu", true },
  { "bl4ckb0x.info", true },
  { "bl4ckb0x.net", true },
  { "bl4ckb0x.org", true },
  { "blablacar.co.uk", true },
  { "blablacar.com", true },
  { "blablacar.com.tr", true },
  { "blablacar.com.ua", true },
  { "blablacar.de", true },
  { "blablacar.es", true },
  { "blablacar.fr", true },
  { "blablacar.hr", true },
  { "blablacar.hu", true },
  { "blablacar.in", true },
  { "blablacar.it", true },
  { "blablacar.mx", true },
  { "blablacar.nl", true },
  { "blablacar.pl", true },
  { "blablacar.pt", true },
  { "blablacar.ro", true },
  { "blablacar.rs", true },
  { "blablacar.ru", true },
  { "black-armada.com", true },
  { "black-armada.com.pl", true },
  { "black-armada.pl", true },
  { "blackberrycentral.com", true },
  { "blackburn.link", true },
  { "blackdesertsp.com", true },
  { "blackdragoninc.org", true },
  { "blackhelicopters.net", true },
  { "blackly.uk", true },
  { "blackpayment.ru", true },
  { "blaise.io", true },
  { "blancodent.com", true },
  { "blastersklan.com", true },
  { "blaudev.es", true },
  { "blauerhunger.de", true },
  { "blauwwit.be", true },
  { "blazor.nl", true },
  { "blechschmidt.saarland", true },
  { "blendle.com", true },
  { "blendle.nl", true },
  { "blessnet.jp", true },
  { "blha303.com.au", true },
  { "blieque.co.uk", true },
  { "blindsexdate.nl", true },
  { "blingsparkleshine.com", true },
  { "blinkenlight.co.uk", true },
  { "blinkenlight.com.au", true },
  { "blmiller.com", true },
  { "blockchain.info", true },
  { "blocksatz-medien.de", true },
  { "bloemendal.me", true },
  { "blog.cyveillance.com", true },
  { "blog.gov.uk", true },
  { "blog.gparent.org", true },
  { "blog.linode.com", false },
  { "blog.torproject.org", false },
  { "blogarts.net", true },
  { "blognone.com", true },
  { "blogreen.org", true },
  { "blubbablasen.de", true },
  { "blubberladen.de", true },
  { "blue-labs.org", true },
  { "blue-leaf81.net", true },
  { "blue42.net", true },
  { "bluechilli.com", true },
  { "blueflare.org", true },
  { "blueimp.net", true },
  { "bluemosh.com", true },
  { "blueperil.de", true },
  { "bluepoint.foundation", true },
  { "bluepoint.institute", true },
  { "bluescloud.xyz", true },
  { "blumenfeldart.com", true },
  { "blumiges-fischbachtal.de", true },
  { "blupig.net", true },
  { "blurringexistence.net", true },
  { "bluserv.net", true },
  { "blusmurf.net", true },
  { "blutroyal.de", true },
  { "bm-trading.nl", true },
  { "bmoattachments.org", true },
  { "bmone.net", true },
  { "bnhlibrary.com", true },
  { "bobancoamigo.com", true },
  { "bobcopeland.com", true },
  { "bockenauer.at", true },
  { "bodhi.fedoraproject.org", true },
  { "bodrumfarm.com", true },
  { "bodyblog.nl", true },
  { "boeddhashop.nl", true },
  { "boensou.com", true },
  { "boernecancerfonden.dk", true },
  { "bohramt.de", true },
  { "boilesen.com", true },
  { "boiseonlinemall.com", true },
  { "bokeyy.com", true },
  { "boltdata.io", true },
  { "bonapp.restaurant", true },
  { "bondskampeerder.nl", true },
  { "bonfi.net", true },
  { "bonifacius.be", true },
  { "bonobo.cz", true },
  { "boof.com", true },
  { "booked.holiday", true },
  { "bookingapp.nl", true },
  { "bookmein.in", true },
  { "bookofraonlinecasinos.com", true },
  { "boomersurf.com", true },
  { "bootjp.me", true },
  { "borchers-media.de", true },
  { "boringsecurity.net", true },
  { "boringsmith.com", true },
  { "boris.one", false },
  { "boris64.net", true },
  { "borisbesemer.com", true },
  { "borrelioz.com", true },
  { "borysek.net", true },
  { "botox.bz", true },
  { "bougeret.fr", true },
  { "bouncourseplanner.net", true },
  { "bouncyball.eu", true },
  { "bouncyballs.org", true },
  { "bourasse.fr", true },
  { "bourse-aux-jouets.org", true },
  { "bourse-aux-vetements.org", true },
  { "bourse-puericulture.org", true },
  { "bouwbedrijfpurmerend.nl", true },
  { "bowling.com", true },
  { "bownty.dk", true },
  { "boxcryptor.com", true },
  { "boxing-austria.eu", true },
  { "boxintense.com", true },
  { "boxpirates.to", true },
  { "boypoint.de", true },
  { "bpadvisors.eu", true },
  { "bpastudies.org", true },
  { "bqtoolbox.com", true },
  { "br.search.yahoo.com", false },
  { "bradbrockmeyer.com", true },
  { "bradkovach.com", true },
  { "brage.info", true },
  { "brainfork.ml", true },
  { "brainster.co", false },
  { "bramvanaken.be", true },
  { "bran.cc", true },
  { "bran.land", true },
  { "branchzero.com", true },
  { "brandbuilderwebsites.com", true },
  { "brandnewdays.nl", false },
  { "brandon.so", true },
  { "brandonwalker.me", true },
  { "brandred.net", true },
  { "brasalcosmetics.com", true },
  { "bratteng.me", true },
  { "bratteng.xyz", true },
  { "brd.ro", true },
  { "breechdepot.com", false },
  { "breeswish.org", true },
  { "brefy.com", true },
  { "bregnedalsystems.dk", true },
  { "breitbild-beamer.de", true },
  { "brejoc.com", true },
  { "brewtrackr.com", true },
  { "brianmwaters.net", true },
  { "brianpcurran.com", true },
  { "brickoo.com", true },
  { "brideandgroomdirect.ie", true },
  { "bridholm.se", true },
  { "brightonbank.com", true },
  { "brightstarkids.co.uk", false },
  { "brightstarkids.com.au", false },
  { "brightstarkids.net", false },
  { "brightstarkids.sg", false },
  { "brigidaarie.com", true },
  { "brilliantbuilders.co.uk", true },
  { "brilliantdecisionmaking.com", true },
  { "britishscienceweek.org", true },
  { "britzer-toner.de", true },
  { "brks.xyz", true },
  { "broadsheet.com.au", true },
  { "broersma.com", true },
  { "broeselei.at", true },
  { "broken-oak.com", true },
  { "bronevichok.ru", false },
  { "brookechase.com", true },
  { "brossman.it", true },
  { "brossmanit.com", true },
  { "brownfieldstsc.org", true },
  { "brrr.fr", true },
  { "brunix.net", true },
  { "brunn.email", true },
  { "brunoramos.com", true },
  { "brunoramos.org", true },
  { "brunosouza.org", true },
  { "bryanquigley.com", true },
  { "bryn.xyz", true },
  { "bsagan.fr", true },
  { "bsalyzer.com", true },
  { "bsidessf.com", true },
  { "bsklabels.com", false },
  { "bsquared.org", true },
  { "bta.lv", false },
  { "btcdlc.com", true },
  { "btcontract.com", true },
  { "btio.pw", true },
  { "btsoft.eu", true },
  { "bubblegumblog.com", true },
  { "bubulazi.com", true },
  { "bubulazy.com", true },
  { "buch-cuber.de", true },
  { "buchheld.at", true },
  { "buck.com", true },
  { "budaev-shop.ru", true },
  { "buddhistische-weisheiten.org", true },
  { "budgetalk.com", true },
  { "budskap.eu", true },
  { "buettgens.net", true },
  { "buffalodrinkinggame.beer", true },
  { "bugcrowd.com", true },
  { "bugginslab.co.uk", true },
  { "bugs.chromium.org", true },
  { "bugtrack.io", true },
  { "bugzil.la", true },
  { "bugzilla.mozilla.org", true },
  { "buhler.pro", true },
  { "buiko.com", true },
  { "build.chromium.org", false },
  { "buildbox.io", true },
  { "buildkite.com", true },
  { "buildsaver.co.za", true },
  { "bukkenfan.jp", true },
  { "bulktrade.de", true },
  { "bullbits.com", true },
  { "bulldog-hosting.de", true },
  { "bulmafox.com", true },
  { "bunaken.asia", true },
  { "bunbun.be", true },
  { "bund-von-theramore.de", true },
  { "bundaberg.com", true },
  { "bunsenlabs.org", true },
  { "bureaubolster.nl", true },
  { "buri.be", false },
  { "burian-server.cz", true },
  { "burningcrash.de", true },
  { "burningflipside.com", true },
  { "burnworks.com", true },
  { "burtrum.me", true },
  { "burtrum.org", true },
  { "burzmali.com", true },
  { "busindre.com", true },
  { "business.facebook.com", false },
  { "business.lookout.com", false },
  { "business.medbank.com.mt", true },
  { "businessesdirectory.eu", true },
  { "businessfurs.info", true },
  { "businessloanconnection.org", true },
  { "busold.ws", true },
  { "bustimes.org", true },
  { "buybaby.eu", true },
  { "buyinginvestmentproperty.com", true },
  { "buzzconcert.com", true },
  { "buzzconf.io", true },
  { "bvalle.com", true },
  { "bvionline.eu", true },
  { "bwcscorecard.org", true },
  { "by4cqb.cn", true },
  { "bygningsregistrering.dk", true },
  { "bynet.cz", true },
  { "bypro.xyz", true },
  { "byronwade.com", true },
  { "byrtz.de", true },
  { "byte.wtf", true },
  { "bytejail.com", true },
  { "byteshark.org", true },
  { "bytesofcode.de", true },
  { "bytesund.biz", true },
  { "bytesystems.com", true },
  { "byteturtle.eu", true },
  { "bziaks.xyz", true },
  { "bztech.com.br", true },
  { "bzv-fr.eu", true },
  { "c.cc", true },
  { "c16t.uk", true },
  { "c1yd3i.me", true },
  { "c3b.info", false },
  { "c3w.at", true },
  { "c4k3.net", true },
  { "ca.gparent.org", true },
  { "ca.search.yahoo.com", false },
  { "caasd.org", true },
  { "cabarave.com", true },
  { "cablemod.com", true },
  { "cabsites.com", true },
  { "cabusar.fr", true },
  { "cacaolalina.com", true },
  { "cachethq.io", true },
  { "cackette.com", true },
  { "caconnect.org", true },
  { "cadoth.net", true },
  { "cadusilva.com", true },
  { "caesarkabalan.com", true },
  { "caesreon.com", true },
  { "cafe-scientifique.org.ec", true },
  { "caffeinatedcode.com", true },
  { "cais.de", true },
  { "caizx.com", true },
  { "caja-pdf.es", true },
  { "cajapopcorn.com", true },
  { "cajunuk.co.uk", true },
  { "calaborlawnews.com", true },
  { "calculator-imt.com", true },
  { "calebmorris.com", true },
  { "calgoty.com", true },
  { "calibreapp.com", false },
  { "calibso.net", true },
  { "calix.com", true },
  { "call.me", false },
  { "callear.org", true },
  { "callhub.io", true },
  { "callsigns.ca", true },
  { "calltrackingreports.com", true },
  { "calomel.org", true },
  { "calories.org", true },
  { "calvin.me", true },
  { "calvinallen.net", true },
  { "calyxengineers.com", true },
  { "camaya.net", true },
  { "cambridgeanalytica.org", true },
  { "camconn.cc", true },
  { "camolist.com", true },
  { "campaign-ad.com", true },
  { "campaignelves.com", true },
  { "campbellsoftware.co.uk", true },
  { "campbrainybunch.com", true },
  { "camperdays.de", true },
  { "campermanaustralia.com", true },
  { "camperverzekerd.nl", true },
  { "campfiretails.org", true },
  { "campfourpaws.com", true },
  { "campus-finance.com", true },
  { "canadalife.de", true },
  { "canadasmotorcycle.ca", true },
  { "canadianchristianity.com", true },
  { "canarymod.net", true },
  { "candicontrols.com", true },
  { "cando.eu", true },
  { "candratech.com", true },
  { "canhazip.com", true },
  { "cannyfoxx.me", true },
  { "cantrack.com", true },
  { "canyonshoa.com", true },
  { "canyoupwn.me", true },
  { "cao.gov", true },
  { "cao.la", true },
  { "capecycles.co.za", true },
  { "caphane.com", true },
  { "capitalquadatv.org.nz", true },
  { "capitaltg.com", true },
  { "capogna.com", true },
  { "capper.de", true },
  { "capriccio.to", true },
  { "caps.is", true },
  { "captchatheprize.com", true },
  { "captivatedbytabrett.com", true },
  { "capturapp.com", true },
  { "capturethepen.co.uk", true },
  { "caputo.com", true },
  { "carano-service.de", true },
  { "caraudio69.cz", true },
  { "carbonmade.com", false },
  { "carck.co.uk", true },
  { "cardloan-manual.net", true },
  { "cardrecovery.fr", true },
  { "cardstream.com", true },
  { "careerstuds.com", true },
  { "caremad.io", true },
  { "carey.li", true },
  { "carezone.com", false },
  { "cargobay.net", true },
  { "carigami.fr", true },
  { "carlandfaith.com", true },
  { "carlgo11.com", true },
  { "carlosalves.info", true },
  { "carnaticalifornia.com", true },
  { "carnildo.com", true },
  { "carsforbackpackers.com", true },
  { "carsten.pw", true },
  { "carstenfeuls.de", true },
  { "cartouche24.eu", true },
  { "cartucce24.it", true },
  { "casa-su.casa", true },
  { "casedi.org", true },
  { "cash-pos.com", true },
  { "cashew3d.com", true },
  { "cashlink.io", true },
  { "casinolistings.com", true },
  { "casinoreal.com", true },
  { "casovi.cf", true },
  { "castlejackpot.com", true },
  { "cat-box.de", true },
  { "catalyst-ecommerce.com", false },
  { "catarsisvr.com", true },
  { "catgirl.pics", true },
  { "catinmay.com", true },
  { "cativa.net", true },
  { "catnapstudios.com", true },
  { "catnet.dk", false },
  { "catsmagic.pp.ua", true },
  { "cattivo.nl", true },
  { "cavac.at", true },
  { "caveclan.org", true },
  { "cavedroid.xyz", true },
  { "cbhq.net", true },
  { "ccayearbook.com", true },
  { "ccblog.de", true },
  { "ccja.ro", false },
  { "ccsys.com", true },
  { "cdkeykopen.com", true },
  { "cdlcenter.com", true },
  { "cdnb.co", true },
  { "cdnjs.com", true },
  { "cdt.org", true },
  { "cecipu.gob.cl", true },
  { "ced-services.nl", true },
  { "ceilingpac.org", true },
  { "cejhon.cz", true },
  { "celti.ie.eu.org", true },
  { "celti.name", true },
  { "cementscience.com", true },
  { "ceml.ch", true },
  { "centennialrewards.com", true },
  { "centerpereezd.ru", false },
  { "centillien.com", true },
  { "centralpoint.be", true },
  { "centralpoint.nl", true },
  { "centralstatecu.org", true },
  { "centralync.com", true },
  { "centrepoint-community.com", false },
  { "centricweb.com", true },
  { "centrobill.com", true },
  { "ceoimon.com", true },
  { "ceopedia.org", true },
  { "cerastar.com", true },
  { "cerebelo.info", true },
  { "ceritamalam.net", true },
  { "certcenter.com", true },
  { "certcenter.de", true },
  { "certible.com", true },
  { "certifi.io", true },
  { "certly.io", true },
  { "certnazionale.it", true },
  { "cervejista.com", true },
  { "cesal.net", true },
  { "cesidianroot.eu", true },
  { "cesobaly.cz", true },
  { "cestlav.it", true },
  { "ceu.edu", false },
  { "cevrimici.com", true },
  { "ceyizlikelisleri.com", true },
  { "cfa.gov", true },
  { "cfcnexus.org", true },
  { "cfcproperties.com", true },
  { "cfetengineering.com", true },
  { "cfh.com", true },
  { "cfo.gov", true },
  { "cfoitplaybook.com", true },
  { "cfxdesign.com", true },
  { "cg-systems.hu", true },
  { "cgan.pw", true },
  { "cgbilling.com", true },
  { "cgtx.us", true },
  { "ch-sc.de", true },
  { "ch.search.yahoo.com", false },
  { "chabaudparfum.com", true },
  { "chahub.com", true },
  { "chainmonitor.com", true },
  { "chaletmanager.com", true },
  { "chamilo.org", true },
  { "changetip.com", true },
  { "chaos-inc.de", true },
  { "chaos.fail", true },
  { "chaoschemnitz.de", true },
  { "chaosdorf.de", true },
  { "chaoswebs.net", true },
  { "charge.co", true },
  { "charityclear.com", true },
  { "charitystreet.co.uk", true },
  { "charl.eu", true },
  { "charlierogers.com", true },
  { "charmander.me", true },
  { "chartpen.com", true },
  { "chateau-belvoir.com", true },
  { "chatme.im", false },
  { "chatup.cf", true },
  { "chaulootz.com", true },
  { "chaz6.com", true },
  { "chazay.net", true },
  { "chcemvediet.sk", true },
  { "chch.it", true },
  { "cheapestgamecards.de", true },
  { "cheapestgamecards.nl", true },
  { "cheapestgamecards.se", true },
  { "cheapgeekts.com", false },
  { "cheapgoa.com", true },
  { "check.torproject.org", false },
  { "checkout.google.com", true },
  { "checktype.com", true },
  { "checkyourmath.com", true },
  { "cheerflow.com", true },
  { "cheesetart.my", false },
  { "cheetah85.de", true },
  { "chenapartment.com", true },
  { "chengl.com", true },
  { "chepaofen.com", true },
  { "cherrywoodtech.com", true },
  { "chfr.search.yahoo.com", false },
  { "chiaramail.com", true },
  { "chic-leather.com", true },
  { "chihiro.xyz", true },
  { "chikan-beacon.net", true },
  { "childcaresolutionscny.org", true },
  { "chilihosting.eu", true },
  { "chimeratool.com", true },
  { "china-line.org", true },
  { "chinternet.xyz", true },
  { "chiphell.com", true },
  { "chippy.ch", false },
  { "chiralsoftware.com", true },
  { "chireiden.net", true },
  { "chirgui.eu", true },
  { "chiropracticwpb.com", true },
  { "chiru.no", true },
  { "chit.search.yahoo.com", false },
  { "chloe.re", true },
  { "chloeallison.co.uk", true },
  { "chocolah.com.au", false },
  { "chocotough.nl", false },
  { "choosemypc.net", true },
  { "chorpinkpoemps.de", true },
  { "chotu.net", true },
  { "chris-edwards.net", true },
  { "chris-web.info", false },
  { "chrisandsarahinasia.com", true },
  { "chrisbrown.id.au", true },
  { "chrisfaber.com", true },
  { "chrisfinazzo.com", true },
  { "chrishamper.com", true },
  { "chrisirwin.ca", true },
  { "chrisjean.com", true },
  { "chriskyrouac.com", true },
  { "chrismckee.co.uk", true },
  { "christadelphiananswers.org", true },
  { "christiaanconover.com", true },
  { "christiaandruif.nl", true },
  { "christianbro.gq", true },
  { "christianhoffmann.info", true },
  { "christianliebel.com", true },
  { "christiesantiques.com", true },
  { "christina-quast.de", true },
  { "christophheich.me", true },
  { "chrisupjohn.com", true },
  { "chriswarrick.com", true },
  { "chriswells.io", true },
  { "chrome-devtools-frontend.appspot.com", true },
  { "chrome.com", false },
  { "chrome.google.com", true },
  { "chromebooksforwork.com", true },
  { "chromiumcodereview.appspot.com", false },
  { "chronoshop.cz", true },
  { "chrst.ph", true },
  { "chsterz.de", true },
  { "chua.cf", true },
  { "chuckame.fr", true },
  { "chulado.com", true },
  { "chun.pro", true },
  { "churchthemes.com", true },
  { "ciat.no", true },
  { "cidbot.com", true },
  { "cienbeaute-lidl.fr", true },
  { "cig-dem.com", true },
  { "cigarblogs.net", true },
  { "cigarterminal.com", false },
  { "cimalando.eu", true },
  { "cimballa.com", true },
  { "cinefilzonen.se", true },
  { "cinema5.ru", true },
  { "cintdirect.com", true },
  { "cio.gov", true },
  { "cipherli.st", true },
  { "cirfi.com", true },
  { "cirope.com", true },
  { "cirrus0.de", true },
  { "ciscodude.net", true },
  { "ciscohomeanalytics.com", true },
  { "ciscommerce.net", true },
  { "citizensbankal.com", true },
  { "cittadesign.com", true },
  { "citya.com", true },
  { "ciubotaru.tk", true },
  { "cjcaron.org", true },
  { "ckleemann.de", true },
  { "cklie.de", true },
  { "ckliemann.com", true },
  { "ckliemann.net", true },
  { "cktennis.com", true },
  { "cl.search.yahoo.com", false },
  { "claimconnect.us", true },
  { "clan-ww.com", true },
  { "clanthor.com", true },
  { "clapping-rhymes.com", true },
  { "claralabs.com", true },
  { "clarkeaward.com", true },
  { "classdojo.com", true },
  { "classicday.nl", true },
  { "classicsandexotics.com", true },
  { "classicshop.ua", true },
  { "classicspublishing.com", true },
  { "clawe.de", true },
  { "cldly.com", true },
  { "clearc.tk", false },
  { "clearkonjac.com", true },
  { "clearsettle-admin.com", true },
  { "clearviewwealthprojector.com.au", true },
  { "clerkendweller.uk", true },
  { "clevertarget.ru", true },
  { "clevisto.com", true },
  { "clickandshoot.nl", true },
  { "clickclickphish.com", true },
  { "clickenergy.com.au", true },
  { "clickforclever.com", true },
  { "clickphish.com", true },
  { "clicks.co.za", true },
  { "clientsecure.me", true },
  { "clifflu.net", true },
  { "climaprecio.es", true },
  { "climateinteractive.org", true },
  { "climatestew.com", true },
  { "cliniquepariseau.com", true },
  { "clintonbloodworth.com", true },
  { "clintwilson.technology", true },
  { "clip.ovh", true },
  { "clipped4u.com", true },
  { "clmde.de", true },
  { "clochix.net", true },
  { "clockcaster.com", true },
  { "clockworksms.com", true },
  { "close.com", false },
  { "closeli.cn", true },
  { "cloud-project.com", true },
  { "cloud.google.com", true },
  { "cloud.wtf", true },
  { "cloudapi.vc", true },
  { "cloudbolin.es", true },
  { "clouddesktop.co.nz", true },
  { "cloudey.net", true },
  { "cloudflareonazure.com", true },
  { "cloudily.com", true },
  { "cloudimag.es", true },
  { "cloudmigrator365.com", true },
  { "cloudns.com.au", true },
  { "cloudpagesforwork.com", true },
  { "cloudpebble.net", true },
  { "clouds.webcam", true },
  { "cloudsecurityalliance.org", true },
  { "cloudspace-analytics.com", true },
  { "cloudstoragemaus.com", true },
  { "cloudstorm.me", true },
  { "cloudstrike.co", true },
  { "cloudup.com", true },
  { "cloverleaf.net", true },
  { "clownish.co.il", true },
  { "cloxy.com", true },
  { "clsimplex.com", true },
  { "clu-in.org", true },
  { "clubmate.rocks", true },
  { "clubmini.jp", true },
  { "clubmix.co.kr", true },
  { "clvrwebdesign.com", true },
  { "clycat.ru", true },
  { "clywedogmaths.co.uk", true },
  { "cmacacias.ch", true },
  { "cmahy.be", true },
  { "cmdline.org", true },
  { "cmlachapelle.ch", true },
  { "cmlancy.ch", true },
  { "cmlignon.ch", true },
  { "cmplainpalais.ch", true },
  { "cmsbattle.com", true },
  { "cnam.net", true },
  { "cni-certing.it", true },
  { "cnlic.com", true },
  { "co.search.yahoo.com", false },
  { "co50.com", true },
  { "coachingconsultancy.com", true },
  { "coam.co", true },
  { "cobalt.io", false },
  { "cocaine.ninja", true },
  { "cocker.cc", false },
  { "cocoaheads.at", true },
  { "cocolovesdaddy.com", true },
  { "codabix.com", true },
  { "codabix.de", true },
  { "codabix.net", true },
  { "code-poets.co.uk", true },
  { "code-well.com", true },
  { "code.facebook.com", false },
  { "code.fm", true },
  { "code.google.com", true },
  { "code67.com", true },
  { "codeco.pw", true },
  { "codeferm.com", true },
  { "codefordus.nrw", true },
  { "codeforhakodate.org", true },
  { "codefoundry.it", true },
  { "codelayer.ca", true },
  { "codeplay.org", true },
  { "codepoints.net", true },
  { "codepref.com", true },
  { "codepult.com", true },
  { "codereview.appspot.com", false },
  { "codereview.chromium.org", false },
  { "coderhangout.com", true },
  { "codesport.io", true },
  { "codeux.com", true },
  { "codewild.de", true },
  { "codewiththepros.org", true },
  { "codeyellow.nl", true },
  { "codingforspeed.com", true },
  { "codyevanscomputer.com", true },
  { "coffee-mamenoki.jp", true },
  { "cogent.cc", true },
  { "cogitoltd.com", true },
  { "cogumelosmagicos.org", true },
  { "coi-verify.com", true },
  { "coiffeurschnittstelle.ch", true },
  { "coimmvest.com", true },
  { "coinapult.com", true },
  { "coinbase.com", true },
  { "coindam.com", false },
  { "coinessa.com", true },
  { "coinjar-sandbox.com", true },
  { "cojo.eu", true },
  { "coldawn.com", true },
  { "coldfff.com", true },
  { "coldhak.ca", true },
  { "colengo.com", true },
  { "colisfrais.com", true },
  { "collabornation.net", true },
  { "collada.org", true },
  { "collectiblebeans.com", true },
  { "collegepulse.org", true },
  { "collinmbarrett.com", false },
  { "collins.kg", true },
  { "collins.press", true },
  { "collinsartworks.com", true },
  { "colognegaming.net", true },
  { "coloradocomputernetworking.net", true },
  { "coloradolottery.com", true },
  { "colorbrush.ru", true },
  { "coloringnotebook.com", true },
  { "colorlib.com", true },
  { "com.cc", true },
  { "comarkinstruments.net", true },
  { "combatshield.cz", true },
  { "comdurav.com", true },
  { "comercialtrading.eu", true },
  { "comfortticket.de", true },
  { "comhack.com", true },
  { "comicspines.com", true },
  { "comitesaustria.at", true },
  { "comiteshopping.com", true },
  { "commencepayments.com", true },
  { "commerciallocker.com", true },
  { "commoncore4kids.com", true },
  { "communityblog.fedoraproject.org", true },
  { "comodo.nl", true },
  { "comotalk.com", true },
  { "compagnia-buffo.de", true },
  { "compalytics.com", true },
  { "comparamejor.com", true },
  { "compareandrecycle.co.uk", true },
  { "compareandrecycle.com", true },
  { "compareinsurance.com.au", true },
  { "comparejewelleryprices.co.uk", true },
  { "comparetravelinsurance.com.au", true },
  { "compeuphoria.com", true },
  { "compiledworks.com", true },
  { "completionist.audio", true },
  { "completionist.me", true },
  { "compliance-systeme.de", true },
  { "compliancedictionary.com", true },
  { "complymd.com", true },
  { "compucorner.com.mx", true },
  { "compucorner.mx", true },
  { "computersystems.guru", true },
  { "comssa.org.au", true },
  { "concentrade.de", true },
  { "condepenalba.com", true },
  { "config.schokokeks.org", false },
  { "confirm365.com", true },
  { "conformal.com", true },
  { "connect.ua", false },
  { "connected-verhuurservice.nl", true },
  { "connectfss.com", true },
  { "connectingconcepts.com", true },
  { "connext.de", true },
  { "connyduck.at", true },
  { "conrad-kostecki.de", true },
  { "consciousandglamorous.com", true },
  { "consciousbrand.co", true },
  { "consciousbrand.org.au", true },
  { "consciousbranding.org.au", true },
  { "consciousbrands.net.au", true },
  { "console.support", true },
  { "consonare.de", true },
  { "constructionjobs.com", true },
  { "consul.io", true },
  { "consumer.gov", true },
  { "consumersentinel.gov", true },
  { "contactbig.com", true },
  { "containerstatistics.com", true },
  { "contarkos.xyz", true },
  { "content-api-dev.azurewebsites.net", true },
  { "continuumgaming.com", false },
  { "contributor.google.com", true },
  { "controlcenter.gigahost.dk", true },
  { "conve.eu", true },
  { "convergemagazine.com", true },
  { "conversiones.com", true },
  { "convert.zone", true },
  { "converter.ml", true },
  { "convocatoriafundacionpepsicomexico.org", false },
  { "cookiesoft.de", true },
  { "cookinglife.nl", false },
  { "cookmedical.com", false },
  { "cool110.tk", true },
  { "coolaj86.com", true },
  { "coopens.com", true },
  { "coore.jp", true },
  { "cooxa.com", true },
  { "copperhead.co", true },
  { "cor-ser.es", true },
  { "coralproject.net", true },
  { "cordlessdog.com", true },
  { "core.mx", true },
  { "coreless-stretchfilm.com", true },
  { "corgicloud.com", true },
  { "cornercircle.co.uk", true },
  { "coronelpicanha.com.br", true },
  { "corruption-mc.net", true },
  { "corruption-rsps.net", true },
  { "corruption-server.net", true },
  { "cortexitrecruitment.com", true },
  { "coryadum.com", true },
  { "costablancavoorjou.com", true },
  { "costreportdata.com", true },
  { "cotonea.de", true },
  { "coughlan.de", true },
  { "count.sh", true },
  { "countermail.com", true },
  { "countybankdel.com", true },
  { "coursdeprogrammation.com", true },
  { "coursera.org", true },
  { "courtlistener.com", true },
  { "covenantoftheriver.org", true },
  { "coverduck.ru", true },
  { "covoiturage.fr", false },
  { "covybrat.cz", true },
  { "cowboyim.com", true },
  { "coweo.cz", true },
  { "cozmaadrian.ro", true },
  { "cpuvinf.eu.org", true },
  { "cpvmatch.eu", true },
  { "cqchome.com", true },
  { "cracker.in.th", true },
  { "crackingking.com", false },
  { "crackle.io", true },
  { "crackpfer.de", true },
  { "cradlepointecm.com", true },
  { "craftbeerbarn.co.uk", true },
  { "craftedge.xyz", true },
  { "cranesafe.com", true },
  { "cravelyrics.com", true },
  { "crazycen.com", true },
  { "crazydomains.ae", true },
  { "crazydomains.co.nz", true },
  { "crazydomains.co.uk", true },
  { "crazydomains.com.au", true },
  { "crazydomains.in", true },
  { "crbug.com", false },
  { "crea.me", true },
  { "creativeartifice.com", true },
  { "creativeplayuk.com", true },
  { "creditkarma.com", true },
  { "creditproautos.com", true },
  { "creep.im", true },
  { "crefelder.com", true },
  { "crendontech.com", true },
  { "crepererum.net", true },
  { "crestasantos.com", true },
  { "crestoncottage.com", true },
  { "crimson.no", true },
  { "cristiandeluxe.com", true },
  { "critical.today", true },
  { "criticalaim.com", true },
  { "crizk.com", true },
  { "crl-autos.com", true },
  { "crm.onlime.ch", false },
  { "cross-view.com", true },
  { "crosscom.ch", true },
  { "crossfitblackwater.com", true },
  { "crosssec.com", true },
  { "crosssellguide.com", true },
  { "crow.tw", true },
  { "crowd.supply", true },
  { "crowdjuris.com", true },
  { "crowdsupply.com", true },
  { "crtvmgmt.com", true },
  { "crudysql.com", true },
  { "crufad.org", true },
  { "crumbcontrol.com", true },
  { "crushroom.com", true },
  { "crute.me", true },
  { "cruzr.xyz", true },
  { "crypt.guru", true },
  { "crypticshell.co.uk", true },
  { "cryptify.eu", true },
  { "crypto.cat", false },
  { "crypto.graphics", true },
  { "cryptobells.com", false },
  { "cryptobin.co", true },
  { "cryptobin.org", true },
  { "cryptocon.org", true },
  { "cryptography.io", true },
  { "cryptoisnotacrime.org", true },
  { "cryptojar.io", true },
  { "cryptolab.pro", true },
  { "cryptonit.net", true },
  { "cryptonym.com", true },
  { "cryptoparty.at", true },
  { "cryptoparty.dk", true },
  { "cryptopartyatx.org", true },
  { "cryptopartyutah.org", true },
  { "cryptopush.com", true },
  { "cryptoseb.pw", true },
  { "crystalchandelierservices.com", true },
  { "crystalclassics.co.uk", true },
  { "csacongress.org", true },
  { "csapak.com", true },
  { "csbs.fr", true },
  { "cselzer.com", true },
  { "csfm.com", true },
  { "csfs.org.uk", true },
  { "csgodicegame.com", true },
  { "csgokings.eu", true },
  { "csokolade.hu", true },
  { "cspbuilder.info", true },
  { "cspvalidator.org", true },
  { "cssu.in", true },
  { "cstkit.com", true },
  { "csuw.net", true },
  { "csvape.com", true },
  { "ct-status.org", true },
  { "cthomas.work", true },
  { "cthulhuden.com", true },
  { "ctns.de", true },
  { "ctoforhire.com.au", true },
  { "ctpe.net", true },
  { "cube.de", true },
  { "cubewano.com", true },
  { "cubua.com", true },
  { "cuibonobo.com", true },
  { "cuisinezest.com", true },
  { "cujba.com", true },
  { "culinae.nl", true },
  { "cultiv.nl", false },
  { "cuonic.com", true },
  { "cup.al", true },
  { "cupcake.io", true },
  { "cupcake.is", true },
  { "curacao-license.com", true },
  { "curiosity-driven.org", true },
  { "curlybracket.co.uk", true },
  { "curlyroots.com", true },
  { "currency-strength.com", true },
  { "curroapp.com", true },
  { "curtacircuitos.com.br", false },
  { "curveweb.co.uk", true },
  { "custe.rs", true },
  { "custodyxchange.com", true },
  { "customd.com", true },
  { "cutorrent.com", true },
  { "cuvva.co", true },
  { "cvjm-memmingen.de", true },
  { "cvmu.jp", true },
  { "cvr.dk", true },
  { "cvsoftub.com", true },
  { "cvursache.com", true },
  { "cwagner.me", true },
  { "cyanogenmod.xxx", true },
  { "cyberfrancais.ro", true },
  { "cyberguerrilla.info", true },
  { "cyberguerrilla.org", true },
  { "cyberhouse.at", true },
  { "cyberianhusky.com", true },
  { "cyberkov.com", true },
  { "cyberoptic.de", true },
  { "cyberpunk.ca", true },
  { "cybersecuritychallenge.be", true },
  { "cybershambles.com", true },
  { "cyberspect.com", true },
  { "cyberspect.io", true },
  { "cyberwire.nl", true },
  { "cybozu.cn", true },
  { "cybozu.com", true },
  { "cybozulive.com", true },
  { "cyclebeads.com", true },
  { "cyclehackluxembourgcity.lu", true },
  { "cydia-search.io", true },
  { "cyfly.org", true },
  { "cygnius.net", true },
  { "cymtech.net", true },
  { "cyon.ch", true },
  { "cyph.audio", true },
  { "cyph.com", true },
  { "cyph.im", true },
  { "cyph.video", true },
  { "cyphertite.com", true },
  { "cyprus-company-service.com", true },
  { "cysec.biz", true },
  { "czakey.net", true },
  { "czbix.com", true },
  { "czechamlp.com", true },
  { "czk.mk", true },
  { "czlx.co", true },
  { "d-20.fr", true },
  { "d-quantum.com", true },
  { "d-training.de", true },
  { "d3xt3r01.tk", true },
  { "d42.no", true },
  { "daallexx.eu", true },
  { "dachb0den.net", true },
  { "dad256.tk", true },
  { "dadons-laserdiscs.com", true },
  { "dadtheimpaler.com", true },
  { "daduke.org", true },
  { "daemon.xin", true },
  { "dag-konsult.com", true },
  { "dailyenglishchallenge.com", true },
  { "dailylifefinancial.com", true },
  { "dailystormerpodcasts.com", true },
  { "daimadi.com", true },
  { "dairyshrine.org", true },
  { "daiweihu.com", true },
  { "dakrib.net", true },
  { "dale-electric.com", true },
  { "dalingk.co", true },
  { "dallmeier.net", true },
  { "damianuv-blog.cz", true },
  { "dammekens.be", true },
  { "damngoodpepper.com", true },
  { "danaketh.com", true },
  { "dancerdates.net", true },
  { "daniel-ruf.de", true },
  { "danielalvarez.net", true },
  { "danielcowie.me", true },
  { "danielheal.net", true },
  { "danielrozenberg.com", true },
  { "danieltollot.de", true },
  { "danielverlaan.nl", true },
  { "danishenanigans.com", true },
  { "danjesensky.com", true },
  { "dank.ninja", true },
  { "dankim.de", true },
  { "dannycrichton.com", true },
  { "dannyrohde.de", true },
  { "danonsecurity.com", true },
  { "danpiel.net", true },
  { "danscomp.com", true },
  { "danseressen.nl", true },
  { "danskoferie.dk", true },
  { "danw.io", true },
  { "daphne.informatik.uni-freiburg.de", true },
  { "daplie.com", true },
  { "darchoods.net", false },
  { "dargasia.is", true },
  { "dario.im", true },
  { "darioturchetti.me", true },
  { "dark-x.cf", true },
  { "darkag.ovh", true },
  { "darkdestiny.ch", true },
  { "darkengine.io", true },
  { "darkkeepers.dk", true },
  { "darknebula.space", false },
  { "darknode.in", true },
  { "darkpony.ru", true },
  { "darkserver.fedoraproject.org", true },
  { "darkserver.stg.fedoraproject.org", true },
  { "darkshop.nl", true },
  { "darkside.re", true },
  { "darksideof.it", true },
  { "darkspacelab.com", true },
  { "darkwater.info", true },
  { "darlo.co.uk", true },
  { "darom.jp", true },
  { "darrenellis.xyz", true },
  { "darrenm.net", true },
  { "darrienworth.com", true },
  { "darwinkel.net", false },
  { "dash-board.jp", false },
  { "dash.rocks", true },
  { "dashboard.yt", true },
  { "data-abundance.com", true },
  { "data.haus", true },
  { "data.qld.gov.au", false },
  { "databutlr.net", true },
  { "datacalle.com", true },
  { "datacandy.com", true },
  { "datahove.no", true },
  { "datajapan.co.jp", true },
  { "datapun.ch", true },
  { "dataretention.solutions", true },
  { "datascience.cafe", true },
  { "datasharesystem.com", true },
  { "datasnitch.co.uk", true },
  { "datatekniikka.com", false },
  { "datatekniikka.fi", false },
  { "dateno1.com", false },
  { "datorb.com", false },
  { "datortipsen.se", true },
  { "datsound.ru", true },
  { "daveoc64.co.uk", true },
  { "davevelopment.net", true },
  { "david-corry.com", true },
  { "david-schiffmann.de", true },
  { "david.kitchen", true },
  { "davidandersson.se", true },
  { "davidgouveia.net", true },
  { "davidgow.net", true },
  { "davidgrudl.com", true },
  { "davidlyness.com", true },
  { "davidmcevoy.org.uk", true },
  { "davidmessenger.co.uk", true },
  { "davidnoren.com", true },
  { "davidreinhardt.de", true },
  { "davidscherzer.at", true },
  { "davimun.org", true },
  { "davisroi.com", true },
  { "daylightpirates.org", true },
  { "dbgamestudio.com", true },
  { "dbldub.net", true },
  { "dbmteam.com", true },
  { "dc585.info", true },
  { "dccode.gov", true },
  { "dccoffeeproducts.com", true },
  { "dckd.nl", true },
  { "dcmt.co", true },
  { "dcpower.eu", true },
  { "dd.art.pl", true },
  { "ddatsh.com", true },
  { "dden.ca", false },
  { "dden.xyz", true },
  { "ddhosted.com", true },
  { "ddmeportal.com", true },
  { "ddos-mitigation.co.uk", true },
  { "ddos-mitigation.info", true },
  { "de-medici.nl", true },
  { "de-spil.be", true },
  { "de.search.yahoo.com", false },
  { "deadbeef.ninja", true },
  { "dealbanana.at", true },
  { "dealbanana.be", true },
  { "dealbanana.co.uk", true },
  { "dealbanana.com", true },
  { "dealbanana.de", true },
  { "dealbanana.fi", true },
  { "dealbanana.fr", true },
  { "dealbanana.it", true },
  { "dealbanana.se", true },
  { "dealcruiser.nl", true },
  { "dealpass.no", true },
  { "deanmorgan.org", true },
  { "deathy.ro", true },
  { "decafu.co", true },
  { "deco.me", true },
  { "decoder.link", true },
  { "decomplify.com", true },
  { "decor-d.com", true },
  { "decoratrix.com", true },
  { "decoyrouting.com", true },
  { "dedelta.net", true },
  { "dedeo.tk", true },
  { "dedicatutiempo.es", true },
  { "dedimax.de", true },
  { "dedmorozrzn.ru", true },
  { "deduijventil.nl", true },
  { "dee.pe", true },
  { "deepbluecrafting.co.uk", true },
  { "deepcovelabs.net", true },
  { "deeprecce.com", true },
  { "deepserve.info", true },
  { "deer.team", true },
  { "deetzen.de", true },
  { "def-pos.ru", true },
  { "defcon.org", true },
  { "degeberg.com", true },
  { "degeberg.dk", true },
  { "dehopre.com", true },
  { "deight.co", true },
  { "deinballon.de", true },
  { "dekasan.ru", true },
  { "delfic.org", true },
  { "deliciisanatoase.ro", true },
  { "delta-data.ch", true },
  { "deltanet-production.de", true },
  { "delvj.org", true },
  { "dementiapraecox.de", true },
  { "demo.swedbank.se", true },
  { "democracy.io", true },
  { "democracychronicles.com", true },
  { "demomanca.com", true },
  { "demuzere.be", true },
  { "demuzere.com", true },
  { "demuzere.eu", true },
  { "demuzere.net", true },
  { "denardbrewing.com", true },
  { "denimio.com", true },
  { "denisjean.fr", true },
  { "dennisdoes.net", true },
  { "denniskoot.nl", true },
  { "dennogumi.org", true },
  { "dentallaborgeraeteservice.de", true },
  { "dentistglasgow.com", true },
  { "dentystabirmingham.co.uk", true },
  { "denverprophit.us", true },
  { "depechemode-live.com", true },
  { "depicus.com", true },
  { "depijl-mz.nl", true },
  { "dequehablamos.es", true },
  { "derbyshire-language-scheme.co.uk", true },
  { "derchris.me", true },
  { "dereferenced.net", true },
  { "deregowski.net", true },
  { "derekkent.com", true },
  { "dergeilstestammderwelt.de", true },
  { "derhil.de", false },
  { "derp.army", true },
  { "derreichesack.com", true },
  { "dersoundhunter.de", true },
  { "derwolfe.net", true },
  { "desiccantpackets.com", true },
  { "designgears.com", true },
  { "designthinking.or.jp", false },
  { "desmaakvanplanten.be", true },
  { "desserteagleselvenar.tk", true },
  { "destinationbijoux.fr", true },
  { "detectify.com", false },
  { "detector.exposed", true },
  { "dethemium.com", true },
  { "detoxsinutritie.ro", true },
  { "detteflies.com", true },
  { "detutorial.com", true },
  { "deuxsolutions.com", true },
  { "devb.nl", true },
  { "devdoodle.net", true },
  { "developer.mydigipass.com", false },
  { "developerfair.com", true },
  { "developers.facebook.com", false },
  { "developfx.com", true },
  { "developmentaid.org", true },
  { "devh.net", true },
  { "deviant.email", true },
  { "devilshakerz.com", true },
  { "deviltracks.net", true },
  { "deviltraxxx.de", true },
  { "devincrow.me", true },
  { "devklog.net", true },
  { "devlux.ch", true },
  { "devmsg.com", true },
  { "devnsec.com", true },
  { "devnull.team", true },
  { "devolution.ws", true },
  { "devopps.me", true },
  { "devopsconnected.com", true },
  { "devstaff.gr", true },
  { "devuan.org", true },
  { "dewalch.net", true },
  { "dfekt.no", true },
  { "dfektlan.no", true },
  { "dfranke.com", true },
  { "dgeex.eu", true },
  { "dgt-portal.de", true },
  { "dhautefeuille.eu", true },
  { "dhauwer.nl", true },
  { "dhuy.net", true },
  { "diamante.ro", true },
  { "diarbag.us", false },
  { "diasdasemana.com", true },
  { "diasporadialogues.com", true },
  { "dibiphp.com", true },
  { "dicgaming.net", true },
  { "dicionariofinanceiro.com", true },
  { "dick.red", true },
  { "didacte.com", true },
  { "diddens.de", true },
  { "die-besten-weisheiten.de", true },
  { "die-blahuts.de", true },
  { "die-partei-reutlingen.de", true },
  { "diegelernten.de", true },
  { "diegerbers.de", true },
  { "dienstplan.cc", true },
  { "dienstplan.one", true },
  { "dierenkruiden.nl", false },
  { "dieselgalleri.com", true },
  { "dieti.net", true },
  { "dietrich.cx", true },
  { "dighans.com", true },
  { "digidroom.be", true },
  { "digital-coach.it", true },
  { "digital-eastside.de", true },
  { "digital1st.co.uk", true },
  { "digitaldeliarchive.com", true },
  { "digitalehandtekeningen.nl", true },
  { "digitallocker.com", true },
  { "digitalnonplus.com", true },
  { "digitalquery.com", true },
  { "digitalskillswap.com", true },
  { "digitkon.com", true },
  { "digminecraft.com", true },
  { "dijkmanmuziek.nl", false },
  { "dillonkorman.com", true },
  { "dime-staging.com", true },
  { "dime.io", true },
  { "dinepont.fr", true },
  { "dinge.xyz", true },
  { "dinkum.online", true },
  { "dinube.com", true },
  { "diodeled.com", true },
  { "dipconsultants.com", true },
  { "dipl.io", true },
  { "directebanking.com", true },
  { "directme.ga", true },
  { "dirkwolf.de", true },
  { "discipul.nl", true },
  { "discofitta.com", true },
  { "disconformity.net", true },
  { "discoveringdocker.com", true },
  { "dise-online.de", true },
  { "disinclined.org", true },
  { "disking.co.uk", true },
  { "disorderboutique.com", true },
  { "disposable.link", true },
  { "disruptivelabs.net", true },
  { "disruptivelabs.org", true },
  { "dissectcyber.com", true },
  { "dissimulo.me", true },
  { "dist.torproject.org", false },
  { "distinctivephotography.com.au", true },
  { "dittvertshus.no", true },
  { "divegearexpress.com", true },
  { "diversityflags.com", true },
  { "divingwithnic.com", true },
  { "dixiediner.com", true },
  { "dixmag.com", true },
  { "diybook.at", true },
  { "diycc.org", true },
  { "dizorg.net", true },
  { "djlive.pl", true },
  { "djxmmx.net", false },
  { "djz4music.com", true },
  { "dk.search.yahoo.com", false },
  { "dkds.us", true },
  { "dl.google.com", true },
  { "dlc.viasinc.com", true },
  { "dlemper.de", true },
  { "dlscomputers.com.au", true },
  { "dm.lookout.com", false },
  { "dm.mylookout.com", false },
  { "dmcibulldog.com", true },
  { "dmeevalumate.com", true },
  { "dmfd.net", true },
  { "dmi.es", true },
  { "dmlogic.com", true },
  { "dmxledlights.com", true },
  { "dmz.ninja", true },
  { "dn42.eu", true },
  { "dn42.us", true },
  { "dna.li", true },
  { "dnc.org.nz", true },
  { "dndtools.net", true },
  { "dne.lu", true },
  { "dnmlab.it", true },
  { "dns.google.com", true },
  { "dnscrypt.org", true },
  { "dnscurve.io", true },
  { "dnshallinta.fi", true },
  { "dnslog.com", true },
  { "dnsman.se", true },
  { "dobet.in", true },
  { "doc.python.org", true },
  { "docbox.ch", true },
  { "docemeldoces.com", true },
  { "docid.io", true },
  { "docket.news", true },
  { "docloh.de", true },
  { "docs.google.com", true },
  { "docs.python.org", true },
  { "doctorfox.co.uk", true },
  { "doctorwho.cz", true },
  { "docucopies.com", true },
  { "docufiel.com", true },
  { "doesmycodehavebugs.today", true },
  { "doeswindowssuckforeveryoneorjustme.com", true },
  { "dogan.ch", false },
  { "dogbox.se", true },
  { "dogespeed.ga", true },
  { "dogfi.sh", true },
  { "doggieholic.net", true },
  { "dogoodbehappyllc.com", true },
  { "doku-gilde.de", true },
  { "dokuboard.com", true },
  { "dolarcanadense.com.br", true },
  { "dollarstore24.com", true },
  { "dollemore.com", true },
  { "dolphin-cloud.com", true },
  { "dolphin-hosting.com", true },
  { "dolphin-it.de", true },
  { "dolphincorp.co.uk", true },
  { "dolphinswithlasers.com", true },
  { "domadillo.com", true },
  { "domainexpress.de", true },
  { "domainkauf.de", true },
  { "domains.google.com", true },
  { "domainstaff.com", true },
  { "domfee.com", true },
  { "domhaase.me", true },
  { "dominikkulaga.pl", true },
  { "dominique-mueller.de", true },
  { "domodedovo.travel", true },
  { "donateaday.net", true },
  { "donmez.uk", false },
  { "donmez.ws", false },
  { "donner-reuschel.de", true },
  { "donnons.org", true },
  { "donotcall.gov", true },
  { "donotspellitgav.in", true },
  { "dontcageus.org", true },
  { "donthedragonwilson.com", true },
  { "doodledraw.ninja", true },
  { "doordecor.bg", true },
  { "dopost.it", true },
  { "doppenpost.nl", true },
  { "dorianharmans.nl", true },
  { "dorianmuthig.com", true },
  { "doridian.com", true },
  { "doridian.de", true },
  { "doridian.net", true },
  { "doridian.org", true },
  { "dossplumbing.co.za", true },
  { "dot.ro", true },
  { "dotbigbang.com", true },
  { "dotbox.org", true },
  { "dotsiam.com", true },
  { "doubleavineyards.com", true },
  { "doublefun.net", true },
  { "dougferris.id.au", true },
  { "dovecotadmin.org", true },
  { "dovetailnow.com", true },
  { "downloadsoftwaregratisan.com", true },
  { "downsouthweddings.com.au", true },
  { "doyoucheck.com", true },
  { "dpd.com.pl", true },
  { "dprd-wonogirikab.go.id", true },
  { "dpsg-roden.de", true },
  { "dr2dr.ca", true },
  { "dragon-chem.eu", true },
  { "dragonisles.net", true },
  { "dragons-of-highlands.cz", true },
  { "dragonschool.org", true },
  { "drahcro.uk", true },
  { "drainagebuizen.nl", true },
  { "drakefortreasurer.sexy", true },
  { "drakeluce.com", true },
  { "dramaticpeople.com", true },
  { "dranderle.com", true },
  { "dranek.com", true },
  { "draw.uy", true },
  { "drawesome.uy", true },
  { "drawingcode.net", true },
  { "drdevil.ru", true },
  { "dreadbyte.com", true },
  { "dreamcreator108.com", true },
  { "dreamlinehost.com", true },
  { "dreamsforabetterworld.com.au", true },
  { "dreamtechie.com", true },
  { "dreid.org", true },
  { "dreizwosechs.de", true },
  { "drew.red", true },
  { "dreweryinc.com", true },
  { "drhopeson.com", true },
  { "driesjtuver.nl", true },
  { "driftdude.nl", true },
  { "drino.org", false },
  { "drishti.guru", true },
  { "drive.google.com", true },
  { "drivenes.net", true },
  { "driving-lessons.co.uk", true },
  { "drkmtrx.xyz", true },
  { "drobniuch.pl", false },
  { "droidboss.com", true },
  { "droidwiki.de", false },
  { "dronepit.dk", true },
  { "droomhuis-in-friesland-kopen.nl", true },
  { "dropbox.com", true },
  { "dropboxer.net", true },
  { "drpetervoigt.de", true },
  { "drrr.chat", true },
  { "drtroyhendrickson.com", true },
  { "drugagodba.si", true },
  { "drumbandesperanto.nl", true },
  { "drumbe.at", true },
  { "drupal.org", true },
  { "drycreekphoto.com", true },
  { "dsbrowser.com", true },
  { "dsebastien.net", true },
  { "dsol.hu", true },
  { "dubrovskiy.net", true },
  { "dubrovskiy.pro", true },
  { "duckduckstart.com", true },
  { "ducohosting.com", true },
  { "duelysthub.com", true },
  { "duernberg.at", true },
  { "duesee.org", true },
  { "duijf.info", true },
  { "duijfathome.nl", true },
  { "dukun.de", true },
  { "dumino.bg", true },
  { "duncancmt.com", true },
  { "dunea.nl", true },
  { "duo.money", true },
  { "durangoenergyllc.com", true },
  { "duria.de", true },
  { "durys.be", true },
  { "dustri.org", true },
  { "dutch1.nl", true },
  { "dutchrank.com", true },
  { "dutchrank.nl", true },
  { "dutchwanderers.nl", true },
  { "dutchweballiance.nl", true },
  { "dutyfreeonboard.com", true },
  { "duuu.ch", true },
  { "dvbris.co.uk", true },
  { "dvbris.com", true },
  { "dvorupotocnych.sk", true },
  { "dvotx.org", true },
  { "dvwc.org", true },
  { "dwhd.org", true },
  { "dworzak.ch", true },
  { "dxa.io", true },
  { "dycontrol.de", true },
  { "dyeager.org", true },
  { "dynaloop.net", true },
  { "dynamicnet.net", true },
  { "dynamicsnetwork.net", true },
  { "dynamize.solutions", false },
  { "dyrenesverden.no", true },
  { "dziekonski.com", true },
  { "dzlibs.io", true },
  { "dzyabchenko.com", true },
  { "e-kontakti.fi", true },
  { "e-lifetechnology.com", true },
  { "e-mak.eu", true },
  { "e-teacher.pl", true },
  { "e-tmf.org", true },
  { "e-typ.eu", true },
  { "e.mail.ru", true },
  { "e3amn2l.com", true },
  { "e3kids.com", true },
  { "eagleridgecampground.com", true },
  { "eagletechz.com.br", true },
  { "eagleyecs.com", true },
  { "eames-clayton.us", true },
  { "earga.sm", true },
  { "earmarks.gov", true },
  { "eastmontgroup.com", true },
  { "easy-rpg.org", true },
  { "easyconstat.com", true },
  { "easycosmetic.ch", true },
  { "easykonto.de", true },
  { "easyplane.it", true },
  { "easypv.ch", true },
  { "easysimplecrm.com", false },
  { "eatery.co.il", true },
  { "eatlowcarb.de", true },
  { "eatsleeprepeat.net", true },
  { "eatvisor.co.uk", true },
  { "eauclairecommerce.com", true },
  { "eb7.jp", true },
  { "ebankcbt.com", true },
  { "ebanking.indovinabank.com.vn", true },
  { "ebcs-solutions.com", true },
  { "ebermannstadt.de", false },
  { "ebfe.pw", false },
  { "ebp2p.com", true },
  { "ebpglobal.com", true },
  { "ecake.in", true },
  { "ecchidreams.com", true },
  { "ecco-verde.com", true },
  { "ecdn.cz", true },
  { "ecfs.link", true },
  { "ecg.fr", false },
  { "echipstore.com", true },
  { "echomanchester.net", true },
  { "echosixmonkey.com", true },
  { "eckel.co", true },
  { "eckro.com", true },
  { "ecnetworker.com", true },
  { "ecogen.com.au", true },
  { "ecogen.net.au", true },
  { "econsumer.gov", true },
  { "ecorus.eu", true },
  { "ecosystem.atlassian.net", true },
  { "ecrimex.net", true },
  { "ectora.com", true },
  { "ecupcafe.com", false },
  { "ed.gs", true },
  { "edakoe.ru", true },
  { "edati.lv", true },
  { "edcphenix.tk", true },
  { "eddmixpanel.com", true },
  { "edelblack.ch", true },
  { "edesseglabor.hu", true },
  { "edgereinvent.com", true },
  { "edicct.com", true },
  { "ediscomp.sk", true },
  { "edissecurity.sk", true },
  { "edit.yahoo.com", false },
  { "edix.ru", true },
  { "edk.com.tr", true },
  { "edmundcelis.com", true },
  { "edoss.co.za", true },
  { "edp-collaborative.com", true },
  { "edpubs.gov", true },
  { "educationunlimited.com", true },
  { "educator-one.com", true },
  { "eduid.se", true },
  { "eduif.nl", true },
  { "eduroam.no", true },
  { "edvmesstec.de", true },
  { "edxg.de", true },
  { "edyou.eu", true },
  { "eelsden.net", true },
  { "eelzak.nl", true },
  { "eeqj.com", true },
  { "eery.de", true },
  { "ef.gy", true },
  { "eff.org", true },
  { "efficienthealth.com", true },
  { "effortlesshr.com", true },
  { "egfl.org.uk", true },
  { "egg-ortho.ch", true },
  { "egit.co", true },
  { "ego4u.com", true },
  { "ego4u.de", true },
  { "egretail.no", true },
  { "ehipaa.com", true },
  { "ehipaadev.com", true },
  { "ehrenamt-skpfcw.de", true },
  { "ehrlichesbier.de", true },
  { "ehuber.info", true },
  { "eichornenterprises.com", true },
  { "eickemeyer.nl", true },
  { "eimacs.com", true },
  { "einaros.is", true },
  { "einheizpreis.de", true },
  { "einsatzstellenverwaltung.de", true },
  { "eintageinzug.de", true },
  { "eirastudios.co.uk", false },
  { "eit-web.de", true },
  { "ejeff.org", true },
  { "ekbanden.nl", false },
  { "ekokontakt.cz", true },
  { "ekostecki.de", true },
  { "eksisozluk.com", true },
  { "ekzarta.ru", true },
  { "el-soul.com", true },
  { "elaintehtaat.fi", true },
  { "elanguest.pl", true },
  { "elanguest.ro", true },
  { "elanguest.ru", true },
  { "elars.de", true },
  { "elbetech.net", true },
  { "elearningpilot.com", true },
  { "electricant.com", true },
  { "electricant.nl", true },
  { "electricianforum.co.uk", true },
  { "electronic-ignition-system.com", true },
  { "electronicfasteners.com", true },
  { "eleicoes2016.com.br", true },
  { "elektropost.org", true },
  { "element-43.com", true },
  { "elemental.software", true },
  { "elementalrobotics.com", true },
  { "elemenx.com", true },
  { "elemprendedor.com.ve", true },
  { "elena-baykova.ru", true },
  { "elenag.ga", true },
  { "elephpant.cz", true },
  { "elglobo.com.mx", true },
  { "elgosblanc.com", true },
  { "eligible.com", true },
  { "eligibleapi.com", true },
  { "eligrey.com", true },
  { "elisa.ee", false },
  { "elisabeth-kostecki.de", true },
  { "elisabethkostecki.de", true },
  { "elite12.de", true },
  { "elitefishtank.com", false },
  { "elitegameservers.net", true },
  { "elitehosting.de", true },
  { "ella-kwikmed.com", true },
  { "ellegaard.dk", true },
  { "elliquiy.com", true },
  { "elliriehl.at", true },
  { "ellsinger.me", true },
  { "elmermx.ch", true },
  { "elnan.do", true },
  { "eloge.se", true },
  { "elonbase.com", true },
  { "elpo.net", true },
  { "elsamakhin.com", true },
  { "eltagroup.co.uk", true },
  { "elternforum-birmensdorf.ch", true },
  { "eluhome.de", true },
  { "elvidence.com.au", true },
  { "em-biotek.cz", true },
  { "emailfuermich.de", true },
  { "emailhunter.co", true },
  { "emailprivacytester.com", true },
  { "emaily.eu", true },
  { "emanuelduss.ch", true },
  { "embracethedarkness.co.uk", true },
  { "embroideryexpress.co.uk", true },
  { "emi-air-comprime.com", true },
  { "emielraaijmakers.nl", true },
  { "emilong.com", true },
  { "emilyhorsman.com", true },
  { "emilyshepherd.me", true },
  { "emirabiz.com", false },
  { "emjainteractive.com", true },
  { "empleosentorreon.mx", true },
  { "empowerdb.com", true },
  { "emprego.pt", true },
  { "emptypath.com", true },
  { "emrenovation.com", true },
  { "en-maktoob.search.yahoo.com", false },
  { "enaim.de", true },
  { "encfs.win", true },
  { "encircleapp.com", true },
  { "encnet.de", true },
  { "encoder.pw", true },
  { "encredible.de", true },
  { "encredible.org", true },
  { "encryptallthethings.net", true },
  { "encrypted.google.com", true },
  { "encryptedaudience.com", true },
  { "encryptio.com", true },
  { "end.pp.ua", true },
  { "ender.co.at", true },
  { "endlessdark.net", true },
  { "endlessdiy.ca", true },
  { "endlesshorizon.net", true },
  { "endlesstone.com", true },
  { "endofnet.org", true },
  { "endohaus.com", true },
  { "enecoshop.nl", true },
  { "enefan.jp", true },
  { "energiekeurplus.nl", true },
  { "energy-drink-magazin.de", true },
  { "energy-infra.nl", true },
  { "enfoqueseguro.com", true },
  { "engelundlicht.ch", true },
  { "engineeryourmarketing.com", true },
  { "englerts.de", true },
  { "englishbulgaria.net", true },
  { "englishclub.com", true },
  { "englishforums.com", true },
  { "enjen.net", true },
  { "enjoy-nepal.de", true },
  { "enlightenedhr.com", true },
  { "enloestatebank.com", true },
  { "enorekcah.com", true },
  { "enquos.com", true },
  { "enscosupply.com", true },
  { "ensemble-rubato.de", true },
  { "enskat.de", true },
  { "enskatson-sippe.de", true },
  { "ensured.com", true },
  { "ensured.nl", true },
  { "enteente.club", true },
  { "enteente.com", true },
  { "enteente.space", true },
  { "enteente.xyz", true },
  { "enterprisecarclub.co.uk", true },
  { "enterprisey.enterprises", true },
  { "entersynapse.com", false },
  { "enumify.com", true },
  { "envelope.co.nz", true },
  { "enveloppenopmaat.nl", true },
  { "enviam.de", true },
  { "envygeeks.com", true },
  { "envygeeks.io", true },
  { "eoldb.org", true },
  { "eopugetsound.org", true },
  { "epanurse.com", true },
  { "epay.bg", true },
  { "epaygateway.net", true },
  { "ephry.com", true },
  { "epicsecure.de", true },
  { "epicsoft.de", true },
  { "epostplus.li", true },
  { "epublibre.org", true },
  { "eq-serve.com", true },
  { "eqorg.com", true },
  { "equilibre-yoga-jennifer-will.com", true },
  { "equipsupply.com", true },
  { "erawanarifnugroho.com", true },
  { "erepublik-deutschland.de", true },
  { "ericdiao.com", true },
  { "erichorstmanshof.nl", true },
  { "ericwie.se", true },
  { "ericyl.com", true },
  { "erigrid.eu", true },
  { "eriix.org", true },
  { "erisrenee.com", true },
  { "ernesto.at", true },
  { "erp-band.ru", true },
  { "erp.band", true },
  { "erpband.ru", true },
  { "erpcargo.com", true },
  { "errlytics.com", true },
  { "errolz.com", true },
  { "errors.zenpayroll.com", false },
  { "ersindemirtas.com", true },
  { "eru.me", true },
  { "erudikum.cz", true },
  { "erwinwensveen.nl", true },
  { "es.search.yahoo.com", false },
  { "escalate.eu", true },
  { "escapees.com", true },
  { "esclear.de", true },
  { "escritoriodearte.com", true },
  { "esg-abi2001.de", true },
  { "esigmbh.de", true },
  { "esko.bar", true },
  { "eskriett.com", true },
  { "esn-ypci.com", true },
  { "esoa.net", true },
  { "esocweb.com", true },
  { "espacemontmorency.com", true },
  { "espanol.search.yahoo.com", false },
  { "espci.fr", true },
  { "espgg.org", true },
  { "espra.com", true },
  { "esquonic.com", true },
  { "ess-cert.ru", true },
  { "essentialoilsimports.com", true },
  { "esseriumani.com", true },
  { "essexghosthunters.co.uk", true },
  { "essoduke.org", true },
  { "estaleiro.org", true },
  { "esteam.se", true },
  { "estebanborges.com", true },
  { "estilosapeca.com", true },
  { "estrietoit.com", true },
  { "etaes.eu", true },
  { "etdonline.co.uk", true },
  { "eteesheet.com", true },
  { "etelej.com", true },
  { "eternitylove.us", true },
  { "eth0.nl", true },
  { "etha.nz", true },
  { "ethack.org", true },
  { "ethanfaust.com", true },
  { "ethercalc.com", true },
  { "ethercalc.org", true },
  { "etherpad.fr", true },
  { "ethicaldata.co.uk", true },
  { "ethicalexploiting.com", true },
  { "ethicall.org.uk", true },
  { "ethil-faer.fr", true },
  { "ethitter.com", true },
  { "ethlan.fr", true },
  { "ethosinfo.com", true },
  { "etkaddict.com", true },
  { "etrker.com", true },
  { "ets2mp.de", true },
  { "etula.ga", true },
  { "etula.me", true },
  { "etyd.org", true },
  { "euanbaines.com", true },
  { "eugenekay.com", true },
  { "eulenleben.de", true },
  { "eulerpi.io", true },
  { "euph.eu", true },
  { "euro.ro", true },
  { "europop.com", true },
  { "euroshop.or.at", true },
  { "euroshop24.net", true },
  { "eurostrategy.vn.ua", true },
  { "eurotramp.com", true },
  { "ev-zertifikate.de", true },
  { "eva.cz", true },
  { "evalesc.com", true },
  { "evantage.org", true },
  { "evantageglobal.com", true },
  { "evasovova.cz", true },
  { "evdenevenakliyatankara.pw", true },
  { "evegalaxy.net", true },
  { "eventaro.com", true },
  { "everhome.de", true },
  { "everling.lu", true },
  { "everwaking.com", true },
  { "everylab.org", true },
  { "everymove.org", true },
  { "everythingkitchens.com", false },
  { "eveseat.net", true },
  { "eveshamglass.co.uk", true },
  { "evi.be", true },
  { "evilized.de", true },
  { "evites.me", true },
  { "evolutionlending.co.uk", true },
  { "evomon.com", true },
  { "evossd.tk", true },
  { "evowl.com", false },
  { "evrial.com", true },
  { "evstatus.com", true },
  { "ewe2.ninja", true },
  { "ewie.name", true },
  { "exceltobarcode.com", true },
  { "excessamerica.com", true },
  { "exchangeworks.co", true },
  { "exekutori.com", true },
  { "exemples-de-stands.com", true },
  { "exeria.de", true },
  { "exfiles.cz", true },
  { "exgaywatch.com", true },
  { "exgravitus.com", true },
  { "exiahost.com", true },
  { "exno.co", true },
  { "exon.io", true },
  { "exoscale.ch", true },
  { "exoticads.com", true },
  { "expatads.com", true },
  { "experienceoz.com.au", true },
  { "experts-en-gestion.fr", true },
  { "explodie.org", true },
  { "exploit.cz", true },
  { "expo-asia.ru", true },
  { "expo-designers.com", true },
  { "express-vpn.com", true },
  { "expressemotion.net", true },
  { "expresshosting.org", true },
  { "expressvpn.com", true },
  { "expxkcd.com", true },
  { "extendwings.com", true },
  { "extracobanks.com", true },
  { "extranetpuc.com.br", true },
  { "extremenetworking.net", true },
  { "exy.pw", true },
  { "exyplis.com", true },
  { "eyasc.nl", true },
  { "eydesignguidelines.com", true },
  { "eyeonid.com", true },
  { "eytosh.net", true },
  { "eyyit.com", true },
  { "ez.fi", true },
  { "ezrefurb.co.uk", true },
  { "f-be.com", true },
  { "f-droid.org", true },
  { "f-s-u.co.uk", true },
  { "f2f.cash", true },
  { "fa-works.com", true },
  { "faber.org.ru", true },
  { "fabhub.io", true },
  { "fabianasantiago.com", true },
  { "fabienbaker.com", true },
  { "fableforge.nl", true },
  { "fabse.net", true },
  { "facebook.com", false },
  { "fachschaft-informatik.de", true },
  { "factor.cc", false },
  { "factorable.net", true },
  { "factuursturen.be", true },
  { "factuursturen.nl", true },
  { "factys.do", true },
  { "factys.es", true },
  { "fadednet.com", true },
  { "fadilus.com", true },
  { "faeriecakes.be", true },
  { "fahrenwal.de", true },
  { "failproof.be", true },
  { "fairbill.com", true },
  { "faircom.co.za", true },
  { "fairlyoddtreasures.com", true },
  { "faizan.net", true },
  { "faktura.pl", true },
  { "fakturi.com", true },
  { "fakturoid.cz", true },
  { "falconvintners.com", true },
  { "falkena.net", true },
  { "fallenangeldrinks.co.uk", true },
  { "fallenangeldrinks.com", true },
  { "fallenangeldrinks.eu", true },
  { "fallenangelspirits.co.uk", true },
  { "fallenangelspirits.com", true },
  { "fallenangelspirits.uk", true },
  { "fallenspirits.co.uk", true },
  { "falsum.net", true },
  { "familie-kupschke.de", true },
  { "familie-monka.de", true },
  { "familie-sander.rocks", true },
  { "familiegrottendieck.de", true },
  { "familieholme.de", true },
  { "familjenfrodlund.se", true },
  { "familjenm.se", true },
  { "fandomservices.com", true },
  { "fangs.ink", true },
  { "fanjoe.be", true },
  { "fant.dk", true },
  { "fanvoice.com", true },
  { "fanyue123.tk", true },
  { "fap.no", true },
  { "faq.lookout.com", false },
  { "faretravel.co.uk", true },
  { "fargtorget.se", true },
  { "farhood.org", true },
  { "farmacialaboratorio.it", true },
  { "fasdoutreach.ca", true },
  { "fashion.net", true },
  { "faspirits.co.uk", true },
  { "faspirits.com", true },
  { "fassadenverkleidung24.de", true },
  { "fasset.jp", true },
  { "fastaim.de", true },
  { "fastcomcorp.com", true },
  { "fastcomcorp.net", true },
  { "fastmail.com", false },
  { "fastopen.ml", true },
  { "fatlossguide.xyz", true },
  { "fatox.de", true },
  { "fatwin.pw", true },
  { "fatzebra.com.au", false },
  { "faucetbox.com", true },
  { "fawkex.me", true },
  { "fawong.com", true },
  { "fayolle.info", true },
  { "fbox.li", true },
  { "fca-tools.com", true },
  { "fcburk.de", true },
  { "fdj.im", true },
  { "fdsys.gov", false },
  { "fdt.name", true },
  { "fearsomegaming.com", true },
  { "fecik.sk", true },
  { "federalregister.gov", true },
  { "federicomigliavacca.it", true },
  { "fedorahosted.org", true },
  { "fedorapeople.org", true },
  { "fedrtc.org", true },
  { "fedux.com.ar", true },
  { "feedbin.com", false },
  { "feedhq.org", true },
  { "feedthebot.com", true },
  { "feel.aero", true },
  { "feen.us", true },
  { "feezmodo.com", true },
  { "feirlane.org", false },
  { "felisslovakia.sk", true },
  { "feliwyn.fr", false },
  { "felixrr.pro", true },
  { "feminists.co", true },
  { "fenno.net", true },
  { "fenteo.com", true },
  { "feragon.net", true },
  { "ferienhaus-polchow-ruegen.de", false },
  { "fernandes.org", true },
  { "fernandob.com", true },
  { "fernandobarillas.com", true },
  { "ferrugem.org", true },
  { "festrip.com", true },
  { "fetch.co.uk", true },
  { "feuerwehr-oberkotzau.de", true },
  { "fewo-thueringer-wald.de", true },
  { "fexco.com", true },
  { "ff-bad-hoehenstadt.de", true },
  { "ffbans.org", true },
  { "ffmradio.de", true },
  { "fhcdn.xyz", true },
  { "fi.google.com", true },
  { "fi.search.yahoo.com", false },
  { "ficus.io", true },
  { "fid.to", true },
  { "fidanza.eu", true },
  { "fidel.uk", true },
  { "fidelapp.com", true },
  { "fiendishmasterplan.com", true },
  { "fierlafijn.net", true },
  { "fierman.eu", true },
  { "fierman.net", true },
  { "fierman.us", true },
  { "fiftyshadesofluca.ml", true },
  { "fightr.co", true },
  { "figuurzagers.nl", true },
  { "fiilr.com", true },
  { "fiken.no", true },
  { "fiksel.info", true },
  { "fikt.space", true },
  { "file-pdf.it", true },
  { "filedir.com", false },
  { "filemeal.com", true },
  { "filestar.io", true },
  { "filhodohomem.com", true },
  { "filip-prochazka.com", true },
  { "filippo.io", true },
  { "fillmysuitca.se", true },
  { "filoo.de", true },
  { "financieringsportaal.nl", true },
  { "finanzkontor.net", true },
  { "finditez.com", true },
  { "findyour.diet", true },
  { "finenet.com.tw", true },
  { "finfev.de", true },
  { "fingent.com", true },
  { "finisron.in", true },
  { "finkelstein.fr", true },
  { "finn.io", true },
  { "finneas.net", true },
  { "finpt.com", true },
  { "fionamcbride.com", true },
  { "firebaseio-demo.com", true },
  { "firebaseio.com", true },
  { "firebird.io", true },
  { "firebirdrangecookers.com", true },
  { "firecore.com", false },
  { "firefall.rocks", true },
  { "firefart.at", false },
  { "firehost.com", true },
  { "firemail.io", true },
  { "fireorbit.de", true },
  { "firevap.org", true },
  { "firexarxa.de", true },
  { "firma-offshore.com", true },
  { "firmapi.com", true },
  { "first-time-offender.com", true },
  { "firstchoicecandy.com", true },
  { "firstderm.com", true },
  { "firstforex.co.uk", true },
  { "firstlook.org", true },
  { "firstmall.de", true },
  { "fischers.cc", true },
  { "fish-hook.ru", true },
  { "fit4medien.de", true },
  { "fitbylo.com", true },
  { "fitiapp.com", true },
  { "fitkram.cz", true },
  { "fitnesswerk.de", true },
  { "fittelo.cz", true },
  { "fitzsim.org", true },
  { "fivestarsitters.com", true },
  { "fiws.net", true },
  { "fixatom.com", true },
  { "fixhotsauce.com", true },
  { "fixmycomputerdude.com", true },
  { "fizz.buzz", true },
  { "fj.simple.com", false },
  { "flaemig42.de", true },
  { "flagspot.net", true },
  { "flajshans.cz", true },
  { "flamer-scene.com", false },
  { "flamewall.net", false },
  { "flamingcow.tv", true },
  { "flamingkeys.com", true },
  { "flamme-von-anor.de", true },
  { "flareon.net", true },
  { "flat.io", true },
  { "flawcheck.com", true },
  { "flawlesscowboy.xyz", true },
  { "flazznetworks.com", false },
  { "fletchto99.com", true },
  { "flexapplications.se", true },
  { "fleximus.org", false },
  { "flexinvesting.fi", true },
  { "flexport.com", true },
  { "flightschoolbooking.com", true },
  { "flipagram.com", false },
  { "flipkey.com", true },
  { "flipneus.net", true },
  { "flirchi.com", false },
  { "floaternet.com", true },
  { "flocktofedora.org", true },
  { "floobits.com", true },
  { "floorball-haunwoehr.de", true },
  { "floort.net", true },
  { "florence.uk.net", true },
  { "florent-tatard.fr", true },
  { "florian-schlachter.de", true },
  { "florianmitrea.uk", true },
  { "floridaescapes.co.uk", true },
  { "floridafieros.org", true },
  { "florismouwen.com", true },
  { "floskelwolke.de", true },
  { "flouartistique.ch", true },
  { "flow.pe", true },
  { "flow.su", true },
  { "flowersandclouds.com", true },
  { "floweslawncare.com", true },
  { "flowlo.me", true },
  { "flra.gov", true },
  { "fluidojobs.com", true },
  { "flukethoughts.com", true },
  { "fluxent.de", false },
  { "fluxfingers.net", true },
  { "fly.moe", true },
  { "flynn.io", true },
  { "flyserver.co.il", true },
  { "fmarchal.fr", true },
  { "fnb-griffinonline.com", true },
  { "fndout.com", true },
  { "fniephaus.com", true },
  { "fnordserver.eu", true },
  { "fnvsecurity.com", true },
  { "focusmark.jp", true },
  { "fokkusu.fi", true },
  { "folv.es", true },
  { "fondanastasia.ru", true },
  { "font-converter.net", true },
  { "food4health.guide", true },
  { "foodacademy.capetown", true },
  { "foodiebox.no", true },
  { "foodievenues.com", true },
  { "foodwise.marketing", true },
  { "footballmapped.com", true },
  { "foray-jero.me", true },
  { "forbook.net", true },
  { "fordbydesign.com", true },
  { "foreveralone.io", true },
  { "forewordreviews.com", true },
  { "forextimes.ru", true },
  { "forgix.com", true },
  { "formationseeker.com", true },
  { "formationsfactory.co.uk", false },
  { "formazioneopen.it", true },
  { "formbetter.com", true },
  { "formula.cf", true },
  { "foro.io", false },
  { "forodeespanol.com", true },
  { "forschbach-janssen.de", true },
  { "fortesanshop.it", true },
  { "fortnine.ca", true },
  { "fortress.sk", true },
  { "fortworth.ch", true },
  { "forum.linode.com", false },
  { "fossewaygardencentre.co.uk", true },
  { "fotocerita.net", true },
  { "fotofaerie.net", true },
  { "fotopasja.info", true },
  { "fotostudio-schweiz.ch", true },
  { "fotowettbewerb.co", true },
  { "fotowolfy.com", true },
  { "fourchin.net", true },
  { "foxbnc.co.uk", true },
  { "foxdev.co", true },
  { "foxelbox.com", true },
  { "foxley-farm.co.uk", true },
  { "foxley-seeds.co.uk", true },
  { "foxleyseeds.co.uk", true },
  { "foxtrot.pw", true },
  { "fpy.cz", true },
  { "fr.search.yahoo.com", false },
  { "fr33d0m.link", true },
  { "frack.nl", true },
  { "fragnic.com", true },
  { "fraho.eu", true },
  { "fralef.me", false },
  { "francescopalazzo.com", true },
  { "francevpn.xyz", true },
  { "franckgirard.net", true },
  { "frangor.info", true },
  { "frank.fyi", true },
  { "frankhaala.com", true },
  { "frankierprofi.de", true },
  { "franta.biz", true },
  { "franta.email", true },
  { "franzt.ovh", true },
  { "frasys.cloud", true },
  { "frasys.io", true },
  { "frasys.net", true },
  { "fraye.net", true },
  { "frederik-braun.com", true },
  { "fredvoyage.fr", true },
  { "free.com.tw", true },
  { "freeboson.org", true },
  { "freebus.org", true },
  { "freedom.press", false },
  { "freeform4u.de", true },
  { "freekdevries.nl", true },
  { "freelance.boutique", true },
  { "freelance.nl", true },
  { "freemanning.de", true },
  { "freematthale.net", true },
  { "freemedforms.com", true },
  { "freemyipod.org", true },
  { "freenetproject.org", true },
  { "freeshell.de", true },
  { "freesitemapgenerator.com", true },
  { "freesoftwaredriver.com", true },
  { "freesounding.com", true },
  { "freesounding.ru", true },
  { "freethought.org.au", true },
  { "freetsa.org", true },
  { "freeweibo.com", true },
  { "freifunk-essen.de", true },
  { "freifunk-luenen.de", true },
  { "freiwurst.net", true },
  { "freqlabs.com", true },
  { "fresh-hotel.org", true },
  { "fretscha.com", true },
  { "frezbo.com", true },
  { "frforms.com", true },
  { "frickelboxx.de", true },
  { "frickenate.com", true },
  { "fridolinka.cz", true },
  { "friendica.ch", true },
  { "frillip.com", true },
  { "frippz.se", true },
  { "fritzrepair.com", true },
  { "frizo.com", true },
  { "frly.de", true },
  { "frob.nl", true },
  { "frogatto.com", true },
  { "frogeye.fr", true },
  { "fromlemaytoz.com", true },
  { "fromscratch.rocks", true },
  { "fronteers.nl", true },
  { "frontisme.nl", true },
  { "frontmin.com", true },
  { "froot.se", true },
  { "froxlor.support", true },
  { "frtn.com", true },
  { "frtr.gov", true },
  { "fruchthof24.de", true },
  { "frugro.be", true },
  { "fruitusers.com", true },
  { "frusky.de", true },
  { "fsapubs.gov", true },
  { "fsbpaintrock.com", true },
  { "fsbturton.com", true },
  { "fsfi.is", true },
  { "fsm2016.org", true },
  { "ftc.gov", false },
  { "ftccomplaintassistant.gov", true },
  { "fteproxy.org", true },
  { "fugle.de", true },
  { "fuglede.dk", true },
  { "fukushima-web.com", true },
  { "fumiware.com", true },
  { "fumo.se", true },
  { "functions-online.com", true },
  { "fundacionhijosdelsol.org", true },
  { "fundays.nl", true },
  { "funderburg.me", true },
  { "fundingempire.com", true },
  { "funi4u.com", true },
  { "funnyang.com", true },
  { "funrun.com", true },
  { "furgo.love", true },
  { "furkancaliskan.com", true },
  { "furry.be", true },
  { "furry.dk", true },
  { "fusionmate.com", true },
  { "futbol11.com", true },
  { "futos.de", true },
  { "futuresonline.com", true },
  { "fuwafuwa.moe", true },
  { "fuzzing-project.org", true },
  { "fx5.de", true },
  { "fxp.co.il", true },
  { "fyn.nl", true },
  { "fysiohaenraets.nl", true },
  { "fzn.io", true },
  { "g-m-w.eu", true },
  { "g-marketing.ro", true },
  { "g-o.pl", true },
  { "g2a.co", true },
  { "g4w.co", true },
  { "g5led.nl", true },
  { "gabber.scot", true },
  { "gaelleetarnaud.com", true },
  { "gafachi.com", true },
  { "gagniard.org", true },
  { "gaichon.com", true },
  { "gaiserik.com", true },
  { "gakkainavi-epsilon.jp", true },
  { "gakkainavi-epsilon.net", true },
  { "gakkainavi.jp", true },
  { "gakkainavi.net", true },
  { "gakkainavi4.com", true },
  { "gakkainavi4.jp", true },
  { "gakkainavi4.net", true },
  { "galactic-crew.org", true },
  { "galenskap.eu", true },
  { "gam3rs.de", true },
  { "gamajo.com", true },
  { "gambit.pro", true },
  { "gambitnash.co.uk", true },
  { "gambitnash.com", true },
  { "gambitprint.com", true },
  { "game-files.net", true },
  { "game7.de", true },
  { "gamecard-shop.nl", true },
  { "gamecollector.be", true },
  { "gamedevelopers.pl", true },
  { "gamegix.com", true },
  { "gameisbest.jp", true },
  { "gamenected.com", true },
  { "gamenected.de", true },
  { "gamepad.vg", true },
  { "gameparade.de", true },
  { "gamercredo.com", true },
  { "gamercredo.net", true },
  { "gamers-life.fr", true },
  { "gamerslair.org", true },
  { "gamesurferapp.com", true },
  { "gamingmedia.eu", true },
  { "gamingreinvented.com", true },
  { "gamingzoneservers.com", true },
  { "gamishou.fr", true },
  { "gamoloco.com", true },
  { "gampenhof.de", true },
  { "gancedo.com.es", true },
  { "ganhonet.com.br", true },
  { "gar-nich.net", true },
  { "garagegoossens.be", true },
  { "garantieabschluss.de", false },
  { "garbage-juice.com", true },
  { "garedtech.com", true },
  { "garron.net", true },
  { "garyjones.co.uk", true },
  { "gasbarkenora.com", true },
  { "gasnews.net", true },
  { "gatapro.net", true },
  { "gateworld.fr", true },
  { "gatilagata.com.br", true },
  { "gaussorgues.me", false },
  { "gautvedt.no", true },
  { "gavick.com", true },
  { "gaytorrent.ru", true },
  { "gc-mc.de", true },
  { "gc.net", true },
  { "gcs-ventures.com", true },
  { "gcsepod.com", true },
  { "gdpventure.com", true },
  { "ge1.me", false },
  { "ge3k.net", true },
  { "geblitzt.de", true },
  { "gechr.io", true },
  { "gee.is", true },
  { "geek-hub.de", true },
  { "geek.com.tw", true },
  { "geekandi.com", true },
  { "geeklair.net", true },
  { "geekwu.org", true },
  { "geeky.software", true },
  { "geeq.ch", true },
  { "gehaowu.com", true },
  { "geli-graphics.com", true },
  { "gelog-software.de", true },
  { "gemeentemolenwaard.nl", true },
  { "gemeinfreie-lieder.de", true },
  { "gemini.com", true },
  { "gendrin.com", true },
  { "geneau.net", true },
  { "genehome.com.au", true },
  { "generali-worldwide.com", true },
  { "generationnext.pl", true },
  { "generic.cx", true },
  { "genossen.ru", true },
  { "genshiken-itb.org", true },
  { "genshiken.org", true },
  { "genslerwisp.com", true },
  { "genuu.com", true },
  { "genuxation.com", true },
  { "genuxtsg.com", true },
  { "genxbeats.com", true },
  { "genxnotes.com", true },
  { "genyhitch.com", true },
  { "geoip.fedoraproject.org", true },
  { "geoip.stg.fedoraproject.org", true },
  { "geolad.com", true },
  { "georgemaschke.com", true },
  { "georgemaschke.net", true },
  { "georgesonarthurs.com.au", true },
  { "georgmayer.eu", true },
  { "geoscan.aero", true },
  { "geraintwhite.co.uk", true },
  { "gerardozamudio.mx", true },
  { "gerencianet.com.br", false },
  { "gereon.ch", true },
  { "germandarknes.net", true },
  { "gernert-server.de", true },
  { "gersting.net", true },
  { "geschwinder.net", true },
  { "gesiwista.net", true },
  { "get-asterisk.ru", true },
  { "get-erp.ru", true },
  { "get.zenpayroll.com", false },
  { "getbox.me", true },
  { "getbutterfly.com", true },
  { "getcarina.com", true },
  { "getcloak.com", false },
  { "getcolor.com", true },
  { "getdash.io", true },
  { "getdigitized.net", true },
  { "geterp.ru", true },
  { "getfedora.org", true },
  { "getfittedstore.com", true },
  { "getflorence.co.uk", true },
  { "gethttpsforfree.com", true },
  { "getinternet.de", true },
  { "getkai.co.nz", true },
  { "getlolaccount.com", true },
  { "getmango.com", true },
  { "getnikola.com", true },
  { "getremembrall.com", true },
  { "getsello.com", false },
  { "getsensibill.com", true },
  { "getsetupfile.com", true },
  { "getspire.com", true },
  { "getsport.mobi", true },
  { "getts.ro", true },
  { "getvdownloader.com", true },
  { "gfhgiro.nl", true },
  { "gflclan.ru", true },
  { "gfm.tech", true },
  { "gfournier.ca", true },
  { "ggp2.com", true },
  { "ggservers.com", true },
  { "ggx.us", true },
  { "gha.st", true },
  { "ghcif.de", true },
  { "gheorghesarcov.ga", true },
  { "gheorghesarcov.tk", true },
  { "ghostblog.info", true },
  { "giacomopelagatti.it", true },
  { "giant-powerfit.co.uk", true },
  { "gianttree.de", true },
  { "giftgofers.com", true },
  { "giftservices.nl", true },
  { "giftsn.com.sg", false },
  { "gifzilla.net", false },
  { "gig.ru", false },
  { "gigacloud.org", true },
  { "gigacog.com", true },
  { "gigawa.lt", true },
  { "gijsbertus.com", true },
  { "gilcloud.com", true },
  { "gilgaz.com", true },
  { "gingali.de", true },
  { "ginja.co.th", true },
  { "gintenreiter-photography.com", true },
  { "ginzadelunch.jp", true },
  { "gipsic.com", true },
  { "girlsnet.work", true },
  { "gistfy.com", true },
  { "git.co", true },
  { "github.com", true },
  { "github.party", false },
  { "giveattheoffice.org", false },
  { "givemyanswer.com", true },
  { "givingnexus.org", false },
  { "gix.net.pl", true },
  { "gixtools.co.uk", true },
  { "gixtools.com", true },
  { "gixtools.net", true },
  { "gixtools.uk", true },
  { "gizzo.sk", true },
  { "gjcampbell.co.uk", true },
  { "gjspunk.de", true },
  { "gjung.com", false },
  { "glasgestaltung.biz", true },
  { "glass.google.com", true },
  { "glasschmuck-millefiori.de", true },
  { "glidingshop.cz", true },
  { "glidingshop.de", true },
  { "glidingshop.eu", true },
  { "glitchsys.com", true },
  { "glittersjabloon.nl", true },
  { "globalcomix.com", true },
  { "globalexpert.co.nz", true },
  { "globalgivingtime.com", true },
  { "globalinstitutefortraining.org.au", true },
  { "globalittech.com", false },
  { "globalmusic.ga", true },
  { "globalperspectivescanada.com", true },
  { "globalsites.nl", true },
  { "globuli-info.de", true },
  { "glossopnorthendafc.co.uk", true },
  { "glubbforum.de", true },
  { "gm-assicurazioni.it", true },
  { "gmail.com", false },
  { "gmcd.co", true },
  { "gmdu.net", true },
  { "gmta.nl", true },
  { "gmw-hannover.de", true },
  { "gmw-ingenieurbuero.de", true },
  { "gnetwork.eu", true },
  { "go-zh.org", true },
  { "go.xero.com", false },
  { "go2sh.de", true },
  { "go4it.solutions", true },
  { "goabonga.com", true },
  { "goalsetup.com", true },
  { "goaltree.ch", true },
  { "goat.xyz", true },
  { "goben.ch", true },
  { "gocardless.com", true },
  { "godesigner.ru", true },
  { "goerner.me", true },
  { "goerres2014.de", true },
  { "gofigure.fr", false },
  { "gogenenglish.com", true },
  { "gogetssl.com", true },
  { "goggs.eu", true },
  { "gohon.org", true },
  { "gokmenguresci.com", true },
  { "gold24.in", true },
  { "gold24.ru", true },
  { "goldendata.io", true },
  { "goldenhillsoftware.com", true },
  { "goldmark.com.au", true },
  { "goldpreisfinder.at", true },
  { "goldpros.com", true },
  { "goldsecurity.com", true },
  { "golf18network.com", true },
  { "golfscape.com", true },
  { "gonzalosanchez.mx", true },
  { "gooby.co", true },
  { "goodenough.nz", true },
  { "goodmengroup.de", true },
  { "google", true },
  { "googlemail.com", false },
  { "googleplex.com", true },
  { "gopay.cz", true },
  { "gordonobrecht.com", true },
  { "gorschenin.com", true },
  { "gosccs.com", true },
  { "gosharewood.com", true },
  { "goshop.cz", true },
  { "gospelvestcination.de", true },
  { "gostudy.net", true },
  { "gosuland.org", true },
  { "gotech.com.eg", true },
  { "gotgenes.com", true },
  { "gothamlimo.com", true },
  { "goto.google.com", true },
  { "gotocloud.ru", true },
  { "gotomi.info", true },
  { "gotspot.com", true },
  { "governorhub.com", true },
  { "govillemo.ca", true },
  { "govtrack.us", true },
  { "gowe.wang", false },
  { "gozel.com.tr", true },
  { "gpfclan.de", true },
  { "gplintegratedit.com", true },
  { "gpo.gov", false },
  { "gprs.uk.com", true },
  { "gps.com.br", true },
  { "gpsfix.cz", true },
  { "gpstuner.com", true },
  { "gr.search.yahoo.com", false },
  { "gra2.com", true },
  { "graasp.net", true },
  { "graavaapi.elasticbeanstalk.com", true },
  { "grace-wan.com", true },
  { "gracedays.org", true },
  { "gracesofgrief.com", false },
  { "graciousmay.com", true },
  { "grademypc.com", true },
  { "gradienthosting.co.uk", true },
  { "grafitec.ru", true },
  { "grafmurr.de", true },
  { "graingert.co.uk", true },
  { "grandcapital.id", true },
  { "grandcapital.ru", true },
  { "grandlinecsk.ru", true },
  { "grandmasfridge.org", true },
  { "grannyshouse.de", true },
  { "granth.io", true },
  { "granular.ag", true },
  { "graphire.io", true },
  { "grassenberg.de", true },
  { "gratisonlinesex.com", true },
  { "gravitechthai.com", true },
  { "gravito.nl", true },
  { "gravity-net.de", true },
  { "graycell.net", true },
  { "graymalk.in", true },
  { "grazetech.com", true },
  { "grc.com", false },
  { "grcnode.co.uk", true },
  { "greatfire.org", true },
  { "greatnet.de", true },
  { "greedbutt.com", true },
  { "greenhillantiques.co.uk", true },
  { "greenpeace-magazin.de", true },
  { "greenpeace.berlin", true },
  { "greenroach.ru", true },
  { "greensolid.biz", true },
  { "greenteamtwente.nl", true },
  { "gregmilton.com", true },
  { "gregmilton.org", true },
  { "gregorytlee.me", true },
  { "greiners.net", true },
  { "grepular.com", true },
  { "gresak.io", true },
  { "gresb.com", true },
  { "gretchelizartistry.com", true },
  { "greysolutions.it", true },
  { "grh.am", true },
  { "gribani.com", true },
  { "grieg-gaarden.no", true },
  { "grieg.com", true },
  { "grieg.no", true },
  { "griegfoundation.no", true },
  { "grieglogistics.no", true },
  { "griegshipbrokers.com", true },
  { "griegshipbrokers.no", true },
  { "griesser2.de", true },
  { "grigalanzsoftware.com", true },
  { "grimm-gastrobedarf.de", true },
  { "grimneko.de", true },
  { "gripopgriep.net", true },
  { "gritte.ch", true },
  { "grizzlys.com", true },
  { "grocock.me.uk", true },
  { "groetzner.net", true },
  { "grog.pw", true },
  { "grokker.com", true },
  { "groovinads.com", true },
  { "groovydisk.com", true },
  { "gropp.org", true },
  { "groseb.net", true },
  { "grossmann.gr", true },
  { "groszek.pl", true },
  { "groupebaillargeon.com", true },
  { "groups.google.com", true },
  { "grozip.com", true },
  { "grsecurity.net", true },
  { "grunex.com", true },
  { "gryffin.ga", true },
  { "gryffin.tk", true },
  { "grytics.com", true },
  { "gs-net.at", true },
  { "gsnort.com", true },
  { "gtamodshop.org", true },
  { "gtanda.tk", true },
  { "gtchipsi.org", true },
  { "gtldna.com", true },
  { "gtmasterclub.it", false },
  { "gtmetrix.com", true },
  { "gtraxapp.com", true },
  { "gts-schulsoftware.de", true },
  { "gudini.net", true },
  { "guerrilla.technology", true },
  { "guevener.de", true },
  { "guffr.it", true },
  { "gugaltika-ipb.org", true },
  { "gugga.dk", true },
  { "guguke.net", true },
  { "guidetoiceland.is", false },
  { "guillaumeperrin.io", true },
  { "guinea-pig.co", true },
  { "guineapigmustach.es", true },
  { "gulenbase.no", true },
  { "gunnaro.com", true },
  { "guntbert.net", true },
  { "gunwatch.co.uk", true },
  { "guoqiang.info", true },
  { "guphi.net", true },
  { "gurkan.in", true },
  { "gurochan.ch", true },
  { "gurom.lv", true },
  { "guru-naradi.cz", true },
  { "gurueffect.com", true },
  { "gurusupe.com", true },
  { "gussi.is", true },
  { "guthabenkarten-billiger.de", true },
  { "guts.me", true },
  { "guvernalternativa.ro", true },
  { "gvt2.com", true },
  { "gvt3.com", true },
  { "gw2treasures.com", true },
  { "gwtest.us", true },
  { "gyboche.com", true },
  { "gyboche.science", true },
  { "gycis.me", true },
  { "gyz.io", true },
  { "gz-architekten.de", true },
  { "gz-benz.com", true },
  { "gz-bmw.com", true },
  { "h-jo.net", true },
  { "h2check.org", true },
  { "h404bi.com", true },
  { "haarkliniek.com", true },
  { "habanaavenue.com", true },
  { "habarisoft.com", true },
  { "hablemosdetecnologia.com.ve", false },
  { "hachre.de", false },
  { "hack.cz", true },
  { "hack.li", true },
  { "hackcraft.net", true },
  { "hackenkunjeleren.nl", true },
  { "hackenturet.dk", true },
  { "hacker.one", true },
  { "hackerforever.com", true },
  { "hackernet.se", true },
  { "hackerone-user-content.com", true },
  { "hackerone.com", true },
  { "hackest.org", true },
  { "hackit.im", true },
  { "hackmd.io", true },
  { "hackthissite.org", true },
  { "hadleighswimmingclub.co.uk", true },
  { "hadzic.co", true },
  { "haeckdesign.com", true },
  { "haeckl.eu", true },
  { "hafniatimes.com", true },
  { "haircrazy.com", true },
  { "haitschi.com", true },
  { "haitschi.de", true },
  { "haitschi.net", true },
  { "haitschi.org", true },
  { "hakase.kr", true },
  { "haktec.de", true },
  { "haku.moe", false },
  { "hakugin.org", true },
  { "hallelujahsoftware.com", true },
  { "hallmarkestates.ca", true },
  { "halo.fr", true },
  { "hamali.bg", true },
  { "haman.nl", true },
  { "hana.ondemand.com", true },
  { "handiworker.com", true },
  { "handmadetutorials.ro", true },
  { "hangouts.google.com", true },
  { "hannover-banditen.de", true },
  { "hansen.hn", true },
  { "hansvaneijsden.com", true },
  { "hansvaneijsden.nl", true },
  { "hanu.la", true },
  { "haomwei.com", true },
  { "haozi.me", true },
  { "happyandrelaxeddogs.eu", true },
  { "happycoder.net", true },
  { "happygadget.me", true },
  { "happygastro.com", true },
  { "happylifestyle.com", true },
  { "happyteamlabs.com", true },
  { "happytiger.eu", true },
  { "happyukgo.com", true },
  { "harabuhouse.com", true },
  { "harbor-light.net", true },
  { "hardeman.nu", true },
  { "hardertimes.com", true },
  { "hardfalcon.net", true },
  { "hardh.at", true },
  { "hardline.xyz", true },
  { "harmoney.co.nz", true },
  { "harmoney.com", true },
  { "harmoney.com.au", true },
  { "harmonycosmetic.com", true },
  { "harringtonca.com", true },
  { "harrisonsand.com", false },
  { "harrisonsdirect.co.uk", true },
  { "harristony.com", true },
  { "hartie95.de", true },
  { "hartlep.email", true },
  { "harvestapp.com", true },
  { "harvester.fr", false },
  { "harvestrenewal.org", true },
  { "haselsteiner.me", true },
  { "hashiconf.com", true },
  { "hashicorp.com", true },
  { "hashimah.ca", true },
  { "hashnode.com", true },
  { "hashplex.com", true },
  { "hashru.nl", true },
  { "hashworks.net", true },
  { "hasinase.de", false },
  { "haskovec.com", true },
  { "haste.ch", true },
  { "hastherebeenamassshooting.today", true },
  { "hatcherlawgroupnm.com", true },
  { "hatoko.net", true },
  { "haucke.xyz", true },
  { "haufschild.de", true },
  { "hauntedfishtank.com", true },
  { "hausarzt-stader-str.de", true },
  { "hausverbrauch.de", true },
  { "haveeruexaminer.com", true },
  { "haveibeenpwned.com", true },
  { "havellab.de", true },
  { "havelland-obstler.de", true },
  { "hawkeyeinsight.com", true },
  { "hawksguild.com", true },
  { "haxo.nl", false },
  { "hazcod.com", true },
  { "hboeck.de", true },
  { "hbpowell.com", true },
  { "hcie.pl", true },
  { "hcs-company.com", true },
  { "hd-gaming.com", true },
  { "hd-offensive.at", true },
  { "hda.me", true },
  { "hdc.cz", true },
  { "hdeaves.uk", true },
  { "hdfgroup.org", true },
  { "hdhoang.space", true },
  { "hdm.io", true },
  { "hdrboundless.com", true },
  { "hds-lan.de", true },
  { "hdsmigrationtool.com", true },
  { "hduin.xyz", true },
  { "hdwallpapers.net", true },
  { "head.org", true },
  { "healthcare.gov", false },
  { "healtheffectsofasbestos.com", true },
  { "healthfoam.com", true },
  { "healthiercompany.com", true },
  { "heartmdinstitute.com", true },
  { "heartsucker.com", true },
  { "heathmanners.com", true },
  { "heavensinferno.net", true },
  { "heavystresser.com", true },
  { "hebikhiv.nl", true },
  { "hec.global", true },
  { "hedgeschool.ie", true },
  { "hegen.com.pl", true },
  { "heh.ee", true },
  { "heha.co", false },
  { "heid.ws", true },
  { "heijblok.com", true },
  { "heinpost.nl", true },
  { "heissluft-fritteuse.com", true },
  { "hejahanif.se", true },
  { "hejsupport.se", true },
  { "hele.cz", true },
  { "helgakristoffer.com", true },
  { "helgakristoffer.wedding", true },
  { "helichat.de", true },
  { "helix.am", true },
  { "hellersgas.com", true },
  { "helloacm.com", true },
  { "helloanselm.com", true },
  { "hellotandem.com", true },
  { "hellscanyonraft.com", true },
  { "help.simpletax.ca", false },
  { "helpadmin.net", true },
  { "helpconnect.com.au", true },
  { "helpgoabroad.com", true },
  { "helpium.de", true },
  { "hemlockhillscabinrentals.com", true },
  { "hencagon.com", true },
  { "hennadesigns.org", true },
  { "hennymerkel.com", true },
  { "henok.eu", true },
  { "henriknoerr.com", true },
  { "henriksen.is", true },
  { "henrock.net", true },
  { "henryphan.com", false },
  { "hentschke-bau.de", true },
  { "hentschke-invest.de", true },
  { "heppler.net", true },
  { "hepteract.us", true },
  { "herbandpat.org", true },
  { "herbert.io", true },
  { "herbertmouwen.nl", true },
  { "heritagedentistry.ca", true },
  { "hermes-net.de", true },
  { "herocentral.de", true },
  { "herpaderp.net", true },
  { "herr-webdesign.de", true },
  { "herrenfahrt.com", true },
  { "herrsmith.com", true },
  { "herzbotschaft.de", true },
  { "hetmer.com", true },
  { "heute-kaufen.de", true },
  { "heutger.net", true },
  { "hex2013.com", true },
  { "hexicurity.com", true },
  { "hexo.io", true },
  { "hexony.com", true },
  { "heycms.com", true },
  { "heyfringe.com", true },
  { "heyguevara.com", true },
  { "hg.python.org", true },
  { "hhhdb.com", true },
  { "hhmmmm.de", true },
  { "hibilog.com", true },
  { "hicl.org", true },
  { "hicn.gq", true },
  { "hicoria.com", true },
  { "hiddendepth.ie", true },
  { "hiddenmail.xyz", true },
  { "hiexmerida-mailing.com", true },
  { "higgstools.org", true },
  { "highseer.com", true },
  { "highvelocitydesign.com", true },
  { "higp.de", true },
  { "hiisukun.com", true },
  { "hikariempire.com", true },
  { "hilahdih.cz", true },
  { "hilti.at", true },
  { "hilti.ca", true },
  { "hilti.cl", true },
  { "hilti.co.jp", true },
  { "hilti.co.kr", true },
  { "hilti.co.uk", true },
  { "hilti.com", true },
  { "hilti.com.ar", true },
  { "hilti.com.au", true },
  { "hilti.com.br", true },
  { "hilti.com.hk", true },
  { "hilti.com.sg", true },
  { "hilti.de", true },
  { "hilti.ee", false },
  { "hilti.es", true },
  { "hilti.fi", true },
  { "hilti.fr", true },
  { "hilti.ie", true },
  { "hilti.it", true },
  { "hilti.kz", false },
  { "hilti.lu", true },
  { "hilti.lv", false },
  { "hilti.pt", true },
  { "hilti.ru", true },
  { "hilti.sk", true },
  { "hiphop.ren", true },
  { "hiphopconvention.nl", true },
  { "hippies.com.br", true },
  { "hipstercat.fr", true },
  { "hirake55.com", true },
  { "hisbrucker.net", true },
  { "history.google.com", false },
  { "hittipps.com", true },
  { "hiv.gov", true },
  { "hjw-kunstwerk.de", true },
  { "hk.search.yahoo.com", false },
  { "hlavacek.us", true },
  { "hledejpravnika.cz", true },
  { "hlfh.space", true },
  { "hmm.nyc", false },
  { "hmsseahawk.com", true },
  { "hobby-gamerz-community.de", true },
  { "hobbyspeed.com", true },
  { "hochhaus.us", true },
  { "hochzeit-dana-laurens.de", true },
  { "hodne.io", true },
  { "hoffmeister.biz", true },
  { "holifestival-freyung.de", true },
  { "holisticon.de", true },
  { "hollowrap.com", true },
  { "holmesian.org", true },
  { "holo.ovh", true },
  { "holofono.com", true },
  { "holyhiphopdatabase.com", true },
  { "holzheizer-forum.de", true },
  { "holzheizerforum.de", true },
  { "holzvergaser-forum.de", true },
  { "homads.com", false },
  { "homecareassociatespa.com", true },
  { "homedna.com", true },
  { "homehunting.pt", true },
  { "homeprivate.de", true },
  { "homeseller.co.uk", true },
  { "homeseller.com", true },
  { "homewatt.co.uk", true },
  { "homeyou.com", true },
  { "homophoni.com", true },
  { "hompus.nl", false },
  { "honda-centrum.cz", true },
  { "hondart.cz", true },
  { "honeybadger.io", false },
  { "honeybeard.co.uk", true },
  { "honeycome.net", true },
  { "honoo.com", true },
  { "hoodoo.io", true },
  { "hoodoo.tech", true },
  { "hooowl.com", true },
  { "hooray.beer", true },
  { "hopesb.org", true },
  { "hopewellproperties.co.uk", true },
  { "hopps.me", true },
  { "horstmanshof.eu", true },
  { "horvathd.eu", true },
  { "horvathtom.com", true },
  { "horza.org", true },
  { "hoshinplan.com", true },
  { "hoshisato.com", true },
  { "hosiet.me", true },
  { "hosmussynergie.nl", true },
  { "hostam.link", true },
  { "hostanalyticsconsulting.com", true },
  { "hosteasy.nl", true },
  { "hostedbgp.net", true },
  { "hostedtalkgadget.google.com", true },
  { "hostelite.com", true },
  { "hostingactive.it", true },
  { "hostingfj.com", true },
  { "hostinghelp.guru", true },
  { "hostinginnederland.nl", true },
  { "hostisan.com", true },
  { "hostix.de", true },
  { "hostmijnpagina.nl", true },
  { "hotchillibox.co.za", true },
  { "hotel-pension-sonnalp.eu", true },
  { "hotel-tongruben.de", true },
  { "hotelmap.com", true },
  { "hotelvictoriaoax-mailing.com", true },
  { "hotelvillahermosa-mailing.com", true },
  { "hoton.in", true },
  { "hotting.nl", true },
  { "housemaadiah.org", true },
  { "houser.lu", true },
  { "housingstudents.org.uk", true },
  { "hovie.at", true },
  { "howbehealthy.com", true },
  { "howrandom.org", true },
  { "howsmyssl.com", true },
  { "howsmytls.com", true },
  { "hozana.si", false },
  { "hpac-portal.com", true },
  { "hpisavageforum.com", true },
  { "hpkp-faq.de", true },
  { "hqhost.net", true },
  { "hr-intranet.com", true },
  { "hrackydomino.cz", true },
  { "hranicka.cz", true },
  { "hrbatypes.cz", true },
  { "hrobert.hu", true },
  { "hroschyk.cz", true },
  { "hs-group.net", true },
  { "hscorp.de", true },
  { "hsir.me", true },
  { "hsmr.cc", true },
  { "hsr.gov", false },
  { "hsts.date", true },
  { "hstsfail.appspot.com", true },
  { "hstspreload.appspot.com", true },
  { "htaccessbook.com", true },
  { "html5.org", true },
  { "htmlacademy.ru", true },
  { "htmue.org", true },
  { "http418.xyz", true },
  { "httpsecurityreport.com", true },
  { "httpswatch.com", true },
  { "huagati.com", true },
  { "huang.nu", true },
  { "huaxueba.com", true },
  { "huersch.com", true },
  { "huffduffer.com", true },
  { "hugocollignon.fr", true },
  { "hugosleep.com.au", true },
  { "huiser.nl", true },
  { "humankode.com", true },
  { "humblefinances.com", true },
  { "humeurs.net", true },
  { "humpi.at", true },
  { "humpteedumptee.in", true },
  { "hund.io", true },
  { "huntshomeinspections.com", true },
  { "hup.blue", true },
  { "hupp.se", true },
  { "hurd.is", true },
  { "huren.nl", true },
  { "husakbau.at", true },
  { "hushfile.it", true },
  { "husky.xyz", true },
  { "huskybutt.dog", true },
  { "huskyinc.us", true },
  { "hussam.eu.org", true },
  { "hwag-pb.de", true },
  { "hx53.de", true },
  { "hxying.com", true },
  { "hydrocloud.net", true },
  { "hydrozone.fr", true },
  { "hyk.me", true },
  { "hymerscollege.co.uk", true },
  { "hypemgmt.com", true },
  { "hyper-text.org", true },
  { "i--b.com", true },
  { "i-jp.net", true },
  { "i-stats.net", true },
  { "i10z.com", false },
  { "i5y.co.uk", true },
  { "iactu.info", true },
  { "iainsimms.me", true },
  { "iamcarrico.com", true },
  { "iamokay.nl", true },
  { "ian.sh", true },
  { "ianix.com", true },
  { "iapws.com", true },
  { "ib-wedler.de", true },
  { "iba.community", true },
  { "iban.is", true },
  { "ibarf.nl", true },
  { "ibnuwebhost.com", true },
  { "ibron.co", false },
  { "icarlos.net", true },
  { "icebat.dyndns.org", true },
  { "iceloch.com", true },
  { "icfl.com.br", true },
  { "ichoosebtec.com", true },
  { "ichronos.net", true },
  { "icpc2016.in.th", true },
  { "icq-project.net", true },
  { "ict-concept.nl", true },
  { "ictinforensics.org", true },
  { "ictual.com", true },
  { "icusignature.com", true },
  { "id-co.in", true },
  { "id-conf.com", false },
  { "id.atlassian.com", true },
  { "id.fedoraproject.org", false },
  { "id.mayfirst.org", false },
  { "id.search.yahoo.com", false },
  { "id0-rsa.pub", true },
  { "idacmedia.com", true },
  { "idahoansforliberty.net", true },
  { "idaspis.com", true },
  { "ideadozz.hu", true },
  { "ideasmeetingpoint.com", true },
  { "ideation-inc.co.jp", true },
  { "ideaweb.de", true },
  { "idedr.com", true },
  { "idensys.nl", true },
  { "identitytheft.gov", true },
  { "idgard.de", true },
  { "idgsupply.com", true },
  { "idiopolis.org", true },
  { "idlekernel.com", true },
  { "idndx.com", true },
  { "idoc24.com", true },
  { "idolf.dk", true },
  { "idontexist.me", true },
  { "idontplaydarts.com", true },
  { "idvl.de", true },
  { "iec.pe", false },
  { "ieeespmb.org", true },
  { "ies-italia.it", true },
  { "ies.id.lv", true },
  { "ieval.ro", true },
  { "ifasec.de", false },
  { "ifcfg.me", true },
  { "ifconfig.co", true },
  { "iflare.de", true },
  { "ifleurs.com", true },
  { "ifoss.me", true },
  { "ifxor.com", true },
  { "igforums.com", true },
  { "iggprivate.com", true },
  { "iggsoft.com", true },
  { "iggsoftware.com", true },
  { "igiftcards.nl", true },
  { "igk.de", true },
  { "igotoffer.com", true },
  { "igrivi.com", true },
  { "ihrlotto.de", true },
  { "ihrnationalrat.ch", true },
  { "ihsbsd.me", true },
  { "iirii.com", true },
  { "iispeed.com", true },
  { "ijsclubtilburg.nl", true },
  { "ikeyless.com", true },
  { "ikk.me", true },
  { "ikkatsu-satei.jp", true },
  { "iklive.org", true },
  { "ikocik.sk", true },
  { "ikon.name", true },
  { "ikvts.de", true },
  { "ikwilguidobellen.nl", true },
  { "ilbuongiorno.it", true },
  { "ile-kalorii.pl", true },
  { "ilhadocaranguejo.com.br", true },
  { "ilikerainbows.co", true },
  { "ilikerainbows.co.uk", false },
  { "illegalpornography.me", true },
  { "illorenese.fr", true },
  { "ilrg.com", true },
  { "iltisim.ch", true },
  { "iluvscotland.co.uk", true },
  { "im-c-shop.com", true },
  { "im2net.com", true },
  { "imagefu.com", true },
  { "imagescostumes.com", true },
  { "imaginary.ca", true },
  { "imagr.io", true },
  { "imanolbarba.net", true },
  { "imbrian.org", true },
  { "imedikament.de", true },
  { "imeds.pl", true },
  { "imgg.es", true },
  { "imguoguo.com", true },
  { "imguploaden.nl", true },
  { "imirhil.fr", true },
  { "imjad.cn", true },
  { "imjiangtao.com", true },
  { "imlonghao.com", true },
  { "immaterium.de", true },
  { "immigrationdirect.com.au", true },
  { "immobilier-nice.fr", true },
  { "immoprotect.ca", true },
  { "immortals-co.com", false },
  { "immoverkauf24.at", true },
  { "immoverkauf24.de", true },
  { "immunicity.eu", true },
  { "immunicity.info", true },
  { "imoni-blog.net", true },
  { "imperialwebsolutions.com", true },
  { "impex.com.bd", true },
  { "imququ.com", true },
  { "imreh.net", true },
  { "imrejonk.nl", true },
  { "imu.li", true },
  { "in-depthoutdoors.com", true },
  { "in-flames.com", true },
  { "in.search.yahoo.com", false },
  { "in.xero.com", false },
  { "inabox.ro", true },
  { "inb4.us", true },
  { "inbitcoin.it", true },
  { "inbounder.io", true },
  { "inbox-group.com", true },
  { "inbox.google.com", true },
  { "inboxen.org", true },
  { "incendiary-arts.com", true },
  { "inche-ali.com", true },
  { "incparadise.net", true },
  { "indicateurs-flash.fr", true },
  { "indiecert.net", false },
  { "indievelopment.nl", true },
  { "indoorskiassen.nl", true },
  { "indovinabank.com.vn", true },
  { "indredouglas.me", true },
  { "indusfastremit-ca.com", true },
  { "indusfastremit-us.com", true },
  { "indusfastremit.com", true },
  { "industreiler.com", true },
  { "indybay.org", true },
  { "infilock.com", true },
  { "infinitusgaming.eu", true },
  { "influxus.com", false },
  { "infmed.com", true },
  { "infogrfx.com", true },
  { "informatiebeveiliging.nl", true },
  { "informatik.zone", true },
  { "informnapalm.org", true },
  { "infosec.ch", true },
  { "infosenior.ch", true },
  { "infra-con.dk", true },
  { "iniiter.com", true },
  { "inios.fr", true },
  { "initq.net", false },
  { "initrd.net", true },
  { "injigo.com", true },
  { "inkable.com.au", true },
  { "inkbunny.net", true },
  { "inksay.com", true },
  { "inleaked.com", true },
  { "inmyarea.com", true },
  { "innophate-security.com", true },
  { "innophate-security.nl", true },
  { "innovaptor.at", true },
  { "innovaptor.com", true },
  { "inovatec.com", true },
  { "insane.zone", true },
  { "insideaudit.com", true },
  { "insightera.co.th", true },
  { "insighti.com", true },
  { "insighti.eu", true },
  { "insighti.org", true },
  { "insighti.sk", true },
  { "inspire-av.com", true },
  { "inspiroinc.com", true },
  { "inspy.me", true },
  { "instant-hack.com", true },
  { "instant.io", true },
  { "instantdev.io", true },
  { "instasex.ch", true },
  { "instela.com", true },
  { "institutoflordelavida.com", true },
  { "institutolancaster.com", true },
  { "intarweb.ca", true },
  { "integrationinc.com", false },
  { "integrityingovernmentidaho.com", true },
  { "integromat.com", true },
  { "intel.li", true },
  { "intelldynamics.com", true },
  { "intellectdynamics.com", true },
  { "interaffairs.com", true },
  { "interasistmen.se", true },
  { "interfug.de", true },
  { "interim-cto.de", true },
  { "interisaudit.com", true },
  { "intermedinet.nl", true },
  { "internect.co.za", true },
  { "internetbank.swedbank.se", true },
  { "internetbugbounty.org", true },
  { "internetcasinos.de", true },
  { "internetdentalalliance.com", true },
  { "internethering.de", true },
  { "internetofdon.gs", true },
  { "internetpro.me", true },
  { "internetzentrale.net", true },
  { "internl.net", true },
  { "interociter-enterprises.com", true },
  { "interviewpipeline.co.uk", true },
  { "intervisteperstrada.com", true },
  { "interways.de", true },
  { "intim-uslugi-kazan.net", true },
  { "intimateperrierjouet.com", true },
  { "intocities.de", false },
  { "inton.biz", true },
  { "intramanager.co.uk", true },
  { "intramanager.dk", true },
  { "intranetsec.fr", true },
  { "intrasoft.com.au", true },
  { "intxt.net", true },
  { "inusasha.de", true },
  { "investorforms.com", true },
  { "invictusmc.uk", true },
  { "invoicefinance.nl", true },
  { "inwestcorp.se", true },
  { "inzdr.com", true },
  { "iocheck.com", false },
  { "iodu.re", true },
  { "iolife.dk", true },
  { "iompost.com", true },
  { "iomstamps.com", true },
  { "ionas-law.ro", false },
  { "ionc.ca", true },
  { "ionlabs.kr", true },
  { "ionx.co.uk", true },
  { "iosmods.com", true },
  { "iossifovlab.com", true },
  { "iotsms.io", true },
  { "ip-life.net", true },
  { "ip2country.info", true },
  { "ip6.li", true },
  { "ipal.im", true },
  { "ipal.name", true },
  { "ipcfg.me", true },
  { "ipconsulting.se", true },
  { "iplabs.de", true },
  { "ipledgeonline.org", false },
  { "ipmotion.ca", true },
  { "ipokabu.net", true },
  { "ipomue.com", false },
  { "iprice.co.id", true },
  { "iprice.hk", true },
  { "iprice.my", true },
  { "iprice.ph", true },
  { "iprice.sg", true },
  { "iprice.vn", true },
  { "ipricethailand.com", true },
  { "iprim.ru", true },
  { "iprody.com", true },
  { "ipsec.pl", true },
  { "ipswitch.com.tw", true },
  { "iptel.by", false },
  { "iptel.ro", true },
  { "ipv6-adresse.dk", true },
  { "ipv6-handbuch.de", true },
  { "ipv6cloud.club", true },
  { "iqboxy.com", true },
  { "iqcn.co", true },
  { "iranianlawschool.com", true },
  { "irazimina.ru", true },
  { "ircmett.de", true },
  { "iready.ro", true },
  { "ireef.tv", true },
  { "irelandesign.com", true },
  { "irgit.pl", true },
  { "iridiumbrowser.de", true },
  { "iridiumflare.de", true },
  { "irische-segenswuensche.info", true },
  { "irmag.ru", true },
  { "ironfistdesign.com", true },
  { "isaacman.tech", true },
  { "isbengrumpy.com", true },
  { "isdown.cz", true },
  { "iseek.biz", true },
  { "iseulde.com", true },
  { "isimonbrown.co.uk", true },
  { "isincheck.com", true },
  { "isitamor.pm", true },
  { "isitchristmas.com", true },
  { "isitup.org", true },
  { "iskaron.de", true },
  { "islandhosting.com", true },
  { "isletech.net", true },
  { "isogen5.com", true },
  { "isondo.com", true },
  { "isopres.de", true },
  { "isqrl.de", true },
  { "israkurort.com", true },
  { "isreedyintheuk.com", true },
  { "isslshop.com", true },
  { "issuesofconcern.in", true },
  { "istanbul.systems", true },
  { "istanbultravelguide.info", true },
  { "istaspirtslietas.lv", true },
  { "istdieweltschonuntergegangen.de", true },
  { "istheapplestoredown.com", true },
  { "istheapplestoredown.de", true },
  { "istorrent.is", true },
  { "it-go.net", true },
  { "it-schwerin.de", true },
  { "it.search.yahoo.com", false },
  { "itb-online.co.uk", true },
  { "itcko.sk", true },
  { "itdashboard.gov", true },
  { "iterror.co", true },
  { "itfh.eu", true },
  { "itforge.nl", true },
  { "itinsight.hu", true },
  { "itis4u.ch", true },
  { "itludens.com", true },
  { "itnota.com", true },
  { "itos.asia", true },
  { "itos.pl", true },
  { "itpol.dk", true },
  { "itriskltd.com", true },
  { "its-gutachten.de", true },
  { "its-v.de", true },
  { "its4living.com", true },
  { "itsadog.co.uk", true },
  { "itsagadget.com", true },
  { "itsecguy.com", true },
  { "itsg-faq.de", true },
  { "itshost.ru", true },
  { "ivancacic.com", true },
  { "ivi-fertility.com", true },
  { "ivi.es", true },
  { "ivk.website", true },
  { "ivpn.net", true },
  { "iwalton.com", true },
  { "iwannarefill.com", true },
  { "iwilcox.me.uk", true },
  { "iwizerunek.pl", true },
  { "iww.mx", true },
  { "ix8.ru", true },
  { "ixds.org", true },
  { "izdiwho.com", true },
  { "izzzorgconcerten.nl", true },
  { "j-lsolutions.com", true },
  { "j-navi.com", true },
  { "j0s.eu", true },
  { "j15t98j.co.uk", true },
  { "j3e.de", true },
  { "ja-dyck.de", true },
  { "ja-publications.com", true },
  { "jaba.hosting", true },
  { "jabbari.io", true },
  { "jabber.at", true },
  { "jacekowski.org", true },
  { "jackdelik.de", true },
  { "jackf.me", true },
  { "jackfahnestock.com", true },
  { "jackyyf.com", false },
  { "jaclynjohnson.com", true },
  { "jacobhaug.com", true },
  { "jacobparry.ca", false },
  { "jacobphono.com", true },
  { "jacuzziprozone.com", true },
  { "jagerman.com", true },
  { "jagido.de", true },
  { "jahliveradio.com", false },
  { "jahofmann.de", true },
  { "jaimechanaga.com", true },
  { "jaispirit.com", true },
  { "jakenbake.com", true },
  { "jaketremper.com", true },
  { "jakub-boucek.cz", true },
  { "jakubboucek.cz", true },
  { "jakubtopic.cz", true },
  { "james.je", true },
  { "jamesbradach.com", true },
  { "jamesburton.london", true },
  { "jamesbywater.co.uk", true },
  { "jamesbywater.com", true },
  { "jamesbywater.me", true },
  { "jamesbywater.me.uk", true },
  { "jamesbywater.uk", true },
  { "jamesdoell.com", true },
  { "jameshost.net", true },
  { "jamesmaurer.com", true },
  { "jamesmilazzo.com", true },
  { "jamesrains.com", true },
  { "jamessan.com", true },
  { "jamielinux.com", true },
  { "jamiemagee.co.uk", true },
  { "jamiemagee.dk", true },
  { "jamon.ca", true },
  { "jamonsilva.com", true },
  { "jan-and-maaret.de", true },
  { "jan-cermak.cz", true },
  { "jan27.org", true },
  { "janario.me", true },
  { "janbrodda.de", true },
  { "jannyrijneveld.nl", true },
  { "janoberst.com", true },
  { "janokacer.sk", true },
  { "janosh.com", true },
  { "jaot.info", true },
  { "japan-foods.co.uk", true },
  { "japan4you.org", true },
  { "japaniac.de", true },
  { "japlex.com", true },
  { "jaqen.ch", true },
  { "jaredeberle.org", true },
  { "jaredfernandez.com", true },
  { "jaroslavtrsek.cz", true },
  { "jarsater.com", true },
  { "jasmineconseil.com", true },
  { "jasonamorrow.com", true },
  { "jasonrobinson.me", true },
  { "jasonroe.me", true },
  { "jasperhammink.com", true },
  { "jastoria.pl", true },
  { "jav-collective.com", true },
  { "javelinsms.com", true },
  { "jayharris.ca", true },
  { "jaymecd.rocks", true },
  { "jayschulman.com", true },
  { "jayscoaching.com", true },
  { "jayshao.com", true },
  { "jazz-alliance.com", true },
  { "jazz-alliance.org", true },
  { "jazzanet.com", true },
  { "jazzinutrecht.info", true },
  { "jazzncheese.com", true },
  { "jbbd.fr", true },
  { "jbn.mx", true },
  { "jbradaric.me", true },
  { "jcaicedo.tk", true },
  { "jcch.de", true },
  { "jcoscia.com", true },
  { "jcraft.us", true },
  { "jctf.io", true },
  { "jdh8.org", true },
  { "jdubya.info", true },
  { "jean-remy.ch", true },
  { "jeepmafia.com", true },
  { "jeff.forsale", true },
  { "jeff393.com", true },
  { "jeffcasavant.com", false },
  { "jefftickle.com", true },
  { "jekkt.com", true },
  { "jelly.cz", true },
  { "jelmer.co.uk", true },
  { "jelmer.uk", true },
  { "jenjoit.de", true },
  { "jennedebleser.com", false },
  { "jennifersauer.nl", true },
  { "jennybeaned.com", true },
  { "jennythebaker.com", false },
  { "jensenbanden.no", true },
  { "jensrex.dk", true },
  { "jeremiahbenes.com", true },
  { "jeremye77.com", true },
  { "jeremyness.com", true },
  { "jerodslay.com", true },
  { "jeroendeneef.com", true },
  { "jeroenseegers.com", true },
  { "jessicabenedictus.nl", true },
  { "jesters-court.net", true },
  { "jetmirshatri.com", true },
  { "jetsetcharge.com", true },
  { "jetsetpay.com", true },
  { "jetsieswerda.nl", true },
  { "jettlarue.com", true },
  { "jettshome.org", false },
  { "jetwhiz.com", true },
  { "jeugdkans.nl", true },
  { "jfreitag.de", true },
  { "jgid.de", true },
  { "jh-media.eu", false },
  { "jhalderm.com", true },
  { "jhburton.co.uk", true },
  { "jhburton.uk", true },
  { "jhejderup.me", true },
  { "jie.dance", true },
  { "jikken.de", true },
  { "jimgao.tk", true },
  { "jimshaver.net", true },
  { "jinbo123.com", false },
  { "jira.com", true },
  { "jirav.com", true },
  { "jirav.io", true },
  { "jitsi.org", false },
  { "jka.io", true },
  { "jkb.pics", true },
  { "jkbuster.com", true },
  { "jkirsche.com", true },
  { "jkrippen.com", true },
  { "jlkhosting.com", true },
  { "jmdekker.it", true },
  { "jmedved.com", true },
  { "jmk.hu", true },
  { "jn1.me", true },
  { "joakimalgroy.com", true },
  { "jobbkk.com", true },
  { "jobflyapp.com", true },
  { "jobmob.co.il", true },
  { "jobss.co.uk", true },
  { "jodyboucher.com", true },
  { "joedavison.me", true },
  { "joelj.org", true },
  { "joepitt.co.uk", true },
  { "joerss.at", true },
  { "joestead.codes", true },
  { "jogorama.com.br", false },
  { "johannes.io", true },
  { "johannes.wtf", true },
  { "johndong.net", true },
  { "johners.me", true },
  { "johngallias.com", true },
  { "johnguant.com", true },
  { "johnhgaunt.com", true },
  { "johnmichel.org", true },
  { "johnrom.com", true },
  { "johnverkerk.com", true },
  { "jointoweb.com", true },
  { "jokewignand.nl", true },
  { "jonarcher.info", true },
  { "jonaskjodt.com", true },
  { "jonaswitmer.ch", true },
  { "jonathan-apps.com", true },
  { "jondevin.com", true },
  { "jonesborostatebank.com", true },
  { "jonfor.net", true },
  { "jonlabelle.com", true },
  { "jonn.me", true },
  { "jonnichols.info", true },
  { "jonnybarnes.uk", true },
  { "jonpads.com", true },
  { "joostrijneveld.nl", true },
  { "jooto.com", true },
  { "jopsens.de", true },
  { "jordanhamilton.me", true },
  { "joretapo.fr", true },
  { "jorgemesa.me", true },
  { "jornadasciberdefensa2016.es", true },
  { "josahrens.me", true },
  { "josefjanosec.com", true },
  { "josephrees.uk", true },
  { "joshgrancell.com", true },
  { "joshi.su", true },
  { "joshtriplett.org", true },
  { "joshuarogers.net", true },
  { "josip.at", false },
  { "jotpics.com", true },
  { "joworld.net", true },
  { "joyofcookingandbaking.com", true },
  { "joyqi.com", true },
  { "jpbike.cz", true },
  { "jr5devdoug.xyz", true },
  { "jr5devdouglas.xyz", true },
  { "jr5proxdoug.xyz", true },
  { "jrgold.me", true },
  { "jrmd.io", true },
  { "jschumacher.info", true },
  { "jsg-technologies.de", true },
  { "json-viewer.com", true },
  { "jstore.ch", true },
  { "jthackery.com", false },
  { "jualssh.com", true },
  { "juch.cc", true },
  { "jugendsuenden.info", true },
  { "juhakoho.com", true },
  { "julianmeyer.de", true },
  { "juliansimioni.com", true },
  { "julibear.com", true },
  { "julido.de", true },
  { "juliemaurel.fr", true },
  { "jultube.de", true },
  { "jumba.com.au", true },
  { "jumbox.xyz", true },
  { "jump.bg", true },
  { "jump.wtf", true },
  { "junethack.net", true },
  { "jungesforumkonstanz.de", true },
  { "junglist.org", true },
  { "juniwalk.cz", true },
  { "junjung.me", true },
  { "junkdrome.org", true },
  { "junqtion.com", false },
  { "jupp0r.de", true },
  { "jurriaan.ninja", true },
  { "justchunks.net", true },
  { "justinlemay.com", true },
  { "justnaw.co.uk", true },
  { "justyy.com", true },
  { "jutella.de", true },
  { "jvoice.net", true },
  { "jwilsson.com", true },
  { "jwilsson.me", true },
  { "jwnotifier.org", true },
  { "jym.fit", true },
  { "jznet.org", true },
  { "k-dev.de", true },
  { "k-tube.com", true },
  { "kaangenc.me", true },
  { "kaasbijwijn.nl", true },
  { "kabat-fans.cz", true },
  { "kabuabc.com", true },
  { "kabus.org", true },
  { "kachlikova2.cz", true },
  { "kackscharf.de", true },
  { "kadioglumakina.com.tr", true },
  { "kaheim.de", true },
  { "kahopoon.net", true },
  { "kaileymslusser.com", true },
  { "kainz.bayern", true },
  { "kainz.be", true },
  { "kairion.de", true },
  { "kaisers.de", true },
  { "kaizeronion.com", true },
  { "kajak.land", true },
  { "kakao-karten.de", true },
  { "kakaravaara.fi", true },
  { "kalender.com", true },
  { "kalevlamps.co.uk", true },
  { "kaliaa.fi", true },
  { "kall.is", true },
  { "kalmar.com", true },
  { "kaloix.de", true },
  { "kamcvicit.sk", true },
  { "kamisama.xyz", true },
  { "kamitech.ch", true },
  { "kamixa.se", true },
  { "kana.me", true },
  { "kandalife.com", true },
  { "kanehusky.com", true },
  { "kaneo-gmbh.de", true },
  { "kangarooislandholidayaccommodation.com.au", true },
  { "kaniklani.co.za", true },
  { "kanna.cf", true },
  { "kanotijd.nl", true },
  { "kantankye.nl", true },
  { "kantanmt.com", true },
  { "kantorosobisty.pl", true },
  { "kanzashi.com", true },
  { "kaplatz.is", true },
  { "kapseli.net", true },
  { "kapucini.si", false },
  { "kaputt.com", true },
  { "karaoketonight.com", true },
  { "karateka.org", true },
  { "karateka.ru", true },
  { "karatorian.org", true },
  { "kardize24.pl", true },
  { "karguine.in", true },
  { "karhukamera.com", true },
  { "karmabaker.com", true },
  { "karmaplatform.com", true },
  { "karmaspa.se", true },
  { "karsofsystems.com", true },
  { "karting34.com", true },
  { "kartonmodellbau.org", true },
  { "kashdash.ca", true },
  { "kasko.io", true },
  { "kassa.at", true },
  { "katekligys.com", true },
  { "katericke.com", true },
  { "katiaetdavid.fr", true },
  { "katka.info", true },
  { "katnunn.co.uk", true },
  { "katproxy.site", true },
  { "kattelans.eu", true },
  { "katyl.info", true },
  { "kau-boys.com", true },
  { "kau-boys.de", true },
  { "kaufberatung.community", true },
  { "kavik.no", true },
  { "kavovary-kava.cz", true },
  { "kawaii.io", true },
  { "kawaiiku.com", true },
  { "kawaiiku.de", true },
  { "kazandaemon.ru", true },
  { "kb3.net", true },
  { "kba-online.de", true },
  { "kbcequitas.hu", true },
  { "kbit.dk", true },
  { "kbjorklu.com", true },
  { "kc5mpk.com", true },
  { "kcolford.com", false },
  { "kd-plus.pp.ua", true },
  { "kdex.de", true },
  { "kdyby.org", true },
  { "ke7tlf.us", true },
  { "keaysmillwork.com", true },
  { "kedarastudios.com", true },
  { "keeleysam.com", true },
  { "keeleysam.me", true },
  { "keepa.com", true },
  { "keepclean.me", true },
  { "keeperapp.com", true },
  { "keepersecurity.com", true },
  { "keeweb.info", true },
  { "kefaloniatoday.com", true },
  { "keganthorrez.com", true },
  { "keifel.de", true },
  { "keisaku.org", true },
  { "keithws.net", true },
  { "keke-shop.ch", true },
  { "kekku.li", true },
  { "kekz.org", true },
  { "kempkens.io", true },
  { "kendra.io", true },
  { "kendu.si", true },
  { "kengilmour.com", true },
  { "kenkoelectric.com", true },
  { "kenners.org", true },
  { "kentacademiestrust.org.uk", true },
  { "keops-spine.fr", true },
  { "keops-spine.us", true },
  { "kerangalam.com", true },
  { "kermadec.com", true },
  { "kernel-error.de", true },
  { "kerrfrequencycombs.org", true },
  { "keskeces.com", true },
  { "kesteren.com", true },
  { "kesteren.org", true },
  { "ketosecology.co.uk", true },
  { "kevinapease.com", true },
  { "kevinbusse.de", true },
  { "kevincox.ca", true },
  { "kevindekoninck.com", true },
  { "keybase.io", true },
  { "keybored.me", true },
  { "keycdn.com", true },
  { "keyerror.com", true },
  { "keys.fedoraproject.org", true },
  { "kg-rating.com", true },
  { "kgm-irm.be", true },
  { "khetzal.info", true },
  { "khipu.com", true },
  { "khmath.com", true },
  { "khmb.ru", true },
  { "ki-on.net", true },
  { "kiano.net", true },
  { "kick-in.nl", true },
  { "kickass.al", true },
  { "kickerplaza.nl", true },
  { "kid-dachau.de", true },
  { "kidbacker.com", true },
  { "kiebel.de", true },
  { "kiel-media.de", true },
  { "kienlen.org", true },
  { "kikuzuki.org", true },
  { "kilerd.me", true },
  { "kilianvalkhof.com", true },
  { "killerrobots.com", true },
  { "kilobyte22.de", true },
  { "kimberg.co.uk", true },
  { "kimmel.com", true },
  { "kimmel.in", true },
  { "kinderbasar-luhe.de", true },
  { "kinderbuecher-kostenlos.de", true },
  { "kinderwagen-test24.de", true },
  { "kindleworth.com", true },
  { "kindlyfire.com", true },
  { "kindof.ninja", true },
  { "kingant.net", true },
  { "kinganywhere.eu", true },
  { "kingmanhall.org", true },
  { "kingqueen.org.uk", true },
  { "kinkdr.com", true },
  { "kinkenonline.com", true },
  { "kinsights.com", false },
  { "kintone.com", true },
  { "kintore.tv", true },
  { "kiocloud.com", true },
  { "kionetworks.com", true },
  { "kirara.eu", true },
  { "kirbear.com", true },
  { "kirei.se", true },
  { "kirinas.com", true },
  { "kirkovsky.com", true },
  { "kirsch-gestaltung.de", true },
  { "kirschbaum.me", true },
  { "kirstin-peters.de", true },
  { "kis-toitoidixi.de", true },
  { "kisalt.im", true },
  { "kissflow.com", true },
  { "kisstyle.ru", true },
  { "kita.id", true },
  { "kitabgaul.com", true },
  { "kitakemon.com", true },
  { "kitsostech.com", true },
  { "kitsta.com", true },
  { "kittmedia.com", true },
  { "kjaermaxi.me", true },
  { "kjarrval.is", true },
  { "kjchernov.info", true },
  { "kk-neudorf-duissern.de", true },
  { "kksg.com", true },
  { "klares-licht.de", true },
  { "klarmobil-empfehlen.de", true },
  { "klas.or.id", true },
  { "klasfauseweh.de", true },
  { "klatschreime.de", true },
  { "klausbrinch.dk", false },
  { "klausimas.lt", true },
  { "klauwd.com", true },
  { "klaxn.com", true },
  { "kle.cz", true },
  { "kleertjesvoordelig.nl", true },
  { "kleidertauschpartys.de", true },
  { "kleine-dingen.nl", true },
  { "kleinerarchitekturfuehrer.de", true },
  { "kleppe.co", true },
  { "kleteckova.cz", true },
  { "kletterkater.com", true },
  { "klicktojob.de", true },
  { "kliemann.me", true },
  { "klif1.nl", true },
  { "klimat-pro.pl", true },
  { "klingeletest.de", true },
  { "klunkergarten.org", true },
  { "klustekeningen.nl", true },
  { "km-net.pl", true },
  { "kmkz.jp", true },
  { "kn007.net", true },
  { "knapen.io", true },
  { "knccloud.com", true },
  { "kngk-group.ru", true },
  { "kngk.org", true },
  { "knip.ch", true },
  { "knowledgehook.com", true },
  { "knowledgesnap.com", true },
  { "knygos.lt", true },
  { "kodakit.com", true },
  { "kodokushi.fr", true },
  { "koebbes.de", true },
  { "koen.io", true },
  { "koenrouwhorst.nl", true },
  { "koenvdheuvel.me", false },
  { "koerper-wie-seele.de", false },
  { "koerperimpuls.ch", true },
  { "koezmangal.ch", true },
  { "koi-sama.net", true },
  { "kojima-life.co.jp", true },
  { "kojipkgs.fedoraproject.org", true },
  { "kokenmetaanbiedingen.nl", true },
  { "koketteriet.se", true },
  { "kollabria.com", true },
  { "kollawat.me", true },
  { "kolmann.at", true },
  { "kolmann.eu", true },
  { "komandakovalchuk.com", false },
  { "komget.net", true },
  { "komiksbaza.pl", true },
  { "komoju.com", true },
  { "kompetenzwerft.de", true },
  { "kon-sil.de", true },
  { "konata.us", true },
  { "koniecfica.sk", true },
  { "konijntjes.nl", true },
  { "konklone.com", true },
  { "konsertoversikt.no", true },
  { "koop-bremen.de", true },
  { "koophetlokaal.nl", true },
  { "koopjesnel.nl", true },
  { "koordinate.net", true },
  { "koot.nl", true },
  { "kopfsalat.eu", true },
  { "kopular.com", true },
  { "koretech.nl", true },
  { "korinar.com", true },
  { "kornersafe.com", true },
  { "korobi.io", true },
  { "korobkovsky.ru", true },
  { "korrelzout.nl", true },
  { "korsanparti.org", true },
  { "kosho.org", true },
  { "kostya.net", false },
  { "kotonehoko.net", true },
  { "koukni.cz", true },
  { "kozuch.biz", true },
  { "kpdyer.com", true },
  { "kpebetka.net", true },
  { "kpinvest.eu", true },
  { "krachtinverbinding.nl", true },
  { "kradalby.no", true },
  { "kraft.im", true },
  { "kraiwon.com", true },
  { "kraken.io", true },
  { "krasota.ru", false },
  { "kravelindo-adventure.com", true },
  { "kraynik.com", true },
  { "kream.io", true },
  { "kreationnext.com", true },
  { "kreativstrecke.de", true },
  { "kreavis.com", true },
  { "kreb.io", true },
  { "kredietpaspoort.nl", true },
  { "kredite.sale", true },
  { "kredite24.de", true },
  { "kreen.org", true },
  { "kriegskindernothilfe.de", true },
  { "kriegt.es", true },
  { "krislamoureux.com", true },
  { "krisstarkey.co.uk", true },
  { "kristikala.nl", true },
  { "kristofferkoch.com", true },
  { "krizek.cc", true },
  { "krk-media.pl", true },
  { "krmela.com", true },
  { "krmeni.cz", true },
  { "kroetenfuchs.de", true },
  { "kromonos.net", true },
  { "kroodle.nl", true },
  { "kroon.email", true },
  { "kropkait.pl", true },
  { "krunut.com", true },
  { "krypsys.com", true },
  { "krypteia.org", true },
  { "kryptera.se", true },
  { "kryptomech.com", true },
  { "kryx.de", true },
  { "ks-watch.de", true },
  { "kschv-rdeck.de", true },
  { "ksfh-mail.de", true },
  { "kstan.me", true },
  { "kubik-rubik.de", false },
  { "kuehnel.org", true },
  { "kuemmling.eu", true },
  { "kulde.net", true },
  { "kum.com", true },
  { "kumachan.biz", true },
  { "kumasanda.jp", true },
  { "kummerlaender.eu", true },
  { "kunstundunrat.de", true },
  { "kupelne-ptacek.sk", true },
  { "kuponrazzi.com", true },
  { "kupschke.net", true },
  { "kura.io", false },
  { "kurehun.org", true },
  { "kurtmclester.com", true },
  { "kuschelmikroben.de", true },
  { "kuwago.io", true },
  { "kvalita-1a.cz", true },
  { "kwbresidential.com", true },
  { "kwidz.fr", true },
  { "kwikmed.eu", true },
  { "kwok.cc", true },
  { "kyanite.co", true },
  { "kybi.sk", true },
  { "kylapps.com", true },
  { "kylelaker.com", true },
  { "kylinj.com", true },
  { "kylling.io", true },
  { "kynaston.org.uk", true },
  { "kynastonwedding.co.uk", true },
  { "kyosaku.org", true },
  { "kzsdabas.hu", true },
  { "l-lab.org", true },
  { "l4n-clan.de", true },
  { "labaia.info", true },
  { "labrador-retrievers.com.au", true },
  { "labradorpuppiesforsalebyregisteredlabradorbreeders.com", true },
  { "labs.directory", true },
  { "labs.moscow", true },
  { "lacasabelucci.com", true },
  { "lacasseroy.com", true },
  { "lacentral.com", false },
  { "lacledeslan.com", true },
  { "lacledeslan.ninja", true },
  { "lafkor.de", true },
  { "lagalerievirtuelle.fr", true },
  { "lagarderob.ru", true },
  { "lagerauftrag.info", true },
  { "laglab.org", true },
  { "lagoza.name", true },
  { "lainchan.org", true },
  { "lak-berlin.de", true },
  { "lakhesis.net", true },
  { "lalaya.fr", true },
  { "lamaland.ru", true },
  { "lambda-complex.org", true },
  { "lamboo.be", true },
  { "laminine.info", true },
  { "lan2k.org", true },
  { "lana.swedbank.se", true },
  { "lanbyte.se", true },
  { "lancejames.com", true },
  { "lancork.net", true },
  { "land.nrw", true },
  { "langatang.com", true },
  { "langbein.org", true },
  { "langenbach.rocks", true },
  { "langendries.eu", true },
  { "langguth.io", true },
  { "langhun.me", true },
  { "lansinoh.co.uk", true },
  { "laozhu.me", true },
  { "lapetition.be", true },
  { "lapidge.net", true },
  { "laposte.net", true },
  { "largescaleforums.com", true },
  { "larrysalibra.com", true },
  { "lars-ewald.com", true },
  { "larsklene.nl", true },
  { "lasercloud.ml", true },
  { "laserfuchs.de", true },
  { "lashstuff.com", true },
  { "lasnaves.com", true },
  { "lasst-uns-beten.de", true },
  { "lastpass.com", false },
  { "latenitefilms.com", false },
  { "lateralsecurity.com", true },
  { "latinphone.com", true },
  { "latitude42technology.com", true },
  { "latrine.cz", true },
  { "lauftreff-himmelgeist.de", true },
  { "laukstein.com", true },
  { "launchkey.com", true },
  { "laurel4th.org", true },
  { "lausitzer-widerstand.de", true },
  { "lavalite.de", true },
  { "laventainnhotel-mailing.com", true },
  { "lavine.ch", true },
  { "lavinya.net", true },
  { "lavoiepharmd.com", true },
  { "lavval.com", true },
  { "lawformt.com", true },
  { "laxatus.com", true },
  { "laylo.nl", true },
  { "lazurit.com", true },
  { "lb-toner.de", true },
  { "lbayer.com", true },
  { "lbrt.xyz", true },
  { "lcti.biz", true },
  { "ld-begunjscica.si", true },
  { "le-dev.de", true },
  { "le-h.de", true },
  { "le-hosting.de", true },
  { "leadbook.ru", true },
  { "leadership9.com", true },
  { "leadingsalons.com", true },
  { "leakedminecraft.net", true },
  { "leanclub.org", true },
  { "leardev.de", true },
  { "learnflakes.net", true },
  { "learningorder.com", true },
  { "learntube.cz", true },
  { "leatherfurnitureexpo.com", true },
  { "leaversmith.com", true },
  { "lechiennoir.net", true },
  { "ledgerscope.net", false },
  { "ledhouse.sk", true },
  { "leedev.org", true },
  { "leerliga.de", true },
  { "leesilvey.com", true },
  { "lega-dental.com", true },
  { "legendofkrystal.com", true },
  { "legoutdesplantes.be", true },
  { "lehighmathcircle.org", true },
  { "leibniz-remscheid.de", true },
  { "leifdreizler.com", true },
  { "leilonorte.com", true },
  { "leinir.dk", true },
  { "lellyboi.ml", true },
  { "lemoine.at", true },
  { "lemp.io", true },
  { "lence.net", true },
  { "lengzzz.com", true },
  { "leninalbertop.com.ve", true },
  { "lenn1.de", true },
  { "lenovogaming.com", true },
  { "lenzw.de", true },
  { "leolana.com", true },
  { "leominstercu.com", false },
  { "leonard.io", true },
  { "leonardcamacho.me", true },
  { "leonax.net", true },
  { "leonklingele.de", true },
  { "leonmahler.consulting", true },
  { "lepont.pl", true },
  { "leppis-it.de", true },
  { "lerner.moscow", true },
  { "lerp.me", true },
  { "les-corsaires.net", true },
  { "lesdouceursdeliyana.com", true },
  { "lesharris.com", true },
  { "lesnet.co.uk", true },
  { "lesperlesdunet.fr", true },
  { "letsmultiplayerplay.com", true },
  { "letstox.com", true },
  { "letustravel.tk", true },
  { "levendwater.org", true },
  { "levert.ch", true },
  { "levinus.de", true },
  { "lewis.li", true },
  { "lewisjuggins.co.uk", true },
  { "lewislaw.com", true },
  { "lexway.pk", true },
  { "lgiswa.com.au", true },
  { "lgrs.com.au", true },
  { "lhalbert.xyz", true },
  { "liam-w.com", true },
  { "liamjack.fr", true },
  { "libbitcoin.org", true },
  { "libertas-tech.com", true },
  { "libertyrp.org", true },
  { "libfte.org", true },
  { "libraryfreedomproject.org", false },
  { "libreboot.org", true },
  { "librelamp.com", true },
  { "libscode.com", true },
  { "libsodium.org", true },
  { "liceserv.com", true },
  { "lichtspot.de", true },
  { "liderwalut.pl", true },
  { "liebel.org", true },
  { "life-time.nl", true },
  { "lifeinitsownway.com", false },
  { "lifeskillsdirect.com", true },
  { "lifestylehunter.co.uk", true },
  { "lifetimemoneymachine.com", true },
  { "lifi.digital", true },
  { "lifi.is", true },
  { "light.mail.ru", true },
  { "lighting-centres.co.uk", true },
  { "lightme.us", true },
  { "lightpaste.com", true },
  { "lightspeed.com", false },
  { "lillepuu.com", true },
  { "lilpwny.com", true },
  { "limeyeti.com", true },
  { "limitededitioncomputers.com", true },
  { "limitededitionsolutions.com", true },
  { "limpid.nl", true },
  { "limpido.it", true },
  { "lingolia.com", true },
  { "lingros-test.tk", true },
  { "linguatrip.com", false },
  { "lingvo-svoboda.ru", true },
  { "link.ba", true },
  { "link2serve.com", true },
  { "linkages.org", true },
  { "linkenheil.org", true },
  { "linkmaker.co.uk", true },
  { "linkonaut.net", true },
  { "linno.me", true },
  { "linode.com", false },
  { "linorman1997.me", true },
  { "linpx.com", true },
  { "linux-admin-california.com", true },
  { "linux.cn", true },
  { "linux.fi", true },
  { "linuxbabe.com", true },
  { "linuxbierwanderung.com", true },
  { "linuxcommand.ru", true },
  { "linuxfixed.it", true },
  { "linuxgeek.ro", true },
  { "linuxhostsupport.com", true },
  { "linuxlounge.net", true },
  { "linuxmonitoring.net", true },
  { "linuxwebservertips.in", true },
  { "linx.li", true },
  { "linx.net", true },
  { "linzgau.de", true },
  { "liornavok.com", true },
  { "liquid.cz", true },
  { "liquidcomm.net", true },
  { "liquorsanthe.in", true },
  { "liris-beautywelt.de", true },
  { "lisaco.de", true },
  { "lislan.org.uk", true },
  { "lister-kirchweg.de", true },
  { "lists.fedoraproject.org", true },
  { "lists.mayfirst.org", false },
  { "lists.stg.fedoraproject.org", true },
  { "litchidova.nl", true },
  { "litespeed.io", true },
  { "litevault.net", true },
  { "lithesalar.se", false },
  { "little.pw", true },
  { "littlefreelibrary.org", true },
  { "litvideoserver.de", true },
  { "liud.im", true },
  { "liudon.org", true },
  { "livecards.co.uk", true },
  { "livedemo.io", true },
  { "liveforspeed.se", true },
  { "livej.am", true },
  { "livekaarten.be", true },
  { "livekaarten.nl", true },
  { "livekort.dk", true },
  { "livekort.se", true },
  { "liverewrite.com", true },
  { "liverpoolmutualhomes.org", false },
  { "livnev.me", true },
  { "ljs.io", true },
  { "lkummer.cz", true },
  { "llamacuba.com", true },
  { "lloyd-day.me", true },
  { "lm-pumpen.de", true },
  { "lmddgtfy.net", true },
  { "lmintlcx.com", true },
  { "lmmtfy.io", true },
  { "lmsptfy.com", true },
  { "lnoldan.com", true },
  { "lntu.org", true },
  { "loadso.me", true },
  { "loancompare.co.za", true },
  { "lobste.rs", true },
  { "localbandz.com", true },
  { "localbitcoins.com", true },
  { "localchum.com", true },
  { "lockify.com", true },
  { "locktheirphone.com", true },
  { "locomore.com", true },
  { "locomotive.ca", true },
  { "lodash.com", true },
  { "loftboard.eu", true },
  { "logario.com.br", true },
  { "logement-saisonnier.com", true },
  { "logentries.com", false },
  { "logfile.at", true },
  { "logicsale.com", true },
  { "logicsale.de", true },
  { "logicsale.fr", true },
  { "logicsale.it", true },
  { "login.corp.google.com", true },
  { "login.gov", true },
  { "login.launchpad.net", true },
  { "login.persona.org", true },
  { "login.sapo.pt", true },
  { "login.ubuntu.com", true },
  { "login.xero.com", false },
  { "login.yahoo.com", false },
  { "loginseite.com", true },
  { "logistify.com.mx", true },
  { "lognot.net", true },
  { "logopaediereinhard.de", true },
  { "logopoeia.com", true },
  { "lokaal.org", true },
  { "loli.bz", true },
  { "lolicore.ch", true },
  { "lolpatrol.de", true },
  { "lonal.com", true },
  { "london-transfers.com", true },
  { "londonlanguageexchange.com", true },
  { "lone-gunman.be", true },
  { "longboarding-ulm.de", true },
  { "lookout.com", false },
  { "lookyman.net", true },
  { "loony.info", true },
  { "loophost.com.br", true },
  { "loopstart.org", true },
  { "lordjevington.co.uk", true },
  { "lore.azurewebsites.net", true },
  { "lost.host", false },
  { "lostinsecurity.com", true },
  { "lostinweb.eu", true },
  { "lothai.re", false },
  { "lotsencafe.de", true },
  { "loucanfixit.com", true },
  { "louiewatch.com", true },
  { "love-schna.jp", true },
  { "loveisourweapon.com", true },
  { "lovelifelovelive.com", true },
  { "lovelive.us", true },
  { "lovemomiji.com", true },
  { "lover-bg.com", true },
  { "loveto.at", true },
  { "loveyounastya.com", true },
  { "lovingearth.co", true },
  { "lovingearth.net", true },
  { "lowmagnitude.com", true },
  { "lowsidetna.com", true },
  { "lpak.nl", true },
  { "lpbk-bethel.de", true },
  { "lpm-uk.com", true },
  { "lrhstsa.com", true },
  { "ls-a.org", true },
  { "ltn-tom-morel.fr", true },
  { "lubot.net", false },
  { "lucaterzini.com", true },
  { "luchscheider.de", true },
  { "lucidframeworks.com", true },
  { "lucielavickova.com", true },
  { "ludwig.im", true },
  { "luehne.de", true },
  { "luelistan.net", true },
  { "lufthansaexperts.com", true },
  { "lugbb.org", true },
  { "luine.xyz", true },
  { "luis-checa.com", true },
  { "lukasberan.cz", true },
  { "lukasunger.cz", true },
  { "lukasunger.net", true },
  { "lukaszdolan.com", true },
  { "lukasztkacz.com", true },
  { "luke.ch", true },
  { "lumiere.com", true },
  { "lunakit.org", true },
  { "lunarift.com", true },
  { "lunarshark.com", true },
  { "luneta.nearbuysystems.com", false },
  { "lungdoc.us", true },
  { "lunix.io", true },
  { "luno.io", true },
  { "luoe.ml", true },
  { "luoh.cc", true },
  { "luoh.me", true },
  { "luohua.im", true },
  { "luom.net", true },
  { "lustrum.ch", true },
  { "lustrumxi.nl", true },
  { "luther.fi", true },
  { "luukklene.nl", true },
  { "luxsci.com", true },
  { "luxwatch.com", true },
  { "lv0.it", true },
  { "lvrsystems.com", true },
  { "lwl-foej-bewerbung.de", true },
  { "lwl.moe", true },
  { "lymia.moe", true },
  { "lynero.dk", true },
  { "lyness.io", true },
  { "lynkos.com", true },
  { "lynthium.com", true },
  { "lyst.co.uk", true },
  { "lyx.dk", true },
  { "lzkill.com", true },
  { "lzzr.me", true },
  { "m-edmondson.co.uk", true },
  { "m.facebook.com", false },
  { "m.mail.ru", true },
  { "m.nu", true },
  { "m0wef.uk", true },
  { "m82labs.com", true },
  { "ma2t.com", true },
  { "mac-torrents.me", true },
  { "macchaberrycream.com", true },
  { "macgeneral.de", true },
  { "mach-politik.ch", true },
  { "machbach.com", true },
  { "machon.biz", false },
  { "macinyasha.net", true },
  { "macker.io", true },
  { "maclemon.at", true },
  { "macleod.io", true },
  { "macnemo.de", true },
  { "maco.org.uk", true },
  { "madars.org", true },
  { "maddi.biz", true },
  { "madebymagnitude.com", true },
  { "madebyshore.com", true },
  { "madeitwor.se", true },
  { "madin.ru", true },
  { "madnetwork.org", true },
  { "madrants.net", true },
  { "madreacqua.org", true },
  { "madtec.de", true },
  { "maelstrom.ninja", true },
  { "mafamane.com", true },
  { "maff.scot", false },
  { "mafiasi.de", true },
  { "magicball.co", true },
  { "magneticanvil.com", true },
  { "mahamed91.pw", true },
  { "mahefa.co.uk", true },
  { "mahrer.net", true },
  { "mail-settings.google.com", true },
  { "mail.de", true },
  { "mail.google.com", true },
  { "mail.yahoo.com", false },
  { "mail4you.in", true },
  { "mailbox.org", true },
  { "mailchuck.com", true },
  { "maildragon.com", true },
  { "mailer-dot.de", true },
  { "mailfence.com", true },
  { "mailgarant.nl", true },
  { "mailhost.it", true },
  { "mailinabox.email", true },
  { "mailing-jbgg.com", true },
  { "mailmag.net", true },
  { "mainlined.org", true },
  { "mainlywrenches.co", true },
  { "majesnix.org", true },
  { "make-pizza.info", true },
  { "makeitdynamic.com", true },
  { "makeyourlaws.org", true },
  { "makowitz.cz", true },
  { "maktoob.search.yahoo.com", false },
  { "malash.me", true },
  { "malaysia.search.yahoo.com", false },
  { "malfait.nl", true },
  { "malinator.net", true },
  { "maliskovik.si", true },
  { "mall.cz", true },
  { "mall.hr", true },
  { "mall.hu", true },
  { "mall.pl", true },
  { "mall.sk", true },
  { "malnex.de", true },
  { "malware.watch", true },
  { "malwaretips.com", true },
  { "malwre.io", true },
  { "mamaxi.org", true },
  { "mammaw.com", true },
  { "mammothmail.com", true },
  { "mammothmail.net", true },
  { "mammothmail.org", true },
  { "man3s.jp", true },
  { "manaboutahor.se", true },
  { "manage.cm", true },
  { "manage.zenpayroll.com", false },
  { "management-companie.ro", true },
  { "management-ethics.com", true },
  { "managemynetsuite.com", true },
  { "manageprojects.com", true },
  { "manager.linode.com", false },
  { "managewp.org", true },
  { "mandala-ausmalbilder.de", true },
  { "manfredimatteo.com", true },
  { "manhattanchoralensemble.org", true },
  { "manicode.com", true },
  { "manifestbin.com", true },
  { "manningbrothers.com", true },
  { "manoirdecontres.com", true },
  { "manowarus.com", true },
  { "mansfieldplacevt.com", true },
  { "mantor.org", false },
  { "manueli.de", true },
  { "maosensanguentadasdejesus.net", true },
  { "maowtm.org", true },
  { "marbogardenlidkoping.se", true },
  { "marcel-preuss.de", true },
  { "marcelpreuss.de", true },
  { "marcoececilia.it", true },
  { "marcofinke.de", true },
  { "marcohager.de", true },
  { "marcontrol.com", true },
  { "mareklecian.cz", true },
  { "mariannematthew.com", true },
  { "mariaolesen.dk", true },
  { "marie-curie.fr", true },
  { "marie-elisabeth.dk", true },
  { "marie.club", true },
  { "marikafranke.de", true },
  { "marilsnijders.nl", true },
  { "marinelausa.com", true },
  { "marines-shop.com", true },
  { "mark-a-hydrant.com", true },
  { "mark-semmler.de", true },
  { "markaconnor.com", true },
  { "market.android.com", true },
  { "marketingdesignu.cz", true },
  { "markhaehnel.de", false },
  { "markido.com", true },
  { "markoh.co.uk", true },
  { "markom.rs", true },
  { "markprof.ru", true },
  { "markri.nl", true },
  { "markt-heiligenstadt.de", true },
  { "marktboten.de", true },
  { "marktcontact.com", true },
  { "markusehrlicher.de", true },
  { "markusueberallassetmanagement.de", true },
  { "marlen.cz", true },
  { "marquiseclub.se", true },
  { "marriottvetcareers.com", true },
  { "marsble.com", true },
  { "marshut.net", true },
  { "martelange.ovh", true },
  { "martensmxservice.nl", true },
  { "martialc.be", true },
  { "martiert.com", true },
  { "martin-smith.info", true },
  { "martineve.com", true },
  { "martinkup.cz", true },
  { "martinkus.eu", true },
  { "martinp.no", true },
  { "martinsfamilyappliance.com", true },
  { "marumagic.com", true },
  { "masa-yoga.com", true },
  { "mascosolutions.com", true },
  { "massdrop.com", true },
  { "masse.org", true },
  { "massivum.de", false },
  { "mastellone.us", true },
  { "masteringtheterminal.com", true },
  { "masters.black", true },
  { "matatall.com", false },
  { "matchneedle.com", true },
  { "maternalsafety.org", true },
  { "mathembedded.com", true },
  { "mathhire.org", true },
  { "mathiasbynens.be", true },
  { "mathiasgarbe.de", true },
  { "matrip.de", true },
  { "matrix.ac", true },
  { "matt.tf", true },
  { "mattandreko.com", true },
  { "mattandyana.com", true },
  { "mattberryman.com", false },
  { "matteomarescotti.it", true },
  { "mattfin.ch", true },
  { "matthewohare.com", true },
  { "matthiasadler.info", true },
  { "matthiasschwab.de", true },
  { "matthiassteen.be", true },
  { "mattia98.org", true },
  { "mattmccutchen.net", true },
  { "mattsvensson.com", true },
  { "mattwb65.com", true },
  { "maultrom.ml", true },
  { "mauriciog.com.ar", true },
  { "mauricioghiorzi.com.ar", true },
  { "mausi.co", true },
  { "mavenclinic.com", true },
  { "mavensecurity.com", true },
  { "maveris.com", true },
  { "mawe.red", true },
  { "max-moeglich.de", true },
  { "max.gov", true },
  { "maxbytes.nl", true },
  { "maxima.at", true },
  { "maximdeboiserie.be", true },
  { "maximeferon.fr", true },
  { "maximelouet.me", true },
  { "maximilian-greger.com", true },
  { "maximiliankrieg.de", true },
  { "maxmilton.com", true },
  { "maxr1998.de", true },
  { "maxserver.com", true },
  { "maxtruxa.com", true },
  { "maxwell-english.co.jp", false },
  { "maya.mg", true },
  { "mazz-tech.com", true },
  { "mbaestlein.de", true },
  { "mbasic.facebook.com", false },
  { "mbilker.us", true },
  { "mbinf.de", true },
  { "mbinformatik.de", true },
  { "mblankhorst.nl", true },
  { "mbp.banking.co.at", false },
  { "mbweir.com", true },
  { "mc-venture.net", false },
  { "mc81.com", true },
  { "mca2017.org", true },
  { "mcadmin.net", true },
  { "mcard.vn", true },
  { "mcatnnlo.org", true },
  { "mcc.re", true },
  { "mccarty.io", true },
  { "mccrackon.com", true },
  { "mcdonalds.be", true },
  { "mcdonaldwhsl.com", true },
  { "mce.eu", true },
  { "mce.nyc", true },
  { "mce55.eu", true },
  { "mceconferencecentre.eu", true },
  { "mcgarderen.nl", true },
  { "mchristopher.com", true },
  { "mcl.gg", true },
  { "mclab.su", false },
  { "mcnext.net", true },
  { "mcooperlaw.com", true },
  { "mcpart.land", true },
  { "mcrn.jp", true },
  { "mctherealm.net", true },
  { "mcuong.tk", true },
  { "md5file.com", true },
  { "md5hashing.net", true },
  { "mdek.at", true },
  { "mdewendt.de", true },
  { "mdkr.nl", true },
  { "mdpraha.cz", true },
  { "mdwftw.com", true },
  { "me.net.nz", true },
  { "mea.in.ua", true },
  { "meadowviewfarms.org", true },
  { "mealgoo.com", true },
  { "meamod.com", true },
  { "meap.xyz", true },
  { "mebio.us", false },
  { "mechanixdirect.co.uk", true },
  { "mechanus.io", true },
  { "medallia.io", true },
  { "medba.se", true },
  { "meddelare.com", true },
  { "medexpress.co.uk", true },
  { "media-courses.com", true },
  { "mediaburst.co.uk", true },
  { "mediaselection.eu", true },
  { "mediastorm.us", true },
  { "mediawiki.org", true },
  { "mediawikicn.org", true },
  { "medicinesfast.com", true },
  { "medirich.co", true },
  { "meditek-dv.ru", true },
  { "medium.com", true },
  { "medm-test.com", true },
  { "medo64.com", true },
  { "medovea.ru", true },
  { "medtehnika.ua", true },
  { "medusa.wtf", true },
  { "meedoenhartvanwestbrabant.nl", true },
  { "meedoenzaanstad.nl", true },
  { "meetbot.fedoraproject.org", true },
  { "meetfinch.com", true },
  { "meetingmanage.nl", true },
  { "meetingmanager.ovh", true },
  { "meetmibaby.co.uk", true },
  { "meetscompany.jp", true },
  { "mega.co.nz", true },
  { "mega.nz", true },
  { "mega.online", true },
  { "megadrol.com", true },
  { "megakiste.de", true },
  { "megaplan.cz", true },
  { "megaplan.ru", true },
  { "megasslstore.com", true },
  { "meghudson.com", true },
  { "mehmetince.net", true },
  { "mehrwert.de", true },
  { "meifrench.com", true },
  { "meillard-auto-ecole.ch", true },
  { "mein-webportal.de", true },
  { "meine-email-im.net", true },
  { "meinebo.it", true },
  { "meizufans.eu", true },
  { "melcher.it", true },
  { "melearning.university", true },
  { "melf.nl", true },
  { "melissaadkins.com", true },
  { "melitopol.co.ua", true },
  { "melnikov.ch", true },
  { "melody-lyrics.com", true },
  { "melted.pw", true },
  { "melvinlow.com", true },
  { "memberpress.com", true },
  { "members.nearlyfreespeech.net", false },
  { "memo-linux.com", true },
  { "mensagemdaluz.com", true },
  { "mentax.net", false },
  { "mentiq.az", true },
  { "mentz.info", true },
  { "menudrivetest.com", true },
  { "menuonlineordering.com", true },
  { "meozcraft.com", false },
  { "mercamaris.es", true },
  { "merccorp.de", true },
  { "mercuryamericas.com", false },
  { "mercurystorm.co.za", true },
  { "mereckas.com", true },
  { "meredithkm.info", true },
  { "meritz.rocks", true },
  { "merkel.me", true },
  { "mersinunivercity.com", true },
  { "merson.me", true },
  { "mertcangokgoz.com", true },
  { "mesmoque.com", true },
  { "mesvt.com", true },
  { "meta-db.com", true },
  { "meta.sc", true },
  { "metaether.net", true },
  { "metapeen.nl", true },
  { "metebalci.com", true },
  { "meteobox.co", true },
  { "meteobox.cz", true },
  { "meteobox.de", true },
  { "meteobox.es", true },
  { "meteobox.fr", true },
  { "meteobox.mx", true },
  { "meteobox.pl", true },
  { "meteobox.sk", true },
  { "meteorapp.space", true },
  { "meteosherbrooke.com", true },
  { "meteosky.net", true },
  { "metis.pw", true },
  { "metrobriefs.com", true },
  { "metzgerei-birkenhof.de", true },
  { "meuemail.pro", true },
  { "mevs.cz", true },
  { "mexicansbook.ru", false },
  { "meyeraviation.com", true },
  { "mfcatalin.com", true },
  { "mfiles.pl", true },
  { "mgdigital.fr", true },
  { "mghiorzi.com.ar", true },
  { "mh-bloemen.co.jp", true },
  { "mheistermann.de", true },
  { "mhertel.com", false },
  { "mhx.pw", true },
  { "miagexport.com", true },
  { "miasarafina.de", true },
  { "michael-rigart.be", true },
  { "michaelcullen.name", true },
  { "michaelleibundgut.com", true },
  { "michaelmorpurgo.com", true },
  { "michaelrigart.be", true },
  { "michaeltroger.com", true },
  { "michaelwaite.org", true },
  { "michal-kral.cz", true },
  { "michalborka.cz", true },
  { "michalkral.tk", true },
  { "michalspacek.cz", true },
  { "michasfahrschule.com", true },
  { "michel-wein.de", true },
  { "michiganunionoptout.com", true },
  { "miconcinemas.com", true },
  { "miconware.de", true },
  { "micro-rain-systems.com", true },
  { "microdots.de", true },
  { "microme.ga", true },
  { "microvb.com", true },
  { "midair.io", true },
  { "midirs.org", true },
  { "midlgx.com", true },
  { "midonet.org", true },
  { "mig5.net", true },
  { "mightysounds.cz", true },
  { "mijailovic.net", true },
  { "mijcorijneveld.nl", true },
  { "mijn-email.org", true },
  { "mijnkredietpaspoort.nl", true },
  { "mijnreisoverzicht.nl", true },
  { "mijntransacties.nl", true },
  { "mikadesign.se", false },
  { "mikadoe.nl", true },
  { "mikaela.info", true },
  { "mikaelemilsson.net", true },
  { "mike-bland.com", true },
  { "mikeburns.com", true },
  { "miketabor.com", true },
  { "mikewest.org", true },
  { "mikewillia.ms", true },
  { "mikeybot.com", true },
  { "miku.be", true },
  { "mil0.com", true },
  { "milahendri.com", false },
  { "milanpala.cz", true },
  { "milatrans.pl", true },
  { "millenniumweb.com", true },
  { "millistream.com", true },
  { "mim.properties", true },
  { "mimeit.de", true },
  { "mimovrste.com", true },
  { "mind-moves.es", true },
  { "mindbodycontinuum.com", true },
  { "mindcoding.ro", true },
  { "mindcraft.ga", true },
  { "minecraft-forum.cf", true },
  { "minecraft-forum.ga", true },
  { "minecraft-forum.gq", true },
  { "minecraft-forum.ml", true },
  { "minecraft-forums.cf", true },
  { "minecraft-forums.ga", true },
  { "minecraft-forums.gq", true },
  { "minecraftforum.de", true },
  { "minecraftforum.ovh", true },
  { "minecraftforums.cf", true },
  { "minecraftforums.gq", true },
  { "minecraftforums.ml", true },
  { "minecraftvoter.com", true },
  { "mineover.es", true },
  { "minesouls.fr", true },
  { "minez-nightswatch.com", false },
  { "mini2.fi", true },
  { "minikneet.com", true },
  { "minipainting.net", true },
  { "minis-hip.de", true },
  { "miniskipper.at", true },
  { "minkondom.nu", true },
  { "minnesotadata.com", true },
  { "minobar.com", true },
  { "minora.io", true },
  { "minpingvin.dk", true },
  { "mintea-noua.ro", true },
  { "mintrak2.com", true },
  { "mipiaci.co.nz", true },
  { "mipiaci.com.au", true },
  { "mireservaonline.es", true },
  { "mirodasilva.be", true },
  { "mironet.cz", true },
  { "mirtes.cz", true },
  { "misakiya.co.jp", true },
  { "miskatonic.org", true },
  { "miss-inventory.co.uk", true },
  { "missdream.org", true },
  { "misskey.xyz", true },
  { "missrain.tw", true },
  { "mistacms.com", true },
  { "mister.hosting", true },
  { "misterl.net", true },
  { "mit-uns.org", true },
  { "mitchellrenouf.ca", true },
  { "mitell.jp", false },
  { "mitnetz-gas.de", true },
  { "mitnetz-strom.de", true },
  { "mitrecaasd.org", true },
  { "mitremai.org", true },
  { "mittelunsachlich.de", true },
  { "mittenhacks.com", true },
  { "mitzpettel.com", true },
  { "mixposure.com", true },
  { "miyoshi-kikaku.com", true },
  { "mizd.at", true },
  { "mjacobson.net", true },
  { "mjanja.ch", true },
  { "mjcaffarattilaw.com", true },
  { "mjec.net", true },
  { "mkcert.org", true },
  { "mkes.com", false },
  { "mkp-deutschland.de", true },
  { "mktemp.org", true },
  { "mkw.st", true },
  { "mlemay.com", true },
  { "mlp.ee", true },
  { "mlpepilepsy.org", true },
  { "mlsrv.de", true },
  { "mm13.at", true },
  { "mm404.com", true },
  { "mma-acareporting.com", true },
  { "mmgazhomeloans.com", true },
  { "mmmm.com", true },
  { "mmonit.com", true },
  { "mmucha.de", true },
  { "mnd.sc", true },
  { "mnetworkingsolutions.co.uk", true },
  { "mnium.de", true },
  { "mnmt.no", true },
  { "mnsure.org", true },
  { "moar.so", true },
  { "mobaircon.com", true },
  { "mobal.com", true },
  { "mobidea.com", true },
  { "mobilcom-debitel-empfehlen.de", true },
  { "mobile.eti.br", true },
  { "mobile.united.com", false },
  { "mobile.usaa.com", false },
  { "mobilekey.co", true },
  { "mobilemedics.com", true },
  { "mobiletraff.co", true },
  { "mobility-events.ch", true },
  { "mobilpass.no", true },
  { "mobilux.lv", true },
  { "mobobe.com", true },
  { "mocloud.eu", true },
  { "modelcase.co.jp", true },
  { "modeldimension.com", true },
  { "modernapprenticeships.org", true },
  { "modernibytovytextil.cz", true },
  { "modifiedmind.com", true },
  { "modmountain.com", true },
  { "modydev.club", true },
  { "moebel-nagel.de", true },
  { "moegirl.org", true },
  { "moen.io", true },
  { "mogry.net", true },
  { "mojaknjiznica.com", false },
  { "mojapraca.sk", true },
  { "mokote.com", true },
  { "mommel.com", true },
  { "mommelonline.de", true },
  { "mon-partage.fr", true },
  { "mona.lu", true },
  { "mondopoint.com", true },
  { "mondwandler.de", true },
  { "moneromerchant.com", true },
  { "moneygo.se", true },
  { "moniquedekermadec.com", true },
  { "monitaure.io", true },
  { "monitman.solutions", true },
  { "monitzer.com", true },
  { "monix.io", true },
  { "monkeydust.net", true },
  { "monnyonle.hu", true },
  { "monobank.no", true },
  { "montanacures.org", true },
  { "montenero.pl", true },
  { "montonicms.com", true },
  { "moo.la", true },
  { "moon.lc", true },
  { "moonagic.com", true },
  { "moonloupe.com", true },
  { "moonraptor.co.uk", true },
  { "moonraptor.com", true },
  { "moonvpn.org", true },
  { "moparcraft.com", true },
  { "moparcraft.net", true },
  { "moparcraft.org", true },
  { "moparisthebest.biz", true },
  { "moparisthebest.com", true },
  { "moparisthebest.info", true },
  { "moparisthebest.net", true },
  { "moparisthebest.org", true },
  { "moparscape.org", true },
  { "mor.cloud", true },
  { "morbatex.com", true },
  { "morbitzer.de", true },
  { "moreapp.co.uk", true },
  { "morenci.ch", true },
  { "morethanadream.lv", true },
  { "morganino.eu", true },
  { "morganino.it", true },
  { "moritz-baestlein.de", true },
  { "moriz.de", true },
  { "morningcalculation.com", true },
  { "mornings.com", true },
  { "morteruelo.net", true },
  { "morz.org", true },
  { "mosstier.com", true },
  { "mostwuat.com", true },
  { "motd.ch", true },
  { "motherbase.io", true },
  { "mothereff.in", true },
  { "motionfreight.com", true },
  { "motocyklovedily.cz", true },
  { "motoryz.nl", true },
  { "mottvd.com", true },
  { "mountainadventureseminars.com", true },
  { "mountainroseherbs.com", true },
  { "moveek.com", true },
  { "moviedollars.com", true },
  { "movinglogistics.nl", true },
  { "movlib.org", true },
  { "moy-gorod.od.ua", true },
  { "mozoa.net", true },
  { "mp3gratuiti.com", true },
  { "mp3juices.is", true },
  { "mpc-hc.org", true },
  { "mpcompliance.com", true },
  { "mpetroff.net", true },
  { "mpintaamalabanna.it", true },
  { "mplant.io", true },
  { "mplusm.eu", true },
  { "mpreserver.com", true },
  { "mpserver12.org", true },
  { "mpsgarage.com.au", true },
  { "mqas.net", true },
  { "mr-hosting.com", true },
  { "mremallin.ca", true },
  { "mrettich.org", true },
  { "mrnonz.com", true },
  { "mrs-shop.com", true },
  { "msa-aesch.ch", true },
  { "msebera.cz", true },
  { "msiegmund.com", true },
  { "msmails.de", true },
  { "msno.no", true },
  { "mszaki.com", true },
  { "mt.me.uk", true },
  { "mtamaki.com", true },
  { "mtasa.com", true },
  { "mtau.com", true },
  { "mtg-tutor.de", true },
  { "mthode.org", true },
  { "mths.be", true },
  { "mtn.cc", true },
  { "mtnz.co.za", true },
  { "mtouch.facebook.com", false },
  { "muabannhanh.com", false },
  { "mudcrab.us", true },
  { "muguayuan.com", true },
  { "mujadin.se", false },
  { "multigamecard.com", true },
  { "multigeist.de", true },
  { "multitheftauto.com", true },
  { "mumei.space", true },
  { "munich-rage.de", true },
  { "munki.org", true },
  { "munuc.org", true },
  { "murfy.nz", true },
  { "muriburi.land", true },
  { "muriburiland.com", true },
  { "murodese.org", true },
  { "murraycoin.org", true },
  { "muscleangels.com", true },
  { "mushikabu.net", true },
  { "musi.cx", true },
  { "musicgamegalaxy.de", true },
  { "musicwear.cz", true },
  { "musikkfondene.no", true },
  { "musmann.io", true },
  { "musthavesforreal.com", true },
  { "mutamatic.com", true },
  { "mutantmonkey.in", true },
  { "mutantmonkey.info", true },
  { "mutantmonkey.sexy", true },
  { "mutuelle.fr", true },
  { "muzykaprzeszladoplay.pl", true },
  { "mvanmarketing.nl", true },
  { "mvixturismo.com.br", true },
  { "mvno.io", true },
  { "mvsecurity.nl", true },
  { "mwavuli.co.ke", true },
  { "mwe.st", true },
  { "mx.org.ua", false },
  { "mx.search.yahoo.com", false },
  { "my-owncloud.com", true },
  { "my-pawnshop.com.ua", true },
  { "my.onlime.ch", false },
  { "my.usa.gov", false },
  { "my.xero.com", false },
  { "myaccount.google.com", true },
  { "myairshop.gr", true },
  { "mybeautyjobs.de", true },
  { "mybon.at", true },
  { "mybudget.xyz", true },
  { "mybuilderinlondon.co.uk", true },
  { "mycieokien.info", false },
  { "myclientsplus.com", true },
  { "myconan.net", true },
  { "mydeos.com", false },
  { "mydnaresults.com", true },
  { "mydnatest.com", true },
  { "mydocserve.com", true },
  { "myg21.com", true },
  { "mygadgetguardian.lookout.com", false },
  { "mygate.at", false },
  { "mygreatjobs.de", true },
  { "mygretchen.de", true },
  { "myhostname.net", true },
  { "myiocc.org", true },
  { "myip.tech", true },
  { "mykeepsake.xyz", true },
  { "mykontool.de", true },
  { "mylookout.com", false },
  { "myni.io", true },
  { "mynigma.org", true },
  { "myonline.hu", true },
  { "myownconference.com", true },
  { "myownconference.com.ua", true },
  { "myownconference.de", true },
  { "myownconference.es", true },
  { "myownconference.fr", true },
  { "myownconference.lt", true },
  { "myownconference.lv", true },
  { "myownconference.pl", true },
  { "myownconference.ru", true },
  { "mypagella.com", true },
  { "mypagella.eu", true },
  { "mypagella.it", true },
  { "mypayoffloan.com", true },
  { "myphonebox.de", true },
  { "myprintcard.de", true },
  { "myraytech.net", false },
  { "myruststats.com", true },
  { "mysecretcase.com", true },
  { "myshirtsize.com", true },
  { "mysmelly.com", true },
  { "mysoundtalks.com", true },
  { "mysticplumes.com", true },
  { "mytc.fr", true },
  { "mythslegendscollection.com", true },
  { "mytripcar.co.uk", true },
  { "mytripcar.com", true },
  { "mytripcar.de", true },
  { "mytripcar.es", true },
  { "mytty.net", true },
  { "mytweeps.com", true },
  { "myvpl.com", true },
  { "myworkinfo.com", true },
  { "myworth.com.au", true },
  { "myzina.cz", false },
  { "mziulu.me", true },
  { "n-pix.com", false },
  { "n0psled.nl", true },
  { "n2x.in", false },
  { "n4l.pw", true },
  { "nabankco.com", true },
  { "nabru.co.uk", true },
  { "nabytko.cz", true },
  { "nachsendeauftrag.net", true },
  { "nachsenden.info", true },
  { "nafod.net", true },
  { "nagaya.biz", true },
  { "nagb.gov", true },
  { "nagb.org", true },
  { "nagelfam.com", true },
  { "nagoya-kyuyo.com", true },
  { "nakedalarmclock.me", true },
  { "nakliyatsirketi.biz", true },
  { "nako.no", true },
  { "nalao-company.com", true },
  { "namacindia.com", true },
  { "namegrep.com", true },
  { "nameid.org", true },
  { "namepros.com", true },
  { "nametiles.co", true },
  { "naminam.de", true },
  { "namorico.me", false },
  { "namu.wiki", true },
  { "nan.zone", true },
  { "nanderson.me", true },
  { "nanogeneinc.com", true },
  { "nanogi.ga", true },
  { "nansay.cn", true },
  { "nanto.eu", true },
  { "narach.com", true },
  { "narada.com.ua", true },
  { "narfation.org", true },
  { "nargele.eu", true },
  { "nargileh.nl", true },
  { "naro.se", true },
  { "narodniki.com", true },
  { "narthollis.net", true },
  { "nartuk.com.ua", false },
  { "natalt.org", true },
  { "natanaelys.com", true },
  { "natenom.com", true },
  { "natenom.name", true },
  { "nathancheek.com", false },
  { "nathanmfarrugia.com", true },
  { "nathansmetana.com", true },
  { "nationalcentereg.org", true },
  { "nationalpriorities.org", true },
  { "natural-progesterone.net", true },
  { "naturesystems.cz", true },
  { "natuurbehangnederland.nl", true },
  { "nav.jobs", true },
  { "naval.tf", true },
  { "navjobs.com", true },
  { "navstevnik.sk", true },
  { "navycs.com", true },
  { "nayahe.ru", true },
  { "nb.zone", true },
  { "nb6.de", true },
  { "nbg-ha.de", false },
  { "nbl.org.tw", true },
  { "nbp.com.pk", true },
  { "ncc60205.info", true },
  { "ncoding.at", true },
  { "ncpc.gov", true },
  { "ncpw.gov", true },
  { "ncrmnt.org", true },
  { "ncstep.org", true },
  { "nct.org.uk", true },
  { "ndarville.com", true },
  { "ndbt.com", true },
  { "ne-on.org", true },
  { "ne1home.dyndns.org", true },
  { "neap.io", false },
  { "nearby.in.th", true },
  { "nebra.io", true },
  { "necesitodinero.org", true },
  { "nectarleaf.com", true },
  { "nedcdata.org", true },
  { "nedraconsult.ru", true },
  { "neel.ch", true },
  { "neer.io", true },
  { "neftebitum-kngk.ru", true },
  { "neg9.org", false },
  { "negai.moe", true },
  { "negativecurvature.net", true },
  { "neilgreen.net", true },
  { "neilwynne.com", false },
  { "neko-life.com", true },
  { "neko.li", true },
  { "nekomimi.pl", false },
  { "nekosc.com", true },
  { "nelhage.com", true },
  { "nella-project.org", true },
  { "nellacms.com", true },
  { "nellacms.org", true },
  { "nellafw.org", true },
  { "nemno.de", true },
  { "neo19.com", true },
  { "neosolution.ca", true },
  { "nepustil.net", true },
  { "nerd42.de", true },
  { "nerdjokes.de", true },
  { "nerdtime.de", true },
  { "nerdydev.net", true },
  { "neris.io", true },
  { "nerull7.info", true },
  { "nestedquotes.ca", true },
  { "net-safe.info", true },
  { "netbank.com.au", true },
  { "netbox.cc", true },
  { "netbrief.ml", true },
  { "netbulls.io", true },
  { "netera.se", true },
  { "netfs.pl", false },
  { "netfxharmonics.com", false },
  { "nethackwiki.com", true },
  { "netherwind.eu", true },
  { "netlocal.ru", true },
  { "netmagik.com", true },
  { "netmazk.net", true },
  { "netnodes.net", true },
  { "netprofile.com.au", true },
  { "netrelay.email", true },
  { "netrider.net.au", false },
  { "netronix.be", true },
  { "netsight.org", true },
  { "netsigna.de", true },
  { "netsoins.org", true },
  { "netsparker.com", false },
  { "netsystems.pro", true },
  { "nette.org", true },
  { "nettefoundation.com", true },
  { "nettools.link", true },
  { "nettopower.dk", true },
  { "netulo.com", true },
  { "netvizura.co.uk", true },
  { "netwarc.nl", true },
  { "netwerkmanager.nl", true },
  { "network-notes.com", true },
  { "network23.nl", true },
  { "networkalarmcorp.com", true },
  { "networking4all.com", true },
  { "networkingnexus.net", true },
  { "networkingphoenix.com", true },
  { "networx-online.de", true },
  { "netzvieh.de", true },
  { "netzwerkwerk.de", true },
  { "netzzwerg4u.de", true },
  { "neueonlinecasino2016.com", true },
  { "neuhaus-city.de", true },
  { "neuralgic.net", true },
  { "neuwal.com", true },
  { "nevadafiber.net", true },
  { "never-afk.de", true },
  { "new-black-order.com", true },
  { "new-process.ch", true },
  { "newantiagingcreams.com", true },
  { "newedivideo.it", true },
  { "newkaliningrad.ru", true },
  { "newline.online", true },
  { "newlooknow.com", true },
  { "newmediaone.net", true },
  { "newodesign.com", true },
  { "newpathintegratedtherapy.com", true },
  { "newportpropertygroup.com", true },
  { "newstarnootropics.com", true },
  { "newstone-tech.com", true },
  { "newsyslog.org", true },
  { "newtnote.com", true },
  { "newtonhaus.com", true },
  { "nex.sx", true },
  { "nexlab.org", true },
  { "next24.io", true },
  { "nextend.net", true },
  { "nextgencel.com", true },
  { "nfo.so", true },
  { "nfrost.me", true },
  { "ng-firewall.com", true },
  { "ng-security.com", true },
  { "nghe.net", true },
  { "nginxnudes.com", true },
  { "niagaraschoice.org", true },
  { "nibiisclaim.com", true },
  { "nicestudio.co.il", true },
  { "nichteinschalten.de", true },
  { "nichthelfer.de", true },
  { "nickloose.de", true },
  { "nickrickard.co.uk", true },
  { "nicky.io", true },
  { "nicoborghuis.nl", true },
  { "nicocourts.com", true },
  { "nicoknibbe.nl", true },
  { "nicolaeiotcu.ro", true },
  { "nicolaelmer.ch", true },
  { "nicolasbettag.me", true },
  { "nicolasklotz.de", true },
  { "nicolaw.uk", true },
  { "nidux.com", true },
  { "niduxcomercial.com", true },
  { "nierenpraxis-dr-merkel.de", true },
  { "nierenpraxis-merkel.de", true },
  { "nieselregen.com", false },
  { "niftiestsoftware.com", true },
  { "niggemeier.cc", true },
  { "nightfirec.at", true },
  { "nightfirecat.com", true },
  { "nightwinds.tk", true },
  { "nijm.nl", true },
  { "nikao-tech.com", true },
  { "nikklassen.ca", true },
  { "nikksno.io", true },
  { "niklaslindblad.se", true },
  { "nikobradshaw.com", true },
  { "nikolasbradshaw.com", true },
  { "nikolasgrottendieck.com", true },
  { "nikomo.fi", true },
  { "niloxy.com", true },
  { "nilrem.org", true },
  { "ninchat.com", true },
  { "nine-hells.net", false },
  { "ninespec.com", true },
  { "niouininon.eu", true },
  { "nippombashi.net", true },
  { "nippon-oku.com", true },
  { "nirada.info", true },
  { "nitropur.com", true },
  { "nixien.fr", true },
  { "nixmag.net", true },
  { "nkinka.de", true },
  { "nl-ix.net", true },
  { "nl.search.yahoo.com", false },
  { "nlegall.fr", true },
  { "nmctest.net", true },
  { "nmd.so", true },
  { "nmsnj.com", true },
  { "nnqc.nl", false },
  { "no.search.yahoo.com", false },
  { "nobly.de", true },
  { "nocit.dk", true },
  { "nocs.cn", true },
  { "nodari.com.ar", true },
  { "nodebrewery.com", true },
  { "nodecompat.com", true },
  { "nodelia.com", true },
  { "nodespin.com", true },
  { "nodi.at", true },
  { "noedidacticos.com", true },
  { "noemax.com", true },
  { "noez.de", true },
  { "nohats.ca", true },
  { "nohup.se", true },
  { "noima.com", true },
  { "noisetrap.cz", true },
  { "nojestorget.se", true },
  { "nolaviz.org", true },
  { "nolberg.net", true },
  { "nolte.work", false },
  { "nomadproject.io", true },
  { "nomesbiblicos.com", true },
  { "nomial.co.uk", true },
  { "nomorebytes.de", true },
  { "noname-ev.de", true },
  { "noob-box.net", false },
  { "noobunbox.net", true },
  { "noop.ch", true },
  { "noordsee.de", true },
  { "nopex.no", true },
  { "nopol.de", true },
  { "norandom.com", true },
  { "norb.at", true },
  { "nord-sud.be", true },
  { "nordiccasinocommunity.com", true },
  { "nordseeblicke.de", true },
  { "norrliden.de", true },
  { "norskpensjon.no", true },
  { "northcutt.com", true },
  { "northernmuscle.ca", true },
  { "nos-medias.fr", true },
  { "nos-oignons.net", true },
  { "nossasenhoradodesterro.com.br", true },
  { "nostraforma.com", false },
  { "notadd.com", true },
  { "notbolaget.se", true },
  { "notenoughtime.de", true },
  { "notificami.com", true },
  { "notjustbitchy.com", true },
  { "notoriousdev.com", true },
  { "nottheonion.net", true },
  { "nouvelle-vague-saint-cast.fr", true },
  { "novacoast.com", true },
  { "novafreixo.pt", true },
  { "novawave.ca", true },
  { "novelfeed.com", true },
  { "nowhere.dk", true },
  { "nowlas.org", true },
  { "noxlogic.nl", true },
  { "npmcdn.com", true },
  { "npw.net", true },
  { "nsboston.org", true },
  { "nsboutique.com", true },
  { "nshost.ro", true },
  { "nspeaks.com", true },
  { "nsweb.solutions", true },
  { "ntbs.pro", true },
  { "ntppool.org", true },
  { "nube.ninja", true },
  { "nukenet.se", true },
  { "nukute.com", true },
  { "null-sec.ru", true },
  { "null.cat", true },
  { "null.tips", true },
  { "number.me", true },
  { "numberoneshoes.co.nz", true },
  { "numero-aleatorio.com", true },
  { "nuos.org", true },
  { "nurserybook.co", true },
  { "nusatrip-api.com", true },
  { "nutleyeducationalfoundation.org", true },
  { "nutleyef.org", true },
  { "nutrienti.eu", true },
  { "nutritionculture.com", true },
  { "nuttyveg.com", true },
  { "nuvini.com", true },
  { "nuxer.fr", true },
  { "nvlop.xyz", true },
  { "nwa.xyz", true },
  { "nwgh.org", true },
  { "nwra.com", true },
  { "nwwc.dk", true },
  { "nyan.it", true },
  { "nyantec.com", true },
  { "nyffo.com", false },
  { "nyiad.edu", true },
  { "nyip.co.uk", true },
  { "nyip.edu", true },
  { "nymphetomania.net", true },
  { "nyronet.de", false },
  { "nysepho.pw", true },
  { "nyyu.tk", true },
  { "nzbs.io", false },
  { "o0o.one", true },
  { "o6asan.com", true },
  { "oaic.gov.au", true },
  { "oakslighting.co.uk", true },
  { "oasis.mobi", true },
  { "oasisim.net", true },
  { "obdolbacca.ru", true },
  { "obermeiers.eu", true },
  { "obscuredfiles.com", false },
  { "obsidianirc.net", true },
  { "obsproject.com", true },
  { "obsydian.org", false },
  { "occentus.net", true },
  { "ochsundjunior.ch", true },
  { "ockendenhemming.co.uk", true },
  { "ocotg.com", true },
  { "ocrami.us", true },
  { "octanio.com", true },
  { "octav.name", true },
  { "octocat.ninja", true },
  { "octothorpe.club", true },
  { "oddtime.net", true },
  { "ofcourselanguages.com", true },
  { "offshoot.rentals", true },
  { "offshore-firma.org", true },
  { "oftn.org", true },
  { "ogocare.com", true },
  { "ogogoshop.com", true },
  { "oguya.ch", true },
  { "oh14.de", true },
  { "ohiohealthfortune100.com", true },
  { "ohling.org", true },
  { "ohnemusik.com", true },
  { "ohsocool.org", true },
  { "oiepoie.nl", false },
  { "okane.love", true },
  { "oke.com.tw", true },
  { "okhrana.agency", true },
  { "okmx.de", true },
  { "okok-rent.com", true },
  { "okok.rent", true },
  { "okonetwork.org.uk", true },
  { "okutama.in.th", true },
  { "olafnorge.de", false },
  { "olcso-vps-szerver.hu", true },
  { "oleksii.name", true },
  { "olivierlemoal.fr", true },
  { "ollehbizev.co.kr", true },
  { "ollie.io", true },
  { "olliespage.net", true },
  { "ollning.com", true },
  { "olmari.fi", true },
  { "ols.io", true },
  { "omacostudio.com", true },
  { "omgaanmetidealen.com", true },
  { "omifind.com", true },
  { "omitech.co.uk", true },
  { "omniasl.com", true },
  { "omskit.ru", true },
  { "onaboat.se", true },
  { "onarto.com", true },
  { "ondrej.org", true },
  { "one---line.com", true },
  { "onearth.one", true },
  { "onedot.nl", true },
  { "onedrive.com", true },
  { "onedrive.live.com", false },
  { "onefour.ga", true },
  { "onehourloan.sg", true },
  { "oneminute.io", true },
  { "oneminutefilm.tv", true },
  { "onespiritinc.com", true },
  { "onet.space", true },
  { "oneway.ga", true },
  { "oneweb.hu", true },
  { "onewebdev.info", true },
  { "oneworldbank.com", true },
  { "onguardonline.gov", true },
  { "oniichan.us", true },
  { "onixcco.com.br", true },
  { "online-bouwmaterialen.nl", true },
  { "online-wetten.de", true },
  { "online.swedbank.se", true },
  { "onlinebizdirect.com", true },
  { "onlinecensorship.org", true },
  { "onlinecompliance.org", true },
  { "onlinedemo.hu", true },
  { "onlinedeposit.us", true },
  { "onlinelegalmarketing.com", true },
  { "onlinelegalmedia.com", true },
  { "onlinelighting.com.au", true },
  { "onlinetravelmoney.co.uk", true },
  { "onlinewetten.de", true },
  { "only-roses.com", true },
  { "onmaps.de", true },
  { "onmarketbookbuilds.com", true },
  { "ono.es", true },
  { "onqproductions.com", true },
  { "ons.ca", true },
  { "onsitemassageco.com", true },
  { "onthebriteside.com", true },
  { "ontimestamp.com", true },
  { "ontras.com", true },
  { "onvori.com", true },
  { "onvori.de", true },
  { "onysix.net", true },
  { "onyxwall.link", true },
  { "onyxwall.net", true },
  { "oogami.name", true },
  { "ooonja.de", true },
  { "oopsmycase.com", true },
  { "oost.io", true },
  { "ooyo.be", true },
  { "open-bs.com", true },
  { "open-bs.ru", true },
  { "open-future.be", true },
  { "open-mesh.org", true },
  { "open.gl", true },
  { "openacademies.com", true },
  { "openblox.org", true },
  { "openbsd.id", true },
  { "openconnect.com.au", true },
  { "openkvk.nl", true },
  { "openmind-shop.de", true },
  { "openmtbmap.org", true },
  { "opennippon.com", true },
  { "opennippon.ru", true },
  { "opensourcehouse.net", true },
  { "openstreetmap.is", true },
  { "opentrack.info", true },
  { "opentrash.org", true },
  { "openverse.com", true },
  { "openvz.org", true },
  { "openxmpp.com", true },
  { "opim.ca", true },
  { "opium.io", true },
  { "oplop.appspot.com", true },
  { "opperwall.net", true },
  { "opq.pw", true },
  { "oprbox.com", true },
  { "oprechtgezegd.nl", true },
  { "opreismetingvoorunicef.nl", true },
  { "opsbears.com", true },
  { "opsmate.com", false },
  { "opstacks.com", true },
  { "optimista.soy", true },
  { "optimus.io", true },
  { "optimuscrime.net", true },
  { "optmos.at", true },
  { "optometriepunt.nl", true },
  { "opus-codium.fr", true },
  { "oracaodocredo.com.br", true },
  { "orangutan-appeal.org.uk", true },
  { "orbiosales.com", true },
  { "orbitcom.de", true },
  { "orcahq.com", true },
  { "orcamoney.com", true },
  { "ordereat.fr", true },
  { "orderswift.com", true },
  { "orf-digitalsatkarte.at", true },
  { "orf-kartentausch.at", true },
  { "organic-superfood.net", true },
  { "oricejoc.com", true },
  { "orientalart.nl", true },
  { "orioncustompcs.com", false },
  { "orlives.de", true },
  { "oroweatorganic.com", true },
  { "osaiyuwu.com", true },
  { "oscarvk.ch", true },
  { "oscsdp.cz", true },
  { "oshayr.com", true },
  { "osm.is", true },
  { "osmanlitorunu.com", true },
  { "osmosis.org", true },
  { "osp.cx", true },
  { "osquery.io", true },
  { "ossbinaries.com", true },
  { "ostendorf.com", true },
  { "osterkraenzchen.de", true },
  { "osticketawesome.com", true },
  { "ostr.io", true },
  { "oszri.hu", true },
  { "otakurepublic.com", true },
  { "otichi.com", true },
  { "otoy.com", true },
  { "otpsmart.com.ua", true },
  { "otrsdemo.hu", true },
  { "ottoproject.io", true },
  { "otya.me", true },
  { "ourcloud.at", true },
  { "ourevents.net", true },
  { "outdoorproducts.com", true },
  { "outetc.com", true },
  { "overalglas.nl", true },
  { "overclockers.ge", true },
  { "overkillshop.com", true },
  { "override.io", true },
  { "overseamusic.de", true },
  { "oversight.garden", true },
  { "oversight.io", true },
  { "ovpn.to", true },
  { "ovvy.net", true },
  { "owensmith.website", true },
  { "own3d.ch", true },
  { "owncloud.help", true },
  { "ownit.se", false },
  { "ownmovies.fr", true },
  { "oxygaming.com", true },
  { "oxygenabsorbers.com", true },
  { "oxymc.com", true },
  { "oxynux.fr", true },
  { "oxynux.xyz", true },
  { "oyste.in", true },
  { "oznamovacipovinnost.cz", true },
  { "ozvolvo.org", true },
  { "p-s-b.com", true },
  { "p.linode.com", false },
  { "p1c.pw", true },
  { "p3in.com", true },
  { "pace.car", true },
  { "pacelink.de", true },
  { "packagist.org", false },
  { "packer.io", true },
  { "pacoda.de", true },
  { "pactf.com", true },
  { "paestbin.com", true },
  { "pagerate.io", true },
  { "pagetoimage.com", true },
  { "pagewizz.com", false },
  { "paginapolitica.ro", true },
  { "pagure.io", true },
  { "pagure.org", true },
  { "pahae.de", true },
  { "painosso.org", true },
  { "pajonzeck.de", true },
  { "pajowu.de", true },
  { "pajuvuo.fi", true },
  { "paket.io", true },
  { "pakke.de", true },
  { "pakremit.com", true },
  { "paku.me", true },
  { "palatin.at", true },
  { "palationtrade.com", true },
  { "palava.tv", true },
  { "pamplona.tv", true },
  { "pamsoft.pl", true },
  { "pan.digital", true },
  { "panaceallc.net", true },
  { "panamateakforestry.com", true },
  { "paneu.de", true },
  { "panmetro.com", true },
  { "panoti.com", true },
  { "pansu.space", true },
  { "panthur.com.au", false },
  { "pantou.org", false },
  { "pantsu.cat", true },
  { "pap.la", false },
  { "papa-webzeit.de", true },
  { "papayapythons.com", true },
  { "paperturn.com", true },
  { "paperwork.co.za", true },
  { "paradoxdesigns.org", true },
  { "paragon.com.sg", true },
  { "paragonie.com", true },
  { "paragreen.net", true },
  { "paranoxer.hu", true },
  { "parasitologyclub.org", true },
  { "paratlan.hu", true },
  { "parent5446.us", true },
  { "parentinterview.com", true },
  { "parentmail.co.uk", true },
  { "pariga.co.uk", true },
  { "parithy.net", true },
  { "parkingplus.co.il", true },
  { "parkingpoint.co.uk", true },
  { "parlamento.gub.uy", true },
  { "parleu2016.nl", true },
  { "parleur.net", true },
  { "parsemail.org", true },
  { "particonpsplus.it", true },
  { "partirkyoto.jp", true },
  { "partnerbeam.com", true },
  { "partnercardservices.com", true },
  { "partyhaus.ovh", true },
  { "partyvan.eu", true },
  { "partyvan.it", true },
  { "partyvan.moe", true },
  { "partyvan.nl", true },
  { "partyvan.se", true },
  { "passieposse.nl", true },
  { "passphrase.today", true },
  { "passport.yandex.by", true },
  { "passport.yandex.com", true },
  { "passport.yandex.com.tr", true },
  { "passport.yandex.kz", true },
  { "passport.yandex.ru", true },
  { "passport.yandex.ua", true },
  { "passwd.io", true },
  { "password.codes", true },
  { "passwordrevelator.net", true },
  { "passwords.google.com", true },
  { "pasta-factory.co.il", true },
  { "pastaenprosecco.nl", false },
  { "pastaf.com", true },
  { "paste.linode.com", false },
  { "pastebin.linode.com", false },
  { "pastenib.com", true },
  { "pasteros.io", true },
  { "pataua.kiwi", true },
  { "patechmasters.com", true },
  { "patentfamily.de", true },
  { "paternitydnatest.com", true },
  { "patfs.com", true },
  { "patralos.at", false },
  { "patrickschneider.me", true },
  { "patriksimek.cz", true },
  { "patt.us", true },
  { "paul.reviews", true },
  { "pauladamsmith.com", true },
  { "paulbdelaat.nl", true },
  { "paulchen.at", true },
  { "paulinewesterman.nl", true },
  { "paulproell.at", true },
  { "paulschreiber.com", true },
  { "paulyang.cn", true },
  { "pauspam.net", true },
  { "pay.ubuntu.com", true },
  { "payfreez.com", true },
  { "paylike.io", true },
  { "payment-network.com", true },
  { "paymentaccuracy.gov", true },
  { "payments-reference.org", true },
  { "paymill.com", true },
  { "paymill.de", true },
  { "payoff.com", true },
  { "paypal.com", false },
  { "paypaq.com", true },
  { "paypro.nl", false },
  { "payroll.ch", true },
  { "payroll.xero.com", false },
  { "paysera.com", true },
  { "payslipview.com", true },
  { "paytm.in", true },
  { "paytwopay.com", true },
  { "payupay.ru", true },
  { "pbapp.net", true },
  { "pbscreens.com", true },
  { "pcel.com", true },
  { "pcfeuerwehr.de", true },
  { "pcforum.sk", true },
  { "pchax.net", true },
  { "pclob.gov", true },
  { "pcloud.com", true },
  { "pctonic.net", true },
  { "pdamsidoarjo.co.id", true },
  { "pdevio.com", true },
  { "pdf.yt", true },
  { "pe.search.yahoo.com", false },
  { "peaceandwool.com", true },
  { "peakapp.nl", true },
  { "pear2pear.de", true },
  { "pedicureduiven.nl", true },
  { "pedroventura.com", true },
  { "peercraft.com", true },
  { "peerherrmann.de", true },
  { "peername.com", true },
  { "peervpn.net", true },
  { "peifi.de", true },
  { "pekkapikkarainen.fi", true },
  { "pekkarik.ru", true },
  { "pekoe.se", true },
  { "pelanucto.cz", true },
  { "pencepay.com", true },
  { "penfold.fr", true },
  { "pengi.me", true },
  { "penguinclientsystem.com", true },
  { "pennergold.net", true },
  { "pennyapp.io", true },
  { "pennylane.me.uk", true },
  { "pensiunealido.ro", true },
  { "pentano.net", true },
  { "pentest.nl", true },
  { "pentesterlab.com", true },
  { "peoplesbankal.com", true },
  { "pepchid.com", false },
  { "pepperhead.com", true },
  { "pepperworldhotshop.de", true },
  { "per-pedes.at", true },
  { "percolate.com", true },
  { "perdel.cn", true },
  { "perfect.in.th", true },
  { "perfectionis.me", true },
  { "perfectseourl.com", true },
  { "perfektesgewicht.com", true },
  { "perfektesgewicht.de", true },
  { "performancesantafe.org", true },
  { "performaterm.ro", true },
  { "perishablepress.com", true },
  { "perot.me", true },
  { "perplex.nl", false },
  { "perspectivum.com", true },
  { "persson.im", true },
  { "perthdevicelab.com", true },
  { "pestici.de", true },
  { "pet-nsk.ru", true },
  { "petabits.de", true },
  { "petchart.net", true },
  { "peter.org.ua", true },
  { "peterboers.info", true },
  { "peterdavehello.org", true },
  { "peterfolta.net", true },
  { "petersmark.com", false },
  { "pethub.com", true },
  { "petja.me", false },
  { "petko.me", true },
  { "petplum.com", true },
  { "petplus.com", true },
  { "petpost.co.nz", true },
  { "petrachuk.ru", true },
  { "petravdbos.nl", true },
  { "petruzz.net", true },
  { "petsittersservices.com", true },
  { "pettsy.com", true },
  { "peytonfarrar.com", true },
  { "pfadfinder-aurich.de", true },
  { "pfarchimedes-pensioen123.nl", true },
  { "pfd-nz.com", true },
  { "pfolta.net", true },
  { "pgmann.cf", true },
  { "pgmsource.com", true },
  { "pgpm.io", true },
  { "pgpmail.cc", true },
  { "pgregg.com", true },
  { "pgtb.be", true },
  { "ph.search.yahoo.com", false },
  { "phantasie.cc", true },
  { "pharmaboard.de", true },
  { "pharmgkb.org", true },
  { "pharynks.com", true },
  { "phil.tw", true },
  { "philadelphia.com.mx", true },
  { "philadelphiadancefoundation.org", true },
  { "philipkohn.com", true },
  { "philipmordue.co.uk", true },
  { "phillmoore.com", true },
  { "phillprice.com", true },
  { "philosopherswool.com", true },
  { "philosophyguides.org", true },
  { "philphonic.de", true },
  { "phoebe.co.nz", true },
  { "phoenix.dj", true },
  { "phoenixlogan.com", true },
  { "phormance.com", true },
  { "photo.org.il", true },
  { "photoblogverona.com", true },
  { "php-tuning.de", true },
  { "phparcade.com", true },
  { "phpdistribution.com", true },
  { "phpdorset.co.uk", true },
  { "phperformances.fr", true },
  { "phpfashion.com", true },
  { "phpsecure.info", true },
  { "phryanjr.com", false },
  { "phryneas.de", true },
  { "phunehehe.net", true },
  { "phurl.de", true },
  { "pi-supply.com", true },
  { "picardiascr.com", true },
  { "pickme.nl", true },
  { "pickr.co", true },
  { "picksin.club", true },
  { "picoauto.com", true },
  { "piconepress.com", true },
  { "picotech.com", true },
  { "picsto.re", true },
  { "piekacz.co.uk", true },
  { "piekacz.eu.org", true },
  { "piekacz.net", true },
  { "pieperhome.de", true },
  { "pieq.eu", true },
  { "pieq.eu.org", true },
  { "pier28.com", true },
  { "pierre-denoblens.net", true },
  { "pierre-schmitz.com", true },
  { "pieterhordijk.com", true },
  { "pieterjangeeroms.me", true },
  { "pijuice.com", true },
  { "pileofgarbage.net", true },
  { "pilgermaske.org", true },
  { "piligrimname.com", true },
  { "piliszek.net", true },
  { "pimpmymac.ru", true },
  { "pims.global", true },
  { "pincha.com.tw", true },
  { "pindanutjes.be", true },
  { "pinkcasino.co.uk", true },
  { "pinkhq.com", true },
  { "pinnaclelife.co.nz", true },
  { "pinnaclelife.nz", true },
  { "pipenny.net", true },
  { "pir9.com", true },
  { "pirateproxy.la", true },
  { "pirateproxy.pe", true },
  { "pirateproxy.pl", true },
  { "pirateproxy.pw", true },
  { "pirateproxy.sx", true },
  { "pirateproxy.tv", true },
  { "pirlitu.com", true },
  { "pirxpilot.me", true },
  { "pisexy.me", true },
  { "pisupp.ly", true },
  { "pitfire.io", false },
  { "pittonpreschool.com", true },
  { "piwko.co", true },
  { "pixel.facebook.com", false },
  { "pixel.google.com", true },
  { "pixelbash.de", true },
  { "pixelhero.co.uk", true },
  { "pixelminers.net", true },
  { "pixi.chat", true },
  { "pixi.me", true },
  { "pixipics.com", true },
  { "piyabute.com", true },
  { "pjuu.com", false },
  { "pkgt.de", true },
  { "pl.search.yahoo.com", false },
  { "placefade.com", true },
  { "placehold.co", true },
  { "placollection.org", true },
  { "plaettliaktion.ch", true },
  { "plainjs.com", false },
  { "plaintech.net.au", true },
  { "plaintray.com", true },
  { "planboardapp.com", true },
  { "planet-work.com", true },
  { "planete-cocoon.com", true },
  { "planpharmacy.com", true },
  { "plasti-pac.ch", true },
  { "play.google.com", true },
  { "playflick.com", true },
  { "playkh.com", true },
  { "playmaker.io", true },
  { "please-deny.me", true },
  { "pleier-it.de", true },
  { "pleier.it", true },
  { "plexusmd.com", true },
  { "plfgr.eu.org", true },
  { "plhdb.org", true },
  { "plirt.ru", false },
  { "plixer.com", true },
  { "ploader.ru", true },
  { "plogable.co", true },
  { "ploxel.com", true },
  { "pluff.nl", true },
  { "pluga.co", true },
  { "plugcubed.net", true },
  { "plugin-planet.com", true },
  { "plumlocosoft.com", true },
  { "plus.google.com", false },
  { "plus.sandbox.google.com", false },
  { "plzenskybarcamp.cz", true },
  { "pm13.cz", true },
  { "pm13.org", true },
  { "pmctire.com", true },
  { "pmg-offshore-company.com", true },
  { "pmg-purchase.com", true },
  { "pmg-purchase.net", true },
  { "pmnts.io", true },
  { "pmponline.de", true },
  { "pmt-documenten.nl", true },
  { "po.gl", true },
  { "pocketsix.com", true },
  { "pocloud.homelinux.net", true },
  { "poed.com.au", true },
  { "poedgirl.com", true },
  { "pointaction.com", true },
  { "pointagri.com", true },
  { "pointiswunderland.de", true },
  { "pointpro.de", true },
  { "pokeinthe.io", true },
  { "pokemori.jp", true },
  { "pol.in.th", true },
  { "poleartschool.com", true },
  { "policeiwitness.sg", true },
  { "polimat.org", true },
  { "polis.or.at", true },
  { "polis.to", false },
  { "politic.org.ua", true },
  { "politiewervingshop.nl", true },
  { "politologos.org", true },
  { "pollpodium.nl", true },
  { "polymathematician.com", true },
  { "polynomapp.com", true },
  { "polypet.com.sg", true },
  { "polypho.nyc", true },
  { "pompompoes.com", true },
  { "ponolau.com", true },
  { "pontualcomp.com", true },
  { "poolvilla-margarita.net", false },
  { "poon.io", false },
  { "poon.tech", true },
  { "poris.web.id", true },
  { "pornstars.me", true },
  { "port443.hamburg", true },
  { "port80.hamburg", true },
  { "portal.tirol.gv.at", true },
  { "portalplatform.net", true },
  { "portalzine.de", true },
  { "portercup.com", true },
  { "portosonline.pl", true },
  { "portraitsystem.biz", true },
  { "portvaletickets.com", true },
  { "posobota.cz", true },
  { "post4me.at", true },
  { "postal.dk", true },
  { "postbox.life", true },
  { "postcodegarant.nl", true },
  { "postcodewise.co.uk", true },
  { "posteo.de", false },
  { "posterspy.com", true },
  { "postfinance.ch", true },
  { "postn.eu", true },
  { "postpi.com", true },
  { "postscheduler.org", true },
  { "posttigo.com", true },
  { "potatofrom.space", true },
  { "potatoheads.net", true },
  { "potbar.com", true },
  { "potbox.com", true },
  { "pothe.com", true },
  { "pothe.de", true },
  { "potlytics.com", true },
  { "potpourrifestival.de", true },
  { "poussinooz.fr", true },
  { "povitria.net", true },
  { "power-of-interest.com", true },
  { "power99press.com", true },
  { "powercloud.technology", true },
  { "powerentertainment.tv", true },
  { "powergridess.com", true },
  { "powerwellness-korecki.de", true },
  { "powerxequality.com", true },
  { "ppipe.net", true },
  { "ppmoon.com", true },
  { "ppro.com", true },
  { "ppy3.com", true },
  { "pr1sm.com", true },
  { "pr2studio.com", true },
  { "practicallabs.com", true },
  { "prakharprasad.com", true },
  { "prayerrequest.com", true },
  { "prazynka.pl", true },
  { "precedecaritas.com.br", true },
  { "prediksisydney.com", true },
  { "predoiu.ro", true },
  { "prefis.com", true },
  { "prefontaine.name", true },
  { "prego-shop.de", true },
  { "preisser-it.de", true },
  { "preissler.co.uk", true },
  { "prekladysanca.cz", true },
  { "preloaded-hsts.badssl.com", true },
  { "premierheart.com", true },
  { "premiumzweirad.de", false },
  { "prepandgo-euro.com", true },
  { "preparetheword.com", false },
  { "prescotonline.co.uk", true },
  { "prescriptiondrugs.com", true },
  { "presidentials2016.com", true },
  { "press-anime-nenkan.com", true },
  { "pressrush.com", true },
  { "prestburyscouts.org.uk", true },
  { "pretix.eu", true },
  { "pretty.hu", true },
  { "prettytunesapp.com", true },
  { "preworkout.me", true },
  { "prezola.com", true },
  { "prgslab.net", true },
  { "pridetechdesign.com", true },
  { "pridoc.se", true },
  { "prilock.com", true },
  { "princessmargaretlotto.com", true },
  { "principaltoolbox.com", true },
  { "prior-it.be", true },
  { "priva.si", true },
  { "privacy.com", true },
  { "privacyinternational.org", true },
  { "privacylabs.io", true },
  { "privacyrup.net", true },
  { "privategiant.com", true },
  { "privatepokertour.com", true },
  { "privaterelay.com", true },
  { "privatestatic.com", true },
  { "privytime.com", true },
  { "prjktruby.com", true },
  { "pro-bike.ro", true },
  { "pro-link.eu", true },
  { "pro-zone.com", true },
  { "procensus.com", true },
  { "professionalboundaries.com", true },
  { "profidea.cz", true },
  { "profiles.google.com", true },
  { "profivps.com", true },
  { "profpay.com", true },
  { "profundr.com", true },
  { "progblog.net", true },
  { "progg.no", true },
  { "progreso.pl", true },
  { "progressiveplanning.com", true },
  { "prohostonline.fi", true },
  { "proitconsulting.com.au", true },
  { "projectarmy.net", true },
  { "projectascension.io", true },
  { "projectbenson.com", true },
  { "projectblackbook.us", true },
  { "projektzentrisch.de", true },
  { "promhadan.com", true },
  { "promoscuola.net", true },
  { "promotiongeeks.com", false },
  { "prontocleaners.co.uk", true },
  { "prontomovers.co.uk", true },
  { "proofwiki.org", true },
  { "proos.nl", true },
  { "propactrading.com", true },
  { "propagandism.org", true },
  { "propershave.com", true },
  { "property-catalogue.eu", true },
  { "propipesystem.com", true },
  { "proslimdiets.com", true },
  { "prosocialmachines.com", true },
  { "prosoft.sk", true },
  { "prospo.co", true },
  { "proteus-tech.com", true },
  { "protonmail.ch", true },
  { "protonmail.com", true },
  { "protoyou.de", true },
  { "proust.media", true },
  { "proustmedia.de", true },
  { "proximato.com", true },
  { "proxybay.al", true },
  { "proxybay.co", true },
  { "proxybay.la", true },
  { "proxybay.top", true },
  { "proxybay.tv", true },
  { "proxyweb.us", true },
  { "prtpe.com", true },
  { "prvikvadrat.hr", true },
  { "prytkov.com", true },
  { "przemas.pl", true },
  { "psb1911.com", true },
  { "psicologia.co.ve", true },
  { "psncardplus.be", true },
  { "psncardplus.com", true },
  { "psncardplus.dk", true },
  { "psncardplus.nl", true },
  { "psncardplus.se", true },
  { "pste.pw", true },
  { "psw-group.de", true },
  { "psw.academy", true },
  { "psw.consulting", true },
  { "psw.net", true },
  { "psxtr.com", true },
  { "pt-server.de", true },
  { "ptbx.co", true },
  { "pterodactylus.cz", true },
  { "ptgoldensun.com", true },
  { "ptm.ro", true },
  { "ptn.moscow", true },
  { "ptsoft.de", true },
  { "puac.de", true },
  { "pubkey.is", true },
  { "publications.qld.gov.au", false },
  { "publicsuffix.org", true },
  { "pubreviews.com", true },
  { "pucssa.org", true },
  { "puddis.de", true },
  { "pugliese.fr", true },
  { "puikheid.nl", true },
  { "puiterwijk.org", true },
  { "pulsar.guru", true },
  { "pult.co", false },
  { "pumpgames.net", true },
  { "punchkickinteractive.com", true },
  { "punkapoule.fr", true },
  { "punknews.org", true },
  { "pupboss.com", true },
  { "purewebmasters.com", false },
  { "purplebricks.com", true },
  { "purplemoon.ch", true },
  { "purplestar.ch", true },
  { "purplestar.com", true },
  { "puryearlaw.com", true },
  { "puyblanc.info", true },
  { "pvcvoordeel.nl", false },
  { "pvtschlag.com", true },
  { "pwd.ovh", true },
  { "pwnies.dk", true },
  { "pwntr.com", true },
  { "pxx.io", true },
  { "pygarage.com", true },
  { "pyol.org", true },
  { "pypa.io", true },
  { "pypi.io", true },
  { "pypi.python.org", true },
  { "pysays.net", true },
  { "python.org", false },
  { "q2.si", true },
  { "qa.fedoraproject.org", true },
  { "qa.stg.fedoraproject.org", true },
  { "qapital.com", true },
  { "qbeing.info", true },
  { "qc.search.yahoo.com", false },
  { "qccareerschool.com", true },
  { "qcdesignschool.com", true },
  { "qceventplanning.com", true },
  { "qcmakeupacademy.com", true },
  { "qcstudentcenter.com", true },
  { "qcstyleacademy.com", true },
  { "qctravelschool.com", true },
  { "qetesh.de", true },
  { "qewc.com", true },
  { "qgustavor.tk", true },
  { "qikan.net", true },
  { "qiliang.wang", true },
  { "qingpat.com", true },
  { "qingpei.me", true },
  { "qionglu.pw", true },
  { "qixxit.de", true },
  { "qkka.org", true },
  { "qldformulaford.org", true },
  { "qlrace.com", false },
  { "qop.io", true },
  { "qorm.co.uk", true },
  { "qrlending.com", true },
  { "qtl.me", true },
  { "qtpower.co.uk", true },
  { "qtxh.net", true },
  { "quai10.org", true },
  { "quail.solutions", true },
  { "quakelive.dk", true },
  { "qualityedgarsolutions.com", true },
  { "qualityhomesystems.com", true },
  { "qualityofcourse.com", true },
  { "qualityology.com", true },
  { "quantacloud.ch", true },
  { "quantenteranik.eu", true },
  { "quantoras.com", true },
  { "quantumfurball.net", true },
  { "quchao.com", true },
  { "quebecmailbox.com", true },
  { "queercinema.ch", true },
  { "queercoders.com", true },
  { "quera.ir", true },
  { "questsandrewards.com", true },
  { "quickpayservice.com", true },
  { "quietapple.org", true },
  { "quikpay.com.au", true },
  { "quintessa.org", true },
  { "quire.io", true },
  { "quli.nl", true },
  { "quotehex.com", true },
  { "quotemaster.co.za", true },
  { "quotev.com", true },
  { "quppa.net", true },
  { "quuz.org", true },
  { "qvitoo.com", true },
  { "qwant.com", true },
  { "qwilink.me", true },
  { "r0t.co", true },
  { "r0uzic.net", true },
  { "r10n.com", true },
  { "r3s1stanc3.me", true },
  { "r40.us", true },
  { "r6-team.ru", true },
  { "r811.de", true },
  { "raah.co", true },
  { "raajheshkannaa.com", true },
  { "racasdecachorro.org", true },
  { "racermaster.xyz", false },
  { "raceviewcycles.com", true },
  { "raceviewequestrian.com", true },
  { "racius.com", true },
  { "raconconsulting.co.uk", true },
  { "rad-route.de", true },
  { "radar.sx", true },
  { "radicaleducation.net", true },
  { "radtke.bayern", true },
  { "radyn.com", true },
  { "rafaelcz.de", true },
  { "rage4.com", true },
  { "ragingserenity.com", true },
  { "raidstone.com", true },
  { "raidstone.net", true },
  { "raidstone.rocks", true },
  { "railgun.ac", true },
  { "railyardurgentcare.com", true },
  { "rainforest.engineering", true },
  { "raiseyourflag.com", true },
  { "raitza.de", true },
  { "rak-business-service.com", true },
  { "ram-it.nl", true },
  { "ramatola.uk", true },
  { "ramon-c.nl", true },
  { "ramonj.nl", true },
  { "ramsor-gaming.de", true },
  { "randc.org", true },
  { "randomcage.com", true },
  { "randstaddirect.nl", false },
  { "rangde.org", true },
  { "rantanda.com", true },
  { "rapenroer.nl", true },
  { "rapido.nu", true },
  { "rapidthunder.io", true },
  { "raspass.me", true },
  { "ratajczak.fr", true },
  { "ratd.net", true },
  { "ratuseks.net", true },
  { "ratuseks.us", true },
  { "raulfraile.net", true },
  { "rauros.net", true },
  { "rautermods.net", true },
  { "ravchat.com", true },
  { "ravindran.me", true },
  { "rawoil.com", true },
  { "rawsec.net", true },
  { "rawstorieslondon.com", true },
  { "ray-home.de", true },
  { "ray-works.de", true },
  { "raydan.space", true },
  { "raydobe.me", false },
  { "raymd.de", true },
  { "raymii.org", true },
  { "raymondjcox.com", true },
  { "rayworks.de", true },
  { "razlaw.name", true },
  { "rbensch.com", true },
  { "rbhighinc.org", true },
  { "rburchell.com", true },
  { "rbxcatalog.com", true },
  { "rc4.io", true },
  { "rcafox.com", true },
  { "rcnitrotalk.com", true },
  { "rcorporation.be", true },
  { "rcpcbd.com", true },
  { "rdh.asia", true },
  { "reachr.com", true },
  { "reaconverter.com", true },
  { "reactivarte.es", true },
  { "reader.ga", true },
  { "readonly.de", true },
  { "readr.pw", true },
  { "realcapoeira.ru", true },
  { "realgarant-shop.de", false },
  { "reallifeforums.com", true },
  { "realmic.net", true },
  { "realmofespionage.com", true },
  { "realmofespionage.xyz", true },
  { "realwaycome.com", true },
  { "reanimated.eu", true },
  { "reardenporn.com", true },
  { "rebootmc.com", true },
  { "recapp.ch", true },
  { "recepty.eu", true },
  { "recht-freundlich.de", true },
  { "recommended.reviews", true },
  { "recon-networks.com", true },
  { "recordeuropa.com", true },
  { "recyclingpromotions.us", true },
  { "red-t-shirt.ru", true },
  { "redar.xyz", true },
  { "redb.cz", true },
  { "redballoonsecurity.com", true },
  { "redbee.nl", true },
  { "redburn.com", true },
  { "redd.it", true },
  { "reddingsbrigade-zwolle.nl", true },
  { "reddit.com", true },
  { "reddit2kindle.com", true },
  { "rede-reim.de", true },
  { "rede.ca", true },
  { "redicabo.de", true },
  { "redigest.it", true },
  { "redirect.fedoraproject.org", true },
  { "redirect.stg.fedoraproject.org", true },
  { "redit.com", true },
  { "redletter.link", true },
  { "redlink.de", true },
  { "redmbk.com", true },
  { "rednsx.org", true },
  { "redports.org", false },
  { "redra.ws", true },
  { "redshield.co", true },
  { "redshiftcybersecurity.co.za", true },
  { "redstickfestival.org", true },
  { "redteam-pentesting.de", true },
  { "redzurl.com", true },
  { "reedloden.com", true },
  { "reezer.org", true },
  { "refill-roboter.de", true },
  { "refreshingserum.com", true },
  { "refundo.cz", true },
  { "refundo.sk", true },
  { "reg.ru", false },
  { "regalosymuestrasgratis.com", true },
  { "regar42.fr", false },
  { "regendevices.eu", true },
  { "reggae-cdmx.com", true },
  { "regionalcoalition.org", true },
  { "regionale.org", true },
  { "regiovertrieb.de", true },
  { "register.gov.uk", true },
  { "regmyr.se", true },
  { "reiki-coaching.nl", true },
  { "reimers.de", true },
  { "reishunger.de", true },
  { "reisyukaku.org", true },
  { "reithguard-it.de", true },
  { "rejo.in", true },
  { "relaxhavefun.com", true },
  { "relayawards.com", true },
  { "release-monitoring.org", true },
  { "reliable-mail.de", true },
  { "rem.pe", true },
  { "remambo.jp", true },
  { "rememberthemilk.com", false },
  { "remitatm.com", true },
  { "remodela.com.ve", true },
  { "remonti.info", true },
  { "remotestance.com", true },
  { "remoteutilities.com", true },
  { "renderloop.com", true },
  { "rene-schwarz.com", true },
  { "renemoser.net", true },
  { "renkenlaw.com", true },
  { "renlong.org", true },
  { "renrenche.com", false },
  { "rentacarcluj.xyz", true },
  { "rentcarassist.com", false },
  { "rentinsingapore.com.sg", true },
  { "renuo.ch", true },
  { "reox.at", true },
  { "repaxan.com", true },
  { "replicagunsswords.com", false },
  { "report-uri.com", true },
  { "report-uri.io", true },
  { "reporturi.com", true },
  { "reporturi.io", true },
  { "republique.org", true },
  { "repustate.com", true },
  { "reputationweaver.com", true },
  { "res-rheingau.de", true },
  { "res42.com", true },
  { "resc.la", true },
  { "research.facebook.com", false },
  { "research.md", true },
  { "residentsinsurance.co.uk", true },
  { "resist.ca", true },
  { "resources.flowfinity.com", true },
  { "respice.xyz", true },
  { "responsibledisclosure.nl", true },
  { "restchart.com", true },
  { "restrito.org", true },
  { "retcor.net", true },
  { "retroarms.com", true },
  { "retroarms.cz", true },
  { "retrofitlab.com", true },
  { "reucon.com", true },
  { "revamed.com", false },
  { "revapost.ch", true },
  { "revello.org", true },
  { "revensoftware.com", true },
  { "revlect.com", true },
  { "revolt.tv", true },
  { "revthefox.co.uk", true },
  { "rewrite3.com", true },
  { "rex.st", true },
  { "rex.tc", true },
  { "rezept-planer.de", true },
  { "rezosup.net", true },
  { "rezosup.org", true },
  { "rgavmf.ru", true },
  { "rhapsodhy.hu", true },
  { "rhdigital.pro", true },
  { "rheocube.com", true },
  { "rhering.de", true },
  { "rheuma-online.de", true },
  { "rhinelander.ca", true },
  { "rhodenmanorcattery.co.uk", true },
  { "rhodri.io", true },
  { "rhymix.org", true },
  { "rhynl.io", true },
  { "ribs.com", true },
  { "riccy.org", true },
  { "richardhering.de", true },
  { "richardwarrender.com", true },
  { "richiemail.net", true },
  { "richmondsunlight.com", false },
  { "richsiciliano.com", true },
  { "ricki-z.com", true },
  { "rickyromero.com", true },
  { "ricochet.im", true },
  { "rid-wan.com", false },
  { "ride-up.com", true },
  { "riesenmagnete.de", true },
  { "riesenweber.id.au", true },
  { "rigart-michael.be", true },
  { "rigartmichael.be", true },
  { "right-to-love.name", true },
  { "rightcapital.com", true },
  { "righttobuy.gov.uk", true },
  { "riiconnect24.net", true },
  { "rijschoolgevonden.nl", false },
  { "rika.me", true },
  { "ring0.xyz", false },
  { "ringh.am", true },
  { "ringingliberty.com", true },
  { "rinobroer.nl", true },
  { "riscascape.net", true },
  { "rischard.org", true },
  { "riseup.net", true },
  { "riskmgt.com.au", true },
  { "riskmitigation.ch", true },
  { "ristioja.ee", true },
  { "rithm.ch", true },
  { "riversideauto.net", true },
  { "rivy.org", true },
  { "rix.ninja", true },
  { "riyono.com", true },
  { "rj.gg", true },
  { "rk6.cz", true },
  { "rlalique.com", true },
  { "rmb.li", true },
  { "rmmanfredi.com", true },
  { "rms.sexy", true },
  { "rmstudio.tw", true },
  { "rngmeme.com", true },
  { "ro.search.yahoo.com", false },
  { "roave.com", true },
  { "robandjanine.com", true },
  { "robertglastra.com", true },
  { "roberthurlbut.com", true },
  { "robertkrueger.de", true },
  { "robertof.ovh", true },
  { "robhorstmanshof.nl", true },
  { "robi-net.it", true },
  { "robigalia.org", true },
  { "robinadr.com", true },
  { "robinsonyu.com", true },
  { "robinwinslow.uk", true },
  { "robodeidentidad.gov", true },
  { "robohash.org", true },
  { "robspc.repair", true },
  { "robteix.com", true },
  { "robtex.com", true },
  { "robtex.net", true },
  { "robtex.org", true },
  { "robud.info", true },
  { "rochman.id", true },
  { "rockcanyonbank.com", true },
  { "rocketmill.co.uk", true },
  { "rodehutskors.net", true },
  { "rodney.id.au", true },
  { "rodolfo.gs", true },
  { "roeckx.be", true },
  { "roeitijd.nl", true },
  { "roelf.org", true },
  { "roeper.party", true },
  { "roffe.nu", true },
  { "rogue-e.xyz", true },
  { "rohedaten.de", true },
  { "rohlik.cz", true },
  { "rointe.online", true },
  { "rokki.ch", true },
  { "rokort.dk", true },
  { "roland.io", true },
  { "rolandreed.cn", true },
  { "rolemaster.net", true },
  { "romab.com", true },
  { "romaimperator.com", true },
  { "romainmuller.xyz", true },
  { "roman-pavlik.cz", true },
  { "romeoferraris.com", false },
  { "romulusapp.com", false },
  { "ron2k.za.net", true },
  { "room-checkin24.de", true },
  { "room208.org", true },
  { "roombase.nl", true },
  { "roomhub.jp", true },
  { "roosterpgplus.nl", true },
  { "root.eu.org", true },
  { "rootforum.org", true },
  { "rootrelativity.com", true },
  { "roots.io", true },
  { "rootservice.org", true },
  { "rootswitch.com", true },
  { "rootwpn.com", true },
  { "rop.io", true },
  { "roquecenter.org", true },
  { "rosenkeller.org", true },
  { "rossen.be", true },
  { "rot47.net", true },
  { "rotozen.com", true },
  { "rotterdamjazz.info", true },
  { "rottweil-hilft.de", true },
  { "rotunneling.net", true },
  { "rotzonline.com", false },
  { "roundcube.mayfirst.org", false },
  { "rous.se", true },
  { "rowancasting.ie", true },
  { "royalacademy.org.uk", true },
  { "royalhop.co", true },
  { "royalmarinesassociation.org.uk", true },
  { "royalpalacenogent.fr", true },
  { "royalpub.net", true },
  { "royalvisiongroup.com", true },
  { "royzez.com", true },
  { "rozalisbengal.ro", true },
  { "rpy.xyz", true },
  { "rr.in.th", true },
  { "rr105.de", true },
  { "rring.me", true },
  { "rrke.cc", true },
  { "rsajeey.info", true },
  { "rsauget.fr", true },
  { "rsi.im", false },
  { "rssr.se", true },
  { "rtcx.net", true },
  { "rtd.uk.com", true },
  { "ru-sprachstudio.ch", true },
  { "ru.search.yahoo.com", false },
  { "ruanmi.de", true },
  { "rubberfurs.org", true },
  { "rubbermaidoutlet.com", true },
  { "rubecodeberg.com", true },
  { "rubendv.be", true },
  { "rubi-ka.net", true },
  { "rubysecurity.org", true },
  { "rudeotter.com", true },
  { "ruderverein-gelsenkirchen.de", true },
  { "ruffbeatz.com", true },
  { "rugk.dedyn.io", true },
  { "rugstorene.co.uk", true },
  { "ruh-veit.de", true },
  { "ruhrmobil-e.de", true },
  { "runawebinar.nl", true },
  { "runcarina.com", true },
  { "runementors.com", true },
  { "runreport.fr", true },
  { "runway2street.com", true },
  { "ruobiyi.com", true },
  { "rusadmin.biz", true },
  { "rusempire.ru", true },
  { "rushball.net", true },
  { "rusl.net", true },
  { "russmarshall.com", true },
  { "rutgerschimmel.nl", true },
  { "ruudkoot.nl", true },
  { "rwanderlust.com", true },
  { "rws-vertriebsportal.de", true },
  { "rww.name", true },
  { "rxbusiness.com", true },
  { "ryan-goldstein.com", true },
  { "ryanhowell.io", true },
  { "ryankearney.com", true },
  { "ryanmcdonough.co.uk", true },
  { "ryansmithphotography.com", true },
  { "s-c.se", true },
  { "s-cubed.net", true },
  { "s-mdb.com", true },
  { "s13d.fr", true },
  { "sabahattin-gucukoglu.com", true },
  { "saccani.net", true },
  { "safar.sk", true },
  { "safcstore.com", true },
  { "safejourney.education", true },
  { "safematix.com", true },
  { "safeme.ga", true },
  { "safemovescheme.co.uk", true },
  { "safescan.com", true },
  { "safic.net", true },
  { "sagedocumentmanager.com", true },
  { "sagerus.com", true },
  { "sageth.com", true },
  { "sagsmarseille.com", true },
  { "saharalondon.com", true },
  { "saikarra.com", false },
  { "sailormoonevents.org", false },
  { "saintsrobotics.com", true },
  { "salaervergleich.com", true },
  { "sale4ru.ru", true },
  { "saleaks.org", true },
  { "saleslift.pl", true },
  { "salmo23.com.br", true },
  { "salmododia.net", true },
  { "salmos91.com", true },
  { "salon.io", false },
  { "saltercane.com", true },
  { "saltstack.cz", true },
  { "salverainha.org", true },
  { "samaritansnet.org", true },
  { "samba.org", true },
  { "sambeso.net", true },
  { "samegoal.com", true },
  { "samegoal.org", true },
  { "samfunnet.no", false },
  { "samifar.in", true },
  { "samirnassar.com", true },
  { "samizdat.cz", true },
  { "samkelleher.com", true },
  { "saml-gateway.org", true },
  { "saml2.com", true },
  { "sampoznay.ru", true },
  { "samraskauskas.com", true },
  { "samsen.club", true },
  { "samuelkeeley.com", true },
  { "samwu.tw", false },
  { "sanandreasstories.com", true },
  { "sanasalud.org", true },
  { "sanasport.cz", true },
  { "sanatfilan.com", true },
  { "sanchez.adv.br", true },
  { "sandbagexpress.com", true },
  { "sandbox.mydigipass.com", false },
  { "sandervankasteel.nl", true },
  { "sandobygg.se", true },
  { "sandogruppen.se", true },
  { "sandor.wtf", true },
  { "sanglierhurlant.fr", true },
  { "sangwon.io", true },
  { "sanhei.ch", true },
  { "sanissimo.com.mx", true },
  { "sanradon.by", true },
  { "santanderideas.com", true },
  { "santing.net", true },
  { "saorsat.ie", true },
  { "sapience.com", true },
  { "sarah-beckett-harpist.com", true },
  { "sarahbeckettharpist.com", true },
  { "sarahlicity.co.uk", false },
  { "sarahlicity.me.uk", true },
  { "sarahs-roestcafe.de", true },
  { "sarahsweetlife.com", true },
  { "sarakas.com", true },
  { "saraleebread.com", true },
  { "sarasturdivant.com", true },
  { "sardegnatirocini.it", true },
  { "sarindia.de", true },
  { "sarisonproductions.com", true },
  { "saro.me", true },
  { "saruwebshop.co.za", true },
  { "sash.pw", true },
  { "saskpension.com", true },
  { "sasyabapi.com", true },
  { "sat.rent", true },
  { "sat4all.com", true },
  { "satmep.com", true },
  { "satrent.com", true },
  { "satrent.se", true },
  { "satriyowibowo.my.id", true },
  { "satsukii.moe", true },
  { "saturne.tk", true },
  { "saucyfox.net", true },
  { "sauerbrey.eu", true },
  { "saulchristie.com", true },
  { "saunas.fr", true },
  { "save.gov", true },
  { "saveaward.gov", true },
  { "savekorea.net", true },
  { "savenet.org", true },
  { "savetheinternet.eu", true },
  { "saveyour.biz", true },
  { "savic.com", true },
  { "savingsstoreonline.ca", true },
  { "savvytime.com", true },
  { "sazuz.cz", true },
  { "sbirecruitment.co.in", true },
  { "sbox-archives.com", true },
  { "sbssoft.ru", true },
  { "sby.de", true },
  { "sc4le.com", true },
  { "scaling.solutions", true },
  { "scandicom.fi", true },
  { "scanpay.dk", true },
  { "schachburg.de", true },
  { "schallert.com", false },
  { "scheidtweiler.de", true },
  { "schlabbi.com", true },
  { "schlarp.com", true },
  { "schmitz.link", true },
  { "schneids.me", true },
  { "schnellno.de", true },
  { "schnouki.net", true },
  { "schoepski.de", true },
  { "schokokeks.org", true },
  { "school.in.th", true },
  { "schooltrends.co.uk", true },
  { "schoolze.com", true },
  { "schorelweb.nl", true },
  { "schreibnacht.de", true },
  { "schreinerei-jahreis.de", true },
  { "schritt4fit.de", true },
  { "schrodinger.io", true },
  { "schroepfglas-versand.de", true },
  { "schumanandmonnet.eu", true },
  { "schurkenstaat.net", true },
  { "schwarzer.it", true },
  { "schwarzkopfforyou.de", true },
  { "schwarzwaldcon.de", true },
  { "schwinabart.com", true },
  { "schwinger.me", true },
  { "scicasts.com", true },
  { "science-texts.de", true },
  { "sciencex.com", true },
  { "scottdial.com", true },
  { "scottgruber.me", true },
  { "scotthel.me", true },
  { "scotthelme.co.uk", true },
  { "scotthelme.com", true },
  { "scottstorey.co.uk", true },
  { "scourt.info", true },
  { "scourt.org.ua", true },
  { "scoutdb.ch", true },
  { "scp-trens.notaires.fr", true },
  { "scrambl.is", true },
  { "scrambler.in", false },
  { "scrap.tf", true },
  { "scrapings.net", true },
  { "scrayos.net", true },
  { "screencaster.io", true },
  { "screenlight.tv", true },
  { "screenresolution.space", true },
  { "scribe.systems", true },
  { "scrion.com", true },
  { "script.google.com", true },
  { "scriptict.nl", true },
  { "scrollstory.com", true },
  { "scs-simulatoren.de", true },
  { "sculpture.support", true },
  { "sdcardrecovery.de", true },
  { "sdrobs.com", true },
  { "sdsl-speedtest.de", true },
  { "se.search.yahoo.com", false },
  { "seamless.no", true },
  { "seanholcroft.co.uk", true },
  { "search-one.de", true },
  { "search.yahoo.com", false },
  { "searchbrothers.com", true },
  { "seasons.nu", true },
  { "seatbeltpledge.com", true },
  { "seattlefabrication.com", true },
  { "sebastianboegl.de", true },
  { "sebster.com", true },
  { "sec.gd", true },
  { "secandtech.com", true },
  { "secboom.com", true },
  { "secctexasgiving.org", false },
  { "secondary-survivor.com", true },
  { "secondary-survivor.help", true },
  { "secondary-survivor.net", true },
  { "secondarysurvivor.help", true },
  { "secondarysurvivorportal.com", true },
  { "secondarysurvivorportal.help", true },
  { "secpatrol.de", true },
  { "secretpanties.com", true },
  { "secretserveronline.com", true },
  { "sectia22.ro", true },
  { "sectio-aurea.org", true },
  { "section.io", true },
  { "sectun.com", true },
  { "secure-games.us", true },
  { "secure-server-hosting.com", true },
  { "secure.advancepayroll.com.au", true },
  { "secure.chat", true },
  { "secure.facebook.com", false },
  { "securedevelop.net", true },
  { "securedrop.org", false },
  { "secureideas.com", false },
  { "secureonline.co", true },
  { "secureradio.net", true },
  { "securify.nl", true },
  { "security-carpet.com", true },
  { "security-taskforce.be", true },
  { "security.google.com", true },
  { "securityheaders.com", true },
  { "securityheaders.io", true },
  { "securitymap.wiki", true },
  { "securitysnobs.com", false },
  { "securitysoapbox.com", true },
  { "securitystreak.com", true },
  { "secuvera.de", true },
  { "sedziapilkarski.pl", true },
  { "seedbox.fr", true },
  { "seele.ca", true },
  { "seen.life", true },
  { "segitz.de", true },
  { "segulink.com", true },
  { "segurosocial.gov", false },
  { "seida.at", true },
  { "seifried.org", true },
  { "seiko-dojo.com", true },
  { "selcusters.nl", true },
  { "selecadm.name", true },
  { "selectel.ru", true },
  { "selectorders.com", true },
  { "selectruckscalltrackingreports.com", true },
  { "selent.me", true },
  { "self-injury.net", true },
  { "selfcarecentral.com", true },
  { "selfici.com", true },
  { "selfici.cz", true },
  { "selfserverx.com", true },
  { "selldorado.com", true },
  { "sellme.biz", true },
  { "sellocdn.com", true },
  { "seminariruum.ee", true },
  { "semps-2fa.de", true },
  { "semps.de", true },
  { "semyonov.su", true },
  { "semyonov.us", true },
  { "sendc.at", true },
  { "sendcat.com", true },
  { "sendmeback.de", true },
  { "sendya.me", true },
  { "senedirect.com", true },
  { "seo-nerd.de", true },
  { "seo.consulting", true },
  { "sephr.com", true },
  { "septakkordeon.de", true },
  { "sequencing.com", true },
  { "serbanpaun.ro", true },
  { "serenitycreams.com", true },
  { "serfdom.io", true },
  { "serized.pw", true },
  { "serveradminz.com", true },
  { "serverco.com", true },
  { "servercode.ca", true },
  { "servergno.me", false },
  { "serveroffline.net", false },
  { "serverpedia.de", true },
  { "serverstuff.info", true },
  { "servertastic.com", true },
  { "servethecity-karlsruhe.de", false },
  { "servious.org", true },
  { "seryo.moe", true },
  { "seryo.net", true },
  { "seryovpn.com", true },
  { "sesha.co.za", true },
  { "sessionslogning.dk", true },
  { "setfix.de", true },
  { "setuid.de", true },
  { "setuid.io", true },
  { "setuid0.kr", true },
  { "sevenmatches.com", true },
  { "sevsopr.ru", true },
  { "sexton.uk.com", false },
  { "sexwork.net", true },
  { "seyahatsagliksigortalari.com", true },
  { "seyr.me", true },
  { "sftool.gov", true },
  { "sg.search.yahoo.com", false },
  { "sgcaccounts.co.uk", true },
  { "sh-network.de", true },
  { "shaaaaaaaaaaaaa.com", true },
  { "shadex.net", true },
  { "shadowkitsune.net", true },
  { "shadowmorph.info", true },
  { "shadowsocks.net", true },
  { "shagi29.ru", true },
  { "shaitan.eu", true },
  { "shakepeers.org", true },
  { "shakes4u.com", true },
  { "shakespearesolutions.com.au", true },
  { "shalott.org", true },
  { "shamariki.ru", true },
  { "shan.io", true },
  { "shanewadleigh.com", true },
  { "shannoneichorn.com", true },
  { "shaobin.wang", true },
  { "sharepass.pw", true },
  { "sharepic.xyz", true },
  { "sharepointdrive.com", true },
  { "sharescope.co.uk", true },
  { "sharesplitter.com", true },
  { "shareworx.net", true },
  { "sharvey.ca", true },
  { "shasso.com", true },
  { "shauncrowley.co.uk", true },
  { "shaundanielz.com", true },
  { "shawcentral.ca", true },
  { "shawnh.net", true },
  { "shazbots.org", true },
  { "sheilasdrivingschool.com", true },
  { "shellfire.de", true },
  { "shellvatore.us", true },
  { "shenghaiautoparts.com", true },
  { "shenyuqi.com", true },
  { "shep.co.il", true },
  { "sherbers.de", true },
  { "shft.cl", true },
  { "shh.sh", true },
  { "shiftplanning.com", true },
  { "shiinko.com", false },
  { "shinju.moe", true },
  { "shinnyosangha.org", false },
  { "shiona.xyz", true },
  { "shipard.com", true },
  { "shipcloud.io", true },
  { "shiroki-k.net", true },
  { "shodan.io", true },
  { "shome.de", true },
  { "shopapi.cz", true },
  { "shopbakersnook.com", true },
  { "shoplandia.co", true },
  { "shorebreaksecurity.com", true },
  { "shortdiary.me", true },
  { "shortpath.com", true },
  { "shortr.li", true },
  { "showsonar.com", true },
  { "shtorku.com", true },
  { "shu-kin.net", true },
  { "shulan.moe", true },
  { "shv25.se", true },
  { "shyrydan.es", true },
  { "si-benelux.nl", true },
  { "sichere-kartenakzeptanz.de", true },
  { "siciliadigitale.pro", true },
  { "siddhant.me", true },
  { "sideshowbarker.net", true },
  { "sidium.de", true },
  { "sidnicio.us", true },
  { "siebens.net", true },
  { "sieh.es", true },
  { "siewert-kau.de", true },
  { "sifls.com", true },
  { "sig6.org", true },
  { "sigabrt.org", true },
  { "sightcure.jp", true },
  { "sighup.nz", true },
  { "signere.com", true },
  { "signing-milter.org", true },
  { "signslabelstapesandmore.com", false },
  { "signtul.com", false },
  { "sigterm.sh", true },
  { "sikatehtaat.fi", true },
  { "sikayetvar.com", true },
  { "silentcircle.com", false },
  { "silentkernel.fr", true },
  { "silentlink.io", true },
  { "silentundo.org", true },
  { "silicagelpackets.ca", true },
  { "silkebaekken.no", true },
  { "sillisalaatti.fi", true },
  { "silver-heart.co.uk", true },
  { "silverbowflyshop.com", true },
  { "silverdragonart.com", true },
  { "silvergoldbull.com", true },
  { "silvergoldbull.de", true },
  { "silverhome.ninja", true },
  { "silverpvp.com", false },
  { "silverwind.io", true },
  { "silvistefi.com", true },
  { "simbihaiti.com", true },
  { "simbolo.co.uk", false },
  { "simobilklub.si", true },
  { "simod.org", false },
  { "simon-hofmann.org", true },
  { "simoncommunity.org.uk", true },
  { "simongong.net", true },
  { "simonkjellberg.com", true },
  { "simonkjellberg.se", true },
  { "simonreich.de", true },
  { "simonsreich.de", true },
  { "simonwessel.net", true },
  { "simpan.id", true },
  { "simphony.cz", true },
  { "simple.com", false },
  { "simpleai.net", true },
  { "simplednscrypt.org", true },
  { "simplelearner.com", true },
  { "simplepractice.com", true },
  { "simpletax.ca", false },
  { "simplexsupport.com", false },
  { "simplia.cz", true },
  { "simplixos.org", true },
  { "simply-premium.com", true },
  { "simplycharlottemason.com", true },
  { "simplyfixit.co.uk", true },
  { "simplymozzo.se", true },
  { "simplystudio.com", true },
  { "sin30.net", true },
  { "sincron.org", true },
  { "singleuse.link", true },
  { "singlu10.org", true },
  { "singul4rity.com", true },
  { "sinneserweiterung.de", true },
  { "sinoscandinavia.se", true },
  { "sinosky.org", true },
  { "siraweb.org", true },
  { "sirenslove.com", true },
  { "sirius-lee.net", true },
  { "siriuspup.com", true },
  { "sistem-maklumat.com.my", true },
  { "sistemy48.ru", false },
  { "sisv.eu", true },
  { "sitehost.io", true },
  { "sites.google.com", true },
  { "sitesko.de", true },
  { "sitesten.com", true },
  { "sizingservers.be", false },
  { "sizzle.co.uk", true },
  { "sjoorm.com", true },
  { "skalender.ch", true },
  { "skanvordoff.ru", true },
  { "skaraborgsassistans.com", false },
  { "skarrok.com", true },
  { "skatclub-beratzhausen.de", true },
  { "skatn.de", true },
  { "skeeley.com", true },
  { "skhoop.cz", true },
  { "ski-insurance.com.au", true },
  { "skia.org", true },
  { "skigebiete-test.de", true },
  { "skilldetector.com", true },
  { "skilletfood.com", true },
  { "skills2services.com", true },
  { "skillseo.com", true },
  { "skimming.net", true },
  { "skipfault.com", true },
  { "skk.io", true },
  { "skoda-clever-lead.de", true },
  { "skoda-im-dialog.de", true },
  { "skoda-nurdiebesten.de", true },
  { "skoda-service-team-cup.de", true },
  { "skogsbruket.fi", true },
  { "skogskultur.fi", true },
  { "skoleniphp.cz", true },
  { "skotty.io", true },
  { "skou.dk", true },
  { "skyasker.com", true },
  { "skydrive.live.com", false },
  { "skyflix.me", true },
  { "skyminds.net", true },
  { "skyveo.ml", true },
  { "skyway.capital", true },
  { "sl1pkn07.wtf", true },
  { "slack-files.com", true },
  { "slack.com", true },
  { "sladic.si", false },
  { "slainvet.net", true },
  { "slamdjapan.com", true },
  { "slamix.nl", true },
  { "slaps.be", true },
  { "slashdesign.it", false },
  { "slattery.co", true },
  { "slauber.de", true },
  { "sleio.com", true },
  { "slever.cz", true },
  { "slevomat.cz", true },
  { "sliceone.com", true },
  { "slicklines.co.uk", true },
  { "slidebatch.com", true },
  { "slightfuture.click", true },
  { "slightfuture.com", true },
  { "slix.io", true },
  { "sloancom.com", true },
  { "slope.haus", true },
  { "slotboss.co.uk", true },
  { "slotcar.com", true },
  { "slowfood.es", true },
  { "slse.ca", true },
  { "slxh.eu", true },
  { "slxh.nl", true },
  { "slycurity.de", true },
  { "smallchat.nl", true },
  { "smalldata.tech", true },
  { "smallplanet.ch", true },
  { "smares.de", true },
  { "smart-ov.nl", true },
  { "smartairkey.com", true },
  { "smartcleaningcenter.nl", true },
  { "smartftp.com", true },
  { "smarthdd.com", true },
  { "smarthomedna.com", true },
  { "smarthouse.de", true },
  { "smartit.pro", true },
  { "smartlend.se", true },
  { "smartlocksmith.com", true },
  { "smartmessages.net", true },
  { "smartphone.continental.com", false },
  { "smartpolicingplatform.com", true },
  { "smartrak.co.nz", true },
  { "smartshiftme.com", true },
  { "smartship.co.jp", true },
  { "smartsparrow.com", true },
  { "smartwurk.nl", true },
  { "smb445.com", true },
  { "smdavis.us", true },
  { "sme-gmbh.net", true },
  { "smiatek.name", true },
  { "smirkingwhorefromhighgarden.pro", true },
  { "smith.is", true },
  { "smithandcanova.co.uk", true },
  { "smittix.co.uk", true },
  { "smkw.com", true },
  { "smm.im", true },
  { "smoo.st", true },
  { "smoothics.com", true },
  { "smove.sg", true },
  { "smow.com", true },
  { "smow.de", true },
  { "sms1.ro", true },
  { "smvfd.info", true },
  { "snailing.org", true },
  { "snakehosting.dk", false },
  { "snapappointments.com", true },
  { "snapappts.com", true },
  { "snazel.co.uk", true },
  { "snazzie.nl", true },
  { "sneakpod.de", true },
  { "sneakynote.com", true },
  { "sneberger.cz", true },
  { "sneezry.com", true },
  { "snelwerk.be", true },
  { "snelxboxlivegold.nl", true },
  { "snfdata.com", true },
  { "sniderman.eu.org", true },
  { "sniep.net", true },
  { "snl.no", true },
  { "snod.land", true },
  { "snoozedds.com", true },
  { "snoqualmiefiber.org", true },
  { "snoupon.com", true },
  { "snow-online.com", true },
  { "snow-online.de", true },
  { "snowcrestdesign.com", true },
  { "snughealth.org.uk", true },
  { "sny.no", true },
  { "so-healthy.co.uk", true },
  { "sobabox.ru", true },
  { "sobie.ch", true },
  { "social-events.net", true },
  { "social-media-strategies.it", true },
  { "socialbillboard.com", true },
  { "socialdevelop.biz", true },
  { "socialgrowing.cl", true },
  { "socialhams.net", false },
  { "socialhead.io", true },
  { "socialnous.co", true },
  { "socialrank.com", true },
  { "socialsecurity.gov", false },
  { "societyhilldance.com", true },
  { "socioambiental.org", true },
  { "sockeye.cc", false },
  { "sodi.nl", true },
  { "sofort.com", true },
  { "sofortueberweisung.de", true },
  { "softwarebetrieb.de", true },
  { "softwaredesign.foundation", true },
  { "sogeek.me", true },
  { "sogravatas.net.br", true },
  { "sogutma.com.tr", true },
  { "soia.ca", true },
  { "soju.fi", true },
  { "sokkenhoek.nl", true },
  { "sol-3.de", true },
  { "solar-ec.com", true },
  { "soldecom.com", true },
  { "soleus.nu", true },
  { "solidfuelappliancespares.co.uk", true },
  { "solidus.systems", true },
  { "solihullcarnival.co.uk", true },
  { "solihulllionsclub.org.uk", true },
  { "soll-i.ch", true },
  { "solomisael.com", true },
  { "solsystems.ru", true },
  { "solutionhoisthire.com.au", true },
  { "solved.tips", true },
  { "somebodycares.org", true },
  { "somethingnew.xyz", true },
  { "sona-gaming.com", true },
  { "sonafe.info", true },
  { "sondergaard.de", true },
  { "sonicrainboom.rocks", true },
  { "soondy.com", true },
  { "soph.us", true },
  { "sopheos.com", true },
  { "soply.com", true },
  { "soporte.cc", true },
  { "sortaweird.net", true },
  { "sorz.org", true },
  { "sos.sk", true },
  { "sosaka.ml", true },
  { "sosecu.red", true },
  { "sotar.us", true },
  { "sotiran.com", true },
  { "sotor.de", true },
  { "souki.cz", true },
  { "soulfulglamour.uk", true },
  { "soulogic.com", false },
  { "soumikghosh.com", true },
  { "soundforsound.co.uk", true },
  { "soundgasm.net", true },
  { "soundtalks.com", true },
  { "sour.is", true },
  { "sourcebox.be", true },
  { "sourcely.net", true },
  { "sourceway.de", true },
  { "sous-surveillance.net", true },
  { "southernutahinfluencers.com", true },
  { "southside-crew.com", true },
  { "southworcestershiregpservices.co.uk", true },
  { "souvik.me", true },
  { "soved.eu", true },
  { "sovereignshare.com", true },
  { "sown.dyndns.org", true },
  { "sowncloud.de", true },
  { "sp.rw", false },
  { "spacecompute.com", true },
  { "spacedust.xyz", true },
  { "spacefish.biz", true },
  { "spaggel.nl", true },
  { "sparelib.com", true },
  { "sparkforautism.org", true },
  { "sparklebastard.com", true },
  { "sparsa.army", true },
  { "spauted.com", true },
  { "spawn.cz", true },
  { "spaysy.com", true },
  { "spdf.net", true },
  { "spectrosoftware.de", true },
  { "speculor.net", true },
  { "speed-mailer.com", true },
  { "speedcounter.net", true },
  { "speedmann.de", true },
  { "speedtest-russia.com", true },
  { "speedy.lt", true },
  { "speedyprep.com", true },
  { "speich.net", true },
  { "speidel.com.tr", true },
  { "sperrstun.de", true },
  { "spherenix.org", true },
  { "spibe.is", true },
  { "spicydog.org", true },
  { "spicydog.tk", true },
  { "spicymatch.com", true },
  { "spideroak.com", true },
  { "spiegels.nl", true },
  { "spielcasinos.com", true },
  { "spiet.nl", true },
  { "spillmaker.no", true },
  { "spins.fedoraproject.org", true },
  { "spirit-dev.net", true },
  { "spiritbionic.ro", true },
  { "spitefultowel.com", true },
  { "spititout.it", true },
  { "splikity.com", true },
  { "splitdna.com", true },
  { "sponsortobias.com", true },
  { "sportifik.com", true },
  { "spot-events.com", true },
  { "spotifyripper.tk", true },
  { "spreadsheets.google.com", true },
  { "spreed.me", true },
  { "sprigings.com", true },
  { "spritchard.photos", true },
  { "sprueche-zum-valentinstag.de", true },
  { "sprueche-zur-geburt.info", true },
  { "sprueche-zur-hochzeit.de", true },
  { "sprueche-zur-konfirmation.de", true },
  { "sprutech.de", true },
  { "spuffin.com", true },
  { "spydersec.com", true },
  { "spyprofit.ru", true },
  { "spyroszarzonis.com", true },
  { "sqlapius.net", true },
  { "sqr-training.com", true },
  { "sqshq.de", true },
  { "square-gaming.org", true },
  { "square-src.de", true },
  { "square.com", false },
  { "square.gs", true },
  { "squareup.com", false },
  { "squawk.cc", true },
  { "squeezemetrics.com", true },
  { "src.fedoraproject.org", true },
  { "srchub.org", true },
  { "srevilak.net", true },
  { "sritest.io", true },
  { "srna.sk", true },
  { "sro.center", true },
  { "srpdb.com", true },
  { "srrr.ca", true },
  { "srv47.de", true },
  { "ss.lv", false },
  { "ssa.gov", false },
  { "ssbrm.ch", true },
  { "sscd.no", true },
  { "ssl-zertifikate.de", true },
  { "ssl.google-analytics.com", true },
  { "ssl.rip", true },
  { "ssl247.co.uk", true },
  { "ssl247.com.mx", true },
  { "ssl247.de", true },
  { "ssl247.dk", true },
  { "sslcertificaten.nl", true },
  { "sslcheck.nl", true },
  { "ssldecoder.org", true },
  { "sslhosting.cz", true },
  { "sslmate.com", true },
  { "sslpoint.com", true },
  { "sslsurvey.de", true },
  { "sslzilla.de", true },
  { "ssmato.me", true },
  { "ssnc.org", true },
  { "sss3s.com", true },
  { "sstewartgallus.com", true },
  { "ssworld.ga", true },
  { "staack.com", true },
  { "stablelib.com", true },
  { "stabletoken.com", true },
  { "stackptr.com", true },
  { "stadionmanager.com", true },
  { "stadjerspasonline.nl", true },
  { "stadtbauwerk.at", true },
  { "stage-props-blank-guns.com", false },
  { "stage.wepay.com", false },
  { "stageirites.fr", true },
  { "stagingjobshq.com", true },
  { "stagstickets.co.uk", true },
  { "stahl.xyz", true },
  { "stalder.work", true },
  { "stalker-shop.com", true },
  { "stalkerhispano.com", true },
  { "stamkassa.nl", true },
  { "stanandjerre.org", true },
  { "standardssuck.org", true },
  { "standingmist.com", true },
  { "star-citizen.wiki", true },
  { "starapple.nl", true },
  { "starcomproj.com", true },
  { "stardanceacademy.net", true },
  { "stargatepartners.com", true },
  { "starmusic.ga", true },
  { "starpeak.org", true },
  { "starsam80.net", true },
  { "starstreak.net", true },
  { "startupsort.com", true },
  { "stash.ai", true },
  { "stat.ink", true },
  { "state-sponsored-actors.net", true },
  { "statecover.com.au", true },
  { "stateofexception.io", true },
  { "static.or.at", true },
  { "static.wepay.com", false },
  { "staticisnoise.com", true },
  { "stationary-traveller.eu", true },
  { "stationaryjourney.com", true },
  { "stationnementdenuit.ca", true },
  { "statuschecks.net", true },
  { "statuscode.ch", true },
  { "stay.black", true },
  { "stayokhotelscdc-mailing.com", true },
  { "stbennett.org", true },
  { "stderr.cc", true },
  { "steakovercooked.com", true },
  { "stealsaga.net", true },
  { "steamdb.info", true },
  { "steckregal-super.de", true },
  { "steelephys.com.au", true },
  { "stefanovski.io", true },
  { "stefanweiser.de", true },
  { "stefany.eu", true },
  { "steidlewirt.de", true },
  { "steigerplank.com", true },
  { "stellanova-planeten.de", true },
  { "stellenticket.de", true },
  { "stemsims.com", true },
  { "stephanierxo.com", true },
  { "stephenandburns.com", true },
  { "stereo.lu", true },
  { "stereochro.me", false },
  { "sternplastic.com", true },
  { "stesti.cz", true },
  { "stevegrav.es", true },
  { "stevenhumphrey.uk", true },
  { "stevensononthe.net", true },
  { "steventress.com", true },
  { "stewartremodelingadvantage.com", true },
  { "stichtingsticky.nl", true },
  { "stick2bike.de", true },
  { "sticklerjs.org", true },
  { "stig.io", true },
  { "stigharder.com", true },
  { "stigroom.com", true },
  { "stillblackhat.id", true },
  { "stinkytrashhound.com", true },
  { "stirling.co", false },
  { "stirlingpoon.com", false },
  { "stirlingpoon.xyz", true },
  { "stjohnin.com", true },
  { "stjohnmiami.org", true },
  { "stkbn.com", true },
  { "stmbgr.com", true },
  { "stnl.de", true },
  { "stocktrade.de", false },
  { "stocktrader.com", true },
  { "stoffe-monster.de", true },
  { "stoffelen.nl", true },
  { "stoianlawfirm.com", true },
  { "stoick.me", true },
  { "stolina.de", true },
  { "stolkschepen.nl", true },
  { "stomt.com", true },
  { "stopwoodfin.org", true },
  { "storecove.com", true },
  { "storedsafe.com", true },
  { "storefrontify.com", true },
  { "stormhub.org", true },
  { "stormyyd.com", true },
  { "storvann.net", true },
  { "storvann.no", true },
  { "storycollective.nl", true },
  { "stpatricksguild.com", true },
  { "strasweb.fr", false },
  { "strchr.com", true },
  { "streampanel.net", false },
  { "streams.dyndns.org", true },
  { "streamzilla.com", true },
  { "stressfreehousehold.com", true },
  { "stretchmyan.us", true },
  { "stricted.net", true },
  { "strictlysudo.com", true },
  { "strijkshop.be", true },
  { "stripe.com", true },
  { "strobeltobias.de", true },
  { "strobeto.de", true },
  { "strongest-privacy.com", true },
  { "structurally.net", true },
  { "strugee.net", true },
  { "stuartbaxter.co", false },
  { "stuartbell.co.uk", true },
  { "studenckiemetody.pl", true },
  { "student.andover.edu", true },
  { "studentloans.gov", true },
  { "studentskydenik.cz", true },
  { "studer.su", true },
  { "studienportal.eu", true },
  { "studiozelden.com", true },
  { "studlan.no", true },
  { "studyhub.cf", true },
  { "stugb.de", true },
  { "stulda.cz", true },
  { "stumf.si", true },
  { "stuntmen.xyz", true },
  { "stupendous.net", true },
  { "stupus.com", true },
  { "stutelage.com", true },
  { "stuur.nl", false },
  { "stw-group.at", true },
  { "stygium.net", false },
  { "styleci.io", true },
  { "stylenda.com", true },
  { "styles.pm", true },
  { "su1ph3r.io", true },
  { "suave.io", true },
  { "subdimension.org", false },
  { "subeesu.com", true },
  { "subrosa.io", true },
  { "subseq.net", false },
  { "subtitle.rip", true },
  { "suche.org", true },
  { "sudo.ws", true },
  { "sufix.cz", true },
  { "suian.or.jp", true },
  { "suite73.org", true },
  { "sulek.eu", true },
  { "sumoatm.com", true },
  { "sumoscout.de", true },
  { "sunbritetv.com", true },
  { "sundayfundayjapan.com", true },
  { "suneilpatel.com", true },
  { "sunflyer.cn", false },
  { "sunnyfruit.ru", true },
  { "sunsetwx.com", true },
  { "suos.io", true },
  { "supastuds.com", true },
  { "supcro.com", true },
  { "super-o-blog.com", true },
  { "superbabysitting.ch", true },
  { "superbart.nl", true },
  { "superbshare.com", true },
  { "supereight.net", true },
  { "superhome.com.au", true },
  { "superkonsult.se", true },
  { "supermarx.nl", true },
  { "superswingtrainer.com", true },
  { "superwally.org", true },
  { "supplies24.at", true },
  { "supplies24.es", true },
  { "support.mayfirst.org", false },
  { "suprlink.net", true },
  { "supweb.ovh", false },
  { "surfone-leucate.com", true },
  { "surgenet.nl", true },
  { "surgicalassociateswny.com", true },
  { "surkatty.org", true },
  { "survature.com", true },
  { "surveypirate.com", true },
  { "survivalmonkey.com", true },
  { "susanbpilates.co", true },
  { "susanbpilates.com", true },
  { "susastudentenjobs.de", true },
  { "sushi101tempe.com", true },
  { "sushifrick.de", true },
  { "sustainability.gov", true },
  { "sustsol.com", true },
  { "sv-turm-hohenlimburg.de", true },
  { "svager.cz", true },
  { "svallee.fr", false },
  { "svarovani.tk", true },
  { "svatba-frantovi.cz", true },
  { "sveneckelmann.de", true },
  { "svenskacasino.com", true },
  { "svijet-medija.hr", true },
  { "swaggerdile.com", true },
  { "swaleacademiestrust.org.uk", true },
  { "swansdoor.org", true },
  { "swapadoodle.com", true },
  { "sway-cdn.com", true },
  { "sway.com", true },
  { "swedishhost.com", true },
  { "swedishhost.se", true },
  { "sweetll.me", true },
  { "sweetstreats.ca", true },
  { "swehack.org", false },
  { "swift-devedge.de", true },
  { "swimming.ca", true },
  { "swimturk.com.tr", true },
  { "swiss-cyber-experts.ch", true },
  { "swite.com", true },
  { "swyn.net", true },
  { "sx3.no", true },
  { "sy-anduril.de", true },
  { "syam.cc", true },
  { "sycamorememphis.org", false },
  { "sychov.pro", true },
  { "syezd.com.au", true },
  { "sykepleien.no", true },
  { "sylaps.com", true },
  { "sylvaindurand.org", true },
  { "sylvan.me", true },
  { "sylvanorder.com", true },
  { "synabi.com", true },
  { "synackr.com", true },
  { "synapticconsulting.co.uk", true },
  { "synatra.co", true },
  { "sync-it.no", true },
  { "syncappate.com", true },
  { "synchrocube.com", true },
  { "syncmylife.net", true },
  { "syncserve.net", true },
  { "synfin.org", true },
  { "synony.me", true },
  { "syntaxnightmare.com", true },
  { "syriatalk.biz", true },
  { "syriatalk.org", true },
  { "syrocon.ch", true },
  { "sysadmin.xyz", true },
  { "sysadmins.ro", true },
  { "sysctl.se", false },
  { "sysdb.io", true },
  { "sysmike.de", true },
  { "sysmike.net", true },
  { "syso.name", true },
  { "syss.de", true },
  { "system.is", true },
  { "systemintegra.ru", true },
  { "systemreboot.net", true },
  { "syzygy-tables.info", true },
  { "szagun.net", true },
  { "szaszm.tk", true },
  { "szaydon.me", false },
  { "szechenyi2020.hu", true },
  { "szentistvanpt.sk", true },
  { "szongott.net", true },
  { "t-hawk.com", true },
  { "t-point.eu", true },
  { "t-shirts4less.nl", true },
  { "t0dd.eu", false },
  { "t23m-navi.jp", false },
  { "t3rror.net", true },
  { "t7e.de", true },
  { "taabe.xyz", true },
  { "tabelfirme.ro", true },
  { "tabla-periodica.com", true },
  { "tablotv.com", false },
  { "taborsky.cz", true },
  { "tacomafia.net", true },
  { "tacticalsquare.com", true },
  { "tadigitalstore.com", true },
  { "tahf.net", true },
  { "tailpuff.net", true },
  { "tails.com.ar", true },
  { "take1give1.com", true },
  { "taken.pl", true },
  { "takeshifujimoto.com", true },
  { "takk.pl", true },
  { "takkaaaaa.com", true },
  { "takusan.ru", true },
  { "talado.gr", false },
  { "talentcast.nl", true },
  { "talideon.com", false },
  { "talk.google.com", true },
  { "talkgadget.google.com", true },
  { "talklifestyle.nl", true },
  { "talktwincities.com", true },
  { "tallr.se", true },
  { "tallshoe.com", true },
  { "talsi.eu", true },
  { "tamasszabo.net", true },
  { "tangibilizing.com", true },
  { "tangiblesecurity.com", true },
  { "taniesianie.pl", true },
  { "tankski.co.uk", true },
  { "tannenhof-moelln.de", true },
  { "tantalos.nl", true },
  { "tante-bugil.net", true },
  { "tantotiempo.de", true },
  { "tapfinder.ca", true },
  { "tappublisher.com", true },
  { "taquilla.com", true },
  { "taranis.re", true },
  { "taravancil.com", true },
  { "tarhauskielto.fi", true },
  { "tartaneagle.org.uk", false },
  { "tartaros.fi", true },
  { "tas2580.net", true },
  { "taskforce512.de", true },
  { "taskotron.fedoraproject.org", true },
  { "taskotron.stg.fedoraproject.org", true },
  { "taskstats.com", true },
  { "taskstream.com", true },
  { "taskulu.com", true },
  { "tasmansecurity.com", true },
  { "tastycake.net", true },
  { "tastyyy.co", true },
  { "tatilbus.com", false },
  { "tatort-fanpage.de", true },
  { "tauchkater.de", true },
  { "tavoittaja.fi", true },
  { "taxaroo.com", true },
  { "taxbench.com", true },
  { "taxisafmatosinhos.pt", true },
  { "taxspeaker.com", true },
  { "taxsquirrel.com", true },
  { "tazemama.biz", true },
  { "tazj.in", false },
  { "tazz.in", true },
  { "tbarter.com", false },
  { "tbitc.ch", true },
  { "tbrss.com", true },
  { "tbspace.de", true },
  { "tc-bonito.de", true },
  { "tcao.info", true },
  { "tcdw.net", true },
  { "tcgrepublic.com", true },
  { "tcomms.org", true },
  { "tdelmas.eu", true },
  { "tdelmas.ovh", true },
  { "tdrs.info", true },
  { "teabagdesign.co.uk", true },
  { "teachercreatedmaterials.com", true },
  { "teachforcanada.ca", true },
  { "team-bbd.com", true },
  { "team-one.racing", true },
  { "teamblueridge.org", true },
  { "teamnorthgermany.de", true },
  { "teampaddymurphy.ie", true },
  { "teampoint.cz", true },
  { "teamsocial.co", true },
  { "teamtouring.net", true },
  { "teamupturn.com", true },
  { "teamzeus.cz", true },
  { "teasenetwork.com", true },
  { "tecart-cloud.de", true },
  { "tecart-system.de", true },
  { "tecartcrm.de", true },
  { "tech-clips.com", true },
  { "tech-essential.com", true },
  { "tech-rat.com", true },
  { "tech-seminar.jp", true },
  { "tech55i.com", true },
  { "techandtux.de", true },
  { "techassist.io", true },
  { "techcavern.ml", true },
  { "techcentric.com", false },
  { "techelements.co", true },
  { "techhipster.net", true },
  { "techhub.ml", true },
  { "techllage.com", true },
  { "techloaner.com", true },
  { "techmajesty.com", true },
  { "techmatehq.com", true },
  { "technoparcepsilon.fr", true },
  { "technosavvyport.com", true },
  { "technotonic.com.au", false },
  { "techorbiter.com", true },
  { "techpivot.net", true },
  { "techpointed.com", true },
  { "techvalue.gr", true },
  { "tecnogaming.com", true },
  { "tecture.de", true },
  { "teddy.ch", true },
  { "tedeh.net", true },
  { "teebeedee.org", true },
  { "teemo.gg", true },
  { "teemperor.de", true },
  { "tehotuotanto.net", true },
  { "tehrabbitt.com", false },
  { "teknologi.or.id", true },
  { "telefisk.org", true },
  { "telefonkonferenz.ch", true },
  { "telekollektiv.org", true },
  { "teleogistic.net", true },
  { "telescam.com", true },
  { "tellingua.com", true },
  { "temizmama.com", true },
  { "temp.pm", true },
  { "tempcraft.net", true },
  { "tempus-aquilae.de", true },
  { "tendertool.nl", true },
  { "tenenz.com", true },
  { "tengroup.com", true },
  { "tenni.xyz", true },
  { "tennisadmin.com", true },
  { "tensionup.com", true },
  { "tent.io", true },
  { "tentations-voyages.com", true },
  { "tenyx.de", true },
  { "teodio.cl", true },
  { "teos.online", true },
  { "teoskanta.fi", true },
  { "tepid.org", true },
  { "teriiphotography.com", true },
  { "terrab.de", true },
  { "terracloud.de", true },
  { "terraelectronica.ru", true },
  { "terraform.io", true },
  { "terrastaffinggroup.com", true },
  { "terravirtua.com", true },
  { "terraweb.net", true },
  { "terrax.info", true },
  { "terrax.net", true },
  { "terrty.net", true },
  { "tescoirelandpayslips.com", true },
  { "tesoro.pr", true },
  { "testadren.com", true },
  { "testandroid.xyz", true },
  { "testingbot.com", true },
  { "testnode.xyz", true },
  { "testsuite.org", true },
  { "tetsumaki.net", true },
  { "teuniz.nl", true },
  { "teunstuinposters.nl", true },
  { "textburst.com", true },
  { "texte-zur-taufe.de", true },
  { "texter-linz.at", true },
  { "texterseo.at", true },
  { "textoplano.xyz", true },
  { "textracer.dk", true },
  { "textualapp.com", true },
  { "texy.info", true },
  { "tezcam.tk", true },
  { "tf-network.de", true },
  { "tf2b.com", true },
  { "tf2stadium.com", true },
  { "tfcoms-sp-tracker-client.azurewebsites.net", true },
  { "tfl.lu", true },
  { "tfnapps.de", true },
  { "tgr.re", true },
  { "th-bl.de", true },
  { "th.search.yahoo.com", false },
  { "thackbarth.net", true },
  { "thaicyberpoint.com", true },
  { "thaihostcool.com", true },
  { "thca.ca", true },
  { "the-construct.com", true },
  { "the-earth-yui.net", true },
  { "the-gist.io", true },
  { "the-paddies.de", true },
  { "theamateurs.net", true },
  { "theamp.com", true },
  { "theater.cf", true },
  { "theberkshirescompany.com", true },
  { "thebigdatacompany.com", true },
  { "thebigwave.de", true },
  { "thebikeinsurer.co.uk", true },
  { "thebimhub.com", true },
  { "thebreakroom.org", true },
  { "thebrotherswarde.com", true },
  { "thecandidforum.com", true },
  { "thecapitalbank.com", true },
  { "thecharlestonwaldorf.com", true },
  { "thecitizens.com", true },
  { "thecitywarehouse.clothing", true },
  { "theclementinebutchers.com", true },
  { "thecloudmigrator.com", true },
  { "theclubjersey.com", true },
  { "thecustomizewindows.com", true },
  { "thedark1337.com", true },
  { "thedevrycommonsbrasil.com", true },
  { "thedisc.nl", true },
  { "thedreamtravelgroup.co.uk", true },
  { "theendofzion.com", true },
  { "theescapistswiki.com", true },
  { "theeyeopener.com", true },
  { "thefarbeyond.com", true },
  { "thefox.co", true },
  { "thefrozenfire.com", false },
  { "thegcccoin.com", true },
  { "thego2swatking.com", false },
  { "thegoldregister.co.uk", true },
  { "thegraciousgourmet.com", true },
  { "thegvoffice.net", true },
  { "thehackerblog.com", true },
  { "thehiddenbay.eu", true },
  { "thehiddenbay.me", true },
  { "thehiddenbay.net", true },
  { "thehonorguard.org", true },
  { "thehotfix.net", true },
  { "theinitium.com", true },
  { "theintercept.com", true },
  { "theinvisibletrailer.com", true },
  { "theitsage.com", true },
  { "thejserver.de", true },
  { "thekelvinliu.com", false },
  { "thekingofhate.com", true },
  { "thelaimlife.com", true },
  { "thelapine.ca", true },
  { "thelastsurprise.com", true },
  { "thelinuxspace.com", true },
  { "thelittlecraft.com", true },
  { "thelocals.ru", true },
  { "themarble.co", true },
  { "themarshallproject.org", true },
  { "themeaudit.com", true },
  { "themicrocapital.com", true },
  { "themoderate.xyz", true },
  { "themoep.at", true },
  { "themostexpensiveworkofart.com", true },
  { "thenocman.com", true },
  { "thenorthschool.org.uk", true },
  { "theodorejones.info", false },
  { "theojones.name", false },
  { "thepaymentscompany.com", true },
  { "thepb.in", true },
  { "thephonecaseplace.com", true },
  { "thepiratebay.al", true },
  { "thepiratebay.poker", true },
  { "theploughharborne.co.uk", true },
  { "theramo.re", true },
  { "therapynotes.com", true },
  { "therewill.be", true },
  { "therockawaysny.com", true },
  { "thescientists.nl", true },
  { "theseed.io", true },
  { "theseletarmall.com", true },
  { "theseoframework.com", true },
  { "thesession.org", false },
  { "theshadestore.com", true },
  { "thesharepointfarm.com", true },
  { "theshopally.com", true },
  { "thesled.net", true },
  { "thestagchorleywood.co.uk", true },
  { "thestory.ie", true },
  { "thetechnical.me", true },
  { "thetradinghall.com", true },
  { "thetuxkeeper.de", true },
  { "theunitedstates.io", true },
  { "theweilai.com", false },
  { "thewhitehat.club", true },
  { "thewhitneypaige.com", true },
  { "thewindow.com", true },
  { "theworldsend.eu", true },
  { "theyosh.nl", true },
  { "thezero.org", true },
  { "thibautcharles.net", true },
  { "thierfreund.de", true },
  { "thierryhayoz.ch", true },
  { "thinkcoding.de", true },
  { "thinkcoding.org", true },
  { "thinkindifferent.net", true },
  { "thinklikeanentrepreneur.com", true },
  { "thinktux.net", true },
  { "thinlyveiledcontempt.com", true },
  { "thirdpartytrade.com", true },
  { "thisisacompletetest.ga", true },
  { "thisisforager.com", true },
  { "thisserver.dontexist.net", true },
  { "thiswebhost.com", false },
  { "thkb.net", true },
  { "thom4s.info", true },
  { "thomas-grobelny.de", true },
  { "thomasbreads.com", true },
  { "thomasgriffin.io", true },
  { "thomashunter.name", false },
  { "thomaskliszowski.fr", false },
  { "thomasnet.fr", true },
  { "thomastimepieces.com.au", true },
  { "thomspooren.nl", true },
  { "thomwiggers.nl", true },
  { "thorbis.com", true },
  { "thorbiswebsitedesign.com", true },
  { "thorgames.nl", true },
  { "thouni.de", true },
  { "threatcentral.io", true },
  { "threedpro.me", true },
  { "threelions.ch", true },
  { "throughthelookingglasslens.co.uk", true },
  { "throwaway.link", true },
  { "throwpass.com", true },
  { "thrx.net", true },
  { "thusoy.com", true },
  { "thyngster.com", false },
  { "tiacollection.com", true },
  { "tianshili.me", true },
  { "ticketmates.com.au", true },
  { "ticketoplichting.nl", true },
  { "tickettoaster.de", true },
  { "tickopa.co.uk", true },
  { "tickreport.com", true },
  { "tictactux.de", true },
  { "tid.jp", false },
  { "tidycustoms.net", true },
  { "tiendavertigo.com", true },
  { "tiendschuurstraat.nl", true },
  { "tiens-ib.cz", true },
  { "tifan.net", true },
  { "tiffnix.com", true },
  { "tigerchef.com", true },
  { "tigerdile.com", true },
  { "tikutiku.pl", true },
  { "tilikum.io", true },
  { "tillseasyscore.com", true },
  { "timbuktutimber.com", true },
  { "timcamara.com", true },
  { "timersuite.com", true },
  { "timetab.org", true },
  { "timmersgems.com", true },
  { "timmy.ws", true },
  { "timtaubert.de", true },
  { "timvivian.ca", true },
  { "timwittenberg.com", true },
  { "tinastahlschmidt.de", true },
  { "tinfoilsecurity.com", false },
  { "tinkertry.com", false },
  { "tinte24.de", true },
  { "tintenfix.net", true },
  { "tinylan.com", true },
  { "tinyvpn.net", true },
  { "tinyvpn.org", true },
  { "tiplanet.org", true },
  { "tipps-fuer-den-haushalt.de", true },
  { "tippspiel.cc", true },
  { "tipsyk.ru", true },
  { "titanous.com", true },
  { "tittelbach.at", true },
  { "tjenestetorvet.dk", true },
  { "tlach.cz", true },
  { "tlo.hosting", true },
  { "tlo.link", true },
  { "tlo.network", true },
  { "tlo.xyz", true },
  { "tls.builders", true },
  { "tls.care", true },
  { "tls.li", true },
  { "tls1914.org", true },
  { "tm-solutions.eu", true },
  { "tmaward.net", true },
  { "tmf.ru", true },
  { "tmi-products.eu", true },
  { "tmi-produkter.se", true },
  { "tmitchell.io", true },
  { "tmpraider.net", true },
  { "tmpsantos.com.br", true },
  { "tmtopup.com", true },
  { "tncnanet.com.br", true },
  { "tnes.dk", true },
  { "tno.io", true },
  { "tobias-kluge.de", true },
  { "tobiasmathes.com", true },
  { "tobiasmathes.name", true },
  { "tobiassachs.de", true },
  { "tobiassattler.com", true },
  { "toccoig.com", true },
  { "todesschaf.org", true },
  { "todo.is", true },
  { "todoist.com", true },
  { "tofu.im", true },
  { "togelonlinecommunity.com", true },
  { "tokaido.com", true },
  { "tokke.dk", true },
  { "tokoone.com", false },
  { "tokyo-powerstation.com", true },
  { "tollsjekk.no", true },
  { "tom.horse", true },
  { "tomasjacik.cz", true },
  { "tomask.info", true },
  { "tomaspialek.cz", true },
  { "tomatenaufdenaugen.de", true },
  { "tomaw.net", true },
  { "tombaker.me", true },
  { "tombrossman.com", true },
  { "tomcort.com", true },
  { "tomeara.net", true },
  { "tomfisher.eu", true },
  { "tomli.me", true },
  { "tommsy.com", true },
  { "tommyads.com", true },
  { "tomo.gr", false },
  { "tomrei.com", true },
  { "tomrichards.net", true },
  { "tomudding.nl", true },
  { "tomvote.com", true },
  { "tomwiggers.nl", false },
  { "tomwilson.io", true },
  { "tonabor.ru", true },
  { "tonage.de", true },
  { "tonburi.jp", true },
  { "toncusters.nl", true },
  { "tonegidoarchief.nl", false },
  { "toner24.at", true },
  { "toner24.co.uk", true },
  { "toner24.es", true },
  { "toner24.fr", true },
  { "toner24.it", true },
  { "toner24.nl", true },
  { "toner24.pl", true },
  { "tonerdepot.de", true },
  { "tonerjet.at", true },
  { "tonerjet.co.uk", true },
  { "tonerklick.de", true },
  { "tonerkurier.de", true },
  { "tonermaus.de", true },
  { "tonermonster.de", true },
  { "tonex.de", true },
  { "tonex.nl", true },
  { "tonkinson.com", true },
  { "tonsit.com", true },
  { "tonsit.org", true },
  { "tonyfantjr.com", true },
  { "tonymanning.com", false },
  { "tonytan.cn", true },
  { "tonytan.io", true },
  { "tonywebster.com", true },
  { "toolbox.ninja", true },
  { "toomanypillows.com", true },
  { "tooolroc.org", true },
  { "top-stage.net", true },
  { "topbrakes.com", true },
  { "topdevbox.net", true },
  { "topfivepercent.co.uk", true },
  { "topmarine.se", true },
  { "topnewstoday.org", true },
  { "topnovini.com", true },
  { "toptexture.com", true },
  { "toptranslation.com", true },
  { "topyx.com", true },
  { "tor2web.org", true },
  { "torahanytime.com", true },
  { "tormentedradio.com", true },
  { "torproject.org", false },
  { "torprojects.com", true },
  { "torquato.de", false },
  { "torrent.fedoraproject.org", true },
  { "torrent.is", true },
  { "torrenttop100.net", true },
  { "torsten-schmitz.net", true },
  { "torv.rocks", true },
  { "tosecure.link", true },
  { "toshkov.com", true },
  { "toshnix.com", true },
  { "tosteberg.se", true },
  { "totalbeauty.co.uk", true },
  { "totalcarcheck.co.uk", true },
  { "totalchecklist.com", true },
  { "totaltriathlon.com", true },
  { "totch.de", true },
  { "totem-eshop.cz", true },
  { "totem-international.com", true },
  { "toucedo.de", true },
  { "touch.facebook.com", false },
  { "touch.mail.ru", true },
  { "touchstonefms.co.uk", true },
  { "touhou.cc", true },
  { "tourispo.com", true },
  { "tout-art.ch", true },
  { "toutart.ch", true },
  { "toverland-tickets.nl", true },
  { "towandalibrary.org", true },
  { "townhousedevelopments.com.au", true },
  { "tox.im", true },
  { "toxme.se", true },
  { "toysperiod.com", true },
  { "tp-iryuubun.com", true },
  { "tp-kabushiki.com", true },
  { "tp-kyouyufudousan.com", true },
  { "tp-law.jp", true },
  { "tpbproxy.co", true },
  { "tppleague.me", true },
  { "tr.search.yahoo.com", false },
  { "traas.org", true },
  { "trabbel.org", true },
  { "trackchair.com", true },
  { "trade-smart.ru", true },
  { "tradeacademy.in", true },
  { "tradedesk.co.za", true },
  { "tradeinvent.co.uk", true },
  { "trademan.ky", true },
  { "trainex.org", true },
  { "trakfusion.com", true },
  { "tranos.de", true },
  { "transacid.de", true },
  { "transdirect.com.au", true },
  { "transfers.do", true },
  { "transfigurewizard.com", true },
  { "transformify.org", true },
  { "transitpoint.us", true },
  { "translate.fedoraproject.org", true },
  { "translate.googleapis.com", true },
  { "translate.stg.fedoraproject.org", true },
  { "transmithe.net", true },
  { "transportal.sk", true },
  { "transverify.com", true },
  { "trashnothing.com", true },
  { "trauertexte.info", true },
  { "travador.com", true },
  { "travelinsurance.co.nz", true },
  { "travisf.net", true },
  { "treebaglia.xyz", true },
  { "treeby.net", true },
  { "treeschat.com", true },
  { "trell.co.in", true },
  { "trendkraft.de", true },
  { "tresorit.com", true },
  { "tresorsecurity.com", true },
  { "tretkowski.de", true },
  { "tribaldos.com", true },
  { "tribut.de", true },
  { "trident-online.de", true },
  { "trik.es", true },
  { "trim-a-slab.com", true },
  { "trimage.org", true },
  { "trineco.com", true },
  { "trineco.fi", true },
  { "trinnes.net", true },
  { "triop.se", true },
  { "triple-mmm.de", true },
  { "tripseats.com", true },
  { "troi.de", true },
  { "trollme.me", true },
  { "trommelwirbel.com", true },
  { "trondelan.no", true },
  { "trophee-discount.com", true },
  { "truckerswereld.nl", true },
  { "truckstop-magazin.de", true },
  { "trueblueessentials.com", true },
  { "truebred-labradors.com", true },
  { "truejob.com", true },
  { "truestaradvisors.com", true },
  { "trueteaching.com", true },
  { "trufflemonkey.co.uk", true },
  { "trunkjunk.co", true },
  { "truserve.org", true },
  { "trusitio.com", true },
  { "trustedinnovators.com", true },
  { "trusteecar.com", true },
  { "trustmeimfancy.com", true },
  { "truthmessages.pw", true },
  { "trw-reseller.com", true },
  { "tryfabulousdiet.com", true },
  { "tryfabulousskincream.com", true },
  { "tryfabulousskinserum.com", true },
  { "tryoneday.co", true },
  { "trywesayyes.com", true },
  { "trzepak.pl", true },
  { "ts3.consulting", true },
  { "tsecy.com", true },
  { "tsgbit.net", true },
  { "tsrstore.gq", true },
  { "tssouthernpower.com", true },
  { "tsumegumi.net", true },
  { "tsumi.it", true },
  { "ttcf.ca", true },
  { "tty.space", true },
  { "ttz.im", true },
  { "tuamoronline.com", true },
  { "tubepro.de", true },
  { "tucny.com", true },
  { "tucuxi.org", true },
  { "tuingereedschappen.net", true },
  { "tuitle.com", true },
  { "tumelum.de", true },
  { "tumutanzi.com", true },
  { "tunai.id", true },
  { "tunebitfm.de", true },
  { "tunnelblick.net", true },
  { "tuntitili.fi", true },
  { "turbobit.ch", true },
  { "turnik-67.ru", true },
  { "turniker.ru", true },
  { "turtle.ai", true },
  { "turtlementors.com", true },
  { "tuvalie.com", true },
  { "tuxcall.de", true },
  { "tuxcloud.net", true },
  { "tuxflow.de", true },
  { "tuxgeo.com", false },
  { "tuxplace.nl", true },
  { "tuxz.net", true },
  { "tuzaijidi.com", true },
  { "tvbeugels.nl", true },
  { "tw.search.yahoo.com", false },
  { "twaka.com", true },
  { "twarog.cc", true },
  { "twd2.me", true },
  { "twd2.net", false },
  { "twee-onder-een-kap-woning-in-brielle-kopen.nl", true },
  { "twelve.rocks", true },
  { "twelve.today", true },
  { "twentymilliseconds.com", true },
  { "twist.party", true },
  { "twisto.cz", true },
  { "twitter.com", false },
  { "twitteroauth.com", true },
  { "twofactorauth.org", true },
  { "twolinepassbrewing.com", true },
  { "twopif.net", true },
  { "txf.pw", true },
  { "ty2u.com", true },
  { "tyche.io", true },
  { "tyl.io", true },
  { "tylerschmidtke.com", true },
  { "typeblog.net", true },
  { "typecodes.com", true },
  { "typeonejoe.com", true },
  { "typewolf.com", true },
  { "typing.com", true },
  { "typingrevolution.com", true },
  { "typo3.com", true },
  { "tyrelius.com", true },
  { "tysye.ca", true },
  { "tzappa.net", true },
  { "u-blox.com", true },
  { "uae-company-service.com", true },
  { "uangteman.com", true },
  { "uasmi.com", true },
  { "uat-activesg.com", true },
  { "ub3rk1tten.com", false },
  { "ubanquity.com", true },
  { "uber.com.au", true },
  { "uberboxen.net", true },
  { "ubertt.org", true },
  { "ubicloud.de", true },
  { "ubicv.com", true },
  { "ublox.com", true },
  { "ubtce.com", true },
  { "ucfirst.nl", true },
  { "udomain.net", true },
  { "uerdingen.info", true },
  { "uesociedadlimitada.com", true },
  { "ueu.me", true },
  { "ufgaming.com", true },
  { "ufotable.uk", false },
  { "uhc.gg", true },
  { "ui8.net", true },
  { "uk.search.yahoo.com", false },
  { "ukchemicalresearch.org", true },
  { "ukdefencejournal.org.uk", true },
  { "ukdropshipment.co.uk", true },
  { "ukdropshipment.com", true },
  { "ukhas.net", true },
  { "ukrainians.ch", true },
  { "ukrgadget.com", true },
  { "ukwct.org.uk", true },
  { "ulabox.cat", true },
  { "ulabox.com", true },
  { "ulabox.es", true },
  { "ulmo.dk", true },
  { "ulrik.moe", true },
  { "ultieme.be", true },
  { "umassfive.coop", true },
  { "umgardi.ca", true },
  { "umisonoda.com", true },
  { "umwandeln-online.de", true },
  { "un-zero-un.fr", true },
  { "unapp.me", true },
  { "unblocked-networks.org", true },
  { "unblocked.win", true },
  { "unblockmy.party", true },
  { "unblockmy.tech", true },
  { "unblockmy.xyz", true },
  { "unblockthe.site", true },
  { "unblockthe.top", true },
  { "under30stravelinsurance.com.au", true },
  { "undernet.uy", true },
  { "undo.co.il", true },
  { "undone.me", true },
  { "unearaigneeauplafond.fr", true },
  { "unexpected.nu", true },
  { "unfiltered.nyc", true },
  { "ungegamere.dk", true },
  { "uni-games.com", true },
  { "unicef.pl", true },
  { "unicooo.com", true },
  { "unicredit.ba", true },
  { "unicredit.ro", true },
  { "unicreditbank.hu", true },
  { "unicreditbank.rs", true },
  { "unicreditbank.ru", true },
  { "uniekglas.nl", true },
  { "uniform-agri.com", true },
  { "unila.edu.br", true },
  { "unionplat.ru", true },
  { "unionstationapp.com", true },
  { "uniq.site", true },
  { "unirenter.ru", true },
  { "unison.com", true },
  { "unisyssecurity.com", true },
  { "unit7jazz.com", true },
  { "unit7jazz.org", true },
  { "united.com", false },
  { "unitedadmins.com", true },
  { "unitedcyberdevelopment.com", true },
  { "unitel2000.de", true },
  { "universalcarremote.com", true },
  { "universalpaymentgateway.com", true },
  { "university4industry.com", true },
  { "unixadm.org", true },
  { "unknownphenomena.net", true },
  { "uno-pizza.ru", true },
  { "unoccupyabq.org", true },
  { "unpossible.xyz", true },
  { "unpr.dk", true },
  { "unravel.ie", true },
  { "uns.vn", true },
  { "unseen.tw", true },
  { "unsystem.net", true },
  { "unterfrankenclan.de", true },
  { "unterschicht.tv", true },
  { "untoldstory.eu", true },
  { "unun.fi", true },
  { "unwiredbrain.com", true },
  { "unyq.me", false },
  { "uonstaffhub.com", true },
  { "uow.ninja", true },
  { "up1.ca", true },
  { "upani.net", true },
  { "upboard.jp", true },
  { "upitnik.rs", true },
  { "upldr.pw", true },
  { "upload.facebook.com", false },
  { "uploadbeta.com", true },
  { "upr.com.ua", true },
  { "upstats.eu", true },
  { "upstox.com", true },
  { "uptic.net", true },
  { "uptimed.com", true },
  { "uptimenotguaranteed.com", true },
  { "uptrends.com", true },
  { "uptrends.de", true },
  { "ur-lauber.de", true },
  { "urandom.eu.org", true },
  { "urban.melbourne", true },
  { "urbanesecurity.com", true },
  { "urbanmelbourne.info", true },
  { "uripura.de", true },
  { "urlchomp.com", true },
  { "urspringer.de", true },
  { "usaa.com", false },
  { "usaab.org", true },
  { "usabackground.com", true },
  { "usakitchensandflooring.com", true },
  { "usbcraft.com", true },
  { "usbirthcertificate.com", false },
  { "usbtypeccompliant.com", true },
  { "uscntalk.com", true },
  { "usd.de", true },
  { "use.be", true },
  { "usercare.com", true },
  { "useresponse.com", true },
  { "userify.com", true },
  { "usetypo3.com", true },
  { "usgande.com", true },
  { "usimmigration.us", true },
  { "usitcolours.bg", true },
  { "uslab.io", true },
  { "usleep.net", true },
  { "usparklodging.com", true },
  { "uspsoig.gov", true },
  { "ust.space", true },
  { "utdsgda.com", true },
  { "utilia.tools", true },
  { "utilityapi.com", true },
  { "utleieplassen.no", true },
  { "utonia.ch", true },
  { "utopiagalaxy.space", true },
  { "utopianhomespa.com", true },
  { "utopianrealms.org", true },
  { "utopians.dk", true },
  { "utopicestudios.com", true },
  { "uttnetgroup.fr", false },
  { "uvarov.pw", false },
  { "v0tti.com", false },
  { "v2.pw", true },
  { "vaddder.com", true },
  { "vagrantup.com", true },
  { "vakuutuskanava.fi", true },
  { "val-sec.com", true },
  { "valentin-sundermann.de", true },
  { "validbrands.com", true },
  { "valis.sx", true },
  { "valitron.se", true },
  { "valkohattu.fi", true },
  { "valleyridgepta.org", true },
  { "valmagus.com", true },
  { "valopv.be", true },
  { "valordolarblue.com.ar", true },
  { "valshamar.is", true },
  { "valsk.is", true },
  { "valskis.lt", true },
  { "valtoaho.com", true },
  { "vandalfsen.me", true },
  { "vanestack.com", true },
  { "vanetv.com", true },
  { "vangeluwedeberlaere.be", true },
  { "vanhoutte.be", true },
  { "vanitas.xyz", true },
  { "vanitynailworkz.com", true },
  { "vanlaanen.com", true },
  { "vansieleghem.com", true },
  { "vantien.com", true },
  { "vantru.is", true },
  { "vapemania.eu", true },
  { "varden.info", true },
  { "varghese.de", true },
  { "varicoseveinssolution.com", true },
  { "varunagw.com", false },
  { "varvy.com", true },
  { "vat-eu.com", true },
  { "vattulainen.fi", true },
  { "vault21.net", true },
  { "vaultproject.io", true },
  { "vavai.net", true },
  { "vazue.com", true },
  { "vbest.net", true },
  { "vbhelp.org", true },
  { "vbulletin-russia.com", true },
  { "vbulletinrussia.com", true },
  { "vcientertainment.com", true },
  { "vcr.re", true },
  { "vcsjones.com", true },
  { "vdbongard.com", true },
  { "vdcomp.cz", true },
  { "vdrpro.com", true },
  { "ve.search.yahoo.com", false },
  { "veblen.com", false },
  { "vechkasov.ru", true },
  { "vegalitarian.org", true },
  { "veggiesbourg.fr", true },
  { "veil-framework.com", true },
  { "velasense.com", true },
  { "venicerealdeal.com", true },
  { "venturepro.com", true },
  { "vereinscheck.de", true },
  { "verifiedinvesting.com", true },
  { "verifikatorindonesia.com", true },
  { "verizonguidelines.com", true },
  { "veronique-schmitz.de", true },
  { "versbeton.nl", true },
  { "versia.ru", true },
  { "versicherungskontor.net", true },
  { "veryhax.de", true },
  { "vespacascadia.com", true },
  { "vetdnacenter.com", true },
  { "vetinte.eu", false },
  { "vfdworld.com", true },
  { "vfree.org", true },
  { "vgatest.nl", true },
  { "vgerak.com", true },
  { "vglimg.com", true },
  { "vgropp.de", true },
  { "vhost.co.id", true },
  { "viaprinto.de", true },
  { "viasinc.com", false },
  { "viciousviscosity.xyz", true },
  { "victorcanera.com", true },
  { "victorjacobs.com", true },
  { "vid-immobilien.de", true },
  { "vide-dressing.org", true },
  { "vide-greniers.org", true },
  { "vide-maisons.org", true },
  { "videogamesartwork.com", true },
  { "videomail.io", true },
  { "videotogel.net", true },
  { "vidid.net", true },
  { "vieaw.com", true },
  { "vieclam24h.vn", false },
  { "viemeister.com", true },
  { "viennan.net", true },
  { "viewmyrecords.com", true },
  { "vigilantnow.com", true },
  { "vigilo.cf", true },
  { "vigilo.ga", true },
  { "vigo-krankenversicherung.de", true },
  { "vigo-tarife.de", true },
  { "vijos.org", true },
  { "vikasbabyworld.de", true },
  { "vikashkumar.me", true },
  { "vikings.net", true },
  { "viktorsvantesson.net", true },
  { "vilaydin.com", true },
  { "villenvinkit.com", true },
  { "vimeo.com", true },
  { "vincentcox.com", true },
  { "vincentkooijman.at", true },
  { "vincentkooijman.nl", true },
  { "vincentpancol.com", true },
  { "vincitraining.com", true },
  { "vinilosdecorativos.net", true },
  { "vintageheartcoffee.com", true },
  { "vinyculture.com", true },
  { "vio.no", true },
  { "viperdns.com", true },
  { "viphospitality.se", true },
  { "vipmusic.ga", true },
  { "vipnettikasinoklubi.com", true },
  { "virginiacrimeanalysisnetwork.org", true },
  { "virtualdesignmedia.com", false },
  { "virtuallifestyle.nl", true },
  { "virtualperez.com", true },
  { "virtualsanity.com", true },
  { "viscopic.com", true },
  { "visioflux-premium.com", true },
  { "visionarymedia.nl", true },
  { "visionless.me", false },
  { "visiontree-beta.eu", true },
  { "visiontree.eu", true },
  { "vispaleistexel.nl", true },
  { "vistaalmar.es", true },
  { "vistarait.com", true },
  { "vistb.me", true },
  { "vitagenda.nl", true },
  { "vitalismaatjes.nl", true },
  { "vitalita.cz", true },
  { "vitalorange.com", true },
  { "vitapingu.de", true },
  { "vitkausk.as", true },
  { "vitrado.de", true },
  { "vitta.me", true },
  { "vivaldi.club", true },
  { "vivatv.com.tw", true },
  { "vivendi.de", true },
  { "viviotech.net", false },
  { "vjirovsky.cz", true },
  { "vkox.com", true },
  { "vleij.com", true },
  { "vleij.family", true },
  { "vleij.se", true },
  { "vmem.jp", true },
  { "vmoagents.com", false },
  { "vmrdev.com", true },
  { "vn.search.yahoo.com", false },
  { "vnvisa.center", true },
  { "vnvisa.ru", true },
  { "vocaloid.my", true },
  { "voceinveste.com", true },
  { "vogt.tech", true },
  { "voidi.ca", true },
  { "vokeapp.com", true },
  { "volcrado.com", true },
  { "volkden.com", true },
  { "volker-gropp.de", true },
  { "volkergropp.de", true },
  { "vomitb.in", true },
  { "vonavycukor.sk", true },
  { "vonedelmann.de", true },
  { "voorjou.com", true },
  { "vop.li", true },
  { "vorlif.org", true },
  { "vorodevops.com", true },
  { "votocek.cz", true },
  { "votockova.cz", true },
  { "vozp.cz", true },
  { "vpl.me", false },
  { "vpn.ht", true },
  { "vpnhot.com", true },
  { "vpnzoom.com", true },
  { "vps-szerver-berles.hu", true },
  { "vratny.space", true },
  { "vrobert.fr", false },
  { "vrtak-cz.net", true },
  { "vsean.net", true },
  { "vserver-preis-vergleich.de", true },
  { "vsund.de", true },
  { "vulnerability.ch", true },
  { "vulners.com", true },
  { "vumetric.com", true },
  { "vuosaarenmontessoritalo.fi", true },
  { "vux.li", true },
  { "vxapps.com", true },
  { "vxstream-sandbox.com", true },
  { "vyber-odhadce.cz", true },
  { "vyberodhadce.cz", true },
  { "vyplnto.cz", true },
  { "vzk.io", false },
  { "w-spotlight.appspot.com", true },
  { "w.wiki", true },
  { "w4nvu.org", true },
  { "w4xzr.top", true },
  { "w4xzr.xyz", true },
  { "wa-stromerzeuger.de", true },
  { "wachter.biz", true },
  { "waelti.xxx", true },
  { "wafa4hw.com", true },
  { "waffle.at", true },
  { "wail.net", true },
  { "wait.jp", true },
  { "waka-mono.com", true },
  { "wakamiyasumiyosi.com", true },
  { "wakened.net", true },
  { "walkeryoung.ca", true },
  { "walkingforhealth.org.uk", true },
  { "wallet.google.com", true },
  { "wallpapers.pub", true },
  { "wallsblog.dk", true },
  { "walnutgaming.co.uk", false },
  { "walnutgaming.com", false },
  { "wan.pp.ua", true },
  { "wanban.io", true },
  { "wander.al", true },
  { "wangqiliang.cn", true },
  { "wangqiliang.com", true },
  { "wangql.cn", true },
  { "wangql.net", true },
  { "warekon.com", true },
  { "warekon.dk", true },
  { "warhaggis.com", true },
  { "warmservers.com", true },
  { "warped.com", true },
  { "warr.ath.cx", true },
  { "warrencreative.com", false },
  { "warsentech.com", true },
  { "warsh.moe", true },
  { "wartorngalaxy.com", true },
  { "wasema.com", true },
  { "wasserspucker.de", true },
  { "wassim.is", true },
  { "watchium.com", true },
  { "watchweasel.com", true },
  { "waterfedpole.com", true },
  { "watersb.org", true },
  { "watertrails.io", true },
  { "watsonhall.uk", true },
  { "wave.is", true },
  { "wavefrontsystemstech.com", true },
  { "wavesboardshop.com", true },
  { "waylaydesign.com", true },
  { "wayohoo.com", true },
  { "wayohoo.net", true },
  { "waze.com", true },
  { "wbg-vs.de", true },
  { "wbt-solutions.ch", true },
  { "wbt-solutions.net", true },
  { "wdbgroup.co.uk", true },
  { "wdesk.com", true },
  { "wdt.cz", true },
  { "wealthcentral.com.au", true },
  { "wealthprojector.com", true },
  { "wealthprojector.com.au", true },
  { "wealthreport.com.au", true },
  { "wear2work.nl", true },
  { "wearandcare.net", true },
  { "wearegenki.com", true },
  { "wearvr.com", true },
  { "weather-and-climate.com", true },
  { "weathermyway.rocks", true },
  { "weaverhairextensions.nl", true },
  { "web-hotel.gr", true },
  { "web-torrent.com", true },
  { "web.cc", true },
  { "webandmore.de", false },
  { "webandwords.com.au", true },
  { "webapps.directory", true },
  { "webassadors.com", false },
  { "webchat.domains", true },
  { "webcollect.org.uk", true },
  { "webdesign-kronberg.de", true },
  { "webdesigneauclaire.com", true },
  { "webdev.mobi", true },
  { "webdevops.io", true },
  { "webeau.com", true },
  { "webelement.sk", true },
  { "webergrillrestaurant.com", true },
  { "webfilings-eu-mirror.appspot.com", true },
  { "webfilings-eu.appspot.com", true },
  { "webfilings-mirror-hrd.appspot.com", true },
  { "webfilings.appspot.com", true },
  { "webhosting4.net", true },
  { "weblogic.pl", true },
  { "weblogzwolle.nl", true },
  { "webm.to", true },
  { "webmail.gigahost.dk", false },
  { "webmail.onlime.ch", false },
  { "webmail.schokokeks.org", false },
  { "webmaniabr.com", true },
  { "webmarketingfestival.it", true },
  { "webmax.com.tr", true },
  { "webmedpharmacy.co.uk", true },
  { "webnosql.com", true },
  { "webogram.org", true },
  { "webrebels.org", true },
  { "webs4all.ro", true },
  { "webscale.nl", true },
  { "websectools.com", true },
  { "webseitendesigner.com", false },
  { "webseitenserver.com", true },
  { "websenat.de", true },
  { "webstore.be", true },
  { "webstory.xyz", true },
  { "webstudio-n.com", true },
  { "webstylemedia.com", true },
  { "webswitch.io", true },
  { "webtalis.nl", true },
  { "webtasarim.pw", true },
  { "webtheapp.com", true },
  { "webtiles.co.uk", true },
  { "webtobesocial.de", true },
  { "webtorrent.io", true },
  { "webtrh.cz", true },
  { "webwit.nl", true },
  { "webwork.pw", true },
  { "webyazilimankara.com", true },
  { "webzanem.com", true },
  { "weeblr.com", true },
  { "weekdone.com", true },
  { "weekly-residence.com", true },
  { "wefinanceinc.com", true },
  { "weggeweest.nl", true },
  { "wegner.no", true },
  { "weicn.org", true },
  { "weirdesigns.com", true },
  { "weisse-liste.de", true },
  { "welches-kinderfahrrad.de", true },
  { "welcomehelp.de", true },
  { "wellacapability.com", true },
  { "wellastore.ru", true },
  { "welldrake.com", true },
  { "wellensteyn.ru", true },
  { "welovemail.com", true },
  { "welpy.com", false },
  { "welteneroberer.de", true },
  { "weltengilde.de", true },
  { "weltenhueter.de", true },
  { "weltmeisterschaft.net", true },
  { "weme.eu", true },
  { "wenjs.me", true },
  { "wepay.com", false },
  { "wepay.in.th", true },
  { "wer-kommt-her.de", true },
  { "werally.com", true },
  { "werbewelt-tv.de", true },
  { "werken-bij-inwork.nl", true },
  { "werkenbijkfc.nl", true },
  { "werktor.net", true },
  { "wesecom.com", false },
  { "wesleycabus.be", true },
  { "wessner.org", true },
  { "westcountrystalking.com", true },
  { "westeros.hu", true },
  { "westsuburbanbank.com", true },
  { "westsussexconnecttosupport.org", true },
  { "wetofu.top", true },
  { "wetoxic.com", true },
  { "wetthost.com", true },
  { "wevahoo.com", true },
  { "wevolver.com", true },
  { "wf-bigsky-master.appspot.com", true },
  { "wf-demo-eu.appspot.com", true },
  { "wf-demo-hrd.appspot.com", true },
  { "wf-dogfood-hrd.appspot.com", true },
  { "wf-hosting.de", true },
  { "wf-pentest.appspot.com", true },
  { "wf-staging-hr.appspot.com", true },
  { "wf-training-hrd.appspot.com", true },
  { "wf-training-master.appspot.com", true },
  { "wf-trial-hrd.appspot.com", true },
  { "wfh.ovh", true },
  { "wfh.se", true },
  { "wftda.com", true },
  { "whatanime.ga", true },
  { "whatnext.limited", true },
  { "whatsapp.com", true },
  { "whatsmychaincert.com", true },
  { "whatsstalk.me", true },
  { "whatsupgold.com.tw", true },
  { "whatwg.org", true },
  { "whd-guide.de", true },
  { "wheeler.kiwi.nz", true },
  { "when-release.ru", false },
  { "when.fm", true },
  { "whereisjason.com", true },
  { "wherephoto.com", false },
  { "whey-protein.ch", true },
  { "whiskeyriver.co.uk", true },
  { "whiskynerd.ca", true },
  { "whisp.ly", true },
  { "whispeer.de", true },
  { "whistleb.com", true },
  { "whitehouse.gov", true },
  { "whiterabbitcakery.com", true },
  { "whiteroom.agency", true },
  { "whocalld.com", true },
  { "whocalled.us", true },
  { "wholesomeharvestbread.com", true },
  { "wholikes.us", true },
  { "whonix.org", true },
  { "wiberg.nu", true },
  { "wideboxmacau.com", false },
  { "widemann.de", true },
  { "widememory.com", true },
  { "wiedu.net", true },
  { "wienholding.at", true },
  { "wieninternational.at", true },
  { "wifimask.com", true },
  { "wifirst.net", true },
  { "wiimotion.de", true },
  { "wiire.me", true },
  { "wijnservices.nl", true },
  { "wiki.python.org", true },
  { "wikibooks.org", true },
  { "wikiclash.info", false },
  { "wikidata.org", true },
  { "wikidsystems.com", false },
  { "wikimediafoundation.org", true },
  { "wikimilk.org", true },
  { "wikinews.org", true },
  { "wikipedia.org", true },
  { "wikiquote.org", true },
  { "wikisource.org", true },
  { "wikiversity.org", true },
  { "wikivoyage.org", true },
  { "wiktionary.org", true },
  { "wiktoriaslife.com", true },
  { "wildbee.org", true },
  { "wilddog.com", true },
  { "wilf1rst.com", true },
  { "willberg.bayern", true },
  { "willcipriano.com", true },
  { "williamfeely.info", true },
  { "williamsapiens.com", true },
  { "williamsonshore.com", true },
  { "willnorris.com", true },
  { "willosagiede.com", true },
  { "wills.co.tt", true },
  { "wimake.solutions", true },
  { "wind.moe", true },
  { "windhaven.nl", true },
  { "windrunner.se", true },
  { "windscribe.com", true },
  { "winebid.com", true },
  { "winecodeavocado.com", true },
  { "winghill.com", true },
  { "wingumd.net", true },
  { "winhistory-forum.net", true },
  { "winmodels.org", true },
  { "winmodels.ru", true },
  { "winpack.cf", true },
  { "winpack.eu.org", true },
  { "winter.engineering", false },
  { "winterfeldt.de", true },
  { "wintodoor.com", true },
  { "wipply.com", false },
  { "wirc.gr", true },
  { "wiretrip.io", true },
  { "wirkstoffreich.de", true },
  { "wis.no", true },
  { "wispapp.com", true },
  { "wisv.ch", true },
  { "wisweb.no", true },
  { "witae.com", true },
  { "withgoogle.com", true },
  { "withinsecurity.com", true },
  { "withmy.beer", true },
  { "withyoutube.com", true },
  { "wittcher.com", true },
  { "wittydonut.com", true },
  { "witway.nl", false },
  { "wizzley.com", false },
  { "wizzr.nl", true },
  { "wje-online.de", true },
  { "wjglerum.nl", true },
  { "wkv.com", true },
  { "wlaws.com", true },
  { "wlzhiyin.cn", true },
  { "wm-talk.net", true },
  { "wmcuk.net", true },
  { "wnu.com", true },
  { "wo2forum.nl", true },
  { "wodice.com", true },
  { "wodka-division.de", true },
  { "wofford-ecs.org", true },
  { "wohlgemuth.rocks", false },
  { "wohnsitz-ausland.com", true },
  { "wolfachtal-alpaka.de", true },
  { "wolfemg.com", true },
  { "wolfesden.com", true },
  { "wolfsden.cz", true },
  { "wolfwings.us", true },
  { "womb.city", true },
  { "womf.org", true },
  { "wonder.com.mx", true },
  { "wonderhost.info", true },
  { "wonderlandmovies.de", true },
  { "wondermags.com", true },
  { "wondershift.biz", true },
  { "wondy.com", true },
  { "woodbury.io", true },
  { "woodlandschurch.net", true },
  { "woodlandsmetro.church", true },
  { "woodomat.com", true },
  { "woording.com", true },
  { "wootton95.com", true },
  { "worcesterfestival.co.uk", true },
  { "word-grabber.com", true },
  { "wordpress.com", false },
  { "wordsmart.it", true },
  { "wordxtra.net", true },
  { "woresite.jp", true },
  { "workfone.io", true },
  { "workingclassmedia.com", true },
  { "workray.com", true },
  { "workwithgo.com", true },
  { "worldcubeassociation.org", true },
  { "woutergeraedts.nl", true },
  { "woutervdb.com", true },
  { "wow-foederation.de", true },
  { "wownmedia.com", true },
  { "wp-tao.com", true },
  { "wpac.de", true },
  { "wpfortify.com", true },
  { "wphostingblog.nl", true },
  { "wpletter.de", false },
  { "wpmeetup-berlin.de", true },
  { "wpostats.com", true },
  { "wpserp.com", true },
  { "wpvulndb.com", true },
  { "wql.zj.cn", true },
  { "wrara.org", true },
  { "wrgms.com", true },
  { "wrightdoumawedding.com", true },
  { "wrldevelopment.com", true },
  { "wrwg.ca", true },
  { "wsa.poznan.pl", true },
  { "wscales.com", true },
  { "wsdezign.com", true },
  { "wss.com.ve", true },
  { "wsv-grafenau.de", true },
  { "wtfismyip.com", true },
  { "wth.in", true },
  { "wubocong.com", true },
  { "wubthecaptain.eu", true },
  { "wuetix.de", true },
  { "wufu.org", true },
  { "wunderkarten.de", true },
  { "wunderlist.com", true },
  { "wundi.net", true },
  { "wurzelzwerg.net", true },
  { "wvg.myds.me", true },
  { "wvr-law.de", false },
  { "ww2onlineshop.com", false },
  { "www.aclu.org", false },
  { "www.airbnb.com", true },
  { "www.apollo-auto.com", true },
  { "www.banking.co.at", false },
  { "www.capitainetrain.com", false },
  { "www.captaintrain.com", false },
  { "www.cloudflare.com", false },
  { "www.cyveillance.com", true },
  { "www.dropbox.com", true },
  { "www.dropcam.com", false },
  { "www.entropia.de", false },
  { "www.eternalgoth.co.uk", true },
  { "www.etsy.com", true },
  { "www.evernote.com", false },
  { "www.facebook.com", false },
  { "www.fastmail.com", true },
  { "www.gamesdepartment.co.uk", false },
  { "www.getcloak.com", false },
  { "www.gmail.com", false },
  { "www.googlemail.com", false },
  { "www.gov.uk", false },
  { "www.gpo.gov", false },
  { "www.grc.com", false },
  { "www.healthcare.gov", false },
  { "www.heliosnet.com", true },
  { "www.honeybadger.io", false },
  { "www.icann.org", false },
  { "www.intercom.io", false },
  { "www.irccloud.com", false },
  { "www.lastpass.com", false },
  { "www.ledgerscope.net", false },
  { "www.linode.com", false },
  { "www.lookout.com", false },
  { "www.makeyourlaws.org", true },
  { "www.mydigipass.com", false },
  { "www.mylookout.com", false },
  { "www.noisebridge.net", false },
  { "www.opsmate.com", true },
  { "www.paypal.com", false },
  { "www.python.org", true },
  { "www.rememberthemilk.com", true },
  { "www.schokokeks.org", true },
  { "www.simbolo.co.uk", false },
  { "www.simple.com", false },
  { "www.therapynotes.com", true },
  { "www.tinfoilsecurity.com", false },
  { "www.torproject.org", false },
  { "www.twitter.com", false },
  { "www.united.com", false },
  { "www.usaa.com", false },
  { "www.viasinc.com", true },
  { "www.vino75.com", false },
  { "www.wepay.com", false },
  { "www.wordpress.com", false },
  { "wxcafe.net", true },
  { "wxster.com", true },
  { "wy6.org", true },
  { "wyeworks.com", true },
  { "wynterhill.co.uk", true },
  { "wzrd.in", true },
  { "wzyboy.org", true },
  { "x.io", true },
  { "x.st", true },
  { "x3led.com", true },
  { "x509.io", true },
  { "x64architecture.com", true },
  { "xa1.uk", true },
  { "xalqbank-online.az", true },
  { "xandocs.com", true },
  { "xatr0z.org", false },
  { "xbb.hk", true },
  { "xbb.li", true },
  { "xbind.io", true },
  { "xboxdownloadthat.com", true },
  { "xboxlivegoldshop.nl", true },
  { "xbrlsuccess.appspot.com", true },
  { "xbt.co", true },
  { "xcentricmold.com", true },
  { "xcoop.me", true },
  { "xd.cm", true },
  { "xdd.io", true },
  { "xdeftor.com", true },
  { "xellos.ga", true },
  { "xellos.ml", true },
  { "xendo.net", true },
  { "xenesisziarovky.sk", true },
  { "xetown.com", true },
  { "xett.com", true },
  { "xf-liam.com", true },
  { "xfive.de", true },
  { "xg3n1us.de", true },
  { "xgclan.com", true },
  { "xho.me", true },
  { "xiangweiqing.co.uk", true },
  { "xiaody.me", true },
  { "xiaofengsky.com", true },
  { "xiaoguo.net", true },
  { "xiaolan.me", true },
  { "xiaolvmu.me", true },
  { "xichtsbuch.de", true },
  { "xichuangke.com", true },
  { "xicreative.net", true },
  { "xilef.org", true },
  { "ximage.me", false },
  { "xinbiji.cn", true },
  { "xkviz.net", true },
  { "xmerak.com", true },
  { "xmpp.dk", true },
  { "xmppwocky.net", true },
  { "xmr.to", true },
  { "xn--3lqp21gwna.cn", true },
  { "xn--3lqp21gwna.xn--fiqs8s", true },
  { "xn--3lqt7ir4md4tzwa.cn", true },
  { "xn--3lqt7ir4md4tzwa.xn--fiqs8s", true },
  { "xn--4dbjwf8c.cf", true },
  { "xn--4dbjwf8c.ga", true },
  { "xn--4dbjwf8c.ml", true },
  { "xn--4dbjwf8c.tk", true },
  { "xn--7xa.google.com", true },
  { "xn--80aaihqncaejjobbu6v.xn--p1ai", true },
  { "xn--9pr52k0p5a.com", true },
  { "xn--datenrettung-mnchen-jbc.com", true },
  { "xn--hfk-allgu-schwaben-stb.de", true },
  { "xn--jobbrse-d1a.de", true },
  { "xn--jp-6l5cs1yf3ivjsglphyv.net", true },
  { "xn--knstler-n2a.tips", false },
  { "xn--lgb3a8bcpn.cf", true },
  { "xn--lgb3a8bcpn.ga", true },
  { "xn--lgb3a8bcpn.gq", true },
  { "xn--lgb3a8bcpn.ml", true },
  { "xn--ls8hi7a.tk", true },
  { "xn--maraa-rta.org", true },
  { "xn--mgbbh2a9fub.xn--ngbc5azd", true },
  { "xn--pbt947am3ab71g.com", true },
  { "xn--qckss0j.tk", true },
  { "xn--t8j4aa4nyhxa7duezbl49aqg5546e264d.net", true },
  { "xn--u9jv84l7ea468b.com", true },
  { "xnode.org", false },
  { "xoffy.com", true },
  { "xolphin.nl", true },
  { "xotika.tv", true },
  { "xpd.se", true },
  { "xps2pdf.co.uk", true },
  { "xqin.net", true },
  { "xrockx.de", true },
  { "xsmobile.de", true },
  { "xss.ht", true },
  { "xss.sk", true },
  { "xtremegaming.it", true },
  { "xtrim.ru", true },
  { "xtronics.com", true },
  { "xuc.me", true },
  { "xuexb.com", true },
  { "xunn.io", true },
  { "xuntier.ch", true },
  { "xwalck.se", true },
  { "xwaretech.info", true },
  { "xyfun.net", true },
  { "yacobo.com", true },
  { "yafuoku.ru", true },
  { "yagihiro.tech", true },
  { "yahvehyireh.com", true },
  { "yak.is", true },
  { "yakmade.com", true },
  { "yakmoo.se", true },
  { "yamadaya.tv", true },
  { "yamaken.jp", true },
  { "yamamo10.com", true },
  { "yameveo.com", true },
  { "yanaduday.com", true },
  { "yanovich.net", true },
  { "yanwh.xyz", true },
  { "yaoidreams.com", true },
  { "yapbreak.fr", true },
  { "yaporn.tv", false },
  { "yard-fu.com", true },
  { "yatesun.com", true },
  { "yaucy.win", true },
  { "yawnbox.com", true },
  { "yaxim.org", true },
  { "ycc.wtf", true },
  { "yclan.net", true },
  { "ydy.jp", true },
  { "yecl.net", true },
  { "yello.website", true },
  { "yellowcar.website", true },
  { "yenniferallulli.com", true },
  { "yenniferallulli.de", true },
  { "yenniferallulli.es", true },
  { "yenniferallulli.moda", true },
  { "yenniferallulli.nl", true },
  { "yesonline.asia", true },
  { "yesonline.me", true },
  { "yetcore.io", true },
  { "yetzt.me", false },
  { "yhaupenthal.org", true },
  { "yikzu.cn", true },
  { "yinlei.org", true },
  { "yippie.nl", true },
  { "yjsw.sh.cn", true },
  { "yksityisyydensuoja.fi", true },
  { "ymarion.de", true },
  { "ynode.co", true },
  { "ynode.com", true },
  { "ynsn.nl", true },
  { "yobst.tk", true },
  { "yoga.is-an-engineer.com", true },
  { "yolobert.de", true },
  { "yoloprod.fr", true },
  { "yoloseo.com", true },
  { "yombo.net", true },
  { "yoramvandevelde.net", true },
  { "yorcom.nl", true },
  { "yorname.ml", true },
  { "yosemo.de", true },
  { "youcancraft.de", true },
  { "youcontrol.ru", true },
  { "youdowell.com", true },
  { "youkaryote.com", true },
  { "youkaryote.org", true },
  { "youkok2.com", true },
  { "yourself.today", true },
  { "yourstrongbox.com", true },
  { "yourznc.com", true },
  { "youtous.me", true },
  { "youyoulemon.com", true },
  { "ypart.eu", true },
  { "ypcs.fi", true },
  { "ypiresia.fr", true },
  { "yplanapp.com", true },
  { "ys-shop.biz", true },
  { "ytvwld.de", true },
  { "yuan.ga", true },
  { "yufan.me", true },
  { "yuhen.ru", true },
  { "yuko.moe", true },
  { "yunity.org", true },
  { "yunzhu.li", true },
  { "yunzhu.org", true },
  { "yusa.me", true },
  { "yutabon.com", false },
  { "yutangyun.com", true },
  { "yvesx.com", true },
  { "yyyy.xyz", true },
  { "yzal.io", true },
  { "z-vector.com", true },
  { "z.ai", true },
  { "z0rro.net", true },
  { "z1h.de", true },
  { "z33.ch", true },
  { "zaalleatherwear.nl", true },
  { "zacarias.com.ar", true },
  { "zachpeters.org", true },
  { "zadieheimlich.com", true },
  { "zadroweb.com", true },
  { "zahe.me", true },
  { "zakmccrac.de", true },
  { "zalan.do", true },
  { "zamorano.edu", true },
  { "zaoshanghao-dajia.rhcloud.com", true },
  { "zap.yt", true },
  { "zapier.com", true },
  { "zaufanatrzeciastrona.pl", true },
  { "zbasenem.pl", true },
  { "zberger.com", true },
  { "zbigniewgalucki.eu", true },
  { "zbp.at", true },
  { "zbrane-doplnky.cz", true },
  { "zcarot.com", false },
  { "zcarrot.com", true },
  { "zcon.nl", true },
  { "zdbl.de", true },
  { "zdrojak.cz", true },
  { "ze3kr.com", true },
  { "zebry.nl", true },
  { "zeedroom.be", true },
  { "zefu.ca", true },
  { "zehdenick-bleibt-bunt.de", true },
  { "zehntner.ch", true },
  { "zeitzer-turngala.de", true },
  { "zellari.ru", true },
  { "zen-trader.com", false },
  { "zenithmedia.ca", true },
  { "zeno-system.com", true },
  { "zentraler-kreditausschuss.de", true },
  { "zenvideocloud.com", true },
  { "zeplin.io", true },
  { "zer0-day.pw", true },
  { "zera.com.au", true },
  { "zerekin.net", true },
  { "zerocool.io", true },
  { "zerolab.org", true },
  { "zeroling.com", true },
  { "zeropush.com", true },
  { "zertif.info", true },
  { "zerudi.com", true },
  { "zespia.tw", true },
  { "zeto365.pl", true },
  { "zetorzeszow.pl", true },
  { "zett4.me", true },
  { "zettaplan.ru", true },
  { "zeytin.pro", true },
  { "zgrep.org", true },
  { "zhang-hao.com", true },
  { "zhanghao.me", true },
  { "zhangruilin.com", true },
  { "zhangyuhao.com", true },
  { "zhaofeng.li", true },
  { "zhaojin97.cn", true },
  { "zhh.in", true },
  { "zhihua-lai.com", true },
  { "zhovner.com", true },
  { "zicklam.com", true },
  { "zifb.in", true },
  { "zima.io", true },
  { "zimiao.moe", true },
  { "zingarastore.com", true },
  { "zionvps.com", false },
  { "zippy-download.com", true },
  { "zippy-download.de", true },
  { "zirtue.io", true },
  { "zixiao.wang", true },
  { "zizoo.com", true },
  { "zju.tv", true },
  { "zjubtv.com", true },
  { "zjutv.com", true },
  { "zlatosnadno.cz", true },
  { "zlavomat.sk", true },
  { "zmy.im", true },
  { "znation.nl", true },
  { "zocken.com", true },
  { "zoe.vc", true },
  { "zoeller.me", true },
  { "zohar.wang", true },
  { "zombiesecured.com", true },
  { "zoneminder.com", true },
  { "zonglovani.info", true },
  { "zoomingin.net", true },
  { "zoommailing.com", true },
  { "zooom.azurewebsites.net", true },
  { "zooparadies.eu", true },
  { "zorium.org", true },
  { "zorntt.fr", true },
  { "zortium.report", true },
  { "zorz.info", true },
  { "zotero.org", true },
  { "zravypapir.cz", true },
  { "zrn.in", true },
  { "zscales.com", true },
  { "ztan.tk", true },
  { "ztcaoll222.cn", true },
  { "zulu7.com", true },
  { "zundapp529.nl", true },
  { "zuram.net", true },
  { "zvncloud.com", true },
  { "zvps.uk", true },
  { "zwerimex.com", true },
  { "zx6rninja.de", true },
  { "zyf.pw", true },
  { "zzsec.org", true },
  { "zzw.ca", true },
};
