#include "FuseOpenTest.h"

using cpputils::unique_ref;
using cpputils::make_unique_ref;

void FuseOpenTest::OpenFile(const char *filename, int flags) {
  auto fs = TestFS();
  auto fd = OpenFileAllowError(fs.get(), filename, flags);
  EXPECT_GE(fd->fd(), 0);
}

int FuseOpenTest::OpenFileReturnError(const char *filename, int flags) {
  auto fs = TestFS();
  auto fd = OpenFileAllowError(fs.get(), filename, flags);
  return fd->errorcode();
}

unique_ref<OpenFileHandle> FuseOpenTest::OpenFileAllowError(const TempTestFS *fs, const char *filename, int flags) {
  auto realpath = fs->mountDir() / filename;
  return make_unique_ref<OpenFileHandle>(realpath.string().c_str(), flags);
}
