/* valasymbol.c generated by valac, the Vala compiler
 * generated from valasymbol.vala, do not modify */

/* valasymbol.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))
#define _vala_version_attribute_unref0(var) ((var == NULL) ? NULL : (var = (vala_version_attribute_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_scope_unref0(var) ((var == NULL) ? NULL : (var = (vala_scope_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaSymbolPrivate {
	gchar* _name;
	gboolean _active;
	gboolean _used;
	gboolean _anonymous;
	ValaSymbolAccessibility _access;
	ValaComment* _comment;
	ValaVersionAttribute* _version;
	gboolean _hides;
	gboolean _is_extern;
	ValaScope* _owner;
	ValaScope* _scope;
	gboolean* _external;
};

static gint ValaSymbol_private_offset;
static gpointer vala_symbol_parent_class = NULL;

static gboolean* _bool_dup (gboolean* self);
static gboolean vala_symbol_real_is_instance_member (ValaSymbol* self);
static gboolean vala_symbol_real_is_class_member (ValaSymbol* self);
static void vala_symbol_real_add_namespace (ValaSymbol* self,
                                     ValaNamespace* ns);
static void vala_symbol_real_add_class (ValaSymbol* self,
                                 ValaClass* cl);
static void vala_symbol_real_add_interface (ValaSymbol* self,
                                     ValaInterface* iface);
static void vala_symbol_real_add_struct (ValaSymbol* self,
                                  ValaStruct* st);
static void vala_symbol_real_add_enum (ValaSymbol* self,
                                ValaEnum* en);
static void vala_symbol_real_add_error_domain (ValaSymbol* self,
                                        ValaErrorDomain* edomain);
static void vala_symbol_real_add_delegate (ValaSymbol* self,
                                    ValaDelegate* d);
static void vala_symbol_real_add_constant (ValaSymbol* self,
                                    ValaConstant* constant);
static void vala_symbol_real_add_field (ValaSymbol* self,
                                 ValaField* f);
static void vala_symbol_real_add_method (ValaSymbol* self,
                                  ValaMethod* m);
static void vala_symbol_real_add_property (ValaSymbol* self,
                                    ValaProperty* prop);
static void vala_symbol_real_add_signal (ValaSymbol* self,
                                  ValaSignal* sig);
static void vala_symbol_real_add_constructor (ValaSymbol* self,
                                       ValaConstructor* c);
static void vala_symbol_real_add_destructor (ValaSymbol* self,
                                      ValaDestructor* d);
static gchar* vala_symbol_real_to_string (ValaCodeNode* base);
static void vala_symbol_finalize (ValaCodeNode * obj);
static GType vala_symbol_get_type_once (void);

static inline gpointer
vala_symbol_get_instance_private (ValaSymbol* self)
{
	return G_STRUCT_MEMBER_P (self, ValaSymbol_private_offset);
}

ValaSymbol*
vala_symbol_get_parent_symbol (ValaSymbol* self)
{
	ValaSymbol* result;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_symbol_get_owner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = NULL;
		return result;
	} else {
		ValaScope* _tmp2_;
		ValaScope* _tmp3_;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		_tmp2_ = vala_symbol_get_owner (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_scope_get_owner (_tmp3_);
		_tmp5_ = _tmp4_;
		result = _tmp5_;
		return result;
	}
}

ValaScope*
vala_symbol_get_owner (ValaSymbol* self)
{
	ValaScope* result;
	ValaScope* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_owner;
	result = _tmp0_;
	return result;
}

void
vala_symbol_set_owner (ValaSymbol* self,
                       ValaScope* value)
{
	ValaScope* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_owner = value;
	_tmp0_ = self->priv->_scope;
	vala_scope_set_parent_scope (_tmp0_, value);
}

const gchar*
vala_symbol_get_name (ValaSymbol* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
vala_symbol_set_name (ValaSymbol* self,
                      const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
}

gboolean
vala_symbol_get_active (ValaSymbol* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}

void
vala_symbol_set_active (ValaSymbol* self,
                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_active = value;
}

gboolean
vala_symbol_get_used (ValaSymbol* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_used;
	return result;
}

void
vala_symbol_set_used (ValaSymbol* self,
                      gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_used = value;
}

gboolean
vala_symbol_get_anonymous (ValaSymbol* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_anonymous;
	return result;
}

void
vala_symbol_set_anonymous (ValaSymbol* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_anonymous = value;
}

ValaSymbolAccessibility
vala_symbol_get_access (ValaSymbol* self)
{
	ValaSymbolAccessibility result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_access;
	return result;
}

void
vala_symbol_set_access (ValaSymbol* self,
                        ValaSymbolAccessibility value)
{
	g_return_if_fail (self != NULL);
	self->priv->_access = value;
}

ValaComment*
vala_symbol_get_comment (ValaSymbol* self)
{
	ValaComment* result;
	ValaComment* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_comment;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_comment_ref0 (gpointer self)
{
	return self ? vala_comment_ref (self) : NULL;
}

void
vala_symbol_set_comment (ValaSymbol* self,
                         ValaComment* value)
{
	ValaComment* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_comment_ref0 (value);
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->_comment = _tmp0_;
}

ValaVersionAttribute*
vala_symbol_get_version (ValaSymbol* self)
{
	ValaVersionAttribute* result;
	ValaVersionAttribute* _tmp0_;
	ValaVersionAttribute* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_version;
	if (_tmp0_ == NULL) {
		ValaVersionAttribute* _tmp1_;
		_tmp1_ = vala_version_attribute_new (self);
		_vala_version_attribute_unref0 (self->priv->_version);
		self->priv->_version = _tmp1_;
	}
	_tmp2_ = self->priv->_version;
	result = _tmp2_;
	return result;
}

gboolean
vala_symbol_get_hides (ValaSymbol* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_hides;
	return result;
}

void
vala_symbol_set_hides (ValaSymbol* self,
                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_hides = value;
}

/**
 * Check if this symbol is just internal API (and therefore doesn't need
 * to be listed in header files for instance) by traversing parent symbols
 * and checking their accessibility.
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

gboolean
vala_symbol_is_internal_symbol (ValaSymbol* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_symbol_get_external (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = vala_symbol_get_external_package (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	{
		ValaSymbol* sym = NULL;
		ValaSymbol* _tmp5_;
		_tmp5_ = _vala_code_node_ref0 (self);
		sym = _tmp5_;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				ValaSymbol* _tmp11_;
				gboolean _tmp12_ = FALSE;
				ValaSymbol* _tmp13_;
				ValaSymbolAccessibility _tmp14_;
				if (!_tmp6_) {
					ValaSymbol* _tmp7_;
					ValaSymbol* _tmp8_;
					ValaSymbol* _tmp9_;
					ValaSymbol* _tmp10_;
					_tmp7_ = sym;
					_tmp8_ = vala_symbol_get_parent_symbol (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = _vala_code_node_ref0 (_tmp9_);
					_vala_code_node_unref0 (sym);
					sym = _tmp10_;
				}
				_tmp6_ = FALSE;
				_tmp11_ = sym;
				if (!(NULL != _tmp11_)) {
					break;
				}
				_tmp13_ = sym;
				_tmp14_ = _tmp13_->priv->_access;
				if (_tmp14_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
					_tmp12_ = TRUE;
				} else {
					ValaSymbol* _tmp15_;
					ValaSymbolAccessibility _tmp16_;
					_tmp15_ = sym;
					_tmp16_ = _tmp15_->priv->_access;
					_tmp12_ = _tmp16_ == VALA_SYMBOL_ACCESSIBILITY_INTERNAL;
				}
				if (_tmp12_) {
					result = TRUE;
					_vala_code_node_unref0 (sym);
					return result;
				}
			}
		}
		_vala_code_node_unref0 (sym);
	}
	result = FALSE;
	return result;
}

gboolean
vala_symbol_is_private_symbol (ValaSymbol* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_symbol_get_external (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = vala_symbol_get_external_package (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	{
		ValaSymbol* sym = NULL;
		ValaSymbol* _tmp5_;
		_tmp5_ = _vala_code_node_ref0 (self);
		sym = _tmp5_;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				ValaSymbol* _tmp11_;
				ValaSymbol* _tmp12_;
				ValaSymbolAccessibility _tmp13_;
				if (!_tmp6_) {
					ValaSymbol* _tmp7_;
					ValaSymbol* _tmp8_;
					ValaSymbol* _tmp9_;
					ValaSymbol* _tmp10_;
					_tmp7_ = sym;
					_tmp8_ = vala_symbol_get_parent_symbol (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = _vala_code_node_ref0 (_tmp9_);
					_vala_code_node_unref0 (sym);
					sym = _tmp10_;
				}
				_tmp6_ = FALSE;
				_tmp11_ = sym;
				if (!(NULL != _tmp11_)) {
					break;
				}
				_tmp12_ = sym;
				_tmp13_ = _tmp12_->priv->_access;
				if (_tmp13_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
					result = TRUE;
					_vala_code_node_unref0 (sym);
					return result;
				}
			}
		}
		_vala_code_node_unref0 (sym);
	}
	result = FALSE;
	return result;
}

ValaScope*
vala_symbol_get_scope (ValaSymbol* self)
{
	ValaScope* result;
	ValaScope* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_scope;
	result = _tmp0_;
	return result;
}

gboolean
vala_symbol_get_is_extern (ValaSymbol* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_extern;
	return result;
}

void
vala_symbol_set_is_extern (ValaSymbol* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_extern = value;
}

gboolean
vala_symbol_get_external (ValaSymbol* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_external;
	if (_tmp0_ != NULL) {
		gboolean* _tmp1_;
		_tmp1_ = self->priv->_external;
		result = *_tmp1_;
		return result;
	}
	_tmp3_ = self->priv->_is_extern;
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = vala_symbol_get_external_package (self);
		_tmp5_ = _tmp4_;
		_tmp2_ = _tmp5_;
	}
	result = _tmp2_;
	return result;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

void
vala_symbol_set_external (ValaSymbol* self,
                          gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_external);
	self->priv->_external = _tmp0_;
}

gboolean
vala_symbol_get_external_package (ValaSymbol* self)
{
	gboolean result;
	ValaSourceFileType _tmp0_;
	ValaSourceFileType _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_symbol_get_source_type (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == VALA_SOURCE_FILE_TYPE_PACKAGE;
	return result;
}

gboolean
vala_symbol_get_from_commandline (ValaSymbol* self)
{
	gboolean result;
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		ValaSourceFile* _tmp4_;
		ValaSourceFile* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_source_reference_get_file (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_file_get_from_commandline (_tmp5_);
		_tmp7_ = _tmp6_;
		result = _tmp7_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

ValaSourceFileType
vala_symbol_get_source_type (ValaSymbol* self)
{
	ValaSourceFileType result;
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		ValaSourceFile* _tmp4_;
		ValaSourceFile* _tmp5_;
		ValaSourceFileType _tmp6_;
		ValaSourceFileType _tmp7_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_source_reference_get_file (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_file_get_file_type (_tmp5_);
		_tmp7_ = _tmp6_;
		result = _tmp7_;
		return result;
	} else {
		result = VALA_SOURCE_FILE_TYPE_NONE;
		return result;
	}
}

ValaSymbol*
vala_symbol_construct (GType object_type,
                       const gchar* name,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaSymbol* self = NULL;
	ValaScope* _tmp0_;
	self = (ValaSymbol*) vala_code_node_construct (object_type);
	vala_symbol_set_name (self, name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_symbol_set_comment (self, comment);
	_tmp0_ = vala_scope_new (self);
	_vala_scope_unref0 (self->priv->_scope);
	self->priv->_scope = _tmp0_;
	return self;
}

/**
 * Returns the fully expanded name of this symbol for use in
 * human-readable messages.
 *
 * @return full name
 */
gchar*
vala_symbol_get_full_name (ValaSymbol* self)
{
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	const gchar* _tmp4_;
	ValaSymbol* _tmp8_;
	ValaSymbol* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp15_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->_name;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->_name;
	if (_tmp4_ == NULL) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = vala_symbol_get_parent_symbol (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_symbol_get_full_name (_tmp6_);
		result = _tmp7_;
		return result;
	}
	_tmp8_ = vala_symbol_get_parent_symbol (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_symbol_get_full_name (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_ == NULL;
	_g_free0 (_tmp11_);
	if (_tmp12_) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = self->priv->_name;
		_tmp14_ = g_strdup (_tmp13_);
		result = _tmp14_;
		return result;
	}
	_tmp15_ = self->priv->_name;
	if (g_str_has_prefix (_tmp15_, ".")) {
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp16_ = vala_symbol_get_parent_symbol (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_symbol_get_full_name (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = self->priv->_name;
		_tmp21_ = g_strdup_printf ("%s%s", _tmp19_, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp19_);
		result = _tmp22_;
		return result;
	} else {
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp23_ = vala_symbol_get_parent_symbol (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_symbol_get_full_name (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = self->priv->_name;
		_tmp28_ = g_strdup_printf ("%s.%s", _tmp26_, _tmp27_);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp26_);
		result = _tmp29_;
		return result;
	}
}

/**
 * Converts a string from CamelCase to lower_case.
 *
 * @param camel_case a string in camel case
 * @return           the specified string converted to lower case
 */
static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

gchar*
vala_symbol_camel_case_to_lower_case (const gchar* camel_case)
{
	GString* result_builder = NULL;
	GString* _tmp1_;
	const gchar* i = NULL;
	gboolean first = FALSE;
	GString* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* result = NULL;
	g_return_val_if_fail (camel_case != NULL, NULL);
	if (string_contains (camel_case, "_")) {
		gchar* _tmp0_;
		_tmp0_ = g_ascii_strdown (camel_case, (gssize) -1);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = g_string_new ("");
	result_builder = _tmp1_;
	i = camel_case;
	first = TRUE;
	while (TRUE) {
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gunichar c = 0U;
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		GString* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		_tmp2_ = i;
		_tmp3_ = strlen (_tmp2_);
		_tmp4_ = _tmp3_;
		if (!(_tmp4_ > 0)) {
			break;
		}
		_tmp5_ = i;
		c = string_get_char (_tmp5_, (glong) 0);
		if (g_unichar_isupper (c)) {
			_tmp6_ = !first;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			const gchar* t = NULL;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gboolean prev_upper = FALSE;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gboolean next_upper = FALSE;
			const gchar* _tmp12_;
			gboolean _tmp13_ = FALSE;
			_tmp7_ = i;
			_tmp8_ = g_utf8_prev_char (_tmp7_);
			t = _tmp8_;
			_tmp9_ = t;
			prev_upper = g_unichar_isupper (string_get_char (_tmp9_, (glong) 0));
			_tmp10_ = i;
			_tmp11_ = g_utf8_next_char (_tmp10_);
			t = _tmp11_;
			_tmp12_ = t;
			next_upper = g_unichar_isupper (string_get_char (_tmp12_, (glong) 0));
			if (!prev_upper) {
				_tmp13_ = TRUE;
			} else {
				gboolean _tmp14_ = FALSE;
				const gchar* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				_tmp15_ = i;
				_tmp16_ = strlen (_tmp15_);
				_tmp17_ = _tmp16_;
				if (_tmp17_ >= 2) {
					_tmp14_ = !next_upper;
				} else {
					_tmp14_ = FALSE;
				}
				_tmp13_ = _tmp14_;
			}
			if (_tmp13_) {
				glong len = 0L;
				GString* _tmp18_;
				const gchar* _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				gboolean _tmp22_ = FALSE;
				_tmp18_ = result_builder;
				_tmp19_ = _tmp18_->str;
				_tmp20_ = strlen (_tmp19_);
				_tmp21_ = _tmp20_;
				len = (glong) _tmp21_;
				if (len != ((glong) 1)) {
					GString* _tmp23_;
					const gchar* _tmp24_;
					_tmp23_ = result_builder;
					_tmp24_ = _tmp23_->str;
					_tmp22_ = string_get_char (_tmp24_, len - 2) != ((gunichar) '_');
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					GString* _tmp25_;
					_tmp25_ = result_builder;
					g_string_append_c (_tmp25_, '_');
				}
			}
		}
		_tmp26_ = result_builder;
		g_string_append_unichar (_tmp26_, g_unichar_tolower (c));
		first = FALSE;
		_tmp27_ = i;
		_tmp28_ = g_utf8_next_char (_tmp27_);
		i = _tmp28_;
	}
	_tmp29_ = result_builder;
	_tmp30_ = _tmp29_->str;
	_tmp31_ = g_strdup (_tmp30_);
	result = _tmp31_;
	_g_string_free0 (result_builder);
	return result;
}

/**
 * Converts a string from lower_case to CamelCase.
 *
 * @param lower_case a string in lower case
 * @return           the specified string converted to camel case
 */
gchar*
vala_symbol_lower_case_to_camel_case (const gchar* lower_case)
{
	GString* result_builder = NULL;
	GString* _tmp0_;
	const gchar* i = NULL;
	gboolean last_underscore = FALSE;
	GString* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result = NULL;
	g_return_val_if_fail (lower_case != NULL, NULL);
	_tmp0_ = g_string_new ("");
	result_builder = _tmp0_;
	i = lower_case;
	last_underscore = TRUE;
	while (TRUE) {
		const gchar* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gunichar c = 0U;
		const gchar* _tmp4_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp1_ = i;
		_tmp2_ = strlen (_tmp1_);
		_tmp3_ = _tmp2_;
		if (!(_tmp3_ > 0)) {
			break;
		}
		_tmp4_ = i;
		c = string_get_char (_tmp4_, (glong) 0);
		if (c == ((gunichar) '_')) {
			last_underscore = TRUE;
		} else {
			if (g_unichar_isupper (c)) {
				gchar* _tmp5_;
				_tmp5_ = g_strdup (lower_case);
				result = _tmp5_;
				_g_string_free0 (result_builder);
				return result;
			} else {
				if (last_underscore) {
					GString* _tmp6_;
					_tmp6_ = result_builder;
					g_string_append_unichar (_tmp6_, g_unichar_toupper (c));
					last_underscore = FALSE;
				} else {
					GString* _tmp7_;
					_tmp7_ = result_builder;
					g_string_append_unichar (_tmp7_, c);
				}
			}
		}
		_tmp8_ = i;
		_tmp9_ = g_utf8_next_char (_tmp8_);
		i = _tmp9_;
	}
	_tmp10_ = result_builder;
	_tmp11_ = _tmp10_->str;
	_tmp12_ = g_strdup (_tmp11_);
	result = _tmp12_;
	_g_string_free0 (result_builder);
	return result;
}

/**
 * Implementation of GLib.EqualFunc to use with e.g. HashMap
 *
 * @param a a symbol
 * @param b a symbol
 * @return whether the given instances represent the same symbol
 */
gboolean
vala_symbol_equal_func (ValaSymbol* a,
                        ValaSymbol* b)
{
	GEqualFunc _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean result = FALSE;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = g_str_equal;
	_tmp1_ = vala_symbol_get_full_name (a);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_full_name (b);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp0_ (_tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp5_;
	return result;
}

/**
 * Implementation of GLib.HashFunc to use with e.g. HashMap
 *
 * @param s a symbol
 * @return a hash value
 */
guint
vala_symbol_hash_func (ValaSymbol* s)
{
	GHashFunc _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	guint _tmp3_;
	guint result = 0U;
	g_return_val_if_fail (s != NULL, 0U);
	_tmp0_ = g_str_hash;
	_tmp1_ = vala_symbol_get_full_name (s);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp0_ (_tmp2_);
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gpointer
_vala_scope_ref0 (gpointer self)
{
	return self ? vala_scope_ref (self) : NULL;
}

ValaScope*
vala_symbol_get_top_accessible_scope (ValaSymbol* self,
                                      gboolean is_internal)
{
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaScope* _tmp12_;
	ValaScope* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_access;
	if (_tmp0_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaScope* _tmp1_;
		ValaScope* _tmp2_;
		ValaScope* _tmp3_;
		_tmp1_ = vala_symbol_get_owner (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = _vala_scope_ref0 (_tmp2_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->_access;
	if (_tmp4_ == VALA_SYMBOL_ACCESSIBILITY_INTERNAL) {
		is_internal = TRUE;
	}
	_tmp5_ = vala_symbol_get_parent_symbol (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == NULL) {
		if (is_internal) {
			ValaScope* _tmp7_;
			ValaScope* _tmp8_;
			ValaScope* _tmp9_;
			_tmp7_ = vala_symbol_get_scope (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = _vala_scope_ref0 (_tmp8_);
			result = _tmp9_;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
	_tmp10_ = vala_symbol_get_parent_symbol (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_symbol_get_top_accessible_scope (_tmp11_, is_internal);
	result = _tmp12_;
	return result;
}

static gboolean
vala_symbol_real_is_instance_member (ValaSymbol* self)
{
	gboolean instance = FALSE;
	gboolean result = FALSE;
	instance = TRUE;
	if (VALA_IS_FIELD (self)) {
		ValaField* f = NULL;
		ValaField* _tmp0_;
		ValaField* _tmp1_;
		ValaMemberBinding _tmp2_;
		ValaMemberBinding _tmp3_;
		_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_FIELD, ValaField));
		f = _tmp0_;
		_tmp1_ = f;
		_tmp2_ = vala_field_get_binding (_tmp1_);
		_tmp3_ = _tmp2_;
		instance = _tmp3_ == VALA_MEMBER_BINDING_INSTANCE;
		_vala_code_node_unref0 (f);
	} else {
		if (VALA_IS_METHOD (self)) {
			ValaMethod* m = NULL;
			ValaMethod* _tmp4_;
			ValaMethod* _tmp5_;
			_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_METHOD, ValaMethod));
			m = _tmp4_;
			_tmp5_ = m;
			if (!VALA_IS_CREATION_METHOD (_tmp5_)) {
				ValaMethod* _tmp6_;
				ValaMemberBinding _tmp7_;
				ValaMemberBinding _tmp8_;
				_tmp6_ = m;
				_tmp7_ = vala_method_get_binding (_tmp6_);
				_tmp8_ = _tmp7_;
				instance = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
			}
			_vala_code_node_unref0 (m);
		} else {
			if (VALA_IS_PROPERTY (self)) {
				ValaProperty* prop = NULL;
				ValaProperty* _tmp9_;
				ValaProperty* _tmp10_;
				ValaMemberBinding _tmp11_;
				ValaMemberBinding _tmp12_;
				_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp9_;
				_tmp10_ = prop;
				_tmp11_ = vala_property_get_binding (_tmp10_);
				_tmp12_ = _tmp11_;
				instance = _tmp12_ == VALA_MEMBER_BINDING_INSTANCE;
				_vala_code_node_unref0 (prop);
			} else {
				if (VALA_IS_ENUM_VALUE (self)) {
					instance = FALSE;
				} else {
					if (VALA_IS_ERROR_CODE (self)) {
						instance = FALSE;
					}
				}
			}
		}
	}
	result = instance;
	return result;
}

gboolean
vala_symbol_is_instance_member (ValaSymbol* self)
{
	ValaSymbolClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = VALA_SYMBOL_GET_CLASS (self);
	if (_klass_->is_instance_member) {
		return _klass_->is_instance_member (self);
	}
	return FALSE;
}

static gboolean
vala_symbol_real_is_class_member (ValaSymbol* self)
{
	gboolean isclass = FALSE;
	gboolean result = FALSE;
	isclass = TRUE;
	if (VALA_IS_FIELD (self)) {
		ValaField* f = NULL;
		ValaField* _tmp0_;
		ValaField* _tmp1_;
		ValaMemberBinding _tmp2_;
		ValaMemberBinding _tmp3_;
		_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_FIELD, ValaField));
		f = _tmp0_;
		_tmp1_ = f;
		_tmp2_ = vala_field_get_binding (_tmp1_);
		_tmp3_ = _tmp2_;
		isclass = _tmp3_ == VALA_MEMBER_BINDING_CLASS;
		_vala_code_node_unref0 (f);
	} else {
		if (VALA_IS_METHOD (self)) {
			ValaMethod* m = NULL;
			ValaMethod* _tmp4_;
			ValaMethod* _tmp5_;
			_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_METHOD, ValaMethod));
			m = _tmp4_;
			_tmp5_ = m;
			if (!VALA_IS_CREATION_METHOD (_tmp5_)) {
				ValaMethod* _tmp6_;
				ValaMemberBinding _tmp7_;
				ValaMemberBinding _tmp8_;
				_tmp6_ = m;
				_tmp7_ = vala_method_get_binding (_tmp6_);
				_tmp8_ = _tmp7_;
				isclass = _tmp8_ == VALA_MEMBER_BINDING_CLASS;
			}
			_vala_code_node_unref0 (m);
		} else {
			if (VALA_IS_PROPERTY (self)) {
				ValaProperty* prop = NULL;
				ValaProperty* _tmp9_;
				ValaProperty* _tmp10_;
				ValaMemberBinding _tmp11_;
				ValaMemberBinding _tmp12_;
				_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp9_;
				_tmp10_ = prop;
				_tmp11_ = vala_property_get_binding (_tmp10_);
				_tmp12_ = _tmp11_;
				isclass = _tmp12_ == VALA_MEMBER_BINDING_CLASS;
				_vala_code_node_unref0 (prop);
			} else {
				if (VALA_IS_ENUM_VALUE (self)) {
					isclass = FALSE;
				} else {
					if (VALA_IS_ERROR_CODE (self)) {
						isclass = FALSE;
					}
				}
			}
		}
	}
	result = isclass;
	return result;
}

gboolean
vala_symbol_is_class_member (ValaSymbol* self)
{
	ValaSymbolClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = VALA_SYMBOL_GET_CLASS (self);
	if (_klass_->is_class_member) {
		return _klass_->is_class_member (self);
	}
	return FALSE;
}

ValaSymbol*
vala_symbol_get_hidden_member (ValaSymbol* self)
{
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	sym = NULL;
	_tmp0_ = vala_symbol_get_parent_symbol (self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_CLASS (_tmp1_)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaClass* _tmp4_;
		ValaClass* _tmp5_;
		ValaClass* _tmp6_;
		_tmp2_ = vala_symbol_get_parent_symbol (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_class_get_base_class (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_CLASS, ValaClass));
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (_tmp5_);
		cl = _tmp6_;
		while (TRUE) {
			ValaClass* _tmp7_;
			ValaClass* _tmp8_;
			ValaScope* _tmp9_;
			ValaScope* _tmp10_;
			const gchar* _tmp11_;
			ValaSymbol* _tmp12_;
			gboolean _tmp13_ = FALSE;
			ValaSymbol* _tmp14_;
			ValaClass* _tmp17_;
			ValaClass* _tmp18_;
			ValaClass* _tmp19_;
			ValaClass* _tmp20_;
			_tmp7_ = cl;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp8_ = cl;
			_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = self->priv->_name;
			_tmp12_ = vala_scope_lookup (_tmp10_, _tmp11_);
			_vala_code_node_unref0 (sym);
			sym = _tmp12_;
			_tmp14_ = sym;
			if (_tmp14_ != NULL) {
				ValaSymbol* _tmp15_;
				ValaSymbolAccessibility _tmp16_;
				_tmp15_ = sym;
				_tmp16_ = _tmp15_->priv->_access;
				_tmp13_ = _tmp16_ != VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				result = sym;
				_vala_code_node_unref0 (cl);
				return result;
			}
			_tmp17_ = cl;
			_tmp18_ = vala_class_get_base_class (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = _vala_code_node_ref0 (_tmp19_);
			_vala_code_node_unref0 (cl);
			cl = _tmp20_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		_tmp21_ = vala_symbol_get_parent_symbol (self);
		_tmp22_ = _tmp21_;
		if (VALA_IS_STRUCT (_tmp22_)) {
			ValaStruct* st = NULL;
			ValaSymbol* _tmp23_;
			ValaSymbol* _tmp24_;
			ValaStruct* _tmp25_;
			ValaStruct* _tmp26_;
			ValaStruct* _tmp27_;
			_tmp23_ = vala_symbol_get_parent_symbol (self);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_struct_get_base_struct (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, VALA_TYPE_STRUCT, ValaStruct));
			_tmp26_ = _tmp25_;
			_tmp27_ = _vala_code_node_ref0 (_tmp26_);
			st = _tmp27_;
			while (TRUE) {
				ValaStruct* _tmp28_;
				ValaStruct* _tmp29_;
				ValaScope* _tmp30_;
				ValaScope* _tmp31_;
				const gchar* _tmp32_;
				ValaSymbol* _tmp33_;
				gboolean _tmp34_ = FALSE;
				ValaSymbol* _tmp35_;
				ValaStruct* _tmp38_;
				ValaStruct* _tmp39_;
				ValaStruct* _tmp40_;
				ValaStruct* _tmp41_;
				_tmp28_ = st;
				if (!(_tmp28_ != NULL)) {
					break;
				}
				_tmp29_ = st;
				_tmp30_ = vala_symbol_get_scope ((ValaSymbol*) _tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = self->priv->_name;
				_tmp33_ = vala_scope_lookup (_tmp31_, _tmp32_);
				_vala_code_node_unref0 (sym);
				sym = _tmp33_;
				_tmp35_ = sym;
				if (_tmp35_ != NULL) {
					ValaSymbol* _tmp36_;
					ValaSymbolAccessibility _tmp37_;
					_tmp36_ = sym;
					_tmp37_ = _tmp36_->priv->_access;
					_tmp34_ = _tmp37_ != VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp34_ = FALSE;
				}
				if (_tmp34_) {
					result = sym;
					_vala_code_node_unref0 (st);
					return result;
				}
				_tmp38_ = st;
				_tmp39_ = vala_struct_get_base_struct (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = _vala_code_node_ref0 (_tmp40_);
				_vala_code_node_unref0 (st);
				st = _tmp41_;
			}
			_vala_code_node_unref0 (st);
		}
	}
	result = NULL;
	_vala_code_node_unref0 (sym);
	return result;
}

gboolean
vala_symbol_is_accessible (ValaSymbol* self,
                           ValaSymbol* sym)
{
	ValaScope* sym_scope = NULL;
	ValaScope* _tmp0_;
	ValaScope* this_scope = NULL;
	ValaScope* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ValaScope* _tmp4_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_symbol_get_top_accessible_scope (sym, FALSE);
	sym_scope = _tmp0_;
	_tmp1_ = vala_symbol_get_top_accessible_scope (self, FALSE);
	this_scope = _tmp1_;
	_tmp4_ = sym_scope;
	if (_tmp4_ == NULL) {
		ValaScope* _tmp5_;
		_tmp5_ = this_scope;
		_tmp3_ = _tmp5_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		ValaScope* _tmp7_;
		_tmp7_ = sym_scope;
		if (_tmp7_ != NULL) {
			ValaScope* _tmp8_;
			ValaScope* _tmp9_;
			_tmp8_ = sym_scope;
			_tmp9_ = this_scope;
			_tmp6_ = !vala_scope_is_subscope_of (_tmp8_, _tmp9_);
		} else {
			_tmp6_ = FALSE;
		}
		_tmp2_ = _tmp6_;
	}
	if (_tmp2_) {
		result = FALSE;
		_vala_scope_unref0 (this_scope);
		_vala_scope_unref0 (sym_scope);
		return result;
	}
	result = TRUE;
	_vala_scope_unref0 (this_scope);
	_vala_scope_unref0 (sym_scope);
	return result;
}

static void
vala_symbol_real_add_namespace (ValaSymbol* self,
                                ValaNamespace* ns)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (ns != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_full_name (self);
	_tmp3_ = _tmp2_;
	vala_report_error (_tmp1_, "inner `%s' is not supported in `%s'", "namespace", _tmp3_);
	_g_free0 (_tmp3_);
}

void
vala_symbol_add_namespace (ValaSymbol* self,
                           ValaNamespace* ns)
{
	ValaSymbolClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_SYMBOL_GET_CLASS (self);
	if (_klass_->add_namespace) {
		_klass_->add_namespace (self, ns);
	}
}

static void
vala_symbol_real_add_class (ValaSymbol* self,
                            ValaClass* cl)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_full_name (self);
	_tmp3_ = _tmp2_;
	vala_report_error (_tmp1_, "inner `%s' types are not supported in `%s'", "class", _tmp3_);
	_g_free0 (_tmp3_);
}

void
vala_symbol_add_class (ValaSymbol* self,
                       ValaClass* cl)
{
	ValaSymbolClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_SYMBOL_GET_CLASS (self);
	if (_klass_->add_class) {
		_klass_->add_class (self, cl);
	}
}

static void
vala_symbol_real_add_interface (ValaSymbol* self,
                                ValaInterface* iface)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (iface != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) iface);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_full_name (self);
	_tmp3_ = _tmp2_;
	vala_report_error (_tmp1_, "inner `%s' types are not supported in `%s'", "interface", _tmp3_);
	_g_free0 (_tmp3_);
}

void
vala_symbol_add_interface (ValaSymbol* self,
                           ValaInterface* iface)
{
	ValaSymbolClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_SYMBOL_GET_CLASS (self);
	if (_klass_->add_interface) {
		_klass_->add_interface (self, iface);
	}
}

static void
vala_symbol_real_add_struct (ValaSymbol* self,
                             ValaStruct* st)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (st != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) st);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_full_name (self);
	_tmp3_ = _tmp2_;
	vala_report_error (_tmp1_, "inner `%s' types are not supported in `%s'", "struct", _tmp3_);
	_g_free0 (_tmp3_);
}

void
vala_symbol_add_struct (ValaSymbol* self,
                        ValaStruct* st)
{
	ValaSymbolClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_SYMBOL_GET_CLASS (self);
	if (_klass_->add_struct) {
		_klass_->add_struct (self, st);
	}
}

static void
vala_symbol_real_add_enum (ValaSymbol* self,
                           ValaEnum* en)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (en != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) en);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_full_name (self);
	_tmp3_ = _tmp2_;
	vala_report_error (_tmp1_, "inner `%s' types are not supported in `%s'", "enum", _tmp3_);
	_g_free0 (_tmp3_);
}

void
vala_symbol_add_enum (ValaSymbol* self,
                      ValaEnum* en)
{
	ValaSymbolClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_SYMBOL_GET_CLASS (self);
	if (_klass_->add_enum) {
		_klass_->add_enum (self, en);
	}
}

static void
vala_symbol_real_add_error_domain (ValaSymbol* self,
                                   ValaErrorDomain* edomain)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) edomain);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_full_name (self);
	_tmp3_ = _tmp2_;
	vala_report_error (_tmp1_, "inner `%s' types are not supported in `%s'", "errordomain", _tmp3_);
	_g_free0 (_tmp3_);
}

void
vala_symbol_add_error_domain (ValaSymbol* self,
                              ValaErrorDomain* edomain)
{
	ValaSymbolClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_SYMBOL_GET_CLASS (self);
	if (_klass_->add_error_domain) {
		_klass_->add_error_domain (self, edomain);
	}
}

static void
vala_symbol_real_add_delegate (ValaSymbol* self,
                               ValaDelegate* d)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_full_name (self);
	_tmp3_ = _tmp2_;
	vala_report_error (_tmp1_, "inner `%s' types are not supported in `%s'", "delegate", _tmp3_);
	_g_free0 (_tmp3_);
}

void
vala_symbol_add_delegate (ValaSymbol* self,
                          ValaDelegate* d)
{
	ValaSymbolClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_SYMBOL_GET_CLASS (self);
	if (_klass_->add_delegate) {
		_klass_->add_delegate (self, d);
	}
}

static void
vala_symbol_real_add_constant (ValaSymbol* self,
                               ValaConstant* constant)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (constant != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) constant);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_full_name (self);
	_tmp3_ = _tmp2_;
	vala_report_error (_tmp1_, "constants are not allowed in `%s'", _tmp3_);
	_g_free0 (_tmp3_);
}

void
vala_symbol_add_constant (ValaSymbol* self,
                          ValaConstant* constant)
{
	ValaSymbolClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_SYMBOL_GET_CLASS (self);
	if (_klass_->add_constant) {
		_klass_->add_constant (self, constant);
	}
}

static void
vala_symbol_real_add_field (ValaSymbol* self,
                            ValaField* f)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (f != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_full_name (self);
	_tmp3_ = _tmp2_;
	vala_report_error (_tmp1_, "fields are not allowed in `%s'", _tmp3_);
	_g_free0 (_tmp3_);
}

void
vala_symbol_add_field (ValaSymbol* self,
                       ValaField* f)
{
	ValaSymbolClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_SYMBOL_GET_CLASS (self);
	if (_klass_->add_field) {
		_klass_->add_field (self, f);
	}
}

static void
vala_symbol_real_add_method (ValaSymbol* self,
                             ValaMethod* m)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (m != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_full_name (self);
	_tmp3_ = _tmp2_;
	vala_report_error (_tmp1_, "methods are not allowed in `%s'", _tmp3_);
	_g_free0 (_tmp3_);
}

void
vala_symbol_add_method (ValaSymbol* self,
                        ValaMethod* m)
{
	ValaSymbolClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_SYMBOL_GET_CLASS (self);
	if (_klass_->add_method) {
		_klass_->add_method (self, m);
	}
}

static void
vala_symbol_real_add_property (ValaSymbol* self,
                               ValaProperty* prop)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (prop != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_full_name (self);
	_tmp3_ = _tmp2_;
	vala_report_error (_tmp1_, "properties are not allowed in `%s'", _tmp3_);
	_g_free0 (_tmp3_);
}

void
vala_symbol_add_property (ValaSymbol* self,
                          ValaProperty* prop)
{
	ValaSymbolClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_SYMBOL_GET_CLASS (self);
	if (_klass_->add_property) {
		_klass_->add_property (self, prop);
	}
}

static void
vala_symbol_real_add_signal (ValaSymbol* self,
                             ValaSignal* sig)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (sig != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) sig);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_full_name (self);
	_tmp3_ = _tmp2_;
	vala_report_error (_tmp1_, "signals are not allowed in `%s'", _tmp3_);
	_g_free0 (_tmp3_);
}

void
vala_symbol_add_signal (ValaSymbol* self,
                        ValaSignal* sig)
{
	ValaSymbolClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_SYMBOL_GET_CLASS (self);
	if (_klass_->add_signal) {
		_klass_->add_signal (self, sig);
	}
}

static void
vala_symbol_real_add_constructor (ValaSymbol* self,
                                  ValaConstructor* c)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_full_name (self);
	_tmp3_ = _tmp2_;
	vala_report_error (_tmp1_, "constructors are not allowed in `%s'", _tmp3_);
	_g_free0 (_tmp3_);
}

void
vala_symbol_add_constructor (ValaSymbol* self,
                             ValaConstructor* c)
{
	ValaSymbolClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_SYMBOL_GET_CLASS (self);
	if (_klass_->add_constructor) {
		_klass_->add_constructor (self, c);
	}
}

static void
vala_symbol_real_add_destructor (ValaSymbol* self,
                                 ValaDestructor* d)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_full_name (self);
	_tmp3_ = _tmp2_;
	vala_report_error (_tmp1_, "destructors are not allowed in `%s'", _tmp3_);
	_g_free0 (_tmp3_);
}

void
vala_symbol_add_destructor (ValaSymbol* self,
                            ValaDestructor* d)
{
	ValaSymbolClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_SYMBOL_GET_CLASS (self);
	if (_klass_->add_destructor) {
		_klass_->add_destructor (self, d);
	}
}

static gchar*
vala_symbol_real_to_string (ValaCodeNode* base)
{
	ValaSymbol * self;
	gchar* _tmp0_;
	gchar* result = NULL;
	self = (ValaSymbol*) base;
	_tmp0_ = vala_symbol_get_full_name (self);
	result = _tmp0_;
	return result;
}

static void
vala_symbol_class_init (ValaSymbolClass * klass,
                        gpointer klass_data)
{
	vala_symbol_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_symbol_finalize;
	g_type_class_adjust_private_offset (klass, &ValaSymbol_private_offset);
	((ValaSymbolClass *) klass)->is_instance_member = (gboolean (*) (ValaSymbol*)) vala_symbol_real_is_instance_member;
	((ValaSymbolClass *) klass)->is_class_member = (gboolean (*) (ValaSymbol*)) vala_symbol_real_is_class_member;
	((ValaSymbolClass *) klass)->add_namespace = (void (*) (ValaSymbol*, ValaNamespace*)) vala_symbol_real_add_namespace;
	((ValaSymbolClass *) klass)->add_class = (void (*) (ValaSymbol*, ValaClass*)) vala_symbol_real_add_class;
	((ValaSymbolClass *) klass)->add_interface = (void (*) (ValaSymbol*, ValaInterface*)) vala_symbol_real_add_interface;
	((ValaSymbolClass *) klass)->add_struct = (void (*) (ValaSymbol*, ValaStruct*)) vala_symbol_real_add_struct;
	((ValaSymbolClass *) klass)->add_enum = (void (*) (ValaSymbol*, ValaEnum*)) vala_symbol_real_add_enum;
	((ValaSymbolClass *) klass)->add_error_domain = (void (*) (ValaSymbol*, ValaErrorDomain*)) vala_symbol_real_add_error_domain;
	((ValaSymbolClass *) klass)->add_delegate = (void (*) (ValaSymbol*, ValaDelegate*)) vala_symbol_real_add_delegate;
	((ValaSymbolClass *) klass)->add_constant = (void (*) (ValaSymbol*, ValaConstant*)) vala_symbol_real_add_constant;
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_symbol_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_symbol_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_symbol_real_add_property;
	((ValaSymbolClass *) klass)->add_signal = (void (*) (ValaSymbol*, ValaSignal*)) vala_symbol_real_add_signal;
	((ValaSymbolClass *) klass)->add_constructor = (void (*) (ValaSymbol*, ValaConstructor*)) vala_symbol_real_add_constructor;
	((ValaSymbolClass *) klass)->add_destructor = (void (*) (ValaSymbol*, ValaDestructor*)) vala_symbol_real_add_destructor;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_symbol_real_to_string;
}

static void
vala_symbol_instance_init (ValaSymbol * self,
                           gpointer klass)
{
	self->priv = vala_symbol_get_instance_private (self);
	self->priv->_active = TRUE;
}

static void
vala_symbol_finalize (ValaCodeNode * obj)
{
	ValaSymbol * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SYMBOL, ValaSymbol);
	_g_free0 (self->priv->_name);
	_vala_comment_unref0 (self->priv->_comment);
	_vala_version_attribute_unref0 (self->priv->_version);
	_vala_scope_unref0 (self->priv->_scope);
	_g_free0 (self->priv->_external);
	VALA_CODE_NODE_CLASS (vala_symbol_parent_class)->finalize (obj);
}

/**
 * Represents a node in the symbol tree.
 */
static GType
vala_symbol_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaSymbolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_symbol_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSymbol), 0, (GInstanceInitFunc) vala_symbol_instance_init, NULL };
	GType vala_symbol_type_id;
	vala_symbol_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaSymbol", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	ValaSymbol_private_offset = g_type_add_instance_private (vala_symbol_type_id, sizeof (ValaSymbolPrivate));
	return vala_symbol_type_id;
}

GType
vala_symbol_get_type (void)
{
	static volatile gsize vala_symbol_type_id__volatile = 0;
	if (g_once_init_enter (&vala_symbol_type_id__volatile)) {
		GType vala_symbol_type_id;
		vala_symbol_type_id = vala_symbol_get_type_once ();
		g_once_init_leave (&vala_symbol_type_id__volatile, vala_symbol_type_id);
	}
	return vala_symbol_type_id__volatile;
}

const gchar*
vala_symbol_accessibility_to_string (ValaSymbolAccessibility self)
{
	const gchar* result = NULL;
	switch (self) {
		case VALA_SYMBOL_ACCESSIBILITY_PROTECTED:
		{
			result = "protected";
			return result;
		}
		case VALA_SYMBOL_ACCESSIBILITY_INTERNAL:
		{
			result = "internal";
			return result;
		}
		case VALA_SYMBOL_ACCESSIBILITY_PRIVATE:
		{
			result = "private";
			return result;
		}
		case VALA_SYMBOL_ACCESSIBILITY_PUBLIC:
		{
			result = "public";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
vala_symbol_accessibility_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_SYMBOL_ACCESSIBILITY_PRIVATE, "VALA_SYMBOL_ACCESSIBILITY_PRIVATE", "private"}, {VALA_SYMBOL_ACCESSIBILITY_INTERNAL, "VALA_SYMBOL_ACCESSIBILITY_INTERNAL", "internal"}, {VALA_SYMBOL_ACCESSIBILITY_PROTECTED, "VALA_SYMBOL_ACCESSIBILITY_PROTECTED", "protected"}, {VALA_SYMBOL_ACCESSIBILITY_PUBLIC, "VALA_SYMBOL_ACCESSIBILITY_PUBLIC", "public"}, {0, NULL, NULL}};
	GType vala_symbol_accessibility_type_id;
	vala_symbol_accessibility_type_id = g_enum_register_static ("ValaSymbolAccessibility", values);
	return vala_symbol_accessibility_type_id;
}

GType
vala_symbol_accessibility_get_type (void)
{
	static volatile gsize vala_symbol_accessibility_type_id__volatile = 0;
	if (g_once_init_enter (&vala_symbol_accessibility_type_id__volatile)) {
		GType vala_symbol_accessibility_type_id;
		vala_symbol_accessibility_type_id = vala_symbol_accessibility_get_type_once ();
		g_once_init_leave (&vala_symbol_accessibility_type_id__volatile, vala_symbol_accessibility_type_id);
	}
	return vala_symbol_accessibility_type_id__volatile;
}

static GType
vala_member_binding_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_MEMBER_BINDING_INSTANCE, "VALA_MEMBER_BINDING_INSTANCE", "instance"}, {VALA_MEMBER_BINDING_CLASS, "VALA_MEMBER_BINDING_CLASS", "class"}, {VALA_MEMBER_BINDING_STATIC, "VALA_MEMBER_BINDING_STATIC", "static"}, {0, NULL, NULL}};
	GType vala_member_binding_type_id;
	vala_member_binding_type_id = g_enum_register_static ("ValaMemberBinding", values);
	return vala_member_binding_type_id;
}

GType
vala_member_binding_get_type (void)
{
	static volatile gsize vala_member_binding_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_binding_type_id__volatile)) {
		GType vala_member_binding_type_id;
		vala_member_binding_type_id = vala_member_binding_get_type_once ();
		g_once_init_leave (&vala_member_binding_type_id__volatile, vala_member_binding_type_id);
	}
	return vala_member_binding_type_id__volatile;
}

