/* valaparameter.c generated by valac, the Vala compiler
 * generated from valaparameter.vala, do not modify */

/* valaparameter.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaParameterPrivate {
	ValaParameterDirection _direction;
	gboolean _ellipsis;
	gboolean _params_array;
	gboolean _captured;
	ValaParameter* _base_parameter;
};

static gint ValaParameter_private_offset;
static gpointer vala_parameter_parent_class = NULL;

static void vala_parameter_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor);
static void vala_parameter_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static void vala_parameter_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type);
static void vala_parameter_real_replace_expression (ValaCodeNode* base,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node);
static gboolean vala_parameter_real_check (ValaCodeNode* base,
                                    ValaCodeContext* context);
static void vala_parameter_finalize (ValaCodeNode * obj);
static GType vala_parameter_get_type_once (void);

static inline gpointer
vala_parameter_get_instance_private (ValaParameter* self)
{
	return G_STRUCT_MEMBER_P (self, ValaParameter_private_offset);
}

ValaParameterDirection
vala_parameter_get_direction (ValaParameter* self)
{
	ValaParameterDirection result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_direction;
	return result;
}

void
vala_parameter_set_direction (ValaParameter* self,
                              ValaParameterDirection value)
{
	g_return_if_fail (self != NULL);
	self->priv->_direction = value;
}

gboolean
vala_parameter_get_ellipsis (ValaParameter* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_ellipsis;
	return result;
}

void
vala_parameter_set_ellipsis (ValaParameter* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_ellipsis = value;
}

gboolean
vala_parameter_get_params_array (ValaParameter* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_params_array;
	return result;
}

void
vala_parameter_set_params_array (ValaParameter* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_params_array = value;
}

gboolean
vala_parameter_get_captured (ValaParameter* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_captured;
	return result;
}

void
vala_parameter_set_captured (ValaParameter* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_captured = value;
}

gboolean
vala_parameter_get_format_arg (ValaParameter* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "FormatArg");
	result = _tmp0_ != NULL;
	return result;
}

ValaParameter*
vala_parameter_get_base_parameter (ValaParameter* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_parameter;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_parameter_set_base_parameter (ValaParameter* self,
                                   ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_parameter);
	self->priv->_base_parameter = _tmp0_;
}

/**
 * Creates a new formal parameter.
 *
 * @param name              parameter name
 * @param variable_type     parameter type
 * @param source_reference  reference to source code
 * @return                  newly created formal parameter
 */
ValaParameter*
vala_parameter_construct (GType object_type,
                          const gchar* name,
                          ValaDataType* variable_type,
                          ValaSourceReference* source_reference)
{
	ValaParameter* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaParameter*) vala_variable_construct (object_type, variable_type, name, NULL, source_reference, NULL);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}

ValaParameter*
vala_parameter_new (const gchar* name,
                    ValaDataType* variable_type,
                    ValaSourceReference* source_reference)
{
	return vala_parameter_construct (VALA_TYPE_PARAMETER, name, variable_type, source_reference);
}

/**
 * Creates a new ellipsis parameter representing an indefinite number of
 * parameters.
 */
ValaParameter*
vala_parameter_construct_with_ellipsis (GType object_type,
                                        ValaSourceReference* source_reference)
{
	ValaParameter* self = NULL;
	self = (ValaParameter*) vala_variable_construct (object_type, NULL, NULL, NULL, source_reference, NULL);
	vala_parameter_set_ellipsis (self, TRUE);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}

ValaParameter*
vala_parameter_new_with_ellipsis (ValaSourceReference* source_reference)
{
	return vala_parameter_construct_with_ellipsis (VALA_TYPE_PARAMETER, source_reference);
}

static void
vala_parameter_real_accept (ValaCodeNode* base,
                            ValaCodeVisitor* visitor)
{
	ValaParameter * self;
	self = (ValaParameter*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_formal_parameter (visitor, self);
}

static void
vala_parameter_real_accept_children (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaParameter * self;
	gboolean _tmp0_;
	self = (ValaParameter*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = self->priv->_ellipsis;
	if (!_tmp0_) {
		ValaDataType* _tmp1_;
		ValaDataType* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp1_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp2_ = _tmp1_;
		vala_code_node_accept ((ValaCodeNode*) _tmp2_, visitor);
		_tmp3_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaExpression* _tmp5_;
			ValaExpression* _tmp6_;
			_tmp5_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp6_ = _tmp5_;
			vala_code_node_accept ((ValaCodeNode*) _tmp6_, visitor);
		}
	}
}

static void
vala_parameter_real_replace_type (ValaCodeNode* base,
                                  ValaDataType* old_type,
                                  ValaDataType* new_type)
{
	ValaParameter * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaParameter*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}

static void
vala_parameter_real_replace_expression (ValaCodeNode* base,
                                        ValaExpression* old_node,
                                        ValaExpression* new_node)
{
	ValaParameter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaParameter*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}

ValaParameter*
vala_parameter_copy (ValaParameter* self)
{
	gboolean _tmp0_;
	ValaParameter* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ellipsis;
	if (!_tmp0_) {
		ValaParameter* _result_ = NULL;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaParameter* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		gboolean _tmp12_;
		ValaParameter* _tmp13_;
		ValaParameterDirection _tmp14_;
		ValaParameter* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		GList* _tmp18_;
		_tmp1_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_data_type_copy (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_parameter_new (_tmp2_, _tmp6_, _tmp8_);
		_tmp10_ = _tmp9_;
		_vala_code_node_unref0 (_tmp6_);
		_result_ = _tmp10_;
		_tmp11_ = _result_;
		_tmp12_ = self->priv->_params_array;
		vala_parameter_set_params_array (_tmp11_, _tmp12_);
		_tmp13_ = _result_;
		_tmp14_ = self->priv->_direction;
		vala_parameter_set_direction (_tmp13_, _tmp14_);
		_tmp15_ = _result_;
		_tmp16_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp17_ = _tmp16_;
		vala_variable_set_initializer ((ValaVariable*) _tmp15_, _tmp17_);
		_tmp18_ = ((ValaCodeNode*) self)->attributes;
		{
			GList* a_collection = NULL;
			GList* a_it = NULL;
			a_collection = _tmp18_;
			for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
				ValaAttribute* _tmp19_;
				ValaAttribute* a = NULL;
				_tmp19_ = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
				a = _tmp19_;
				{
					ValaParameter* _tmp20_;
					ValaAttribute* _tmp21_;
					ValaAttribute* _tmp22_;
					_tmp20_ = _result_;
					_tmp21_ = a;
					_tmp22_ = _vala_code_node_ref0 (_tmp21_);
					((ValaCodeNode*) _tmp20_)->attributes = g_list_append (((ValaCodeNode*) _tmp20_)->attributes, _tmp22_);
					_vala_code_node_unref0 (a);
				}
			}
		}
		result = _result_;
		return result;
	} else {
		ValaParameter* _tmp23_;
		_tmp23_ = vala_parameter_new_with_ellipsis (NULL);
		result = _tmp23_;
		return result;
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_parameter_real_check (ValaCodeNode* base,
                           ValaCodeContext* context)
{
	ValaParameter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaSymbol* _tmp24_;
	ValaSymbol* _tmp25_;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	gboolean _tmp34_;
	gboolean _tmp88_ = FALSE;
	ValaExpression* _tmp89_;
	ValaExpression* _tmp90_;
	gboolean _tmp151_;
	ValaMethod* m = NULL;
	ValaSymbol* _tmp192_;
	ValaSymbol* _tmp193_;
	ValaMethod* _tmp194_;
	ValaSemanticAnalyzer* _tmp224_;
	ValaSemanticAnalyzer* _tmp225_;
	ValaSourceFile* _tmp226_;
	ValaSemanticAnalyzer* _tmp227_;
	ValaSemanticAnalyzer* _tmp228_;
	ValaSymbol* _tmp229_;
	gboolean _tmp230_;
	gboolean _tmp231_;
	gboolean result = FALSE;
	self = (ValaParameter*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp25_ = _tmp24_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, _tmp25_);
	_tmp26_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp27_ = _tmp26_;
	if (_tmp27_ != NULL) {
		ValaDataType* _tmp28_;
		ValaDataType* _tmp29_;
		ValaDataType* _tmp32_;
		ValaDataType* _tmp33_;
		_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp29_ = _tmp28_;
		if (VALA_IS_VOID_TYPE (_tmp29_)) {
			ValaSourceReference* _tmp30_;
			ValaSourceReference* _tmp31_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp31_ = _tmp30_;
			vala_report_error (_tmp31_, "'void' not supported as parameter type");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp32_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp33_ = _tmp32_;
		vala_code_node_check ((ValaCodeNode*) _tmp33_, context);
	}
	_tmp34_ = self->priv->_ellipsis;
	if (!_tmp34_) {
		ValaDataType* _tmp35_;
		ValaDataType* _tmp36_;
		gboolean _tmp37_;
		gboolean _tmp48_ = FALSE;
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaArrayType* variable_array_type = NULL;
		ValaDataType* _tmp75_;
		ValaDataType* _tmp76_;
		gboolean _tmp77_ = FALSE;
		gboolean _tmp78_ = FALSE;
		ValaArrayType* _tmp79_;
		_tmp35_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp36_ = _tmp35_;
		vala_code_node_check ((ValaCodeNode*) _tmp36_, context);
		_tmp37_ = self->priv->_params_array;
		if (_tmp37_) {
			ValaDataType* _tmp38_;
			ValaDataType* _tmp39_;
			_tmp38_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp39_ = _tmp38_;
			if (!VALA_IS_ARRAY_TYPE (_tmp39_)) {
				ValaSourceReference* _tmp40_;
				ValaSourceReference* _tmp41_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp41_ = _tmp40_;
				vala_report_error (_tmp41_, "parameter array expected");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			} else {
				ValaDataType* _tmp42_;
				ValaDataType* _tmp43_;
				gint _tmp44_;
				gint _tmp45_;
				_tmp42_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp43_ = _tmp42_;
				_tmp44_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp45_ = _tmp44_;
				if (_tmp45_ != 1) {
					ValaSourceReference* _tmp46_;
					ValaSourceReference* _tmp47_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp47_ = _tmp46_;
					vala_report_error (_tmp47_, "multi-dimensional parameter array not allowed");
					result = FALSE;
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
			}
		}
		if (vala_code_node_has_attribute_argument ((ValaCodeNode*) self, "CCode", "scope")) {
			ValaDataType* _tmp49_;
			ValaDataType* _tmp50_;
			_tmp49_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp50_ = _tmp49_;
			_tmp48_ = VALA_IS_DELEGATE_TYPE (_tmp50_);
		} else {
			_tmp48_ = FALSE;
		}
		if (_tmp48_) {
			ValaDelegateType* delegate_type = NULL;
			ValaDataType* _tmp51_;
			ValaDataType* _tmp52_;
			ValaDelegateType* _tmp53_;
			ValaDelegateType* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			_tmp51_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp52_ = _tmp51_;
			_tmp53_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			delegate_type = _tmp53_;
			_tmp54_ = delegate_type;
			_tmp55_ = vala_code_node_get_attribute_string ((ValaCodeNode*) self, "CCode", "scope", NULL);
			_tmp56_ = _tmp55_;
			vala_delegate_type_set_is_called_once (_tmp54_, g_strcmp0 (_tmp56_, "async") == 0);
			_g_free0 (_tmp56_);
			_vala_code_node_unref0 (delegate_type);
		}
		_tmp57_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp58_ = _tmp57_;
		if (_tmp58_ != NULL) {
			ValaExpression* _tmp59_;
			ValaExpression* _tmp60_;
			ValaDataType* _tmp61_;
			ValaDataType* _tmp62_;
			ValaDataType* _tmp63_;
			ValaDataType* _tmp64_;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaExpression* _tmp67_;
			ValaExpression* _tmp68_;
			ValaDataType* _tmp69_;
			ValaDataType* _tmp70_;
			_tmp59_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_data_type_copy (_tmp62_);
			_tmp64_ = _tmp63_;
			vala_expression_set_target_type (_tmp60_, _tmp64_);
			_vala_code_node_unref0 (_tmp64_);
			_tmp65_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp66_ = _tmp65_;
			vala_code_node_check ((ValaCodeNode*) _tmp66_, context);
			_tmp67_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp68_ = _tmp67_;
			_tmp69_ = vala_expression_get_value_type (_tmp68_);
			_tmp70_ = _tmp69_;
			if (_tmp70_ == NULL) {
				ValaExpression* _tmp71_;
				ValaExpression* _tmp72_;
				ValaInvalidType* _tmp73_;
				ValaInvalidType* _tmp74_;
				_tmp71_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp72_ = _tmp71_;
				_tmp73_ = vala_invalid_type_new ();
				_tmp74_ = _tmp73_;
				vala_expression_set_value_type (_tmp72_, (ValaDataType*) _tmp74_);
				_vala_code_node_unref0 (_tmp74_);
			}
		}
		_tmp75_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp76_ = _tmp75_;
		variable_array_type = VALA_IS_ARRAY_TYPE (_tmp76_) ? ((ValaArrayType*) _tmp76_) : NULL;
		_tmp79_ = variable_array_type;
		if (_tmp79_ != NULL) {
			ValaArrayType* _tmp80_;
			gboolean _tmp81_;
			gboolean _tmp82_;
			_tmp80_ = variable_array_type;
			_tmp81_ = vala_array_type_get_inline_allocated (_tmp80_);
			_tmp82_ = _tmp81_;
			_tmp78_ = _tmp82_;
		} else {
			_tmp78_ = FALSE;
		}
		if (_tmp78_) {
			ValaArrayType* _tmp83_;
			gboolean _tmp84_;
			gboolean _tmp85_;
			_tmp83_ = variable_array_type;
			_tmp84_ = vala_array_type_get_fixed_length (_tmp83_);
			_tmp85_ = _tmp84_;
			_tmp77_ = !_tmp85_;
		} else {
			_tmp77_ = FALSE;
		}
		if (_tmp77_) {
			ValaSourceReference* _tmp86_;
			ValaSourceReference* _tmp87_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp86_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp87_ = _tmp86_;
			vala_report_error (_tmp87_, "Inline allocated array as parameter requires to have fixed length");
		}
	}
	_tmp89_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp90_ = _tmp89_;
	if (_tmp90_ != NULL) {
		ValaExpression* _tmp91_;
		ValaExpression* _tmp92_;
		gboolean _tmp93_;
		gboolean _tmp94_;
		_tmp91_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp92_ = _tmp91_;
		_tmp93_ = vala_code_node_get_error ((ValaCodeNode*) _tmp92_);
		_tmp94_ = _tmp93_;
		_tmp88_ = !_tmp94_;
	} else {
		_tmp88_ = FALSE;
	}
	if (_tmp88_) {
		gboolean _tmp95_ = FALSE;
		gboolean _tmp96_ = FALSE;
		ValaExpression* _tmp97_;
		ValaExpression* _tmp98_;
		_tmp97_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp98_ = _tmp97_;
		if (VALA_IS_NULL_LITERAL (_tmp98_)) {
			ValaDataType* _tmp99_;
			ValaDataType* _tmp100_;
			gboolean _tmp101_;
			gboolean _tmp102_;
			_tmp99_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp100_ = _tmp99_;
			_tmp101_ = vala_data_type_get_nullable (_tmp100_);
			_tmp102_ = _tmp101_;
			_tmp96_ = !_tmp102_;
		} else {
			_tmp96_ = FALSE;
		}
		if (_tmp96_) {
			ValaParameterDirection _tmp103_;
			_tmp103_ = self->priv->_direction;
			_tmp95_ = _tmp103_ != VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp95_ = FALSE;
		}
		if (_tmp95_) {
			ValaSourceReference* _tmp104_;
			ValaSourceReference* _tmp105_;
			ValaDataType* _tmp106_;
			ValaDataType* _tmp107_;
			gchar* _tmp108_;
			gchar* _tmp109_;
			_tmp104_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp105_ = _tmp104_;
			_tmp106_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp107_ = _tmp106_;
			_tmp108_ = vala_code_node_to_string ((ValaCodeNode*) _tmp107_);
			_tmp109_ = _tmp108_;
			vala_report_warning (_tmp105_, "`null' incompatible with parameter type `%s'", _tmp109_);
			_g_free0 (_tmp109_);
		} else {
			gboolean _tmp110_ = FALSE;
			ValaExpression* _tmp111_;
			ValaExpression* _tmp112_;
			_tmp111_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp112_ = _tmp111_;
			if (!VALA_IS_NULL_LITERAL (_tmp112_)) {
				ValaParameterDirection _tmp113_;
				_tmp113_ = self->priv->_direction;
				_tmp110_ = _tmp113_ == VALA_PARAMETER_DIRECTION_OUT;
			} else {
				_tmp110_ = FALSE;
			}
			if (_tmp110_) {
				ValaSourceReference* _tmp114_;
				ValaSourceReference* _tmp115_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp114_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp115_ = _tmp114_;
				vala_report_error (_tmp115_, "only `null' is allowed as default value for out parameters");
			} else {
				gboolean _tmp116_ = FALSE;
				ValaParameterDirection _tmp117_;
				_tmp117_ = self->priv->_direction;
				if (_tmp117_ == VALA_PARAMETER_DIRECTION_IN) {
					ValaExpression* _tmp118_;
					ValaExpression* _tmp119_;
					ValaDataType* _tmp120_;
					ValaDataType* _tmp121_;
					ValaDataType* _tmp122_;
					ValaDataType* _tmp123_;
					_tmp118_ = vala_variable_get_initializer ((ValaVariable*) self);
					_tmp119_ = _tmp118_;
					_tmp120_ = vala_expression_get_value_type (_tmp119_);
					_tmp121_ = _tmp120_;
					_tmp122_ = vala_variable_get_variable_type ((ValaVariable*) self);
					_tmp123_ = _tmp122_;
					_tmp116_ = !vala_data_type_compatible (_tmp121_, _tmp123_);
				} else {
					_tmp116_ = FALSE;
				}
				if (_tmp116_) {
					ValaExpression* _tmp124_;
					ValaExpression* _tmp125_;
					ValaSourceReference* _tmp126_;
					ValaSourceReference* _tmp127_;
					ValaExpression* _tmp128_;
					ValaExpression* _tmp129_;
					ValaDataType* _tmp130_;
					ValaDataType* _tmp131_;
					gchar* _tmp132_;
					gchar* _tmp133_;
					ValaDataType* _tmp134_;
					ValaDataType* _tmp135_;
					gchar* _tmp136_;
					gchar* _tmp137_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp124_ = vala_variable_get_initializer ((ValaVariable*) self);
					_tmp125_ = _tmp124_;
					_tmp126_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp125_);
					_tmp127_ = _tmp126_;
					_tmp128_ = vala_variable_get_initializer ((ValaVariable*) self);
					_tmp129_ = _tmp128_;
					_tmp130_ = vala_expression_get_value_type (_tmp129_);
					_tmp131_ = _tmp130_;
					_tmp132_ = vala_code_node_to_string ((ValaCodeNode*) _tmp131_);
					_tmp133_ = _tmp132_;
					_tmp134_ = vala_variable_get_variable_type ((ValaVariable*) self);
					_tmp135_ = _tmp134_;
					_tmp136_ = vala_code_node_to_string ((ValaCodeNode*) _tmp135_);
					_tmp137_ = _tmp136_;
					vala_report_error (_tmp127_, "Cannot convert from `%s' to `%s'", _tmp133_, _tmp137_);
					_g_free0 (_tmp137_);
					_g_free0 (_tmp133_);
				} else {
					ValaParameterDirection _tmp138_;
					_tmp138_ = self->priv->_direction;
					if (_tmp138_ == VALA_PARAMETER_DIRECTION_REF) {
						ValaSourceReference* _tmp139_;
						ValaSourceReference* _tmp140_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp139_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp140_ = _tmp139_;
						vala_report_error (_tmp140_, "default value not allowed for ref parameter");
					} else {
						ValaExpression* _tmp141_;
						ValaExpression* _tmp142_;
						_tmp141_ = vala_variable_get_initializer ((ValaVariable*) self);
						_tmp142_ = _tmp141_;
						if (!vala_expression_is_accessible (_tmp142_, (ValaSymbol*) self)) {
							ValaExpression* _tmp143_;
							ValaExpression* _tmp144_;
							ValaSourceReference* _tmp145_;
							ValaSourceReference* _tmp146_;
							ValaSymbol* _tmp147_;
							ValaSymbol* _tmp148_;
							gchar* _tmp149_;
							gchar* _tmp150_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp143_ = vala_variable_get_initializer ((ValaVariable*) self);
							_tmp144_ = _tmp143_;
							_tmp145_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp144_);
							_tmp146_ = _tmp145_;
							_tmp147_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
							_tmp148_ = _tmp147_;
							_tmp149_ = vala_symbol_get_full_name (_tmp148_);
							_tmp150_ = _tmp149_;
							vala_report_error (_tmp146_, "default value is less accessible than method `%s'", _tmp150_);
							_g_free0 (_tmp150_);
						}
					}
				}
			}
		}
	}
	_tmp151_ = self->priv->_ellipsis;
	if (!_tmp151_) {
		gboolean _tmp152_;
		gboolean _tmp153_;
		ValaSemanticAnalyzer* _tmp178_;
		ValaSemanticAnalyzer* _tmp179_;
		ValaDataType* _tmp180_;
		ValaDataType* _tmp181_;
		_tmp152_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp153_ = _tmp152_;
		if (!_tmp153_) {
			ValaSemanticAnalyzer* _tmp154_;
			ValaSemanticAnalyzer* _tmp155_;
			ValaDataType* _tmp156_;
			ValaDataType* _tmp157_;
			gboolean _tmp158_ = FALSE;
			gboolean _tmp159_ = FALSE;
			ValaSymbol* _tmp160_;
			ValaSymbol* _tmp161_;
			_tmp154_ = vala_code_context_get_analyzer (context);
			_tmp155_ = _tmp154_;
			_tmp156_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp157_ = _tmp156_;
			vala_semantic_analyzer_check_type (_tmp155_, _tmp157_);
			_tmp160_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp161_ = _tmp160_;
			if (_tmp161_ == NULL) {
				_tmp159_ = TRUE;
			} else {
				ValaSymbol* _tmp162_;
				ValaSymbol* _tmp163_;
				gboolean _tmp164_;
				gboolean _tmp165_;
				_tmp162_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp163_ = _tmp162_;
				_tmp164_ = vala_symbol_get_external_package (_tmp163_);
				_tmp165_ = _tmp164_;
				_tmp159_ = !_tmp165_;
			}
			if (_tmp159_) {
				ValaDataType* _tmp166_;
				ValaDataType* _tmp167_;
				ValaTypeSymbol* _tmp168_;
				ValaTypeSymbol* _tmp169_;
				_tmp166_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp167_ = _tmp166_;
				_tmp168_ = vala_data_type_get_type_symbol (_tmp167_);
				_tmp169_ = _tmp168_;
				_tmp158_ = _tmp169_ != NULL;
			} else {
				_tmp158_ = FALSE;
			}
			if (_tmp158_) {
				ValaDataType* _tmp170_;
				ValaDataType* _tmp171_;
				ValaTypeSymbol* _tmp172_;
				ValaTypeSymbol* _tmp173_;
				ValaVersionAttribute* _tmp174_;
				ValaVersionAttribute* _tmp175_;
				ValaSourceReference* _tmp176_;
				ValaSourceReference* _tmp177_;
				_tmp170_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_data_type_get_type_symbol (_tmp171_);
				_tmp173_ = _tmp172_;
				_tmp174_ = vala_symbol_get_version ((ValaSymbol*) _tmp173_);
				_tmp175_ = _tmp174_;
				_tmp176_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp177_ = _tmp176_;
				vala_version_attribute_check (_tmp175_, context, _tmp177_);
			}
		}
		_tmp178_ = vala_code_context_get_analyzer (context);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp181_ = _tmp180_;
		if (!vala_semantic_analyzer_is_type_accessible (_tmp179_, (ValaSymbol*) self, _tmp181_)) {
			ValaSourceReference* _tmp182_;
			ValaSourceReference* _tmp183_;
			ValaDataType* _tmp184_;
			ValaDataType* _tmp185_;
			gchar* _tmp186_;
			gchar* _tmp187_;
			ValaSymbol* _tmp188_;
			ValaSymbol* _tmp189_;
			gchar* _tmp190_;
			gchar* _tmp191_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp182_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp183_ = _tmp182_;
			_tmp184_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp185_ = _tmp184_;
			_tmp186_ = vala_code_node_to_string ((ValaCodeNode*) _tmp185_);
			_tmp187_ = _tmp186_;
			_tmp188_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp189_ = _tmp188_;
			_tmp190_ = vala_symbol_get_full_name (_tmp189_);
			_tmp191_ = _tmp190_;
			vala_report_error (_tmp183_, "parameter type `%s' is less accessible than method `%s'", _tmp187_, _tmp191_);
			_g_free0 (_tmp191_);
			_g_free0 (_tmp187_);
		}
	}
	_tmp192_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp193_ = _tmp192_;
	m = VALA_IS_METHOD (_tmp193_) ? ((ValaMethod*) _tmp193_) : NULL;
	_tmp194_ = m;
	if (_tmp194_ != NULL) {
		ValaMethod* base_method = NULL;
		gboolean _tmp195_ = FALSE;
		ValaMethod* _tmp196_;
		ValaMethod* _tmp197_;
		ValaMethod* _tmp198_;
		ValaMethod* _tmp217_;
		base_method = NULL;
		_tmp196_ = m;
		_tmp197_ = vala_method_get_base_method (_tmp196_);
		_tmp198_ = _tmp197_;
		if (_tmp198_ != NULL) {
			ValaMethod* _tmp199_;
			ValaMethod* _tmp200_;
			ValaMethod* _tmp201_;
			ValaMethod* _tmp202_;
			_tmp199_ = m;
			_tmp200_ = vala_method_get_base_method (_tmp199_);
			_tmp201_ = _tmp200_;
			_tmp202_ = m;
			_tmp195_ = _tmp201_ != _tmp202_;
		} else {
			_tmp195_ = FALSE;
		}
		if (_tmp195_) {
			ValaMethod* _tmp203_;
			ValaMethod* _tmp204_;
			ValaMethod* _tmp205_;
			_tmp203_ = m;
			_tmp204_ = vala_method_get_base_method (_tmp203_);
			_tmp205_ = _tmp204_;
			base_method = _tmp205_;
		} else {
			gboolean _tmp206_ = FALSE;
			ValaMethod* _tmp207_;
			ValaMethod* _tmp208_;
			ValaMethod* _tmp209_;
			_tmp207_ = m;
			_tmp208_ = vala_method_get_base_interface_method (_tmp207_);
			_tmp209_ = _tmp208_;
			if (_tmp209_ != NULL) {
				ValaMethod* _tmp210_;
				ValaMethod* _tmp211_;
				ValaMethod* _tmp212_;
				ValaMethod* _tmp213_;
				_tmp210_ = m;
				_tmp211_ = vala_method_get_base_interface_method (_tmp210_);
				_tmp212_ = _tmp211_;
				_tmp213_ = m;
				_tmp206_ = _tmp212_ != _tmp213_;
			} else {
				_tmp206_ = FALSE;
			}
			if (_tmp206_) {
				ValaMethod* _tmp214_;
				ValaMethod* _tmp215_;
				ValaMethod* _tmp216_;
				_tmp214_ = m;
				_tmp215_ = vala_method_get_base_interface_method (_tmp214_);
				_tmp216_ = _tmp215_;
				base_method = _tmp216_;
			}
		}
		_tmp217_ = base_method;
		if (_tmp217_ != NULL) {
			gint index = 0;
			ValaMethod* _tmp218_;
			ValaList* _tmp219_;
			_tmp218_ = m;
			_tmp219_ = vala_callable_get_parameters ((ValaCallable*) _tmp218_);
			index = vala_list_index_of (_tmp219_, self);
			if (index >= 0) {
				ValaMethod* _tmp220_;
				ValaList* _tmp221_;
				gpointer _tmp222_;
				ValaParameter* _tmp223_;
				_tmp220_ = base_method;
				_tmp221_ = vala_callable_get_parameters ((ValaCallable*) _tmp220_);
				_tmp222_ = vala_list_get (_tmp221_, index);
				_tmp223_ = (ValaParameter*) _tmp222_;
				vala_parameter_set_base_parameter (self, _tmp223_);
				_vala_code_node_unref0 (_tmp223_);
			}
		}
	}
	_tmp224_ = vala_code_context_get_analyzer (context);
	_tmp225_ = _tmp224_;
	_tmp226_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp225_, _tmp226_);
	_tmp227_ = vala_code_context_get_analyzer (context);
	_tmp228_ = _tmp227_;
	_tmp229_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp228_, _tmp229_);
	_tmp230_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp231_ = _tmp230_;
	result = !_tmp231_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_parameter_class_init (ValaParameterClass * klass,
                           gpointer klass_data)
{
	vala_parameter_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_parameter_finalize;
	g_type_class_adjust_private_offset (klass, &ValaParameter_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_parameter_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_parameter_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_parameter_real_replace_type;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_parameter_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_parameter_real_check;
}

static void
vala_parameter_instance_init (ValaParameter * self,
                              gpointer klass)
{
	self->priv = vala_parameter_get_instance_private (self);
	self->priv->_direction = VALA_PARAMETER_DIRECTION_IN;
}

static void
vala_parameter_finalize (ValaCodeNode * obj)
{
	ValaParameter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_PARAMETER, ValaParameter);
	_vala_code_node_unref0 (self->priv->_base_parameter);
	VALA_CODE_NODE_CLASS (vala_parameter_parent_class)->finalize (obj);
}

/**
 * Represents a formal parameter in method and callback signatures.
 */
static GType
vala_parameter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_parameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaParameter), 0, (GInstanceInitFunc) vala_parameter_instance_init, NULL };
	GType vala_parameter_type_id;
	vala_parameter_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaParameter", &g_define_type_info, 0);
	ValaParameter_private_offset = g_type_add_instance_private (vala_parameter_type_id, sizeof (ValaParameterPrivate));
	return vala_parameter_type_id;
}

GType
vala_parameter_get_type (void)
{
	static volatile gsize vala_parameter_type_id__volatile = 0;
	if (g_once_init_enter (&vala_parameter_type_id__volatile)) {
		GType vala_parameter_type_id;
		vala_parameter_type_id = vala_parameter_get_type_once ();
		g_once_init_leave (&vala_parameter_type_id__volatile, vala_parameter_type_id);
	}
	return vala_parameter_type_id__volatile;
}

static GType
vala_parameter_direction_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_PARAMETER_DIRECTION_IN, "VALA_PARAMETER_DIRECTION_IN", "in"}, {VALA_PARAMETER_DIRECTION_OUT, "VALA_PARAMETER_DIRECTION_OUT", "out"}, {VALA_PARAMETER_DIRECTION_REF, "VALA_PARAMETER_DIRECTION_REF", "ref"}, {0, NULL, NULL}};
	GType vala_parameter_direction_type_id;
	vala_parameter_direction_type_id = g_enum_register_static ("ValaParameterDirection", values);
	return vala_parameter_direction_type_id;
}

GType
vala_parameter_direction_get_type (void)
{
	static volatile gsize vala_parameter_direction_type_id__volatile = 0;
	if (g_once_init_enter (&vala_parameter_direction_type_id__volatile)) {
		GType vala_parameter_direction_type_id;
		vala_parameter_direction_type_id = vala_parameter_direction_get_type_once ();
		g_once_init_leave (&vala_parameter_direction_type_id__volatile, vala_parameter_direction_type_id);
	}
	return vala_parameter_direction_type_id__volatile;
}

