/* autogenerated file */

static st_table *rsock_intern_family_hash;
static st_table *rsock_intern_family_noprefix_hash;
static st_table *rsock_intern_protocol_family_hash;
static st_table *rsock_intern_socktype_hash;
static st_table *rsock_intern_ipproto_hash;
static st_table *rsock_intern_iplevel_hash;
static st_table *rsock_intern_so_optname_hash;
static st_table *rsock_intern_ip_optname_hash;
static st_table *rsock_intern_ipv6_optname_hash;
static st_table *rsock_intern_tcp_optname_hash;
static st_table *rsock_intern_udp_optname_hash;
static st_table *rsock_intern_scm_optname_hash;
static st_table *rsock_intern_local_optname_hash;

#ifdef HAVE_LONG_LONG
#define INTEGER2NUM(n) \
    (FIXNUM_MAX < (n) ? ULL2NUM(n) : \
     FIXNUM_MIN > (LONG_LONG)(n) ? LL2NUM(n) : \
     LONG2FIX(n))
#else
#define INTEGER2NUM(n) \
    (FIXNUM_MAX < (n) ? ULONG2NUM(n) : \
     FIXNUM_MIN > (long)(n) ? LONG2NUM(n) : \
     LONG2FIX(n))
#endif

static void
init_constants(void)
{
    /*
     * Document-module: Socket::Constants
     *
     * Socket::Constants provides socket-related constants.  All possible
     * socket constants are listed in the documentation but they may not all
     * be present on your platform.
     *
     * If the underlying platform doesn't define a constant the corresponding
     * Ruby constant is not defined.
     *
     */
    rb_mSockConst = rb_define_module_under(rb_cSocket, "Constants");

#if defined(SOCK_STREAM)
    /* A stream socket provides a sequenced, reliable two-way connection for a byte stream */
    rb_define_const(rb_cSocket, "SOCK_STREAM", INTEGER2NUM(SOCK_STREAM));
    /* A stream socket provides a sequenced, reliable two-way connection for a byte stream */
    rb_define_const(rb_mSockConst, "SOCK_STREAM", INTEGER2NUM(SOCK_STREAM));
#endif
#if defined(SOCK_DGRAM)
    /* A datagram socket provides connectionless, unreliable messaging */
    rb_define_const(rb_cSocket, "SOCK_DGRAM", INTEGER2NUM(SOCK_DGRAM));
    /* A datagram socket provides connectionless, unreliable messaging */
    rb_define_const(rb_mSockConst, "SOCK_DGRAM", INTEGER2NUM(SOCK_DGRAM));
#endif
#if defined(SOCK_RAW)
    /* A raw socket provides low-level access for direct access or implementing network protocols */
    rb_define_const(rb_cSocket, "SOCK_RAW", INTEGER2NUM(SOCK_RAW));
    /* A raw socket provides low-level access for direct access or implementing network protocols */
    rb_define_const(rb_mSockConst, "SOCK_RAW", INTEGER2NUM(SOCK_RAW));
#endif
#if defined(SOCK_RDM)
    /* A reliable datagram socket provides reliable delivery of messages */
    rb_define_const(rb_cSocket, "SOCK_RDM", INTEGER2NUM(SOCK_RDM));
    /* A reliable datagram socket provides reliable delivery of messages */
    rb_define_const(rb_mSockConst, "SOCK_RDM", INTEGER2NUM(SOCK_RDM));
#endif
#if defined(SOCK_SEQPACKET)
    /* A sequential packet socket provides sequenced, reliable two-way connection for datagrams */
    rb_define_const(rb_cSocket, "SOCK_SEQPACKET", INTEGER2NUM(SOCK_SEQPACKET));
    /* A sequential packet socket provides sequenced, reliable two-way connection for datagrams */
    rb_define_const(rb_mSockConst, "SOCK_SEQPACKET", INTEGER2NUM(SOCK_SEQPACKET));
#endif
#if defined(SOCK_PACKET)
    /* Device-level packet access */
    rb_define_const(rb_cSocket, "SOCK_PACKET", INTEGER2NUM(SOCK_PACKET));
    /* Device-level packet access */
    rb_define_const(rb_mSockConst, "SOCK_PACKET", INTEGER2NUM(SOCK_PACKET));
#endif
#if defined(AF_UNSPEC)
    /* Unspecified protocol, any supported address family */
    rb_define_const(rb_cSocket, "AF_UNSPEC", INTEGER2NUM(AF_UNSPEC));
    /* Unspecified protocol, any supported address family */
    rb_define_const(rb_mSockConst, "AF_UNSPEC", INTEGER2NUM(AF_UNSPEC));
#endif
#if defined(PF_UNSPEC)
    /* Unspecified protocol, any supported address family */
    rb_define_const(rb_cSocket, "PF_UNSPEC", INTEGER2NUM(PF_UNSPEC));
    /* Unspecified protocol, any supported address family */
    rb_define_const(rb_mSockConst, "PF_UNSPEC", INTEGER2NUM(PF_UNSPEC));
#endif
#if defined(AF_INET)
    /* IPv4 protocol */
    rb_define_const(rb_cSocket, "AF_INET", INTEGER2NUM(AF_INET));
    /* IPv4 protocol */
    rb_define_const(rb_mSockConst, "AF_INET", INTEGER2NUM(AF_INET));
#endif
#if defined(PF_INET)
    /* IPv4 protocol */
    rb_define_const(rb_cSocket, "PF_INET", INTEGER2NUM(PF_INET));
    /* IPv4 protocol */
    rb_define_const(rb_mSockConst, "PF_INET", INTEGER2NUM(PF_INET));
#endif
#if defined(INET6)
#if defined(AF_INET6)
    /* IPv6 protocol */
    rb_define_const(rb_cSocket, "AF_INET6", INTEGER2NUM(AF_INET6));
    /* IPv6 protocol */
    rb_define_const(rb_mSockConst, "AF_INET6", INTEGER2NUM(AF_INET6));
#endif
#endif
#if defined(INET6)
#if defined(PF_INET6)
    /* IPv6 protocol */
    rb_define_const(rb_cSocket, "PF_INET6", INTEGER2NUM(PF_INET6));
    /* IPv6 protocol */
    rb_define_const(rb_mSockConst, "PF_INET6", INTEGER2NUM(PF_INET6));
#endif
#endif
#if defined(AF_UNIX)
    /* UNIX sockets */
    rb_define_const(rb_cSocket, "AF_UNIX", INTEGER2NUM(AF_UNIX));
    /* UNIX sockets */
    rb_define_const(rb_mSockConst, "AF_UNIX", INTEGER2NUM(AF_UNIX));
#endif
#if defined(PF_UNIX)
    /* UNIX sockets */
    rb_define_const(rb_cSocket, "PF_UNIX", INTEGER2NUM(PF_UNIX));
    /* UNIX sockets */
    rb_define_const(rb_mSockConst, "PF_UNIX", INTEGER2NUM(PF_UNIX));
#endif
#if defined(AF_AX25)
    /* AX.25 protocol */
    rb_define_const(rb_cSocket, "AF_AX25", INTEGER2NUM(AF_AX25));
    /* AX.25 protocol */
    rb_define_const(rb_mSockConst, "AF_AX25", INTEGER2NUM(AF_AX25));
#endif
#if defined(PF_AX25)
    /* AX.25 protocol */
    rb_define_const(rb_cSocket, "PF_AX25", INTEGER2NUM(PF_AX25));
    /* AX.25 protocol */
    rb_define_const(rb_mSockConst, "PF_AX25", INTEGER2NUM(PF_AX25));
#endif
#if defined(AF_IPX)
    /* IPX protocol */
    rb_define_const(rb_cSocket, "AF_IPX", INTEGER2NUM(AF_IPX));
    /* IPX protocol */
    rb_define_const(rb_mSockConst, "AF_IPX", INTEGER2NUM(AF_IPX));
#endif
#if defined(PF_IPX)
    /* IPX protocol */
    rb_define_const(rb_cSocket, "PF_IPX", INTEGER2NUM(PF_IPX));
    /* IPX protocol */
    rb_define_const(rb_mSockConst, "PF_IPX", INTEGER2NUM(PF_IPX));
#endif
#if defined(AF_APPLETALK)
    /* AppleTalk protocol */
    rb_define_const(rb_cSocket, "AF_APPLETALK", INTEGER2NUM(AF_APPLETALK));
    /* AppleTalk protocol */
    rb_define_const(rb_mSockConst, "AF_APPLETALK", INTEGER2NUM(AF_APPLETALK));
#endif
#if defined(PF_APPLETALK)
    /* AppleTalk protocol */
    rb_define_const(rb_cSocket, "PF_APPLETALK", INTEGER2NUM(PF_APPLETALK));
    /* AppleTalk protocol */
    rb_define_const(rb_mSockConst, "PF_APPLETALK", INTEGER2NUM(PF_APPLETALK));
#endif
#if defined(AF_LOCAL)
    /* Host-internal protocols */
    rb_define_const(rb_cSocket, "AF_LOCAL", INTEGER2NUM(AF_LOCAL));
    /* Host-internal protocols */
    rb_define_const(rb_mSockConst, "AF_LOCAL", INTEGER2NUM(AF_LOCAL));
#endif
#if defined(PF_LOCAL)
    /* Host-internal protocols */
    rb_define_const(rb_cSocket, "PF_LOCAL", INTEGER2NUM(PF_LOCAL));
    /* Host-internal protocols */
    rb_define_const(rb_mSockConst, "PF_LOCAL", INTEGER2NUM(PF_LOCAL));
#endif
#if defined(AF_IMPLINK)
    /* ARPANET IMP protocol */
    rb_define_const(rb_cSocket, "AF_IMPLINK", INTEGER2NUM(AF_IMPLINK));
    /* ARPANET IMP protocol */
    rb_define_const(rb_mSockConst, "AF_IMPLINK", INTEGER2NUM(AF_IMPLINK));
#endif
#if defined(PF_IMPLINK)
    /* ARPANET IMP protocol */
    rb_define_const(rb_cSocket, "PF_IMPLINK", INTEGER2NUM(PF_IMPLINK));
    /* ARPANET IMP protocol */
    rb_define_const(rb_mSockConst, "PF_IMPLINK", INTEGER2NUM(PF_IMPLINK));
#endif
#if defined(AF_PUP)
    /* PARC Universal Packet protocol */
    rb_define_const(rb_cSocket, "AF_PUP", INTEGER2NUM(AF_PUP));
    /* PARC Universal Packet protocol */
    rb_define_const(rb_mSockConst, "AF_PUP", INTEGER2NUM(AF_PUP));
#endif
#if defined(PF_PUP)
    /* PARC Universal Packet protocol */
    rb_define_const(rb_cSocket, "PF_PUP", INTEGER2NUM(PF_PUP));
    /* PARC Universal Packet protocol */
    rb_define_const(rb_mSockConst, "PF_PUP", INTEGER2NUM(PF_PUP));
#endif
#if defined(AF_CHAOS)
    /* MIT CHAOS protocols */
    rb_define_const(rb_cSocket, "AF_CHAOS", INTEGER2NUM(AF_CHAOS));
    /* MIT CHAOS protocols */
    rb_define_const(rb_mSockConst, "AF_CHAOS", INTEGER2NUM(AF_CHAOS));
#endif
#if defined(PF_CHAOS)
    /* MIT CHAOS protocols */
    rb_define_const(rb_cSocket, "PF_CHAOS", INTEGER2NUM(PF_CHAOS));
    /* MIT CHAOS protocols */
    rb_define_const(rb_mSockConst, "PF_CHAOS", INTEGER2NUM(PF_CHAOS));
#endif
#if defined(AF_NS)
    /* XEROX NS protocols */
    rb_define_const(rb_cSocket, "AF_NS", INTEGER2NUM(AF_NS));
    /* XEROX NS protocols */
    rb_define_const(rb_mSockConst, "AF_NS", INTEGER2NUM(AF_NS));
#endif
#if defined(PF_NS)
    /* XEROX NS protocols */
    rb_define_const(rb_cSocket, "PF_NS", INTEGER2NUM(PF_NS));
    /* XEROX NS protocols */
    rb_define_const(rb_mSockConst, "PF_NS", INTEGER2NUM(PF_NS));
#endif
#if defined(AF_ISO)
    /* ISO Open Systems Interconnection protocols */
    rb_define_const(rb_cSocket, "AF_ISO", INTEGER2NUM(AF_ISO));
    /* ISO Open Systems Interconnection protocols */
    rb_define_const(rb_mSockConst, "AF_ISO", INTEGER2NUM(AF_ISO));
#endif
#if defined(PF_ISO)
    /* ISO Open Systems Interconnection protocols */
    rb_define_const(rb_cSocket, "PF_ISO", INTEGER2NUM(PF_ISO));
    /* ISO Open Systems Interconnection protocols */
    rb_define_const(rb_mSockConst, "PF_ISO", INTEGER2NUM(PF_ISO));
#endif
#if defined(AF_OSI)
    /* ISO Open Systems Interconnection protocols */
    rb_define_const(rb_cSocket, "AF_OSI", INTEGER2NUM(AF_OSI));
    /* ISO Open Systems Interconnection protocols */
    rb_define_const(rb_mSockConst, "AF_OSI", INTEGER2NUM(AF_OSI));
#endif
#if defined(PF_OSI)
    /* ISO Open Systems Interconnection protocols */
    rb_define_const(rb_cSocket, "PF_OSI", INTEGER2NUM(PF_OSI));
    /* ISO Open Systems Interconnection protocols */
    rb_define_const(rb_mSockConst, "PF_OSI", INTEGER2NUM(PF_OSI));
#endif
#if defined(AF_ECMA)
    /* European Computer Manufacturers protocols */
    rb_define_const(rb_cSocket, "AF_ECMA", INTEGER2NUM(AF_ECMA));
    /* European Computer Manufacturers protocols */
    rb_define_const(rb_mSockConst, "AF_ECMA", INTEGER2NUM(AF_ECMA));
#endif
#if defined(PF_ECMA)
    /* European Computer Manufacturers protocols */
    rb_define_const(rb_cSocket, "PF_ECMA", INTEGER2NUM(PF_ECMA));
    /* European Computer Manufacturers protocols */
    rb_define_const(rb_mSockConst, "PF_ECMA", INTEGER2NUM(PF_ECMA));
#endif
#if defined(AF_DATAKIT)
    /* Datakit protocol */
    rb_define_const(rb_cSocket, "AF_DATAKIT", INTEGER2NUM(AF_DATAKIT));
    /* Datakit protocol */
    rb_define_const(rb_mSockConst, "AF_DATAKIT", INTEGER2NUM(AF_DATAKIT));
#endif
#if defined(PF_DATAKIT)
    /* Datakit protocol */
    rb_define_const(rb_cSocket, "PF_DATAKIT", INTEGER2NUM(PF_DATAKIT));
    /* Datakit protocol */
    rb_define_const(rb_mSockConst, "PF_DATAKIT", INTEGER2NUM(PF_DATAKIT));
#endif
#if defined(AF_CCITT)
    /* CCITT (now ITU-T) protocols */
    rb_define_const(rb_cSocket, "AF_CCITT", INTEGER2NUM(AF_CCITT));
    /* CCITT (now ITU-T) protocols */
    rb_define_const(rb_mSockConst, "AF_CCITT", INTEGER2NUM(AF_CCITT));
#endif
#if defined(PF_CCITT)
    /* CCITT (now ITU-T) protocols */
    rb_define_const(rb_cSocket, "PF_CCITT", INTEGER2NUM(PF_CCITT));
    /* CCITT (now ITU-T) protocols */
    rb_define_const(rb_mSockConst, "PF_CCITT", INTEGER2NUM(PF_CCITT));
#endif
#if defined(AF_SNA)
    /* IBM SNA protocol */
    rb_define_const(rb_cSocket, "AF_SNA", INTEGER2NUM(AF_SNA));
    /* IBM SNA protocol */
    rb_define_const(rb_mSockConst, "AF_SNA", INTEGER2NUM(AF_SNA));
#endif
#if defined(PF_SNA)
    /* IBM SNA protocol */
    rb_define_const(rb_cSocket, "PF_SNA", INTEGER2NUM(PF_SNA));
    /* IBM SNA protocol */
    rb_define_const(rb_mSockConst, "PF_SNA", INTEGER2NUM(PF_SNA));
#endif
#if defined(AF_DEC)
    /* DECnet protocol */
    rb_define_const(rb_cSocket, "AF_DEC", INTEGER2NUM(AF_DEC));
    /* DECnet protocol */
    rb_define_const(rb_mSockConst, "AF_DEC", INTEGER2NUM(AF_DEC));
#endif
#if defined(PF_DEC)
    /* DECnet protocol */
    rb_define_const(rb_cSocket, "PF_DEC", INTEGER2NUM(PF_DEC));
    /* DECnet protocol */
    rb_define_const(rb_mSockConst, "PF_DEC", INTEGER2NUM(PF_DEC));
#endif
#if defined(AF_DLI)
    /* DEC Direct Data Link Interface protocol */
    rb_define_const(rb_cSocket, "AF_DLI", INTEGER2NUM(AF_DLI));
    /* DEC Direct Data Link Interface protocol */
    rb_define_const(rb_mSockConst, "AF_DLI", INTEGER2NUM(AF_DLI));
#endif
#if defined(PF_DLI)
    /* DEC Direct Data Link Interface protocol */
    rb_define_const(rb_cSocket, "PF_DLI", INTEGER2NUM(PF_DLI));
    /* DEC Direct Data Link Interface protocol */
    rb_define_const(rb_mSockConst, "PF_DLI", INTEGER2NUM(PF_DLI));
#endif
#if defined(AF_LAT)
    /* Local Area Transport protocol */
    rb_define_const(rb_cSocket, "AF_LAT", INTEGER2NUM(AF_LAT));
    /* Local Area Transport protocol */
    rb_define_const(rb_mSockConst, "AF_LAT", INTEGER2NUM(AF_LAT));
#endif
#if defined(PF_LAT)
    /* Local Area Transport protocol */
    rb_define_const(rb_cSocket, "PF_LAT", INTEGER2NUM(PF_LAT));
    /* Local Area Transport protocol */
    rb_define_const(rb_mSockConst, "PF_LAT", INTEGER2NUM(PF_LAT));
#endif
#if defined(AF_HYLINK)
    /* NSC Hyperchannel protocol */
    rb_define_const(rb_cSocket, "AF_HYLINK", INTEGER2NUM(AF_HYLINK));
    /* NSC Hyperchannel protocol */
    rb_define_const(rb_mSockConst, "AF_HYLINK", INTEGER2NUM(AF_HYLINK));
#endif
#if defined(PF_HYLINK)
    /* NSC Hyperchannel protocol */
    rb_define_const(rb_cSocket, "PF_HYLINK", INTEGER2NUM(PF_HYLINK));
    /* NSC Hyperchannel protocol */
    rb_define_const(rb_mSockConst, "PF_HYLINK", INTEGER2NUM(PF_HYLINK));
#endif
#if defined(AF_ROUTE)
    /* Internal routing protocol */
    rb_define_const(rb_cSocket, "AF_ROUTE", INTEGER2NUM(AF_ROUTE));
    /* Internal routing protocol */
    rb_define_const(rb_mSockConst, "AF_ROUTE", INTEGER2NUM(AF_ROUTE));
#endif
#if defined(PF_ROUTE)
    /* Internal routing protocol */
    rb_define_const(rb_cSocket, "PF_ROUTE", INTEGER2NUM(PF_ROUTE));
    /* Internal routing protocol */
    rb_define_const(rb_mSockConst, "PF_ROUTE", INTEGER2NUM(PF_ROUTE));
#endif
#if defined(AF_LINK)
    /* Link layer interface */
    rb_define_const(rb_cSocket, "AF_LINK", INTEGER2NUM(AF_LINK));
    /* Link layer interface */
    rb_define_const(rb_mSockConst, "AF_LINK", INTEGER2NUM(AF_LINK));
#endif
#if defined(PF_LINK)
    /* Link layer interface */
    rb_define_const(rb_cSocket, "PF_LINK", INTEGER2NUM(PF_LINK));
    /* Link layer interface */
    rb_define_const(rb_mSockConst, "PF_LINK", INTEGER2NUM(PF_LINK));
#endif
#if defined(AF_COIP)
    /* Connection-oriented IP */
    rb_define_const(rb_cSocket, "AF_COIP", INTEGER2NUM(AF_COIP));
    /* Connection-oriented IP */
    rb_define_const(rb_mSockConst, "AF_COIP", INTEGER2NUM(AF_COIP));
#endif
#if defined(PF_COIP)
    /* Connection-oriented IP */
    rb_define_const(rb_cSocket, "PF_COIP", INTEGER2NUM(PF_COIP));
    /* Connection-oriented IP */
    rb_define_const(rb_mSockConst, "PF_COIP", INTEGER2NUM(PF_COIP));
#endif
#if defined(AF_CNT)
    /* Computer Network Technology */
    rb_define_const(rb_cSocket, "AF_CNT", INTEGER2NUM(AF_CNT));
    /* Computer Network Technology */
    rb_define_const(rb_mSockConst, "AF_CNT", INTEGER2NUM(AF_CNT));
#endif
#if defined(PF_CNT)
    /* Computer Network Technology */
    rb_define_const(rb_cSocket, "PF_CNT", INTEGER2NUM(PF_CNT));
    /* Computer Network Technology */
    rb_define_const(rb_mSockConst, "PF_CNT", INTEGER2NUM(PF_CNT));
#endif
#if defined(AF_SIP)
    /* Simple Internet Protocol */
    rb_define_const(rb_cSocket, "AF_SIP", INTEGER2NUM(AF_SIP));
    /* Simple Internet Protocol */
    rb_define_const(rb_mSockConst, "AF_SIP", INTEGER2NUM(AF_SIP));
#endif
#if defined(PF_SIP)
    /* Simple Internet Protocol */
    rb_define_const(rb_cSocket, "PF_SIP", INTEGER2NUM(PF_SIP));
    /* Simple Internet Protocol */
    rb_define_const(rb_mSockConst, "PF_SIP", INTEGER2NUM(PF_SIP));
#endif
#if defined(AF_NDRV)
    /* Network driver raw access */
    rb_define_const(rb_cSocket, "AF_NDRV", INTEGER2NUM(AF_NDRV));
    /* Network driver raw access */
    rb_define_const(rb_mSockConst, "AF_NDRV", INTEGER2NUM(AF_NDRV));
#endif
#if defined(PF_NDRV)
    /* Network driver raw access */
    rb_define_const(rb_cSocket, "PF_NDRV", INTEGER2NUM(PF_NDRV));
    /* Network driver raw access */
    rb_define_const(rb_mSockConst, "PF_NDRV", INTEGER2NUM(PF_NDRV));
#endif
#if defined(AF_ISDN)
    /* Integrated Services Digital Network */
    rb_define_const(rb_cSocket, "AF_ISDN", INTEGER2NUM(AF_ISDN));
    /* Integrated Services Digital Network */
    rb_define_const(rb_mSockConst, "AF_ISDN", INTEGER2NUM(AF_ISDN));
#endif
#if defined(PF_ISDN)
    /* Integrated Services Digital Network */
    rb_define_const(rb_cSocket, "PF_ISDN", INTEGER2NUM(PF_ISDN));
    /* Integrated Services Digital Network */
    rb_define_const(rb_mSockConst, "PF_ISDN", INTEGER2NUM(PF_ISDN));
#endif
#if defined(AF_NATM)
    /* Native ATM access */
    rb_define_const(rb_cSocket, "AF_NATM", INTEGER2NUM(AF_NATM));
    /* Native ATM access */
    rb_define_const(rb_mSockConst, "AF_NATM", INTEGER2NUM(AF_NATM));
#endif
#if defined(PF_NATM)
    /* Native ATM access */
    rb_define_const(rb_cSocket, "PF_NATM", INTEGER2NUM(PF_NATM));
    /* Native ATM access */
    rb_define_const(rb_mSockConst, "PF_NATM", INTEGER2NUM(PF_NATM));
#endif
#if defined(AF_SYSTEM)
    /*  */
    rb_define_const(rb_cSocket, "AF_SYSTEM", INTEGER2NUM(AF_SYSTEM));
    /*  */
    rb_define_const(rb_mSockConst, "AF_SYSTEM", INTEGER2NUM(AF_SYSTEM));
#endif
#if defined(PF_SYSTEM)
    /*  */
    rb_define_const(rb_cSocket, "PF_SYSTEM", INTEGER2NUM(PF_SYSTEM));
    /*  */
    rb_define_const(rb_mSockConst, "PF_SYSTEM", INTEGER2NUM(PF_SYSTEM));
#endif
#if defined(AF_NETBIOS)
    /* NetBIOS */
    rb_define_const(rb_cSocket, "AF_NETBIOS", INTEGER2NUM(AF_NETBIOS));
    /* NetBIOS */
    rb_define_const(rb_mSockConst, "AF_NETBIOS", INTEGER2NUM(AF_NETBIOS));
#endif
#if defined(PF_NETBIOS)
    /* NetBIOS */
    rb_define_const(rb_cSocket, "PF_NETBIOS", INTEGER2NUM(PF_NETBIOS));
    /* NetBIOS */
    rb_define_const(rb_mSockConst, "PF_NETBIOS", INTEGER2NUM(PF_NETBIOS));
#endif
#if defined(AF_PPP)
    /* Point-to-Point Protocol */
    rb_define_const(rb_cSocket, "AF_PPP", INTEGER2NUM(AF_PPP));
    /* Point-to-Point Protocol */
    rb_define_const(rb_mSockConst, "AF_PPP", INTEGER2NUM(AF_PPP));
#endif
#if defined(PF_PPP)
    /* Point-to-Point Protocol */
    rb_define_const(rb_cSocket, "PF_PPP", INTEGER2NUM(PF_PPP));
    /* Point-to-Point Protocol */
    rb_define_const(rb_mSockConst, "PF_PPP", INTEGER2NUM(PF_PPP));
#endif
#if defined(AF_ATM)
    /* Asynchronous Transfer Mode */
    rb_define_const(rb_cSocket, "AF_ATM", INTEGER2NUM(AF_ATM));
    /* Asynchronous Transfer Mode */
    rb_define_const(rb_mSockConst, "AF_ATM", INTEGER2NUM(AF_ATM));
#endif
#if defined(PF_ATM)
    /* Asynchronous Transfer Mode */
    rb_define_const(rb_cSocket, "PF_ATM", INTEGER2NUM(PF_ATM));
    /* Asynchronous Transfer Mode */
    rb_define_const(rb_mSockConst, "PF_ATM", INTEGER2NUM(PF_ATM));
#endif
#if defined(AF_NETGRAPH)
    /* Netgraph sockets */
    rb_define_const(rb_cSocket, "AF_NETGRAPH", INTEGER2NUM(AF_NETGRAPH));
    /* Netgraph sockets */
    rb_define_const(rb_mSockConst, "AF_NETGRAPH", INTEGER2NUM(AF_NETGRAPH));
#endif
#if defined(PF_NETGRAPH)
    /* Netgraph sockets */
    rb_define_const(rb_cSocket, "PF_NETGRAPH", INTEGER2NUM(PF_NETGRAPH));
    /* Netgraph sockets */
    rb_define_const(rb_mSockConst, "PF_NETGRAPH", INTEGER2NUM(PF_NETGRAPH));
#endif
#if defined(AF_MAX)
    /* Maximum address family for this platform */
    rb_define_const(rb_cSocket, "AF_MAX", INTEGER2NUM(AF_MAX));
    /* Maximum address family for this platform */
    rb_define_const(rb_mSockConst, "AF_MAX", INTEGER2NUM(AF_MAX));
#endif
#if defined(PF_MAX)
    /* Maximum address family for this platform */
    rb_define_const(rb_cSocket, "PF_MAX", INTEGER2NUM(PF_MAX));
    /* Maximum address family for this platform */
    rb_define_const(rb_mSockConst, "PF_MAX", INTEGER2NUM(PF_MAX));
#endif
#if defined(AF_PACKET)
    /* Direct link-layer access */
    rb_define_const(rb_cSocket, "AF_PACKET", INTEGER2NUM(AF_PACKET));
    /* Direct link-layer access */
    rb_define_const(rb_mSockConst, "AF_PACKET", INTEGER2NUM(AF_PACKET));
#endif
#if defined(PF_PACKET)
    /* Direct link-layer access */
    rb_define_const(rb_cSocket, "PF_PACKET", INTEGER2NUM(PF_PACKET));
    /* Direct link-layer access */
    rb_define_const(rb_mSockConst, "PF_PACKET", INTEGER2NUM(PF_PACKET));
#endif
#if defined(AF_E164)
    /* CCITT (ITU-T) E.164 recommendation */
    rb_define_const(rb_cSocket, "AF_E164", INTEGER2NUM(AF_E164));
    /* CCITT (ITU-T) E.164 recommendation */
    rb_define_const(rb_mSockConst, "AF_E164", INTEGER2NUM(AF_E164));
#endif
#if defined(PF_XTP)
    /* eXpress Transfer Protocol */
    rb_define_const(rb_cSocket, "PF_XTP", INTEGER2NUM(PF_XTP));
    /* eXpress Transfer Protocol */
    rb_define_const(rb_mSockConst, "PF_XTP", INTEGER2NUM(PF_XTP));
#endif
#if defined(PF_RTIP)
    /*  */
    rb_define_const(rb_cSocket, "PF_RTIP", INTEGER2NUM(PF_RTIP));
    /*  */
    rb_define_const(rb_mSockConst, "PF_RTIP", INTEGER2NUM(PF_RTIP));
#endif
#if defined(PF_PIP)
    /*  */
    rb_define_const(rb_cSocket, "PF_PIP", INTEGER2NUM(PF_PIP));
    /*  */
    rb_define_const(rb_mSockConst, "PF_PIP", INTEGER2NUM(PF_PIP));
#endif
#if defined(PF_KEY)
    /*  */
    rb_define_const(rb_cSocket, "PF_KEY", INTEGER2NUM(PF_KEY));
    /*  */
    rb_define_const(rb_mSockConst, "PF_KEY", INTEGER2NUM(PF_KEY));
#endif
#if defined(MSG_OOB)
    /* Process out-of-band data */
    rb_define_const(rb_cSocket, "MSG_OOB", INTEGER2NUM(MSG_OOB));
    /* Process out-of-band data */
    rb_define_const(rb_mSockConst, "MSG_OOB", INTEGER2NUM(MSG_OOB));
#endif
#if defined(MSG_PEEK)
    /* Peek at incoming message */
    rb_define_const(rb_cSocket, "MSG_PEEK", INTEGER2NUM(MSG_PEEK));
    /* Peek at incoming message */
    rb_define_const(rb_mSockConst, "MSG_PEEK", INTEGER2NUM(MSG_PEEK));
#endif
#if defined(MSG_DONTROUTE)
    /* Send without using the routing tables */
    rb_define_const(rb_cSocket, "MSG_DONTROUTE", INTEGER2NUM(MSG_DONTROUTE));
    /* Send without using the routing tables */
    rb_define_const(rb_mSockConst, "MSG_DONTROUTE", INTEGER2NUM(MSG_DONTROUTE));
#endif
#if defined(MSG_EOR)
    /* Data completes record */
    rb_define_const(rb_cSocket, "MSG_EOR", INTEGER2NUM(MSG_EOR));
    /* Data completes record */
    rb_define_const(rb_mSockConst, "MSG_EOR", INTEGER2NUM(MSG_EOR));
#endif
#if defined(MSG_TRUNC)
    /* Data discarded before delivery */
    rb_define_const(rb_cSocket, "MSG_TRUNC", INTEGER2NUM(MSG_TRUNC));
    /* Data discarded before delivery */
    rb_define_const(rb_mSockConst, "MSG_TRUNC", INTEGER2NUM(MSG_TRUNC));
#endif
#if defined(MSG_CTRUNC)
    /* Control data lost before delivery */
    rb_define_const(rb_cSocket, "MSG_CTRUNC", INTEGER2NUM(MSG_CTRUNC));
    /* Control data lost before delivery */
    rb_define_const(rb_mSockConst, "MSG_CTRUNC", INTEGER2NUM(MSG_CTRUNC));
#endif
#if defined(MSG_WAITALL)
    /* Wait for full request or error */
    rb_define_const(rb_cSocket, "MSG_WAITALL", INTEGER2NUM(MSG_WAITALL));
    /* Wait for full request or error */
    rb_define_const(rb_mSockConst, "MSG_WAITALL", INTEGER2NUM(MSG_WAITALL));
#endif
#if defined(MSG_DONTWAIT)
    /* This message should be non-blocking */
    rb_define_const(rb_cSocket, "MSG_DONTWAIT", INTEGER2NUM(MSG_DONTWAIT));
    /* This message should be non-blocking */
    rb_define_const(rb_mSockConst, "MSG_DONTWAIT", INTEGER2NUM(MSG_DONTWAIT));
#endif
#if defined(MSG_EOF)
    /* Data completes connection */
    rb_define_const(rb_cSocket, "MSG_EOF", INTEGER2NUM(MSG_EOF));
    /* Data completes connection */
    rb_define_const(rb_mSockConst, "MSG_EOF", INTEGER2NUM(MSG_EOF));
#endif
#if defined(MSG_FLUSH)
    /* Start of a hold sequence.  Dumps to so_temp */
    rb_define_const(rb_cSocket, "MSG_FLUSH", INTEGER2NUM(MSG_FLUSH));
    /* Start of a hold sequence.  Dumps to so_temp */
    rb_define_const(rb_mSockConst, "MSG_FLUSH", INTEGER2NUM(MSG_FLUSH));
#endif
#if defined(MSG_HOLD)
    /* Hold fragment in so_temp */
    rb_define_const(rb_cSocket, "MSG_HOLD", INTEGER2NUM(MSG_HOLD));
    /* Hold fragment in so_temp */
    rb_define_const(rb_mSockConst, "MSG_HOLD", INTEGER2NUM(MSG_HOLD));
#endif
#if defined(MSG_SEND)
    /* Send the packet in so_temp */
    rb_define_const(rb_cSocket, "MSG_SEND", INTEGER2NUM(MSG_SEND));
    /* Send the packet in so_temp */
    rb_define_const(rb_mSockConst, "MSG_SEND", INTEGER2NUM(MSG_SEND));
#endif
#if defined(MSG_HAVEMORE)
    /* Data ready to be read */
    rb_define_const(rb_cSocket, "MSG_HAVEMORE", INTEGER2NUM(MSG_HAVEMORE));
    /* Data ready to be read */
    rb_define_const(rb_mSockConst, "MSG_HAVEMORE", INTEGER2NUM(MSG_HAVEMORE));
#endif
#if defined(MSG_RCVMORE)
    /* Data remains in the current packet */
    rb_define_const(rb_cSocket, "MSG_RCVMORE", INTEGER2NUM(MSG_RCVMORE));
    /* Data remains in the current packet */
    rb_define_const(rb_mSockConst, "MSG_RCVMORE", INTEGER2NUM(MSG_RCVMORE));
#endif
#if defined(MSG_COMPAT)
    /* End of record */
    rb_define_const(rb_cSocket, "MSG_COMPAT", INTEGER2NUM(MSG_COMPAT));
    /* End of record */
    rb_define_const(rb_mSockConst, "MSG_COMPAT", INTEGER2NUM(MSG_COMPAT));
#endif
#if defined(MSG_PROXY)
    /* Wait for full request */
    rb_define_const(rb_cSocket, "MSG_PROXY", INTEGER2NUM(MSG_PROXY));
    /* Wait for full request */
    rb_define_const(rb_mSockConst, "MSG_PROXY", INTEGER2NUM(MSG_PROXY));
#endif
#if defined(MSG_FIN)
    /*  */
    rb_define_const(rb_cSocket, "MSG_FIN", INTEGER2NUM(MSG_FIN));
    /*  */
    rb_define_const(rb_mSockConst, "MSG_FIN", INTEGER2NUM(MSG_FIN));
#endif
#if defined(MSG_SYN)
    /*  */
    rb_define_const(rb_cSocket, "MSG_SYN", INTEGER2NUM(MSG_SYN));
    /*  */
    rb_define_const(rb_mSockConst, "MSG_SYN", INTEGER2NUM(MSG_SYN));
#endif
#if defined(MSG_CONFIRM)
    /* Confirm path validity */
    rb_define_const(rb_cSocket, "MSG_CONFIRM", INTEGER2NUM(MSG_CONFIRM));
    /* Confirm path validity */
    rb_define_const(rb_mSockConst, "MSG_CONFIRM", INTEGER2NUM(MSG_CONFIRM));
#endif
#if defined(MSG_RST)
    /*  */
    rb_define_const(rb_cSocket, "MSG_RST", INTEGER2NUM(MSG_RST));
    /*  */
    rb_define_const(rb_mSockConst, "MSG_RST", INTEGER2NUM(MSG_RST));
#endif
#if defined(MSG_ERRQUEUE)
    /* Fetch message from error queue */
    rb_define_const(rb_cSocket, "MSG_ERRQUEUE", INTEGER2NUM(MSG_ERRQUEUE));
    /* Fetch message from error queue */
    rb_define_const(rb_mSockConst, "MSG_ERRQUEUE", INTEGER2NUM(MSG_ERRQUEUE));
#endif
#if defined(MSG_NOSIGNAL)
    /* Do not generate SIGPIPE */
    rb_define_const(rb_cSocket, "MSG_NOSIGNAL", INTEGER2NUM(MSG_NOSIGNAL));
    /* Do not generate SIGPIPE */
    rb_define_const(rb_mSockConst, "MSG_NOSIGNAL", INTEGER2NUM(MSG_NOSIGNAL));
#endif
#if defined(MSG_MORE)
    /* Sender will send more */
    rb_define_const(rb_cSocket, "MSG_MORE", INTEGER2NUM(MSG_MORE));
    /* Sender will send more */
    rb_define_const(rb_mSockConst, "MSG_MORE", INTEGER2NUM(MSG_MORE));
#endif
#if defined(MSG_FASTOPEN)
    /* Reduce step of the handshake process */
    rb_define_const(rb_cSocket, "MSG_FASTOPEN", INTEGER2NUM(MSG_FASTOPEN));
    /* Reduce step of the handshake process */
    rb_define_const(rb_mSockConst, "MSG_FASTOPEN", INTEGER2NUM(MSG_FASTOPEN));
#endif
#if defined(SOL_SOCKET)
    /* Socket-level options */
    rb_define_const(rb_cSocket, "SOL_SOCKET", INTEGER2NUM(SOL_SOCKET));
    /* Socket-level options */
    rb_define_const(rb_mSockConst, "SOL_SOCKET", INTEGER2NUM(SOL_SOCKET));
#endif
#if defined(SOL_IP)
    /* IP socket options */
    rb_define_const(rb_cSocket, "SOL_IP", INTEGER2NUM(SOL_IP));
    /* IP socket options */
    rb_define_const(rb_mSockConst, "SOL_IP", INTEGER2NUM(SOL_IP));
#endif
#if defined(SOL_IPX)
    /* IPX socket options */
    rb_define_const(rb_cSocket, "SOL_IPX", INTEGER2NUM(SOL_IPX));
    /* IPX socket options */
    rb_define_const(rb_mSockConst, "SOL_IPX", INTEGER2NUM(SOL_IPX));
#endif
#if defined(SOL_AX25)
    /* AX.25 socket options */
    rb_define_const(rb_cSocket, "SOL_AX25", INTEGER2NUM(SOL_AX25));
    /* AX.25 socket options */
    rb_define_const(rb_mSockConst, "SOL_AX25", INTEGER2NUM(SOL_AX25));
#endif
#if defined(SOL_ATALK)
    /* AppleTalk socket options */
    rb_define_const(rb_cSocket, "SOL_ATALK", INTEGER2NUM(SOL_ATALK));
    /* AppleTalk socket options */
    rb_define_const(rb_mSockConst, "SOL_ATALK", INTEGER2NUM(SOL_ATALK));
#endif
#if defined(SOL_TCP)
    /* TCP socket options */
    rb_define_const(rb_cSocket, "SOL_TCP", INTEGER2NUM(SOL_TCP));
    /* TCP socket options */
    rb_define_const(rb_mSockConst, "SOL_TCP", INTEGER2NUM(SOL_TCP));
#endif
#if defined(SOL_UDP)
    /* UDP socket options */
    rb_define_const(rb_cSocket, "SOL_UDP", INTEGER2NUM(SOL_UDP));
    /* UDP socket options */
    rb_define_const(rb_mSockConst, "SOL_UDP", INTEGER2NUM(SOL_UDP));
#endif
#if defined(IPPROTO_IP)
    /* Dummy protocol for IP */
    rb_define_const(rb_cSocket, "IPPROTO_IP", INTEGER2NUM(IPPROTO_IP));
    /* Dummy protocol for IP */
    rb_define_const(rb_mSockConst, "IPPROTO_IP", INTEGER2NUM(IPPROTO_IP));
#endif
#if defined(IPPROTO_ICMP)
    /* Control message protocol */
    rb_define_const(rb_cSocket, "IPPROTO_ICMP", INTEGER2NUM(IPPROTO_ICMP));
    /* Control message protocol */
    rb_define_const(rb_mSockConst, "IPPROTO_ICMP", INTEGER2NUM(IPPROTO_ICMP));
#endif
#if defined(IPPROTO_IGMP)
    /* Group Management Protocol */
    rb_define_const(rb_cSocket, "IPPROTO_IGMP", INTEGER2NUM(IPPROTO_IGMP));
    /* Group Management Protocol */
    rb_define_const(rb_mSockConst, "IPPROTO_IGMP", INTEGER2NUM(IPPROTO_IGMP));
#endif
#if defined(IPPROTO_GGP)
    /* Gateway to Gateway Protocol */
    rb_define_const(rb_cSocket, "IPPROTO_GGP", INTEGER2NUM(IPPROTO_GGP));
    /* Gateway to Gateway Protocol */
    rb_define_const(rb_mSockConst, "IPPROTO_GGP", INTEGER2NUM(IPPROTO_GGP));
#endif
#if defined(IPPROTO_TCP)
    /* TCP */
    rb_define_const(rb_cSocket, "IPPROTO_TCP", INTEGER2NUM(IPPROTO_TCP));
    /* TCP */
    rb_define_const(rb_mSockConst, "IPPROTO_TCP", INTEGER2NUM(IPPROTO_TCP));
#endif
#if defined(IPPROTO_EGP)
    /* Exterior Gateway Protocol */
    rb_define_const(rb_cSocket, "IPPROTO_EGP", INTEGER2NUM(IPPROTO_EGP));
    /* Exterior Gateway Protocol */
    rb_define_const(rb_mSockConst, "IPPROTO_EGP", INTEGER2NUM(IPPROTO_EGP));
#endif
#if defined(IPPROTO_PUP)
    /* PARC Universal Packet protocol */
    rb_define_const(rb_cSocket, "IPPROTO_PUP", INTEGER2NUM(IPPROTO_PUP));
    /* PARC Universal Packet protocol */
    rb_define_const(rb_mSockConst, "IPPROTO_PUP", INTEGER2NUM(IPPROTO_PUP));
#endif
#if defined(IPPROTO_UDP)
    /* UDP */
    rb_define_const(rb_cSocket, "IPPROTO_UDP", INTEGER2NUM(IPPROTO_UDP));
    /* UDP */
    rb_define_const(rb_mSockConst, "IPPROTO_UDP", INTEGER2NUM(IPPROTO_UDP));
#endif
#if defined(IPPROTO_IDP)
    /* XNS IDP */
    rb_define_const(rb_cSocket, "IPPROTO_IDP", INTEGER2NUM(IPPROTO_IDP));
    /* XNS IDP */
    rb_define_const(rb_mSockConst, "IPPROTO_IDP", INTEGER2NUM(IPPROTO_IDP));
#endif
#if defined(IPPROTO_HELLO)
    /* "hello" routing protocol */
    rb_define_const(rb_cSocket, "IPPROTO_HELLO", INTEGER2NUM(IPPROTO_HELLO));
    /* "hello" routing protocol */
    rb_define_const(rb_mSockConst, "IPPROTO_HELLO", INTEGER2NUM(IPPROTO_HELLO));
#endif
#if defined(IPPROTO_ND)
    /* Sun net disk protocol */
    rb_define_const(rb_cSocket, "IPPROTO_ND", INTEGER2NUM(IPPROTO_ND));
    /* Sun net disk protocol */
    rb_define_const(rb_mSockConst, "IPPROTO_ND", INTEGER2NUM(IPPROTO_ND));
#endif
#if defined(IPPROTO_TP)
    /* ISO transport protocol class 4 */
    rb_define_const(rb_cSocket, "IPPROTO_TP", INTEGER2NUM(IPPROTO_TP));
    /* ISO transport protocol class 4 */
    rb_define_const(rb_mSockConst, "IPPROTO_TP", INTEGER2NUM(IPPROTO_TP));
#endif
#if defined(IPPROTO_XTP)
    /* Xpress Transport Protocol */
    rb_define_const(rb_cSocket, "IPPROTO_XTP", INTEGER2NUM(IPPROTO_XTP));
    /* Xpress Transport Protocol */
    rb_define_const(rb_mSockConst, "IPPROTO_XTP", INTEGER2NUM(IPPROTO_XTP));
#endif
#if defined(IPPROTO_EON)
    /* ISO cnlp */
    rb_define_const(rb_cSocket, "IPPROTO_EON", INTEGER2NUM(IPPROTO_EON));
    /* ISO cnlp */
    rb_define_const(rb_mSockConst, "IPPROTO_EON", INTEGER2NUM(IPPROTO_EON));
#endif
#if defined(IPPROTO_BIP)
    /*  */
    rb_define_const(rb_cSocket, "IPPROTO_BIP", INTEGER2NUM(IPPROTO_BIP));
    /*  */
    rb_define_const(rb_mSockConst, "IPPROTO_BIP", INTEGER2NUM(IPPROTO_BIP));
#endif
#if defined(IPPROTO_AH)
    /* IP6 auth header */
    rb_define_const(rb_cSocket, "IPPROTO_AH", INTEGER2NUM(IPPROTO_AH));
    /* IP6 auth header */
    rb_define_const(rb_mSockConst, "IPPROTO_AH", INTEGER2NUM(IPPROTO_AH));
#endif
#if defined(IPPROTO_DSTOPTS)
    /* IP6 destination option */
    rb_define_const(rb_cSocket, "IPPROTO_DSTOPTS", INTEGER2NUM(IPPROTO_DSTOPTS));
    /* IP6 destination option */
    rb_define_const(rb_mSockConst, "IPPROTO_DSTOPTS", INTEGER2NUM(IPPROTO_DSTOPTS));
#endif
#if defined(IPPROTO_ESP)
    /* IP6 Encapsulated Security Payload */
    rb_define_const(rb_cSocket, "IPPROTO_ESP", INTEGER2NUM(IPPROTO_ESP));
    /* IP6 Encapsulated Security Payload */
    rb_define_const(rb_mSockConst, "IPPROTO_ESP", INTEGER2NUM(IPPROTO_ESP));
#endif
#if defined(IPPROTO_FRAGMENT)
    /* IP6 fragmentation header */
    rb_define_const(rb_cSocket, "IPPROTO_FRAGMENT", INTEGER2NUM(IPPROTO_FRAGMENT));
    /* IP6 fragmentation header */
    rb_define_const(rb_mSockConst, "IPPROTO_FRAGMENT", INTEGER2NUM(IPPROTO_FRAGMENT));
#endif
#if defined(IPPROTO_HOPOPTS)
    /* IP6 hop-by-hop options */
    rb_define_const(rb_cSocket, "IPPROTO_HOPOPTS", INTEGER2NUM(IPPROTO_HOPOPTS));
    /* IP6 hop-by-hop options */
    rb_define_const(rb_mSockConst, "IPPROTO_HOPOPTS", INTEGER2NUM(IPPROTO_HOPOPTS));
#endif
#if defined(IPPROTO_ICMPV6)
    /* ICMP6 */
    rb_define_const(rb_cSocket, "IPPROTO_ICMPV6", INTEGER2NUM(IPPROTO_ICMPV6));
    /* ICMP6 */
    rb_define_const(rb_mSockConst, "IPPROTO_ICMPV6", INTEGER2NUM(IPPROTO_ICMPV6));
#endif
#if defined(IPPROTO_IPV6)
    /* IP6 header */
    rb_define_const(rb_cSocket, "IPPROTO_IPV6", INTEGER2NUM(IPPROTO_IPV6));
    /* IP6 header */
    rb_define_const(rb_mSockConst, "IPPROTO_IPV6", INTEGER2NUM(IPPROTO_IPV6));
#endif
#if defined(IPPROTO_NONE)
    /* IP6 no next header */
    rb_define_const(rb_cSocket, "IPPROTO_NONE", INTEGER2NUM(IPPROTO_NONE));
    /* IP6 no next header */
    rb_define_const(rb_mSockConst, "IPPROTO_NONE", INTEGER2NUM(IPPROTO_NONE));
#endif
#if defined(IPPROTO_ROUTING)
    /* IP6 routing header */
    rb_define_const(rb_cSocket, "IPPROTO_ROUTING", INTEGER2NUM(IPPROTO_ROUTING));
    /* IP6 routing header */
    rb_define_const(rb_mSockConst, "IPPROTO_ROUTING", INTEGER2NUM(IPPROTO_ROUTING));
#endif
#if defined(IPPROTO_RAW)
    /* Raw IP packet */
    rb_define_const(rb_cSocket, "IPPROTO_RAW", INTEGER2NUM(IPPROTO_RAW));
    /* Raw IP packet */
    rb_define_const(rb_mSockConst, "IPPROTO_RAW", INTEGER2NUM(IPPROTO_RAW));
#endif
#if defined(IPPROTO_MAX)
    /* Maximum IPPROTO constant */
    rb_define_const(rb_cSocket, "IPPROTO_MAX", INTEGER2NUM(IPPROTO_MAX));
    /* Maximum IPPROTO constant */
    rb_define_const(rb_mSockConst, "IPPROTO_MAX", INTEGER2NUM(IPPROTO_MAX));
#endif
#if defined(IPPORT_RESERVED)
    /* Default minimum address for bind or connect */
    rb_define_const(rb_cSocket, "IPPORT_RESERVED", INTEGER2NUM(IPPORT_RESERVED));
    /* Default minimum address for bind or connect */
    rb_define_const(rb_mSockConst, "IPPORT_RESERVED", INTEGER2NUM(IPPORT_RESERVED));
#endif
#if defined(IPPORT_USERRESERVED)
    /* Default maximum address for bind or connect */
    rb_define_const(rb_cSocket, "IPPORT_USERRESERVED", INTEGER2NUM(IPPORT_USERRESERVED));
    /* Default maximum address for bind or connect */
    rb_define_const(rb_mSockConst, "IPPORT_USERRESERVED", INTEGER2NUM(IPPORT_USERRESERVED));
#endif
#if defined(INADDR_ANY)
    /* A socket bound to INADDR_ANY receives packets from all interfaces and sends from the default IP address */
    rb_define_const(rb_cSocket, "INADDR_ANY", INTEGER2NUM(INADDR_ANY));
    /* A socket bound to INADDR_ANY receives packets from all interfaces and sends from the default IP address */
    rb_define_const(rb_mSockConst, "INADDR_ANY", INTEGER2NUM(INADDR_ANY));
#endif
#if defined(INADDR_BROADCAST)
    /* The network broadcast address */
    rb_define_const(rb_cSocket, "INADDR_BROADCAST", INTEGER2NUM(INADDR_BROADCAST));
    /* The network broadcast address */
    rb_define_const(rb_mSockConst, "INADDR_BROADCAST", INTEGER2NUM(INADDR_BROADCAST));
#endif
#if defined(INADDR_LOOPBACK)
    /* The loopback address */
    rb_define_const(rb_cSocket, "INADDR_LOOPBACK", INTEGER2NUM(INADDR_LOOPBACK));
    /* The loopback address */
    rb_define_const(rb_mSockConst, "INADDR_LOOPBACK", INTEGER2NUM(INADDR_LOOPBACK));
#endif
#if defined(INADDR_UNSPEC_GROUP)
    /* The reserved multicast group */
    rb_define_const(rb_cSocket, "INADDR_UNSPEC_GROUP", INTEGER2NUM(INADDR_UNSPEC_GROUP));
    /* The reserved multicast group */
    rb_define_const(rb_mSockConst, "INADDR_UNSPEC_GROUP", INTEGER2NUM(INADDR_UNSPEC_GROUP));
#endif
#if defined(INADDR_ALLHOSTS_GROUP)
    /* Multicast group for all systems on this subset */
    rb_define_const(rb_cSocket, "INADDR_ALLHOSTS_GROUP", INTEGER2NUM(INADDR_ALLHOSTS_GROUP));
    /* Multicast group for all systems on this subset */
    rb_define_const(rb_mSockConst, "INADDR_ALLHOSTS_GROUP", INTEGER2NUM(INADDR_ALLHOSTS_GROUP));
#endif
#if defined(INADDR_MAX_LOCAL_GROUP)
    /* The last local network multicast group */
    rb_define_const(rb_cSocket, "INADDR_MAX_LOCAL_GROUP", INTEGER2NUM(INADDR_MAX_LOCAL_GROUP));
    /* The last local network multicast group */
    rb_define_const(rb_mSockConst, "INADDR_MAX_LOCAL_GROUP", INTEGER2NUM(INADDR_MAX_LOCAL_GROUP));
#endif
#if defined(INADDR_NONE)
    /* A bitmask for matching no valid IP address */
    rb_define_const(rb_cSocket, "INADDR_NONE", INTEGER2NUM(INADDR_NONE));
    /* A bitmask for matching no valid IP address */
    rb_define_const(rb_mSockConst, "INADDR_NONE", INTEGER2NUM(INADDR_NONE));
#endif
#if defined(IP_OPTIONS)
    /* IP options to be included in packets */
    rb_define_const(rb_cSocket, "IP_OPTIONS", INTEGER2NUM(IP_OPTIONS));
    /* IP options to be included in packets */
    rb_define_const(rb_mSockConst, "IP_OPTIONS", INTEGER2NUM(IP_OPTIONS));
#endif
#if defined(IP_HDRINCL)
    /* Header is included with data */
    rb_define_const(rb_cSocket, "IP_HDRINCL", INTEGER2NUM(IP_HDRINCL));
    /* Header is included with data */
    rb_define_const(rb_mSockConst, "IP_HDRINCL", INTEGER2NUM(IP_HDRINCL));
#endif
#if defined(IP_TOS)
    /* IP type-of-service */
    rb_define_const(rb_cSocket, "IP_TOS", INTEGER2NUM(IP_TOS));
    /* IP type-of-service */
    rb_define_const(rb_mSockConst, "IP_TOS", INTEGER2NUM(IP_TOS));
#endif
#if defined(IP_TTL)
    /* IP time-to-live */
    rb_define_const(rb_cSocket, "IP_TTL", INTEGER2NUM(IP_TTL));
    /* IP time-to-live */
    rb_define_const(rb_mSockConst, "IP_TTL", INTEGER2NUM(IP_TTL));
#endif
#if defined(IP_RECVOPTS)
    /* Receive all IP options with datagram */
    rb_define_const(rb_cSocket, "IP_RECVOPTS", INTEGER2NUM(IP_RECVOPTS));
    /* Receive all IP options with datagram */
    rb_define_const(rb_mSockConst, "IP_RECVOPTS", INTEGER2NUM(IP_RECVOPTS));
#endif
#if defined(IP_RECVRETOPTS)
    /* Receive all IP options for response */
    rb_define_const(rb_cSocket, "IP_RECVRETOPTS", INTEGER2NUM(IP_RECVRETOPTS));
    /* Receive all IP options for response */
    rb_define_const(rb_mSockConst, "IP_RECVRETOPTS", INTEGER2NUM(IP_RECVRETOPTS));
#endif
#if defined(IP_RECVDSTADDR)
    /* Receive IP destination address with datagram */
    rb_define_const(rb_cSocket, "IP_RECVDSTADDR", INTEGER2NUM(IP_RECVDSTADDR));
    /* Receive IP destination address with datagram */
    rb_define_const(rb_mSockConst, "IP_RECVDSTADDR", INTEGER2NUM(IP_RECVDSTADDR));
#endif
#if defined(IP_RETOPTS)
    /* IP options to be included in datagrams */
    rb_define_const(rb_cSocket, "IP_RETOPTS", INTEGER2NUM(IP_RETOPTS));
    /* IP options to be included in datagrams */
    rb_define_const(rb_mSockConst, "IP_RETOPTS", INTEGER2NUM(IP_RETOPTS));
#endif
#if defined(IP_MINTTL)
    /* Minimum TTL allowed for received packets */
    rb_define_const(rb_cSocket, "IP_MINTTL", INTEGER2NUM(IP_MINTTL));
    /* Minimum TTL allowed for received packets */
    rb_define_const(rb_mSockConst, "IP_MINTTL", INTEGER2NUM(IP_MINTTL));
#endif
#if defined(IP_DONTFRAG)
    /* Don't fragment packets */
    rb_define_const(rb_cSocket, "IP_DONTFRAG", INTEGER2NUM(IP_DONTFRAG));
    /* Don't fragment packets */
    rb_define_const(rb_mSockConst, "IP_DONTFRAG", INTEGER2NUM(IP_DONTFRAG));
#endif
#if defined(IP_SENDSRCADDR)
    /* Source address for outgoing UDP datagrams */
    rb_define_const(rb_cSocket, "IP_SENDSRCADDR", INTEGER2NUM(IP_SENDSRCADDR));
    /* Source address for outgoing UDP datagrams */
    rb_define_const(rb_mSockConst, "IP_SENDSRCADDR", INTEGER2NUM(IP_SENDSRCADDR));
#endif
#if defined(IP_ONESBCAST)
    /* Force outgoing broadcast datagrams to have the undirected broadcast address */
    rb_define_const(rb_cSocket, "IP_ONESBCAST", INTEGER2NUM(IP_ONESBCAST));
    /* Force outgoing broadcast datagrams to have the undirected broadcast address */
    rb_define_const(rb_mSockConst, "IP_ONESBCAST", INTEGER2NUM(IP_ONESBCAST));
#endif
#if defined(IP_RECVTTL)
    /* Receive IP TTL with datagrams */
    rb_define_const(rb_cSocket, "IP_RECVTTL", INTEGER2NUM(IP_RECVTTL));
    /* Receive IP TTL with datagrams */
    rb_define_const(rb_mSockConst, "IP_RECVTTL", INTEGER2NUM(IP_RECVTTL));
#endif
#if defined(IP_RECVIF)
    /* Receive interface information with datagrams */
    rb_define_const(rb_cSocket, "IP_RECVIF", INTEGER2NUM(IP_RECVIF));
    /* Receive interface information with datagrams */
    rb_define_const(rb_mSockConst, "IP_RECVIF", INTEGER2NUM(IP_RECVIF));
#endif
#if defined(IP_RECVSLLA)
    /* Receive link-layer address with datagrams */
    rb_define_const(rb_cSocket, "IP_RECVSLLA", INTEGER2NUM(IP_RECVSLLA));
    /* Receive link-layer address with datagrams */
    rb_define_const(rb_mSockConst, "IP_RECVSLLA", INTEGER2NUM(IP_RECVSLLA));
#endif
#if defined(IP_PORTRANGE)
    /* Set the port range for sockets with unspecified port numbers */
    rb_define_const(rb_cSocket, "IP_PORTRANGE", INTEGER2NUM(IP_PORTRANGE));
    /* Set the port range for sockets with unspecified port numbers */
    rb_define_const(rb_mSockConst, "IP_PORTRANGE", INTEGER2NUM(IP_PORTRANGE));
#endif
#if defined(IP_MULTICAST_IF)
    /* IP multicast interface */
    rb_define_const(rb_cSocket, "IP_MULTICAST_IF", INTEGER2NUM(IP_MULTICAST_IF));
    /* IP multicast interface */
    rb_define_const(rb_mSockConst, "IP_MULTICAST_IF", INTEGER2NUM(IP_MULTICAST_IF));
#endif
#if defined(IP_MULTICAST_TTL)
    /* IP multicast TTL */
    rb_define_const(rb_cSocket, "IP_MULTICAST_TTL", INTEGER2NUM(IP_MULTICAST_TTL));
    /* IP multicast TTL */
    rb_define_const(rb_mSockConst, "IP_MULTICAST_TTL", INTEGER2NUM(IP_MULTICAST_TTL));
#endif
#if defined(IP_MULTICAST_LOOP)
    /* IP multicast loopback */
    rb_define_const(rb_cSocket, "IP_MULTICAST_LOOP", INTEGER2NUM(IP_MULTICAST_LOOP));
    /* IP multicast loopback */
    rb_define_const(rb_mSockConst, "IP_MULTICAST_LOOP", INTEGER2NUM(IP_MULTICAST_LOOP));
#endif
#if defined(IP_ADD_MEMBERSHIP)
    /* Add a multicast group membership */
    rb_define_const(rb_cSocket, "IP_ADD_MEMBERSHIP", INTEGER2NUM(IP_ADD_MEMBERSHIP));
    /* Add a multicast group membership */
    rb_define_const(rb_mSockConst, "IP_ADD_MEMBERSHIP", INTEGER2NUM(IP_ADD_MEMBERSHIP));
#endif
#if defined(IP_DROP_MEMBERSHIP)
    /* Drop a multicast group membership */
    rb_define_const(rb_cSocket, "IP_DROP_MEMBERSHIP", INTEGER2NUM(IP_DROP_MEMBERSHIP));
    /* Drop a multicast group membership */
    rb_define_const(rb_mSockConst, "IP_DROP_MEMBERSHIP", INTEGER2NUM(IP_DROP_MEMBERSHIP));
#endif
#if defined(IP_DEFAULT_MULTICAST_TTL)
    /* Default multicast TTL */
    rb_define_const(rb_cSocket, "IP_DEFAULT_MULTICAST_TTL", INTEGER2NUM(IP_DEFAULT_MULTICAST_TTL));
    /* Default multicast TTL */
    rb_define_const(rb_mSockConst, "IP_DEFAULT_MULTICAST_TTL", INTEGER2NUM(IP_DEFAULT_MULTICAST_TTL));
#endif
#if defined(IP_DEFAULT_MULTICAST_LOOP)
    /* Default multicast loopback */
    rb_define_const(rb_cSocket, "IP_DEFAULT_MULTICAST_LOOP", INTEGER2NUM(IP_DEFAULT_MULTICAST_LOOP));
    /* Default multicast loopback */
    rb_define_const(rb_mSockConst, "IP_DEFAULT_MULTICAST_LOOP", INTEGER2NUM(IP_DEFAULT_MULTICAST_LOOP));
#endif
#if defined(IP_MAX_MEMBERSHIPS)
    /* Maximum number multicast groups a socket can join */
    rb_define_const(rb_cSocket, "IP_MAX_MEMBERSHIPS", INTEGER2NUM(IP_MAX_MEMBERSHIPS));
    /* Maximum number multicast groups a socket can join */
    rb_define_const(rb_mSockConst, "IP_MAX_MEMBERSHIPS", INTEGER2NUM(IP_MAX_MEMBERSHIPS));
#endif
#if defined(IP_ROUTER_ALERT)
    /* Notify transit routers to more closely examine the contents of an IP packet */
    rb_define_const(rb_cSocket, "IP_ROUTER_ALERT", INTEGER2NUM(IP_ROUTER_ALERT));
    /* Notify transit routers to more closely examine the contents of an IP packet */
    rb_define_const(rb_mSockConst, "IP_ROUTER_ALERT", INTEGER2NUM(IP_ROUTER_ALERT));
#endif
#if defined(IP_PKTINFO)
    /* Receive packet information with datagrams */
    rb_define_const(rb_cSocket, "IP_PKTINFO", INTEGER2NUM(IP_PKTINFO));
    /* Receive packet information with datagrams */
    rb_define_const(rb_mSockConst, "IP_PKTINFO", INTEGER2NUM(IP_PKTINFO));
#endif
#if defined(IP_PKTOPTIONS)
    /* Receive packet options with datagrams */
    rb_define_const(rb_cSocket, "IP_PKTOPTIONS", INTEGER2NUM(IP_PKTOPTIONS));
    /* Receive packet options with datagrams */
    rb_define_const(rb_mSockConst, "IP_PKTOPTIONS", INTEGER2NUM(IP_PKTOPTIONS));
#endif
#if defined(IP_MTU_DISCOVER)
    /* Path MTU discovery */
    rb_define_const(rb_cSocket, "IP_MTU_DISCOVER", INTEGER2NUM(IP_MTU_DISCOVER));
    /* Path MTU discovery */
    rb_define_const(rb_mSockConst, "IP_MTU_DISCOVER", INTEGER2NUM(IP_MTU_DISCOVER));
#endif
#if defined(IP_RECVERR)
    /* Enable extended reliable error message passing */
    rb_define_const(rb_cSocket, "IP_RECVERR", INTEGER2NUM(IP_RECVERR));
    /* Enable extended reliable error message passing */
    rb_define_const(rb_mSockConst, "IP_RECVERR", INTEGER2NUM(IP_RECVERR));
#endif
#if defined(IP_RECVTOS)
    /* Receive TOS with incoming packets */
    rb_define_const(rb_cSocket, "IP_RECVTOS", INTEGER2NUM(IP_RECVTOS));
    /* Receive TOS with incoming packets */
    rb_define_const(rb_mSockConst, "IP_RECVTOS", INTEGER2NUM(IP_RECVTOS));
#endif
#if defined(IP_MTU)
    /* The Maximum Transmission Unit of the socket */
    rb_define_const(rb_cSocket, "IP_MTU", INTEGER2NUM(IP_MTU));
    /* The Maximum Transmission Unit of the socket */
    rb_define_const(rb_mSockConst, "IP_MTU", INTEGER2NUM(IP_MTU));
#endif
#if defined(IP_FREEBIND)
    /* Allow binding to nonexistent IP addresses */
    rb_define_const(rb_cSocket, "IP_FREEBIND", INTEGER2NUM(IP_FREEBIND));
    /* Allow binding to nonexistent IP addresses */
    rb_define_const(rb_mSockConst, "IP_FREEBIND", INTEGER2NUM(IP_FREEBIND));
#endif
#if defined(IP_IPSEC_POLICY)
    /* IPsec security policy */
    rb_define_const(rb_cSocket, "IP_IPSEC_POLICY", INTEGER2NUM(IP_IPSEC_POLICY));
    /* IPsec security policy */
    rb_define_const(rb_mSockConst, "IP_IPSEC_POLICY", INTEGER2NUM(IP_IPSEC_POLICY));
#endif
#if defined(IP_XFRM_POLICY)
    /*  */
    rb_define_const(rb_cSocket, "IP_XFRM_POLICY", INTEGER2NUM(IP_XFRM_POLICY));
    /*  */
    rb_define_const(rb_mSockConst, "IP_XFRM_POLICY", INTEGER2NUM(IP_XFRM_POLICY));
#endif
#if defined(IP_PASSSEC)
    /* Retrieve security context with datagram */
    rb_define_const(rb_cSocket, "IP_PASSSEC", INTEGER2NUM(IP_PASSSEC));
    /* Retrieve security context with datagram */
    rb_define_const(rb_mSockConst, "IP_PASSSEC", INTEGER2NUM(IP_PASSSEC));
#endif
#if defined(IP_TRANSPARENT)
    /* Transparent proxy */
    rb_define_const(rb_cSocket, "IP_TRANSPARENT", INTEGER2NUM(IP_TRANSPARENT));
    /* Transparent proxy */
    rb_define_const(rb_mSockConst, "IP_TRANSPARENT", INTEGER2NUM(IP_TRANSPARENT));
#endif
#if defined(IP_PMTUDISC_DONT)
    /* Never send DF frames */
    rb_define_const(rb_cSocket, "IP_PMTUDISC_DONT", INTEGER2NUM(IP_PMTUDISC_DONT));
    /* Never send DF frames */
    rb_define_const(rb_mSockConst, "IP_PMTUDISC_DONT", INTEGER2NUM(IP_PMTUDISC_DONT));
#endif
#if defined(IP_PMTUDISC_WANT)
    /* Use per-route hints */
    rb_define_const(rb_cSocket, "IP_PMTUDISC_WANT", INTEGER2NUM(IP_PMTUDISC_WANT));
    /* Use per-route hints */
    rb_define_const(rb_mSockConst, "IP_PMTUDISC_WANT", INTEGER2NUM(IP_PMTUDISC_WANT));
#endif
#if defined(IP_PMTUDISC_DO)
    /* Always send DF frames */
    rb_define_const(rb_cSocket, "IP_PMTUDISC_DO", INTEGER2NUM(IP_PMTUDISC_DO));
    /* Always send DF frames */
    rb_define_const(rb_mSockConst, "IP_PMTUDISC_DO", INTEGER2NUM(IP_PMTUDISC_DO));
#endif
#if defined(IP_UNBLOCK_SOURCE)
    /* Unblock IPv4 multicast packets with a give source address */
    rb_define_const(rb_cSocket, "IP_UNBLOCK_SOURCE", INTEGER2NUM(IP_UNBLOCK_SOURCE));
    /* Unblock IPv4 multicast packets with a give source address */
    rb_define_const(rb_mSockConst, "IP_UNBLOCK_SOURCE", INTEGER2NUM(IP_UNBLOCK_SOURCE));
#endif
#if defined(IP_BLOCK_SOURCE)
    /* Block IPv4 multicast packets with a give source address */
    rb_define_const(rb_cSocket, "IP_BLOCK_SOURCE", INTEGER2NUM(IP_BLOCK_SOURCE));
    /* Block IPv4 multicast packets with a give source address */
    rb_define_const(rb_mSockConst, "IP_BLOCK_SOURCE", INTEGER2NUM(IP_BLOCK_SOURCE));
#endif
#if defined(IP_ADD_SOURCE_MEMBERSHIP)
    /* Add a multicast group membership */
    rb_define_const(rb_cSocket, "IP_ADD_SOURCE_MEMBERSHIP", INTEGER2NUM(IP_ADD_SOURCE_MEMBERSHIP));
    /* Add a multicast group membership */
    rb_define_const(rb_mSockConst, "IP_ADD_SOURCE_MEMBERSHIP", INTEGER2NUM(IP_ADD_SOURCE_MEMBERSHIP));
#endif
#if defined(IP_DROP_SOURCE_MEMBERSHIP)
    /* Drop a multicast group membership */
    rb_define_const(rb_cSocket, "IP_DROP_SOURCE_MEMBERSHIP", INTEGER2NUM(IP_DROP_SOURCE_MEMBERSHIP));
    /* Drop a multicast group membership */
    rb_define_const(rb_mSockConst, "IP_DROP_SOURCE_MEMBERSHIP", INTEGER2NUM(IP_DROP_SOURCE_MEMBERSHIP));
#endif
#if defined(IP_MSFILTER)
    /* Multicast source filtering */
    rb_define_const(rb_cSocket, "IP_MSFILTER", INTEGER2NUM(IP_MSFILTER));
    /* Multicast source filtering */
    rb_define_const(rb_mSockConst, "IP_MSFILTER", INTEGER2NUM(IP_MSFILTER));
#endif
#if defined(MCAST_JOIN_GROUP)
    /* Join a multicast group */
    rb_define_const(rb_cSocket, "MCAST_JOIN_GROUP", INTEGER2NUM(MCAST_JOIN_GROUP));
    /* Join a multicast group */
    rb_define_const(rb_mSockConst, "MCAST_JOIN_GROUP", INTEGER2NUM(MCAST_JOIN_GROUP));
#endif
#if defined(MCAST_BLOCK_SOURCE)
    /* Block multicast packets from this source */
    rb_define_const(rb_cSocket, "MCAST_BLOCK_SOURCE", INTEGER2NUM(MCAST_BLOCK_SOURCE));
    /* Block multicast packets from this source */
    rb_define_const(rb_mSockConst, "MCAST_BLOCK_SOURCE", INTEGER2NUM(MCAST_BLOCK_SOURCE));
#endif
#if defined(MCAST_UNBLOCK_SOURCE)
    /* Unblock multicast packets from this source */
    rb_define_const(rb_cSocket, "MCAST_UNBLOCK_SOURCE", INTEGER2NUM(MCAST_UNBLOCK_SOURCE));
    /* Unblock multicast packets from this source */
    rb_define_const(rb_mSockConst, "MCAST_UNBLOCK_SOURCE", INTEGER2NUM(MCAST_UNBLOCK_SOURCE));
#endif
#if defined(MCAST_LEAVE_GROUP)
    /* Leave a multicast group */
    rb_define_const(rb_cSocket, "MCAST_LEAVE_GROUP", INTEGER2NUM(MCAST_LEAVE_GROUP));
    /* Leave a multicast group */
    rb_define_const(rb_mSockConst, "MCAST_LEAVE_GROUP", INTEGER2NUM(MCAST_LEAVE_GROUP));
#endif
#if defined(MCAST_JOIN_SOURCE_GROUP)
    /* Join a multicast source group */
    rb_define_const(rb_cSocket, "MCAST_JOIN_SOURCE_GROUP", INTEGER2NUM(MCAST_JOIN_SOURCE_GROUP));
    /* Join a multicast source group */
    rb_define_const(rb_mSockConst, "MCAST_JOIN_SOURCE_GROUP", INTEGER2NUM(MCAST_JOIN_SOURCE_GROUP));
#endif
#if defined(MCAST_LEAVE_SOURCE_GROUP)
    /* Leave a multicast source group */
    rb_define_const(rb_cSocket, "MCAST_LEAVE_SOURCE_GROUP", INTEGER2NUM(MCAST_LEAVE_SOURCE_GROUP));
    /* Leave a multicast source group */
    rb_define_const(rb_mSockConst, "MCAST_LEAVE_SOURCE_GROUP", INTEGER2NUM(MCAST_LEAVE_SOURCE_GROUP));
#endif
#if defined(MCAST_MSFILTER)
    /* Multicast source filtering */
    rb_define_const(rb_cSocket, "MCAST_MSFILTER", INTEGER2NUM(MCAST_MSFILTER));
    /* Multicast source filtering */
    rb_define_const(rb_mSockConst, "MCAST_MSFILTER", INTEGER2NUM(MCAST_MSFILTER));
#endif
#if defined(MCAST_EXCLUDE)
    /* Exclusive multicast source filter */
    rb_define_const(rb_cSocket, "MCAST_EXCLUDE", INTEGER2NUM(MCAST_EXCLUDE));
    /* Exclusive multicast source filter */
    rb_define_const(rb_mSockConst, "MCAST_EXCLUDE", INTEGER2NUM(MCAST_EXCLUDE));
#endif
#if defined(MCAST_INCLUDE)
    /* Inclusive multicast source filter */
    rb_define_const(rb_cSocket, "MCAST_INCLUDE", INTEGER2NUM(MCAST_INCLUDE));
    /* Inclusive multicast source filter */
    rb_define_const(rb_mSockConst, "MCAST_INCLUDE", INTEGER2NUM(MCAST_INCLUDE));
#endif
#if defined(SO_DEBUG)
    /* Debug info recording */
    rb_define_const(rb_cSocket, "SO_DEBUG", INTEGER2NUM(SO_DEBUG));
    /* Debug info recording */
    rb_define_const(rb_mSockConst, "SO_DEBUG", INTEGER2NUM(SO_DEBUG));
#endif
#if defined(SO_REUSEADDR)
    /* Allow local address reuse */
    rb_define_const(rb_cSocket, "SO_REUSEADDR", INTEGER2NUM(SO_REUSEADDR));
    /* Allow local address reuse */
    rb_define_const(rb_mSockConst, "SO_REUSEADDR", INTEGER2NUM(SO_REUSEADDR));
#endif
#if defined(SO_REUSEPORT)
    /* Allow local address and port reuse */
    rb_define_const(rb_cSocket, "SO_REUSEPORT", INTEGER2NUM(SO_REUSEPORT));
    /* Allow local address and port reuse */
    rb_define_const(rb_mSockConst, "SO_REUSEPORT", INTEGER2NUM(SO_REUSEPORT));
#endif
#if defined(SO_TYPE)
    /* Get the socket type */
    rb_define_const(rb_cSocket, "SO_TYPE", INTEGER2NUM(SO_TYPE));
    /* Get the socket type */
    rb_define_const(rb_mSockConst, "SO_TYPE", INTEGER2NUM(SO_TYPE));
#endif
#if defined(SO_ERROR)
    /* Get and clear the error status */
    rb_define_const(rb_cSocket, "SO_ERROR", INTEGER2NUM(SO_ERROR));
    /* Get and clear the error status */
    rb_define_const(rb_mSockConst, "SO_ERROR", INTEGER2NUM(SO_ERROR));
#endif
#if defined(SO_DONTROUTE)
    /* Use interface addresses */
    rb_define_const(rb_cSocket, "SO_DONTROUTE", INTEGER2NUM(SO_DONTROUTE));
    /* Use interface addresses */
    rb_define_const(rb_mSockConst, "SO_DONTROUTE", INTEGER2NUM(SO_DONTROUTE));
#endif
#if defined(SO_BROADCAST)
    /* Permit sending of broadcast messages */
    rb_define_const(rb_cSocket, "SO_BROADCAST", INTEGER2NUM(SO_BROADCAST));
    /* Permit sending of broadcast messages */
    rb_define_const(rb_mSockConst, "SO_BROADCAST", INTEGER2NUM(SO_BROADCAST));
#endif
#if defined(SO_SNDBUF)
    /* Send buffer size */
    rb_define_const(rb_cSocket, "SO_SNDBUF", INTEGER2NUM(SO_SNDBUF));
    /* Send buffer size */
    rb_define_const(rb_mSockConst, "SO_SNDBUF", INTEGER2NUM(SO_SNDBUF));
#endif
#if defined(SO_RCVBUF)
    /* Receive buffer size */
    rb_define_const(rb_cSocket, "SO_RCVBUF", INTEGER2NUM(SO_RCVBUF));
    /* Receive buffer size */
    rb_define_const(rb_mSockConst, "SO_RCVBUF", INTEGER2NUM(SO_RCVBUF));
#endif
#if defined(SO_SNDBUFFORCE)
    /* Send buffer size without wmem_max limit (Linux 2.6.14) */
    rb_define_const(rb_cSocket, "SO_SNDBUFFORCE", INTEGER2NUM(SO_SNDBUFFORCE));
    /* Send buffer size without wmem_max limit (Linux 2.6.14) */
    rb_define_const(rb_mSockConst, "SO_SNDBUFFORCE", INTEGER2NUM(SO_SNDBUFFORCE));
#endif
#if defined(SO_RCVBUFFORCE)
    /* Receive buffer size without rmem_max limit (Linux 2.6.14) */
    rb_define_const(rb_cSocket, "SO_RCVBUFFORCE", INTEGER2NUM(SO_RCVBUFFORCE));
    /* Receive buffer size without rmem_max limit (Linux 2.6.14) */
    rb_define_const(rb_mSockConst, "SO_RCVBUFFORCE", INTEGER2NUM(SO_RCVBUFFORCE));
#endif
#if defined(SO_KEEPALIVE)
    /* Keep connections alive */
    rb_define_const(rb_cSocket, "SO_KEEPALIVE", INTEGER2NUM(SO_KEEPALIVE));
    /* Keep connections alive */
    rb_define_const(rb_mSockConst, "SO_KEEPALIVE", INTEGER2NUM(SO_KEEPALIVE));
#endif
#if defined(SO_OOBINLINE)
    /* Leave received out-of-band data in-line */
    rb_define_const(rb_cSocket, "SO_OOBINLINE", INTEGER2NUM(SO_OOBINLINE));
    /* Leave received out-of-band data in-line */
    rb_define_const(rb_mSockConst, "SO_OOBINLINE", INTEGER2NUM(SO_OOBINLINE));
#endif
#if defined(SO_NO_CHECK)
    /* Disable checksums */
    rb_define_const(rb_cSocket, "SO_NO_CHECK", INTEGER2NUM(SO_NO_CHECK));
    /* Disable checksums */
    rb_define_const(rb_mSockConst, "SO_NO_CHECK", INTEGER2NUM(SO_NO_CHECK));
#endif
#if defined(SO_PRIORITY)
    /* The protocol-defined priority for all packets on this socket */
    rb_define_const(rb_cSocket, "SO_PRIORITY", INTEGER2NUM(SO_PRIORITY));
    /* The protocol-defined priority for all packets on this socket */
    rb_define_const(rb_mSockConst, "SO_PRIORITY", INTEGER2NUM(SO_PRIORITY));
#endif
#if defined(SO_LINGER)
    /* Linger on close if data is present */
    rb_define_const(rb_cSocket, "SO_LINGER", INTEGER2NUM(SO_LINGER));
    /* Linger on close if data is present */
    rb_define_const(rb_mSockConst, "SO_LINGER", INTEGER2NUM(SO_LINGER));
#endif
#if defined(SO_PASSCRED)
    /* Receive SCM_CREDENTIALS messages */
    rb_define_const(rb_cSocket, "SO_PASSCRED", INTEGER2NUM(SO_PASSCRED));
    /* Receive SCM_CREDENTIALS messages */
    rb_define_const(rb_mSockConst, "SO_PASSCRED", INTEGER2NUM(SO_PASSCRED));
#endif
#if defined(SO_PEERCRED)
    /* The credentials of the foreign process connected to this socket */
    rb_define_const(rb_cSocket, "SO_PEERCRED", INTEGER2NUM(SO_PEERCRED));
    /* The credentials of the foreign process connected to this socket */
    rb_define_const(rb_mSockConst, "SO_PEERCRED", INTEGER2NUM(SO_PEERCRED));
#endif
#if defined(SO_RCVLOWAT)
    /* Receive low-water mark */
    rb_define_const(rb_cSocket, "SO_RCVLOWAT", INTEGER2NUM(SO_RCVLOWAT));
    /* Receive low-water mark */
    rb_define_const(rb_mSockConst, "SO_RCVLOWAT", INTEGER2NUM(SO_RCVLOWAT));
#endif
#if defined(SO_SNDLOWAT)
    /* Send low-water mark */
    rb_define_const(rb_cSocket, "SO_SNDLOWAT", INTEGER2NUM(SO_SNDLOWAT));
    /* Send low-water mark */
    rb_define_const(rb_mSockConst, "SO_SNDLOWAT", INTEGER2NUM(SO_SNDLOWAT));
#endif
#if defined(SO_RCVTIMEO)
    /* Receive timeout */
    rb_define_const(rb_cSocket, "SO_RCVTIMEO", INTEGER2NUM(SO_RCVTIMEO));
    /* Receive timeout */
    rb_define_const(rb_mSockConst, "SO_RCVTIMEO", INTEGER2NUM(SO_RCVTIMEO));
#endif
#if defined(SO_SNDTIMEO)
    /* Send timeout */
    rb_define_const(rb_cSocket, "SO_SNDTIMEO", INTEGER2NUM(SO_SNDTIMEO));
    /* Send timeout */
    rb_define_const(rb_mSockConst, "SO_SNDTIMEO", INTEGER2NUM(SO_SNDTIMEO));
#endif
#if defined(SO_ACCEPTCONN)
    /* Socket has had listen() called on it */
    rb_define_const(rb_cSocket, "SO_ACCEPTCONN", INTEGER2NUM(SO_ACCEPTCONN));
    /* Socket has had listen() called on it */
    rb_define_const(rb_mSockConst, "SO_ACCEPTCONN", INTEGER2NUM(SO_ACCEPTCONN));
#endif
#if defined(SO_USELOOPBACK)
    /* Bypass hardware when possible */
    rb_define_const(rb_cSocket, "SO_USELOOPBACK", INTEGER2NUM(SO_USELOOPBACK));
    /* Bypass hardware when possible */
    rb_define_const(rb_mSockConst, "SO_USELOOPBACK", INTEGER2NUM(SO_USELOOPBACK));
#endif
#if defined(SO_ACCEPTFILTER)
    /* There is an accept filter */
    rb_define_const(rb_cSocket, "SO_ACCEPTFILTER", INTEGER2NUM(SO_ACCEPTFILTER));
    /* There is an accept filter */
    rb_define_const(rb_mSockConst, "SO_ACCEPTFILTER", INTEGER2NUM(SO_ACCEPTFILTER));
#endif
#if defined(SO_DONTTRUNC)
    /* Retain unread data */
    rb_define_const(rb_cSocket, "SO_DONTTRUNC", INTEGER2NUM(SO_DONTTRUNC));
    /* Retain unread data */
    rb_define_const(rb_mSockConst, "SO_DONTTRUNC", INTEGER2NUM(SO_DONTTRUNC));
#endif
#if defined(SO_WANTMORE)
    /* Give a hint when more data is ready */
    rb_define_const(rb_cSocket, "SO_WANTMORE", INTEGER2NUM(SO_WANTMORE));
    /* Give a hint when more data is ready */
    rb_define_const(rb_mSockConst, "SO_WANTMORE", INTEGER2NUM(SO_WANTMORE));
#endif
#if defined(SO_WANTOOBFLAG)
    /* OOB data is wanted in MSG_FLAG on receive */
    rb_define_const(rb_cSocket, "SO_WANTOOBFLAG", INTEGER2NUM(SO_WANTOOBFLAG));
    /* OOB data is wanted in MSG_FLAG on receive */
    rb_define_const(rb_mSockConst, "SO_WANTOOBFLAG", INTEGER2NUM(SO_WANTOOBFLAG));
#endif
#if defined(SO_NREAD)
    /* Get first packet byte count */
    rb_define_const(rb_cSocket, "SO_NREAD", INTEGER2NUM(SO_NREAD));
    /* Get first packet byte count */
    rb_define_const(rb_mSockConst, "SO_NREAD", INTEGER2NUM(SO_NREAD));
#endif
#if defined(SO_NKE)
    /* Install socket-level Network Kernel Extension */
    rb_define_const(rb_cSocket, "SO_NKE", INTEGER2NUM(SO_NKE));
    /* Install socket-level Network Kernel Extension */
    rb_define_const(rb_mSockConst, "SO_NKE", INTEGER2NUM(SO_NKE));
#endif
#if defined(SO_NOSIGPIPE)
    /* Don't SIGPIPE on EPIPE */
    rb_define_const(rb_cSocket, "SO_NOSIGPIPE", INTEGER2NUM(SO_NOSIGPIPE));
    /* Don't SIGPIPE on EPIPE */
    rb_define_const(rb_mSockConst, "SO_NOSIGPIPE", INTEGER2NUM(SO_NOSIGPIPE));
#endif
#if defined(SO_SECURITY_AUTHENTICATION)
    /*  */
    rb_define_const(rb_cSocket, "SO_SECURITY_AUTHENTICATION", INTEGER2NUM(SO_SECURITY_AUTHENTICATION));
    /*  */
    rb_define_const(rb_mSockConst, "SO_SECURITY_AUTHENTICATION", INTEGER2NUM(SO_SECURITY_AUTHENTICATION));
#endif
#if defined(SO_SECURITY_ENCRYPTION_TRANSPORT)
    /*  */
    rb_define_const(rb_cSocket, "SO_SECURITY_ENCRYPTION_TRANSPORT", INTEGER2NUM(SO_SECURITY_ENCRYPTION_TRANSPORT));
    /*  */
    rb_define_const(rb_mSockConst, "SO_SECURITY_ENCRYPTION_TRANSPORT", INTEGER2NUM(SO_SECURITY_ENCRYPTION_TRANSPORT));
#endif
#if defined(SO_SECURITY_ENCRYPTION_NETWORK)
    /*  */
    rb_define_const(rb_cSocket, "SO_SECURITY_ENCRYPTION_NETWORK", INTEGER2NUM(SO_SECURITY_ENCRYPTION_NETWORK));
    /*  */
    rb_define_const(rb_mSockConst, "SO_SECURITY_ENCRYPTION_NETWORK", INTEGER2NUM(SO_SECURITY_ENCRYPTION_NETWORK));
#endif
#if defined(SO_BINDTODEVICE)
    /* Only send packets from the given interface */
    rb_define_const(rb_cSocket, "SO_BINDTODEVICE", INTEGER2NUM(SO_BINDTODEVICE));
    /* Only send packets from the given interface */
    rb_define_const(rb_mSockConst, "SO_BINDTODEVICE", INTEGER2NUM(SO_BINDTODEVICE));
#endif
#if defined(SO_ATTACH_FILTER)
    /* Attach an accept filter */
    rb_define_const(rb_cSocket, "SO_ATTACH_FILTER", INTEGER2NUM(SO_ATTACH_FILTER));
    /* Attach an accept filter */
    rb_define_const(rb_mSockConst, "SO_ATTACH_FILTER", INTEGER2NUM(SO_ATTACH_FILTER));
#endif
#if defined(SO_DETACH_FILTER)
    /* Detach an accept filter */
    rb_define_const(rb_cSocket, "SO_DETACH_FILTER", INTEGER2NUM(SO_DETACH_FILTER));
    /* Detach an accept filter */
    rb_define_const(rb_mSockConst, "SO_DETACH_FILTER", INTEGER2NUM(SO_DETACH_FILTER));
#endif
#if defined(SO_GET_FILTER)
    /* Obtain filter set by SO_ATTACH_FILTER (Linux 3.8) */
    rb_define_const(rb_cSocket, "SO_GET_FILTER", INTEGER2NUM(SO_GET_FILTER));
    /* Obtain filter set by SO_ATTACH_FILTER (Linux 3.8) */
    rb_define_const(rb_mSockConst, "SO_GET_FILTER", INTEGER2NUM(SO_GET_FILTER));
#endif
#if defined(SO_PEERNAME)
    /* Name of the connecting user */
    rb_define_const(rb_cSocket, "SO_PEERNAME", INTEGER2NUM(SO_PEERNAME));
    /* Name of the connecting user */
    rb_define_const(rb_mSockConst, "SO_PEERNAME", INTEGER2NUM(SO_PEERNAME));
#endif
#if defined(SO_TIMESTAMP)
    /* Receive timestamp with datagrams (timeval) */
    rb_define_const(rb_cSocket, "SO_TIMESTAMP", INTEGER2NUM(SO_TIMESTAMP));
    /* Receive timestamp with datagrams (timeval) */
    rb_define_const(rb_mSockConst, "SO_TIMESTAMP", INTEGER2NUM(SO_TIMESTAMP));
#endif
#if defined(SO_TIMESTAMPNS)
    /* Receive nanosecond timestamp with datagrams (timespec) */
    rb_define_const(rb_cSocket, "SO_TIMESTAMPNS", INTEGER2NUM(SO_TIMESTAMPNS));
    /* Receive nanosecond timestamp with datagrams (timespec) */
    rb_define_const(rb_mSockConst, "SO_TIMESTAMPNS", INTEGER2NUM(SO_TIMESTAMPNS));
#endif
#if defined(SO_BINTIME)
    /* Receive timestamp with datagrams (bintime) */
    rb_define_const(rb_cSocket, "SO_BINTIME", INTEGER2NUM(SO_BINTIME));
    /* Receive timestamp with datagrams (bintime) */
    rb_define_const(rb_mSockConst, "SO_BINTIME", INTEGER2NUM(SO_BINTIME));
#endif
#if defined(SO_RECVUCRED)
    /* Receive user credentials with datagram */
    rb_define_const(rb_cSocket, "SO_RECVUCRED", INTEGER2NUM(SO_RECVUCRED));
    /* Receive user credentials with datagram */
    rb_define_const(rb_mSockConst, "SO_RECVUCRED", INTEGER2NUM(SO_RECVUCRED));
#endif
#if defined(SO_MAC_EXEMPT)
    /* Mandatory Access Control exemption for unlabeled peers */
    rb_define_const(rb_cSocket, "SO_MAC_EXEMPT", INTEGER2NUM(SO_MAC_EXEMPT));
    /* Mandatory Access Control exemption for unlabeled peers */
    rb_define_const(rb_mSockConst, "SO_MAC_EXEMPT", INTEGER2NUM(SO_MAC_EXEMPT));
#endif
#if defined(SO_ALLZONES)
    /* Bypass zone boundaries */
    rb_define_const(rb_cSocket, "SO_ALLZONES", INTEGER2NUM(SO_ALLZONES));
    /* Bypass zone boundaries */
    rb_define_const(rb_mSockConst, "SO_ALLZONES", INTEGER2NUM(SO_ALLZONES));
#endif
#if defined(SO_PEERSEC)
    /* Obtain the security credentials (Linux 2.6.2) */
    rb_define_const(rb_cSocket, "SO_PEERSEC", INTEGER2NUM(SO_PEERSEC));
    /* Obtain the security credentials (Linux 2.6.2) */
    rb_define_const(rb_mSockConst, "SO_PEERSEC", INTEGER2NUM(SO_PEERSEC));
#endif
#if defined(SO_PASSSEC)
    /* Toggle security context passing (Linux 2.6.18) */
    rb_define_const(rb_cSocket, "SO_PASSSEC", INTEGER2NUM(SO_PASSSEC));
    /* Toggle security context passing (Linux 2.6.18) */
    rb_define_const(rb_mSockConst, "SO_PASSSEC", INTEGER2NUM(SO_PASSSEC));
#endif
#if defined(SO_MARK)
    /* Set the mark for mark-based routing (Linux 2.6.25) */
    rb_define_const(rb_cSocket, "SO_MARK", INTEGER2NUM(SO_MARK));
    /* Set the mark for mark-based routing (Linux 2.6.25) */
    rb_define_const(rb_mSockConst, "SO_MARK", INTEGER2NUM(SO_MARK));
#endif
#if defined(SO_TIMESTAMPING)
    /* Time stamping of incoming and outgoing packets (Linux 2.6.30) */
    rb_define_const(rb_cSocket, "SO_TIMESTAMPING", INTEGER2NUM(SO_TIMESTAMPING));
    /* Time stamping of incoming and outgoing packets (Linux 2.6.30) */
    rb_define_const(rb_mSockConst, "SO_TIMESTAMPING", INTEGER2NUM(SO_TIMESTAMPING));
#endif
#if defined(SO_PROTOCOL)
    /* Protocol given for socket() (Linux 2.6.32) */
    rb_define_const(rb_cSocket, "SO_PROTOCOL", INTEGER2NUM(SO_PROTOCOL));
    /* Protocol given for socket() (Linux 2.6.32) */
    rb_define_const(rb_mSockConst, "SO_PROTOCOL", INTEGER2NUM(SO_PROTOCOL));
#endif
#if defined(SO_DOMAIN)
    /* Domain given for socket() (Linux 2.6.32) */
    rb_define_const(rb_cSocket, "SO_DOMAIN", INTEGER2NUM(SO_DOMAIN));
    /* Domain given for socket() (Linux 2.6.32) */
    rb_define_const(rb_mSockConst, "SO_DOMAIN", INTEGER2NUM(SO_DOMAIN));
#endif
#if defined(SO_RXQ_OVFL)
    /* Toggle cmsg for number of packets dropped (Linux 2.6.33) */
    rb_define_const(rb_cSocket, "SO_RXQ_OVFL", INTEGER2NUM(SO_RXQ_OVFL));
    /* Toggle cmsg for number of packets dropped (Linux 2.6.33) */
    rb_define_const(rb_mSockConst, "SO_RXQ_OVFL", INTEGER2NUM(SO_RXQ_OVFL));
#endif
#if defined(SO_WIFI_STATUS)
    /* Toggle cmsg for wifi status (Linux 3.3) */
    rb_define_const(rb_cSocket, "SO_WIFI_STATUS", INTEGER2NUM(SO_WIFI_STATUS));
    /* Toggle cmsg for wifi status (Linux 3.3) */
    rb_define_const(rb_mSockConst, "SO_WIFI_STATUS", INTEGER2NUM(SO_WIFI_STATUS));
#endif
#if defined(SO_PEEK_OFF)
    /* Set the peek offset (Linux 3.4) */
    rb_define_const(rb_cSocket, "SO_PEEK_OFF", INTEGER2NUM(SO_PEEK_OFF));
    /* Set the peek offset (Linux 3.4) */
    rb_define_const(rb_mSockConst, "SO_PEEK_OFF", INTEGER2NUM(SO_PEEK_OFF));
#endif
#if defined(SO_NOFCS)
    /* Set netns of a socket (Linux 3.4) */
    rb_define_const(rb_cSocket, "SO_NOFCS", INTEGER2NUM(SO_NOFCS));
    /* Set netns of a socket (Linux 3.4) */
    rb_define_const(rb_mSockConst, "SO_NOFCS", INTEGER2NUM(SO_NOFCS));
#endif
#if defined(SO_LOCK_FILTER)
    /* Lock the filter attached to a socket (Linux 3.9) */
    rb_define_const(rb_cSocket, "SO_LOCK_FILTER", INTEGER2NUM(SO_LOCK_FILTER));
    /* Lock the filter attached to a socket (Linux 3.9) */
    rb_define_const(rb_mSockConst, "SO_LOCK_FILTER", INTEGER2NUM(SO_LOCK_FILTER));
#endif
#if defined(SO_SELECT_ERR_QUEUE)
    /* Make select() detect socket error queue with errorfds (Linux 3.10) */
    rb_define_const(rb_cSocket, "SO_SELECT_ERR_QUEUE", INTEGER2NUM(SO_SELECT_ERR_QUEUE));
    /* Make select() detect socket error queue with errorfds (Linux 3.10) */
    rb_define_const(rb_mSockConst, "SO_SELECT_ERR_QUEUE", INTEGER2NUM(SO_SELECT_ERR_QUEUE));
#endif
#if defined(SO_BUSY_POLL)
    /* Set the threshold in microseconds for low latency polling (Linux 3.11) */
    rb_define_const(rb_cSocket, "SO_BUSY_POLL", INTEGER2NUM(SO_BUSY_POLL));
    /* Set the threshold in microseconds for low latency polling (Linux 3.11) */
    rb_define_const(rb_mSockConst, "SO_BUSY_POLL", INTEGER2NUM(SO_BUSY_POLL));
#endif
#if defined(SO_MAX_PACING_RATE)
    /* Cap the rate computed by transport layer. [bytes per second] (Linux 3.13) */
    rb_define_const(rb_cSocket, "SO_MAX_PACING_RATE", INTEGER2NUM(SO_MAX_PACING_RATE));
    /* Cap the rate computed by transport layer. [bytes per second] (Linux 3.13) */
    rb_define_const(rb_mSockConst, "SO_MAX_PACING_RATE", INTEGER2NUM(SO_MAX_PACING_RATE));
#endif
#if defined(SO_BPF_EXTENSIONS)
    /* Query supported BPF extensions (Linux 3.14) */
    rb_define_const(rb_cSocket, "SO_BPF_EXTENSIONS", INTEGER2NUM(SO_BPF_EXTENSIONS));
    /* Query supported BPF extensions (Linux 3.14) */
    rb_define_const(rb_mSockConst, "SO_BPF_EXTENSIONS", INTEGER2NUM(SO_BPF_EXTENSIONS));
#endif
#if defined(SOPRI_INTERACTIVE)
    /* Interactive socket priority */
    rb_define_const(rb_cSocket, "SOPRI_INTERACTIVE", INTEGER2NUM(SOPRI_INTERACTIVE));
    /* Interactive socket priority */
    rb_define_const(rb_mSockConst, "SOPRI_INTERACTIVE", INTEGER2NUM(SOPRI_INTERACTIVE));
#endif
#if defined(SOPRI_NORMAL)
    /* Normal socket priority */
    rb_define_const(rb_cSocket, "SOPRI_NORMAL", INTEGER2NUM(SOPRI_NORMAL));
    /* Normal socket priority */
    rb_define_const(rb_mSockConst, "SOPRI_NORMAL", INTEGER2NUM(SOPRI_NORMAL));
#endif
#if defined(SOPRI_BACKGROUND)
    /* Background socket priority */
    rb_define_const(rb_cSocket, "SOPRI_BACKGROUND", INTEGER2NUM(SOPRI_BACKGROUND));
    /* Background socket priority */
    rb_define_const(rb_mSockConst, "SOPRI_BACKGROUND", INTEGER2NUM(SOPRI_BACKGROUND));
#endif
#if defined(IPX_TYPE)
    /*  */
    rb_define_const(rb_cSocket, "IPX_TYPE", INTEGER2NUM(IPX_TYPE));
    /*  */
    rb_define_const(rb_mSockConst, "IPX_TYPE", INTEGER2NUM(IPX_TYPE));
#endif
#if defined(TCP_NODELAY)
    /* Don't delay sending to coalesce packets */
    rb_define_const(rb_cSocket, "TCP_NODELAY", INTEGER2NUM(TCP_NODELAY));
    /* Don't delay sending to coalesce packets */
    rb_define_const(rb_mSockConst, "TCP_NODELAY", INTEGER2NUM(TCP_NODELAY));
#endif
#if defined(TCP_MAXSEG)
    /* Set maximum segment size */
    rb_define_const(rb_cSocket, "TCP_MAXSEG", INTEGER2NUM(TCP_MAXSEG));
    /* Set maximum segment size */
    rb_define_const(rb_mSockConst, "TCP_MAXSEG", INTEGER2NUM(TCP_MAXSEG));
#endif
#if defined(TCP_CORK)
    /* Don't send partial frames (Linux 2.2, glibc 2.2) */
    rb_define_const(rb_cSocket, "TCP_CORK", INTEGER2NUM(TCP_CORK));
    /* Don't send partial frames (Linux 2.2, glibc 2.2) */
    rb_define_const(rb_mSockConst, "TCP_CORK", INTEGER2NUM(TCP_CORK));
#endif
#if defined(TCP_DEFER_ACCEPT)
    /* Don't notify a listening socket until data is ready (Linux 2.4, glibc 2.2) */
    rb_define_const(rb_cSocket, "TCP_DEFER_ACCEPT", INTEGER2NUM(TCP_DEFER_ACCEPT));
    /* Don't notify a listening socket until data is ready (Linux 2.4, glibc 2.2) */
    rb_define_const(rb_mSockConst, "TCP_DEFER_ACCEPT", INTEGER2NUM(TCP_DEFER_ACCEPT));
#endif
#if defined(TCP_INFO)
    /* Retrieve information about this socket (Linux 2.4, glibc 2.2) */
    rb_define_const(rb_cSocket, "TCP_INFO", INTEGER2NUM(TCP_INFO));
    /* Retrieve information about this socket (Linux 2.4, glibc 2.2) */
    rb_define_const(rb_mSockConst, "TCP_INFO", INTEGER2NUM(TCP_INFO));
#endif
#if defined(TCP_KEEPCNT)
    /* Maximum number of keepalive probes allowed before dropping a connection (Linux 2.4, glibc 2.2) */
    rb_define_const(rb_cSocket, "TCP_KEEPCNT", INTEGER2NUM(TCP_KEEPCNT));
    /* Maximum number of keepalive probes allowed before dropping a connection (Linux 2.4, glibc 2.2) */
    rb_define_const(rb_mSockConst, "TCP_KEEPCNT", INTEGER2NUM(TCP_KEEPCNT));
#endif
#if defined(TCP_KEEPIDLE)
    /* Idle time before keepalive probes are sent (Linux 2.4, glibc 2.2) */
    rb_define_const(rb_cSocket, "TCP_KEEPIDLE", INTEGER2NUM(TCP_KEEPIDLE));
    /* Idle time before keepalive probes are sent (Linux 2.4, glibc 2.2) */
    rb_define_const(rb_mSockConst, "TCP_KEEPIDLE", INTEGER2NUM(TCP_KEEPIDLE));
#endif
#if defined(TCP_KEEPINTVL)
    /* Time between keepalive probes (Linux 2.4, glibc 2.2) */
    rb_define_const(rb_cSocket, "TCP_KEEPINTVL", INTEGER2NUM(TCP_KEEPINTVL));
    /* Time between keepalive probes (Linux 2.4, glibc 2.2) */
    rb_define_const(rb_mSockConst, "TCP_KEEPINTVL", INTEGER2NUM(TCP_KEEPINTVL));
#endif
#if defined(TCP_LINGER2)
    /* Lifetime of orphaned FIN_WAIT2 sockets (Linux 2.4, glibc 2.2) */
    rb_define_const(rb_cSocket, "TCP_LINGER2", INTEGER2NUM(TCP_LINGER2));
    /* Lifetime of orphaned FIN_WAIT2 sockets (Linux 2.4, glibc 2.2) */
    rb_define_const(rb_mSockConst, "TCP_LINGER2", INTEGER2NUM(TCP_LINGER2));
#endif
#if defined(TCP_MD5SIG)
    /* Use MD5 digests (RFC2385, Linux 2.6.20, glibc 2.7) */
    rb_define_const(rb_cSocket, "TCP_MD5SIG", INTEGER2NUM(TCP_MD5SIG));
    /* Use MD5 digests (RFC2385, Linux 2.6.20, glibc 2.7) */
    rb_define_const(rb_mSockConst, "TCP_MD5SIG", INTEGER2NUM(TCP_MD5SIG));
#endif
#if defined(TCP_NOOPT)
    /* Don't use TCP options */
    rb_define_const(rb_cSocket, "TCP_NOOPT", INTEGER2NUM(TCP_NOOPT));
    /* Don't use TCP options */
    rb_define_const(rb_mSockConst, "TCP_NOOPT", INTEGER2NUM(TCP_NOOPT));
#endif
#if defined(TCP_NOPUSH)
    /* Don't push the last block of write */
    rb_define_const(rb_cSocket, "TCP_NOPUSH", INTEGER2NUM(TCP_NOPUSH));
    /* Don't push the last block of write */
    rb_define_const(rb_mSockConst, "TCP_NOPUSH", INTEGER2NUM(TCP_NOPUSH));
#endif
#if defined(TCP_QUICKACK)
    /* Enable quickack mode (Linux 2.4.4, glibc 2.3) */
    rb_define_const(rb_cSocket, "TCP_QUICKACK", INTEGER2NUM(TCP_QUICKACK));
    /* Enable quickack mode (Linux 2.4.4, glibc 2.3) */
    rb_define_const(rb_mSockConst, "TCP_QUICKACK", INTEGER2NUM(TCP_QUICKACK));
#endif
#if defined(TCP_SYNCNT)
    /* Number of SYN retransmits before a connection is dropped (Linux 2.4, glibc 2.2) */
    rb_define_const(rb_cSocket, "TCP_SYNCNT", INTEGER2NUM(TCP_SYNCNT));
    /* Number of SYN retransmits before a connection is dropped (Linux 2.4, glibc 2.2) */
    rb_define_const(rb_mSockConst, "TCP_SYNCNT", INTEGER2NUM(TCP_SYNCNT));
#endif
#if defined(TCP_WINDOW_CLAMP)
    /* Clamp the size of the advertised window (Linux 2.4, glibc 2.2) */
    rb_define_const(rb_cSocket, "TCP_WINDOW_CLAMP", INTEGER2NUM(TCP_WINDOW_CLAMP));
    /* Clamp the size of the advertised window (Linux 2.4, glibc 2.2) */
    rb_define_const(rb_mSockConst, "TCP_WINDOW_CLAMP", INTEGER2NUM(TCP_WINDOW_CLAMP));
#endif
#if defined(TCP_FASTOPEN)
    /* Reduce step of the handshake process (Linux 3.7, glibc 2.18) */
    rb_define_const(rb_cSocket, "TCP_FASTOPEN", INTEGER2NUM(TCP_FASTOPEN));
    /* Reduce step of the handshake process (Linux 3.7, glibc 2.18) */
    rb_define_const(rb_mSockConst, "TCP_FASTOPEN", INTEGER2NUM(TCP_FASTOPEN));
#endif
#if defined(TCP_CONGESTION)
    /* TCP congestion control algorithm (Linux 2.6.13, glibc 2.6) */
    rb_define_const(rb_cSocket, "TCP_CONGESTION", INTEGER2NUM(TCP_CONGESTION));
    /* TCP congestion control algorithm (Linux 2.6.13, glibc 2.6) */
    rb_define_const(rb_mSockConst, "TCP_CONGESTION", INTEGER2NUM(TCP_CONGESTION));
#endif
#if defined(TCP_COOKIE_TRANSACTIONS)
    /* TCP Cookie Transactions (Linux 2.6.33, glibc 2.18) */
    rb_define_const(rb_cSocket, "TCP_COOKIE_TRANSACTIONS", INTEGER2NUM(TCP_COOKIE_TRANSACTIONS));
    /* TCP Cookie Transactions (Linux 2.6.33, glibc 2.18) */
    rb_define_const(rb_mSockConst, "TCP_COOKIE_TRANSACTIONS", INTEGER2NUM(TCP_COOKIE_TRANSACTIONS));
#endif
#if defined(TCP_QUEUE_SEQ)
    /* Sequence of a queue for repair mode (Linux 3.5, glibc 2.18) */
    rb_define_const(rb_cSocket, "TCP_QUEUE_SEQ", INTEGER2NUM(TCP_QUEUE_SEQ));
    /* Sequence of a queue for repair mode (Linux 3.5, glibc 2.18) */
    rb_define_const(rb_mSockConst, "TCP_QUEUE_SEQ", INTEGER2NUM(TCP_QUEUE_SEQ));
#endif
#if defined(TCP_REPAIR)
    /* Repair mode (Linux 3.5, glibc 2.18) */
    rb_define_const(rb_cSocket, "TCP_REPAIR", INTEGER2NUM(TCP_REPAIR));
    /* Repair mode (Linux 3.5, glibc 2.18) */
    rb_define_const(rb_mSockConst, "TCP_REPAIR", INTEGER2NUM(TCP_REPAIR));
#endif
#if defined(TCP_REPAIR_OPTIONS)
    /* Options for repair mode (Linux 3.5, glibc 2.18) */
    rb_define_const(rb_cSocket, "TCP_REPAIR_OPTIONS", INTEGER2NUM(TCP_REPAIR_OPTIONS));
    /* Options for repair mode (Linux 3.5, glibc 2.18) */
    rb_define_const(rb_mSockConst, "TCP_REPAIR_OPTIONS", INTEGER2NUM(TCP_REPAIR_OPTIONS));
#endif
#if defined(TCP_REPAIR_QUEUE)
    /* Queue for repair mode (Linux 3.5, glibc 2.18) */
    rb_define_const(rb_cSocket, "TCP_REPAIR_QUEUE", INTEGER2NUM(TCP_REPAIR_QUEUE));
    /* Queue for repair mode (Linux 3.5, glibc 2.18) */
    rb_define_const(rb_mSockConst, "TCP_REPAIR_QUEUE", INTEGER2NUM(TCP_REPAIR_QUEUE));
#endif
#if defined(TCP_THIN_DUPACK)
    /* Duplicated acknowledgments handling for thin-streams (Linux 2.6.34, glibc 2.18) */
    rb_define_const(rb_cSocket, "TCP_THIN_DUPACK", INTEGER2NUM(TCP_THIN_DUPACK));
    /* Duplicated acknowledgments handling for thin-streams (Linux 2.6.34, glibc 2.18) */
    rb_define_const(rb_mSockConst, "TCP_THIN_DUPACK", INTEGER2NUM(TCP_THIN_DUPACK));
#endif
#if defined(TCP_THIN_LINEAR_TIMEOUTS)
    /* Linear timeouts for thin-streams (Linux 2.6.34, glibc 2.18) */
    rb_define_const(rb_cSocket, "TCP_THIN_LINEAR_TIMEOUTS", INTEGER2NUM(TCP_THIN_LINEAR_TIMEOUTS));
    /* Linear timeouts for thin-streams (Linux 2.6.34, glibc 2.18) */
    rb_define_const(rb_mSockConst, "TCP_THIN_LINEAR_TIMEOUTS", INTEGER2NUM(TCP_THIN_LINEAR_TIMEOUTS));
#endif
#if defined(TCP_TIMESTAMP)
    /* TCP timestamp (Linux 3.9, glibc 2.18) */
    rb_define_const(rb_cSocket, "TCP_TIMESTAMP", INTEGER2NUM(TCP_TIMESTAMP));
    /* TCP timestamp (Linux 3.9, glibc 2.18) */
    rb_define_const(rb_mSockConst, "TCP_TIMESTAMP", INTEGER2NUM(TCP_TIMESTAMP));
#endif
#if defined(TCP_USER_TIMEOUT)
    /* Max timeout before a TCP connection is aborted (Linux 2.6.37, glibc 2.18) */
    rb_define_const(rb_cSocket, "TCP_USER_TIMEOUT", INTEGER2NUM(TCP_USER_TIMEOUT));
    /* Max timeout before a TCP connection is aborted (Linux 2.6.37, glibc 2.18) */
    rb_define_const(rb_mSockConst, "TCP_USER_TIMEOUT", INTEGER2NUM(TCP_USER_TIMEOUT));
#endif
#if defined(UDP_CORK)
    /* Don't send partial frames (Linux 2.5.44, glibc 2.11) */
    rb_define_const(rb_cSocket, "UDP_CORK", INTEGER2NUM(UDP_CORK));
    /* Don't send partial frames (Linux 2.5.44, glibc 2.11) */
    rb_define_const(rb_mSockConst, "UDP_CORK", INTEGER2NUM(UDP_CORK));
#endif
#if defined(EAI_ADDRFAMILY)
    /* Address family for hostname not supported */
    rb_define_const(rb_cSocket, "EAI_ADDRFAMILY", INTEGER2NUM(EAI_ADDRFAMILY));
    /* Address family for hostname not supported */
    rb_define_const(rb_mSockConst, "EAI_ADDRFAMILY", INTEGER2NUM(EAI_ADDRFAMILY));
#endif
#if defined(EAI_AGAIN)
    /* Temporary failure in name resolution */
    rb_define_const(rb_cSocket, "EAI_AGAIN", INTEGER2NUM(EAI_AGAIN));
    /* Temporary failure in name resolution */
    rb_define_const(rb_mSockConst, "EAI_AGAIN", INTEGER2NUM(EAI_AGAIN));
#endif
#if defined(EAI_BADFLAGS)
    /* Invalid flags */
    rb_define_const(rb_cSocket, "EAI_BADFLAGS", INTEGER2NUM(EAI_BADFLAGS));
    /* Invalid flags */
    rb_define_const(rb_mSockConst, "EAI_BADFLAGS", INTEGER2NUM(EAI_BADFLAGS));
#endif
#if defined(EAI_FAIL)
    /* Non-recoverable failure in name resolution */
    rb_define_const(rb_cSocket, "EAI_FAIL", INTEGER2NUM(EAI_FAIL));
    /* Non-recoverable failure in name resolution */
    rb_define_const(rb_mSockConst, "EAI_FAIL", INTEGER2NUM(EAI_FAIL));
#endif
#if defined(EAI_FAMILY)
    /* Address family not supported */
    rb_define_const(rb_cSocket, "EAI_FAMILY", INTEGER2NUM(EAI_FAMILY));
    /* Address family not supported */
    rb_define_const(rb_mSockConst, "EAI_FAMILY", INTEGER2NUM(EAI_FAMILY));
#endif
#if defined(EAI_MEMORY)
    /* Memory allocation failure */
    rb_define_const(rb_cSocket, "EAI_MEMORY", INTEGER2NUM(EAI_MEMORY));
    /* Memory allocation failure */
    rb_define_const(rb_mSockConst, "EAI_MEMORY", INTEGER2NUM(EAI_MEMORY));
#endif
#if defined(EAI_NODATA)
    /* No address associated with hostname */
    rb_define_const(rb_cSocket, "EAI_NODATA", INTEGER2NUM(EAI_NODATA));
    /* No address associated with hostname */
    rb_define_const(rb_mSockConst, "EAI_NODATA", INTEGER2NUM(EAI_NODATA));
#endif
#if defined(EAI_NONAME)
    /* Hostname nor servname, or not known */
    rb_define_const(rb_cSocket, "EAI_NONAME", INTEGER2NUM(EAI_NONAME));
    /* Hostname nor servname, or not known */
    rb_define_const(rb_mSockConst, "EAI_NONAME", INTEGER2NUM(EAI_NONAME));
#endif
#if defined(EAI_OVERFLOW)
    /* Argument buffer overflow */
    rb_define_const(rb_cSocket, "EAI_OVERFLOW", INTEGER2NUM(EAI_OVERFLOW));
    /* Argument buffer overflow */
    rb_define_const(rb_mSockConst, "EAI_OVERFLOW", INTEGER2NUM(EAI_OVERFLOW));
#endif
#if defined(EAI_SERVICE)
    /* Servname not supported for socket type */
    rb_define_const(rb_cSocket, "EAI_SERVICE", INTEGER2NUM(EAI_SERVICE));
    /* Servname not supported for socket type */
    rb_define_const(rb_mSockConst, "EAI_SERVICE", INTEGER2NUM(EAI_SERVICE));
#endif
#if defined(EAI_SOCKTYPE)
    /* Socket type not supported */
    rb_define_const(rb_cSocket, "EAI_SOCKTYPE", INTEGER2NUM(EAI_SOCKTYPE));
    /* Socket type not supported */
    rb_define_const(rb_mSockConst, "EAI_SOCKTYPE", INTEGER2NUM(EAI_SOCKTYPE));
#endif
#if defined(EAI_SYSTEM)
    /* System error returned in errno */
    rb_define_const(rb_cSocket, "EAI_SYSTEM", INTEGER2NUM(EAI_SYSTEM));
    /* System error returned in errno */
    rb_define_const(rb_mSockConst, "EAI_SYSTEM", INTEGER2NUM(EAI_SYSTEM));
#endif
#if defined(EAI_BADHINTS)
    /* Invalid value for hints */
    rb_define_const(rb_cSocket, "EAI_BADHINTS", INTEGER2NUM(EAI_BADHINTS));
    /* Invalid value for hints */
    rb_define_const(rb_mSockConst, "EAI_BADHINTS", INTEGER2NUM(EAI_BADHINTS));
#endif
#if defined(EAI_PROTOCOL)
    /* Resolved protocol is unknown */
    rb_define_const(rb_cSocket, "EAI_PROTOCOL", INTEGER2NUM(EAI_PROTOCOL));
    /* Resolved protocol is unknown */
    rb_define_const(rb_mSockConst, "EAI_PROTOCOL", INTEGER2NUM(EAI_PROTOCOL));
#endif
#if defined(EAI_MAX)
    /* Maximum error code from getaddrinfo */
    rb_define_const(rb_cSocket, "EAI_MAX", INTEGER2NUM(EAI_MAX));
    /* Maximum error code from getaddrinfo */
    rb_define_const(rb_mSockConst, "EAI_MAX", INTEGER2NUM(EAI_MAX));
#endif
#if defined(AI_PASSIVE)
    /* Get address to use with bind() */
    rb_define_const(rb_cSocket, "AI_PASSIVE", INTEGER2NUM(AI_PASSIVE));
    /* Get address to use with bind() */
    rb_define_const(rb_mSockConst, "AI_PASSIVE", INTEGER2NUM(AI_PASSIVE));
#endif
#if defined(AI_CANONNAME)
    /* Fill in the canonical name */
    rb_define_const(rb_cSocket, "AI_CANONNAME", INTEGER2NUM(AI_CANONNAME));
    /* Fill in the canonical name */
    rb_define_const(rb_mSockConst, "AI_CANONNAME", INTEGER2NUM(AI_CANONNAME));
#endif
#if defined(AI_NUMERICHOST)
    /* Prevent host name resolution */
    rb_define_const(rb_cSocket, "AI_NUMERICHOST", INTEGER2NUM(AI_NUMERICHOST));
    /* Prevent host name resolution */
    rb_define_const(rb_mSockConst, "AI_NUMERICHOST", INTEGER2NUM(AI_NUMERICHOST));
#endif
#if defined(AI_NUMERICSERV)
    /* Prevent service name resolution */
    rb_define_const(rb_cSocket, "AI_NUMERICSERV", INTEGER2NUM(AI_NUMERICSERV));
    /* Prevent service name resolution */
    rb_define_const(rb_mSockConst, "AI_NUMERICSERV", INTEGER2NUM(AI_NUMERICSERV));
#endif
#if defined(AI_MASK)
    /* Valid flag mask for getaddrinfo (not for application use) */
    rb_define_const(rb_cSocket, "AI_MASK", INTEGER2NUM(AI_MASK));
    /* Valid flag mask for getaddrinfo (not for application use) */
    rb_define_const(rb_mSockConst, "AI_MASK", INTEGER2NUM(AI_MASK));
#endif
#if defined(AI_ALL)
    /* Allow all addresses */
    rb_define_const(rb_cSocket, "AI_ALL", INTEGER2NUM(AI_ALL));
    /* Allow all addresses */
    rb_define_const(rb_mSockConst, "AI_ALL", INTEGER2NUM(AI_ALL));
#endif
#if defined(AI_V4MAPPED_CFG)
    /* Accept IPv4 mapped addresses if the kernel supports it */
    rb_define_const(rb_cSocket, "AI_V4MAPPED_CFG", INTEGER2NUM(AI_V4MAPPED_CFG));
    /* Accept IPv4 mapped addresses if the kernel supports it */
    rb_define_const(rb_mSockConst, "AI_V4MAPPED_CFG", INTEGER2NUM(AI_V4MAPPED_CFG));
#endif
#if defined(AI_ADDRCONFIG)
    /* Accept only if any address is assigned */
    rb_define_const(rb_cSocket, "AI_ADDRCONFIG", INTEGER2NUM(AI_ADDRCONFIG));
    /* Accept only if any address is assigned */
    rb_define_const(rb_mSockConst, "AI_ADDRCONFIG", INTEGER2NUM(AI_ADDRCONFIG));
#endif
#if defined(AI_V4MAPPED)
    /* Accept IPv4-mapped IPv6 addresses */
    rb_define_const(rb_cSocket, "AI_V4MAPPED", INTEGER2NUM(AI_V4MAPPED));
    /* Accept IPv4-mapped IPv6 addresses */
    rb_define_const(rb_mSockConst, "AI_V4MAPPED", INTEGER2NUM(AI_V4MAPPED));
#endif
#if defined(AI_DEFAULT)
    /* Default flags for getaddrinfo */
    rb_define_const(rb_cSocket, "AI_DEFAULT", INTEGER2NUM(AI_DEFAULT));
    /* Default flags for getaddrinfo */
    rb_define_const(rb_mSockConst, "AI_DEFAULT", INTEGER2NUM(AI_DEFAULT));
#endif
#if defined(NI_MAXHOST)
    /* Maximum length of a hostname */
    rb_define_const(rb_cSocket, "NI_MAXHOST", INTEGER2NUM(NI_MAXHOST));
    /* Maximum length of a hostname */
    rb_define_const(rb_mSockConst, "NI_MAXHOST", INTEGER2NUM(NI_MAXHOST));
#endif
#if defined(NI_MAXSERV)
    /* Maximum length of a service name */
    rb_define_const(rb_cSocket, "NI_MAXSERV", INTEGER2NUM(NI_MAXSERV));
    /* Maximum length of a service name */
    rb_define_const(rb_mSockConst, "NI_MAXSERV", INTEGER2NUM(NI_MAXSERV));
#endif
#if defined(NI_NOFQDN)
    /* An FQDN is not required for local hosts, return only the local part */
    rb_define_const(rb_cSocket, "NI_NOFQDN", INTEGER2NUM(NI_NOFQDN));
    /* An FQDN is not required for local hosts, return only the local part */
    rb_define_const(rb_mSockConst, "NI_NOFQDN", INTEGER2NUM(NI_NOFQDN));
#endif
#if defined(NI_NUMERICHOST)
    /* Return a numeric address */
    rb_define_const(rb_cSocket, "NI_NUMERICHOST", INTEGER2NUM(NI_NUMERICHOST));
    /* Return a numeric address */
    rb_define_const(rb_mSockConst, "NI_NUMERICHOST", INTEGER2NUM(NI_NUMERICHOST));
#endif
#if defined(NI_NAMEREQD)
    /* A name is required */
    rb_define_const(rb_cSocket, "NI_NAMEREQD", INTEGER2NUM(NI_NAMEREQD));
    /* A name is required */
    rb_define_const(rb_mSockConst, "NI_NAMEREQD", INTEGER2NUM(NI_NAMEREQD));
#endif
#if defined(NI_NUMERICSERV)
    /* Return the service name as a digit string */
    rb_define_const(rb_cSocket, "NI_NUMERICSERV", INTEGER2NUM(NI_NUMERICSERV));
    /* Return the service name as a digit string */
    rb_define_const(rb_mSockConst, "NI_NUMERICSERV", INTEGER2NUM(NI_NUMERICSERV));
#endif
#if defined(NI_DGRAM)
    /* The service specified is a datagram service (looks up UDP ports) */
    rb_define_const(rb_cSocket, "NI_DGRAM", INTEGER2NUM(NI_DGRAM));
    /* The service specified is a datagram service (looks up UDP ports) */
    rb_define_const(rb_mSockConst, "NI_DGRAM", INTEGER2NUM(NI_DGRAM));
#endif
#if defined(SHUT_RD)
    /* Shut down the reading side of the socket */
    rb_define_const(rb_cSocket, "SHUT_RD", INTEGER2NUM(SHUT_RD));
    /* Shut down the reading side of the socket */
    rb_define_const(rb_mSockConst, "SHUT_RD", INTEGER2NUM(SHUT_RD));
#endif
#if defined(SHUT_WR)
    /* Shut down the writing side of the socket */
    rb_define_const(rb_cSocket, "SHUT_WR", INTEGER2NUM(SHUT_WR));
    /* Shut down the writing side of the socket */
    rb_define_const(rb_mSockConst, "SHUT_WR", INTEGER2NUM(SHUT_WR));
#endif
#if defined(SHUT_RDWR)
    /* Shut down the both sides of the socket */
    rb_define_const(rb_cSocket, "SHUT_RDWR", INTEGER2NUM(SHUT_RDWR));
    /* Shut down the both sides of the socket */
    rb_define_const(rb_mSockConst, "SHUT_RDWR", INTEGER2NUM(SHUT_RDWR));
#endif
#if defined(INET6)
#if defined(IPV6_JOIN_GROUP)
    /* Join a group membership */
    rb_define_const(rb_cSocket, "IPV6_JOIN_GROUP", INTEGER2NUM(IPV6_JOIN_GROUP));
    /* Join a group membership */
    rb_define_const(rb_mSockConst, "IPV6_JOIN_GROUP", INTEGER2NUM(IPV6_JOIN_GROUP));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_LEAVE_GROUP)
    /* Leave a group membership */
    rb_define_const(rb_cSocket, "IPV6_LEAVE_GROUP", INTEGER2NUM(IPV6_LEAVE_GROUP));
    /* Leave a group membership */
    rb_define_const(rb_mSockConst, "IPV6_LEAVE_GROUP", INTEGER2NUM(IPV6_LEAVE_GROUP));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_MULTICAST_HOPS)
    /* IP6 multicast hops */
    rb_define_const(rb_cSocket, "IPV6_MULTICAST_HOPS", INTEGER2NUM(IPV6_MULTICAST_HOPS));
    /* IP6 multicast hops */
    rb_define_const(rb_mSockConst, "IPV6_MULTICAST_HOPS", INTEGER2NUM(IPV6_MULTICAST_HOPS));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_MULTICAST_IF)
    /* IP6 multicast interface */
    rb_define_const(rb_cSocket, "IPV6_MULTICAST_IF", INTEGER2NUM(IPV6_MULTICAST_IF));
    /* IP6 multicast interface */
    rb_define_const(rb_mSockConst, "IPV6_MULTICAST_IF", INTEGER2NUM(IPV6_MULTICAST_IF));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_MULTICAST_LOOP)
    /* IP6 multicast loopback */
    rb_define_const(rb_cSocket, "IPV6_MULTICAST_LOOP", INTEGER2NUM(IPV6_MULTICAST_LOOP));
    /* IP6 multicast loopback */
    rb_define_const(rb_mSockConst, "IPV6_MULTICAST_LOOP", INTEGER2NUM(IPV6_MULTICAST_LOOP));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_UNICAST_HOPS)
    /* IP6 unicast hops */
    rb_define_const(rb_cSocket, "IPV6_UNICAST_HOPS", INTEGER2NUM(IPV6_UNICAST_HOPS));
    /* IP6 unicast hops */
    rb_define_const(rb_mSockConst, "IPV6_UNICAST_HOPS", INTEGER2NUM(IPV6_UNICAST_HOPS));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_V6ONLY)
    /* Only bind IPv6 with a wildcard bind */
    rb_define_const(rb_cSocket, "IPV6_V6ONLY", INTEGER2NUM(IPV6_V6ONLY));
    /* Only bind IPv6 with a wildcard bind */
    rb_define_const(rb_mSockConst, "IPV6_V6ONLY", INTEGER2NUM(IPV6_V6ONLY));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_CHECKSUM)
    /* Checksum offset for raw sockets */
    rb_define_const(rb_cSocket, "IPV6_CHECKSUM", INTEGER2NUM(IPV6_CHECKSUM));
    /* Checksum offset for raw sockets */
    rb_define_const(rb_mSockConst, "IPV6_CHECKSUM", INTEGER2NUM(IPV6_CHECKSUM));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_DONTFRAG)
    /* Don't fragment packets */
    rb_define_const(rb_cSocket, "IPV6_DONTFRAG", INTEGER2NUM(IPV6_DONTFRAG));
    /* Don't fragment packets */
    rb_define_const(rb_mSockConst, "IPV6_DONTFRAG", INTEGER2NUM(IPV6_DONTFRAG));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_DSTOPTS)
    /* Destination option */
    rb_define_const(rb_cSocket, "IPV6_DSTOPTS", INTEGER2NUM(IPV6_DSTOPTS));
    /* Destination option */
    rb_define_const(rb_mSockConst, "IPV6_DSTOPTS", INTEGER2NUM(IPV6_DSTOPTS));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_HOPLIMIT)
    /* Hop limit */
    rb_define_const(rb_cSocket, "IPV6_HOPLIMIT", INTEGER2NUM(IPV6_HOPLIMIT));
    /* Hop limit */
    rb_define_const(rb_mSockConst, "IPV6_HOPLIMIT", INTEGER2NUM(IPV6_HOPLIMIT));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_HOPOPTS)
    /* Hop-by-hop option */
    rb_define_const(rb_cSocket, "IPV6_HOPOPTS", INTEGER2NUM(IPV6_HOPOPTS));
    /* Hop-by-hop option */
    rb_define_const(rb_mSockConst, "IPV6_HOPOPTS", INTEGER2NUM(IPV6_HOPOPTS));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_NEXTHOP)
    /* Next hop address */
    rb_define_const(rb_cSocket, "IPV6_NEXTHOP", INTEGER2NUM(IPV6_NEXTHOP));
    /* Next hop address */
    rb_define_const(rb_mSockConst, "IPV6_NEXTHOP", INTEGER2NUM(IPV6_NEXTHOP));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_PATHMTU)
    /* Retrieve current path MTU */
    rb_define_const(rb_cSocket, "IPV6_PATHMTU", INTEGER2NUM(IPV6_PATHMTU));
    /* Retrieve current path MTU */
    rb_define_const(rb_mSockConst, "IPV6_PATHMTU", INTEGER2NUM(IPV6_PATHMTU));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_PKTINFO)
    /* Receive packet information with datagram */
    rb_define_const(rb_cSocket, "IPV6_PKTINFO", INTEGER2NUM(IPV6_PKTINFO));
    /* Receive packet information with datagram */
    rb_define_const(rb_mSockConst, "IPV6_PKTINFO", INTEGER2NUM(IPV6_PKTINFO));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_RECVDSTOPTS)
    /* Receive all IP6 options for response */
    rb_define_const(rb_cSocket, "IPV6_RECVDSTOPTS", INTEGER2NUM(IPV6_RECVDSTOPTS));
    /* Receive all IP6 options for response */
    rb_define_const(rb_mSockConst, "IPV6_RECVDSTOPTS", INTEGER2NUM(IPV6_RECVDSTOPTS));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_RECVHOPLIMIT)
    /* Receive hop limit with datagram */
    rb_define_const(rb_cSocket, "IPV6_RECVHOPLIMIT", INTEGER2NUM(IPV6_RECVHOPLIMIT));
    /* Receive hop limit with datagram */
    rb_define_const(rb_mSockConst, "IPV6_RECVHOPLIMIT", INTEGER2NUM(IPV6_RECVHOPLIMIT));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_RECVHOPOPTS)
    /* Receive hop-by-hop options */
    rb_define_const(rb_cSocket, "IPV6_RECVHOPOPTS", INTEGER2NUM(IPV6_RECVHOPOPTS));
    /* Receive hop-by-hop options */
    rb_define_const(rb_mSockConst, "IPV6_RECVHOPOPTS", INTEGER2NUM(IPV6_RECVHOPOPTS));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_RECVPKTINFO)
    /* Receive destination IP address and incoming interface */
    rb_define_const(rb_cSocket, "IPV6_RECVPKTINFO", INTEGER2NUM(IPV6_RECVPKTINFO));
    /* Receive destination IP address and incoming interface */
    rb_define_const(rb_mSockConst, "IPV6_RECVPKTINFO", INTEGER2NUM(IPV6_RECVPKTINFO));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_RECVRTHDR)
    /* Receive routing header */
    rb_define_const(rb_cSocket, "IPV6_RECVRTHDR", INTEGER2NUM(IPV6_RECVRTHDR));
    /* Receive routing header */
    rb_define_const(rb_mSockConst, "IPV6_RECVRTHDR", INTEGER2NUM(IPV6_RECVRTHDR));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_RECVTCLASS)
    /* Receive traffic class */
    rb_define_const(rb_cSocket, "IPV6_RECVTCLASS", INTEGER2NUM(IPV6_RECVTCLASS));
    /* Receive traffic class */
    rb_define_const(rb_mSockConst, "IPV6_RECVTCLASS", INTEGER2NUM(IPV6_RECVTCLASS));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_RTHDR)
    /* Allows removal of sticky routing headers */
    rb_define_const(rb_cSocket, "IPV6_RTHDR", INTEGER2NUM(IPV6_RTHDR));
    /* Allows removal of sticky routing headers */
    rb_define_const(rb_mSockConst, "IPV6_RTHDR", INTEGER2NUM(IPV6_RTHDR));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_RTHDRDSTOPTS)
    /* Allows removal of sticky destination options header */
    rb_define_const(rb_cSocket, "IPV6_RTHDRDSTOPTS", INTEGER2NUM(IPV6_RTHDRDSTOPTS));
    /* Allows removal of sticky destination options header */
    rb_define_const(rb_mSockConst, "IPV6_RTHDRDSTOPTS", INTEGER2NUM(IPV6_RTHDRDSTOPTS));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_RTHDR_TYPE_0)
    /* Routing header type 0 */
    rb_define_const(rb_cSocket, "IPV6_RTHDR_TYPE_0", INTEGER2NUM(IPV6_RTHDR_TYPE_0));
    /* Routing header type 0 */
    rb_define_const(rb_mSockConst, "IPV6_RTHDR_TYPE_0", INTEGER2NUM(IPV6_RTHDR_TYPE_0));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_RECVPATHMTU)
    /* Receive current path MTU with datagram */
    rb_define_const(rb_cSocket, "IPV6_RECVPATHMTU", INTEGER2NUM(IPV6_RECVPATHMTU));
    /* Receive current path MTU with datagram */
    rb_define_const(rb_mSockConst, "IPV6_RECVPATHMTU", INTEGER2NUM(IPV6_RECVPATHMTU));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_TCLASS)
    /* Specify the traffic class */
    rb_define_const(rb_cSocket, "IPV6_TCLASS", INTEGER2NUM(IPV6_TCLASS));
    /* Specify the traffic class */
    rb_define_const(rb_mSockConst, "IPV6_TCLASS", INTEGER2NUM(IPV6_TCLASS));
#endif
#endif
#if defined(INET6)
#if defined(IPV6_USE_MIN_MTU)
    /* Use the minimum MTU size */
    rb_define_const(rb_cSocket, "IPV6_USE_MIN_MTU", INTEGER2NUM(IPV6_USE_MIN_MTU));
    /* Use the minimum MTU size */
    rb_define_const(rb_mSockConst, "IPV6_USE_MIN_MTU", INTEGER2NUM(IPV6_USE_MIN_MTU));
#endif
#endif
#if defined(INET_ADDRSTRLEN)
    /* Maximum length of an IPv4 address string */
    rb_define_const(rb_cSocket, "INET_ADDRSTRLEN", INTEGER2NUM(INET_ADDRSTRLEN));
    /* Maximum length of an IPv4 address string */
    rb_define_const(rb_mSockConst, "INET_ADDRSTRLEN", INTEGER2NUM(INET_ADDRSTRLEN));
#endif
#if defined(INET6_ADDRSTRLEN)
    /* Maximum length of an IPv6 address string */
    rb_define_const(rb_cSocket, "INET6_ADDRSTRLEN", INTEGER2NUM(INET6_ADDRSTRLEN));
    /* Maximum length of an IPv6 address string */
    rb_define_const(rb_mSockConst, "INET6_ADDRSTRLEN", INTEGER2NUM(INET6_ADDRSTRLEN));
#endif
#if defined(IFNAMSIZ)
    /* Maximum interface name size */
    rb_define_const(rb_cSocket, "IFNAMSIZ", INTEGER2NUM(IFNAMSIZ));
    /* Maximum interface name size */
    rb_define_const(rb_mSockConst, "IFNAMSIZ", INTEGER2NUM(IFNAMSIZ));
#endif
#if defined(IF_NAMESIZE)
    /* Maximum interface name size */
    rb_define_const(rb_cSocket, "IF_NAMESIZE", INTEGER2NUM(IF_NAMESIZE));
    /* Maximum interface name size */
    rb_define_const(rb_mSockConst, "IF_NAMESIZE", INTEGER2NUM(IF_NAMESIZE));
#endif
#if defined(SOMAXCONN)
    /* Maximum connection requests that may be queued for a socket */
    rb_define_const(rb_cSocket, "SOMAXCONN", INTEGER2NUM(SOMAXCONN));
    /* Maximum connection requests that may be queued for a socket */
    rb_define_const(rb_mSockConst, "SOMAXCONN", INTEGER2NUM(SOMAXCONN));
#endif
#if defined(SCM_RIGHTS)
    /* Access rights */
    rb_define_const(rb_cSocket, "SCM_RIGHTS", INTEGER2NUM(SCM_RIGHTS));
    /* Access rights */
    rb_define_const(rb_mSockConst, "SCM_RIGHTS", INTEGER2NUM(SCM_RIGHTS));
#endif
#if defined(SCM_TIMESTAMP)
    /* Timestamp (timeval) */
    rb_define_const(rb_cSocket, "SCM_TIMESTAMP", INTEGER2NUM(SCM_TIMESTAMP));
    /* Timestamp (timeval) */
    rb_define_const(rb_mSockConst, "SCM_TIMESTAMP", INTEGER2NUM(SCM_TIMESTAMP));
#endif
#if defined(SCM_TIMESTAMPNS)
    /* Timespec (timespec) */
    rb_define_const(rb_cSocket, "SCM_TIMESTAMPNS", INTEGER2NUM(SCM_TIMESTAMPNS));
    /* Timespec (timespec) */
    rb_define_const(rb_mSockConst, "SCM_TIMESTAMPNS", INTEGER2NUM(SCM_TIMESTAMPNS));
#endif
#if defined(SCM_TIMESTAMPING)
    /* Timestamp (timespec list) (Linux 2.6.30) */
    rb_define_const(rb_cSocket, "SCM_TIMESTAMPING", INTEGER2NUM(SCM_TIMESTAMPING));
    /* Timestamp (timespec list) (Linux 2.6.30) */
    rb_define_const(rb_mSockConst, "SCM_TIMESTAMPING", INTEGER2NUM(SCM_TIMESTAMPING));
#endif
#if defined(SCM_BINTIME)
    /* Timestamp (bintime) */
    rb_define_const(rb_cSocket, "SCM_BINTIME", INTEGER2NUM(SCM_BINTIME));
    /* Timestamp (bintime) */
    rb_define_const(rb_mSockConst, "SCM_BINTIME", INTEGER2NUM(SCM_BINTIME));
#endif
#if defined(SCM_CREDENTIALS)
    /* The sender's credentials */
    rb_define_const(rb_cSocket, "SCM_CREDENTIALS", INTEGER2NUM(SCM_CREDENTIALS));
    /* The sender's credentials */
    rb_define_const(rb_mSockConst, "SCM_CREDENTIALS", INTEGER2NUM(SCM_CREDENTIALS));
#endif
#if defined(SCM_CREDS)
    /* Process credentials */
    rb_define_const(rb_cSocket, "SCM_CREDS", INTEGER2NUM(SCM_CREDS));
    /* Process credentials */
    rb_define_const(rb_mSockConst, "SCM_CREDS", INTEGER2NUM(SCM_CREDS));
#endif
#if defined(SCM_UCRED)
    /* User credentials */
    rb_define_const(rb_cSocket, "SCM_UCRED", INTEGER2NUM(SCM_UCRED));
    /* User credentials */
    rb_define_const(rb_mSockConst, "SCM_UCRED", INTEGER2NUM(SCM_UCRED));
#endif
#if defined(SCM_WIFI_STATUS)
    /* Wifi status (Linux 3.3) */
    rb_define_const(rb_cSocket, "SCM_WIFI_STATUS", INTEGER2NUM(SCM_WIFI_STATUS));
    /* Wifi status (Linux 3.3) */
    rb_define_const(rb_mSockConst, "SCM_WIFI_STATUS", INTEGER2NUM(SCM_WIFI_STATUS));
#endif
#if defined(LOCAL_PEERCRED)
    /* Retrieve peer credentials */
    rb_define_const(rb_cSocket, "LOCAL_PEERCRED", INTEGER2NUM(LOCAL_PEERCRED));
    /* Retrieve peer credentials */
    rb_define_const(rb_mSockConst, "LOCAL_PEERCRED", INTEGER2NUM(LOCAL_PEERCRED));
#endif
#if defined(LOCAL_CREDS)
    /* Pass credentials to receiver */
    rb_define_const(rb_cSocket, "LOCAL_CREDS", INTEGER2NUM(LOCAL_CREDS));
    /* Pass credentials to receiver */
    rb_define_const(rb_mSockConst, "LOCAL_CREDS", INTEGER2NUM(LOCAL_CREDS));
#endif
#if defined(LOCAL_CONNWAIT)
    /* Connect blocks until accepted */
    rb_define_const(rb_cSocket, "LOCAL_CONNWAIT", INTEGER2NUM(LOCAL_CONNWAIT));
    /* Connect blocks until accepted */
    rb_define_const(rb_mSockConst, "LOCAL_CONNWAIT", INTEGER2NUM(LOCAL_CONNWAIT));
#endif
#if defined(IFF_802_1Q_VLAN)
    /* 802.1Q VLAN device */
    rb_define_const(rb_cSocket, "IFF_802_1Q_VLAN", INTEGER2NUM(IFF_802_1Q_VLAN));
    /* 802.1Q VLAN device */
    rb_define_const(rb_mSockConst, "IFF_802_1Q_VLAN", INTEGER2NUM(IFF_802_1Q_VLAN));
#endif
#if defined(IFF_ALLMULTI)
    /* receive all multicast packets */
    rb_define_const(rb_cSocket, "IFF_ALLMULTI", INTEGER2NUM(IFF_ALLMULTI));
    /* receive all multicast packets */
    rb_define_const(rb_mSockConst, "IFF_ALLMULTI", INTEGER2NUM(IFF_ALLMULTI));
#endif
#if defined(IFF_ALTPHYS)
    /* use alternate physical connection */
    rb_define_const(rb_cSocket, "IFF_ALTPHYS", INTEGER2NUM(IFF_ALTPHYS));
    /* use alternate physical connection */
    rb_define_const(rb_mSockConst, "IFF_ALTPHYS", INTEGER2NUM(IFF_ALTPHYS));
#endif
#if defined(IFF_AUTOMEDIA)
    /* auto media select active */
    rb_define_const(rb_cSocket, "IFF_AUTOMEDIA", INTEGER2NUM(IFF_AUTOMEDIA));
    /* auto media select active */
    rb_define_const(rb_mSockConst, "IFF_AUTOMEDIA", INTEGER2NUM(IFF_AUTOMEDIA));
#endif
#if defined(IFF_BONDING)
    /* bonding master or slave */
    rb_define_const(rb_cSocket, "IFF_BONDING", INTEGER2NUM(IFF_BONDING));
    /* bonding master or slave */
    rb_define_const(rb_mSockConst, "IFF_BONDING", INTEGER2NUM(IFF_BONDING));
#endif
#if defined(IFF_BRIDGE_PORT)
    /* device used as bridge port */
    rb_define_const(rb_cSocket, "IFF_BRIDGE_PORT", INTEGER2NUM(IFF_BRIDGE_PORT));
    /* device used as bridge port */
    rb_define_const(rb_mSockConst, "IFF_BRIDGE_PORT", INTEGER2NUM(IFF_BRIDGE_PORT));
#endif
#if defined(IFF_BROADCAST)
    /* broadcast address valid */
    rb_define_const(rb_cSocket, "IFF_BROADCAST", INTEGER2NUM(IFF_BROADCAST));
    /* broadcast address valid */
    rb_define_const(rb_mSockConst, "IFF_BROADCAST", INTEGER2NUM(IFF_BROADCAST));
#endif
#if defined(IFF_CANTCONFIG)
    /* unconfigurable using ioctl(2) */
    rb_define_const(rb_cSocket, "IFF_CANTCONFIG", INTEGER2NUM(IFF_CANTCONFIG));
    /* unconfigurable using ioctl(2) */
    rb_define_const(rb_mSockConst, "IFF_CANTCONFIG", INTEGER2NUM(IFF_CANTCONFIG));
#endif
#if defined(IFF_DEBUG)
    /* turn on debugging */
    rb_define_const(rb_cSocket, "IFF_DEBUG", INTEGER2NUM(IFF_DEBUG));
    /* turn on debugging */
    rb_define_const(rb_mSockConst, "IFF_DEBUG", INTEGER2NUM(IFF_DEBUG));
#endif
#if defined(IFF_DISABLE_NETPOLL)
    /* disable netpoll at run-time */
    rb_define_const(rb_cSocket, "IFF_DISABLE_NETPOLL", INTEGER2NUM(IFF_DISABLE_NETPOLL));
    /* disable netpoll at run-time */
    rb_define_const(rb_mSockConst, "IFF_DISABLE_NETPOLL", INTEGER2NUM(IFF_DISABLE_NETPOLL));
#endif
#if defined(IFF_DONT_BRIDGE)
    /* disallow bridging this ether dev */
    rb_define_const(rb_cSocket, "IFF_DONT_BRIDGE", INTEGER2NUM(IFF_DONT_BRIDGE));
    /* disallow bridging this ether dev */
    rb_define_const(rb_mSockConst, "IFF_DONT_BRIDGE", INTEGER2NUM(IFF_DONT_BRIDGE));
#endif
#if defined(IFF_DORMANT)
    /* driver signals dormant */
    rb_define_const(rb_cSocket, "IFF_DORMANT", INTEGER2NUM(IFF_DORMANT));
    /* driver signals dormant */
    rb_define_const(rb_mSockConst, "IFF_DORMANT", INTEGER2NUM(IFF_DORMANT));
#endif
#if defined(IFF_DRV_OACTIVE)
    /* tx hardware queue is full */
    rb_define_const(rb_cSocket, "IFF_DRV_OACTIVE", INTEGER2NUM(IFF_DRV_OACTIVE));
    /* tx hardware queue is full */
    rb_define_const(rb_mSockConst, "IFF_DRV_OACTIVE", INTEGER2NUM(IFF_DRV_OACTIVE));
#endif
#if defined(IFF_DRV_RUNNING)
    /* resources allocated */
    rb_define_const(rb_cSocket, "IFF_DRV_RUNNING", INTEGER2NUM(IFF_DRV_RUNNING));
    /* resources allocated */
    rb_define_const(rb_mSockConst, "IFF_DRV_RUNNING", INTEGER2NUM(IFF_DRV_RUNNING));
#endif
#if defined(IFF_DYING)
    /* interface is winding down */
    rb_define_const(rb_cSocket, "IFF_DYING", INTEGER2NUM(IFF_DYING));
    /* interface is winding down */
    rb_define_const(rb_mSockConst, "IFF_DYING", INTEGER2NUM(IFF_DYING));
#endif
#if defined(IFF_DYNAMIC)
    /* dialup device with changing addresses */
    rb_define_const(rb_cSocket, "IFF_DYNAMIC", INTEGER2NUM(IFF_DYNAMIC));
    /* dialup device with changing addresses */
    rb_define_const(rb_mSockConst, "IFF_DYNAMIC", INTEGER2NUM(IFF_DYNAMIC));
#endif
#if defined(IFF_EBRIDGE)
    /* ethernet bridging device */
    rb_define_const(rb_cSocket, "IFF_EBRIDGE", INTEGER2NUM(IFF_EBRIDGE));
    /* ethernet bridging device */
    rb_define_const(rb_mSockConst, "IFF_EBRIDGE", INTEGER2NUM(IFF_EBRIDGE));
#endif
#if defined(IFF_ECHO)
    /* echo sent packets */
    rb_define_const(rb_cSocket, "IFF_ECHO", INTEGER2NUM(IFF_ECHO));
    /* echo sent packets */
    rb_define_const(rb_mSockConst, "IFF_ECHO", INTEGER2NUM(IFF_ECHO));
#endif
#if defined(IFF_ISATAP)
    /* ISATAP interface (RFC4214) */
    rb_define_const(rb_cSocket, "IFF_ISATAP", INTEGER2NUM(IFF_ISATAP));
    /* ISATAP interface (RFC4214) */
    rb_define_const(rb_mSockConst, "IFF_ISATAP", INTEGER2NUM(IFF_ISATAP));
#endif
#if defined(IFF_LINK0)
    /* per link layer defined bit 0 */
    rb_define_const(rb_cSocket, "IFF_LINK0", INTEGER2NUM(IFF_LINK0));
    /* per link layer defined bit 0 */
    rb_define_const(rb_mSockConst, "IFF_LINK0", INTEGER2NUM(IFF_LINK0));
#endif
#if defined(IFF_LINK1)
    /* per link layer defined bit 1 */
    rb_define_const(rb_cSocket, "IFF_LINK1", INTEGER2NUM(IFF_LINK1));
    /* per link layer defined bit 1 */
    rb_define_const(rb_mSockConst, "IFF_LINK1", INTEGER2NUM(IFF_LINK1));
#endif
#if defined(IFF_LINK2)
    /* per link layer defined bit 2 */
    rb_define_const(rb_cSocket, "IFF_LINK2", INTEGER2NUM(IFF_LINK2));
    /* per link layer defined bit 2 */
    rb_define_const(rb_mSockConst, "IFF_LINK2", INTEGER2NUM(IFF_LINK2));
#endif
#if defined(IFF_LIVE_ADDR_CHANGE)
    /* hardware address change when it's running */
    rb_define_const(rb_cSocket, "IFF_LIVE_ADDR_CHANGE", INTEGER2NUM(IFF_LIVE_ADDR_CHANGE));
    /* hardware address change when it's running */
    rb_define_const(rb_mSockConst, "IFF_LIVE_ADDR_CHANGE", INTEGER2NUM(IFF_LIVE_ADDR_CHANGE));
#endif
#if defined(IFF_LOOPBACK)
    /* loopback net */
    rb_define_const(rb_cSocket, "IFF_LOOPBACK", INTEGER2NUM(IFF_LOOPBACK));
    /* loopback net */
    rb_define_const(rb_mSockConst, "IFF_LOOPBACK", INTEGER2NUM(IFF_LOOPBACK));
#endif
#if defined(IFF_LOWER_UP)
    /* driver signals L1 up */
    rb_define_const(rb_cSocket, "IFF_LOWER_UP", INTEGER2NUM(IFF_LOWER_UP));
    /* driver signals L1 up */
    rb_define_const(rb_mSockConst, "IFF_LOWER_UP", INTEGER2NUM(IFF_LOWER_UP));
#endif
#if defined(IFF_MACVLAN_PORT)
    /* device used as macvlan port */
    rb_define_const(rb_cSocket, "IFF_MACVLAN_PORT", INTEGER2NUM(IFF_MACVLAN_PORT));
    /* device used as macvlan port */
    rb_define_const(rb_mSockConst, "IFF_MACVLAN_PORT", INTEGER2NUM(IFF_MACVLAN_PORT));
#endif
#if defined(IFF_MASTER)
    /* master of a load balancer */
    rb_define_const(rb_cSocket, "IFF_MASTER", INTEGER2NUM(IFF_MASTER));
    /* master of a load balancer */
    rb_define_const(rb_mSockConst, "IFF_MASTER", INTEGER2NUM(IFF_MASTER));
#endif
#if defined(IFF_MASTER_8023AD)
    /* bonding master, 802.3ad. */
    rb_define_const(rb_cSocket, "IFF_MASTER_8023AD", INTEGER2NUM(IFF_MASTER_8023AD));
    /* bonding master, 802.3ad. */
    rb_define_const(rb_mSockConst, "IFF_MASTER_8023AD", INTEGER2NUM(IFF_MASTER_8023AD));
#endif
#if defined(IFF_MASTER_ALB)
    /* bonding master, balance-alb. */
    rb_define_const(rb_cSocket, "IFF_MASTER_ALB", INTEGER2NUM(IFF_MASTER_ALB));
    /* bonding master, balance-alb. */
    rb_define_const(rb_mSockConst, "IFF_MASTER_ALB", INTEGER2NUM(IFF_MASTER_ALB));
#endif
#if defined(IFF_MASTER_ARPMON)
    /* bonding master, ARP mon in use */
    rb_define_const(rb_cSocket, "IFF_MASTER_ARPMON", INTEGER2NUM(IFF_MASTER_ARPMON));
    /* bonding master, ARP mon in use */
    rb_define_const(rb_mSockConst, "IFF_MASTER_ARPMON", INTEGER2NUM(IFF_MASTER_ARPMON));
#endif
#if defined(IFF_MONITOR)
    /* user-requested monitor mode */
    rb_define_const(rb_cSocket, "IFF_MONITOR", INTEGER2NUM(IFF_MONITOR));
    /* user-requested monitor mode */
    rb_define_const(rb_mSockConst, "IFF_MONITOR", INTEGER2NUM(IFF_MONITOR));
#endif
#if defined(IFF_MULTICAST)
    /* supports multicast */
    rb_define_const(rb_cSocket, "IFF_MULTICAST", INTEGER2NUM(IFF_MULTICAST));
    /* supports multicast */
    rb_define_const(rb_mSockConst, "IFF_MULTICAST", INTEGER2NUM(IFF_MULTICAST));
#endif
#if defined(IFF_NOARP)
    /* no address resolution protocol */
    rb_define_const(rb_cSocket, "IFF_NOARP", INTEGER2NUM(IFF_NOARP));
    /* no address resolution protocol */
    rb_define_const(rb_mSockConst, "IFF_NOARP", INTEGER2NUM(IFF_NOARP));
#endif
#if defined(IFF_NOTRAILERS)
    /* avoid use of trailers */
    rb_define_const(rb_cSocket, "IFF_NOTRAILERS", INTEGER2NUM(IFF_NOTRAILERS));
    /* avoid use of trailers */
    rb_define_const(rb_mSockConst, "IFF_NOTRAILERS", INTEGER2NUM(IFF_NOTRAILERS));
#endif
#if defined(IFF_OACTIVE)
    /* transmission in progress */
    rb_define_const(rb_cSocket, "IFF_OACTIVE", INTEGER2NUM(IFF_OACTIVE));
    /* transmission in progress */
    rb_define_const(rb_mSockConst, "IFF_OACTIVE", INTEGER2NUM(IFF_OACTIVE));
#endif
#if defined(IFF_OVS_DATAPATH)
    /* device used as Open vSwitch datapath port */
    rb_define_const(rb_cSocket, "IFF_OVS_DATAPATH", INTEGER2NUM(IFF_OVS_DATAPATH));
    /* device used as Open vSwitch datapath port */
    rb_define_const(rb_mSockConst, "IFF_OVS_DATAPATH", INTEGER2NUM(IFF_OVS_DATAPATH));
#endif
#if defined(IFF_POINTOPOINT)
    /* point-to-point link */
    rb_define_const(rb_cSocket, "IFF_POINTOPOINT", INTEGER2NUM(IFF_POINTOPOINT));
    /* point-to-point link */
    rb_define_const(rb_mSockConst, "IFF_POINTOPOINT", INTEGER2NUM(IFF_POINTOPOINT));
#endif
#if defined(IFF_PORTSEL)
    /* can set media type */
    rb_define_const(rb_cSocket, "IFF_PORTSEL", INTEGER2NUM(IFF_PORTSEL));
    /* can set media type */
    rb_define_const(rb_mSockConst, "IFF_PORTSEL", INTEGER2NUM(IFF_PORTSEL));
#endif
#if defined(IFF_PPROMISC)
    /* user-requested promisc mode */
    rb_define_const(rb_cSocket, "IFF_PPROMISC", INTEGER2NUM(IFF_PPROMISC));
    /* user-requested promisc mode */
    rb_define_const(rb_mSockConst, "IFF_PPROMISC", INTEGER2NUM(IFF_PPROMISC));
#endif
#if defined(IFF_PROMISC)
    /* receive all packets */
    rb_define_const(rb_cSocket, "IFF_PROMISC", INTEGER2NUM(IFF_PROMISC));
    /* receive all packets */
    rb_define_const(rb_mSockConst, "IFF_PROMISC", INTEGER2NUM(IFF_PROMISC));
#endif
#if defined(IFF_RENAMING)
    /* interface is being renamed */
    rb_define_const(rb_cSocket, "IFF_RENAMING", INTEGER2NUM(IFF_RENAMING));
    /* interface is being renamed */
    rb_define_const(rb_mSockConst, "IFF_RENAMING", INTEGER2NUM(IFF_RENAMING));
#endif
#if defined(IFF_ROUTE)
    /* routing entry installed */
    rb_define_const(rb_cSocket, "IFF_ROUTE", INTEGER2NUM(IFF_ROUTE));
    /* routing entry installed */
    rb_define_const(rb_mSockConst, "IFF_ROUTE", INTEGER2NUM(IFF_ROUTE));
#endif
#if defined(IFF_RUNNING)
    /* resources allocated */
    rb_define_const(rb_cSocket, "IFF_RUNNING", INTEGER2NUM(IFF_RUNNING));
    /* resources allocated */
    rb_define_const(rb_mSockConst, "IFF_RUNNING", INTEGER2NUM(IFF_RUNNING));
#endif
#if defined(IFF_SIMPLEX)
    /* can't hear own transmissions */
    rb_define_const(rb_cSocket, "IFF_SIMPLEX", INTEGER2NUM(IFF_SIMPLEX));
    /* can't hear own transmissions */
    rb_define_const(rb_mSockConst, "IFF_SIMPLEX", INTEGER2NUM(IFF_SIMPLEX));
#endif
#if defined(IFF_SLAVE)
    /* slave of a load balancer */
    rb_define_const(rb_cSocket, "IFF_SLAVE", INTEGER2NUM(IFF_SLAVE));
    /* slave of a load balancer */
    rb_define_const(rb_mSockConst, "IFF_SLAVE", INTEGER2NUM(IFF_SLAVE));
#endif
#if defined(IFF_SLAVE_INACTIVE)
    /* bonding slave not the curr. active */
    rb_define_const(rb_cSocket, "IFF_SLAVE_INACTIVE", INTEGER2NUM(IFF_SLAVE_INACTIVE));
    /* bonding slave not the curr. active */
    rb_define_const(rb_mSockConst, "IFF_SLAVE_INACTIVE", INTEGER2NUM(IFF_SLAVE_INACTIVE));
#endif
#if defined(IFF_SLAVE_NEEDARP)
    /* need ARPs for validation */
    rb_define_const(rb_cSocket, "IFF_SLAVE_NEEDARP", INTEGER2NUM(IFF_SLAVE_NEEDARP));
    /* need ARPs for validation */
    rb_define_const(rb_mSockConst, "IFF_SLAVE_NEEDARP", INTEGER2NUM(IFF_SLAVE_NEEDARP));
#endif
#if defined(IFF_SMART)
    /* interface manages own routes */
    rb_define_const(rb_cSocket, "IFF_SMART", INTEGER2NUM(IFF_SMART));
    /* interface manages own routes */
    rb_define_const(rb_mSockConst, "IFF_SMART", INTEGER2NUM(IFF_SMART));
#endif
#if defined(IFF_STATICARP)
    /* static ARP */
    rb_define_const(rb_cSocket, "IFF_STATICARP", INTEGER2NUM(IFF_STATICARP));
    /* static ARP */
    rb_define_const(rb_mSockConst, "IFF_STATICARP", INTEGER2NUM(IFF_STATICARP));
#endif
#if defined(IFF_SUPP_NOFCS)
    /* sending custom FCS */
    rb_define_const(rb_cSocket, "IFF_SUPP_NOFCS", INTEGER2NUM(IFF_SUPP_NOFCS));
    /* sending custom FCS */
    rb_define_const(rb_mSockConst, "IFF_SUPP_NOFCS", INTEGER2NUM(IFF_SUPP_NOFCS));
#endif
#if defined(IFF_TEAM_PORT)
    /* used as team port */
    rb_define_const(rb_cSocket, "IFF_TEAM_PORT", INTEGER2NUM(IFF_TEAM_PORT));
    /* used as team port */
    rb_define_const(rb_mSockConst, "IFF_TEAM_PORT", INTEGER2NUM(IFF_TEAM_PORT));
#endif
#if defined(IFF_TX_SKB_SHARING)
    /* sharing skbs on transmit */
    rb_define_const(rb_cSocket, "IFF_TX_SKB_SHARING", INTEGER2NUM(IFF_TX_SKB_SHARING));
    /* sharing skbs on transmit */
    rb_define_const(rb_mSockConst, "IFF_TX_SKB_SHARING", INTEGER2NUM(IFF_TX_SKB_SHARING));
#endif
#if defined(IFF_UNICAST_FLT)
    /* unicast filtering */
    rb_define_const(rb_cSocket, "IFF_UNICAST_FLT", INTEGER2NUM(IFF_UNICAST_FLT));
    /* unicast filtering */
    rb_define_const(rb_mSockConst, "IFF_UNICAST_FLT", INTEGER2NUM(IFF_UNICAST_FLT));
#endif
#if defined(IFF_UP)
    /* interface is up */
    rb_define_const(rb_cSocket, "IFF_UP", INTEGER2NUM(IFF_UP));
    /* interface is up */
    rb_define_const(rb_mSockConst, "IFF_UP", INTEGER2NUM(IFF_UP));
#endif
#if defined(IFF_WAN_HDLC)
    /* WAN HDLC device */
    rb_define_const(rb_cSocket, "IFF_WAN_HDLC", INTEGER2NUM(IFF_WAN_HDLC));
    /* WAN HDLC device */
    rb_define_const(rb_mSockConst, "IFF_WAN_HDLC", INTEGER2NUM(IFF_WAN_HDLC));
#endif
#if defined(IFF_XMIT_DST_RELEASE)
    /* dev_hard_start_xmit() is allowed to release skb->dst */
    rb_define_const(rb_cSocket, "IFF_XMIT_DST_RELEASE", INTEGER2NUM(IFF_XMIT_DST_RELEASE));
    /* dev_hard_start_xmit() is allowed to release skb->dst */
    rb_define_const(rb_mSockConst, "IFF_XMIT_DST_RELEASE", INTEGER2NUM(IFF_XMIT_DST_RELEASE));
#endif
#if defined(IFF_VOLATILE)
    /* volatile flags */
    rb_define_const(rb_cSocket, "IFF_VOLATILE", INTEGER2NUM(IFF_VOLATILE));
    /* volatile flags */
    rb_define_const(rb_mSockConst, "IFF_VOLATILE", INTEGER2NUM(IFF_VOLATILE));
#endif
#if defined(IFF_CANTCHANGE)
    /* flags not changeable */
    rb_define_const(rb_cSocket, "IFF_CANTCHANGE", INTEGER2NUM(IFF_CANTCHANGE));
    /* flags not changeable */
    rb_define_const(rb_mSockConst, "IFF_CANTCHANGE", INTEGER2NUM(IFF_CANTCHANGE));
#endif

    rsock_intern_family_hash = st_init_numtable();
#ifdef AF_E164
    st_insert(rsock_intern_family_hash, (st_data_t)AF_E164, (st_data_t)rb_intern2("AF_E164", 7));
#endif
#ifdef AF_PACKET
    st_insert(rsock_intern_family_hash, (st_data_t)AF_PACKET, (st_data_t)rb_intern2("AF_PACKET", 9));
#endif
#ifdef AF_MAX
    st_insert(rsock_intern_family_hash, (st_data_t)AF_MAX, (st_data_t)rb_intern2("AF_MAX", 6));
#endif
#ifdef AF_NETGRAPH
    st_insert(rsock_intern_family_hash, (st_data_t)AF_NETGRAPH, (st_data_t)rb_intern2("AF_NETGRAPH", 11));
#endif
#ifdef AF_ATM
    st_insert(rsock_intern_family_hash, (st_data_t)AF_ATM, (st_data_t)rb_intern2("AF_ATM", 6));
#endif
#ifdef AF_PPP
    st_insert(rsock_intern_family_hash, (st_data_t)AF_PPP, (st_data_t)rb_intern2("AF_PPP", 6));
#endif
#ifdef AF_NETBIOS
    st_insert(rsock_intern_family_hash, (st_data_t)AF_NETBIOS, (st_data_t)rb_intern2("AF_NETBIOS", 10));
#endif
#ifdef AF_SYSTEM
    st_insert(rsock_intern_family_hash, (st_data_t)AF_SYSTEM, (st_data_t)rb_intern2("AF_SYSTEM", 9));
#endif
#ifdef AF_NATM
    st_insert(rsock_intern_family_hash, (st_data_t)AF_NATM, (st_data_t)rb_intern2("AF_NATM", 7));
#endif
#ifdef AF_ISDN
    st_insert(rsock_intern_family_hash, (st_data_t)AF_ISDN, (st_data_t)rb_intern2("AF_ISDN", 7));
#endif
#ifdef AF_NDRV
    st_insert(rsock_intern_family_hash, (st_data_t)AF_NDRV, (st_data_t)rb_intern2("AF_NDRV", 7));
#endif
#ifdef AF_SIP
    st_insert(rsock_intern_family_hash, (st_data_t)AF_SIP, (st_data_t)rb_intern2("AF_SIP", 6));
#endif
#ifdef AF_CNT
    st_insert(rsock_intern_family_hash, (st_data_t)AF_CNT, (st_data_t)rb_intern2("AF_CNT", 6));
#endif
#ifdef AF_COIP
    st_insert(rsock_intern_family_hash, (st_data_t)AF_COIP, (st_data_t)rb_intern2("AF_COIP", 7));
#endif
#ifdef AF_LINK
    st_insert(rsock_intern_family_hash, (st_data_t)AF_LINK, (st_data_t)rb_intern2("AF_LINK", 7));
#endif
#ifdef AF_ROUTE
    st_insert(rsock_intern_family_hash, (st_data_t)AF_ROUTE, (st_data_t)rb_intern2("AF_ROUTE", 8));
#endif
#ifdef AF_HYLINK
    st_insert(rsock_intern_family_hash, (st_data_t)AF_HYLINK, (st_data_t)rb_intern2("AF_HYLINK", 9));
#endif
#ifdef AF_LAT
    st_insert(rsock_intern_family_hash, (st_data_t)AF_LAT, (st_data_t)rb_intern2("AF_LAT", 6));
#endif
#ifdef AF_DLI
    st_insert(rsock_intern_family_hash, (st_data_t)AF_DLI, (st_data_t)rb_intern2("AF_DLI", 6));
#endif
#ifdef AF_DEC
    st_insert(rsock_intern_family_hash, (st_data_t)AF_DEC, (st_data_t)rb_intern2("AF_DEC", 6));
#endif
#ifdef AF_SNA
    st_insert(rsock_intern_family_hash, (st_data_t)AF_SNA, (st_data_t)rb_intern2("AF_SNA", 6));
#endif
#ifdef AF_CCITT
    st_insert(rsock_intern_family_hash, (st_data_t)AF_CCITT, (st_data_t)rb_intern2("AF_CCITT", 8));
#endif
#ifdef AF_DATAKIT
    st_insert(rsock_intern_family_hash, (st_data_t)AF_DATAKIT, (st_data_t)rb_intern2("AF_DATAKIT", 10));
#endif
#ifdef AF_ECMA
    st_insert(rsock_intern_family_hash, (st_data_t)AF_ECMA, (st_data_t)rb_intern2("AF_ECMA", 7));
#endif
#ifdef AF_OSI
    st_insert(rsock_intern_family_hash, (st_data_t)AF_OSI, (st_data_t)rb_intern2("AF_OSI", 6));
#endif
#ifdef AF_ISO
    st_insert(rsock_intern_family_hash, (st_data_t)AF_ISO, (st_data_t)rb_intern2("AF_ISO", 6));
#endif
#ifdef AF_NS
    st_insert(rsock_intern_family_hash, (st_data_t)AF_NS, (st_data_t)rb_intern2("AF_NS", 5));
#endif
#ifdef AF_CHAOS
    st_insert(rsock_intern_family_hash, (st_data_t)AF_CHAOS, (st_data_t)rb_intern2("AF_CHAOS", 8));
#endif
#ifdef AF_PUP
    st_insert(rsock_intern_family_hash, (st_data_t)AF_PUP, (st_data_t)rb_intern2("AF_PUP", 6));
#endif
#ifdef AF_IMPLINK
    st_insert(rsock_intern_family_hash, (st_data_t)AF_IMPLINK, (st_data_t)rb_intern2("AF_IMPLINK", 10));
#endif
#ifdef AF_LOCAL
    st_insert(rsock_intern_family_hash, (st_data_t)AF_LOCAL, (st_data_t)rb_intern2("AF_LOCAL", 8));
#endif
#ifdef AF_APPLETALK
    st_insert(rsock_intern_family_hash, (st_data_t)AF_APPLETALK, (st_data_t)rb_intern2("AF_APPLETALK", 12));
#endif
#ifdef AF_IPX
    st_insert(rsock_intern_family_hash, (st_data_t)AF_IPX, (st_data_t)rb_intern2("AF_IPX", 6));
#endif
#ifdef AF_AX25
    st_insert(rsock_intern_family_hash, (st_data_t)AF_AX25, (st_data_t)rb_intern2("AF_AX25", 7));
#endif
#ifdef AF_UNIX
    st_insert(rsock_intern_family_hash, (st_data_t)AF_UNIX, (st_data_t)rb_intern2("AF_UNIX", 7));
#endif
#ifdef AF_INET6
    st_insert(rsock_intern_family_hash, (st_data_t)AF_INET6, (st_data_t)rb_intern2("AF_INET6", 8));
#endif
#ifdef AF_INET
    st_insert(rsock_intern_family_hash, (st_data_t)AF_INET, (st_data_t)rb_intern2("AF_INET", 7));
#endif
#ifdef AF_UNSPEC
    st_insert(rsock_intern_family_hash, (st_data_t)AF_UNSPEC, (st_data_t)rb_intern2("AF_UNSPEC", 9));
#endif

    rsock_intern_family_noprefix_hash = st_init_numtable();
#ifdef AF_E164
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_E164, (st_data_t)rb_intern2("AF_E164", 7));
#endif
#ifdef AF_PACKET
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_PACKET, (st_data_t)rb_intern2("AF_PACKET", 9));
#endif
#ifdef AF_MAX
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_MAX, (st_data_t)rb_intern2("AF_MAX", 6));
#endif
#ifdef AF_NETGRAPH
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_NETGRAPH, (st_data_t)rb_intern2("AF_NETGRAPH", 11));
#endif
#ifdef AF_ATM
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_ATM, (st_data_t)rb_intern2("AF_ATM", 6));
#endif
#ifdef AF_PPP
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_PPP, (st_data_t)rb_intern2("AF_PPP", 6));
#endif
#ifdef AF_NETBIOS
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_NETBIOS, (st_data_t)rb_intern2("AF_NETBIOS", 10));
#endif
#ifdef AF_SYSTEM
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_SYSTEM, (st_data_t)rb_intern2("AF_SYSTEM", 9));
#endif
#ifdef AF_NATM
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_NATM, (st_data_t)rb_intern2("AF_NATM", 7));
#endif
#ifdef AF_ISDN
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_ISDN, (st_data_t)rb_intern2("AF_ISDN", 7));
#endif
#ifdef AF_NDRV
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_NDRV, (st_data_t)rb_intern2("AF_NDRV", 7));
#endif
#ifdef AF_SIP
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_SIP, (st_data_t)rb_intern2("AF_SIP", 6));
#endif
#ifdef AF_CNT
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_CNT, (st_data_t)rb_intern2("AF_CNT", 6));
#endif
#ifdef AF_COIP
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_COIP, (st_data_t)rb_intern2("AF_COIP", 7));
#endif
#ifdef AF_LINK
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_LINK, (st_data_t)rb_intern2("AF_LINK", 7));
#endif
#ifdef AF_ROUTE
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_ROUTE, (st_data_t)rb_intern2("AF_ROUTE", 8));
#endif
#ifdef AF_HYLINK
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_HYLINK, (st_data_t)rb_intern2("AF_HYLINK", 9));
#endif
#ifdef AF_LAT
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_LAT, (st_data_t)rb_intern2("AF_LAT", 6));
#endif
#ifdef AF_DLI
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_DLI, (st_data_t)rb_intern2("AF_DLI", 6));
#endif
#ifdef AF_DEC
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_DEC, (st_data_t)rb_intern2("AF_DEC", 6));
#endif
#ifdef AF_SNA
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_SNA, (st_data_t)rb_intern2("AF_SNA", 6));
#endif
#ifdef AF_CCITT
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_CCITT, (st_data_t)rb_intern2("AF_CCITT", 8));
#endif
#ifdef AF_DATAKIT
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_DATAKIT, (st_data_t)rb_intern2("AF_DATAKIT", 10));
#endif
#ifdef AF_ECMA
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_ECMA, (st_data_t)rb_intern2("AF_ECMA", 7));
#endif
#ifdef AF_OSI
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_OSI, (st_data_t)rb_intern2("AF_OSI", 6));
#endif
#ifdef AF_ISO
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_ISO, (st_data_t)rb_intern2("AF_ISO", 6));
#endif
#ifdef AF_NS
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_NS, (st_data_t)rb_intern2("AF_NS", 5));
#endif
#ifdef AF_CHAOS
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_CHAOS, (st_data_t)rb_intern2("AF_CHAOS", 8));
#endif
#ifdef AF_PUP
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_PUP, (st_data_t)rb_intern2("AF_PUP", 6));
#endif
#ifdef AF_IMPLINK
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_IMPLINK, (st_data_t)rb_intern2("AF_IMPLINK", 10));
#endif
#ifdef AF_LOCAL
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_LOCAL, (st_data_t)rb_intern2("AF_LOCAL", 8));
#endif
#ifdef AF_APPLETALK
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_APPLETALK, (st_data_t)rb_intern2("AF_APPLETALK", 12));
#endif
#ifdef AF_IPX
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_IPX, (st_data_t)rb_intern2("AF_IPX", 6));
#endif
#ifdef AF_AX25
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_AX25, (st_data_t)rb_intern2("AF_AX25", 7));
#endif
#ifdef AF_UNIX
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_UNIX, (st_data_t)rb_intern2("AF_UNIX", 7));
#endif
#ifdef AF_INET6
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_INET6, (st_data_t)rb_intern2("AF_INET6", 8));
#endif
#ifdef AF_INET
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_INET, (st_data_t)rb_intern2("AF_INET", 7));
#endif
#ifdef AF_UNSPEC
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_UNSPEC, (st_data_t)rb_intern2("AF_UNSPEC", 9));
#endif
#ifdef AF_E164
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_E164, (st_data_t)rb_intern2("E164", 4));
#endif
#ifdef AF_PACKET
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_PACKET, (st_data_t)rb_intern2("PACKET", 6));
#endif
#ifdef AF_MAX
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_MAX, (st_data_t)rb_intern2("MAX", 3));
#endif
#ifdef AF_NETGRAPH
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_NETGRAPH, (st_data_t)rb_intern2("NETGRAPH", 8));
#endif
#ifdef AF_ATM
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_ATM, (st_data_t)rb_intern2("ATM", 3));
#endif
#ifdef AF_PPP
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_PPP, (st_data_t)rb_intern2("PPP", 3));
#endif
#ifdef AF_NETBIOS
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_NETBIOS, (st_data_t)rb_intern2("NETBIOS", 7));
#endif
#ifdef AF_SYSTEM
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_SYSTEM, (st_data_t)rb_intern2("SYSTEM", 6));
#endif
#ifdef AF_NATM
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_NATM, (st_data_t)rb_intern2("NATM", 4));
#endif
#ifdef AF_ISDN
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_ISDN, (st_data_t)rb_intern2("ISDN", 4));
#endif
#ifdef AF_NDRV
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_NDRV, (st_data_t)rb_intern2("NDRV", 4));
#endif
#ifdef AF_SIP
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_SIP, (st_data_t)rb_intern2("SIP", 3));
#endif
#ifdef AF_CNT
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_CNT, (st_data_t)rb_intern2("CNT", 3));
#endif
#ifdef AF_COIP
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_COIP, (st_data_t)rb_intern2("COIP", 4));
#endif
#ifdef AF_LINK
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_LINK, (st_data_t)rb_intern2("LINK", 4));
#endif
#ifdef AF_ROUTE
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_ROUTE, (st_data_t)rb_intern2("ROUTE", 5));
#endif
#ifdef AF_HYLINK
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_HYLINK, (st_data_t)rb_intern2("HYLINK", 6));
#endif
#ifdef AF_LAT
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_LAT, (st_data_t)rb_intern2("LAT", 3));
#endif
#ifdef AF_DLI
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_DLI, (st_data_t)rb_intern2("DLI", 3));
#endif
#ifdef AF_DEC
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_DEC, (st_data_t)rb_intern2("DEC", 3));
#endif
#ifdef AF_SNA
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_SNA, (st_data_t)rb_intern2("SNA", 3));
#endif
#ifdef AF_CCITT
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_CCITT, (st_data_t)rb_intern2("CCITT", 5));
#endif
#ifdef AF_DATAKIT
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_DATAKIT, (st_data_t)rb_intern2("DATAKIT", 7));
#endif
#ifdef AF_ECMA
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_ECMA, (st_data_t)rb_intern2("ECMA", 4));
#endif
#ifdef AF_OSI
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_OSI, (st_data_t)rb_intern2("OSI", 3));
#endif
#ifdef AF_ISO
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_ISO, (st_data_t)rb_intern2("ISO", 3));
#endif
#ifdef AF_NS
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_NS, (st_data_t)rb_intern2("NS", 2));
#endif
#ifdef AF_CHAOS
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_CHAOS, (st_data_t)rb_intern2("CHAOS", 5));
#endif
#ifdef AF_PUP
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_PUP, (st_data_t)rb_intern2("PUP", 3));
#endif
#ifdef AF_IMPLINK
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_IMPLINK, (st_data_t)rb_intern2("IMPLINK", 7));
#endif
#ifdef AF_LOCAL
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_LOCAL, (st_data_t)rb_intern2("LOCAL", 5));
#endif
#ifdef AF_APPLETALK
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_APPLETALK, (st_data_t)rb_intern2("APPLETALK", 9));
#endif
#ifdef AF_IPX
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_IPX, (st_data_t)rb_intern2("IPX", 3));
#endif
#ifdef AF_AX25
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_AX25, (st_data_t)rb_intern2("AX25", 4));
#endif
#ifdef AF_UNIX
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_UNIX, (st_data_t)rb_intern2("UNIX", 4));
#endif
#ifdef AF_INET6
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_INET6, (st_data_t)rb_intern2("INET6", 5));
#endif
#ifdef AF_INET
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_INET, (st_data_t)rb_intern2("INET", 4));
#endif
#ifdef AF_UNSPEC
    st_insert(rsock_intern_family_noprefix_hash, (st_data_t)AF_UNSPEC, (st_data_t)rb_intern2("UNSPEC", 6));
#endif

    rsock_intern_protocol_family_hash = st_init_numtable();
#ifdef PF_KEY
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_KEY, (st_data_t)rb_intern2("PF_KEY", 6));
#endif
#ifdef PF_PIP
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_PIP, (st_data_t)rb_intern2("PF_PIP", 6));
#endif
#ifdef PF_RTIP
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_RTIP, (st_data_t)rb_intern2("PF_RTIP", 7));
#endif
#ifdef PF_XTP
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_XTP, (st_data_t)rb_intern2("PF_XTP", 6));
#endif
#ifdef PF_PACKET
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_PACKET, (st_data_t)rb_intern2("PF_PACKET", 9));
#endif
#ifdef PF_MAX
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_MAX, (st_data_t)rb_intern2("PF_MAX", 6));
#endif
#ifdef PF_NETGRAPH
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_NETGRAPH, (st_data_t)rb_intern2("PF_NETGRAPH", 11));
#endif
#ifdef PF_ATM
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_ATM, (st_data_t)rb_intern2("PF_ATM", 6));
#endif
#ifdef PF_PPP
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_PPP, (st_data_t)rb_intern2("PF_PPP", 6));
#endif
#ifdef PF_NETBIOS
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_NETBIOS, (st_data_t)rb_intern2("PF_NETBIOS", 10));
#endif
#ifdef PF_SYSTEM
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_SYSTEM, (st_data_t)rb_intern2("PF_SYSTEM", 9));
#endif
#ifdef PF_NATM
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_NATM, (st_data_t)rb_intern2("PF_NATM", 7));
#endif
#ifdef PF_ISDN
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_ISDN, (st_data_t)rb_intern2("PF_ISDN", 7));
#endif
#ifdef PF_NDRV
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_NDRV, (st_data_t)rb_intern2("PF_NDRV", 7));
#endif
#ifdef PF_SIP
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_SIP, (st_data_t)rb_intern2("PF_SIP", 6));
#endif
#ifdef PF_CNT
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_CNT, (st_data_t)rb_intern2("PF_CNT", 6));
#endif
#ifdef PF_COIP
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_COIP, (st_data_t)rb_intern2("PF_COIP", 7));
#endif
#ifdef PF_LINK
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_LINK, (st_data_t)rb_intern2("PF_LINK", 7));
#endif
#ifdef PF_ROUTE
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_ROUTE, (st_data_t)rb_intern2("PF_ROUTE", 8));
#endif
#ifdef PF_HYLINK
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_HYLINK, (st_data_t)rb_intern2("PF_HYLINK", 9));
#endif
#ifdef PF_LAT
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_LAT, (st_data_t)rb_intern2("PF_LAT", 6));
#endif
#ifdef PF_DLI
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_DLI, (st_data_t)rb_intern2("PF_DLI", 6));
#endif
#ifdef PF_DEC
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_DEC, (st_data_t)rb_intern2("PF_DEC", 6));
#endif
#ifdef PF_SNA
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_SNA, (st_data_t)rb_intern2("PF_SNA", 6));
#endif
#ifdef PF_CCITT
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_CCITT, (st_data_t)rb_intern2("PF_CCITT", 8));
#endif
#ifdef PF_DATAKIT
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_DATAKIT, (st_data_t)rb_intern2("PF_DATAKIT", 10));
#endif
#ifdef PF_ECMA
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_ECMA, (st_data_t)rb_intern2("PF_ECMA", 7));
#endif
#ifdef PF_OSI
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_OSI, (st_data_t)rb_intern2("PF_OSI", 6));
#endif
#ifdef PF_ISO
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_ISO, (st_data_t)rb_intern2("PF_ISO", 6));
#endif
#ifdef PF_NS
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_NS, (st_data_t)rb_intern2("PF_NS", 5));
#endif
#ifdef PF_CHAOS
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_CHAOS, (st_data_t)rb_intern2("PF_CHAOS", 8));
#endif
#ifdef PF_PUP
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_PUP, (st_data_t)rb_intern2("PF_PUP", 6));
#endif
#ifdef PF_IMPLINK
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_IMPLINK, (st_data_t)rb_intern2("PF_IMPLINK", 10));
#endif
#ifdef PF_LOCAL
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_LOCAL, (st_data_t)rb_intern2("PF_LOCAL", 8));
#endif
#ifdef PF_APPLETALK
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_APPLETALK, (st_data_t)rb_intern2("PF_APPLETALK", 12));
#endif
#ifdef PF_IPX
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_IPX, (st_data_t)rb_intern2("PF_IPX", 6));
#endif
#ifdef PF_AX25
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_AX25, (st_data_t)rb_intern2("PF_AX25", 7));
#endif
#ifdef PF_UNIX
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_UNIX, (st_data_t)rb_intern2("PF_UNIX", 7));
#endif
#ifdef PF_INET6
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_INET6, (st_data_t)rb_intern2("PF_INET6", 8));
#endif
#ifdef PF_INET
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_INET, (st_data_t)rb_intern2("PF_INET", 7));
#endif
#ifdef PF_UNSPEC
    st_insert(rsock_intern_protocol_family_hash, (st_data_t)PF_UNSPEC, (st_data_t)rb_intern2("PF_UNSPEC", 9));
#endif

    rsock_intern_socktype_hash = st_init_numtable();
#ifdef SOCK_PACKET
    st_insert(rsock_intern_socktype_hash, (st_data_t)SOCK_PACKET, (st_data_t)rb_intern2("SOCK_PACKET", 11));
#endif
#ifdef SOCK_SEQPACKET
    st_insert(rsock_intern_socktype_hash, (st_data_t)SOCK_SEQPACKET, (st_data_t)rb_intern2("SOCK_SEQPACKET", 14));
#endif
#ifdef SOCK_RDM
    st_insert(rsock_intern_socktype_hash, (st_data_t)SOCK_RDM, (st_data_t)rb_intern2("SOCK_RDM", 8));
#endif
#ifdef SOCK_RAW
    st_insert(rsock_intern_socktype_hash, (st_data_t)SOCK_RAW, (st_data_t)rb_intern2("SOCK_RAW", 8));
#endif
#ifdef SOCK_DGRAM
    st_insert(rsock_intern_socktype_hash, (st_data_t)SOCK_DGRAM, (st_data_t)rb_intern2("SOCK_DGRAM", 10));
#endif
#ifdef SOCK_STREAM
    st_insert(rsock_intern_socktype_hash, (st_data_t)SOCK_STREAM, (st_data_t)rb_intern2("SOCK_STREAM", 11));
#endif

    rsock_intern_ipproto_hash = st_init_numtable();
#ifdef IPPROTO_MAX
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_MAX, (st_data_t)rb_intern2("IPPROTO_MAX", 11));
#endif
#ifdef IPPROTO_RAW
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_RAW, (st_data_t)rb_intern2("IPPROTO_RAW", 11));
#endif
#ifdef IPPROTO_ROUTING
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_ROUTING, (st_data_t)rb_intern2("IPPROTO_ROUTING", 15));
#endif
#ifdef IPPROTO_NONE
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_NONE, (st_data_t)rb_intern2("IPPROTO_NONE", 12));
#endif
#ifdef IPPROTO_IPV6
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_IPV6, (st_data_t)rb_intern2("IPPROTO_IPV6", 12));
#endif
#ifdef IPPROTO_ICMPV6
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_ICMPV6, (st_data_t)rb_intern2("IPPROTO_ICMPV6", 14));
#endif
#ifdef IPPROTO_HOPOPTS
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_HOPOPTS, (st_data_t)rb_intern2("IPPROTO_HOPOPTS", 15));
#endif
#ifdef IPPROTO_FRAGMENT
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_FRAGMENT, (st_data_t)rb_intern2("IPPROTO_FRAGMENT", 16));
#endif
#ifdef IPPROTO_ESP
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_ESP, (st_data_t)rb_intern2("IPPROTO_ESP", 11));
#endif
#ifdef IPPROTO_DSTOPTS
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_DSTOPTS, (st_data_t)rb_intern2("IPPROTO_DSTOPTS", 15));
#endif
#ifdef IPPROTO_AH
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_AH, (st_data_t)rb_intern2("IPPROTO_AH", 10));
#endif
#ifdef IPPROTO_BIP
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_BIP, (st_data_t)rb_intern2("IPPROTO_BIP", 11));
#endif
#ifdef IPPROTO_EON
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_EON, (st_data_t)rb_intern2("IPPROTO_EON", 11));
#endif
#ifdef IPPROTO_XTP
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_XTP, (st_data_t)rb_intern2("IPPROTO_XTP", 11));
#endif
#ifdef IPPROTO_TP
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_TP, (st_data_t)rb_intern2("IPPROTO_TP", 10));
#endif
#ifdef IPPROTO_ND
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_ND, (st_data_t)rb_intern2("IPPROTO_ND", 10));
#endif
#ifdef IPPROTO_HELLO
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_HELLO, (st_data_t)rb_intern2("IPPROTO_HELLO", 13));
#endif
#ifdef IPPROTO_IDP
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_IDP, (st_data_t)rb_intern2("IPPROTO_IDP", 11));
#endif
#ifdef IPPROTO_UDP
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_UDP, (st_data_t)rb_intern2("IPPROTO_UDP", 11));
#endif
#ifdef IPPROTO_PUP
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_PUP, (st_data_t)rb_intern2("IPPROTO_PUP", 11));
#endif
#ifdef IPPROTO_EGP
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_EGP, (st_data_t)rb_intern2("IPPROTO_EGP", 11));
#endif
#ifdef IPPROTO_TCP
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_TCP, (st_data_t)rb_intern2("IPPROTO_TCP", 11));
#endif
#ifdef IPPROTO_GGP
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_GGP, (st_data_t)rb_intern2("IPPROTO_GGP", 11));
#endif
#ifdef IPPROTO_IGMP
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_IGMP, (st_data_t)rb_intern2("IPPROTO_IGMP", 12));
#endif
#ifdef IPPROTO_ICMP
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_ICMP, (st_data_t)rb_intern2("IPPROTO_ICMP", 12));
#endif
#ifdef IPPROTO_IP
    st_insert(rsock_intern_ipproto_hash, (st_data_t)IPPROTO_IP, (st_data_t)rb_intern2("IPPROTO_IP", 10));
#endif

    rsock_intern_iplevel_hash = st_init_numtable();
#ifdef IPPROTO_MAX
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_MAX, (st_data_t)rb_intern2("IPPROTO_MAX", 11));
#endif
#ifdef IPPROTO_RAW
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_RAW, (st_data_t)rb_intern2("IPPROTO_RAW", 11));
#endif
#ifdef IPPROTO_ROUTING
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_ROUTING, (st_data_t)rb_intern2("IPPROTO_ROUTING", 15));
#endif
#ifdef IPPROTO_NONE
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_NONE, (st_data_t)rb_intern2("IPPROTO_NONE", 12));
#endif
#ifdef IPPROTO_IPV6
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_IPV6, (st_data_t)rb_intern2("IPPROTO_IPV6", 12));
#endif
#ifdef IPPROTO_ICMPV6
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_ICMPV6, (st_data_t)rb_intern2("IPPROTO_ICMPV6", 14));
#endif
#ifdef IPPROTO_HOPOPTS
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_HOPOPTS, (st_data_t)rb_intern2("IPPROTO_HOPOPTS", 15));
#endif
#ifdef IPPROTO_FRAGMENT
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_FRAGMENT, (st_data_t)rb_intern2("IPPROTO_FRAGMENT", 16));
#endif
#ifdef IPPROTO_ESP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_ESP, (st_data_t)rb_intern2("IPPROTO_ESP", 11));
#endif
#ifdef IPPROTO_DSTOPTS
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_DSTOPTS, (st_data_t)rb_intern2("IPPROTO_DSTOPTS", 15));
#endif
#ifdef IPPROTO_AH
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_AH, (st_data_t)rb_intern2("IPPROTO_AH", 10));
#endif
#ifdef IPPROTO_BIP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_BIP, (st_data_t)rb_intern2("IPPROTO_BIP", 11));
#endif
#ifdef IPPROTO_EON
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_EON, (st_data_t)rb_intern2("IPPROTO_EON", 11));
#endif
#ifdef IPPROTO_XTP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_XTP, (st_data_t)rb_intern2("IPPROTO_XTP", 11));
#endif
#ifdef IPPROTO_TP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_TP, (st_data_t)rb_intern2("IPPROTO_TP", 10));
#endif
#ifdef IPPROTO_ND
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_ND, (st_data_t)rb_intern2("IPPROTO_ND", 10));
#endif
#ifdef IPPROTO_HELLO
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_HELLO, (st_data_t)rb_intern2("IPPROTO_HELLO", 13));
#endif
#ifdef IPPROTO_IDP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_IDP, (st_data_t)rb_intern2("IPPROTO_IDP", 11));
#endif
#ifdef IPPROTO_UDP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_UDP, (st_data_t)rb_intern2("IPPROTO_UDP", 11));
#endif
#ifdef IPPROTO_PUP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_PUP, (st_data_t)rb_intern2("IPPROTO_PUP", 11));
#endif
#ifdef IPPROTO_EGP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_EGP, (st_data_t)rb_intern2("IPPROTO_EGP", 11));
#endif
#ifdef IPPROTO_TCP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_TCP, (st_data_t)rb_intern2("IPPROTO_TCP", 11));
#endif
#ifdef IPPROTO_GGP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_GGP, (st_data_t)rb_intern2("IPPROTO_GGP", 11));
#endif
#ifdef IPPROTO_IGMP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_IGMP, (st_data_t)rb_intern2("IPPROTO_IGMP", 12));
#endif
#ifdef IPPROTO_ICMP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_ICMP, (st_data_t)rb_intern2("IPPROTO_ICMP", 12));
#endif
#ifdef IPPROTO_IP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_IP, (st_data_t)rb_intern2("IPPROTO_IP", 10));
#endif
#ifdef SOL_SOCKET
    st_insert(rsock_intern_iplevel_hash, (st_data_t)SOL_SOCKET, (st_data_t)rb_intern2("SOL_SOCKET", 10));
#endif
#ifdef IPPROTO_MAX
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_MAX, (st_data_t)rb_intern2("MAX", 3));
#endif
#ifdef IPPROTO_RAW
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_RAW, (st_data_t)rb_intern2("RAW", 3));
#endif
#ifdef IPPROTO_ROUTING
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_ROUTING, (st_data_t)rb_intern2("ROUTING", 7));
#endif
#ifdef IPPROTO_NONE
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_NONE, (st_data_t)rb_intern2("NONE", 4));
#endif
#ifdef IPPROTO_IPV6
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_IPV6, (st_data_t)rb_intern2("IPV6", 4));
#endif
#ifdef IPPROTO_ICMPV6
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_ICMPV6, (st_data_t)rb_intern2("ICMPV6", 6));
#endif
#ifdef IPPROTO_HOPOPTS
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_HOPOPTS, (st_data_t)rb_intern2("HOPOPTS", 7));
#endif
#ifdef IPPROTO_FRAGMENT
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_FRAGMENT, (st_data_t)rb_intern2("FRAGMENT", 8));
#endif
#ifdef IPPROTO_ESP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_ESP, (st_data_t)rb_intern2("ESP", 3));
#endif
#ifdef IPPROTO_DSTOPTS
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_DSTOPTS, (st_data_t)rb_intern2("DSTOPTS", 7));
#endif
#ifdef IPPROTO_AH
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_AH, (st_data_t)rb_intern2("AH", 2));
#endif
#ifdef IPPROTO_BIP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_BIP, (st_data_t)rb_intern2("BIP", 3));
#endif
#ifdef IPPROTO_EON
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_EON, (st_data_t)rb_intern2("EON", 3));
#endif
#ifdef IPPROTO_XTP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_XTP, (st_data_t)rb_intern2("XTP", 3));
#endif
#ifdef IPPROTO_TP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_TP, (st_data_t)rb_intern2("TP", 2));
#endif
#ifdef IPPROTO_ND
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_ND, (st_data_t)rb_intern2("ND", 2));
#endif
#ifdef IPPROTO_HELLO
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_HELLO, (st_data_t)rb_intern2("HELLO", 5));
#endif
#ifdef IPPROTO_IDP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_IDP, (st_data_t)rb_intern2("IDP", 3));
#endif
#ifdef IPPROTO_UDP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_UDP, (st_data_t)rb_intern2("UDP", 3));
#endif
#ifdef IPPROTO_PUP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_PUP, (st_data_t)rb_intern2("PUP", 3));
#endif
#ifdef IPPROTO_EGP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_EGP, (st_data_t)rb_intern2("EGP", 3));
#endif
#ifdef IPPROTO_TCP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_TCP, (st_data_t)rb_intern2("TCP", 3));
#endif
#ifdef IPPROTO_GGP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_GGP, (st_data_t)rb_intern2("GGP", 3));
#endif
#ifdef IPPROTO_IGMP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_IGMP, (st_data_t)rb_intern2("IGMP", 4));
#endif
#ifdef IPPROTO_ICMP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_ICMP, (st_data_t)rb_intern2("ICMP", 4));
#endif
#ifdef IPPROTO_IP
    st_insert(rsock_intern_iplevel_hash, (st_data_t)IPPROTO_IP, (st_data_t)rb_intern2("IP", 2));
#endif
#ifdef SOL_SOCKET
    st_insert(rsock_intern_iplevel_hash, (st_data_t)SOL_SOCKET, (st_data_t)rb_intern2("SOCKET", 6));
#endif

    rsock_intern_so_optname_hash = st_init_numtable();
#ifdef SO_BPF_EXTENSIONS
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_BPF_EXTENSIONS, (st_data_t)rb_intern2("SO_BPF_EXTENSIONS", 17));
#endif
#ifdef SO_MAX_PACING_RATE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_MAX_PACING_RATE, (st_data_t)rb_intern2("SO_MAX_PACING_RATE", 18));
#endif
#ifdef SO_BUSY_POLL
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_BUSY_POLL, (st_data_t)rb_intern2("SO_BUSY_POLL", 12));
#endif
#ifdef SO_SELECT_ERR_QUEUE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_SELECT_ERR_QUEUE, (st_data_t)rb_intern2("SO_SELECT_ERR_QUEUE", 19));
#endif
#ifdef SO_LOCK_FILTER
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_LOCK_FILTER, (st_data_t)rb_intern2("SO_LOCK_FILTER", 14));
#endif
#ifdef SO_NOFCS
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_NOFCS, (st_data_t)rb_intern2("SO_NOFCS", 8));
#endif
#ifdef SO_PEEK_OFF
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_PEEK_OFF, (st_data_t)rb_intern2("SO_PEEK_OFF", 11));
#endif
#ifdef SO_WIFI_STATUS
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_WIFI_STATUS, (st_data_t)rb_intern2("SO_WIFI_STATUS", 14));
#endif
#ifdef SO_RXQ_OVFL
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_RXQ_OVFL, (st_data_t)rb_intern2("SO_RXQ_OVFL", 11));
#endif
#ifdef SO_DOMAIN
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_DOMAIN, (st_data_t)rb_intern2("SO_DOMAIN", 9));
#endif
#ifdef SO_PROTOCOL
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_PROTOCOL, (st_data_t)rb_intern2("SO_PROTOCOL", 11));
#endif
#ifdef SO_TIMESTAMPING
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_TIMESTAMPING, (st_data_t)rb_intern2("SO_TIMESTAMPING", 15));
#endif
#ifdef SO_MARK
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_MARK, (st_data_t)rb_intern2("SO_MARK", 7));
#endif
#ifdef SO_PASSSEC
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_PASSSEC, (st_data_t)rb_intern2("SO_PASSSEC", 10));
#endif
#ifdef SO_PEERSEC
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_PEERSEC, (st_data_t)rb_intern2("SO_PEERSEC", 10));
#endif
#ifdef SO_ALLZONES
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_ALLZONES, (st_data_t)rb_intern2("SO_ALLZONES", 11));
#endif
#ifdef SO_MAC_EXEMPT
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_MAC_EXEMPT, (st_data_t)rb_intern2("SO_MAC_EXEMPT", 13));
#endif
#ifdef SO_RECVUCRED
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_RECVUCRED, (st_data_t)rb_intern2("SO_RECVUCRED", 12));
#endif
#ifdef SO_BINTIME
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_BINTIME, (st_data_t)rb_intern2("SO_BINTIME", 10));
#endif
#ifdef SO_TIMESTAMPNS
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_TIMESTAMPNS, (st_data_t)rb_intern2("SO_TIMESTAMPNS", 14));
#endif
#ifdef SO_TIMESTAMP
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_TIMESTAMP, (st_data_t)rb_intern2("SO_TIMESTAMP", 12));
#endif
#ifdef SO_PEERNAME
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_PEERNAME, (st_data_t)rb_intern2("SO_PEERNAME", 11));
#endif
#ifdef SO_GET_FILTER
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_GET_FILTER, (st_data_t)rb_intern2("SO_GET_FILTER", 13));
#endif
#ifdef SO_DETACH_FILTER
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_DETACH_FILTER, (st_data_t)rb_intern2("SO_DETACH_FILTER", 16));
#endif
#ifdef SO_ATTACH_FILTER
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_ATTACH_FILTER, (st_data_t)rb_intern2("SO_ATTACH_FILTER", 16));
#endif
#ifdef SO_BINDTODEVICE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_BINDTODEVICE, (st_data_t)rb_intern2("SO_BINDTODEVICE", 15));
#endif
#ifdef SO_SECURITY_ENCRYPTION_NETWORK
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_SECURITY_ENCRYPTION_NETWORK, (st_data_t)rb_intern2("SO_SECURITY_ENCRYPTION_NETWORK", 30));
#endif
#ifdef SO_SECURITY_ENCRYPTION_TRANSPORT
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_SECURITY_ENCRYPTION_TRANSPORT, (st_data_t)rb_intern2("SO_SECURITY_ENCRYPTION_TRANSPORT", 32));
#endif
#ifdef SO_SECURITY_AUTHENTICATION
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_SECURITY_AUTHENTICATION, (st_data_t)rb_intern2("SO_SECURITY_AUTHENTICATION", 26));
#endif
#ifdef SO_NOSIGPIPE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_NOSIGPIPE, (st_data_t)rb_intern2("SO_NOSIGPIPE", 12));
#endif
#ifdef SO_NKE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_NKE, (st_data_t)rb_intern2("SO_NKE", 6));
#endif
#ifdef SO_NREAD
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_NREAD, (st_data_t)rb_intern2("SO_NREAD", 8));
#endif
#ifdef SO_WANTOOBFLAG
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_WANTOOBFLAG, (st_data_t)rb_intern2("SO_WANTOOBFLAG", 14));
#endif
#ifdef SO_WANTMORE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_WANTMORE, (st_data_t)rb_intern2("SO_WANTMORE", 11));
#endif
#ifdef SO_DONTTRUNC
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_DONTTRUNC, (st_data_t)rb_intern2("SO_DONTTRUNC", 12));
#endif
#ifdef SO_ACCEPTFILTER
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_ACCEPTFILTER, (st_data_t)rb_intern2("SO_ACCEPTFILTER", 15));
#endif
#ifdef SO_USELOOPBACK
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_USELOOPBACK, (st_data_t)rb_intern2("SO_USELOOPBACK", 14));
#endif
#ifdef SO_ACCEPTCONN
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_ACCEPTCONN, (st_data_t)rb_intern2("SO_ACCEPTCONN", 13));
#endif
#ifdef SO_SNDTIMEO
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_SNDTIMEO, (st_data_t)rb_intern2("SO_SNDTIMEO", 11));
#endif
#ifdef SO_RCVTIMEO
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_RCVTIMEO, (st_data_t)rb_intern2("SO_RCVTIMEO", 11));
#endif
#ifdef SO_SNDLOWAT
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_SNDLOWAT, (st_data_t)rb_intern2("SO_SNDLOWAT", 11));
#endif
#ifdef SO_RCVLOWAT
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_RCVLOWAT, (st_data_t)rb_intern2("SO_RCVLOWAT", 11));
#endif
#ifdef SO_PEERCRED
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_PEERCRED, (st_data_t)rb_intern2("SO_PEERCRED", 11));
#endif
#ifdef SO_PASSCRED
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_PASSCRED, (st_data_t)rb_intern2("SO_PASSCRED", 11));
#endif
#ifdef SO_LINGER
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_LINGER, (st_data_t)rb_intern2("SO_LINGER", 9));
#endif
#ifdef SO_PRIORITY
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_PRIORITY, (st_data_t)rb_intern2("SO_PRIORITY", 11));
#endif
#ifdef SO_NO_CHECK
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_NO_CHECK, (st_data_t)rb_intern2("SO_NO_CHECK", 11));
#endif
#ifdef SO_OOBINLINE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_OOBINLINE, (st_data_t)rb_intern2("SO_OOBINLINE", 12));
#endif
#ifdef SO_KEEPALIVE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_KEEPALIVE, (st_data_t)rb_intern2("SO_KEEPALIVE", 12));
#endif
#ifdef SO_RCVBUFFORCE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_RCVBUFFORCE, (st_data_t)rb_intern2("SO_RCVBUFFORCE", 14));
#endif
#ifdef SO_SNDBUFFORCE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_SNDBUFFORCE, (st_data_t)rb_intern2("SO_SNDBUFFORCE", 14));
#endif
#ifdef SO_RCVBUF
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_RCVBUF, (st_data_t)rb_intern2("SO_RCVBUF", 9));
#endif
#ifdef SO_SNDBUF
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_SNDBUF, (st_data_t)rb_intern2("SO_SNDBUF", 9));
#endif
#ifdef SO_BROADCAST
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_BROADCAST, (st_data_t)rb_intern2("SO_BROADCAST", 12));
#endif
#ifdef SO_DONTROUTE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_DONTROUTE, (st_data_t)rb_intern2("SO_DONTROUTE", 12));
#endif
#ifdef SO_ERROR
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_ERROR, (st_data_t)rb_intern2("SO_ERROR", 8));
#endif
#ifdef SO_TYPE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_TYPE, (st_data_t)rb_intern2("SO_TYPE", 7));
#endif
#ifdef SO_REUSEPORT
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_REUSEPORT, (st_data_t)rb_intern2("SO_REUSEPORT", 12));
#endif
#ifdef SO_REUSEADDR
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_REUSEADDR, (st_data_t)rb_intern2("SO_REUSEADDR", 12));
#endif
#ifdef SO_DEBUG
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_DEBUG, (st_data_t)rb_intern2("SO_DEBUG", 8));
#endif
#ifdef SO_BPF_EXTENSIONS
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_BPF_EXTENSIONS, (st_data_t)rb_intern2("BPF_EXTENSIONS", 14));
#endif
#ifdef SO_MAX_PACING_RATE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_MAX_PACING_RATE, (st_data_t)rb_intern2("MAX_PACING_RATE", 15));
#endif
#ifdef SO_BUSY_POLL
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_BUSY_POLL, (st_data_t)rb_intern2("BUSY_POLL", 9));
#endif
#ifdef SO_SELECT_ERR_QUEUE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_SELECT_ERR_QUEUE, (st_data_t)rb_intern2("SELECT_ERR_QUEUE", 16));
#endif
#ifdef SO_LOCK_FILTER
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_LOCK_FILTER, (st_data_t)rb_intern2("LOCK_FILTER", 11));
#endif
#ifdef SO_NOFCS
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_NOFCS, (st_data_t)rb_intern2("NOFCS", 5));
#endif
#ifdef SO_PEEK_OFF
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_PEEK_OFF, (st_data_t)rb_intern2("PEEK_OFF", 8));
#endif
#ifdef SO_WIFI_STATUS
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_WIFI_STATUS, (st_data_t)rb_intern2("WIFI_STATUS", 11));
#endif
#ifdef SO_RXQ_OVFL
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_RXQ_OVFL, (st_data_t)rb_intern2("RXQ_OVFL", 8));
#endif
#ifdef SO_DOMAIN
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_DOMAIN, (st_data_t)rb_intern2("DOMAIN", 6));
#endif
#ifdef SO_PROTOCOL
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_PROTOCOL, (st_data_t)rb_intern2("PROTOCOL", 8));
#endif
#ifdef SO_TIMESTAMPING
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_TIMESTAMPING, (st_data_t)rb_intern2("TIMESTAMPING", 12));
#endif
#ifdef SO_MARK
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_MARK, (st_data_t)rb_intern2("MARK", 4));
#endif
#ifdef SO_PASSSEC
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_PASSSEC, (st_data_t)rb_intern2("PASSSEC", 7));
#endif
#ifdef SO_PEERSEC
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_PEERSEC, (st_data_t)rb_intern2("PEERSEC", 7));
#endif
#ifdef SO_ALLZONES
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_ALLZONES, (st_data_t)rb_intern2("ALLZONES", 8));
#endif
#ifdef SO_MAC_EXEMPT
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_MAC_EXEMPT, (st_data_t)rb_intern2("MAC_EXEMPT", 10));
#endif
#ifdef SO_RECVUCRED
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_RECVUCRED, (st_data_t)rb_intern2("RECVUCRED", 9));
#endif
#ifdef SO_BINTIME
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_BINTIME, (st_data_t)rb_intern2("BINTIME", 7));
#endif
#ifdef SO_TIMESTAMPNS
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_TIMESTAMPNS, (st_data_t)rb_intern2("TIMESTAMPNS", 11));
#endif
#ifdef SO_TIMESTAMP
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_TIMESTAMP, (st_data_t)rb_intern2("TIMESTAMP", 9));
#endif
#ifdef SO_PEERNAME
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_PEERNAME, (st_data_t)rb_intern2("PEERNAME", 8));
#endif
#ifdef SO_GET_FILTER
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_GET_FILTER, (st_data_t)rb_intern2("GET_FILTER", 10));
#endif
#ifdef SO_DETACH_FILTER
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_DETACH_FILTER, (st_data_t)rb_intern2("DETACH_FILTER", 13));
#endif
#ifdef SO_ATTACH_FILTER
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_ATTACH_FILTER, (st_data_t)rb_intern2("ATTACH_FILTER", 13));
#endif
#ifdef SO_BINDTODEVICE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_BINDTODEVICE, (st_data_t)rb_intern2("BINDTODEVICE", 12));
#endif
#ifdef SO_SECURITY_ENCRYPTION_NETWORK
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_SECURITY_ENCRYPTION_NETWORK, (st_data_t)rb_intern2("SECURITY_ENCRYPTION_NETWORK", 27));
#endif
#ifdef SO_SECURITY_ENCRYPTION_TRANSPORT
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_SECURITY_ENCRYPTION_TRANSPORT, (st_data_t)rb_intern2("SECURITY_ENCRYPTION_TRANSPORT", 29));
#endif
#ifdef SO_SECURITY_AUTHENTICATION
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_SECURITY_AUTHENTICATION, (st_data_t)rb_intern2("SECURITY_AUTHENTICATION", 23));
#endif
#ifdef SO_NOSIGPIPE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_NOSIGPIPE, (st_data_t)rb_intern2("NOSIGPIPE", 9));
#endif
#ifdef SO_NKE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_NKE, (st_data_t)rb_intern2("NKE", 3));
#endif
#ifdef SO_NREAD
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_NREAD, (st_data_t)rb_intern2("NREAD", 5));
#endif
#ifdef SO_WANTOOBFLAG
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_WANTOOBFLAG, (st_data_t)rb_intern2("WANTOOBFLAG", 11));
#endif
#ifdef SO_WANTMORE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_WANTMORE, (st_data_t)rb_intern2("WANTMORE", 8));
#endif
#ifdef SO_DONTTRUNC
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_DONTTRUNC, (st_data_t)rb_intern2("DONTTRUNC", 9));
#endif
#ifdef SO_ACCEPTFILTER
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_ACCEPTFILTER, (st_data_t)rb_intern2("ACCEPTFILTER", 12));
#endif
#ifdef SO_USELOOPBACK
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_USELOOPBACK, (st_data_t)rb_intern2("USELOOPBACK", 11));
#endif
#ifdef SO_ACCEPTCONN
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_ACCEPTCONN, (st_data_t)rb_intern2("ACCEPTCONN", 10));
#endif
#ifdef SO_SNDTIMEO
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_SNDTIMEO, (st_data_t)rb_intern2("SNDTIMEO", 8));
#endif
#ifdef SO_RCVTIMEO
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_RCVTIMEO, (st_data_t)rb_intern2("RCVTIMEO", 8));
#endif
#ifdef SO_SNDLOWAT
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_SNDLOWAT, (st_data_t)rb_intern2("SNDLOWAT", 8));
#endif
#ifdef SO_RCVLOWAT
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_RCVLOWAT, (st_data_t)rb_intern2("RCVLOWAT", 8));
#endif
#ifdef SO_PEERCRED
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_PEERCRED, (st_data_t)rb_intern2("PEERCRED", 8));
#endif
#ifdef SO_PASSCRED
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_PASSCRED, (st_data_t)rb_intern2("PASSCRED", 8));
#endif
#ifdef SO_LINGER
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_LINGER, (st_data_t)rb_intern2("LINGER", 6));
#endif
#ifdef SO_PRIORITY
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_PRIORITY, (st_data_t)rb_intern2("PRIORITY", 8));
#endif
#ifdef SO_NO_CHECK
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_NO_CHECK, (st_data_t)rb_intern2("NO_CHECK", 8));
#endif
#ifdef SO_OOBINLINE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_OOBINLINE, (st_data_t)rb_intern2("OOBINLINE", 9));
#endif
#ifdef SO_KEEPALIVE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_KEEPALIVE, (st_data_t)rb_intern2("KEEPALIVE", 9));
#endif
#ifdef SO_RCVBUFFORCE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_RCVBUFFORCE, (st_data_t)rb_intern2("RCVBUFFORCE", 11));
#endif
#ifdef SO_SNDBUFFORCE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_SNDBUFFORCE, (st_data_t)rb_intern2("SNDBUFFORCE", 11));
#endif
#ifdef SO_RCVBUF
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_RCVBUF, (st_data_t)rb_intern2("RCVBUF", 6));
#endif
#ifdef SO_SNDBUF
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_SNDBUF, (st_data_t)rb_intern2("SNDBUF", 6));
#endif
#ifdef SO_BROADCAST
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_BROADCAST, (st_data_t)rb_intern2("BROADCAST", 9));
#endif
#ifdef SO_DONTROUTE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_DONTROUTE, (st_data_t)rb_intern2("DONTROUTE", 9));
#endif
#ifdef SO_ERROR
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_ERROR, (st_data_t)rb_intern2("ERROR", 5));
#endif
#ifdef SO_TYPE
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_TYPE, (st_data_t)rb_intern2("TYPE", 4));
#endif
#ifdef SO_REUSEPORT
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_REUSEPORT, (st_data_t)rb_intern2("REUSEPORT", 9));
#endif
#ifdef SO_REUSEADDR
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_REUSEADDR, (st_data_t)rb_intern2("REUSEADDR", 9));
#endif
#ifdef SO_DEBUG
    st_insert(rsock_intern_so_optname_hash, (st_data_t)SO_DEBUG, (st_data_t)rb_intern2("DEBUG", 5));
#endif

    rsock_intern_ip_optname_hash = st_init_numtable();
#ifdef IP_MSFILTER
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_MSFILTER, (st_data_t)rb_intern2("IP_MSFILTER", 11));
#endif
#ifdef IP_DROP_SOURCE_MEMBERSHIP
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_DROP_SOURCE_MEMBERSHIP, (st_data_t)rb_intern2("IP_DROP_SOURCE_MEMBERSHIP", 25));
#endif
#ifdef IP_ADD_SOURCE_MEMBERSHIP
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_ADD_SOURCE_MEMBERSHIP, (st_data_t)rb_intern2("IP_ADD_SOURCE_MEMBERSHIP", 24));
#endif
#ifdef IP_BLOCK_SOURCE
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_BLOCK_SOURCE, (st_data_t)rb_intern2("IP_BLOCK_SOURCE", 15));
#endif
#ifdef IP_UNBLOCK_SOURCE
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_UNBLOCK_SOURCE, (st_data_t)rb_intern2("IP_UNBLOCK_SOURCE", 17));
#endif
#ifdef IP_PMTUDISC_DO
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_PMTUDISC_DO, (st_data_t)rb_intern2("IP_PMTUDISC_DO", 14));
#endif
#ifdef IP_PMTUDISC_WANT
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_PMTUDISC_WANT, (st_data_t)rb_intern2("IP_PMTUDISC_WANT", 16));
#endif
#ifdef IP_PMTUDISC_DONT
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_PMTUDISC_DONT, (st_data_t)rb_intern2("IP_PMTUDISC_DONT", 16));
#endif
#ifdef IP_TRANSPARENT
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_TRANSPARENT, (st_data_t)rb_intern2("IP_TRANSPARENT", 14));
#endif
#ifdef IP_PASSSEC
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_PASSSEC, (st_data_t)rb_intern2("IP_PASSSEC", 10));
#endif
#ifdef IP_XFRM_POLICY
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_XFRM_POLICY, (st_data_t)rb_intern2("IP_XFRM_POLICY", 14));
#endif
#ifdef IP_IPSEC_POLICY
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_IPSEC_POLICY, (st_data_t)rb_intern2("IP_IPSEC_POLICY", 15));
#endif
#ifdef IP_FREEBIND
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_FREEBIND, (st_data_t)rb_intern2("IP_FREEBIND", 11));
#endif
#ifdef IP_MTU
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_MTU, (st_data_t)rb_intern2("IP_MTU", 6));
#endif
#ifdef IP_RECVTOS
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_RECVTOS, (st_data_t)rb_intern2("IP_RECVTOS", 10));
#endif
#ifdef IP_RECVERR
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_RECVERR, (st_data_t)rb_intern2("IP_RECVERR", 10));
#endif
#ifdef IP_MTU_DISCOVER
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_MTU_DISCOVER, (st_data_t)rb_intern2("IP_MTU_DISCOVER", 15));
#endif
#ifdef IP_PKTOPTIONS
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_PKTOPTIONS, (st_data_t)rb_intern2("IP_PKTOPTIONS", 13));
#endif
#ifdef IP_PKTINFO
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_PKTINFO, (st_data_t)rb_intern2("IP_PKTINFO", 10));
#endif
#ifdef IP_ROUTER_ALERT
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_ROUTER_ALERT, (st_data_t)rb_intern2("IP_ROUTER_ALERT", 15));
#endif
#ifdef IP_MAX_MEMBERSHIPS
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_MAX_MEMBERSHIPS, (st_data_t)rb_intern2("IP_MAX_MEMBERSHIPS", 18));
#endif
#ifdef IP_DEFAULT_MULTICAST_LOOP
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_DEFAULT_MULTICAST_LOOP, (st_data_t)rb_intern2("IP_DEFAULT_MULTICAST_LOOP", 25));
#endif
#ifdef IP_DEFAULT_MULTICAST_TTL
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_DEFAULT_MULTICAST_TTL, (st_data_t)rb_intern2("IP_DEFAULT_MULTICAST_TTL", 24));
#endif
#ifdef IP_DROP_MEMBERSHIP
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_DROP_MEMBERSHIP, (st_data_t)rb_intern2("IP_DROP_MEMBERSHIP", 18));
#endif
#ifdef IP_ADD_MEMBERSHIP
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_ADD_MEMBERSHIP, (st_data_t)rb_intern2("IP_ADD_MEMBERSHIP", 17));
#endif
#ifdef IP_MULTICAST_LOOP
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_MULTICAST_LOOP, (st_data_t)rb_intern2("IP_MULTICAST_LOOP", 17));
#endif
#ifdef IP_MULTICAST_TTL
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_MULTICAST_TTL, (st_data_t)rb_intern2("IP_MULTICAST_TTL", 16));
#endif
#ifdef IP_MULTICAST_IF
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_MULTICAST_IF, (st_data_t)rb_intern2("IP_MULTICAST_IF", 15));
#endif
#ifdef IP_PORTRANGE
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_PORTRANGE, (st_data_t)rb_intern2("IP_PORTRANGE", 12));
#endif
#ifdef IP_RECVSLLA
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_RECVSLLA, (st_data_t)rb_intern2("IP_RECVSLLA", 11));
#endif
#ifdef IP_RECVIF
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_RECVIF, (st_data_t)rb_intern2("IP_RECVIF", 9));
#endif
#ifdef IP_RECVTTL
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_RECVTTL, (st_data_t)rb_intern2("IP_RECVTTL", 10));
#endif
#ifdef IP_ONESBCAST
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_ONESBCAST, (st_data_t)rb_intern2("IP_ONESBCAST", 12));
#endif
#ifdef IP_SENDSRCADDR
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_SENDSRCADDR, (st_data_t)rb_intern2("IP_SENDSRCADDR", 14));
#endif
#ifdef IP_DONTFRAG
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_DONTFRAG, (st_data_t)rb_intern2("IP_DONTFRAG", 11));
#endif
#ifdef IP_MINTTL
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_MINTTL, (st_data_t)rb_intern2("IP_MINTTL", 9));
#endif
#ifdef IP_RETOPTS
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_RETOPTS, (st_data_t)rb_intern2("IP_RETOPTS", 10));
#endif
#ifdef IP_RECVDSTADDR
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_RECVDSTADDR, (st_data_t)rb_intern2("IP_RECVDSTADDR", 14));
#endif
#ifdef IP_RECVRETOPTS
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_RECVRETOPTS, (st_data_t)rb_intern2("IP_RECVRETOPTS", 14));
#endif
#ifdef IP_RECVOPTS
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_RECVOPTS, (st_data_t)rb_intern2("IP_RECVOPTS", 11));
#endif
#ifdef IP_TTL
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_TTL, (st_data_t)rb_intern2("IP_TTL", 6));
#endif
#ifdef IP_TOS
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_TOS, (st_data_t)rb_intern2("IP_TOS", 6));
#endif
#ifdef IP_HDRINCL
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_HDRINCL, (st_data_t)rb_intern2("IP_HDRINCL", 10));
#endif
#ifdef IP_OPTIONS
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_OPTIONS, (st_data_t)rb_intern2("IP_OPTIONS", 10));
#endif
#ifdef IP_MSFILTER
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_MSFILTER, (st_data_t)rb_intern2("MSFILTER", 8));
#endif
#ifdef IP_DROP_SOURCE_MEMBERSHIP
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_DROP_SOURCE_MEMBERSHIP, (st_data_t)rb_intern2("DROP_SOURCE_MEMBERSHIP", 22));
#endif
#ifdef IP_ADD_SOURCE_MEMBERSHIP
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_ADD_SOURCE_MEMBERSHIP, (st_data_t)rb_intern2("ADD_SOURCE_MEMBERSHIP", 21));
#endif
#ifdef IP_BLOCK_SOURCE
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_BLOCK_SOURCE, (st_data_t)rb_intern2("BLOCK_SOURCE", 12));
#endif
#ifdef IP_UNBLOCK_SOURCE
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_UNBLOCK_SOURCE, (st_data_t)rb_intern2("UNBLOCK_SOURCE", 14));
#endif
#ifdef IP_PMTUDISC_DO
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_PMTUDISC_DO, (st_data_t)rb_intern2("PMTUDISC_DO", 11));
#endif
#ifdef IP_PMTUDISC_WANT
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_PMTUDISC_WANT, (st_data_t)rb_intern2("PMTUDISC_WANT", 13));
#endif
#ifdef IP_PMTUDISC_DONT
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_PMTUDISC_DONT, (st_data_t)rb_intern2("PMTUDISC_DONT", 13));
#endif
#ifdef IP_TRANSPARENT
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_TRANSPARENT, (st_data_t)rb_intern2("TRANSPARENT", 11));
#endif
#ifdef IP_PASSSEC
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_PASSSEC, (st_data_t)rb_intern2("PASSSEC", 7));
#endif
#ifdef IP_XFRM_POLICY
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_XFRM_POLICY, (st_data_t)rb_intern2("XFRM_POLICY", 11));
#endif
#ifdef IP_IPSEC_POLICY
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_IPSEC_POLICY, (st_data_t)rb_intern2("IPSEC_POLICY", 12));
#endif
#ifdef IP_FREEBIND
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_FREEBIND, (st_data_t)rb_intern2("FREEBIND", 8));
#endif
#ifdef IP_MTU
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_MTU, (st_data_t)rb_intern2("MTU", 3));
#endif
#ifdef IP_RECVTOS
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_RECVTOS, (st_data_t)rb_intern2("RECVTOS", 7));
#endif
#ifdef IP_RECVERR
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_RECVERR, (st_data_t)rb_intern2("RECVERR", 7));
#endif
#ifdef IP_MTU_DISCOVER
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_MTU_DISCOVER, (st_data_t)rb_intern2("MTU_DISCOVER", 12));
#endif
#ifdef IP_PKTOPTIONS
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_PKTOPTIONS, (st_data_t)rb_intern2("PKTOPTIONS", 10));
#endif
#ifdef IP_PKTINFO
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_PKTINFO, (st_data_t)rb_intern2("PKTINFO", 7));
#endif
#ifdef IP_ROUTER_ALERT
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_ROUTER_ALERT, (st_data_t)rb_intern2("ROUTER_ALERT", 12));
#endif
#ifdef IP_MAX_MEMBERSHIPS
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_MAX_MEMBERSHIPS, (st_data_t)rb_intern2("MAX_MEMBERSHIPS", 15));
#endif
#ifdef IP_DEFAULT_MULTICAST_LOOP
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_DEFAULT_MULTICAST_LOOP, (st_data_t)rb_intern2("DEFAULT_MULTICAST_LOOP", 22));
#endif
#ifdef IP_DEFAULT_MULTICAST_TTL
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_DEFAULT_MULTICAST_TTL, (st_data_t)rb_intern2("DEFAULT_MULTICAST_TTL", 21));
#endif
#ifdef IP_DROP_MEMBERSHIP
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_DROP_MEMBERSHIP, (st_data_t)rb_intern2("DROP_MEMBERSHIP", 15));
#endif
#ifdef IP_ADD_MEMBERSHIP
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_ADD_MEMBERSHIP, (st_data_t)rb_intern2("ADD_MEMBERSHIP", 14));
#endif
#ifdef IP_MULTICAST_LOOP
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_MULTICAST_LOOP, (st_data_t)rb_intern2("MULTICAST_LOOP", 14));
#endif
#ifdef IP_MULTICAST_TTL
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_MULTICAST_TTL, (st_data_t)rb_intern2("MULTICAST_TTL", 13));
#endif
#ifdef IP_MULTICAST_IF
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_MULTICAST_IF, (st_data_t)rb_intern2("MULTICAST_IF", 12));
#endif
#ifdef IP_PORTRANGE
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_PORTRANGE, (st_data_t)rb_intern2("PORTRANGE", 9));
#endif
#ifdef IP_RECVSLLA
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_RECVSLLA, (st_data_t)rb_intern2("RECVSLLA", 8));
#endif
#ifdef IP_RECVIF
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_RECVIF, (st_data_t)rb_intern2("RECVIF", 6));
#endif
#ifdef IP_RECVTTL
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_RECVTTL, (st_data_t)rb_intern2("RECVTTL", 7));
#endif
#ifdef IP_ONESBCAST
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_ONESBCAST, (st_data_t)rb_intern2("ONESBCAST", 9));
#endif
#ifdef IP_SENDSRCADDR
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_SENDSRCADDR, (st_data_t)rb_intern2("SENDSRCADDR", 11));
#endif
#ifdef IP_DONTFRAG
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_DONTFRAG, (st_data_t)rb_intern2("DONTFRAG", 8));
#endif
#ifdef IP_MINTTL
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_MINTTL, (st_data_t)rb_intern2("MINTTL", 6));
#endif
#ifdef IP_RETOPTS
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_RETOPTS, (st_data_t)rb_intern2("RETOPTS", 7));
#endif
#ifdef IP_RECVDSTADDR
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_RECVDSTADDR, (st_data_t)rb_intern2("RECVDSTADDR", 11));
#endif
#ifdef IP_RECVRETOPTS
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_RECVRETOPTS, (st_data_t)rb_intern2("RECVRETOPTS", 11));
#endif
#ifdef IP_RECVOPTS
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_RECVOPTS, (st_data_t)rb_intern2("RECVOPTS", 8));
#endif
#ifdef IP_TTL
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_TTL, (st_data_t)rb_intern2("TTL", 3));
#endif
#ifdef IP_TOS
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_TOS, (st_data_t)rb_intern2("TOS", 3));
#endif
#ifdef IP_HDRINCL
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_HDRINCL, (st_data_t)rb_intern2("HDRINCL", 7));
#endif
#ifdef IP_OPTIONS
    st_insert(rsock_intern_ip_optname_hash, (st_data_t)IP_OPTIONS, (st_data_t)rb_intern2("OPTIONS", 7));
#endif

    rsock_intern_ipv6_optname_hash = st_init_numtable();
#ifdef IPV6_USE_MIN_MTU
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_USE_MIN_MTU, (st_data_t)rb_intern2("IPV6_USE_MIN_MTU", 16));
#endif
#ifdef IPV6_TCLASS
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_TCLASS, (st_data_t)rb_intern2("IPV6_TCLASS", 11));
#endif
#ifdef IPV6_RECVPATHMTU
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_RECVPATHMTU, (st_data_t)rb_intern2("IPV6_RECVPATHMTU", 16));
#endif
#ifdef IPV6_RTHDR_TYPE_0
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_RTHDR_TYPE_0, (st_data_t)rb_intern2("IPV6_RTHDR_TYPE_0", 17));
#endif
#ifdef IPV6_RTHDRDSTOPTS
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_RTHDRDSTOPTS, (st_data_t)rb_intern2("IPV6_RTHDRDSTOPTS", 17));
#endif
#ifdef IPV6_RTHDR
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_RTHDR, (st_data_t)rb_intern2("IPV6_RTHDR", 10));
#endif
#ifdef IPV6_RECVTCLASS
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_RECVTCLASS, (st_data_t)rb_intern2("IPV6_RECVTCLASS", 15));
#endif
#ifdef IPV6_RECVRTHDR
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_RECVRTHDR, (st_data_t)rb_intern2("IPV6_RECVRTHDR", 14));
#endif
#ifdef IPV6_RECVPKTINFO
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_RECVPKTINFO, (st_data_t)rb_intern2("IPV6_RECVPKTINFO", 16));
#endif
#ifdef IPV6_RECVHOPOPTS
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_RECVHOPOPTS, (st_data_t)rb_intern2("IPV6_RECVHOPOPTS", 16));
#endif
#ifdef IPV6_RECVHOPLIMIT
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_RECVHOPLIMIT, (st_data_t)rb_intern2("IPV6_RECVHOPLIMIT", 17));
#endif
#ifdef IPV6_RECVDSTOPTS
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_RECVDSTOPTS, (st_data_t)rb_intern2("IPV6_RECVDSTOPTS", 16));
#endif
#ifdef IPV6_PKTINFO
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_PKTINFO, (st_data_t)rb_intern2("IPV6_PKTINFO", 12));
#endif
#ifdef IPV6_PATHMTU
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_PATHMTU, (st_data_t)rb_intern2("IPV6_PATHMTU", 12));
#endif
#ifdef IPV6_NEXTHOP
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_NEXTHOP, (st_data_t)rb_intern2("IPV6_NEXTHOP", 12));
#endif
#ifdef IPV6_HOPOPTS
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_HOPOPTS, (st_data_t)rb_intern2("IPV6_HOPOPTS", 12));
#endif
#ifdef IPV6_HOPLIMIT
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_HOPLIMIT, (st_data_t)rb_intern2("IPV6_HOPLIMIT", 13));
#endif
#ifdef IPV6_DSTOPTS
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_DSTOPTS, (st_data_t)rb_intern2("IPV6_DSTOPTS", 12));
#endif
#ifdef IPV6_DONTFRAG
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_DONTFRAG, (st_data_t)rb_intern2("IPV6_DONTFRAG", 13));
#endif
#ifdef IPV6_CHECKSUM
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_CHECKSUM, (st_data_t)rb_intern2("IPV6_CHECKSUM", 13));
#endif
#ifdef IPV6_V6ONLY
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_V6ONLY, (st_data_t)rb_intern2("IPV6_V6ONLY", 11));
#endif
#ifdef IPV6_UNICAST_HOPS
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_UNICAST_HOPS, (st_data_t)rb_intern2("IPV6_UNICAST_HOPS", 17));
#endif
#ifdef IPV6_MULTICAST_LOOP
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_MULTICAST_LOOP, (st_data_t)rb_intern2("IPV6_MULTICAST_LOOP", 19));
#endif
#ifdef IPV6_MULTICAST_IF
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_MULTICAST_IF, (st_data_t)rb_intern2("IPV6_MULTICAST_IF", 17));
#endif
#ifdef IPV6_MULTICAST_HOPS
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_MULTICAST_HOPS, (st_data_t)rb_intern2("IPV6_MULTICAST_HOPS", 19));
#endif
#ifdef IPV6_LEAVE_GROUP
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_LEAVE_GROUP, (st_data_t)rb_intern2("IPV6_LEAVE_GROUP", 16));
#endif
#ifdef IPV6_JOIN_GROUP
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_JOIN_GROUP, (st_data_t)rb_intern2("IPV6_JOIN_GROUP", 15));
#endif
#ifdef IPV6_USE_MIN_MTU
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_USE_MIN_MTU, (st_data_t)rb_intern2("USE_MIN_MTU", 11));
#endif
#ifdef IPV6_TCLASS
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_TCLASS, (st_data_t)rb_intern2("TCLASS", 6));
#endif
#ifdef IPV6_RECVPATHMTU
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_RECVPATHMTU, (st_data_t)rb_intern2("RECVPATHMTU", 11));
#endif
#ifdef IPV6_RTHDR_TYPE_0
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_RTHDR_TYPE_0, (st_data_t)rb_intern2("RTHDR_TYPE_0", 12));
#endif
#ifdef IPV6_RTHDRDSTOPTS
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_RTHDRDSTOPTS, (st_data_t)rb_intern2("RTHDRDSTOPTS", 12));
#endif
#ifdef IPV6_RTHDR
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_RTHDR, (st_data_t)rb_intern2("RTHDR", 5));
#endif
#ifdef IPV6_RECVTCLASS
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_RECVTCLASS, (st_data_t)rb_intern2("RECVTCLASS", 10));
#endif
#ifdef IPV6_RECVRTHDR
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_RECVRTHDR, (st_data_t)rb_intern2("RECVRTHDR", 9));
#endif
#ifdef IPV6_RECVPKTINFO
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_RECVPKTINFO, (st_data_t)rb_intern2("RECVPKTINFO", 11));
#endif
#ifdef IPV6_RECVHOPOPTS
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_RECVHOPOPTS, (st_data_t)rb_intern2("RECVHOPOPTS", 11));
#endif
#ifdef IPV6_RECVHOPLIMIT
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_RECVHOPLIMIT, (st_data_t)rb_intern2("RECVHOPLIMIT", 12));
#endif
#ifdef IPV6_RECVDSTOPTS
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_RECVDSTOPTS, (st_data_t)rb_intern2("RECVDSTOPTS", 11));
#endif
#ifdef IPV6_PKTINFO
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_PKTINFO, (st_data_t)rb_intern2("PKTINFO", 7));
#endif
#ifdef IPV6_PATHMTU
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_PATHMTU, (st_data_t)rb_intern2("PATHMTU", 7));
#endif
#ifdef IPV6_NEXTHOP
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_NEXTHOP, (st_data_t)rb_intern2("NEXTHOP", 7));
#endif
#ifdef IPV6_HOPOPTS
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_HOPOPTS, (st_data_t)rb_intern2("HOPOPTS", 7));
#endif
#ifdef IPV6_HOPLIMIT
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_HOPLIMIT, (st_data_t)rb_intern2("HOPLIMIT", 8));
#endif
#ifdef IPV6_DSTOPTS
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_DSTOPTS, (st_data_t)rb_intern2("DSTOPTS", 7));
#endif
#ifdef IPV6_DONTFRAG
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_DONTFRAG, (st_data_t)rb_intern2("DONTFRAG", 8));
#endif
#ifdef IPV6_CHECKSUM
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_CHECKSUM, (st_data_t)rb_intern2("CHECKSUM", 8));
#endif
#ifdef IPV6_V6ONLY
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_V6ONLY, (st_data_t)rb_intern2("V6ONLY", 6));
#endif
#ifdef IPV6_UNICAST_HOPS
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_UNICAST_HOPS, (st_data_t)rb_intern2("UNICAST_HOPS", 12));
#endif
#ifdef IPV6_MULTICAST_LOOP
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_MULTICAST_LOOP, (st_data_t)rb_intern2("MULTICAST_LOOP", 14));
#endif
#ifdef IPV6_MULTICAST_IF
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_MULTICAST_IF, (st_data_t)rb_intern2("MULTICAST_IF", 12));
#endif
#ifdef IPV6_MULTICAST_HOPS
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_MULTICAST_HOPS, (st_data_t)rb_intern2("MULTICAST_HOPS", 14));
#endif
#ifdef IPV6_LEAVE_GROUP
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_LEAVE_GROUP, (st_data_t)rb_intern2("LEAVE_GROUP", 11));
#endif
#ifdef IPV6_JOIN_GROUP
    st_insert(rsock_intern_ipv6_optname_hash, (st_data_t)IPV6_JOIN_GROUP, (st_data_t)rb_intern2("JOIN_GROUP", 10));
#endif

    rsock_intern_tcp_optname_hash = st_init_numtable();
#ifdef TCP_USER_TIMEOUT
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_USER_TIMEOUT, (st_data_t)rb_intern2("TCP_USER_TIMEOUT", 16));
#endif
#ifdef TCP_TIMESTAMP
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_TIMESTAMP, (st_data_t)rb_intern2("TCP_TIMESTAMP", 13));
#endif
#ifdef TCP_THIN_LINEAR_TIMEOUTS
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_THIN_LINEAR_TIMEOUTS, (st_data_t)rb_intern2("TCP_THIN_LINEAR_TIMEOUTS", 24));
#endif
#ifdef TCP_THIN_DUPACK
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_THIN_DUPACK, (st_data_t)rb_intern2("TCP_THIN_DUPACK", 15));
#endif
#ifdef TCP_REPAIR_QUEUE
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_REPAIR_QUEUE, (st_data_t)rb_intern2("TCP_REPAIR_QUEUE", 16));
#endif
#ifdef TCP_REPAIR_OPTIONS
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_REPAIR_OPTIONS, (st_data_t)rb_intern2("TCP_REPAIR_OPTIONS", 18));
#endif
#ifdef TCP_REPAIR
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_REPAIR, (st_data_t)rb_intern2("TCP_REPAIR", 10));
#endif
#ifdef TCP_QUEUE_SEQ
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_QUEUE_SEQ, (st_data_t)rb_intern2("TCP_QUEUE_SEQ", 13));
#endif
#ifdef TCP_COOKIE_TRANSACTIONS
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_COOKIE_TRANSACTIONS, (st_data_t)rb_intern2("TCP_COOKIE_TRANSACTIONS", 23));
#endif
#ifdef TCP_CONGESTION
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_CONGESTION, (st_data_t)rb_intern2("TCP_CONGESTION", 14));
#endif
#ifdef TCP_FASTOPEN
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_FASTOPEN, (st_data_t)rb_intern2("TCP_FASTOPEN", 12));
#endif
#ifdef TCP_WINDOW_CLAMP
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_WINDOW_CLAMP, (st_data_t)rb_intern2("TCP_WINDOW_CLAMP", 16));
#endif
#ifdef TCP_SYNCNT
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_SYNCNT, (st_data_t)rb_intern2("TCP_SYNCNT", 10));
#endif
#ifdef TCP_QUICKACK
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_QUICKACK, (st_data_t)rb_intern2("TCP_QUICKACK", 12));
#endif
#ifdef TCP_NOPUSH
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_NOPUSH, (st_data_t)rb_intern2("TCP_NOPUSH", 10));
#endif
#ifdef TCP_NOOPT
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_NOOPT, (st_data_t)rb_intern2("TCP_NOOPT", 9));
#endif
#ifdef TCP_MD5SIG
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_MD5SIG, (st_data_t)rb_intern2("TCP_MD5SIG", 10));
#endif
#ifdef TCP_LINGER2
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_LINGER2, (st_data_t)rb_intern2("TCP_LINGER2", 11));
#endif
#ifdef TCP_KEEPINTVL
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_KEEPINTVL, (st_data_t)rb_intern2("TCP_KEEPINTVL", 13));
#endif
#ifdef TCP_KEEPIDLE
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_KEEPIDLE, (st_data_t)rb_intern2("TCP_KEEPIDLE", 12));
#endif
#ifdef TCP_KEEPCNT
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_KEEPCNT, (st_data_t)rb_intern2("TCP_KEEPCNT", 11));
#endif
#ifdef TCP_INFO
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_INFO, (st_data_t)rb_intern2("TCP_INFO", 8));
#endif
#ifdef TCP_DEFER_ACCEPT
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_DEFER_ACCEPT, (st_data_t)rb_intern2("TCP_DEFER_ACCEPT", 16));
#endif
#ifdef TCP_CORK
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_CORK, (st_data_t)rb_intern2("TCP_CORK", 8));
#endif
#ifdef TCP_MAXSEG
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_MAXSEG, (st_data_t)rb_intern2("TCP_MAXSEG", 10));
#endif
#ifdef TCP_NODELAY
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_NODELAY, (st_data_t)rb_intern2("TCP_NODELAY", 11));
#endif
#ifdef TCP_USER_TIMEOUT
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_USER_TIMEOUT, (st_data_t)rb_intern2("USER_TIMEOUT", 12));
#endif
#ifdef TCP_TIMESTAMP
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_TIMESTAMP, (st_data_t)rb_intern2("TIMESTAMP", 9));
#endif
#ifdef TCP_THIN_LINEAR_TIMEOUTS
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_THIN_LINEAR_TIMEOUTS, (st_data_t)rb_intern2("THIN_LINEAR_TIMEOUTS", 20));
#endif
#ifdef TCP_THIN_DUPACK
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_THIN_DUPACK, (st_data_t)rb_intern2("THIN_DUPACK", 11));
#endif
#ifdef TCP_REPAIR_QUEUE
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_REPAIR_QUEUE, (st_data_t)rb_intern2("REPAIR_QUEUE", 12));
#endif
#ifdef TCP_REPAIR_OPTIONS
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_REPAIR_OPTIONS, (st_data_t)rb_intern2("REPAIR_OPTIONS", 14));
#endif
#ifdef TCP_REPAIR
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_REPAIR, (st_data_t)rb_intern2("REPAIR", 6));
#endif
#ifdef TCP_QUEUE_SEQ
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_QUEUE_SEQ, (st_data_t)rb_intern2("QUEUE_SEQ", 9));
#endif
#ifdef TCP_COOKIE_TRANSACTIONS
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_COOKIE_TRANSACTIONS, (st_data_t)rb_intern2("COOKIE_TRANSACTIONS", 19));
#endif
#ifdef TCP_CONGESTION
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_CONGESTION, (st_data_t)rb_intern2("CONGESTION", 10));
#endif
#ifdef TCP_FASTOPEN
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_FASTOPEN, (st_data_t)rb_intern2("FASTOPEN", 8));
#endif
#ifdef TCP_WINDOW_CLAMP
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_WINDOW_CLAMP, (st_data_t)rb_intern2("WINDOW_CLAMP", 12));
#endif
#ifdef TCP_SYNCNT
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_SYNCNT, (st_data_t)rb_intern2("SYNCNT", 6));
#endif
#ifdef TCP_QUICKACK
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_QUICKACK, (st_data_t)rb_intern2("QUICKACK", 8));
#endif
#ifdef TCP_NOPUSH
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_NOPUSH, (st_data_t)rb_intern2("NOPUSH", 6));
#endif
#ifdef TCP_NOOPT
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_NOOPT, (st_data_t)rb_intern2("NOOPT", 5));
#endif
#ifdef TCP_MD5SIG
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_MD5SIG, (st_data_t)rb_intern2("MD5SIG", 6));
#endif
#ifdef TCP_LINGER2
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_LINGER2, (st_data_t)rb_intern2("LINGER2", 7));
#endif
#ifdef TCP_KEEPINTVL
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_KEEPINTVL, (st_data_t)rb_intern2("KEEPINTVL", 9));
#endif
#ifdef TCP_KEEPIDLE
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_KEEPIDLE, (st_data_t)rb_intern2("KEEPIDLE", 8));
#endif
#ifdef TCP_KEEPCNT
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_KEEPCNT, (st_data_t)rb_intern2("KEEPCNT", 7));
#endif
#ifdef TCP_INFO
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_INFO, (st_data_t)rb_intern2("INFO", 4));
#endif
#ifdef TCP_DEFER_ACCEPT
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_DEFER_ACCEPT, (st_data_t)rb_intern2("DEFER_ACCEPT", 12));
#endif
#ifdef TCP_CORK
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_CORK, (st_data_t)rb_intern2("CORK", 4));
#endif
#ifdef TCP_MAXSEG
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_MAXSEG, (st_data_t)rb_intern2("MAXSEG", 6));
#endif
#ifdef TCP_NODELAY
    st_insert(rsock_intern_tcp_optname_hash, (st_data_t)TCP_NODELAY, (st_data_t)rb_intern2("NODELAY", 7));
#endif

    rsock_intern_udp_optname_hash = st_init_numtable();
#ifdef UDP_CORK
    st_insert(rsock_intern_udp_optname_hash, (st_data_t)UDP_CORK, (st_data_t)rb_intern2("UDP_CORK", 8));
#endif
#ifdef UDP_CORK
    st_insert(rsock_intern_udp_optname_hash, (st_data_t)UDP_CORK, (st_data_t)rb_intern2("CORK", 4));
#endif

    rsock_intern_scm_optname_hash = st_init_numtable();
#ifdef SCM_WIFI_STATUS
    st_insert(rsock_intern_scm_optname_hash, (st_data_t)SCM_WIFI_STATUS, (st_data_t)rb_intern2("SCM_WIFI_STATUS", 15));
#endif
#ifdef SCM_UCRED
    st_insert(rsock_intern_scm_optname_hash, (st_data_t)SCM_UCRED, (st_data_t)rb_intern2("SCM_UCRED", 9));
#endif
#ifdef SCM_CREDS
    st_insert(rsock_intern_scm_optname_hash, (st_data_t)SCM_CREDS, (st_data_t)rb_intern2("SCM_CREDS", 9));
#endif
#ifdef SCM_CREDENTIALS
    st_insert(rsock_intern_scm_optname_hash, (st_data_t)SCM_CREDENTIALS, (st_data_t)rb_intern2("SCM_CREDENTIALS", 15));
#endif
#ifdef SCM_BINTIME
    st_insert(rsock_intern_scm_optname_hash, (st_data_t)SCM_BINTIME, (st_data_t)rb_intern2("SCM_BINTIME", 11));
#endif
#ifdef SCM_TIMESTAMPING
    st_insert(rsock_intern_scm_optname_hash, (st_data_t)SCM_TIMESTAMPING, (st_data_t)rb_intern2("SCM_TIMESTAMPING", 16));
#endif
#ifdef SCM_TIMESTAMPNS
    st_insert(rsock_intern_scm_optname_hash, (st_data_t)SCM_TIMESTAMPNS, (st_data_t)rb_intern2("SCM_TIMESTAMPNS", 15));
#endif
#ifdef SCM_TIMESTAMP
    st_insert(rsock_intern_scm_optname_hash, (st_data_t)SCM_TIMESTAMP, (st_data_t)rb_intern2("SCM_TIMESTAMP", 13));
#endif
#ifdef SCM_RIGHTS
    st_insert(rsock_intern_scm_optname_hash, (st_data_t)SCM_RIGHTS, (st_data_t)rb_intern2("SCM_RIGHTS", 10));
#endif
#ifdef SCM_WIFI_STATUS
    st_insert(rsock_intern_scm_optname_hash, (st_data_t)SCM_WIFI_STATUS, (st_data_t)rb_intern2("WIFI_STATUS", 11));
#endif
#ifdef SCM_UCRED
    st_insert(rsock_intern_scm_optname_hash, (st_data_t)SCM_UCRED, (st_data_t)rb_intern2("UCRED", 5));
#endif
#ifdef SCM_CREDS
    st_insert(rsock_intern_scm_optname_hash, (st_data_t)SCM_CREDS, (st_data_t)rb_intern2("CREDS", 5));
#endif
#ifdef SCM_CREDENTIALS
    st_insert(rsock_intern_scm_optname_hash, (st_data_t)SCM_CREDENTIALS, (st_data_t)rb_intern2("CREDENTIALS", 11));
#endif
#ifdef SCM_BINTIME
    st_insert(rsock_intern_scm_optname_hash, (st_data_t)SCM_BINTIME, (st_data_t)rb_intern2("BINTIME", 7));
#endif
#ifdef SCM_TIMESTAMPING
    st_insert(rsock_intern_scm_optname_hash, (st_data_t)SCM_TIMESTAMPING, (st_data_t)rb_intern2("TIMESTAMPING", 12));
#endif
#ifdef SCM_TIMESTAMPNS
    st_insert(rsock_intern_scm_optname_hash, (st_data_t)SCM_TIMESTAMPNS, (st_data_t)rb_intern2("TIMESTAMPNS", 11));
#endif
#ifdef SCM_TIMESTAMP
    st_insert(rsock_intern_scm_optname_hash, (st_data_t)SCM_TIMESTAMP, (st_data_t)rb_intern2("TIMESTAMP", 9));
#endif
#ifdef SCM_RIGHTS
    st_insert(rsock_intern_scm_optname_hash, (st_data_t)SCM_RIGHTS, (st_data_t)rb_intern2("RIGHTS", 6));
#endif

    rsock_intern_local_optname_hash = st_init_numtable();
#ifdef LOCAL_CONNWAIT
    st_insert(rsock_intern_local_optname_hash, (st_data_t)LOCAL_CONNWAIT, (st_data_t)rb_intern2("LOCAL_CONNWAIT", 14));
#endif
#ifdef LOCAL_CREDS
    st_insert(rsock_intern_local_optname_hash, (st_data_t)LOCAL_CREDS, (st_data_t)rb_intern2("LOCAL_CREDS", 11));
#endif
#ifdef LOCAL_PEERCRED
    st_insert(rsock_intern_local_optname_hash, (st_data_t)LOCAL_PEERCRED, (st_data_t)rb_intern2("LOCAL_PEERCRED", 14));
#endif
#ifdef LOCAL_CONNWAIT
    st_insert(rsock_intern_local_optname_hash, (st_data_t)LOCAL_CONNWAIT, (st_data_t)rb_intern2("CONNWAIT", 8));
#endif
#ifdef LOCAL_CREDS
    st_insert(rsock_intern_local_optname_hash, (st_data_t)LOCAL_CREDS, (st_data_t)rb_intern2("CREDS", 5));
#endif
#ifdef LOCAL_PEERCRED
    st_insert(rsock_intern_local_optname_hash, (st_data_t)LOCAL_PEERCRED, (st_data_t)rb_intern2("PEERCRED", 8));
#endif

}

int
rsock_family_to_int(const char *str, long len, int *valp)
{
    switch (len) {
      case 2:
#ifdef AF_NS
        if (memcmp(str, "NS", 2) == 0) { *valp = AF_NS; return 0; }
#endif
        return -1;

      case 3:
#ifdef AF_IPX
        if (memcmp(str, "IPX", 3) == 0) { *valp = AF_IPX; return 0; }
#endif
#ifdef AF_PUP
        if (memcmp(str, "PUP", 3) == 0) { *valp = AF_PUP; return 0; }
#endif
#ifdef AF_ISO
        if (memcmp(str, "ISO", 3) == 0) { *valp = AF_ISO; return 0; }
#endif
#ifdef AF_OSI
        if (memcmp(str, "OSI", 3) == 0) { *valp = AF_OSI; return 0; }
#endif
#ifdef AF_SNA
        if (memcmp(str, "SNA", 3) == 0) { *valp = AF_SNA; return 0; }
#endif
#ifdef AF_DEC
        if (memcmp(str, "DEC", 3) == 0) { *valp = AF_DEC; return 0; }
#endif
#ifdef AF_DLI
        if (memcmp(str, "DLI", 3) == 0) { *valp = AF_DLI; return 0; }
#endif
#ifdef AF_LAT
        if (memcmp(str, "LAT", 3) == 0) { *valp = AF_LAT; return 0; }
#endif
#ifdef AF_CNT
        if (memcmp(str, "CNT", 3) == 0) { *valp = AF_CNT; return 0; }
#endif
#ifdef AF_SIP
        if (memcmp(str, "SIP", 3) == 0) { *valp = AF_SIP; return 0; }
#endif
#ifdef AF_PPP
        if (memcmp(str, "PPP", 3) == 0) { *valp = AF_PPP; return 0; }
#endif
#ifdef AF_ATM
        if (memcmp(str, "ATM", 3) == 0) { *valp = AF_ATM; return 0; }
#endif
#ifdef AF_MAX
        if (memcmp(str, "MAX", 3) == 0) { *valp = AF_MAX; return 0; }
#endif
        return -1;

      case 4:
#ifdef AF_INET
        if (memcmp(str, "INET", 4) == 0) { *valp = AF_INET; return 0; }
#endif
#ifdef AF_UNIX
        if (memcmp(str, "UNIX", 4) == 0) { *valp = AF_UNIX; return 0; }
#endif
#ifdef AF_AX25
        if (memcmp(str, "AX25", 4) == 0) { *valp = AF_AX25; return 0; }
#endif
#ifdef AF_ECMA
        if (memcmp(str, "ECMA", 4) == 0) { *valp = AF_ECMA; return 0; }
#endif
#ifdef AF_LINK
        if (memcmp(str, "LINK", 4) == 0) { *valp = AF_LINK; return 0; }
#endif
#ifdef AF_COIP
        if (memcmp(str, "COIP", 4) == 0) { *valp = AF_COIP; return 0; }
#endif
#ifdef AF_NDRV
        if (memcmp(str, "NDRV", 4) == 0) { *valp = AF_NDRV; return 0; }
#endif
#ifdef AF_ISDN
        if (memcmp(str, "ISDN", 4) == 0) { *valp = AF_ISDN; return 0; }
#endif
#ifdef AF_NATM
        if (memcmp(str, "NATM", 4) == 0) { *valp = AF_NATM; return 0; }
#endif
#ifdef AF_E164
        if (memcmp(str, "E164", 4) == 0) { *valp = AF_E164; return 0; }
#endif
        return -1;

      case 5:
#ifdef AF_NS
        if (memcmp(str, "AF_NS", 5) == 0) { *valp = AF_NS; return 0; }
#endif
#ifdef PF_NS
        if (memcmp(str, "PF_NS", 5) == 0) { *valp = PF_NS; return 0; }
#endif
#ifdef AF_INET6
        if (memcmp(str, "INET6", 5) == 0) { *valp = AF_INET6; return 0; }
#endif
#ifdef AF_LOCAL
        if (memcmp(str, "LOCAL", 5) == 0) { *valp = AF_LOCAL; return 0; }
#endif
#ifdef AF_CHAOS
        if (memcmp(str, "CHAOS", 5) == 0) { *valp = AF_CHAOS; return 0; }
#endif
#ifdef AF_CCITT
        if (memcmp(str, "CCITT", 5) == 0) { *valp = AF_CCITT; return 0; }
#endif
#ifdef AF_ROUTE
        if (memcmp(str, "ROUTE", 5) == 0) { *valp = AF_ROUTE; return 0; }
#endif
        return -1;

      case 6:
#ifdef AF_IPX
        if (memcmp(str, "AF_IPX", 6) == 0) { *valp = AF_IPX; return 0; }
#endif
#ifdef PF_IPX
        if (memcmp(str, "PF_IPX", 6) == 0) { *valp = PF_IPX; return 0; }
#endif
#ifdef AF_PUP
        if (memcmp(str, "AF_PUP", 6) == 0) { *valp = AF_PUP; return 0; }
#endif
#ifdef PF_PUP
        if (memcmp(str, "PF_PUP", 6) == 0) { *valp = PF_PUP; return 0; }
#endif
#ifdef AF_ISO
        if (memcmp(str, "AF_ISO", 6) == 0) { *valp = AF_ISO; return 0; }
#endif
#ifdef PF_ISO
        if (memcmp(str, "PF_ISO", 6) == 0) { *valp = PF_ISO; return 0; }
#endif
#ifdef AF_OSI
        if (memcmp(str, "AF_OSI", 6) == 0) { *valp = AF_OSI; return 0; }
#endif
#ifdef PF_OSI
        if (memcmp(str, "PF_OSI", 6) == 0) { *valp = PF_OSI; return 0; }
#endif
#ifdef AF_SNA
        if (memcmp(str, "AF_SNA", 6) == 0) { *valp = AF_SNA; return 0; }
#endif
#ifdef PF_SNA
        if (memcmp(str, "PF_SNA", 6) == 0) { *valp = PF_SNA; return 0; }
#endif
#ifdef AF_DEC
        if (memcmp(str, "AF_DEC", 6) == 0) { *valp = AF_DEC; return 0; }
#endif
#ifdef PF_DEC
        if (memcmp(str, "PF_DEC", 6) == 0) { *valp = PF_DEC; return 0; }
#endif
#ifdef AF_DLI
        if (memcmp(str, "AF_DLI", 6) == 0) { *valp = AF_DLI; return 0; }
#endif
#ifdef PF_DLI
        if (memcmp(str, "PF_DLI", 6) == 0) { *valp = PF_DLI; return 0; }
#endif
#ifdef AF_LAT
        if (memcmp(str, "AF_LAT", 6) == 0) { *valp = AF_LAT; return 0; }
#endif
#ifdef PF_LAT
        if (memcmp(str, "PF_LAT", 6) == 0) { *valp = PF_LAT; return 0; }
#endif
#ifdef AF_CNT
        if (memcmp(str, "AF_CNT", 6) == 0) { *valp = AF_CNT; return 0; }
#endif
#ifdef PF_CNT
        if (memcmp(str, "PF_CNT", 6) == 0) { *valp = PF_CNT; return 0; }
#endif
#ifdef AF_SIP
        if (memcmp(str, "AF_SIP", 6) == 0) { *valp = AF_SIP; return 0; }
#endif
#ifdef PF_SIP
        if (memcmp(str, "PF_SIP", 6) == 0) { *valp = PF_SIP; return 0; }
#endif
#ifdef AF_PPP
        if (memcmp(str, "AF_PPP", 6) == 0) { *valp = AF_PPP; return 0; }
#endif
#ifdef PF_PPP
        if (memcmp(str, "PF_PPP", 6) == 0) { *valp = PF_PPP; return 0; }
#endif
#ifdef AF_ATM
        if (memcmp(str, "AF_ATM", 6) == 0) { *valp = AF_ATM; return 0; }
#endif
#ifdef PF_ATM
        if (memcmp(str, "PF_ATM", 6) == 0) { *valp = PF_ATM; return 0; }
#endif
#ifdef AF_MAX
        if (memcmp(str, "AF_MAX", 6) == 0) { *valp = AF_MAX; return 0; }
#endif
#ifdef PF_MAX
        if (memcmp(str, "PF_MAX", 6) == 0) { *valp = PF_MAX; return 0; }
#endif
#ifdef PF_XTP
        if (memcmp(str, "PF_XTP", 6) == 0) { *valp = PF_XTP; return 0; }
#endif
#ifdef PF_PIP
        if (memcmp(str, "PF_PIP", 6) == 0) { *valp = PF_PIP; return 0; }
#endif
#ifdef PF_KEY
        if (memcmp(str, "PF_KEY", 6) == 0) { *valp = PF_KEY; return 0; }
#endif
#ifdef AF_UNSPEC
        if (memcmp(str, "UNSPEC", 6) == 0) { *valp = AF_UNSPEC; return 0; }
#endif
#ifdef AF_HYLINK
        if (memcmp(str, "HYLINK", 6) == 0) { *valp = AF_HYLINK; return 0; }
#endif
#ifdef AF_SYSTEM
        if (memcmp(str, "SYSTEM", 6) == 0) { *valp = AF_SYSTEM; return 0; }
#endif
#ifdef AF_PACKET
        if (memcmp(str, "PACKET", 6) == 0) { *valp = AF_PACKET; return 0; }
#endif
        return -1;

      case 7:
#ifdef AF_INET
        if (memcmp(str, "AF_INET", 7) == 0) { *valp = AF_INET; return 0; }
#endif
#ifdef PF_INET
        if (memcmp(str, "PF_INET", 7) == 0) { *valp = PF_INET; return 0; }
#endif
#ifdef AF_UNIX
        if (memcmp(str, "AF_UNIX", 7) == 0) { *valp = AF_UNIX; return 0; }
#endif
#ifdef PF_UNIX
        if (memcmp(str, "PF_UNIX", 7) == 0) { *valp = PF_UNIX; return 0; }
#endif
#ifdef AF_AX25
        if (memcmp(str, "AF_AX25", 7) == 0) { *valp = AF_AX25; return 0; }
#endif
#ifdef PF_AX25
        if (memcmp(str, "PF_AX25", 7) == 0) { *valp = PF_AX25; return 0; }
#endif
#ifdef AF_ECMA
        if (memcmp(str, "AF_ECMA", 7) == 0) { *valp = AF_ECMA; return 0; }
#endif
#ifdef PF_ECMA
        if (memcmp(str, "PF_ECMA", 7) == 0) { *valp = PF_ECMA; return 0; }
#endif
#ifdef AF_LINK
        if (memcmp(str, "AF_LINK", 7) == 0) { *valp = AF_LINK; return 0; }
#endif
#ifdef PF_LINK
        if (memcmp(str, "PF_LINK", 7) == 0) { *valp = PF_LINK; return 0; }
#endif
#ifdef AF_COIP
        if (memcmp(str, "AF_COIP", 7) == 0) { *valp = AF_COIP; return 0; }
#endif
#ifdef PF_COIP
        if (memcmp(str, "PF_COIP", 7) == 0) { *valp = PF_COIP; return 0; }
#endif
#ifdef AF_NDRV
        if (memcmp(str, "AF_NDRV", 7) == 0) { *valp = AF_NDRV; return 0; }
#endif
#ifdef PF_NDRV
        if (memcmp(str, "PF_NDRV", 7) == 0) { *valp = PF_NDRV; return 0; }
#endif
#ifdef AF_ISDN
        if (memcmp(str, "AF_ISDN", 7) == 0) { *valp = AF_ISDN; return 0; }
#endif
#ifdef PF_ISDN
        if (memcmp(str, "PF_ISDN", 7) == 0) { *valp = PF_ISDN; return 0; }
#endif
#ifdef AF_NATM
        if (memcmp(str, "AF_NATM", 7) == 0) { *valp = AF_NATM; return 0; }
#endif
#ifdef PF_NATM
        if (memcmp(str, "PF_NATM", 7) == 0) { *valp = PF_NATM; return 0; }
#endif
#ifdef AF_E164
        if (memcmp(str, "AF_E164", 7) == 0) { *valp = AF_E164; return 0; }
#endif
#ifdef PF_RTIP
        if (memcmp(str, "PF_RTIP", 7) == 0) { *valp = PF_RTIP; return 0; }
#endif
#ifdef AF_IMPLINK
        if (memcmp(str, "IMPLINK", 7) == 0) { *valp = AF_IMPLINK; return 0; }
#endif
#ifdef AF_DATAKIT
        if (memcmp(str, "DATAKIT", 7) == 0) { *valp = AF_DATAKIT; return 0; }
#endif
#ifdef AF_NETBIOS
        if (memcmp(str, "NETBIOS", 7) == 0) { *valp = AF_NETBIOS; return 0; }
#endif
        return -1;

      case 8:
#ifdef AF_INET6
        if (memcmp(str, "AF_INET6", 8) == 0) { *valp = AF_INET6; return 0; }
#endif
#ifdef PF_INET6
        if (memcmp(str, "PF_INET6", 8) == 0) { *valp = PF_INET6; return 0; }
#endif
#ifdef AF_LOCAL
        if (memcmp(str, "AF_LOCAL", 8) == 0) { *valp = AF_LOCAL; return 0; }
#endif
#ifdef PF_LOCAL
        if (memcmp(str, "PF_LOCAL", 8) == 0) { *valp = PF_LOCAL; return 0; }
#endif
#ifdef AF_CHAOS
        if (memcmp(str, "AF_CHAOS", 8) == 0) { *valp = AF_CHAOS; return 0; }
#endif
#ifdef PF_CHAOS
        if (memcmp(str, "PF_CHAOS", 8) == 0) { *valp = PF_CHAOS; return 0; }
#endif
#ifdef AF_CCITT
        if (memcmp(str, "AF_CCITT", 8) == 0) { *valp = AF_CCITT; return 0; }
#endif
#ifdef PF_CCITT
        if (memcmp(str, "PF_CCITT", 8) == 0) { *valp = PF_CCITT; return 0; }
#endif
#ifdef AF_ROUTE
        if (memcmp(str, "AF_ROUTE", 8) == 0) { *valp = AF_ROUTE; return 0; }
#endif
#ifdef PF_ROUTE
        if (memcmp(str, "PF_ROUTE", 8) == 0) { *valp = PF_ROUTE; return 0; }
#endif
#ifdef AF_NETGRAPH
        if (memcmp(str, "NETGRAPH", 8) == 0) { *valp = AF_NETGRAPH; return 0; }
#endif
        return -1;

      case 9:
#ifdef AF_UNSPEC
        if (memcmp(str, "AF_UNSPEC", 9) == 0) { *valp = AF_UNSPEC; return 0; }
#endif
#ifdef PF_UNSPEC
        if (memcmp(str, "PF_UNSPEC", 9) == 0) { *valp = PF_UNSPEC; return 0; }
#endif
#ifdef AF_HYLINK
        if (memcmp(str, "AF_HYLINK", 9) == 0) { *valp = AF_HYLINK; return 0; }
#endif
#ifdef PF_HYLINK
        if (memcmp(str, "PF_HYLINK", 9) == 0) { *valp = PF_HYLINK; return 0; }
#endif
#ifdef AF_SYSTEM
        if (memcmp(str, "AF_SYSTEM", 9) == 0) { *valp = AF_SYSTEM; return 0; }
#endif
#ifdef PF_SYSTEM
        if (memcmp(str, "PF_SYSTEM", 9) == 0) { *valp = PF_SYSTEM; return 0; }
#endif
#ifdef AF_PACKET
        if (memcmp(str, "AF_PACKET", 9) == 0) { *valp = AF_PACKET; return 0; }
#endif
#ifdef PF_PACKET
        if (memcmp(str, "PF_PACKET", 9) == 0) { *valp = PF_PACKET; return 0; }
#endif
#ifdef AF_APPLETALK
        if (memcmp(str, "APPLETALK", 9) == 0) { *valp = AF_APPLETALK; return 0; }
#endif
        return -1;

      case 10:
#ifdef AF_IMPLINK
        if (memcmp(str, "AF_IMPLINK", 10) == 0) { *valp = AF_IMPLINK; return 0; }
#endif
#ifdef PF_IMPLINK
        if (memcmp(str, "PF_IMPLINK", 10) == 0) { *valp = PF_IMPLINK; return 0; }
#endif
#ifdef AF_DATAKIT
        if (memcmp(str, "AF_DATAKIT", 10) == 0) { *valp = AF_DATAKIT; return 0; }
#endif
#ifdef PF_DATAKIT
        if (memcmp(str, "PF_DATAKIT", 10) == 0) { *valp = PF_DATAKIT; return 0; }
#endif
#ifdef AF_NETBIOS
        if (memcmp(str, "AF_NETBIOS", 10) == 0) { *valp = AF_NETBIOS; return 0; }
#endif
#ifdef PF_NETBIOS
        if (memcmp(str, "PF_NETBIOS", 10) == 0) { *valp = PF_NETBIOS; return 0; }
#endif
        return -1;

      case 11:
#ifdef AF_NETGRAPH
        if (memcmp(str, "AF_NETGRAPH", 11) == 0) { *valp = AF_NETGRAPH; return 0; }
#endif
#ifdef PF_NETGRAPH
        if (memcmp(str, "PF_NETGRAPH", 11) == 0) { *valp = PF_NETGRAPH; return 0; }
#endif
        return -1;

      case 12:
#ifdef AF_APPLETALK
        if (memcmp(str, "AF_APPLETALK", 12) == 0) { *valp = AF_APPLETALK; return 0; }
#endif
#ifdef PF_APPLETALK
        if (memcmp(str, "PF_APPLETALK", 12) == 0) { *valp = PF_APPLETALK; return 0; }
#endif
        return -1;

      default:
        if (!str || !valp) {/* wrong argument */}
        return -1;
    }
}


int
rsock_socktype_to_int(const char *str, long len, int *valp)
{
    switch (len) {
      case 3:
#ifdef SOCK_RAW
        if (memcmp(str, "RAW", 3) == 0) { *valp = SOCK_RAW; return 0; }
#endif
#ifdef SOCK_RDM
        if (memcmp(str, "RDM", 3) == 0) { *valp = SOCK_RDM; return 0; }
#endif
        return -1;

      case 5:
#ifdef SOCK_DGRAM
        if (memcmp(str, "DGRAM", 5) == 0) { *valp = SOCK_DGRAM; return 0; }
#endif
        return -1;

      case 6:
#ifdef SOCK_STREAM
        if (memcmp(str, "STREAM", 6) == 0) { *valp = SOCK_STREAM; return 0; }
#endif
#ifdef SOCK_PACKET
        if (memcmp(str, "PACKET", 6) == 0) { *valp = SOCK_PACKET; return 0; }
#endif
        return -1;

      case 8:
#ifdef SOCK_RAW
        if (memcmp(str, "SOCK_RAW", 8) == 0) { *valp = SOCK_RAW; return 0; }
#endif
#ifdef SOCK_RDM
        if (memcmp(str, "SOCK_RDM", 8) == 0) { *valp = SOCK_RDM; return 0; }
#endif
        return -1;

      case 9:
#ifdef SOCK_SEQPACKET
        if (memcmp(str, "SEQPACKET", 9) == 0) { *valp = SOCK_SEQPACKET; return 0; }
#endif
        return -1;

      case 10:
#ifdef SOCK_DGRAM
        if (memcmp(str, "SOCK_DGRAM", 10) == 0) { *valp = SOCK_DGRAM; return 0; }
#endif
        return -1;

      case 11:
#ifdef SOCK_STREAM
        if (memcmp(str, "SOCK_STREAM", 11) == 0) { *valp = SOCK_STREAM; return 0; }
#endif
#ifdef SOCK_PACKET
        if (memcmp(str, "SOCK_PACKET", 11) == 0) { *valp = SOCK_PACKET; return 0; }
#endif
        return -1;

      case 14:
#ifdef SOCK_SEQPACKET
        if (memcmp(str, "SOCK_SEQPACKET", 14) == 0) { *valp = SOCK_SEQPACKET; return 0; }
#endif
        return -1;

      default:
        if (!str || !valp) {/* wrong argument */}
        return -1;
    }
}


int
rsock_ipproto_to_int(const char *str, long len, int *valp)
{
    switch (len) {
      case 2:
#ifdef IPPROTO_IP
        if (memcmp(str, "IP", 2) == 0) { *valp = IPPROTO_IP; return 0; }
#endif
#ifdef IPPROTO_ND
        if (memcmp(str, "ND", 2) == 0) { *valp = IPPROTO_ND; return 0; }
#endif
#ifdef IPPROTO_TP
        if (memcmp(str, "TP", 2) == 0) { *valp = IPPROTO_TP; return 0; }
#endif
#ifdef IPPROTO_AH
        if (memcmp(str, "AH", 2) == 0) { *valp = IPPROTO_AH; return 0; }
#endif
        return -1;

      case 3:
#ifdef IPPROTO_GGP
        if (memcmp(str, "GGP", 3) == 0) { *valp = IPPROTO_GGP; return 0; }
#endif
#ifdef IPPROTO_TCP
        if (memcmp(str, "TCP", 3) == 0) { *valp = IPPROTO_TCP; return 0; }
#endif
#ifdef IPPROTO_EGP
        if (memcmp(str, "EGP", 3) == 0) { *valp = IPPROTO_EGP; return 0; }
#endif
#ifdef IPPROTO_PUP
        if (memcmp(str, "PUP", 3) == 0) { *valp = IPPROTO_PUP; return 0; }
#endif
#ifdef IPPROTO_UDP
        if (memcmp(str, "UDP", 3) == 0) { *valp = IPPROTO_UDP; return 0; }
#endif
#ifdef IPPROTO_IDP
        if (memcmp(str, "IDP", 3) == 0) { *valp = IPPROTO_IDP; return 0; }
#endif
#ifdef IPPROTO_XTP
        if (memcmp(str, "XTP", 3) == 0) { *valp = IPPROTO_XTP; return 0; }
#endif
#ifdef IPPROTO_EON
        if (memcmp(str, "EON", 3) == 0) { *valp = IPPROTO_EON; return 0; }
#endif
#ifdef IPPROTO_BIP
        if (memcmp(str, "BIP", 3) == 0) { *valp = IPPROTO_BIP; return 0; }
#endif
#ifdef IPPROTO_ESP
        if (memcmp(str, "ESP", 3) == 0) { *valp = IPPROTO_ESP; return 0; }
#endif
#ifdef IPPROTO_RAW
        if (memcmp(str, "RAW", 3) == 0) { *valp = IPPROTO_RAW; return 0; }
#endif
#ifdef IPPROTO_MAX
        if (memcmp(str, "MAX", 3) == 0) { *valp = IPPROTO_MAX; return 0; }
#endif
        return -1;

      case 4:
#ifdef IPPROTO_ICMP
        if (memcmp(str, "ICMP", 4) == 0) { *valp = IPPROTO_ICMP; return 0; }
#endif
#ifdef IPPROTO_IGMP
        if (memcmp(str, "IGMP", 4) == 0) { *valp = IPPROTO_IGMP; return 0; }
#endif
#ifdef IPPROTO_IPV6
        if (memcmp(str, "IPV6", 4) == 0) { *valp = IPPROTO_IPV6; return 0; }
#endif
#ifdef IPPROTO_NONE
        if (memcmp(str, "NONE", 4) == 0) { *valp = IPPROTO_NONE; return 0; }
#endif
        return -1;

      case 5:
#ifdef IPPROTO_HELLO
        if (memcmp(str, "HELLO", 5) == 0) { *valp = IPPROTO_HELLO; return 0; }
#endif
        return -1;

      case 6:
#ifdef IPPROTO_ICMPV6
        if (memcmp(str, "ICMPV6", 6) == 0) { *valp = IPPROTO_ICMPV6; return 0; }
#endif
        return -1;

      case 7:
#ifdef IPPROTO_DSTOPTS
        if (memcmp(str, "DSTOPTS", 7) == 0) { *valp = IPPROTO_DSTOPTS; return 0; }
#endif
#ifdef IPPROTO_HOPOPTS
        if (memcmp(str, "HOPOPTS", 7) == 0) { *valp = IPPROTO_HOPOPTS; return 0; }
#endif
#ifdef IPPROTO_ROUTING
        if (memcmp(str, "ROUTING", 7) == 0) { *valp = IPPROTO_ROUTING; return 0; }
#endif
        return -1;

      case 8:
#ifdef IPPROTO_FRAGMENT
        if (memcmp(str, "FRAGMENT", 8) == 0) { *valp = IPPROTO_FRAGMENT; return 0; }
#endif
        return -1;

      case 10:
#ifdef IPPROTO_IP
        if (memcmp(str, "IPPROTO_IP", 10) == 0) { *valp = IPPROTO_IP; return 0; }
#endif
#ifdef IPPROTO_ND
        if (memcmp(str, "IPPROTO_ND", 10) == 0) { *valp = IPPROTO_ND; return 0; }
#endif
#ifdef IPPROTO_TP
        if (memcmp(str, "IPPROTO_TP", 10) == 0) { *valp = IPPROTO_TP; return 0; }
#endif
#ifdef IPPROTO_AH
        if (memcmp(str, "IPPROTO_AH", 10) == 0) { *valp = IPPROTO_AH; return 0; }
#endif
        return -1;

      case 11:
#ifdef IPPROTO_GGP
        if (memcmp(str, "IPPROTO_GGP", 11) == 0) { *valp = IPPROTO_GGP; return 0; }
#endif
#ifdef IPPROTO_TCP
        if (memcmp(str, "IPPROTO_TCP", 11) == 0) { *valp = IPPROTO_TCP; return 0; }
#endif
#ifdef IPPROTO_EGP
        if (memcmp(str, "IPPROTO_EGP", 11) == 0) { *valp = IPPROTO_EGP; return 0; }
#endif
#ifdef IPPROTO_PUP
        if (memcmp(str, "IPPROTO_PUP", 11) == 0) { *valp = IPPROTO_PUP; return 0; }
#endif
#ifdef IPPROTO_UDP
        if (memcmp(str, "IPPROTO_UDP", 11) == 0) { *valp = IPPROTO_UDP; return 0; }
#endif
#ifdef IPPROTO_IDP
        if (memcmp(str, "IPPROTO_IDP", 11) == 0) { *valp = IPPROTO_IDP; return 0; }
#endif
#ifdef IPPROTO_XTP
        if (memcmp(str, "IPPROTO_XTP", 11) == 0) { *valp = IPPROTO_XTP; return 0; }
#endif
#ifdef IPPROTO_EON
        if (memcmp(str, "IPPROTO_EON", 11) == 0) { *valp = IPPROTO_EON; return 0; }
#endif
#ifdef IPPROTO_BIP
        if (memcmp(str, "IPPROTO_BIP", 11) == 0) { *valp = IPPROTO_BIP; return 0; }
#endif
#ifdef IPPROTO_ESP
        if (memcmp(str, "IPPROTO_ESP", 11) == 0) { *valp = IPPROTO_ESP; return 0; }
#endif
#ifdef IPPROTO_RAW
        if (memcmp(str, "IPPROTO_RAW", 11) == 0) { *valp = IPPROTO_RAW; return 0; }
#endif
#ifdef IPPROTO_MAX
        if (memcmp(str, "IPPROTO_MAX", 11) == 0) { *valp = IPPROTO_MAX; return 0; }
#endif
        return -1;

      case 12:
#ifdef IPPROTO_ICMP
        if (memcmp(str, "IPPROTO_ICMP", 12) == 0) { *valp = IPPROTO_ICMP; return 0; }
#endif
#ifdef IPPROTO_IGMP
        if (memcmp(str, "IPPROTO_IGMP", 12) == 0) { *valp = IPPROTO_IGMP; return 0; }
#endif
#ifdef IPPROTO_IPV6
        if (memcmp(str, "IPPROTO_IPV6", 12) == 0) { *valp = IPPROTO_IPV6; return 0; }
#endif
#ifdef IPPROTO_NONE
        if (memcmp(str, "IPPROTO_NONE", 12) == 0) { *valp = IPPROTO_NONE; return 0; }
#endif
        return -1;

      case 13:
#ifdef IPPROTO_HELLO
        if (memcmp(str, "IPPROTO_HELLO", 13) == 0) { *valp = IPPROTO_HELLO; return 0; }
#endif
        return -1;

      case 14:
#ifdef IPPROTO_ICMPV6
        if (memcmp(str, "IPPROTO_ICMPV6", 14) == 0) { *valp = IPPROTO_ICMPV6; return 0; }
#endif
        return -1;

      case 15:
#ifdef IPPROTO_DSTOPTS
        if (memcmp(str, "IPPROTO_DSTOPTS", 15) == 0) { *valp = IPPROTO_DSTOPTS; return 0; }
#endif
#ifdef IPPROTO_HOPOPTS
        if (memcmp(str, "IPPROTO_HOPOPTS", 15) == 0) { *valp = IPPROTO_HOPOPTS; return 0; }
#endif
#ifdef IPPROTO_ROUTING
        if (memcmp(str, "IPPROTO_ROUTING", 15) == 0) { *valp = IPPROTO_ROUTING; return 0; }
#endif
        return -1;

      case 16:
#ifdef IPPROTO_FRAGMENT
        if (memcmp(str, "IPPROTO_FRAGMENT", 16) == 0) { *valp = IPPROTO_FRAGMENT; return 0; }
#endif
        return -1;

      default:
        if (!str || !valp) {/* wrong argument */}
        return -1;
    }
}


int
rsock_unknown_level_to_int(const char *str, long len, int *valp)
{
    switch (len) {
      case 6:
#ifdef SOL_SOCKET
        if (memcmp(str, "SOCKET", 6) == 0) { *valp = SOL_SOCKET; return 0; }
#endif
        return -1;

      case 10:
#ifdef SOL_SOCKET
        if (memcmp(str, "SOL_SOCKET", 10) == 0) { *valp = SOL_SOCKET; return 0; }
#endif
        return -1;

      default:
        if (!str || !valp) {/* wrong argument */}
        return -1;
    }
}


int
rsock_ip_level_to_int(const char *str, long len, int *valp)
{
    switch (len) {
      case 2:
#ifdef IPPROTO_IP
        if (memcmp(str, "IP", 2) == 0) { *valp = IPPROTO_IP; return 0; }
#endif
#ifdef IPPROTO_ND
        if (memcmp(str, "ND", 2) == 0) { *valp = IPPROTO_ND; return 0; }
#endif
#ifdef IPPROTO_TP
        if (memcmp(str, "TP", 2) == 0) { *valp = IPPROTO_TP; return 0; }
#endif
#ifdef IPPROTO_AH
        if (memcmp(str, "AH", 2) == 0) { *valp = IPPROTO_AH; return 0; }
#endif
        return -1;

      case 3:
#ifdef IPPROTO_GGP
        if (memcmp(str, "GGP", 3) == 0) { *valp = IPPROTO_GGP; return 0; }
#endif
#ifdef IPPROTO_TCP
        if (memcmp(str, "TCP", 3) == 0) { *valp = IPPROTO_TCP; return 0; }
#endif
#ifdef IPPROTO_EGP
        if (memcmp(str, "EGP", 3) == 0) { *valp = IPPROTO_EGP; return 0; }
#endif
#ifdef IPPROTO_PUP
        if (memcmp(str, "PUP", 3) == 0) { *valp = IPPROTO_PUP; return 0; }
#endif
#ifdef IPPROTO_UDP
        if (memcmp(str, "UDP", 3) == 0) { *valp = IPPROTO_UDP; return 0; }
#endif
#ifdef IPPROTO_IDP
        if (memcmp(str, "IDP", 3) == 0) { *valp = IPPROTO_IDP; return 0; }
#endif
#ifdef IPPROTO_XTP
        if (memcmp(str, "XTP", 3) == 0) { *valp = IPPROTO_XTP; return 0; }
#endif
#ifdef IPPROTO_EON
        if (memcmp(str, "EON", 3) == 0) { *valp = IPPROTO_EON; return 0; }
#endif
#ifdef IPPROTO_BIP
        if (memcmp(str, "BIP", 3) == 0) { *valp = IPPROTO_BIP; return 0; }
#endif
#ifdef IPPROTO_ESP
        if (memcmp(str, "ESP", 3) == 0) { *valp = IPPROTO_ESP; return 0; }
#endif
#ifdef IPPROTO_RAW
        if (memcmp(str, "RAW", 3) == 0) { *valp = IPPROTO_RAW; return 0; }
#endif
#ifdef IPPROTO_MAX
        if (memcmp(str, "MAX", 3) == 0) { *valp = IPPROTO_MAX; return 0; }
#endif
        return -1;

      case 4:
#ifdef IPPROTO_ICMP
        if (memcmp(str, "ICMP", 4) == 0) { *valp = IPPROTO_ICMP; return 0; }
#endif
#ifdef IPPROTO_IGMP
        if (memcmp(str, "IGMP", 4) == 0) { *valp = IPPROTO_IGMP; return 0; }
#endif
#ifdef IPPROTO_IPV6
        if (memcmp(str, "IPV6", 4) == 0) { *valp = IPPROTO_IPV6; return 0; }
#endif
#ifdef IPPROTO_NONE
        if (memcmp(str, "NONE", 4) == 0) { *valp = IPPROTO_NONE; return 0; }
#endif
        return -1;

      case 5:
#ifdef IPPROTO_HELLO
        if (memcmp(str, "HELLO", 5) == 0) { *valp = IPPROTO_HELLO; return 0; }
#endif
        return -1;

      case 6:
#ifdef SOL_SOCKET
        if (memcmp(str, "SOCKET", 6) == 0) { *valp = SOL_SOCKET; return 0; }
#endif
#ifdef IPPROTO_ICMPV6
        if (memcmp(str, "ICMPV6", 6) == 0) { *valp = IPPROTO_ICMPV6; return 0; }
#endif
        return -1;

      case 7:
#ifdef IPPROTO_DSTOPTS
        if (memcmp(str, "DSTOPTS", 7) == 0) { *valp = IPPROTO_DSTOPTS; return 0; }
#endif
#ifdef IPPROTO_HOPOPTS
        if (memcmp(str, "HOPOPTS", 7) == 0) { *valp = IPPROTO_HOPOPTS; return 0; }
#endif
#ifdef IPPROTO_ROUTING
        if (memcmp(str, "ROUTING", 7) == 0) { *valp = IPPROTO_ROUTING; return 0; }
#endif
        return -1;

      case 8:
#ifdef IPPROTO_FRAGMENT
        if (memcmp(str, "FRAGMENT", 8) == 0) { *valp = IPPROTO_FRAGMENT; return 0; }
#endif
        return -1;

      case 10:
#ifdef SOL_SOCKET
        if (memcmp(str, "SOL_SOCKET", 10) == 0) { *valp = SOL_SOCKET; return 0; }
#endif
#ifdef IPPROTO_IP
        if (memcmp(str, "IPPROTO_IP", 10) == 0) { *valp = IPPROTO_IP; return 0; }
#endif
#ifdef IPPROTO_ND
        if (memcmp(str, "IPPROTO_ND", 10) == 0) { *valp = IPPROTO_ND; return 0; }
#endif
#ifdef IPPROTO_TP
        if (memcmp(str, "IPPROTO_TP", 10) == 0) { *valp = IPPROTO_TP; return 0; }
#endif
#ifdef IPPROTO_AH
        if (memcmp(str, "IPPROTO_AH", 10) == 0) { *valp = IPPROTO_AH; return 0; }
#endif
        return -1;

      case 11:
#ifdef IPPROTO_GGP
        if (memcmp(str, "IPPROTO_GGP", 11) == 0) { *valp = IPPROTO_GGP; return 0; }
#endif
#ifdef IPPROTO_TCP
        if (memcmp(str, "IPPROTO_TCP", 11) == 0) { *valp = IPPROTO_TCP; return 0; }
#endif
#ifdef IPPROTO_EGP
        if (memcmp(str, "IPPROTO_EGP", 11) == 0) { *valp = IPPROTO_EGP; return 0; }
#endif
#ifdef IPPROTO_PUP
        if (memcmp(str, "IPPROTO_PUP", 11) == 0) { *valp = IPPROTO_PUP; return 0; }
#endif
#ifdef IPPROTO_UDP
        if (memcmp(str, "IPPROTO_UDP", 11) == 0) { *valp = IPPROTO_UDP; return 0; }
#endif
#ifdef IPPROTO_IDP
        if (memcmp(str, "IPPROTO_IDP", 11) == 0) { *valp = IPPROTO_IDP; return 0; }
#endif
#ifdef IPPROTO_XTP
        if (memcmp(str, "IPPROTO_XTP", 11) == 0) { *valp = IPPROTO_XTP; return 0; }
#endif
#ifdef IPPROTO_EON
        if (memcmp(str, "IPPROTO_EON", 11) == 0) { *valp = IPPROTO_EON; return 0; }
#endif
#ifdef IPPROTO_BIP
        if (memcmp(str, "IPPROTO_BIP", 11) == 0) { *valp = IPPROTO_BIP; return 0; }
#endif
#ifdef IPPROTO_ESP
        if (memcmp(str, "IPPROTO_ESP", 11) == 0) { *valp = IPPROTO_ESP; return 0; }
#endif
#ifdef IPPROTO_RAW
        if (memcmp(str, "IPPROTO_RAW", 11) == 0) { *valp = IPPROTO_RAW; return 0; }
#endif
#ifdef IPPROTO_MAX
        if (memcmp(str, "IPPROTO_MAX", 11) == 0) { *valp = IPPROTO_MAX; return 0; }
#endif
        return -1;

      case 12:
#ifdef IPPROTO_ICMP
        if (memcmp(str, "IPPROTO_ICMP", 12) == 0) { *valp = IPPROTO_ICMP; return 0; }
#endif
#ifdef IPPROTO_IGMP
        if (memcmp(str, "IPPROTO_IGMP", 12) == 0) { *valp = IPPROTO_IGMP; return 0; }
#endif
#ifdef IPPROTO_IPV6
        if (memcmp(str, "IPPROTO_IPV6", 12) == 0) { *valp = IPPROTO_IPV6; return 0; }
#endif
#ifdef IPPROTO_NONE
        if (memcmp(str, "IPPROTO_NONE", 12) == 0) { *valp = IPPROTO_NONE; return 0; }
#endif
        return -1;

      case 13:
#ifdef IPPROTO_HELLO
        if (memcmp(str, "IPPROTO_HELLO", 13) == 0) { *valp = IPPROTO_HELLO; return 0; }
#endif
        return -1;

      case 14:
#ifdef IPPROTO_ICMPV6
        if (memcmp(str, "IPPROTO_ICMPV6", 14) == 0) { *valp = IPPROTO_ICMPV6; return 0; }
#endif
        return -1;

      case 15:
#ifdef IPPROTO_DSTOPTS
        if (memcmp(str, "IPPROTO_DSTOPTS", 15) == 0) { *valp = IPPROTO_DSTOPTS; return 0; }
#endif
#ifdef IPPROTO_HOPOPTS
        if (memcmp(str, "IPPROTO_HOPOPTS", 15) == 0) { *valp = IPPROTO_HOPOPTS; return 0; }
#endif
#ifdef IPPROTO_ROUTING
        if (memcmp(str, "IPPROTO_ROUTING", 15) == 0) { *valp = IPPROTO_ROUTING; return 0; }
#endif
        return -1;

      case 16:
#ifdef IPPROTO_FRAGMENT
        if (memcmp(str, "IPPROTO_FRAGMENT", 16) == 0) { *valp = IPPROTO_FRAGMENT; return 0; }
#endif
        return -1;

      default:
        if (!str || !valp) {/* wrong argument */}
        return -1;
    }
}


int
rsock_so_optname_to_int(const char *str, long len, int *valp)
{
    switch (len) {
      case 3:
#ifdef SO_NKE
        if (memcmp(str, "NKE", 3) == 0) { *valp = SO_NKE; return 0; }
#endif
        return -1;

      case 4:
#ifdef SO_TYPE
        if (memcmp(str, "TYPE", 4) == 0) { *valp = SO_TYPE; return 0; }
#endif
#ifdef SO_MARK
        if (memcmp(str, "MARK", 4) == 0) { *valp = SO_MARK; return 0; }
#endif
        return -1;

      case 5:
#ifdef SO_DEBUG
        if (memcmp(str, "DEBUG", 5) == 0) { *valp = SO_DEBUG; return 0; }
#endif
#ifdef SO_ERROR
        if (memcmp(str, "ERROR", 5) == 0) { *valp = SO_ERROR; return 0; }
#endif
#ifdef SO_NREAD
        if (memcmp(str, "NREAD", 5) == 0) { *valp = SO_NREAD; return 0; }
#endif
#ifdef SO_NOFCS
        if (memcmp(str, "NOFCS", 5) == 0) { *valp = SO_NOFCS; return 0; }
#endif
        return -1;

      case 6:
#ifdef SO_NKE
        if (memcmp(str, "SO_NKE", 6) == 0) { *valp = SO_NKE; return 0; }
#endif
#ifdef SO_SNDBUF
        if (memcmp(str, "SNDBUF", 6) == 0) { *valp = SO_SNDBUF; return 0; }
#endif
#ifdef SO_RCVBUF
        if (memcmp(str, "RCVBUF", 6) == 0) { *valp = SO_RCVBUF; return 0; }
#endif
#ifdef SO_LINGER
        if (memcmp(str, "LINGER", 6) == 0) { *valp = SO_LINGER; return 0; }
#endif
#ifdef SO_DOMAIN
        if (memcmp(str, "DOMAIN", 6) == 0) { *valp = SO_DOMAIN; return 0; }
#endif
        return -1;

      case 7:
#ifdef SO_TYPE
        if (memcmp(str, "SO_TYPE", 7) == 0) { *valp = SO_TYPE; return 0; }
#endif
#ifdef SO_MARK
        if (memcmp(str, "SO_MARK", 7) == 0) { *valp = SO_MARK; return 0; }
#endif
#ifdef SO_BINTIME
        if (memcmp(str, "BINTIME", 7) == 0) { *valp = SO_BINTIME; return 0; }
#endif
#ifdef SO_PEERSEC
        if (memcmp(str, "PEERSEC", 7) == 0) { *valp = SO_PEERSEC; return 0; }
#endif
#ifdef SO_PASSSEC
        if (memcmp(str, "PASSSEC", 7) == 0) { *valp = SO_PASSSEC; return 0; }
#endif
        return -1;

      case 8:
#ifdef SO_DEBUG
        if (memcmp(str, "SO_DEBUG", 8) == 0) { *valp = SO_DEBUG; return 0; }
#endif
#ifdef SO_ERROR
        if (memcmp(str, "SO_ERROR", 8) == 0) { *valp = SO_ERROR; return 0; }
#endif
#ifdef SO_NREAD
        if (memcmp(str, "SO_NREAD", 8) == 0) { *valp = SO_NREAD; return 0; }
#endif
#ifdef SO_NOFCS
        if (memcmp(str, "SO_NOFCS", 8) == 0) { *valp = SO_NOFCS; return 0; }
#endif
#ifdef SO_NO_CHECK
        if (memcmp(str, "NO_CHECK", 8) == 0) { *valp = SO_NO_CHECK; return 0; }
#endif
#ifdef SO_PRIORITY
        if (memcmp(str, "PRIORITY", 8) == 0) { *valp = SO_PRIORITY; return 0; }
#endif
#ifdef SO_PASSCRED
        if (memcmp(str, "PASSCRED", 8) == 0) { *valp = SO_PASSCRED; return 0; }
#endif
#ifdef SO_PEERCRED
        if (memcmp(str, "PEERCRED", 8) == 0) { *valp = SO_PEERCRED; return 0; }
#endif
#ifdef SO_RCVLOWAT
        if (memcmp(str, "RCVLOWAT", 8) == 0) { *valp = SO_RCVLOWAT; return 0; }
#endif
#ifdef SO_SNDLOWAT
        if (memcmp(str, "SNDLOWAT", 8) == 0) { *valp = SO_SNDLOWAT; return 0; }
#endif
#ifdef SO_RCVTIMEO
        if (memcmp(str, "RCVTIMEO", 8) == 0) { *valp = SO_RCVTIMEO; return 0; }
#endif
#ifdef SO_SNDTIMEO
        if (memcmp(str, "SNDTIMEO", 8) == 0) { *valp = SO_SNDTIMEO; return 0; }
#endif
#ifdef SO_WANTMORE
        if (memcmp(str, "WANTMORE", 8) == 0) { *valp = SO_WANTMORE; return 0; }
#endif
#ifdef SO_PEERNAME
        if (memcmp(str, "PEERNAME", 8) == 0) { *valp = SO_PEERNAME; return 0; }
#endif
#ifdef SO_ALLZONES
        if (memcmp(str, "ALLZONES", 8) == 0) { *valp = SO_ALLZONES; return 0; }
#endif
#ifdef SO_PROTOCOL
        if (memcmp(str, "PROTOCOL", 8) == 0) { *valp = SO_PROTOCOL; return 0; }
#endif
#ifdef SO_RXQ_OVFL
        if (memcmp(str, "RXQ_OVFL", 8) == 0) { *valp = SO_RXQ_OVFL; return 0; }
#endif
#ifdef SO_PEEK_OFF
        if (memcmp(str, "PEEK_OFF", 8) == 0) { *valp = SO_PEEK_OFF; return 0; }
#endif
        return -1;

      case 9:
#ifdef SO_SNDBUF
        if (memcmp(str, "SO_SNDBUF", 9) == 0) { *valp = SO_SNDBUF; return 0; }
#endif
#ifdef SO_RCVBUF
        if (memcmp(str, "SO_RCVBUF", 9) == 0) { *valp = SO_RCVBUF; return 0; }
#endif
#ifdef SO_LINGER
        if (memcmp(str, "SO_LINGER", 9) == 0) { *valp = SO_LINGER; return 0; }
#endif
#ifdef SO_DOMAIN
        if (memcmp(str, "SO_DOMAIN", 9) == 0) { *valp = SO_DOMAIN; return 0; }
#endif
#ifdef SO_REUSEADDR
        if (memcmp(str, "REUSEADDR", 9) == 0) { *valp = SO_REUSEADDR; return 0; }
#endif
#ifdef SO_REUSEPORT
        if (memcmp(str, "REUSEPORT", 9) == 0) { *valp = SO_REUSEPORT; return 0; }
#endif
#ifdef SO_DONTROUTE
        if (memcmp(str, "DONTROUTE", 9) == 0) { *valp = SO_DONTROUTE; return 0; }
#endif
#ifdef SO_BROADCAST
        if (memcmp(str, "BROADCAST", 9) == 0) { *valp = SO_BROADCAST; return 0; }
#endif
#ifdef SO_KEEPALIVE
        if (memcmp(str, "KEEPALIVE", 9) == 0) { *valp = SO_KEEPALIVE; return 0; }
#endif
#ifdef SO_OOBINLINE
        if (memcmp(str, "OOBINLINE", 9) == 0) { *valp = SO_OOBINLINE; return 0; }
#endif
#ifdef SO_DONTTRUNC
        if (memcmp(str, "DONTTRUNC", 9) == 0) { *valp = SO_DONTTRUNC; return 0; }
#endif
#ifdef SO_NOSIGPIPE
        if (memcmp(str, "NOSIGPIPE", 9) == 0) { *valp = SO_NOSIGPIPE; return 0; }
#endif
#ifdef SO_TIMESTAMP
        if (memcmp(str, "TIMESTAMP", 9) == 0) { *valp = SO_TIMESTAMP; return 0; }
#endif
#ifdef SO_RECVUCRED
        if (memcmp(str, "RECVUCRED", 9) == 0) { *valp = SO_RECVUCRED; return 0; }
#endif
#ifdef SO_BUSY_POLL
        if (memcmp(str, "BUSY_POLL", 9) == 0) { *valp = SO_BUSY_POLL; return 0; }
#endif
        return -1;

      case 10:
#ifdef SO_BINTIME
        if (memcmp(str, "SO_BINTIME", 10) == 0) { *valp = SO_BINTIME; return 0; }
#endif
#ifdef SO_PEERSEC
        if (memcmp(str, "SO_PEERSEC", 10) == 0) { *valp = SO_PEERSEC; return 0; }
#endif
#ifdef SO_PASSSEC
        if (memcmp(str, "SO_PASSSEC", 10) == 0) { *valp = SO_PASSSEC; return 0; }
#endif
#ifdef SO_ACCEPTCONN
        if (memcmp(str, "ACCEPTCONN", 10) == 0) { *valp = SO_ACCEPTCONN; return 0; }
#endif
#ifdef SO_GET_FILTER
        if (memcmp(str, "GET_FILTER", 10) == 0) { *valp = SO_GET_FILTER; return 0; }
#endif
#ifdef SO_MAC_EXEMPT
        if (memcmp(str, "MAC_EXEMPT", 10) == 0) { *valp = SO_MAC_EXEMPT; return 0; }
#endif
        return -1;

      case 11:
#ifdef SO_NO_CHECK
        if (memcmp(str, "SO_NO_CHECK", 11) == 0) { *valp = SO_NO_CHECK; return 0; }
#endif
#ifdef SO_PRIORITY
        if (memcmp(str, "SO_PRIORITY", 11) == 0) { *valp = SO_PRIORITY; return 0; }
#endif
#ifdef SO_PASSCRED
        if (memcmp(str, "SO_PASSCRED", 11) == 0) { *valp = SO_PASSCRED; return 0; }
#endif
#ifdef SO_PEERCRED
        if (memcmp(str, "SO_PEERCRED", 11) == 0) { *valp = SO_PEERCRED; return 0; }
#endif
#ifdef SO_RCVLOWAT
        if (memcmp(str, "SO_RCVLOWAT", 11) == 0) { *valp = SO_RCVLOWAT; return 0; }
#endif
#ifdef SO_SNDLOWAT
        if (memcmp(str, "SO_SNDLOWAT", 11) == 0) { *valp = SO_SNDLOWAT; return 0; }
#endif
#ifdef SO_RCVTIMEO
        if (memcmp(str, "SO_RCVTIMEO", 11) == 0) { *valp = SO_RCVTIMEO; return 0; }
#endif
#ifdef SO_SNDTIMEO
        if (memcmp(str, "SO_SNDTIMEO", 11) == 0) { *valp = SO_SNDTIMEO; return 0; }
#endif
#ifdef SO_WANTMORE
        if (memcmp(str, "SO_WANTMORE", 11) == 0) { *valp = SO_WANTMORE; return 0; }
#endif
#ifdef SO_PEERNAME
        if (memcmp(str, "SO_PEERNAME", 11) == 0) { *valp = SO_PEERNAME; return 0; }
#endif
#ifdef SO_ALLZONES
        if (memcmp(str, "SO_ALLZONES", 11) == 0) { *valp = SO_ALLZONES; return 0; }
#endif
#ifdef SO_PROTOCOL
        if (memcmp(str, "SO_PROTOCOL", 11) == 0) { *valp = SO_PROTOCOL; return 0; }
#endif
#ifdef SO_RXQ_OVFL
        if (memcmp(str, "SO_RXQ_OVFL", 11) == 0) { *valp = SO_RXQ_OVFL; return 0; }
#endif
#ifdef SO_PEEK_OFF
        if (memcmp(str, "SO_PEEK_OFF", 11) == 0) { *valp = SO_PEEK_OFF; return 0; }
#endif
#ifdef SO_SNDBUFFORCE
        if (memcmp(str, "SNDBUFFORCE", 11) == 0) { *valp = SO_SNDBUFFORCE; return 0; }
#endif
#ifdef SO_RCVBUFFORCE
        if (memcmp(str, "RCVBUFFORCE", 11) == 0) { *valp = SO_RCVBUFFORCE; return 0; }
#endif
#ifdef SO_USELOOPBACK
        if (memcmp(str, "USELOOPBACK", 11) == 0) { *valp = SO_USELOOPBACK; return 0; }
#endif
#ifdef SO_WANTOOBFLAG
        if (memcmp(str, "WANTOOBFLAG", 11) == 0) { *valp = SO_WANTOOBFLAG; return 0; }
#endif
#ifdef SO_TIMESTAMPNS
        if (memcmp(str, "TIMESTAMPNS", 11) == 0) { *valp = SO_TIMESTAMPNS; return 0; }
#endif
#ifdef SO_WIFI_STATUS
        if (memcmp(str, "WIFI_STATUS", 11) == 0) { *valp = SO_WIFI_STATUS; return 0; }
#endif
#ifdef SO_LOCK_FILTER
        if (memcmp(str, "LOCK_FILTER", 11) == 0) { *valp = SO_LOCK_FILTER; return 0; }
#endif
        return -1;

      case 12:
#ifdef SO_REUSEADDR
        if (memcmp(str, "SO_REUSEADDR", 12) == 0) { *valp = SO_REUSEADDR; return 0; }
#endif
#ifdef SO_REUSEPORT
        if (memcmp(str, "SO_REUSEPORT", 12) == 0) { *valp = SO_REUSEPORT; return 0; }
#endif
#ifdef SO_DONTROUTE
        if (memcmp(str, "SO_DONTROUTE", 12) == 0) { *valp = SO_DONTROUTE; return 0; }
#endif
#ifdef SO_BROADCAST
        if (memcmp(str, "SO_BROADCAST", 12) == 0) { *valp = SO_BROADCAST; return 0; }
#endif
#ifdef SO_KEEPALIVE
        if (memcmp(str, "SO_KEEPALIVE", 12) == 0) { *valp = SO_KEEPALIVE; return 0; }
#endif
#ifdef SO_OOBINLINE
        if (memcmp(str, "SO_OOBINLINE", 12) == 0) { *valp = SO_OOBINLINE; return 0; }
#endif
#ifdef SO_DONTTRUNC
        if (memcmp(str, "SO_DONTTRUNC", 12) == 0) { *valp = SO_DONTTRUNC; return 0; }
#endif
#ifdef SO_NOSIGPIPE
        if (memcmp(str, "SO_NOSIGPIPE", 12) == 0) { *valp = SO_NOSIGPIPE; return 0; }
#endif
#ifdef SO_TIMESTAMP
        if (memcmp(str, "SO_TIMESTAMP", 12) == 0) { *valp = SO_TIMESTAMP; return 0; }
#endif
#ifdef SO_RECVUCRED
        if (memcmp(str, "SO_RECVUCRED", 12) == 0) { *valp = SO_RECVUCRED; return 0; }
#endif
#ifdef SO_BUSY_POLL
        if (memcmp(str, "SO_BUSY_POLL", 12) == 0) { *valp = SO_BUSY_POLL; return 0; }
#endif
#ifdef SO_ACCEPTFILTER
        if (memcmp(str, "ACCEPTFILTER", 12) == 0) { *valp = SO_ACCEPTFILTER; return 0; }
#endif
#ifdef SO_BINDTODEVICE
        if (memcmp(str, "BINDTODEVICE", 12) == 0) { *valp = SO_BINDTODEVICE; return 0; }
#endif
#ifdef SO_TIMESTAMPING
        if (memcmp(str, "TIMESTAMPING", 12) == 0) { *valp = SO_TIMESTAMPING; return 0; }
#endif
        return -1;

      case 13:
#ifdef SO_ACCEPTCONN
        if (memcmp(str, "SO_ACCEPTCONN", 13) == 0) { *valp = SO_ACCEPTCONN; return 0; }
#endif
#ifdef SO_GET_FILTER
        if (memcmp(str, "SO_GET_FILTER", 13) == 0) { *valp = SO_GET_FILTER; return 0; }
#endif
#ifdef SO_MAC_EXEMPT
        if (memcmp(str, "SO_MAC_EXEMPT", 13) == 0) { *valp = SO_MAC_EXEMPT; return 0; }
#endif
#ifdef SO_ATTACH_FILTER
        if (memcmp(str, "ATTACH_FILTER", 13) == 0) { *valp = SO_ATTACH_FILTER; return 0; }
#endif
#ifdef SO_DETACH_FILTER
        if (memcmp(str, "DETACH_FILTER", 13) == 0) { *valp = SO_DETACH_FILTER; return 0; }
#endif
        return -1;

      case 14:
#ifdef SO_SNDBUFFORCE
        if (memcmp(str, "SO_SNDBUFFORCE", 14) == 0) { *valp = SO_SNDBUFFORCE; return 0; }
#endif
#ifdef SO_RCVBUFFORCE
        if (memcmp(str, "SO_RCVBUFFORCE", 14) == 0) { *valp = SO_RCVBUFFORCE; return 0; }
#endif
#ifdef SO_USELOOPBACK
        if (memcmp(str, "SO_USELOOPBACK", 14) == 0) { *valp = SO_USELOOPBACK; return 0; }
#endif
#ifdef SO_WANTOOBFLAG
        if (memcmp(str, "SO_WANTOOBFLAG", 14) == 0) { *valp = SO_WANTOOBFLAG; return 0; }
#endif
#ifdef SO_TIMESTAMPNS
        if (memcmp(str, "SO_TIMESTAMPNS", 14) == 0) { *valp = SO_TIMESTAMPNS; return 0; }
#endif
#ifdef SO_WIFI_STATUS
        if (memcmp(str, "SO_WIFI_STATUS", 14) == 0) { *valp = SO_WIFI_STATUS; return 0; }
#endif
#ifdef SO_LOCK_FILTER
        if (memcmp(str, "SO_LOCK_FILTER", 14) == 0) { *valp = SO_LOCK_FILTER; return 0; }
#endif
#ifdef SO_BPF_EXTENSIONS
        if (memcmp(str, "BPF_EXTENSIONS", 14) == 0) { *valp = SO_BPF_EXTENSIONS; return 0; }
#endif
        return -1;

      case 15:
#ifdef SO_ACCEPTFILTER
        if (memcmp(str, "SO_ACCEPTFILTER", 15) == 0) { *valp = SO_ACCEPTFILTER; return 0; }
#endif
#ifdef SO_BINDTODEVICE
        if (memcmp(str, "SO_BINDTODEVICE", 15) == 0) { *valp = SO_BINDTODEVICE; return 0; }
#endif
#ifdef SO_TIMESTAMPING
        if (memcmp(str, "SO_TIMESTAMPING", 15) == 0) { *valp = SO_TIMESTAMPING; return 0; }
#endif
#ifdef SO_MAX_PACING_RATE
        if (memcmp(str, "MAX_PACING_RATE", 15) == 0) { *valp = SO_MAX_PACING_RATE; return 0; }
#endif
        return -1;

      case 16:
#ifdef SO_ATTACH_FILTER
        if (memcmp(str, "SO_ATTACH_FILTER", 16) == 0) { *valp = SO_ATTACH_FILTER; return 0; }
#endif
#ifdef SO_DETACH_FILTER
        if (memcmp(str, "SO_DETACH_FILTER", 16) == 0) { *valp = SO_DETACH_FILTER; return 0; }
#endif
#ifdef SO_SELECT_ERR_QUEUE
        if (memcmp(str, "SELECT_ERR_QUEUE", 16) == 0) { *valp = SO_SELECT_ERR_QUEUE; return 0; }
#endif
        return -1;

      case 17:
#ifdef SO_BPF_EXTENSIONS
        if (memcmp(str, "SO_BPF_EXTENSIONS", 17) == 0) { *valp = SO_BPF_EXTENSIONS; return 0; }
#endif
        return -1;

      case 18:
#ifdef SO_MAX_PACING_RATE
        if (memcmp(str, "SO_MAX_PACING_RATE", 18) == 0) { *valp = SO_MAX_PACING_RATE; return 0; }
#endif
        return -1;

      case 19:
#ifdef SO_SELECT_ERR_QUEUE
        if (memcmp(str, "SO_SELECT_ERR_QUEUE", 19) == 0) { *valp = SO_SELECT_ERR_QUEUE; return 0; }
#endif
        return -1;

      case 23:
#ifdef SO_SECURITY_AUTHENTICATION
        if (memcmp(str, "SECURITY_AUTHENTICATION", 23) == 0) { *valp = SO_SECURITY_AUTHENTICATION; return 0; }
#endif
        return -1;

      case 26:
#ifdef SO_SECURITY_AUTHENTICATION
        if (memcmp(str, "SO_SECURITY_AUTHENTICATION", 26) == 0) { *valp = SO_SECURITY_AUTHENTICATION; return 0; }
#endif
        return -1;

      case 27:
#ifdef SO_SECURITY_ENCRYPTION_NETWORK
        if (memcmp(str, "SECURITY_ENCRYPTION_NETWORK", 27) == 0) { *valp = SO_SECURITY_ENCRYPTION_NETWORK; return 0; }
#endif
        return -1;

      case 29:
#ifdef SO_SECURITY_ENCRYPTION_TRANSPORT
        if (memcmp(str, "SECURITY_ENCRYPTION_TRANSPORT", 29) == 0) { *valp = SO_SECURITY_ENCRYPTION_TRANSPORT; return 0; }
#endif
        return -1;

      case 30:
#ifdef SO_SECURITY_ENCRYPTION_NETWORK
        if (memcmp(str, "SO_SECURITY_ENCRYPTION_NETWORK", 30) == 0) { *valp = SO_SECURITY_ENCRYPTION_NETWORK; return 0; }
#endif
        return -1;

      case 32:
#ifdef SO_SECURITY_ENCRYPTION_TRANSPORT
        if (memcmp(str, "SO_SECURITY_ENCRYPTION_TRANSPORT", 32) == 0) { *valp = SO_SECURITY_ENCRYPTION_TRANSPORT; return 0; }
#endif
        return -1;

      default:
        if (!str || !valp) {/* wrong argument */}
        return -1;
    }
}


int
rsock_ip_optname_to_int(const char *str, long len, int *valp)
{
    switch (len) {
      case 3:
#ifdef IP_TOS
        if (memcmp(str, "TOS", 3) == 0) { *valp = IP_TOS; return 0; }
#endif
#ifdef IP_TTL
        if (memcmp(str, "TTL", 3) == 0) { *valp = IP_TTL; return 0; }
#endif
#ifdef IP_MTU
        if (memcmp(str, "MTU", 3) == 0) { *valp = IP_MTU; return 0; }
#endif
        return -1;

      case 6:
#ifdef IP_TOS
        if (memcmp(str, "IP_TOS", 6) == 0) { *valp = IP_TOS; return 0; }
#endif
#ifdef IP_TTL
        if (memcmp(str, "IP_TTL", 6) == 0) { *valp = IP_TTL; return 0; }
#endif
#ifdef IP_MTU
        if (memcmp(str, "IP_MTU", 6) == 0) { *valp = IP_MTU; return 0; }
#endif
#ifdef IP_MINTTL
        if (memcmp(str, "MINTTL", 6) == 0) { *valp = IP_MINTTL; return 0; }
#endif
#ifdef IP_RECVIF
        if (memcmp(str, "RECVIF", 6) == 0) { *valp = IP_RECVIF; return 0; }
#endif
        return -1;

      case 7:
#ifdef IP_OPTIONS
        if (memcmp(str, "OPTIONS", 7) == 0) { *valp = IP_OPTIONS; return 0; }
#endif
#ifdef IP_HDRINCL
        if (memcmp(str, "HDRINCL", 7) == 0) { *valp = IP_HDRINCL; return 0; }
#endif
#ifdef IP_RETOPTS
        if (memcmp(str, "RETOPTS", 7) == 0) { *valp = IP_RETOPTS; return 0; }
#endif
#ifdef IP_RECVTTL
        if (memcmp(str, "RECVTTL", 7) == 0) { *valp = IP_RECVTTL; return 0; }
#endif
#ifdef IP_PKTINFO
        if (memcmp(str, "PKTINFO", 7) == 0) { *valp = IP_PKTINFO; return 0; }
#endif
#ifdef IP_RECVERR
        if (memcmp(str, "RECVERR", 7) == 0) { *valp = IP_RECVERR; return 0; }
#endif
#ifdef IP_RECVTOS
        if (memcmp(str, "RECVTOS", 7) == 0) { *valp = IP_RECVTOS; return 0; }
#endif
#ifdef IP_PASSSEC
        if (memcmp(str, "PASSSEC", 7) == 0) { *valp = IP_PASSSEC; return 0; }
#endif
        return -1;

      case 8:
#ifdef IP_RECVOPTS
        if (memcmp(str, "RECVOPTS", 8) == 0) { *valp = IP_RECVOPTS; return 0; }
#endif
#ifdef IP_DONTFRAG
        if (memcmp(str, "DONTFRAG", 8) == 0) { *valp = IP_DONTFRAG; return 0; }
#endif
#ifdef IP_RECVSLLA
        if (memcmp(str, "RECVSLLA", 8) == 0) { *valp = IP_RECVSLLA; return 0; }
#endif
#ifdef IP_FREEBIND
        if (memcmp(str, "FREEBIND", 8) == 0) { *valp = IP_FREEBIND; return 0; }
#endif
#ifdef IP_MSFILTER
        if (memcmp(str, "MSFILTER", 8) == 0) { *valp = IP_MSFILTER; return 0; }
#endif
        return -1;

      case 9:
#ifdef IP_MINTTL
        if (memcmp(str, "IP_MINTTL", 9) == 0) { *valp = IP_MINTTL; return 0; }
#endif
#ifdef IP_RECVIF
        if (memcmp(str, "IP_RECVIF", 9) == 0) { *valp = IP_RECVIF; return 0; }
#endif
#ifdef IP_ONESBCAST
        if (memcmp(str, "ONESBCAST", 9) == 0) { *valp = IP_ONESBCAST; return 0; }
#endif
#ifdef IP_PORTRANGE
        if (memcmp(str, "PORTRANGE", 9) == 0) { *valp = IP_PORTRANGE; return 0; }
#endif
        return -1;

      case 10:
#ifdef IP_OPTIONS
        if (memcmp(str, "IP_OPTIONS", 10) == 0) { *valp = IP_OPTIONS; return 0; }
#endif
#ifdef IP_HDRINCL
        if (memcmp(str, "IP_HDRINCL", 10) == 0) { *valp = IP_HDRINCL; return 0; }
#endif
#ifdef IP_RETOPTS
        if (memcmp(str, "IP_RETOPTS", 10) == 0) { *valp = IP_RETOPTS; return 0; }
#endif
#ifdef IP_RECVTTL
        if (memcmp(str, "IP_RECVTTL", 10) == 0) { *valp = IP_RECVTTL; return 0; }
#endif
#ifdef IP_PKTINFO
        if (memcmp(str, "IP_PKTINFO", 10) == 0) { *valp = IP_PKTINFO; return 0; }
#endif
#ifdef IP_RECVERR
        if (memcmp(str, "IP_RECVERR", 10) == 0) { *valp = IP_RECVERR; return 0; }
#endif
#ifdef IP_RECVTOS
        if (memcmp(str, "IP_RECVTOS", 10) == 0) { *valp = IP_RECVTOS; return 0; }
#endif
#ifdef IP_PASSSEC
        if (memcmp(str, "IP_PASSSEC", 10) == 0) { *valp = IP_PASSSEC; return 0; }
#endif
#ifdef IP_PKTOPTIONS
        if (memcmp(str, "PKTOPTIONS", 10) == 0) { *valp = IP_PKTOPTIONS; return 0; }
#endif
        return -1;

      case 11:
#ifdef IP_RECVOPTS
        if (memcmp(str, "IP_RECVOPTS", 11) == 0) { *valp = IP_RECVOPTS; return 0; }
#endif
#ifdef IP_DONTFRAG
        if (memcmp(str, "IP_DONTFRAG", 11) == 0) { *valp = IP_DONTFRAG; return 0; }
#endif
#ifdef IP_RECVSLLA
        if (memcmp(str, "IP_RECVSLLA", 11) == 0) { *valp = IP_RECVSLLA; return 0; }
#endif
#ifdef IP_FREEBIND
        if (memcmp(str, "IP_FREEBIND", 11) == 0) { *valp = IP_FREEBIND; return 0; }
#endif
#ifdef IP_MSFILTER
        if (memcmp(str, "IP_MSFILTER", 11) == 0) { *valp = IP_MSFILTER; return 0; }
#endif
#ifdef IP_RECVRETOPTS
        if (memcmp(str, "RECVRETOPTS", 11) == 0) { *valp = IP_RECVRETOPTS; return 0; }
#endif
#ifdef IP_RECVDSTADDR
        if (memcmp(str, "RECVDSTADDR", 11) == 0) { *valp = IP_RECVDSTADDR; return 0; }
#endif
#ifdef IP_SENDSRCADDR
        if (memcmp(str, "SENDSRCADDR", 11) == 0) { *valp = IP_SENDSRCADDR; return 0; }
#endif
#ifdef IP_XFRM_POLICY
        if (memcmp(str, "XFRM_POLICY", 11) == 0) { *valp = IP_XFRM_POLICY; return 0; }
#endif
#ifdef IP_TRANSPARENT
        if (memcmp(str, "TRANSPARENT", 11) == 0) { *valp = IP_TRANSPARENT; return 0; }
#endif
#ifdef IP_PMTUDISC_DO
        if (memcmp(str, "PMTUDISC_DO", 11) == 0) { *valp = IP_PMTUDISC_DO; return 0; }
#endif
        return -1;

      case 12:
#ifdef IP_ONESBCAST
        if (memcmp(str, "IP_ONESBCAST", 12) == 0) { *valp = IP_ONESBCAST; return 0; }
#endif
#ifdef IP_PORTRANGE
        if (memcmp(str, "IP_PORTRANGE", 12) == 0) { *valp = IP_PORTRANGE; return 0; }
#endif
#ifdef IP_MULTICAST_IF
        if (memcmp(str, "MULTICAST_IF", 12) == 0) { *valp = IP_MULTICAST_IF; return 0; }
#endif
#ifdef IP_ROUTER_ALERT
        if (memcmp(str, "ROUTER_ALERT", 12) == 0) { *valp = IP_ROUTER_ALERT; return 0; }
#endif
#ifdef IP_MTU_DISCOVER
        if (memcmp(str, "MTU_DISCOVER", 12) == 0) { *valp = IP_MTU_DISCOVER; return 0; }
#endif
#ifdef IP_IPSEC_POLICY
        if (memcmp(str, "IPSEC_POLICY", 12) == 0) { *valp = IP_IPSEC_POLICY; return 0; }
#endif
#ifdef IP_BLOCK_SOURCE
        if (memcmp(str, "BLOCK_SOURCE", 12) == 0) { *valp = IP_BLOCK_SOURCE; return 0; }
#endif
        return -1;

      case 13:
#ifdef IP_PKTOPTIONS
        if (memcmp(str, "IP_PKTOPTIONS", 13) == 0) { *valp = IP_PKTOPTIONS; return 0; }
#endif
#ifdef IP_MULTICAST_TTL
        if (memcmp(str, "MULTICAST_TTL", 13) == 0) { *valp = IP_MULTICAST_TTL; return 0; }
#endif
#ifdef IP_PMTUDISC_DONT
        if (memcmp(str, "PMTUDISC_DONT", 13) == 0) { *valp = IP_PMTUDISC_DONT; return 0; }
#endif
#ifdef IP_PMTUDISC_WANT
        if (memcmp(str, "PMTUDISC_WANT", 13) == 0) { *valp = IP_PMTUDISC_WANT; return 0; }
#endif
        return -1;

      case 14:
#ifdef IP_RECVRETOPTS
        if (memcmp(str, "IP_RECVRETOPTS", 14) == 0) { *valp = IP_RECVRETOPTS; return 0; }
#endif
#ifdef IP_RECVDSTADDR
        if (memcmp(str, "IP_RECVDSTADDR", 14) == 0) { *valp = IP_RECVDSTADDR; return 0; }
#endif
#ifdef IP_SENDSRCADDR
        if (memcmp(str, "IP_SENDSRCADDR", 14) == 0) { *valp = IP_SENDSRCADDR; return 0; }
#endif
#ifdef IP_XFRM_POLICY
        if (memcmp(str, "IP_XFRM_POLICY", 14) == 0) { *valp = IP_XFRM_POLICY; return 0; }
#endif
#ifdef IP_TRANSPARENT
        if (memcmp(str, "IP_TRANSPARENT", 14) == 0) { *valp = IP_TRANSPARENT; return 0; }
#endif
#ifdef IP_PMTUDISC_DO
        if (memcmp(str, "IP_PMTUDISC_DO", 14) == 0) { *valp = IP_PMTUDISC_DO; return 0; }
#endif
#ifdef IP_MULTICAST_LOOP
        if (memcmp(str, "MULTICAST_LOOP", 14) == 0) { *valp = IP_MULTICAST_LOOP; return 0; }
#endif
#ifdef IP_ADD_MEMBERSHIP
        if (memcmp(str, "ADD_MEMBERSHIP", 14) == 0) { *valp = IP_ADD_MEMBERSHIP; return 0; }
#endif
#ifdef IP_UNBLOCK_SOURCE
        if (memcmp(str, "UNBLOCK_SOURCE", 14) == 0) { *valp = IP_UNBLOCK_SOURCE; return 0; }
#endif
        return -1;

      case 15:
#ifdef IP_MULTICAST_IF
        if (memcmp(str, "IP_MULTICAST_IF", 15) == 0) { *valp = IP_MULTICAST_IF; return 0; }
#endif
#ifdef IP_ROUTER_ALERT
        if (memcmp(str, "IP_ROUTER_ALERT", 15) == 0) { *valp = IP_ROUTER_ALERT; return 0; }
#endif
#ifdef IP_MTU_DISCOVER
        if (memcmp(str, "IP_MTU_DISCOVER", 15) == 0) { *valp = IP_MTU_DISCOVER; return 0; }
#endif
#ifdef IP_IPSEC_POLICY
        if (memcmp(str, "IP_IPSEC_POLICY", 15) == 0) { *valp = IP_IPSEC_POLICY; return 0; }
#endif
#ifdef IP_BLOCK_SOURCE
        if (memcmp(str, "IP_BLOCK_SOURCE", 15) == 0) { *valp = IP_BLOCK_SOURCE; return 0; }
#endif
#ifdef IP_DROP_MEMBERSHIP
        if (memcmp(str, "DROP_MEMBERSHIP", 15) == 0) { *valp = IP_DROP_MEMBERSHIP; return 0; }
#endif
#ifdef IP_MAX_MEMBERSHIPS
        if (memcmp(str, "MAX_MEMBERSHIPS", 15) == 0) { *valp = IP_MAX_MEMBERSHIPS; return 0; }
#endif
        return -1;

      case 16:
#ifdef IP_MULTICAST_TTL
        if (memcmp(str, "IP_MULTICAST_TTL", 16) == 0) { *valp = IP_MULTICAST_TTL; return 0; }
#endif
#ifdef IP_PMTUDISC_DONT
        if (memcmp(str, "IP_PMTUDISC_DONT", 16) == 0) { *valp = IP_PMTUDISC_DONT; return 0; }
#endif
#ifdef IP_PMTUDISC_WANT
        if (memcmp(str, "IP_PMTUDISC_WANT", 16) == 0) { *valp = IP_PMTUDISC_WANT; return 0; }
#endif
        return -1;

      case 17:
#ifdef IP_MULTICAST_LOOP
        if (memcmp(str, "IP_MULTICAST_LOOP", 17) == 0) { *valp = IP_MULTICAST_LOOP; return 0; }
#endif
#ifdef IP_ADD_MEMBERSHIP
        if (memcmp(str, "IP_ADD_MEMBERSHIP", 17) == 0) { *valp = IP_ADD_MEMBERSHIP; return 0; }
#endif
#ifdef IP_UNBLOCK_SOURCE
        if (memcmp(str, "IP_UNBLOCK_SOURCE", 17) == 0) { *valp = IP_UNBLOCK_SOURCE; return 0; }
#endif
        return -1;

      case 18:
#ifdef IP_DROP_MEMBERSHIP
        if (memcmp(str, "IP_DROP_MEMBERSHIP", 18) == 0) { *valp = IP_DROP_MEMBERSHIP; return 0; }
#endif
#ifdef IP_MAX_MEMBERSHIPS
        if (memcmp(str, "IP_MAX_MEMBERSHIPS", 18) == 0) { *valp = IP_MAX_MEMBERSHIPS; return 0; }
#endif
        return -1;

      case 21:
#ifdef IP_DEFAULT_MULTICAST_TTL
        if (memcmp(str, "DEFAULT_MULTICAST_TTL", 21) == 0) { *valp = IP_DEFAULT_MULTICAST_TTL; return 0; }
#endif
#ifdef IP_ADD_SOURCE_MEMBERSHIP
        if (memcmp(str, "ADD_SOURCE_MEMBERSHIP", 21) == 0) { *valp = IP_ADD_SOURCE_MEMBERSHIP; return 0; }
#endif
        return -1;

      case 22:
#ifdef IP_DEFAULT_MULTICAST_LOOP
        if (memcmp(str, "DEFAULT_MULTICAST_LOOP", 22) == 0) { *valp = IP_DEFAULT_MULTICAST_LOOP; return 0; }
#endif
#ifdef IP_DROP_SOURCE_MEMBERSHIP
        if (memcmp(str, "DROP_SOURCE_MEMBERSHIP", 22) == 0) { *valp = IP_DROP_SOURCE_MEMBERSHIP; return 0; }
#endif
        return -1;

      case 24:
#ifdef IP_DEFAULT_MULTICAST_TTL
        if (memcmp(str, "IP_DEFAULT_MULTICAST_TTL", 24) == 0) { *valp = IP_DEFAULT_MULTICAST_TTL; return 0; }
#endif
#ifdef IP_ADD_SOURCE_MEMBERSHIP
        if (memcmp(str, "IP_ADD_SOURCE_MEMBERSHIP", 24) == 0) { *valp = IP_ADD_SOURCE_MEMBERSHIP; return 0; }
#endif
        return -1;

      case 25:
#ifdef IP_DEFAULT_MULTICAST_LOOP
        if (memcmp(str, "IP_DEFAULT_MULTICAST_LOOP", 25) == 0) { *valp = IP_DEFAULT_MULTICAST_LOOP; return 0; }
#endif
#ifdef IP_DROP_SOURCE_MEMBERSHIP
        if (memcmp(str, "IP_DROP_SOURCE_MEMBERSHIP", 25) == 0) { *valp = IP_DROP_SOURCE_MEMBERSHIP; return 0; }
#endif
        return -1;

      default:
        if (!str || !valp) {/* wrong argument */}
        return -1;
    }
}


#ifdef IPPROTO_IPV6
int
rsock_ipv6_optname_to_int(const char *str, long len, int *valp)
{
    switch (len) {
      case 5:
#ifdef IPV6_RTHDR
        if (memcmp(str, "RTHDR", 5) == 0) { *valp = IPV6_RTHDR; return 0; }
#endif
        return -1;

      case 6:
#ifdef IPV6_V6ONLY
        if (memcmp(str, "V6ONLY", 6) == 0) { *valp = IPV6_V6ONLY; return 0; }
#endif
#ifdef IPV6_TCLASS
        if (memcmp(str, "TCLASS", 6) == 0) { *valp = IPV6_TCLASS; return 0; }
#endif
        return -1;

      case 7:
#ifdef IPV6_DSTOPTS
        if (memcmp(str, "DSTOPTS", 7) == 0) { *valp = IPV6_DSTOPTS; return 0; }
#endif
#ifdef IPV6_HOPOPTS
        if (memcmp(str, "HOPOPTS", 7) == 0) { *valp = IPV6_HOPOPTS; return 0; }
#endif
#ifdef IPV6_NEXTHOP
        if (memcmp(str, "NEXTHOP", 7) == 0) { *valp = IPV6_NEXTHOP; return 0; }
#endif
#ifdef IPV6_PATHMTU
        if (memcmp(str, "PATHMTU", 7) == 0) { *valp = IPV6_PATHMTU; return 0; }
#endif
#ifdef IPV6_PKTINFO
        if (memcmp(str, "PKTINFO", 7) == 0) { *valp = IPV6_PKTINFO; return 0; }
#endif
        return -1;

      case 8:
#ifdef IPV6_CHECKSUM
        if (memcmp(str, "CHECKSUM", 8) == 0) { *valp = IPV6_CHECKSUM; return 0; }
#endif
#ifdef IPV6_DONTFRAG
        if (memcmp(str, "DONTFRAG", 8) == 0) { *valp = IPV6_DONTFRAG; return 0; }
#endif
#ifdef IPV6_HOPLIMIT
        if (memcmp(str, "HOPLIMIT", 8) == 0) { *valp = IPV6_HOPLIMIT; return 0; }
#endif
        return -1;

      case 9:
#ifdef IPV6_RECVRTHDR
        if (memcmp(str, "RECVRTHDR", 9) == 0) { *valp = IPV6_RECVRTHDR; return 0; }
#endif
        return -1;

      case 10:
#ifdef IPV6_RTHDR
        if (memcmp(str, "IPV6_RTHDR", 10) == 0) { *valp = IPV6_RTHDR; return 0; }
#endif
#ifdef IPV6_JOIN_GROUP
        if (memcmp(str, "JOIN_GROUP", 10) == 0) { *valp = IPV6_JOIN_GROUP; return 0; }
#endif
#ifdef IPV6_RECVTCLASS
        if (memcmp(str, "RECVTCLASS", 10) == 0) { *valp = IPV6_RECVTCLASS; return 0; }
#endif
        return -1;

      case 11:
#ifdef IPV6_V6ONLY
        if (memcmp(str, "IPV6_V6ONLY", 11) == 0) { *valp = IPV6_V6ONLY; return 0; }
#endif
#ifdef IPV6_TCLASS
        if (memcmp(str, "IPV6_TCLASS", 11) == 0) { *valp = IPV6_TCLASS; return 0; }
#endif
#ifdef IPV6_LEAVE_GROUP
        if (memcmp(str, "LEAVE_GROUP", 11) == 0) { *valp = IPV6_LEAVE_GROUP; return 0; }
#endif
#ifdef IPV6_RECVDSTOPTS
        if (memcmp(str, "RECVDSTOPTS", 11) == 0) { *valp = IPV6_RECVDSTOPTS; return 0; }
#endif
#ifdef IPV6_RECVHOPOPTS
        if (memcmp(str, "RECVHOPOPTS", 11) == 0) { *valp = IPV6_RECVHOPOPTS; return 0; }
#endif
#ifdef IPV6_RECVPKTINFO
        if (memcmp(str, "RECVPKTINFO", 11) == 0) { *valp = IPV6_RECVPKTINFO; return 0; }
#endif
#ifdef IPV6_RECVPATHMTU
        if (memcmp(str, "RECVPATHMTU", 11) == 0) { *valp = IPV6_RECVPATHMTU; return 0; }
#endif
#ifdef IPV6_USE_MIN_MTU
        if (memcmp(str, "USE_MIN_MTU", 11) == 0) { *valp = IPV6_USE_MIN_MTU; return 0; }
#endif
        return -1;

      case 12:
#ifdef IPV6_DSTOPTS
        if (memcmp(str, "IPV6_DSTOPTS", 12) == 0) { *valp = IPV6_DSTOPTS; return 0; }
#endif
#ifdef IPV6_HOPOPTS
        if (memcmp(str, "IPV6_HOPOPTS", 12) == 0) { *valp = IPV6_HOPOPTS; return 0; }
#endif
#ifdef IPV6_NEXTHOP
        if (memcmp(str, "IPV6_NEXTHOP", 12) == 0) { *valp = IPV6_NEXTHOP; return 0; }
#endif
#ifdef IPV6_PATHMTU
        if (memcmp(str, "IPV6_PATHMTU", 12) == 0) { *valp = IPV6_PATHMTU; return 0; }
#endif
#ifdef IPV6_PKTINFO
        if (memcmp(str, "IPV6_PKTINFO", 12) == 0) { *valp = IPV6_PKTINFO; return 0; }
#endif
#ifdef IPV6_MULTICAST_IF
        if (memcmp(str, "MULTICAST_IF", 12) == 0) { *valp = IPV6_MULTICAST_IF; return 0; }
#endif
#ifdef IPV6_UNICAST_HOPS
        if (memcmp(str, "UNICAST_HOPS", 12) == 0) { *valp = IPV6_UNICAST_HOPS; return 0; }
#endif
#ifdef IPV6_RECVHOPLIMIT
        if (memcmp(str, "RECVHOPLIMIT", 12) == 0) { *valp = IPV6_RECVHOPLIMIT; return 0; }
#endif
#ifdef IPV6_RTHDRDSTOPTS
        if (memcmp(str, "RTHDRDSTOPTS", 12) == 0) { *valp = IPV6_RTHDRDSTOPTS; return 0; }
#endif
#ifdef IPV6_RTHDR_TYPE_0
        if (memcmp(str, "RTHDR_TYPE_0", 12) == 0) { *valp = IPV6_RTHDR_TYPE_0; return 0; }
#endif
        return -1;

      case 13:
#ifdef IPV6_CHECKSUM
        if (memcmp(str, "IPV6_CHECKSUM", 13) == 0) { *valp = IPV6_CHECKSUM; return 0; }
#endif
#ifdef IPV6_DONTFRAG
        if (memcmp(str, "IPV6_DONTFRAG", 13) == 0) { *valp = IPV6_DONTFRAG; return 0; }
#endif
#ifdef IPV6_HOPLIMIT
        if (memcmp(str, "IPV6_HOPLIMIT", 13) == 0) { *valp = IPV6_HOPLIMIT; return 0; }
#endif
        return -1;

      case 14:
#ifdef IPV6_RECVRTHDR
        if (memcmp(str, "IPV6_RECVRTHDR", 14) == 0) { *valp = IPV6_RECVRTHDR; return 0; }
#endif
#ifdef IPV6_MULTICAST_HOPS
        if (memcmp(str, "MULTICAST_HOPS", 14) == 0) { *valp = IPV6_MULTICAST_HOPS; return 0; }
#endif
#ifdef IPV6_MULTICAST_LOOP
        if (memcmp(str, "MULTICAST_LOOP", 14) == 0) { *valp = IPV6_MULTICAST_LOOP; return 0; }
#endif
        return -1;

      case 15:
#ifdef IPV6_JOIN_GROUP
        if (memcmp(str, "IPV6_JOIN_GROUP", 15) == 0) { *valp = IPV6_JOIN_GROUP; return 0; }
#endif
#ifdef IPV6_RECVTCLASS
        if (memcmp(str, "IPV6_RECVTCLASS", 15) == 0) { *valp = IPV6_RECVTCLASS; return 0; }
#endif
        return -1;

      case 16:
#ifdef IPV6_LEAVE_GROUP
        if (memcmp(str, "IPV6_LEAVE_GROUP", 16) == 0) { *valp = IPV6_LEAVE_GROUP; return 0; }
#endif
#ifdef IPV6_RECVDSTOPTS
        if (memcmp(str, "IPV6_RECVDSTOPTS", 16) == 0) { *valp = IPV6_RECVDSTOPTS; return 0; }
#endif
#ifdef IPV6_RECVHOPOPTS
        if (memcmp(str, "IPV6_RECVHOPOPTS", 16) == 0) { *valp = IPV6_RECVHOPOPTS; return 0; }
#endif
#ifdef IPV6_RECVPKTINFO
        if (memcmp(str, "IPV6_RECVPKTINFO", 16) == 0) { *valp = IPV6_RECVPKTINFO; return 0; }
#endif
#ifdef IPV6_RECVPATHMTU
        if (memcmp(str, "IPV6_RECVPATHMTU", 16) == 0) { *valp = IPV6_RECVPATHMTU; return 0; }
#endif
#ifdef IPV6_USE_MIN_MTU
        if (memcmp(str, "IPV6_USE_MIN_MTU", 16) == 0) { *valp = IPV6_USE_MIN_MTU; return 0; }
#endif
        return -1;

      case 17:
#ifdef IPV6_MULTICAST_IF
        if (memcmp(str, "IPV6_MULTICAST_IF", 17) == 0) { *valp = IPV6_MULTICAST_IF; return 0; }
#endif
#ifdef IPV6_UNICAST_HOPS
        if (memcmp(str, "IPV6_UNICAST_HOPS", 17) == 0) { *valp = IPV6_UNICAST_HOPS; return 0; }
#endif
#ifdef IPV6_RECVHOPLIMIT
        if (memcmp(str, "IPV6_RECVHOPLIMIT", 17) == 0) { *valp = IPV6_RECVHOPLIMIT; return 0; }
#endif
#ifdef IPV6_RTHDRDSTOPTS
        if (memcmp(str, "IPV6_RTHDRDSTOPTS", 17) == 0) { *valp = IPV6_RTHDRDSTOPTS; return 0; }
#endif
#ifdef IPV6_RTHDR_TYPE_0
        if (memcmp(str, "IPV6_RTHDR_TYPE_0", 17) == 0) { *valp = IPV6_RTHDR_TYPE_0; return 0; }
#endif
        return -1;

      case 19:
#ifdef IPV6_MULTICAST_HOPS
        if (memcmp(str, "IPV6_MULTICAST_HOPS", 19) == 0) { *valp = IPV6_MULTICAST_HOPS; return 0; }
#endif
#ifdef IPV6_MULTICAST_LOOP
        if (memcmp(str, "IPV6_MULTICAST_LOOP", 19) == 0) { *valp = IPV6_MULTICAST_LOOP; return 0; }
#endif
        return -1;

      default:
        if (!str || !valp) {/* wrong argument */}
        return -1;
    }
}

#endif

int
rsock_tcp_optname_to_int(const char *str, long len, int *valp)
{
    switch (len) {
      case 4:
#ifdef TCP_CORK
        if (memcmp(str, "CORK", 4) == 0) { *valp = TCP_CORK; return 0; }
#endif
#ifdef TCP_INFO
        if (memcmp(str, "INFO", 4) == 0) { *valp = TCP_INFO; return 0; }
#endif
        return -1;

      case 5:
#ifdef TCP_NOOPT
        if (memcmp(str, "NOOPT", 5) == 0) { *valp = TCP_NOOPT; return 0; }
#endif
        return -1;

      case 6:
#ifdef TCP_MAXSEG
        if (memcmp(str, "MAXSEG", 6) == 0) { *valp = TCP_MAXSEG; return 0; }
#endif
#ifdef TCP_MD5SIG
        if (memcmp(str, "MD5SIG", 6) == 0) { *valp = TCP_MD5SIG; return 0; }
#endif
#ifdef TCP_NOPUSH
        if (memcmp(str, "NOPUSH", 6) == 0) { *valp = TCP_NOPUSH; return 0; }
#endif
#ifdef TCP_SYNCNT
        if (memcmp(str, "SYNCNT", 6) == 0) { *valp = TCP_SYNCNT; return 0; }
#endif
#ifdef TCP_REPAIR
        if (memcmp(str, "REPAIR", 6) == 0) { *valp = TCP_REPAIR; return 0; }
#endif
        return -1;

      case 7:
#ifdef TCP_NODELAY
        if (memcmp(str, "NODELAY", 7) == 0) { *valp = TCP_NODELAY; return 0; }
#endif
#ifdef TCP_KEEPCNT
        if (memcmp(str, "KEEPCNT", 7) == 0) { *valp = TCP_KEEPCNT; return 0; }
#endif
#ifdef TCP_LINGER2
        if (memcmp(str, "LINGER2", 7) == 0) { *valp = TCP_LINGER2; return 0; }
#endif
        return -1;

      case 8:
#ifdef TCP_CORK
        if (memcmp(str, "TCP_CORK", 8) == 0) { *valp = TCP_CORK; return 0; }
#endif
#ifdef TCP_INFO
        if (memcmp(str, "TCP_INFO", 8) == 0) { *valp = TCP_INFO; return 0; }
#endif
#ifdef TCP_KEEPIDLE
        if (memcmp(str, "KEEPIDLE", 8) == 0) { *valp = TCP_KEEPIDLE; return 0; }
#endif
#ifdef TCP_QUICKACK
        if (memcmp(str, "QUICKACK", 8) == 0) { *valp = TCP_QUICKACK; return 0; }
#endif
#ifdef TCP_FASTOPEN
        if (memcmp(str, "FASTOPEN", 8) == 0) { *valp = TCP_FASTOPEN; return 0; }
#endif
        return -1;

      case 9:
#ifdef TCP_NOOPT
        if (memcmp(str, "TCP_NOOPT", 9) == 0) { *valp = TCP_NOOPT; return 0; }
#endif
#ifdef TCP_KEEPINTVL
        if (memcmp(str, "KEEPINTVL", 9) == 0) { *valp = TCP_KEEPINTVL; return 0; }
#endif
#ifdef TCP_QUEUE_SEQ
        if (memcmp(str, "QUEUE_SEQ", 9) == 0) { *valp = TCP_QUEUE_SEQ; return 0; }
#endif
#ifdef TCP_TIMESTAMP
        if (memcmp(str, "TIMESTAMP", 9) == 0) { *valp = TCP_TIMESTAMP; return 0; }
#endif
        return -1;

      case 10:
#ifdef TCP_MAXSEG
        if (memcmp(str, "TCP_MAXSEG", 10) == 0) { *valp = TCP_MAXSEG; return 0; }
#endif
#ifdef TCP_MD5SIG
        if (memcmp(str, "TCP_MD5SIG", 10) == 0) { *valp = TCP_MD5SIG; return 0; }
#endif
#ifdef TCP_NOPUSH
        if (memcmp(str, "TCP_NOPUSH", 10) == 0) { *valp = TCP_NOPUSH; return 0; }
#endif
#ifdef TCP_SYNCNT
        if (memcmp(str, "TCP_SYNCNT", 10) == 0) { *valp = TCP_SYNCNT; return 0; }
#endif
#ifdef TCP_REPAIR
        if (memcmp(str, "TCP_REPAIR", 10) == 0) { *valp = TCP_REPAIR; return 0; }
#endif
#ifdef TCP_CONGESTION
        if (memcmp(str, "CONGESTION", 10) == 0) { *valp = TCP_CONGESTION; return 0; }
#endif
        return -1;

      case 11:
#ifdef TCP_NODELAY
        if (memcmp(str, "TCP_NODELAY", 11) == 0) { *valp = TCP_NODELAY; return 0; }
#endif
#ifdef TCP_KEEPCNT
        if (memcmp(str, "TCP_KEEPCNT", 11) == 0) { *valp = TCP_KEEPCNT; return 0; }
#endif
#ifdef TCP_LINGER2
        if (memcmp(str, "TCP_LINGER2", 11) == 0) { *valp = TCP_LINGER2; return 0; }
#endif
#ifdef TCP_THIN_DUPACK
        if (memcmp(str, "THIN_DUPACK", 11) == 0) { *valp = TCP_THIN_DUPACK; return 0; }
#endif
        return -1;

      case 12:
#ifdef TCP_KEEPIDLE
        if (memcmp(str, "TCP_KEEPIDLE", 12) == 0) { *valp = TCP_KEEPIDLE; return 0; }
#endif
#ifdef TCP_QUICKACK
        if (memcmp(str, "TCP_QUICKACK", 12) == 0) { *valp = TCP_QUICKACK; return 0; }
#endif
#ifdef TCP_FASTOPEN
        if (memcmp(str, "TCP_FASTOPEN", 12) == 0) { *valp = TCP_FASTOPEN; return 0; }
#endif
#ifdef TCP_DEFER_ACCEPT
        if (memcmp(str, "DEFER_ACCEPT", 12) == 0) { *valp = TCP_DEFER_ACCEPT; return 0; }
#endif
#ifdef TCP_WINDOW_CLAMP
        if (memcmp(str, "WINDOW_CLAMP", 12) == 0) { *valp = TCP_WINDOW_CLAMP; return 0; }
#endif
#ifdef TCP_REPAIR_QUEUE
        if (memcmp(str, "REPAIR_QUEUE", 12) == 0) { *valp = TCP_REPAIR_QUEUE; return 0; }
#endif
#ifdef TCP_USER_TIMEOUT
        if (memcmp(str, "USER_TIMEOUT", 12) == 0) { *valp = TCP_USER_TIMEOUT; return 0; }
#endif
        return -1;

      case 13:
#ifdef TCP_KEEPINTVL
        if (memcmp(str, "TCP_KEEPINTVL", 13) == 0) { *valp = TCP_KEEPINTVL; return 0; }
#endif
#ifdef TCP_QUEUE_SEQ
        if (memcmp(str, "TCP_QUEUE_SEQ", 13) == 0) { *valp = TCP_QUEUE_SEQ; return 0; }
#endif
#ifdef TCP_TIMESTAMP
        if (memcmp(str, "TCP_TIMESTAMP", 13) == 0) { *valp = TCP_TIMESTAMP; return 0; }
#endif
        return -1;

      case 14:
#ifdef TCP_CONGESTION
        if (memcmp(str, "TCP_CONGESTION", 14) == 0) { *valp = TCP_CONGESTION; return 0; }
#endif
#ifdef TCP_REPAIR_OPTIONS
        if (memcmp(str, "REPAIR_OPTIONS", 14) == 0) { *valp = TCP_REPAIR_OPTIONS; return 0; }
#endif
        return -1;

      case 15:
#ifdef TCP_THIN_DUPACK
        if (memcmp(str, "TCP_THIN_DUPACK", 15) == 0) { *valp = TCP_THIN_DUPACK; return 0; }
#endif
        return -1;

      case 16:
#ifdef TCP_DEFER_ACCEPT
        if (memcmp(str, "TCP_DEFER_ACCEPT", 16) == 0) { *valp = TCP_DEFER_ACCEPT; return 0; }
#endif
#ifdef TCP_WINDOW_CLAMP
        if (memcmp(str, "TCP_WINDOW_CLAMP", 16) == 0) { *valp = TCP_WINDOW_CLAMP; return 0; }
#endif
#ifdef TCP_REPAIR_QUEUE
        if (memcmp(str, "TCP_REPAIR_QUEUE", 16) == 0) { *valp = TCP_REPAIR_QUEUE; return 0; }
#endif
#ifdef TCP_USER_TIMEOUT
        if (memcmp(str, "TCP_USER_TIMEOUT", 16) == 0) { *valp = TCP_USER_TIMEOUT; return 0; }
#endif
        return -1;

      case 18:
#ifdef TCP_REPAIR_OPTIONS
        if (memcmp(str, "TCP_REPAIR_OPTIONS", 18) == 0) { *valp = TCP_REPAIR_OPTIONS; return 0; }
#endif
        return -1;

      case 19:
#ifdef TCP_COOKIE_TRANSACTIONS
        if (memcmp(str, "COOKIE_TRANSACTIONS", 19) == 0) { *valp = TCP_COOKIE_TRANSACTIONS; return 0; }
#endif
        return -1;

      case 20:
#ifdef TCP_THIN_LINEAR_TIMEOUTS
        if (memcmp(str, "THIN_LINEAR_TIMEOUTS", 20) == 0) { *valp = TCP_THIN_LINEAR_TIMEOUTS; return 0; }
#endif
        return -1;

      case 23:
#ifdef TCP_COOKIE_TRANSACTIONS
        if (memcmp(str, "TCP_COOKIE_TRANSACTIONS", 23) == 0) { *valp = TCP_COOKIE_TRANSACTIONS; return 0; }
#endif
        return -1;

      case 24:
#ifdef TCP_THIN_LINEAR_TIMEOUTS
        if (memcmp(str, "TCP_THIN_LINEAR_TIMEOUTS", 24) == 0) { *valp = TCP_THIN_LINEAR_TIMEOUTS; return 0; }
#endif
        return -1;

      default:
        if (!str || !valp) {/* wrong argument */}
        return -1;
    }
}


int
rsock_udp_optname_to_int(const char *str, long len, int *valp)
{
    switch (len) {
      case 4:
#ifdef UDP_CORK
        if (memcmp(str, "CORK", 4) == 0) { *valp = UDP_CORK; return 0; }
#endif
        return -1;

      case 8:
#ifdef UDP_CORK
        if (memcmp(str, "UDP_CORK", 8) == 0) { *valp = UDP_CORK; return 0; }
#endif
        return -1;

      default:
        if (!str || !valp) {/* wrong argument */}
        return -1;
    }
}


int
rsock_shutdown_how_to_int(const char *str, long len, int *valp)
{
    switch (len) {
      case 2:
#ifdef SHUT_RD
        if (memcmp(str, "RD", 2) == 0) { *valp = SHUT_RD; return 0; }
#endif
#ifdef SHUT_WR
        if (memcmp(str, "WR", 2) == 0) { *valp = SHUT_WR; return 0; }
#endif
        return -1;

      case 4:
#ifdef SHUT_RDWR
        if (memcmp(str, "RDWR", 4) == 0) { *valp = SHUT_RDWR; return 0; }
#endif
        return -1;

      case 7:
#ifdef SHUT_RD
        if (memcmp(str, "SHUT_RD", 7) == 0) { *valp = SHUT_RD; return 0; }
#endif
#ifdef SHUT_WR
        if (memcmp(str, "SHUT_WR", 7) == 0) { *valp = SHUT_WR; return 0; }
#endif
        return -1;

      case 9:
#ifdef SHUT_RDWR
        if (memcmp(str, "SHUT_RDWR", 9) == 0) { *valp = SHUT_RDWR; return 0; }
#endif
        return -1;

      default:
        if (!str || !valp) {/* wrong argument */}
        return -1;
    }
}


int
rsock_scm_optname_to_int(const char *str, long len, int *valp)
{
    switch (len) {
      case 5:
#ifdef SCM_CREDS
        if (memcmp(str, "CREDS", 5) == 0) { *valp = SCM_CREDS; return 0; }
#endif
#ifdef SCM_UCRED
        if (memcmp(str, "UCRED", 5) == 0) { *valp = SCM_UCRED; return 0; }
#endif
        return -1;

      case 6:
#ifdef SCM_RIGHTS
        if (memcmp(str, "RIGHTS", 6) == 0) { *valp = SCM_RIGHTS; return 0; }
#endif
        return -1;

      case 7:
#ifdef SCM_BINTIME
        if (memcmp(str, "BINTIME", 7) == 0) { *valp = SCM_BINTIME; return 0; }
#endif
        return -1;

      case 9:
#ifdef SCM_CREDS
        if (memcmp(str, "SCM_CREDS", 9) == 0) { *valp = SCM_CREDS; return 0; }
#endif
#ifdef SCM_UCRED
        if (memcmp(str, "SCM_UCRED", 9) == 0) { *valp = SCM_UCRED; return 0; }
#endif
#ifdef SCM_TIMESTAMP
        if (memcmp(str, "TIMESTAMP", 9) == 0) { *valp = SCM_TIMESTAMP; return 0; }
#endif
        return -1;

      case 10:
#ifdef SCM_RIGHTS
        if (memcmp(str, "SCM_RIGHTS", 10) == 0) { *valp = SCM_RIGHTS; return 0; }
#endif
        return -1;

      case 11:
#ifdef SCM_BINTIME
        if (memcmp(str, "SCM_BINTIME", 11) == 0) { *valp = SCM_BINTIME; return 0; }
#endif
#ifdef SCM_TIMESTAMPNS
        if (memcmp(str, "TIMESTAMPNS", 11) == 0) { *valp = SCM_TIMESTAMPNS; return 0; }
#endif
#ifdef SCM_CREDENTIALS
        if (memcmp(str, "CREDENTIALS", 11) == 0) { *valp = SCM_CREDENTIALS; return 0; }
#endif
#ifdef SCM_WIFI_STATUS
        if (memcmp(str, "WIFI_STATUS", 11) == 0) { *valp = SCM_WIFI_STATUS; return 0; }
#endif
        return -1;

      case 12:
#ifdef SCM_TIMESTAMPING
        if (memcmp(str, "TIMESTAMPING", 12) == 0) { *valp = SCM_TIMESTAMPING; return 0; }
#endif
        return -1;

      case 13:
#ifdef SCM_TIMESTAMP
        if (memcmp(str, "SCM_TIMESTAMP", 13) == 0) { *valp = SCM_TIMESTAMP; return 0; }
#endif
        return -1;

      case 15:
#ifdef SCM_TIMESTAMPNS
        if (memcmp(str, "SCM_TIMESTAMPNS", 15) == 0) { *valp = SCM_TIMESTAMPNS; return 0; }
#endif
#ifdef SCM_CREDENTIALS
        if (memcmp(str, "SCM_CREDENTIALS", 15) == 0) { *valp = SCM_CREDENTIALS; return 0; }
#endif
#ifdef SCM_WIFI_STATUS
        if (memcmp(str, "SCM_WIFI_STATUS", 15) == 0) { *valp = SCM_WIFI_STATUS; return 0; }
#endif
        return -1;

      case 16:
#ifdef SCM_TIMESTAMPING
        if (memcmp(str, "SCM_TIMESTAMPING", 16) == 0) { *valp = SCM_TIMESTAMPING; return 0; }
#endif
        return -1;

      default:
        if (!str || !valp) {/* wrong argument */}
        return -1;
    }
}



ID
rsock_intern_family(int val)
{
    st_data_t name;
    if (st_lookup(rsock_intern_family_hash, (st_data_t)val, &name))
        return (ID)name;
    return 0;
}

ID
rsock_intern_family_noprefix(int val)
{
    st_data_t name;
    if (st_lookup(rsock_intern_family_noprefix_hash, (st_data_t)val, &name))
        return (ID)name;
    return 0;
}

ID
rsock_intern_protocol_family(int val)
{
    st_data_t name;
    if (st_lookup(rsock_intern_protocol_family_hash, (st_data_t)val, &name))
        return (ID)name;
    return 0;
}

ID
rsock_intern_socktype(int val)
{
    st_data_t name;
    if (st_lookup(rsock_intern_socktype_hash, (st_data_t)val, &name))
        return (ID)name;
    return 0;
}

ID
rsock_intern_ipproto(int val)
{
    st_data_t name;
    if (st_lookup(rsock_intern_ipproto_hash, (st_data_t)val, &name))
        return (ID)name;
    return 0;
}

ID
rsock_intern_iplevel(int val)
{
    st_data_t name;
    if (st_lookup(rsock_intern_iplevel_hash, (st_data_t)val, &name))
        return (ID)name;
    return 0;
}

ID
rsock_intern_so_optname(int val)
{
    st_data_t name;
    if (st_lookup(rsock_intern_so_optname_hash, (st_data_t)val, &name))
        return (ID)name;
    return 0;
}

ID
rsock_intern_ip_optname(int val)
{
    st_data_t name;
    if (st_lookup(rsock_intern_ip_optname_hash, (st_data_t)val, &name))
        return (ID)name;
    return 0;
}

ID
rsock_intern_ipv6_optname(int val)
{
    st_data_t name;
    if (st_lookup(rsock_intern_ipv6_optname_hash, (st_data_t)val, &name))
        return (ID)name;
    return 0;
}

ID
rsock_intern_tcp_optname(int val)
{
    st_data_t name;
    if (st_lookup(rsock_intern_tcp_optname_hash, (st_data_t)val, &name))
        return (ID)name;
    return 0;
}

ID
rsock_intern_udp_optname(int val)
{
    st_data_t name;
    if (st_lookup(rsock_intern_udp_optname_hash, (st_data_t)val, &name))
        return (ID)name;
    return 0;
}

ID
rsock_intern_scm_optname(int val)
{
    st_data_t name;
    if (st_lookup(rsock_intern_scm_optname_hash, (st_data_t)val, &name))
        return (ID)name;
    return 0;
}

ID
rsock_intern_local_optname(int val)
{
    st_data_t name;
    if (st_lookup(rsock_intern_local_optname_hash, (st_data_t)val, &name))
        return (ID)name;
    return 0;
}


