<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_session - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_session</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_session.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_session.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Support des sessions</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>session_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_session.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3 d'Apache</td></tr></table>
<h3>Sommaire</h3>

    <div class="warning"><h3>Avertissement</h3>
      <p>Le module session fait usage des cookies HTTP, et peut  ce
      titre tre victime d'attaques de type Cross Site Scripting, ou
      divulguer des informations  caractre priv aux clients. Veuillez
      vous assurer que les risques ainsi encourus ont t pris en compte
      avant d'activer le support des sessions sur votre serveur.</p>
    </div>

    <p>Ce module fournit le support d'une interface de session pour
    chaque utilisateur au niveau du serveur global. Les sessions
    permettent de transmettre diverses informations  : l'utilisateur
    est-il connect ou non, ou toute autre information qui doit tre
    conserve d'une requte  l'autre.</p>

    <p>Les sessions peuvent tre stockes sur le serveur, ou au niveau
    du navigateur. Les sessions peuvent galement tre chiffres pour une
    scurit accrue. Ces fonctionnalits sont rparties entre diffrents
    modules complmentaires de <code class="module"><a href="../mod/mod_session.html">mod_session</a></code> :
    <code class="module"><a href="../mod/mod_session_crypto.html">mod_session_crypto</a></code>,
    <code class="module"><a href="../mod/mod_session_cookie.html">mod_session_cookie</a></code> et
    <code class="module"><a href="../mod/mod_session_dbd.html">mod_session_dbd</a></code>. Chargez les modules appropris
    en fonction des besoins du serveur (soit statiquement  la
    compilation, soit dynamiquement via la directive <code class="directive"><a href="../mod/mod_so.html#loadmodule">LoadModule</a></code>).</p>

    <p>Les sessions peuvent tre manipules par d'autres modules qui
    dpendent de la session, ou la session peut tre lue et crite dans
    des variables d'environnement et des en-ttes HTTP, selon les
    besoins.</p>

</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#session">Session</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sessionenv">SessionEnv</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sessionexclude">SessionExclude</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sessionheader">SessionHeader</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sessioninclude">SessionInclude</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sessionmaxage">SessionMaxAge</a></li>
</ul>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#whatisasession">Qu'est-ce qu'une session ?</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#whocanuseasession">Qui peut utiliser une session
    ?</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#serversession">Stockage des sessions sur le
    serveur</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#browsersession">Stockage des sessions au niveau
    du navigateur</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#basicexamples">Exemples simples</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sessionprivacy">Confidentialit des
    sessions</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cookieprivacy">Confidentialit du cookie</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authentication">Support des sessions pour
    l'authentification</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#integration">Intgration des sessions avec les
    applications externes</a></li>
</ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="module"><a href="../mod/mod_session_cookie.html">mod_session_cookie</a></code></li>
<li><code class="module"><a href="../mod/mod_session_crypto.html">mod_session_crypto</a></code></li>
<li><code class="module"><a href="../mod/mod_session_dbd.html">mod_session_dbd</a></code></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="whatisasession" id="whatisasession">Qu'est-ce qu'une session ?</a></h2>
      <p>Au coeur de l'interface de session se trouve une table de
      paires cl/valeur qui sont accessibles d'une requte du navigateur
       l'autre. Les valeurs de cls peuvent se voir affecter toute chane
      de caractres valide, en fonction des besoins de l'application qui
      fait usage de la session.</p>

      <p>Une "session" est une chane
      <strong>application/x-www-form-urlencoded</strong> qui contient la
      paire cl/valeur dfinie par la <a href="http://www.w3.org/TR/html4/">spcification HTML</a>.</p>

      <p>Selon les souhaits de l'administrateur, la session peut tre
      chiffre et code en base64 avant d'tre soumise au dispositif de
      stockage.</p>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="whocanuseasession" id="whocanuseasession">Qui peut utiliser une session
    ?</a></h2>
      <p>L'interface de session a t conue  l'origine pour tre
      utilise par d'autres modules du serveur comme
      <code class="module"><a href="../mod/mod_auth_form.html">mod_auth_form</a></code> ; les applications  base de
      programmes CGI peuvent cependant se voir accorder l'accs au
      contenu d'une session via la variable d'environnement
      HTTP_SESSION. Il est possible de modifier et/ou de mettre  jour
      une session en insrant un en-tte de rponse HTTP contenant les
      nouveaux paramtres de session.</p>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="serversession" id="serversession">Stockage des sessions sur le
    serveur</a></h2>
      <p>Apache peut tre configur pour stocker les sessions
      utilisateurs sur un serveur particulier ou un groupe de serveurs.
      Cette fonctionnalit est similaire aux sessions disponibles sur
      les serveurs d'applications courants.</p>

      <p>Selon la configuration, les sessions sont suivies 
      partir d'un identifiant de session stock dans un cookie, ou
      extraites de la chane de paramtres de l'URL, comme dans les
      requtes GET courantes.</p>

      <p>Comme le contenu de la session est stock exclusivement sur le
      serveur, il est ncessaire de prserver la confidentialit de ce
      contenu. Ceci a des implications en matire de performance et de
      consommation de ressources lorsqu'un grand nombre de sessions est
      stock, ou lorsqu'un grand nombre de serveurs doivent se partager
      les sessions entre eux.</p>

      <p>Le module <code class="module"><a href="../mod/mod_session_dbd.html">mod_session_dbd</a></code> permet de stocker
      les sessions utilisateurs dans une base de donnes SQL via le
      module <code class="module"><a href="../mod/mod_dbd.html">mod_dbd</a></code>.</p>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="browsersession" id="browsersession">Stockage des sessions au niveau
    du navigateur</a></h2>
      <p>Dans les environnements  haut trafic o le stockage d'une
      session sur un serveur consomme trop
      de ressources, il est possible de stocker le contenu de la session
      dans un cookie au niveau du navigateur client.</p>

      <p>Ceci a pour avantage de ne ncessiter qu'une quantit minimale de
      ressources sur le serveur pour suivre les sessions, et vite 
      plusieurs serveurs parmi une fort de serveurs de devoir partager
      les informations de session.</p>

      <p>Le contenu de la session est cependant prsent au client, avec
      pour consquence un risque de perte de confidentialit. Le module
      <code class="module"><a href="../mod/mod_session_crypto.html">mod_session_crypto</a></code> peut tre configur pour
      chiffrer le contenu de la session avant qu'elle soit stocke au
      niveau du client.</p>

      <p>Le module <code class="module"><a href="../mod/mod_session_cookie.html">mod_session_cookie</a></code> permet de stocker
      les sessions au niveau du navigateur dans un cookie HTTP.</p>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="basicexamples" id="basicexamples">Exemples simples</a></h2>

      <p>La cration d'une session consiste simplement  ouvrir la
      session, et  dcider de l'endroit o elle doit tre stocke. Dans
      l'exemple suivant, la session sera stocke au niveau du
      navigateur, dans un cookie nomm <code>session</code>.</p>

      <div class="example"><h3>Session stocke au niveau du navigateur</h3><pre class="prettyprint lang-config">
Session On
SessionCookieName session path=/
        </pre>
</div>

      <p>Une session est inutile s'il n'est pas possible d'y lire
      ou d'y crire. L'exemple suivant montre comment des valeurs
      peuvent tre injectes dans une session  l'aide d'un en-tte de
      rponse HTTP prdtermin nomm
      <code>X-Replace-Session</code>.</p>

      <div class="example"><h3>Ecriture dans une session</h3><pre class="prettyprint lang-config">
Session On
SessionCookieName session path=/
SessionHeader X-Replace-Session
        </pre>
</div>

      <p>L'en-tte doit contenir des paires cl/valeur sous le mme
      format que celui de la chane d'argument d'une URL, comme dans
      l'exemple suivant. Donner pour valeur  une cl la chane vide a
      pour effet de supprimer la cl de la session.</p>

      <div class="example"><h3>Script CGI pour crire dans une session</h3><pre class="prettyprint lang-sh">
#!/bin/bash
echo "Content-Type: text/plain"
echo "X-Replace-Session: key1=foo&amp;key2=&amp;key3=bar"
echo
env
        </pre>
</div>

      <p>Selon la configuration, les informations de la session peuvent
      tre extraites de la variable d'environnement HTTP_SESSION. Par
      dfaut la session est prive, et cette fonctionnalit doit donc
      tre explicitement active via la directive <code class="directive"><a href="#sessionenv">SessionEnv</a></code>.</p>

      <div class="example"><h3>Lecture depuis une session</h3><pre class="prettyprint lang-config">
Session On
SessionEnv On
SessionCookieName session path=/
SessionHeader X-Replace-Session
        </pre>
</div>

      <p>Une fois la lecture effectue, la variable CGI
      <code>HTTP_SESSION</code> doit contenir la valeur
      <code>cl1=foo&amp;cl3=bar</code>.</p>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="sessionprivacy" id="sessionprivacy">Confidentialit des
    sessions</a></h2>

      <p>En utilisant la fonctionnalit de votre navigateur "Afficher
      les cookies", vous pouvez voir une rprsentation de la session
      sous forme de texte en clair. Ceci peut poser problme si le
      contenu de la session doit tre dissimul  l'utilisateur final,
      ou si un tiers accde sans autorisation aux informations de
      session.</p>

      <p> ce titre, le contenu de la session peut tre chiffr  l'aide
      du module <code class="module"><a href="../mod/mod_session_crypto.html">mod_session_crypto</a></code> avant d'tre stock
      au niveau du navigateur.</p>

      <div class="example"><h3>Session chiffre avant stockage au niveau du
      navigateur</h3><pre class="prettyprint lang-config">
Session On
SessionCryptoPassphrase secret
SessionCookieName session path=/
        </pre>
</div>

      <p>La session sera automatiquement dchiffre  la lecture, et
      rechiffre par Apache lors de la sauvegarde, si bien que
      l'application sous-jacente qui utilise la session n'a pas  se
      proccuper de savoir si un chiffrement a t mis en oeuvre ou
      non.</p>

      <p>Les sessions stockes sur le serveur plutt qu'au niveau du
      navigateur peuvent aussi tre chiffres, prservant par l-mme la
      confidentialit lorsque des informations sensibles sont partages
      entre les serveurs web d'une fort de serveurs  l'aide du module
      <code class="module"><a href="../mod/mod_session_dbd.html">mod_session_dbd</a></code>.</p>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="cookieprivacy" id="cookieprivacy">Confidentialit du cookie</a></h2>

      <p>Le mcanisme de cookie HTTP offre aussi des fonctionnalits
      quant  la confidentialit, comme la possibilit de
      restreindre le transport du cookie aux pages protges par SSL
      seulement, ou l'interdiction pour les scripts java qui
      s'excutent au niveau du navigateur d'obtenir l'accs au contenu
      du cookie.</p>

      <div class="warning"><h3>Avertissement</h3>
      <p>Certaines fonctionnalits de confidentialit du cookie HTTP ne
      sont pas standardises, ou ne sont pas toujours implmentes au
      niveau du navigateur. Les modules de session vous permettent de
      dfinir les paramtres du cookie, mais il n'est pas garanti que la
      confidentialit sera respecte par le navigateur. Si la scurit
      est la principale proccupation, chiffrez le contenu de la session
      avec le module <code class="module"><a href="../mod/mod_session_crypto.html">mod_session_crypto</a></code>, ou stockez la
      session sur le serveur avec le module
      <code class="module"><a href="../mod/mod_session_dbd.html">mod_session_dbd</a></code>.</p>
      </div>

      <p>Les paramtres standards du cookie peuvent tre spcifis aprs
      le nom du cookie comme dans l'exemple suivant :</p>

      <div class="example"><h3>Dfinition des paramtres du cookie</h3><pre class="prettyprint lang-config">
Session On
SessionCryptoPassphrase secret
SessionCookieName session path=/private;domain=example.com;httponly;secure;
        </pre>
</div>

      <p>Dans les cas o le serveur Apache sert de frontal pour des
      serveurs d'arrire-plan, il est possible de supprimer les cookies
      de session des en-ttes HTTP entrants  l'aide de la directive
      <code class="directive"><a href="../mod/mod_session_cookie.html#sessioncookieremove">SessionCookieRemove</a></code>. Ceci
      permet d'empcher les serveurs d'arrire-plan d'accder au contenu
      des cookies de session.
      </p>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="authentication" id="authentication">Support des sessions pour
    l'authentification</a></h2>

      <p>Comme il est possible de le faire avec de nombreux serveurs
      d'applications, les modules d'authentification peuvent utiliser
      une session pour stocker le nom d'utilisateur et le mot de passe
      aprs connexion. Le module <code class="module"><a href="../mod/mod_auth_form.html">mod_auth_form</a></code> par
      exemple, sauvegarde les nom de connexion et mot de passe de
      l'utilisateur dans une session.</p>

      <div class="example"><h3>Authentification  base de formulaire</h3><pre class="prettyprint lang-config">
Session On
SessionCryptoPassphrase secret
SessionCookieName session path=/
AuthFormProvider file
AuthUserFile conf/passwd
AuthType form
AuthName realm
#...
        </pre>
</div>

      <p>Pour la documentation et des exemples complets, voir le module
      <code class="module"><a href="../mod/mod_auth_form.html">mod_auth_form</a></code>.</p>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="integration" id="integration">Intgration des sessions avec les
    applications externes</a></h2>

      <p>Pour que les sessions soient utiles, leur contenu doit tre
      accessible aux applications externes, et ces dernires doivent
      elles-mmes tre capables d'crire une session.</p>

      <p>L'exemple type est une application qui modifie le mot de passe
      d'un utilisateur dfini par <code class="module"><a href="../mod/mod_auth_form.html">mod_auth_form</a></code>. Cette
      application doit pouvoir extraire les nom d'utilisateur et mot de
      passe courants de la session, effectuer les modifications
      demandes, puis crire le nouveau mot de passe dans la session,
      afin que la transition vers le nouveau mot de passe soit
      transparente.</p>

      <p>Un autre exemple met en jeu une application qui enregistre un
      nouvel utilisateur pour la premire fois. Une fois
      l'enregistrement termin, le nom d'utilisateur et le mot de passe
      sont crits dans la session, fournissant l aussi une transition
      transparente.</p>

      <dl>
      <dt>Modules Apache</dt>
      <dd>Selon les besoins, les modules du serveur peuvent utiliser
      l'API <strong>mod_session.h</strong> pour lire et crire dans les
      sessions. Les modules tels que <code class="module"><a href="../mod/mod_auth_form.html">mod_auth_form</a></code>
      utilisent ce mcanisme.
      </dd>

      <dt>Programmes CGI et langages de script</dt>
      <dd>Les applications qui s'excutent au sein du serveur web
      peuvent ventuellement extraire la valeur de la session de la
      variable d'environnement <strong>HTTP_SESSION</strong>. La session
      doit tre code sous la forme d'une chane
      <strong>application/x-www-form-urlencoded</strong> selon les
      prconisations de la <a href="http://www.w3.org/TR/html4/">specification HTML</a>. Cette
      variable d'environnement est dfinie via la directive <code class="directive"><a href="#sessionenv">SessionEnv</a></code>. Un script peut crire
      dans la session en renvoyant un en-tte de rponse
      <strong>application/x-www-form-urlencoded</strong> dont le nom est
      dfini via la directive <code class="directive"><a href="#sessionheader">SessionHeader</a></code>. Dans les deux cas,
      tout chiffrement ou dchiffrement, ainsi que la lecture ou
      l'criture de ou vers la session  partir du mcanisme de stockage
      choisi sont grs par le module <code class="module"><a href="../mod/mod_session.html">mod_session</a></code> et la
      configuration correspondante.
      </dd>

      <dt>Applications situes derrire <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code></dt>
      <dd>Si la directive <code class="directive"><a href="#sessionheader">SessionHeader</a></code> est utilise pour
      dfinir un en-tte de requte HTTP, la session code sous la forme
      d'une chane <strong>application/x-www-form-urlencoded</strong>
      sera accessible pour l'application. Si ce mme en-tte est fourni
      dans la rponse, sa valeur sera utilise pour remplacer la
      session. Comme prcdemment, tout chiffrement ou dchiffrement,
      ainsi que la lecture ou
      l'criture de ou vers la session  partir du mcanisme de stockage
      choisi sont grs par le module <code class="module"><a href="../mod/mod_session.html">mod_session</a></code> et la
      configuration correspondante.</dd>

      <dt>Applications indpendantes</dt>
      <dd>Les applications peuvent choisir de manipuler la session en
      s'affranchissant du contrle du serveur HTTP Apache. Dans ce cas,
      c'est l'application qui doit prendre en charge la lecture de la
      session depuis le mcanisme de stockage choisi, son dchiffrement,
      sa mise  jour, son chiffrement et sa rcriture vers le mcanisme
      de stockage choisi de manire approprie.</dd>
      </dl>

    </div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="Session" id="Session">Session</a> <a name="session" id="session">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Ouvre une session pour le contexte courant</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Session On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Session Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_session</td></tr>
</table>
    <p>La directive <code class="directive">Session</code> permet d'ouvrir une
    session pour le contexte ou conteneur courant. Les directives
    suivantes permettent de dfinir o la session sera stocke et
    comment sera assure la confidentialit.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="SessionEnv" id="SessionEnv">SessionEnv</a> <a name="sessionenv" id="sessionenv">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit si le contenu de la session doit tre enregistr
dans la variable d'environnement <var>HTTP_SESSION</var></td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SessionEnv On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SessionEnv Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_session</td></tr>
</table>
    <p>Lorsque la directive <code class="directive">SessionEnv</code> est
    dfinie  <var>On</var>, le contenu de la session est enregistr
    dans une variable d'environnement CGI nomme
    <var>HTTP_SESSION</var>.</p>

    <p>La chane est crite sous le mme format que celui de la chane
    d'arguments d'une URL, comme dans l'exemple suivant :</p>

    <div class="example"><p><code>
      <code>cl1=foo&amp;cl3=bar</code>
    </code></p></div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="SessionExclude" id="SessionExclude">SessionExclude</a> <a name="sessionexclude" id="sessionexclude">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit les prfixes d'URLs pour lesquels une session sera
ignore</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SessionExclude <var>chemin</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>none</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_session</td></tr>
</table>
    <p>La directive <code class="directive">SessionExclude</code> permet de
    dfinir les prfixes d'URLs pour lesquels la session sera
    dsactive. Ceci peut amliorer l'efficacit d'un site web, en
    ciblant de manire plus prcise l'espace d'URL pour lequel une
    session devra tre maintenue. Par dfaut, toutes les URLs du
    contexte ou du conteneur courant sont incluses dans la session. La
    directive <code class="directive"><a href="#sessionexclude">SessionExclude</a></code>
    l'emporte sur la directive <code class="directive"><a href="#sessioninclude">SessionInclude</a></code>.</p>

    <div class="warning"><h3>Avertissement</h3>
    <p>Cette directive a un comportement similaire  celui de l'attribut
    <var>chemin</var> des cookies HTTP, mais ne doit pas tre confondue
    avec cet attribut. En effet, cette directive ne dfinit pas
    l'attribut <var>chemin</var>, qui doit tre configur
    sparment.</p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="SessionHeader" id="SessionHeader">SessionHeader</a> <a name="sessionheader" id="sessionheader">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Importation des mises  jour de session depuis l'en-tte de
rponse HTTP spcifi</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SessionHeader <var>en-tte</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>none</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_session</td></tr>
</table>
    <p>La directive <code class="directive">SessionHeader</code> permet de
    dfinir le nom d'un en-tte de rponse HTTP qui, s'il est prsent,
    sera lu et son contenu crit dans la session courante.</p>

    <p>Le contenu de l'en-tte doit se prsenter sous le mme format que
    celui de la chane d'arguments d'une URL, comme dans l'exemple
    suivant :</p>

    <div class="example"><p><code>
      <code>cl1=foo&amp;cl2=&amp;cl3=bar</code>
    </code></p></div>

    <p>Si une cl a pour valeur la chane vide, elle sera supprime de
    la session.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="SessionInclude" id="SessionInclude">SessionInclude</a> <a name="sessioninclude" id="sessioninclude">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit les prfixes d'URL pour lesquels une session est
valide</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SessionInclude <var>chemin</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>toutes URLs</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_session</td></tr>
</table>
    <p>La directive <code class="directive">SessionInclude</code> permet de
    dfinir les prfixes d'URL spcifiques pour lesquels une session
    sera valide. Ceci peut amliorer l'efficacit d'un site web, en
    ciblant de manire plus prcise l'espace d'URL pour lequel une
    session devra tre maintenue. Par dfaut, toutes les URLs du
    contexte ou du conteneur courant sont incluses dans la session.</p>

    <div class="warning"><h3>Avertissement</h3>
    <p>Cette directive a un comportement similaire  celui de l'attribut
    <var>chemin</var> des cookies HTTP, mais ne doit pas tre confondue
    avec cet attribut. En effet, cette directive ne dfinit pas
    l'attribut <var>chemin</var>, qui doit tre configur sparment.</p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="SessionMaxAge" id="SessionMaxAge">SessionMaxAge</a> <a name="sessionmaxage" id="sessionmaxage">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit une dure de vie maximale pour la session en
secondes</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SessionMaxAge <var>dure de vie maximale</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SessionMaxAge 0</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_session</td></tr>
</table>
    <p>La directive <code class="directive">SessionMaxAge</code> permet de
    dfinir la dure maximale pendant laquelle une session restera
    valide. Lorsqu'une session est sauvegarde, cette dure est
    rinitialise et la session peut continuer d'exister. Si la dure
    d'une session dpasse cette limite sans qu'une requte au serveur ne
    vienne la rafrachir, la session va passer hors dlai et sera
    supprime. Lorsqu'une session est utilise pour stocker les
    informations de connexion d'un utilisateur, ceci aura pour effet de
    le dconnecter automatiquement aprs le dlai spcifi.</p>

    <p>Donner  cette directive la valeur 0 empche l'expiration de la
    session.</p>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_session.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_session.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_session.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2012 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>