/*
   This file is part of TALER
   Copyright (C) 2024 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_select_donau_instance_by_serial.c
 * @brief Implementation of the select_donau_instance function for Postgres
 * @author Bohdan Potuzhnyi
 * @author Vlada Svirsh
 */
#include "platform.h"
#include <taler/taler_error_codes.h>
#include <taler/taler_dbevents.h>
#include <taler/taler_pq_lib.h>
#include "pg_select_donau_instance_by_serial.h"
#include "taler_merchant_donau.h"
#include "pg_helper.h"


enum GNUNET_DB_QueryStatus
TMH_PG_select_donau_instance_by_serial (void *cls,
                                        uint64_t serial,
                                        char **donau_url,
                                        uint64_t *charity_id)
{
  struct PostgresClosure *pg = cls;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_uint64 (&serial),
    GNUNET_PQ_query_param_end
  };
  struct GNUNET_PQ_ResultSpec rs[] = {
    GNUNET_PQ_result_spec_string ("donau_url",
                                  donau_url),
    GNUNET_PQ_result_spec_uint64 ("charity_id",
                                  charity_id),
    GNUNET_PQ_result_spec_end
  };

  check_connection (pg);
  PREPARE (pg,
           "select_donau_instance_by_serial",
           "SELECT donau_url"
           " ,charity_id"
           "  FROM merchant_donau_instances"
           " WHERE donau_instances_serial = $1");

  return GNUNET_PQ_eval_prepared_singleton_select (
    pg->conn,
    "select_donau_instance_by_serial",
    params,
    rs);
}
