--
-- This file is part of TALER
-- Copyright (C) 2025 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--
-- @author Özgür Kesim

CREATE FUNCTION create_table_unique_refresh_blinding_seed(
  IN partition_suffix TEXT DEFAULT NULL
)
RETURNS VOID
LANGUAGE plpgsql
AS $$
DECLARE
  table_name TEXT DEFAULT 'unique_refresh_blinding_seed';
BEGIN
  PERFORM create_partitioned_table(
    'CREATE TABLE %I'
      '(unique_refresh_blinding_seed_id BIGINT GENERATED BY DEFAULT AS IDENTITY'
      ',blinding_seed BYTEA PRIMARY KEY'
    ') %s ;'
    ,table_name
    ,'PARTITION BY HASH (blinding_seed)'
    ,partition_suffix
  );
  PERFORM comment_partitioned_table(
     'Table to ensure uniqueness of the blinding_seed for CS signatures across all refresh operations. '
    ,table_name
    ,partition_suffix
  );
END
$$;


CREATE FUNCTION constrain_table_unique_refresh_blinding_seed(
  IN partition_suffix TEXT
)
RETURNS void
LANGUAGE plpgsql
AS $$
DECLARE
  table_name TEXT DEFAULT 'unique_refresh_blinding_seed';
BEGIN
  table_name = concat_ws('_', table_name, partition_suffix);
  EXECUTE FORMAT (
    'ALTER TABLE ' || table_name ||
    ' ADD CONSTRAINT ' || table_name || '_refresh_id_key'
    ' UNIQUE (unique_refresh_blinding_seed_id);'
  );
END
$$;

INSERT INTO exchange_tables
  (name
  ,version
  ,action
  ,partitioned
  ,by_range)
VALUES
  ('unique_refresh_blinding_seed', 'exchange-0002', 'create',   TRUE ,FALSE),
  ('unique_refresh_blinding_seed', 'exchange-0002', 'constrain',TRUE ,FALSE);

