/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _QA_ATSC_SINGLE_VITERBI_H
#define _QA_ATSC_SINGLE_VITERBI_H

#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TextTestResult.h>

#include <atsc_single_viterbi.h>
#include <atsc_basic_trellis_encoder.h>

class qa_atsc_single_viterbi : public CppUnit::TestCase {
 private:
  atsc_single_viterbi		decoder;
  atsc_basic_trellis_encoder 	encoder;
  
 public:

  static void register_tests (CppUnit::TestSuite *suite)
  {
    suite->addTest (new CppUnit::TestCaller<qa_atsc_single_viterbi>
      ("single_viterbi: t0", &qa_atsc_single_viterbi::t0));
    suite->addTest (new CppUnit::TestCaller<qa_atsc_single_viterbi>
      ("single_viterbi: t1", &qa_atsc_single_viterbi::t1));
  }

 private:

  void t0 ();
  void t1 ();
  void encode_block(unsigned char *out, unsigned char *in, unsigned n);
  void decode_block(unsigned char *out, unsigned char *in, unsigned n, float noise_factor);
  float noise ();

};

#endif /* _QA_ATSC_SINGLE_VITERBI_H_ */
