/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2014 (c)
 * 
 *    file: options.c
 *    This file is part of mino (Mino).
 *
 *    mino (Mino) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    mino (Mino) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with mino (Mino).  If not, see <http://www.gnu.org/licenses/>.
 */    
#include "defs.h"
#include "options.h"
#include "kbd.h"
#include <pwd.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

struct passwd *pass;//will be used to find the home dir

int x, y, w, x, sel;
int oldFGColors[6];
int oldBGColors[6];

char *changeColorsDialogOptions[6] =
      { "Window          ",
	"Highlighted text",
	"Menu bar        ",
	"Status bar      ",
	"Buttons         ",
	"Selected Button "
      };

char* findColorName(int c) 
{
  switch(c) 
  {
    case(30):case(40): return "BLACK  "; break;
    case(31):case(41): return "RED    "; break;
    case(32):case(42): return "GREEN  "; break;
    case(33):case(43): return "BROWN  "; break;
    case(34):case(44): return "BLUE   "; break;
    case(35):case(45): return "MAGENTA"; break;
    case(36):case(46): return "CYAN   "; break;
    case(37):case(47): return "WHITE  "; break;
  }//end switch
  return NULL;
}

void saveOldColors() 
{
  int i;
  for(i = 0; i < 6; i++) 
  {
    oldFGColors[i] = FG_COLOR[i];
    oldBGColors[i] = BG_COLOR[i];
  }
}

void resetColors() 
{
  int i;
  for(i = 0; i < 6; i++) 
  {
    FG_COLOR[i] = oldFGColors[i];
    BG_COLOR[i] = oldBGColors[i];
  }
}

int showColorChooserDialog() 
{
  int i;
  int x1 = (SCREEN_H/2)-5;
  int y1 = (SCREEN_W/2)-10;
  drawBox(x1, y1, x1+10, y1+16, " Choose color ", YES);
  for(i = 30; i < 38; i++)
    printf("\e[%d;%dH%s", ++x1, y1+1, findColorName(i));
  printf("\e[%d;%dHCANCEL", ++x1, y1+1);
  x1 = (SCREEN_H/2)-4; i = 30;
  setScreenColors(FG_COLOR[COLOR_HIGHLIGHT_TEXT], BG_COLOR[COLOR_HIGHLIGHT_TEXT]);
  printf("\e[%d;%dH%s", x1, y1+1, findColorName(i));
  fflush(stdout);
  int endme = 0;
  char *c;
  
  while(!endme) 
  {
    c = getKey();
    //printf("         %c,%d", c, c);
    switch(c[0]) 
    {
      case(UP_KEY):
	//msgBox("UP", OK, INFO);
	if(i <= 30) 
	{
	  setScreenColors(FG_COLOR[COLOR_WINDOW], BG_COLOR[COLOR_WINDOW]);
	  printf("\e[%d;%dH%s", x1, y1+1, findColorName(i));
	  i = 38;
	  setScreenColors(FG_COLOR[COLOR_HIGHLIGHT_TEXT], BG_COLOR[COLOR_HIGHLIGHT_TEXT]);
	  printf("\e[%d;%dHCANCEL", x1+i-30, y1+1);
	  //printf("\e[%d;%dH%s", x1+i-30, y1+1, findColorName(i));
	} 
	else if(i == 38) 
	{
	  setScreenColors(FG_COLOR[COLOR_WINDOW], BG_COLOR[COLOR_WINDOW]);
	  printf("\e[%d;%dHCANCEL", x1+i-30, y1+1);
	  i = 37;
	  setScreenColors(FG_COLOR[COLOR_HIGHLIGHT_TEXT], BG_COLOR[COLOR_HIGHLIGHT_TEXT]);
	  printf("\e[%d;%dH%s", x1+i-30, y1+1, findColorName(i));
	} 
	else 
	{
	  setScreenColors(FG_COLOR[COLOR_WINDOW], BG_COLOR[COLOR_WINDOW]);
	  printf("\e[%d;%dH%s", x1+i-30, y1+1, findColorName(i));
	  i--;
	  setScreenColors(FG_COLOR[COLOR_HIGHLIGHT_TEXT], BG_COLOR[COLOR_HIGHLIGHT_TEXT]);
	  printf("\e[%d;%dH%s", x1+i-30, y1+1, findColorName(i));
	}//end if
	fflush(stdout);
	endme = 0;
	break;
      case(DOWN_KEY):
	//msgBox("DOWN", OK, INFO);
	if(i >= 38) 
	{
	  setScreenColors(FG_COLOR[COLOR_WINDOW], BG_COLOR[COLOR_WINDOW]);
	  printf("\e[%d;%dHCANCEL", x1+i-30, y1+1);
	  //printf("\e[%d;%dH%s", x1+i-30, y1+1, findColorName(i));
	  i = 30;
	  setScreenColors(FG_COLOR[COLOR_HIGHLIGHT_TEXT], BG_COLOR[COLOR_HIGHLIGHT_TEXT]);
	  printf("\e[%d;%dH%s", x1+i-30, y1+1, findColorName(i));
	} 
	else if(i == 37) 
	{
	  setScreenColors(FG_COLOR[COLOR_WINDOW], BG_COLOR[COLOR_WINDOW]);
	  printf("\e[%d;%dH%s", x1+i-30, y1+1, findColorName(i));
	  //printf("\e[%d;%dH%s", x1+i-30, y1+1, findColorName(i));
	  i = 38;
	  setScreenColors(FG_COLOR[COLOR_HIGHLIGHT_TEXT], BG_COLOR[COLOR_HIGHLIGHT_TEXT]);
	  printf("\e[%d;%dHCANCEL", x1+i-30, y1+1);
	} 
	else 
	{
	  setScreenColors(FG_COLOR[COLOR_WINDOW], BG_COLOR[COLOR_WINDOW]);
	  printf("\e[%d;%dH%s", x1+i-30, y1+1, findColorName(i));
	  i++;
	  setScreenColors(FG_COLOR[COLOR_HIGHLIGHT_TEXT], BG_COLOR[COLOR_HIGHLIGHT_TEXT]);
	  printf("\e[%d;%dH%s", x1+i-30, y1+1, findColorName(i));
	}//end if
	endme = 0;
	fflush(stdout);
	break;
      case(ENTER_KEY):
      case(SPACE_KEY):
	//msgBox("ENTER", OK, INFO);
	//c = getKey();
	if(i == 38) { i = 0; return 0; break; }
	endme = 1; //fflush(stdin);
	return i; break;
      case(0):
	continue; break;
      case(ESC_KEY):
      default:
	//msgBox("DEFAULT", OK, INFO);
	endme = 1; //i = 0; //fflush(stdin);
	return 0; break;
    }//end switch
  }//end while
  return i;
}

void refreshChangeColorsDialog() 
{
  int i;
  drawBox(x, y, h, w, "Change colors", YES);
  fprintf(stdout, "\e[%d;%dHForeground  Background", x+1, y+16);
  fprintf(stdout, "\e[%d;%dH  OK   RESET", h-1, y+12);
  setScreenColors(FG_COLOR[COLOR_WINDOW], BG_COLOR[COLOR_WINDOW]);
  for(i = 0; i < changeColorsDialogOptionsN; i++) 
  {
    fprintf(stdout, "\e[%d;%dH", x+i+2, y+1);
    fprintf(stdout, "%s  %s  %s", changeColorsDialogOptions[i],
		    findColorName(FG_COLOR[i]),
		    findColorName(BG_COLOR[i]));
  }//end for
  setScreenColors(FG_COLOR[COLOR_HIGHLIGHT_TEXT], BG_COLOR[COLOR_HIGHLIGHT_TEXT]);
  if(sel == 12)
    fprintf(stdout, "\e[%d;%dH  OK  ", h-1, y+12);
  else if(sel == 13)
    fprintf(stdout, "\e[%d;%dHRESET", h-1, y+19);
  else if(sel >= 0 && sel <= 5)
    fprintf(stdout, "\e[%d;%dH%s", x+sel+2, y+19, findColorName(FG_COLOR[sel]));
  else if(sel >= 6 && sel <= 11)
    fprintf(stdout, "\e[%d;%dH%s", x+(sel-6)+2, y+28, findColorName(BG_COLOR[sel-6]));
  fflush(stdout);
}


void optionsMenu_Change_Colors() 
{
  x = (SCREEN_H/2)-5;
  y = (SCREEN_W/2)-18;
  w = y+38;
  h = x+10;
  //int i;
  sel = 0;//selected item: 0-5 FG_COLORS, 6-11 BG_COLORS,
	      //12 OK, 13 RESET
  saveOldColors();
  refreshChangeColorsDialog();
  int endme = 0;
  int enter_error = 0;
  //infinite loop to get user input
  while(!endme) 
  {
    char *c = getKey();
    //printf("         ..%c,%d", c, c);
    switch(c[0]) 
    {
      case(0):
	//continue; 
	break;
      case(UP_KEY):
	if(sel == 0 || sel == 6) sel = 12;
	else if(sel == 12) sel = 5;
	else if(sel == 13) sel = 11;
	else sel--;
	refreshChangeColorsDialog();
	enter_error = 0;
	break;
      case(DOWN_KEY):
	if(sel == 12) sel = 0;
	else if(sel == 13) sel = 6;
	else if(sel == 5 || sel == 6) sel = 12;
	else sel++;
	refreshChangeColorsDialog();
	enter_error = 0;
	break;
      case(LEFT_KEY):
      case(RIGHT_KEY):
	if(sel == 12) sel = 13;
	else if(sel == 13) sel = 12;
	else if(sel >= 0 && sel <= 5) sel += 6;
	else sel -= 6;
	refreshChangeColorsDialog();
	enter_error = 0;
	break;
      case(ESC_KEY):
	resetColors();
	//write_config_file();
	refreshView();
	endme = 1;
	return; break;
      case(SPACE_KEY):
      case(ENTER_KEY):
	if(enter_error) continue;
	if(sel == 12) 
	{
	  write_config_file();
	  refreshView();
	  endme = 1;
	  return;
	} 
	else if(sel == 13) 
	{
	  resetColors();
	  refreshChangeColorsDialog();
	  //write_config_file();
	} 
	else 
	{
	  int tmp;
	  enter_error = !enter_error;
	  if(!enter_error) continue;
	  if(sel >= 0 && sel <= 5) 
	  {
	    tmp = showColorChooserDialog();
	    if(tmp) FG_COLOR[sel] = tmp;
	    //else { sprintf(lines[0], "%d", tmp); return; }
	    //c = DOWN_KEY;
	    //msgBox("1", OK, INFO);
	    refreshChangeColorsDialog();
	    //msgBox("2", OK, INFO);
	    //if(!X_IS_RUNNING) c = getKey();
	    break;
	  } 
	  else if(sel >= 6 && sel <= 11) 
	  {
	    tmp = showColorChooserDialog();
	    if(tmp) BG_COLOR[sel-6] = tmp+10;
	    //else { sprintf(lines[0], "%d", tmp); return; }
	    //c = DOWN_KEY;
	    refreshChangeColorsDialog();
	    //if(!X_IS_RUNNING) c = getKey();
	    break;
	  }
	}//end if
	break;
    }//end switch
    //printf("%d..%c", c, c);
    //msgBox("3", OK, INFO);
    //refreshChangeColorsDialog();
    //printf("         ..%c,%d", c, c);
  }//end while
  
}

/****************************************
 * Takes new definition for number of
 * spaces in a tab character and writes
 * configuration into ~/.mino.conf file.
 * **************************************/
void optionsMenu_Tab_Spaces() 
{
  char *t;
  t = inputBox("Enter number of spaces in a tab:", " Tab spaces ");
  if(t) 
  {
    char *t2 = (char *) malloc(10);
    makestr(t2, t);
    if(atoi(t2) <= 0) return;
    TAB_CHARS = atoi(t2);
    write_config_file();
    free(t2);
    //msgBox("Finished writing default values to ~/.mino.conf", OK, INFO);
  }
}

/******************************************
 * Resets configuration file ~/.mino.conf
 * to default values.
 * ****************************************/
void optionsMenu_Reset_Config() 
{
      if(!(pass = getpwuid(geteuid()))) 
      {
	msgBox("Couldn't open home directory to write config file.", OK, ERROR);
	refreshView();
	return;
      }
      config_file_name = (char *) malloc(strlen(pass->pw_dir)+11);
      strcpy(config_file_name, pass->pw_dir);
      strcat(config_file_name, "/");
      strcat(config_file_name, ".mino.conf");
      if(!(config_file = fopen(config_file_name, "w"))) 
      {
	msgBox("Couldn't write to config file in home directory.", OK, ERROR);
	refreshView();
	return;
      }
      fprintf(config_file, "#Configuration file for mino program\n");
      fprintf(config_file, "#Please do not modify this file by hand\n");
      fprintf(config_file, "#Use the Options menu in mino to change program configuration.\n\n");
      fprintf(config_file, "#Line Wrapping\n");
      fprintf(config_file, "#If TRUE, lines cannot be longer than the screen width\n");
      fprintf(config_file, "#If FALSE, lines cannot be upto MAX_CHARS_PER_LINE characters\n");
      fprintf(config_file, "#Note this value is omitted if WRAP_LINES is TRUE\n");
      fprintf(config_file, "MAX_CHARS_PER_LINE = 100\n");
      fprintf(config_file, "WRAP_LINES = TRUE\n\n");
      fprintf(config_file, "#Number of spaces to insert when user presses TAB key\n");
      fprintf(config_file, "TAB_CHARS = 8\n\n");
      fprintf(config_file, "#Default title for newly opened documents, no quotes\n");
      fprintf(config_file, "DEFAULT_TITLE = untitled\n\n");
      fprintf(config_file, "#Start mino with CAPS and INSERT set to OFF/ON\n");
      fprintf(config_file, "CAPS = OFF\n");
      fprintf(config_file, "INSERT = OFF\n\n");
      fprintf(config_file, "#Display colors\n");
      fprintf(config_file, "FG_COLOR_WIN = 37\n");
      fprintf(config_file, "FG_COLOR_HLT = 34\n");
      fprintf(config_file, "FG_COLOR_MBAR = 34\n");
      fprintf(config_file, "FG_COLOR_SBAR = 34\n");
      fprintf(config_file, "FG_COLOR_HBUT = 32\n");
      fprintf(config_file, "FG_COLOR_BUT = 37\n");
      fprintf(config_file, "BG_COLOR_WIN = 44\n");
      fprintf(config_file, "BG_COLOR_HLT = 47\n");
      fprintf(config_file, "BG_COLOR_MBAR = 47\n");
      fprintf(config_file, "BG_COLOR_SBAR = 47\n");
      fprintf(config_file, "BG_COLOR_HBUT = 41\n");
      fprintf(config_file, "BG_COLOR_BUT = 41\n");
      fprintf(config_file, "#Show README on startup\n");
      fprintf(config_file, "SHOW_README\n");
      fprintf(config_file, "#GnuDOS Level\n");
      fprintf(config_file, "GNU_DOS_LEVEL = 1\n");
      fclose(config_file);
      msgBox("Finished writing default values to ~/.mino.conf", OK, INFO);
      free(config_file_name);
      refreshView();
      return;
}

void write_config_file() 
{
      if(!(pass = getpwuid(geteuid()))) 
      {
	msgBox("Couldn't open home directory to write config file.", OK, ERROR);
	refreshView();
	return;
      }
      config_file_name = (char *) malloc(strlen(pass->pw_dir)+11);
      strcpy(config_file_name, pass->pw_dir);
      strcat(config_file_name, "/");
      strcat(config_file_name, ".mino.conf");
      if(!(config_file = fopen(config_file_name, "w"))) 
      {
	msgBox("Couldn't write to config file in home directory.", OK, ERROR);
	refreshView();
	return;
      }
      fprintf(config_file, "#Configuration file for mino program\n");
      fprintf(config_file, "#Please do not modify this file by hand\n");
      fprintf(config_file, "#Use the Options menu in mino to change program configuration.\n\n");
      fprintf(config_file, "#Line Wrapping\n");
      fprintf(config_file, "#If TRUE, lines cannot be longer than the screen width\n");
      fprintf(config_file, "#If FALSE, lines cannot be upto MAX_CHARS_PER_LINE characters\n");
      fprintf(config_file, "#Note this value is omitted if WRAP_LINES is TRUE\n");
      fprintf(config_file, "MAX_CHARS_PER_LINE = 100\n");
      fprintf(config_file, "WRAP_LINES = TRUE\n\n");
      fprintf(config_file, "#Number of spaces to insert when user presses TAB key\n");
      fprintf(config_file, "TAB_CHARS = %d\n\n", TAB_CHARS);
      fprintf(config_file, "#Default title for newly opened documents, no quotes\n");
      fprintf(config_file, "DEFAULT_TITLE = untitled\n\n");
      fprintf(config_file, "#Start mino with CAPS and INSERT set to OFF/ON\n");
      fprintf(config_file, "CAPS = OFF\n");
      fprintf(config_file, "INSERT = OFF\n\n");
      fprintf(config_file, "#Display colors\n");
      fprintf(config_file, "FG_COLOR_WIN = %d\n", FG_COLOR[COLOR_WINDOW]);
      fprintf(config_file, "FG_COLOR_HLT = %d\n", FG_COLOR[COLOR_HIGHLIGHT_TEXT]);
      fprintf(config_file, "FG_COLOR_MBAR = %d\n", FG_COLOR[COLOR_MENU_BAR]);
      fprintf(config_file, "FG_COLOR_SBAR = %d\n", FG_COLOR[COLOR_STATUS_BAR]);
      fprintf(config_file, "FG_COLOR_HBUT = %d\n", FG_COLOR[COLOR_HBUTTONS]);
      fprintf(config_file, "FG_COLOR_BUT = %d\n", FG_COLOR[COLOR_BUTTONS]);
      fprintf(config_file, "BG_COLOR_WIN = %d\n", BG_COLOR[COLOR_WINDOW]);
      fprintf(config_file, "BG_COLOR_HLT = %d\n", BG_COLOR[COLOR_HIGHLIGHT_TEXT]);
      fprintf(config_file, "BG_COLOR_MBAR = %d\n", BG_COLOR[COLOR_MENU_BAR]);
      fprintf(config_file, "BG_COLOR_SBAR = %d\n", BG_COLOR[COLOR_STATUS_BAR]);
      fprintf(config_file, "BG_COLOR_HBUT = %d\n", BG_COLOR[COLOR_HBUTTONS]);
      fprintf(config_file, "BG_COLOR_BUT = %d\n", BG_COLOR[COLOR_BUTTONS]);
      if(SHOW_README) 
      {
	fprintf(config_file, "#Show README on startup\n");
	fprintf(config_file, "SHOW_README\n");
      }
      fprintf(config_file, "#GnuDOS Level\n");
      fprintf(config_file, "GNU_DOS_LEVEL = %d\n", GNU_DOS_LEVEL);
      fclose(config_file);
      //msgBox("Finished writing default values to ~/.mino.conf", OK, INFO);
      free(config_file_name);
      refreshView();
      return;    
}


void loadKeywords(hmode mode) 
{
  switch(mode) 
  {
    case(C_MODE):
      //basic C language keywords
      keyword[0] = "auto";
      keyword[1] = "break";
      keyword[2] = "case";
      keyword[3] = "char";
      keyword[4] = "const";
      keyword[5] = "continue";
      keyword[6] = "default";
      keyword[8] = "do";
      keyword[7] = "double";
      keyword[9] = "else";
      keyword[10] = "enum";
      keyword[11] = "extern";
      keyword[12] = "float";
      keyword[13] = "for";
      keyword[14] = "goto";
      keyword[15] = "if";
      keyword[16] = "int";
      keyword[17] = "long";
      keyword[18] = "register";
      keyword[19] = "return";
      keyword[20] = "short";
      keyword[21] = "signed";
      keyword[22] = "sizeof";
      keyword[23] = "static";
      keyword[24] = "struct";
      keyword[25] = "switch";
      keyword[26] = "typedef";
      keyword[27] = "union";
      keyword[28] = "unsigned";
      keyword[29] = "void";
      keyword[30] = "volatile";
      keyword[31] = "while";
      //math function names
      keyword[32] = "acos";
      keyword[33] = "asin";
      keyword[35] = "atan";
      keyword[34] = "atan2";
      keyword[37] = "cos";
      keyword[36] = "cosh";
      keyword[39] = "sin";
      keyword[38] = "sinh";
      keyword[41] = "tan";
      keyword[40] = "tanh";
      keyword[44] = "exp";
      keyword[42] = "frexp";
      keyword[43] = "ldexp";
      keyword[46] = "log";
      keyword[45] = "log10";
      keyword[47] = "modf";
      keyword[48] = "pow";
      keyword[49] = "sqrt";
      keyword[50] = "ceil";
      keyword[51] = "fabs";
      keyword[52] = "floor";
      keyword[53] = "fmod";
      //file function names
      keyword[54] = "clearerr";
      keyword[55] = "fclose";
      keyword[56] = "feof";
      keyword[57] = "ferror";
      keyword[58] = "fflush";
      keyword[59] = "fgetpos";
      keyword[60] = "fopen";
      keyword[61] = "fread";
      keyword[62] = "freopen";
      keyword[63] = "fseek";
      keyword[64] = "fsetpos";
      keyword[65] = "ftell";
      keyword[66] = "fwrite";
      keyword[67] = "remove";
      keyword[68] = "rename";
      keyword[69] = "rewind";
      keyword[70] = "setbuf";
      keyword[71] = "setvbuf";
      keyword[72] = "tmpfile";
      keyword[73] = "tmpnam";
      //printf function names
      keyword[74] = "fprintf";
      keyword[79] = "printf";
      keyword[75] = "sprintf";
      keyword[76] = "vfprintf";
      keyword[77] = "vprintf";
      keyword[78] = "vsprintf";
      keyword[80] = "fscanf";
      keyword[82] = "scanf";
      keyword[81] = "sscanf";
      keyword[83] = "fgetc";
      keyword[84] = "fgets";
      keyword[85] = "fputc";
      keyword[86] = "fputs";
      keyword[88] = "getc";
      keyword[87] = "getchar";
      keyword[89] = "gets";
      keyword[91] = "putc";
      keyword[90] = "putchar";
      keyword[92] = "puts";
      keyword[93] = "ungetc";
      keyword[94] = "perror";
      //stdlib function names
      keyword[95] = "atof";
      keyword[96] = "atoi";
      keyword[97] = "atol";
      keyword[98] = "strtod";
      keyword[99] = "strtol";
      keyword[100] = "strtoul";
      keyword[101] = "calloc";
      keyword[102] = "free";
      keyword[103] = "malloc";
      keyword[104] = "realloc";
      keyword[105] = "abort";
      keyword[106] = "atexit";
      keyword[107] = "exit";
      keyword[108] = "getenv";
      keyword[109] = "system";
      keyword[110] = "bsearch";
      keyword[111] = "qsort";
      keyword[112] = "abs";
      keyword[113] = "div";
      keyword[114] = "labs";
      keyword[115] = "ldiv";
      keyword[117] = "rand";
      keyword[116] = "srand";
      keyword[118] = "mblen";
      keyword[119] = "mbstowcs";
      keyword[120] = "mbtowc";
      keyword[121] = "wcstombs";
      keyword[122] = "wctomb";
      //string function names
      keyword[123] = "memchr";
      keyword[124] = "memcmp";
      keyword[125] = "memcpy";
      keyword[126] = "memmove";
      keyword[127] = "memset";
      keyword[128] = "strcat";
      keyword[129] = "strncat";
      keyword[130] = "strchr";
      keyword[131] = "strcmp";
      keyword[132] = "strcoll";
      keyword[133] = "strcpy";
      keyword[134] = "strncpy";
      keyword[135] = "strcspn";
      keyword[136] = "strerror";
      keyword[137] = "strlen";
      keyword[138] = "strpbrk";
      keyword[139] = "strrchr";
      keyword[140] = "strspn";
      keyword[141] = "strstr";
      keyword[142] = "strtok";
      keyword[143] = "strxfrm";
      //time function names
      keyword[144] = "asctime";
      keyword[145] = "clock";
      keyword[146] = "ctime";
      keyword[147] = "difftime";
      keyword[148] = "gmtime";
      keyword[149] = "localtime";
      keyword[150] = "mktime";
      keyword[151] = "strftime";
      keyword[152] = "time";
      ////////
      keyword[153] = "stdin";
      keyword[154] = "stdout";
      keyword[155] = "stderr";
      total_keywords = 156;
      break;
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
    case(CPP_MODE):
      //basic C++ language keywords
      keyword[0] = "alignas";
      keyword[1] = "alignof";
      keyword[3] = "and";
      keyword[2] = "and_eq";
      keyword[4] = "asm";
      keyword[5] = "auto";
      keyword[6] = "bitand";
      keyword[7] = "bitor";
      keyword[8] = "bool";
      keyword[9] = "break";
      keyword[10] = "case";
      keyword[11] = "catch";
      keyword[14] = "char";
      keyword[12] = "char16_t";
      keyword[13] = "char32_t";
      keyword[15] = "class";
      keyword[16] = "compl";
      keyword[19] = "const";
      keyword[17] = "constexpr";
      keyword[18] = "const_cast";
      keyword[20] = "continue";
      keyword[21] = "decltype";
      keyword[22] = "default";
      keyword[23] = "delete";
      keyword[25] = "do";
      keyword[24] = "double";
      keyword[26] = "dynamic_cast";
      keyword[27] = "else";
      keyword[28] = "enum";
      keyword[29] = "explicit";
      keyword[30] = "extern";
      keyword[31] = "export";
      keyword[32] = "false";
      keyword[33] = "float";
      keyword[34] = "for";
      keyword[35] = "friend";
      keyword[36] = "goto";
      keyword[37] = "if";
      keyword[38] = "inline";
      keyword[39] = "int";
      keyword[40] = "long";
      keyword[41] = "mutable";
      keyword[42] = "namespace";
      keyword[43] = "new";
      keyword[44] = "noexcept";
      keyword[46] = "not";
      keyword[45] = "not_eq";
      keyword[47] = "nullptr";
      keyword[48] = "operator";
      keyword[50] = "or";
      keyword[49] = "or_eq";
      keyword[51] = "private";
      keyword[52] = "protected";
      keyword[53] = "public";
      keyword[54] = "register";
      keyword[55] = "reinterpret_cast";
      keyword[56] = "return";
      keyword[57] = "short";
      keyword[58] = "signed";
      keyword[59] = "sizeof";
      keyword[62] = "static";
      keyword[60] = "static_assert";
      keyword[61] = "static_cast";
      keyword[63] = "struct";
      keyword[64] = "switch";
      keyword[65] = "template";
      keyword[66] = "this";
      keyword[67] = "thread_local";
      keyword[68] = "throw";
      keyword[69] = "true";
      keyword[70] = "try";
      keyword[71] = "typedef";
      keyword[72] = "typeid";
      keyword[73] = "typename";
      keyword[74] = "union";
      keyword[75] = "unsigned";
      keyword[76] = "using";
      keyword[77] = "virtual";
      keyword[78] = "void";
      keyword[79] = "volatile";
      keyword[80] = "wchar_t";
      keyword[81] = "while";
      keyword[83] = "xor";
      keyword[82] = "xor_eq";
      keyword[84] = "overried";
      keyword[85] = "final";
      //strings library
      keyword[89] = "string";
      keyword[86] = "wstring";
      keyword[87] = "u16string";
      keyword[88] = "u32string";
      //containers library
      keyword[90] = "array";
      keyword[91] = "vector";
      keyword[92] = "deque";
      keyword[93] = "forward_list";
      keyword[94] = "list";
      keyword[95] = "set";
      keyword[96] = "map";
      /*keyword[90] = "multiset";
      keyword[90] = "multimap";
      keyword[90] = "unordered_set";
      keyword[100] = "unordered_map";
      keyword[100] = "unordered_multiset";
      keyword[100] = "unordered_multimap";
      keyword[100] = "stack";
      keyword[100] = "queue";
      keyword[100] = "all_of";
      keyword[100] = "any_of";
      keyword[100] = "none_of";
      keyword[100] = "for_each";
      keyword[100] = "count_if";
      keyword[110] = "count";
      keyword[110] = "mismatch";
      keyword[110] = "equal";
      keyword[110] = "find";
      keyword[110] = "find_if";
      keyword[110] = "find_if_not";
      keyword[110] = "find_end";
      keyword[110] = "find_first_of";
      keyword[110] = "adjacent_find";
      keyword[110] = "search";
      keyword[120] = "search_n";
      keyword[120] = "copy";
      keyword[120] = "copy_if";
      keyword[120] = "copy_n";
      keyword[120] = "copy_backward";
      keyword[120] = "move";
      keyword[120] = "move_backward";
      keyword[120] = "fill";
      keyword[120] = "fill_n";
      keyword[120] = "transform";
      keyword[130] = "generate";
      keyword[] = "generate_n";
      keyword[] = "remove";
      keyword[] = "remove_if";
      keyword[] = "remove_copy";
      keyword[] = "remove_copy_if";
      keyword[] = "replace";
      keyword[] = "replace_if";
      keyword[] = "replace_copy";
      keyword[] = "replace_copy_if";
      keyword[] = "swap";
      keyword[] = "swap_ranges";
      keyword[] = "iter_swap";
      keyword[] = "reverse";
      keyword[] = "reverse_copy";
      keyword[] = "rotate";
      keyword[] = "rotate_copy";
      keyword[] = "random_shuffle";
      keyword[] = "shuffle";
      keyword[] = "unique";
      keyword[] = "unique_copy";
      keyword[] = "is_partitioned";
      keyword[] = "partition";
      keyword[] = "partition_copy";
      keyword[] = "stable_partition";
      keyword[] = "partition_point";
      keyword[] = "is_sorted";
      keyword[] = "is_sorted_until";
      keyword[] = "sort";
      keyword[] = "partial_sort";
      keyword[] = "partial_sort_copy";
      keyword[] = "stable_sort";
      keyword[] = "nth_element";
      keyword[] = "lower_bound";
      keyword[] = "upper_bound";
      keyword[] = "binary_search";
      keyword[] = "equal_range";
      keyword[] = "merge";
      keyword[] = "inplace_merge";
      keyword[] = "includes";
      keyword[] = "set_difference";
      keyword[] = "set_intersection";
      keyword[] = "set_symmetric_difference";
      keyword[] = "set_union";
      keyword[] = "is_heap";
      keyword[] = "is_heap_until";
      keyword[] = "make_heap";
      keyword[] = "push_heap";
      keyword[] = "pop_heap";
      keyword[] = "sort_heap";
      keyword[] = "max";
      keyword[] = "max_element";
      keyword[] = "min";
      keyword[] = "min_element";
      keyword[] = "minmax";
      keyword[] = "minmax_element";
      keyword[] = "lexicographical_compare";
      keyword[] = "is_permutation";
      keyword[] = "next_permutation";
      keyword[] = "prev_permutation";
      keyword[] = "itoa";
      keyword[] = "accumulate";
      keyword[] = "inner_product";
      keyword[] = "adjacent_difference";
      keyword[] = "partial_sum";*/
      keyword[97] = "qsort";
      keyword[98] = "bsearch";
      //I/O functions
      keyword[99] = "srand";
      keyword[100] = "rand";
      keyword[101] = "std";
      keyword[102] = "fopen";
      keyword[103] = "freopen";
      keyword[104] = "fclose";
      keyword[105] = "fflush";
      keyword[106] = "fwide";
      keyword[107] = "setbuf";
      keyword[108] = "setvbuf";
      keyword[109] = "fread";
      keyword[110] = "fwrite";
      keyword[111] = "fgetc";
      keyword[112] = "getc";
      keyword[113] = "fgets";
      keyword[114] = "fputc";
      keyword[115] = "putc";
      keyword[116] = "fputs";
      keyword[117] = "getchar";
      keyword[118] = "gets";
      keyword[119] = "putchar";
      keyword[120] = "puts";
      keyword[121] = "ungetc";
      keyword[122] = "fgetwc";
      keyword[130] = "getwc";
      keyword[124] = "fgetws";
      keyword[125] = "fputwc";
      keyword[126] = "putwc";
      keyword[127] = "fputws";
      keyword[128] = "getwchar";
      keyword[129] = "putwchar";
      keyword[123] = "ungetwc";
      keyword[136] = "scanf";
      keyword[131] = "fscanf";
      keyword[132] = "sscanf";
      keyword[133] = "vscanf";
      keyword[134] = "vfscanf";
      keyword[135] = "vsscanf";
      keyword[144] = "printf";
      keyword[137] = "fprintf";
      keyword[138] = "sprintf";
      keyword[139] = "snprintf";
      keyword[140] = "vprintf";
      keyword[141] = "vfprintf";
      keyword[142] = "vsprintf";
      keyword[143] = "vsnprintf";
      keyword[150] = "wscanf";
      keyword[145] = "fwscanf";
      keyword[146] = "swscanf";
      keyword[147] = "vwscanf";
      keyword[148] = "vfwscanf";
      keyword[149] = "vswscanf";
      keyword[156] = "wprintf";
      keyword[151] = "fwprintf";
      keyword[152] = "swprintf";
      keyword[153] = "vwprintf";
      keyword[154] = "vfwprintf";
      keyword[155] = "vswprintf";
      keyword[157] = "ftell";
      keyword[158] = "fgetpos";
      keyword[159] = "fseek";
      keyword[160] = "fsetpos";
      keyword[161] = "rewind";
      keyword[162] = "clearerr";
      keyword[163] = "feof";
      keyword[164] = "ferror";
      keyword[165] = "perror";
      keyword[166] = "remove";
      keyword[167] = "rename";
      keyword[168] = "tmpfile";
      keyword[169] = "tmpnam";
      keyword[170] = "stdin";
      keyword[171] = "stdout";
      keyword[172] = "stderr";
      total_keywords = 173;
      break;
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
    case(SHELL_MODE):
      //shell keywords
      keyword[0] = "!";
      keyword[1] = "case";
      keyword[3] = "do";
      keyword[2] = "done";
      keyword[4] = "elif";
      keyword[5] = "else";
      keyword[6] = "esac";
      keyword[7] = "fi";
      keyword[8] = "for";
      keyword[9] = "function";
      keyword[10] = "if";
      keyword[11] = "in";
      keyword[12] = "select";
      keyword[13] = "then";
      keyword[14] = "until";
      keyword[15] = "while";
      keyword[16] = "time";
      keyword[17] = "[[";
      keyword[18] = "]]";
      //shell builtin functions
      keyword[19] = ".";
      keyword[20] = ":";
      keyword[21] = "[";
      keyword[22] = "alias";
      keyword[23] = "bg";
      keyword[24] = "bind";
      keyword[25] = "break";
      keyword[26] = "builtin";
      keyword[27] = "caller";
      keyword[28] = "cd";
      keyword[29] = "command";
      keyword[30] = "compgen";
      keyword[31] = "complete";
      keyword[32] = "compopt";
      keyword[33] = "continue";
      keyword[34] = "declare";
      keyword[35] = "dirs";
      keyword[36] = "disown";
      keyword[37] = "echo";
      keyword[38] = "enable";
      keyword[39] = "eval";
      keyword[40] = "exec";
      keyword[41] = "exit";
      keyword[42] = "export";
      keyword[43] = "false";
      keyword[44] = "fc";
      keyword[45] = "fg";
      keyword[46] = "getopts";
      keyword[47] = "hash";
      keyword[48] = "help";
      keyword[49] = "history";
      keyword[50] = "jobs";
      keyword[51] = "kill";
      keyword[52] = "let";
      keyword[53] = "local";
      keyword[54] = "logout";
      keyword[55] = "mapfile";
      keyword[56] = "popd";
      keyword[57] = "printf";
      keyword[58] = "pushd";
      keyword[59] = "pwd";
      keyword[62] = "read";
      keyword[60] = "readarray";
      keyword[61] = "readonly";
      keyword[63] = "return";
      keyword[64] = "set";
      keyword[65] = "shift";
      keyword[66] = "shopt";
      keyword[67] = "source";
      keyword[68] = "suspend";
      keyword[69] = "test";
      keyword[70] = "times";
      keyword[71] = "trap";
      keyword[72] = "true";
      keyword[74] = "type";
      keyword[73] = "typeset";
      keyword[75] = "ulimit";
      keyword[76] = "umask";
      keyword[77] = "unalias";
      keyword[78] = "unset";
      keyword[79] = "wait";
      keyword[80] = "{";
      keyword[81] = "}";
      total_keywords = 82;
      break;
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
      /////////////////////////////////////////////////
    case(PERL_MODE):
      //PERL functions
      keyword[0] = "-A";
      keyword[1] = "-B";
      keyword[2] = "-b";
      keyword[3] = "-C";
      keyword[4] = "-c";
      keyword[5] = "-d";
      keyword[6] = "-e";
      keyword[7] = "-f";
      keyword[8] = "-g";
      keyword[9] = "-k";
      keyword[10] = "-l";
      keyword[11] = "-M";
      keyword[12] = "-O";
      keyword[13] = "-o";
      keyword[14] = "-p";
      keyword[15] = "-r";
      keyword[16] = "-R";
      keyword[17] = "-s";
      keyword[18] = "-S";
      keyword[19] = "-T";
      keyword[20] = "-t";
      keyword[21] = "-u";
      keyword[22] = "-w";
      keyword[23] = "-W";
      keyword[24] = "-X";
      keyword[25] = "-x";
      keyword[26] = "-z";
      keyword[27] = "abs";
      keyword[28] = "accept";
      keyword[29] = "alarm";
      keyword[30] = "atan2";
      keyword[31] = "AUTOLOAD";
      keyword[32] = "BEGIN";
      keyword[33] = "bind";
      keyword[34] = "binmode";
      keyword[35] = "bless";
      keyword[36] = "break";
      keyword[37] = "caller";
      keyword[38] = "chdir";
      keyword[39] = "CHECK";
      keyword[40] = "chmod";
      keyword[41] = "chomp";
      keyword[42] = "chop";
      keyword[43] = "chown";
      keyword[45] = "chr";
      keyword[44] = "chroot";
      keyword[47] = "close";
      keyword[46] = "closedir";
      keyword[48] = "connect";
      keyword[49] = "cos";
      keyword[50] = "crypt";
      keyword[51] = "dbmclose";
      keyword[52] = "dbmopen";
      keyword[53] = "defined";
      keyword[54] = "delete";
      keyword[55] = "DESTROY";
      keyword[56] = "die";
      keyword[57] = "dump";
      keyword[58] = "each";
      keyword[59] = "END";
      keyword[60] = "endgrent";
      keyword[61] = "endhostent";
      keyword[62] = "endprotoent";
      keyword[63] = "endpwent";
      keyword[64] = "endservent";
      keyword[65] = "eof";
      keyword[66] = "eval";
      keyword[67] = "exec";
      keyword[68] = "exists";
      keyword[69] = "exit";
      keyword[70] = "fcntl";
      keyword[71] = "fileno";
      keyword[72] = "flock";
      keyword[73] = "fork";
      keyword[74] = "format";
      keyword[75] = "formline";
      keyword[76] = "getc";
      keyword[77] = "getgrent";
      keyword[78] = "getgrgid";
      keyword[79] = "getgrnam";
      keyword[80] = "gethostbyaddr";
      keyword[81] = "gethostbyname";
      keyword[82] = "gethostent";
      keyword[83] = "getlogin";
      keyword[84] = "getnetbyaddr";
      keyword[85] = "getnetbyname";
      keyword[86] = "getnetent";
      keyword[87] = "getpeername";
      keyword[88] = "getpgrp";
      keyword[89] = "getppid";
      keyword[90] = "getpriority";
      keyword[91] = "getprotobyname";
      keyword[92] = "getprotobynumber";
      keyword[93] = "getprotoent";
      keyword[94] = "getpwent";
      keyword[95] = "getpwnam";
      keyword[96] = "getpwuid";
      keyword[97] = "getservbyname";
      keyword[98] = "getservbyport";
      keyword[99] = "getservent";
      keyword[100] = "getsockname";
      keyword[101] = "getsockopt";
      keyword[102] = "glob";
      keyword[103] = "gmtime";
      keyword[104] = "goto";
      keyword[105] = "grep";
      keyword[106] = "hex";
      keyword[107] = "index";
      keyword[108] = "INIT";
      keyword[109] = "int";
      keyword[110] = "ioctl";
      keyword[111] = "join";
      keyword[112] = "keys";
      keyword[113] = "kill";
      keyword[114] = "last";
      keyword[116] = "lc";
      keyword[115] = "lcfirst";
      keyword[117] = "length";
      keyword[118] = "link";
      keyword[119] = "listen";
      keyword[121] = "local";
      keyword[120] = "localtime";
      keyword[122] = "log";
      keyword[123] = "lstat";
      keyword[124] = "map";
      keyword[125] = "mkdir";
      keyword[126] = "msgctl";
      keyword[127] = "msgget";
      keyword[128] = "msgrcv";
      keyword[129] = "msgsnd";
      keyword[130] = "my";
      keyword[131] = "next";
      keyword[132] = "not";
      keyword[133] = "oct";
      keyword[135] = "open";
      keyword[134] = "opendir";
      keyword[136] = "ord";
      keyword[137] = "our";
      keyword[138] = "pack";
      keyword[139] = "pipe";
      keyword[140] = "pop";
      keyword[141] = "pos";
      keyword[143] = "print";
      keyword[142] = "printf";
      keyword[144] = "prototype";
      keyword[145] = "push";
      keyword[146] = "quotemeta";
      keyword[147] = "rand";
      keyword[152] = "read";
      keyword[148] = "readdir";
      keyword[149] = "readline";
      keyword[150] = "readlink";
      keyword[151] = "readpipe";
      keyword[153] = "recv";
      keyword[154] = "redo";
      keyword[155] = "ref";
      keyword[156] = "rename";
      keyword[157] = "require";
      keyword[158] = "reset";
      keyword[159] = "return";
      keyword[160] = "reverse";
      keyword[161] = "rewinddir";
      keyword[162] = "rindex";
      keyword[163] = "rmdir";
      keyword[164] = "say";
      keyword[165] = "scalar";
      keyword[167] = "seek";
      keyword[166] = "seekdir";
      keyword[168] = "select";
      keyword[169] = "semctl";
      keyword[170] = "semget";
      keyword[171] = "semop";
      keyword[172] = "send";
      keyword[173] = "setgrent";
      keyword[174] = "sethostent";
      keyword[175] = "setnetent";
      keyword[176] = "setpgrp";
      keyword[177] = "setpriority";
      keyword[178] = "setprotoent";
      keyword[179] = "setpwent";
      keyword[180] = "setservent";
      keyword[181] = "setsockopt";
      keyword[182] = "shift";
      keyword[183] = "shmctl";
      keyword[184] = "shmget";
      keyword[185] = "shmread";
      keyword[186] = "shmwrite";
      keyword[187] = "shutdown";
      keyword[188] = "sin";
      keyword[189] = "sleep";
      keyword[191] = "socket";
      keyword[190] = "socketpair";
      keyword[192] = "sort";
      keyword[193] = "splice";
      keyword[194] = "split";
      keyword[195] = "sprintf";
      keyword[196] = "sqrt";
      keyword[197] = "srand";
      keyword[199] = "stat";
      keyword[198] = "state";
      keyword[200] = "study";
      keyword[201] = "substr";
      keyword[202] = "symlink";
      keyword[203] = "syscall";
      keyword[204] = "sysopen";
      keyword[205] = "sysread";
      keyword[206] = "sysseek";
      keyword[207] = "system";
      keyword[208] = "syswrite";
      keyword[210] = "tell";
      keyword[209] = "telldir";
      keyword[212] = "tie";
      keyword[211] = "tied";
      keyword[214] = "time";
      keyword[213] = "times";
      keyword[215] = "truncate";
      keyword[217] = "uc";
      keyword[216] = "ucfirst";
      keyword[218] = "umask";
      keyword[219] = "undef";
      keyword[220] = "UNITCHECK";
      keyword[221] = "unlink";
      keyword[222] = "unpack";
      keyword[223] = "unshift";
      keyword[224] = "untie";
      keyword[225] = "use";
      keyword[226] = "utime";
      keyword[227] = "values";
      keyword[228] = "vec";
      keyword[230] = "wait";
      keyword[229] = "waitpid";
      keyword[231] = "wantarray";
      keyword[232] = "warn";
      keyword[233] = "write";
      //PERL syntax
      keyword[234] = "__DATA__";
      keyword[235] = "__END__";
      keyword[236] = "__FILE__";
      keyword[237] = "__LINE__";
      keyword[238] = "__PACKAGE__";
      keyword[239] = "and";
      keyword[240] = "cmp";
      keyword[241] = "continue";
      keyword[242] = "CORE";
      keyword[243] = "do";
      keyword[244] = "else";
      keyword[245] = "elsif";
      keyword[246] = "eq";
      keyword[247] = "exp";
      keyword[249] = "for";
      keyword[248] = "foreach";
      keyword[250] = "ge";
      keyword[251] = "gt";
      keyword[252] = "if";
      keyword[253] = "le";
      keyword[254] = "lock";
      keyword[255] = "lt";
      keyword[256] = "m";
      keyword[257] = "ne";
      keyword[258] = "no";
      keyword[259] = "or";
      keyword[260] = "package";
      keyword[265] = "q";
      keyword[261] = "qq";
      keyword[262] = "qr";
      keyword[263] = "qw";
      keyword[264] = "qx";
      keyword[267] = "s";
      keyword[266] = "sub";
      keyword[268] = "tr";
      keyword[269] = "unless";
      keyword[270] = "until";
      keyword[271] = "while";
      keyword[272] = "xor";
      keyword[273] = "y";
      //PERL variables
      keyword[274] = "$!";
      keyword[275] = "$\"";
      keyword[276] = "$#";
      keyword[277] = "$$";
      keyword[278] = "$%";
      keyword[279] = "$&";
      keyword[280] = "$'";
      keyword[281] = "$(";
      keyword[282] = "$)";
      keyword[283] = "$*";
      keyword[284] = "$+";
      keyword[285] = "$,";
      keyword[286] = "$-";
      keyword[287] = "$.";
      keyword[288] = "$/";
      keyword[289] = "$0";
      keyword[290] = "$:";
      keyword[291] = "$;";
      keyword[292] = "$<";
      keyword[293] = "$=";
      keyword[294] = "$>";
      keyword[295] = "$?";
      keyword[296] = "$@";
      keyword[297] = "$[";
      keyword[298] = "$\\";
      keyword[299] = "$]";
      keyword[300] = "$^";
      keyword[301] = "$^A";
      keyword[302] = "$^C";
      keyword[303] = "$^CHILD_ERROR_NATIVE";
      keyword[304] = "$^D";
      keyword[306] = "$^E";
      keyword[305] = "$^ENCODING";
      keyword[307] = "$^F";
      keyword[308] = "$^H";
      keyword[309] = "$^I";
      keyword[310] = "$^L";
      keyword[311] = "$^M";
      keyword[312] = "$^N";
      keyword[314] = "$^O";
      keyword[313] = "$^OPEN";
      keyword[315] = "$^P";
      keyword[318] = "$^R";
      keyword[316] = "$^RE_DEBUG_FLAGS";
      keyword[317] = "$^RE_TRIE_MAXBUF";
      keyword[319] = "$^S";
      keyword[321] = "$^T";
      keyword[320] = "$^TAINT";
      keyword[322] = "$^UNICODE";
      keyword[323] = "$^UTF8LOCALE";
      keyword[324] = "$^V";
      keyword[327] = "$^W";
      keyword[325] = "$^WARNING_BITS";
      keyword[326] = "$^WIDE_SYSTEM_CALLS";
      keyword[328] = "$^X";
      keyword[329] = "$_";
      keyword[330] = "$`";
      keyword[331] = "$a";
      keyword[332] = "$ACCUMULATOR";
      keyword[334] = "$ARG";
      keyword[333] = "$ARGV";
      keyword[335] = "$b";
      keyword[336] = "$BASETIME";
      keyword[337] = "$CHILD_ERROR";
      keyword[338] = "$COMPILING";
      keyword[339] = "$DEBUGGING";
      keyword[340] = "$EFFECTIVE_GROUP_ID";
      keyword[341] = "$EFFECTIVE_USER_ID";
      keyword[342] = "$EGID";
      keyword[343] = "$ERRNO";
      keyword[344] = "$EUID";
      keyword[345] = "$EVAL_ERROR";
      keyword[346] = "$EXCEPTIONS_BEING_CAUGHT";
      keyword[347] = "$EXECUTABLE_NAME";
      keyword[348] = "$EXTENDED_OS_ERROR";
      keyword[349] = "$FORMAT_FORMFEED";
      keyword[350] = "$FORMAT_LINE_BREAK_CHARACTERS";
      keyword[351] = "$FORMAT_LINES_LEFT";
      keyword[352] = "$FORMAT_LINES_PER_PAGE";
      keyword[353] = "$FORMAT_NAME";
      keyword[354] = "$FORMAT_PAGE_NUMBER";
      keyword[355] = "$FORMAT_TOP_NAME";
      keyword[356] = "$GID";
      keyword[357] = "$INPLACE_Mino";
      keyword[358] = "$INPUT_LINE_NUMBER";
      keyword[359] = "$INPUT_RECORD_SEPARATOR";
      keyword[360] = "$LAST_MATCH_END";
      keyword[361] = "$LAST_PAREN_MATCH";
      keyword[362] = "$LAST_REGEXP_CODE_RESULT";
      keyword[363] = "$LIST_SEPARATOR";
      keyword[364] = "$MATCH";
      keyword[365] = "$MULTILINE_MATCHING";
      keyword[366] = "$NR";
      keyword[367] = "$OFMT";
      keyword[368] = "$OFS";
      keyword[369] = "$ORS";
      keyword[370] = "$OS_ERROR";
      keyword[371] = "$OSNAME";
      keyword[372] = "$OUTPUT_AUTO_FLUSH";
      keyword[373] = "$OUTPUT_FIELD_SEPARATOR";
      keyword[374] = "$OUTPUT_RECORD_SEPARATOR";
      keyword[375] = "$PERL_VERSION";
      keyword[376] = "$PERLDB";
      keyword[377] = "$PID";
      keyword[378] = "$POSMATCH";
      keyword[379] = "$PREMATCH";
      keyword[380] = "$PROCESS_ID";
      keyword[381] = "$PROGRAM_NAME";
      keyword[382] = "$REAL_GROUP_ID";
      keyword[383] = "$REAL_USER_ID";
      keyword[384] = "$RS";
      keyword[385] = "$SUBSCRIPT_SEPARATOR";
      keyword[386] = "$SUBSEP";
      keyword[387] = "$SYSTEM_FD_MAX";
      keyword[388] = "$UID";
      keyword[389] = "$WARNING";
      keyword[390] = "$|";
      keyword[391] = "$~";
      keyword[392] = "%!";
      keyword[393] = "%^H";
      keyword[394] = "%ENV";
      keyword[395] = "%INC";
      keyword[396] = "%OVERLOAD";
      keyword[397] = "%SIG";
      keyword[398] = "@+";
      keyword[399] = "@-";
      keyword[400] = "@_";
      keyword[401] = "@ARGV";
      keyword[402] = "@INC";
      keyword[403] = "@LAST_MATCH_START";
      //PERL file handles
      keyword[405] = "ARGV";
      keyword[404] = "ARGVOUT";
      keyword[406] = "STDERR";
      keyword[407] = "STDIN";
      keyword[408] = "STDOUT";
      total_keywords = 409;
      break;
    case(NO_MODE):
      break;
  }//end switch
  old_window_color = BG_COLOR[COLOR_WINDOW];
}