/* -*- mode:c -*-
 *
 * Copyright 2021 The Chromium OS Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

/* GSC Signals */
GPIO_INT(EC_WP_L,		PIN(5, 0), GPIO_INT_BOTH,			switch_interrupt)	/* Write Protect Enabled */
GPIO(CCD_MODE_ODL,		PIN(C, 6), GPIO_ODR_HIGH)							/* Case Closed Debug Mode */
GPIO(EC_GSC_PACKET_MODE,	PIN(B, 1), GPIO_OUT_LOW)						/* GSC Packet Mode */
GPIO(GSC_EC_RECOVERY_BTN_ODL, 	PIN(2, 7), GPIO_INT_BOTH)
ALTERNATE(			PIN_MASK(6, BIT(4) | BIT(5)), 0,		MODULE_UART, 0) 	/* UART_EC_TX_GSC_DBG_RX_R, UART_GSC_DBG_TX_EC_RX_R */

/* Power Signals */
GPIO_INT(MECH_PWR_BTN_ODL,	PIN(D, 2), GPIO_INT_BOTH | GPIO_HIB_WAKE_LOW, 	power_button_interrupt)	/* Mechanical Power Button */
GPIO_INT(EC_I2C_EXT_INT_ODL,	PIN(2, 4), GPIO_INT_BOTH,			ext_charger_interrupt)
GPIO_INT(EC_PWR_BTN_ODL,	PIN(0, 1), GPIO_INT_BOTH, 			power_button_interrupt) /* Power Button */
GPIO_INT(SLP_S3_L,		PIN(6, 1), GPIO_INT_BOTH,			baseboard_en_pwr_s0)	/* Sleep S3 */
GPIO_INT(SLP_S5_L,		PIN(7, 2), GPIO_INT_BOTH,			power_signal_interrupt) /* Sleep S5 */
GPIO_INT(SLP_S3_S0I3_L,		PIN(7, 4), GPIO_INT_BOTH,			power_signal_interrupt) /* Sleep S0ix */
GPIO_INT(PG_PWR_S5,		PIN(C, 0), GPIO_INT_BOTH,			baseboard_en_pwr_s0)	/* S5 Power OK */
GPIO_INT(PG_PCORE_S0_R_OD,	PIN(B, 6), GPIO_INT_BOTH, 			power_signal_interrupt) /* S0 Power OK */
GPIO_INT(EC_PCORE_INT_ODL,	PIN(F, 0), GPIO_INT_BOTH | GPIO_PULL_UP,	power_signal_interrupt)	/* Power Core Interrupt */
GPIO_INT(PG_GROUPC_S0_OD,	PIN(A, 3), GPIO_INT_BOTH, 			baseboard_en_pwr_pcore_s0)	/* Power Group C S0 */
GPIO_INT(PG_DDR4_S3_OD,		PIN(9, 5), GPIO_INT_BOTH, 			baseboard_en_pwr_pcore_s0)	/* Power Group LPDDR4 S3 */
GPIO_INT(BJ_ADP_PRESENT_L,	PIN(3, 0), GPIO_INT_BOTH | GPIO_PULL_UP,	baseboard_bj_connect_interrupt)	/* Barrel Jack Adapter Present */
GPIO(EC_RECOVERY_BTN_ODL,	PIN(3, 1), GPIO_INT_BOTH)
GPIO(EN_PWR_S5,			PIN(B, 7), GPIO_OUT_LOW)						/* Enable S5 Power */
GPIO(EN_PWR_S0_R,		PIN(F, 1), GPIO_OUT_LOW)
GPIO(EN_PWR_PCORE_S0_R,		PIN(E, 1), GPIO_OUT_LOW)
GPIO(EN_PPVAR_BJ_ADP_L,		PIN(2, 1), GPIO_OUT_LOW)						/* Enable Barrel Jack Adapter Power */
GPIO(EN_USM_ODL,		PIN(1, 2), GPIO_ODR_HIGH)						/* Enable ultrasonic mode */
ALTERNATE(/*MECH_PWR_BTN_ODL*/	PIN_MASK(D, BIT(2)), 0,				MODULE_PMU, 0)		/* PSL - Mechanical Power Button */

/* SOC Signals */
UNIMPLEMENTED(ENTERING_RW) 										/* GPIO_ENTERING_RW */
GPIO(EC_SYS_RST_L,		PIN(7, 6), GPIO_ODR_HIGH)						/* Cold Reset SOC */
GPIO(EC_SOC_RSMRST_L,		PIN(C, 5), GPIO_OUT_LOW)						/* Resume Reset SOC */
GPIO(EC_CLR_CMOS,		PIN(A, 1), GPIO_OUT_LOW)						/* Clear SOC CMOS */
GPIO(EC_MEM_EVENT,		PIN(A, 5), GPIO_OUT_LOW)						/* Memory Thermal Event to SOC*/
GPIO(EC_SOC_PWR_BTN_L,		PIN(6, 3), GPIO_OUT_HIGH)						/* Power Button to SOC */
GPIO(EC_SOC_PWR_GOOD,		PIN(1, 3), GPIO_OUT_LOW)						/* Power Good to SOC */
GPIO(EC_SOC_WAKE_L,		PIN(0, 3), GPIO_OUT_HIGH)						/* Wake SOC */
GPIO(EC_SOC_INT_L,		PIN(8, 3), GPIO_OUT_HIGH)						/* Matrix Keyboard Protocol Event to SOC */
GPIO(PROCHOT_ODL,		PIN(D, 5), GPIO_ODR_HIGH)						/* Force SOC into HTC-active state */
GPIO(SOC_ALERT_EC_L,		PIN(E, 2), GPIO_INPUT)							/* Sideband-Temperature Iterrupt */
GPIO(SOC_THERMTRIP_ODL, 	PIN(E, 5), GPIO_INPUT)							/* Temperature Trip Sensor */

/* USB Signals */
GPIO_INT(USB_C0_TCPC_INT_ODL,	PIN(E, 0), GPIO_INT_FALLING,			tcpc_alert_event)
GPIO_INT(USB_C1_TCPC_INT_ODL,	PIN(C, 7), GPIO_INT_FALLING,			tcpc_alert_event)
GPIO_INT(USB_C0_PPC_INT_ODL,	PIN(7, 5), GPIO_INT_FALLING,			ppc_interrupt)
GPIO_INT(USB_C1_PPC_INT_ODL,	PIN(D, 4), GPIO_INT_FALLING,			ppc_interrupt)
GPIO_INT(USB_C0_BC12_INT_ODL,	PIN(A, 4), GPIO_INT_FALLING | GPIO_PULL_UP,	bc12_interrupt)
GPIO_INT(USB_C1_BC12_INT_ODL, 	PIN(9, 6), GPIO_INT_FALLING | GPIO_PULL_UP,	bc12_interrupt)
GPIO(USB_FAULT_ODL,		PIN(1, 4), GPIO_OUT_HIGH)						/* C0/C1 Fault to SOC */
GPIO(USB_C0_TCPC_RST_L,		PIN(1, 5), GPIO_OUT_HIGH)						/* C0 TCPC Reset */
GPIO(USB_C1_TCPC_RST_L,		PIN(1, 6), GPIO_OUT_HIGH)						/* C1 TCPC Reset */
GPIO(USB_C0_HPD,		PIN(F, 5), GPIO_OUT_LOW)						/* C0 DP Hotplug Detect */
GPIO(USB_C1_HPD,		PIN(F, 4), GPIO_OUT_LOW)						/* C1 DP Hotplug Detect */
GPIO_INT(USB_A4_FAULT_R_ODL,	PIN(1, 1), GPIO_INT_BOTH,			baseboard_usb_fault_alert)
GPIO_INT(USB_A3_FAULT_R_ODL,	PIN(1, 0), GPIO_INT_BOTH,			baseboard_usb_fault_alert)
GPIO_INT(USB_A2_FAULT_R_ODL,	PIN(0, 7), GPIO_INT_BOTH,			baseboard_usb_fault_alert)
GPIO_INT(USB_A1_FAULT_R_ODL,	PIN(0, 6), GPIO_INT_BOTH,			baseboard_usb_fault_alert)
GPIO_INT(USB_A0_FAULT_R_ODL,	PIN(0, 5), GPIO_INT_BOTH,			baseboard_usb_fault_alert)

/* Sensor Signals */
ALTERNATE(/*TEMP_SOC|MEM*/	PIN_MASK(4, BIT(3) | BIT(5)), 0, 		MODULE_ADC, 0)		/* SOC and Memory Temperature */
ALTERNATE(			PIN_MASK(4, BIT(4)), 0,		 		MODULE_ADC, 0)		/* ANALOG_PPVAR_PWR_IN_IMON */
ALTERNATE(			PIN_MASK(4, BIT(1) | BIT(2)), 0,		MODULE_ADC, 0)		/* EC_ADC_CORE_IMON1, EC_ADC_SOC_IMON2 */
ALTERNATE(			PIN_MASK(3, BIT(7)), 0,				MODULE_ADC, 0)		/* SNS_PPVAR_PWR_IN */
ALTERNATE(			PIN_MASK(3, BIT(4)), 0,				MODULE_ADC, 0)		/* TEMP_AMBIENT_VR */

/* LED Signals */
GPIO(EC_DISABLE_DISP_BL,	PIN(A, 6), GPIO_OUT_HIGH)						/* Disable Display Backlight */
ALTERNATE(			PIN_MASK(C, BIT(4)), 0,				MODULE_PWM, 0)		/* EC_PWM_LED1_L */
ALTERNATE(			PIN_MASK(8, BIT(0)), 0,				MODULE_PWM, 0)		/* EC_PWM_LED2_L */

/* Fan Signals */
ALTERNATE(			PIN_MASK(C, BIT(3)), 0, 			MODULE_PWM, 0)		/* EC_FAN_PWM - Fan PWM */
ALTERNATE(			PIN_MASK(4, BIT(0)), 0, 			MODULE_PWM, 0)		/* EC_FAN_SPEED - Fan Speed */

/* I2C Signals -- i2c pins need to be exposed as GPIO for bit banging, even though set to alternate mode below */
GPIO(EC_I2C_USB_HUB_SCL,	PIN(9, 2), GPIO_INPUT)
GPIO(EC_I2C_USB_HUB_SDA,	PIN(9, 1), GPIO_INPUT)
GPIO(EC_I2C_USB_C0_SCL,		PIN(B, 5), GPIO_INPUT)
GPIO(EC_I2C_USB_C0_SDA,		PIN(B, 4), GPIO_INPUT)
GPIO(EC_I2C_USB_C1_SCL,		PIN(9, 0), GPIO_INPUT)
GPIO(EC_I2C_USB_C1_SDA,		PIN(8, 7), GPIO_INPUT)
GPIO(EC_I2C_USBC_MUX_SCL,	PIN(D, 1), GPIO_INPUT)
GPIO(EC_I2C_USBC_MUX_SDA,	PIN(D, 0), GPIO_INPUT)
GPIO(EC_I2C_POWER_SCL,		PIN(F, 3), GPIO_INPUT)
GPIO(EC_I2C_POWER_SDA,		PIN(F, 2), GPIO_INPUT)
GPIO(EC_I2C_CBI_SCL,		PIN(3, 3), GPIO_INPUT)
GPIO(EC_I2C_CBI_SDA,		PIN(3, 6), GPIO_INPUT)
GPIO(EC_I2C_SENSOR_SCL,		PIN(E, 4), GPIO_INPUT)
GPIO(EC_I2C_SENSOR_SDA,		PIN(E, 3), GPIO_INPUT)
GPIO(EC_I2C_SOC_SIC,		PIN(B, 3), GPIO_INPUT)
GPIO(EC_I2C_SOC_SID,		PIN(B, 2), GPIO_INPUT)

ALTERNATE(			PIN_MASK(B, BIT(4) | BIT(5)), 0, 		MODULE_I2C, 0)		/* I2C0 */
ALTERNATE(			PIN_MASK(9, BIT(0) | BIT(1) | BIT(2)), 0, 	MODULE_I2C, 0)		/* I2C1 SCL / I2C2 */
ALTERNATE(			PIN_MASK(8, BIT(7)), 0, MODULE_I2C, 0)					/* I2C1 SDA */
ALTERNATE(			PIN_MASK(D, BIT(0) | BIT(1)), 0, 		MODULE_I2C, 0)		/* I2C3 */
ALTERNATE(			PIN_MASK(F, BIT(2) | BIT(3)), 0, 		MODULE_I2C, 0)		/* I2C4 */
ALTERNATE(			PIN_MASK(3, BIT(3) | BIT(6)), 0, 		MODULE_I2C, 0)		/* I2C5 */
ALTERNATE(			PIN_MASK(E, BIT(3) | BIT(4)), 0, 		MODULE_I2C, 0)		/* I2C6 */
ALTERNATE(			PIN_MASK(B, BIT(2) | BIT(3)), 0, 		MODULE_I2C, 0)		/* I2C7 */

/* HDMI/DP Signals */
GPIO(HDMI_1_CEC, 		PIN(1, 7), GPIO_OUT_LOW)
GPIO_INT(FAULT_HDMI_1_L,	PIN(2, 5), GPIO_INT_FALLING, 			hdmi_fault_interrupt)
GPIO_INT(FAULT_DP_L,		PIN(2, 6), GPIO_INT_FALLING,			dp_fault_interrupt)

/* b/186135022: Pull eSPI RST# high to disable */
GPIO(EC_ESPI_RST_L,            PIN(5, 4), GPIO_PULL_UP)

#if 0
/*
 * SOC eSPI Bus
 * These signals do not need to be explicitly configured.
 * Leaving here so all signals are documented.
 */
GPIO(ESPI_SOC_CLK,		PIN(5, 5), GPIO_DEFAULT)
GPIO(ESPI_SOC_CS_EC_L,		PIN(5, 3), GPIO_DEFAULT)
GPIO(ESPI_SOC_D0_EC,		PIN(4, 6), GPIO_DEFAULT)
GPIO(ESPI_SOC_D1_EC,		PIN(4, 7), GPIO_DEFAULT)
GPIO(ESPI_SOC_D2_EC,		PIN(5, 1), GPIO_DEFAULT)
GPIO(ESPI_SOC_D3_EC,		PIN(5, 2), GPIO_DEFAULT)
GPIO(ESPI_EC_ALERT_SOC_L,	PIN(5, 7), GPIO_DEFAULT)
#endif

/* TCPC C0 */
IOEX(EN_PP5000_USB_A0_VBUS,	EXPIN(USBC_PORT_C0, 1, 5), GPIO_OUT_LOW)
IOEX(USB_A0_LIMIT_SDP,		EXPIN(USBC_PORT_C0, 1, 6), GPIO_OUT_LOW)
IOEX(USB_C0_PPC_EN_L,		EXPIN(USBC_PORT_C0, 1, 0), GPIO_OUT_LOW)
IOEX(USB_C0_PPC_ILIM_3A_EN,	EXPIN(USBC_PORT_C0, 1, 1), GPIO_OUT_LOW)
IOEX_INT(USB_C0_SBU_FAULT_ODL,	EXPIN(USBC_PORT_C0, 1, 2), GPIO_INT_FALLING,	sbu_fault_interrupt)
IOEX(USB_C0_SBU_FLIP,		EXPIN(USBC_PORT_C0, 1, 7), GPIO_OUT_LOW)

/* TCPC C1 */
IOEX(USB_A1_LIMIT_SDP,		EXPIN(USBC_PORT_C1, 1, 6), GPIO_OUT_LOW)
IOEX(USB_C1_IN_HPD,		EXPIN(USBC_PORT_C1, 0, 3), GPIO_OUT_LOW)
IOEX(USB_C1_PPC_EN_L,		EXPIN(USBC_PORT_C1, 1, 0), GPIO_OUT_LOW)
IOEX(USB_C1_PPC_ILIM_3A_EN,	EXPIN(USBC_PORT_C1, 1, 1), GPIO_OUT_LOW)
IOEX_INT(USB_C1_SBU_FAULT_ODL,	EXPIN(USBC_PORT_C1, 1, 2), GPIO_INT_FALLING,	sbu_fault_interrupt)
IOEX(USB_C1_SBU_FLIP,		EXPIN(USBC_PORT_C1, 1, 7), GPIO_OUT_LOW)

/* Test Points */
GPIO(EC_ADC_6,			PIN(3, 4), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_FLPRG2,			PIN(8, 6), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_GPIO04,			PIN(0, 4), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_GPIO20,			PIN(2, 0), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_GPIO22,			PIN(2, 2), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_GPIO23,			PIN(2, 3), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_GPIO56,			PIN(5, 6), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_GPIO73,			PIN(7, 3), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_GPIO81,			PIN(8, 1), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_GPIO82,			PIN(8, 2), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_GPIO94,			PIN(9, 4), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_GPIO97,			PIN(9, 7), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_GPIOA0,			PIN(A, 0), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_GPIOA2,			PIN(A, 2), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_GPIOB0,			PIN(B, 0), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_GPIOC1,			PIN(C, 1), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_GPIOC2,			PIN(C, 2), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_PS2_CLK,		PIN(6, 7), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_PS2_DAT,		PIN(7, 0), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_PS2_RST,		PIN(6, 2), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_PSL_GPO,		PIN(D, 7), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_PSL_IN2,		PIN(0, 0), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_PSL_IN4,		PIN(0, 2), GPIO_INPUT | GPIO_PULL_UP)
GPIO(EC_PWM7,			PIN(6, 0), GPIO_INPUT | GPIO_PULL_UP)
GPIO(VOLDN_BTN_ODL,		PIN(A, 7), GPIO_INPUT | GPIO_PULL_UP)
GPIO(VOLUP_BTN_ODL,		PIN(9, 3), GPIO_INPUT | GPIO_PULL_UP)
