% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcacontourjitter.R
\name{mcacontourjit}
\alias{mcacontourjit}
\title{Contour plots and MCA function for classification modeling}
\usage{
mcacontourjit(dataf=dataf,jit=0.1,alpha1=0.8,alpha2=0.8,alpha3=0.7,title="",...)
}
\arguments{
\item{dataf}{data frame.}

\item{jit}{jit distance. Default 0.1.}

\item{alpha1}{alpha transparency for majoritary class}

\item{alpha2}{alpha transparency for minoritary class}

\item{alpha3}{alpha transparency for fit probability plots}

\item{title}{plot main title}

\item{...}{options to be passed from mcacontour}
}
\value{
A list with the following objects:\describe{
\item{graph1}{plot of points on MCA  two dimensions}
\item{graph2}{plot of points and variables}
\item{graph3}{plot of points and contour curves}
\item{graph4}{plot of points, contour curves and variables}
\item{graph5}{plot of points colored by fitted probability}
\item{graph6}{plot of points colored by abs difference}
}
}
\description{
This function is similar to mcacontour but points are jittered in every plot
}
\examples{
data(breastwisconsin1)
dataf<-breastwisconsin1
listconti=c( "clump_thickness","uniformity_of_cell_shape","mitosis")
listclass=c("")
vardep="classes"
result<-mcacontourjit(dataf=dataf,listconti=listconti,listclass=listclass,vardep=vardep,jit=0.1)
}
\keyword{MCA}
\keyword{classification}
\keyword{contour_curves}
