% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r.R
\name{use_test_helper}
\alias{use_test_helper}
\title{Create or edit a test helper file}
\usage{
use_test_helper(name = NULL, open = rlang::is_interactive())
}
\arguments{
\item{name}{Can be used to specify the optional "SLUG" in
\code{tests/testthat/helper-SLUG.R}.}

\item{open}{Whether to open the file for interactive editing.}
}
\description{
This function creates (or opens) a test helper file, typically
\code{tests/testthat/helper.R}. Test helper files are executed at the
beginning of every automated test run and are also executed by
\code{\link[pkgload:load_all]{load_all()}}. A helper file is a great place to
define test helper functions for use throughout your test suite, such as
a custom expectation.
}
\examples{
\dontrun{
use_test_helper()
use_test_helper("mocks")
}
}
\seealso{
\itemize{
\item \code{\link[=use_test]{use_test()}} to create a test file.
\item The testthat vignette on special files
\code{vignette("special-files", package = "testthat")}.
}
}
