% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prodmnt.R
\name{prodmnt}
\alias{prodmnt}
\title{Compute the product moment.}
\usage{
prodmnt(Obj, kappa)
}
\arguments{
\item{Obj}{mtrunmnt object created by the \code{\link{mtrunmnt}}.}

\item{kappa}{Vector of orders of length equal to mu.}
}
\value{
a numeric value.
}
\description{
It computes the kappa-th order product moment for a truncated multivariate 
    normal distribution.
}
\details{
\code{prodmnt} is a S3 generic function of the class 
    \code{\link{mtrunmnt}}. Using the multivariate Gaussian quadrature, it 
    computes the product moment 
    \eqn{E(\prod_{i=1}^n Y_i^{k_i}) | a_i < Y_i < b_i, i = 1, \ldots, n)}, 
    where \eqn{Y \sim N(\mu, ZDZ' + E)}.
}
\examples{
###  A simple example ####

set.seed(123)
sigma2e <- 1
sigma2a <- 2
n <- 5
mu <- seq(-1,1, length.out = n)
y <- mu + rnorm(1, sd = sqrt(sigma2a)) + rnorm(n, sd = sqrt(sigma2e))
a  <- rep(-Inf, n)
b  <- rep(Inf, n)
a[y >= 0] <- 0
b[y <  0] <- 0
obj <- mtrunmnt(mu, lower = a, upper = b, Sigmae = sigma2e, D = sigma2a) 
prodmnt(obj, c(2,2,0,0,0))

}
\seealso{
\code{\link{mtrunmnt}}, \code{\link[MomTrunc]{momentsTMD}}.
}
