% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{adsl}
\alias{adsl}
\title{Baseline subject-level data}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 412 rows and 12 columns.
}
\usage{
adsl
}
\description{
This data set contains baseline subject-level data. Of note,
\code{PDDT} can be derived from the \code{ADT} variable of the \code{ADTTE} data set
by selecting \code{PARAMCD == "INPFS" & CNSR == 0 &  EVNTDESC == "PROGRESSIVE DISEASE"}. Additionally,
\code{OSDT} and \code{DIED} can be derived from the \code{ADT} and \code{CNSR} variables of
the \code{ADTTE} data set by selecting \code{PARAMCD == "OS"}.
}
\details{
\describe{
\item{\code{SUBJID}}{subject ID}
\item{\code{SEX}}{sex: "M" or "F"}
\item{\code{STRAT1V}}{stratification factor 1: ECOG PS}
\item{\code{STRAT2V}}{stratification factor 2: inv. chosen chemotherapy}
\item{\code{RANDDT}}{randomization date}
\item{\code{TRT01P}}{planned treatment: Active or Placebo}
\item{\code{TRTSDT}}{treatment start date}
\item{\code{PDDT}}{date of disease progression}
\item{\code{XODT}}{date of treatment crossover}
\item{\code{OSDT}}{date of death or censoring}
\item{\code{DIED}}{whether the patient died}
\item{\code{DCUTDT}}{date of data cut}
}
}
\keyword{datasets}
