% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_logsumexp}
\alias{torch_logsumexp}
\title{Logsumexp}
\usage{
torch_logsumexp(self, dim, keepdim = FALSE)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{dim}{(int or tuple of ints) the dimension or dimensions to reduce.}

\item{keepdim}{(bool) whether the output tensor has \code{dim} retained or not.}
}
\description{
Logsumexp
}
\section{logsumexp(input, dim, keepdim=False, out=NULL) }{


Returns the log of summed exponentials of each row of the \code{input}
tensor in the given dimension \code{dim}. The computation is numerically
stabilized.

For summation index \eqn{j} given by \code{dim} and other indices \eqn{i}, the result is

\deqn{
        \mbox{logsumexp}(x)_{i} = \log \sum_j \exp(x_{ij})
}

If \code{keepdim} is \code{TRUE}, the output tensor is of the same size
as \code{input} except in the dimension(s) \code{dim} where it is of size 1.
Otherwise, \code{dim} is squeezed (see \code{\link{torch_squeeze}}), resulting in the
output tensor having 1 (or \code{len(dim)}) fewer dimension(s).
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(3, 3))
torch_logsumexp(a, 1)
}
}
