% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VERBS-transmute.R
\name{transmute-table.express}
\alias{transmute-table.express}
\alias{transmute.ExprBuilder}
\alias{transmute.EagerExprBuilder}
\alias{transmute.data.table}
\title{Compute new columns}
\usage{
\method{transmute}{ExprBuilder}(
  .data,
  ...,
  .enlist = TRUE,
  .sequential = FALSE,
  .parse = getOption("table.express.parse", FALSE),
  .chain = getOption("table.express.chain", TRUE)
)

\method{transmute}{EagerExprBuilder}(.data, ..., .parent_env = rlang::caller_env())

\method{transmute}{data.table}(.data, ...)
}
\arguments{
\item{.data}{An instance of \link{ExprBuilder}.}

\item{...}{Clauses for transmuting columns. For \code{j} inside the \code{data.table}'s frame.}

\item{.enlist}{See details.}

\item{.sequential}{If \code{TRUE}, each expression in \code{...} is assigned to a nested body within curly braces to allow them to use variables created by previous expressions. The default is \code{FALSE} because enabling this may turn off some \link[data.table:datatable-optimize]{data.table optimizations}.}

\item{.parse}{Logical. Whether to apply \code{\link[rlang:parse_expr]{rlang::parse_expr()}} to obtain the expressions.}

\item{.chain}{Logical. Should a new frame be automatically chained to the expression if the
clause being set already exists?}

\item{.parent_env}{See \code{\link[=end_expr]{end_expr()}}}
}
\description{
Compute and keep only new columns.
}
\details{
Everything in \code{...} is wrapped in a call to \code{list} by default. If only one expression is given,
you can set \code{.enlist} to \code{FALSE} to skip the call to \code{list}.

To see more examples, check the
\href{https://asardaes.github.io/table.express/articles/table.express.html}{vignette}, or the
\link{table.express-package} entry.
}
\examples{

data("mtcars")

data.table::as.data.table(mtcars) \%>\%
    transmute(ans = mpg * 2)

}
