% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey-core.R
\name{survey_log}
\alias{survey_log}
\title{Return the log contents of a strata log file as a tibble}
\usage{
survey_log(log_path)
}
\arguments{
\item{log_path}{Path to the log file}
}
\value{
A tibble of the contents of the log file
}
\description{
If users decide to pipe the results of \code{\link[=main]{main()}} or any of the
logging-related functions into a log file, the contents of log file
can be parsed and stored in a tibble using \code{survey_log()}.  \emph{Only}
the messages from the \verb{log_*()} functions will be parsed, all other output
from the code will be ignored.
}
\examples{
tmp <- fs::dir_create(fs::file_temp())
log <- fs::file_create(fs::path(tmp, "main.log"))
fake_log_message <- log_message("example message")
cat(fake_log_message, file = log)
survey_log(log)
fs::dir_delete(tmp)
}
\seealso{
Other survey: 
\code{\link{survey_strata}()},
\code{\link{survey_tomls}()}

Other log: 
\code{\link{log_error}()},
\code{\link{log_message}()},
\code{\link{log_total_time}()}
}
\concept{log}
\concept{survey}
