% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventTracking.R
\name{trackEventsPerTrial}
\alias{trackEventsPerTrial}
\title{Event tracking in an oncology trial.}
\usage{
trackEventsPerTrial(data, timeP, byArm = FALSE)
}
\arguments{
\item{data}{(\code{data.frame})\cr illness-death data set in \verb{1rowPatient} format.}

\item{timeP}{(\code{numeric})\cr  vector of study time-points.}

\item{byArm}{(\code{logical})\cr  if \code{TRUE} time-point per treatment arm, else joint evaluation of treatment arms.}
}
\value{
This function returns a data frame including number of PFS events, number of OS events,
number of recruited patients, number of censored patients and number of ongoing patients at \code{timeP}.
}
\description{
Event tracking in an oncology trial.
}
\examples{
transition1 <- weibull_transition(h01 = 1.2, h02 = 1.5, h12 = 1.6, p01 = 0.8, p02 = 0.9, p12 = 1)
transition2 <- weibull_transition(h01 = 1, h02 = 1.3, h12 = 1.7, p01 = 1.1, p02 = 0.9, p12 = 1.1)

simStudy <- getOneClinicalTrial(
  nPat = c(20, 20), transitionByArm = list(transition1, transition2),
  dropout = list(rate = 0.3, time = 10),
  accrual = list(param = "time", value = 0)
)
simStudyWide <- getDatasetWideFormat(simStudy)
trackEventsPerTrial(data = simStudyWide, timeP = 1.5, byArm = FALSE)
}
