% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corPFSOS.R
\name{expvalPFSInteg}
\alias{expvalPFSInteg}
\title{Helper Function for Computing E(PFS^2)}
\usage{
expvalPFSInteg(x, transition)
}
\arguments{
\item{x}{(\code{numeric})\cr variable of integration.}

\item{transition}{(\code{TransitionParameters})\cr
see \code{\link[=exponential_transition]{exponential_transition()}}, \code{\link[=weibull_transition]{weibull_transition()}} or \code{\link[=piecewise_exponential]{piecewise_exponential()}} for details.}
}
\value{
Numeric results of the integrand used to calculate E(PFS^2).
}
\description{
Helper Function for Computing E(PFS^2)
}
\examples{
transition <- exponential_transition(h01 = 1.2, h02 = 1.5, h12 = 1.6)
expvalPFSInteg(0.4, transition)
}
