% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle_imp.R
\name{mle_imp}
\alias{mle_imp}
\title{Imputation-Based MLE for Censored Data}
\usage{
mle_imp(
  left,
  right,
  dist = "weibull",
  impute = c("midpoint", "random", "median", "harmonic_median", "geometric_median",
    "random_survival")
)
}
\arguments{
\item{left}{Left bounds of censoring intervals}

\item{right}{Right bounds of censoring intervals}

\item{dist}{Distribution name (e.g. "weibull", "loglogistic", "EMV")}

\item{impute}{Imputation method: "midpoint", "random", "median",
"harmonic_median", "geometric_median", "random_survival"}
}
\value{
A list containing estimates, standard errors, and log-likelihood
}
\description{
Estimates distribution parameters using imputed event times.
}
\examples{
# Simulate interval-censored data from a Weibull distribution
set.seed(123)
dat <- simIC(n = 100, dist = "weibull", shape = 1.5, scale = 5, width = 2,
             study_start = 1, study_end = 8, uncensored_tol = 0.1)

# Fit model using harmonic median imputation
fit <- mle_imp(left = dat$left, right = dat$right, dist = "weibull", impute = "harmonic_median")

# Inspect results
print(fit$estimates)
print(fit$logLik)
print(fit$converged)
}
