% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfcr_baseline.R
\name{.check_external_consistency}
\alias{.check_external_consistency}
\title{Check shocks for length consistency and warn about risks of using exogenous series}
\usage{
.check_external_consistency(external, periods = periods)
}
\arguments{
\item{external}{An .eq_as_tb() tibble with external variables.}

\item{periods}{The periods of the baseline model.}
}
\description{
This function makes two checks:
}
\details{
\enumerate{
\item The exogenous variable is a constant that is repeated over time;
\item The exogenous variable has exactly the same length as the shock.
}

Furthermore, it throws a warning that using exogenous series in a shock can lead to unexpected
behavior if the length of the shock is not the same as the periods in the scenario.
}
\author{
João Macalós
}
\keyword{internal}
