% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derived_variables.R
\name{calcTurnVelocity}
\alias{calcTurnVelocity}
\title{Calculate turn velocity}
\usage{
calcTurnVelocity(list)
}
\arguments{
\item{list}{A list of data frames, where each data frame has a column for
turn angle.}
}
\value{
A list of data frames that each contain a column for turn velocity.
}
\description{
Calculate the turning velocity in degrees per second between two moves
}
\details{
For this function to work, the data must have previously been processed with
the \code{calcTurnAngle} function.

This function calculates the turning velocity between two consecutive moves.
The units for turn velocity will be degrees per second.

If the data will be aggregated, it is recommended to aggregate the data before
running this function.
}
\examples{
# Provide data previously processed by the calcTurnAngle function

 servosphere <- list(data.frame(id = rep(1, 200),
                                stimulus = rep(c(0, 1), each = 100),
                                dT = sample(8:12, 200, replace = TRUE),
                                dx = runif(200, 0, 5),
                                dy = runif(200, 0, 5),
                                treatment = rep("a", 200),
                                date = rep("2032018", 200)),
                     data.frame(id = rep(2, 200),
                                stimulus = rep(c(0, 1), each = 100),
                                dT = sample(8:12, 200, replace = TRUE),
                                dx = runif(200, 0, 5),
                                dy = runif(200, 0, 5),
                                treatment = rep("b", 200),
                                date = rep("2032018", 200)))
servosphere <- calcXY(servosphere)
servosphere <- calcBearing(servosphere)
servosphere <- calcTurnAngle(servosphere)
servosphere <- calcTurnVelocity(servosphere)
}
