% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derived_variables.R
\name{calcTurnAngle}
\alias{calcTurnAngle}
\title{Calculate turn angle}
\usage{
calcTurnAngle(list)
}
\arguments{
\item{list}{A list of data frames, where each data frame has a column for
bearing.}
}
\value{
A list of data frames that each contain a column for turn angle.
}
\description{
Calculate the turn angle between two successive moves
}
\details{
For this function to work, the data must have previously been processed with
the \code{calcBearing} function.

This function calculates the turn angle between two successive movement
vectors. If the organism has not moved for a period of time but begins moving
again, the function calculates the turn angle between the last movement the
organism made and its current move.

If the data will be aggregated, it is recommended to aggregate the data before
running this function.
}
\examples{
# Provide a data frame that includes a column with bearing data

 servosphere <- list(data.frame(id = rep(1, 200),
                                stimulus = rep(c(0, 1), each = 100),
                                dT = sample(8:12, 200, replace = TRUE),
                                dx = runif(200, 0, 5),
                                dy = runif(200, 0, 5),
                                treatment = rep("a", 200),
                                date = rep("2032018", 200)),
                     data.frame(id = rep(2, 200),
                                stimulus = rep(c(0, 1), each = 100),
                                dT = sample(8:12, 200, replace = TRUE),
                                dx = runif(200, 0, 5),
                                dy = runif(200, 0, 5),
                                treatment = rep("b", 200),
                                date = rep("2032018", 200)))
servosphere <- calcXY(servosphere)
servosphere <- calcBearing(servosphere)
servosphere <- calcTurnAngle(servosphere)
}
