% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saekernel.R
\name{saekernel}
\alias{saekernel}
\title{Small Area Estimation Non-Parametric Based Nadaraya-Watson Kernel}
\usage{
saekernel(X, Y, vardir, bandwidth)
}
\arguments{
\item{X}{Auxiliary Variable of X}

\item{Y}{Direct Estimation of Y}

\item{vardir}{Sampling variances of Direct Estimators}

\item{bandwidth}{The kernel Bandwidth Smoothing Parameter}
}
\value{
This function returns a list with following objects:
\item{est}{a value of Small Area Estimation Non-Parametric Based Nadaraya-Watson Kernel}
\item{refvar}{Estimated Random Effect Variance}
}
\description{
This Function Gives Small Area Estimation Non-Parametric Based Nadaraya-Watson Kernel
}
\examples{
##load dataset
data(Data_saekernel)

saekernel(X = Data_saekernel$x, Y = Data_saekernel$y,
vardir = Data_saekernel$Vardir, bandwidth = 0.04)

}
