% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_phylopic_tree.R
\name{add_phylopic_tree}
\alias{add_phylopic_tree}
\title{Add PhyloPics to a phylogenetic tree plotted with base R}
\usage{
add_phylopic_tree(
  tree,
  tip = names(img) \%||\% names(uuid) \%||\% names(name) \%||\% name,
  img = NULL,
  name = if (is.null(img) && is.null(uuid)) tip else NULL,
  uuid = NULL,
  align = "tip",
  width,
  padding = NULL,
  relWidth = 0.06,
  relPadding = if (align == "tip") 1/200 else -1/200,
  hjust = if (align == "tip") 0 else 1,
  ...
)
}
\arguments{
\item{tree}{\code{phylo}. The phylogenetic tree object on which to add the
silhouette.}

\item{tip}{\code{character}. The tip labels against which to add the silhouettes. If not
specified, the names of the \code{img}, \code{uuid} or \code{name} vector are used.}

\item{img}{A \link[grImport2:Picture-class]{Picture} or png array object, e.g.,
from using \code{\link[=get_phylopic]{get_phylopic()}}.}

\item{name}{\code{character}. A taxonomic name to be passed to \code{\link[=get_uuid]{get_uuid()}}.}

\item{uuid}{\code{character}. A valid uuid for a PhyloPic silhouette (such as
that returned by \code{\link[=get_uuid]{get_uuid()}} or \code{\link[=pick_phylopic]{pick_phylopic()}}).}

\item{align}{\code{character}. Should each silhouette be aligned to its
respective tip (\code{"tip"}, the default) or to the right-hand side of the
plotting area (\code{"plot"})? If \code{"tip"} is specified, the silhouette is placed
at the x coordinate of the respective tip, plus any horizontal padding
specified by \code{padding} or \code{relPadding}. If \code{"plot"} is specified, the
silhouette is placed at the right-hand side of the plotting area,
determined by \code{par("usr")}, plus any horizontal padding specified by
\code{padding} or \code{relPadding}.}

\item{width, relWidth}{\code{numeric}. The width of each silhouette, in the plot coordinate
system (\code{width}) or relative to the size of the plotting area (\code{relWidth}).
If "NULL" and \code{height} is specified, the width is determined by the aspect
ratio of the original image. One of height and width must be "NULL".}

\item{padding, relPadding}{\code{numeric}. Horizontal padding for each silhouette from its
respective x value, in the plot coordinate system (\code{padding}) or relative
to the size of the plotting area (\code{relPadding}). Negative values offset to
the left.}

\item{hjust}{\code{numeric}. A numeric vector between 0 and 1 specifying
horizontal justification (left = 0, center = 0.5, right = 1).}

\item{\dots}{Further arguments to pass to \code{\link[=add_phylopic_base]{add_phylopic_base()}}.}
}
\description{
Specify existing images, taxonomic names, or PhyloPic uuids to add PhyloPic
silhouettes alongside the associated leaves of a phylogenetic tree that has
been plotted in the active graphics device using the base R graphics
functions. The current functionality assumes that the tree is not in a
circular configuration and has a "rightwards" direction.
}
\examples{
\dontrun{
# Load the ape library to work with phylogenetic trees
library("ape")

# Read a phylogenetic tree
tree <- ape::read.tree(text = "(cat, (dog, mouse));")

# Set a large right margin to accommodate the silhouettes
par(mar = c(1, 1, 1, 10))

# Plot the tree
plot(tree)

# Add a PhyloPic silhouette of a cat to the tree
add_phylopic_tree(
  tree, # Must be the tree that was plotted
  "cat", # Which leaf should the silhouette be plotted against?
  uuid = "23cd6aa4-9587-4a2e-8e26-de42885004c9", # Silhouette to plot
  relWidth = 0.2,
  fill = "brown"
)
}
}
\seealso{
For trees plotted using \pkg{ggtree}, see \code{\link[=geom_phylopic]{geom_phylopic()}}.
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
