% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-vertintap.R, R/op-cdo-ap2pl.R
\name{vertintap}
\alias{vertintap}
\alias{cdo_ap2pl}
\title{Vertical pressure interpolation}
\usage{
cdo_ap2pl(ifile, plevels = NULL, ofile = NULL)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{plevels}{FLOAT - Comma-separated list of pressure levels in pascal}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operators that don't return filenames return a character vector with the
string output.
}
\description{
Interpolate 3D variables on hybrid sigma height coordinates to pressure levels. The input file must contain the 3D air pressure in pascal. The air pressure is identified by the NetCDF CF standard name air_pressure. Use the alias  ap2plx or the environment variable EXTRAPOLATE to extrapolate missing values. This operator requires all variables on the same horizontal grid.
}
\section{Note}{

This is a specific implementation for NetCDF files from the ICON model, it may not work with data from other sources.
}

