context("test-reproject")

idx <- c(387L, 926L, 1184L, 1348L, 1487L, 1526L, 1529L, 1554L, 1588L,
         1784L, 1828L, 1987L, 2107L, 2181L, 2195L, 2986L, 3257L, 3458L,
         3513L, 3555L, 3845L, 3955L, 4011L, 4083L, 4392L)
cds <- sp::coordinates(etopo)[idx, ]
c0 <-structure(c(77.6666684225318, 77.0000017407933, -111.000002509455,
                 -1.66666670434617, 91.0000020573012, 117.000002645102, 119.000002690317,
                 135.666669733779, 158.333336912887, -71.0000016051471, -41.6666676086544,
                 64.3333347877624, 144.333336596379, -166.333337093748, -157.00000354941,
                 10.3333335669463, -169.000003820702, -35.0000007912697, 1.66666670434617,
                 29.6666673373619, -137.000003097256, -63.6666681060239, -26.3333339286696,
                 21.6666671565003, -132.333336325086, -0.333333320144283, -0.999999960432849,
                 -1.66666660072141, -1.66666660072141, -1.66666660072141, -1.66666660072141,
                 -1.66666660072141, -1.66666660072141, -1.66666660072141, -2.33333324100998,
                 -2.33333324100998, -2.33333324100998, -2.33333324100998, -2.99999988129855,
                 -2.99999988129855, -3.66666652158711, -4.33333316187568, -4.33333316187568,
                 -4.33333316187568, -4.33333316187568, -4.99999980216424, -4.99999980216424,
                 -4.99999980216424, -4.99999980216424, -5.66666644245281), .Dim = c(25L,
                                                                                    2L), .Dimnames = list(NULL, c("x", "y")))
c1 <- structure(c(7998790.05365194, 7939878.81087366, -10507141.6476077,
                  -185467.598143379, 9094569.68191333, 10870056.8417237, 10984402.6860711,
                  11802293.5734535, 12489287.037344, -7402266.0841387, -4533847.23844012,
                  6786497.09635431, 12111840.0113703, -12363576.7885587, -12386185.2865353,
                  1146989.66956327, -11799916.1974422, -3827459.89049144, 185131.453756102,
                  3258605.00692866, -11763660.5631871, -6706810.20861539, -2897305.18162699,
                  2390706.91255989, -11554400.0322274, -47316.0549573657, -141284.422998582,
                  -325285.248539753, -184303.966353487, -262893.481251692, -352600.118046039,
                  -362985.026515513, -488118.706046688, -977688.043166333, -316863.222527861,
                  -276029.676948626, -304747.009038728, -840751.541095702, -2724011.93488214,
                  -1650206.37491736, -407027.453402442, -4654700.50210569, -502262.6152628,
                  -479100.747653934, -495540.391399752, -1498973.12682844, -650327.207174631,
                  -567602.814088227, -562719.638636261, -1540527.63613082), .Dim = c(25L,
                                                                                     2L), .Dimnames = list(NULL, c("x", "y")))
test_that("reprojecting works", {
  expect_equivalent(cds, c0)
  ## note that we drop the third coordinate from proj4
  expect_equivalent(c1, target_coordinates(c0, "+proj=longlat +datum=WGS84", "+proj=laea +datum=WGS84")[,1:2])
})

## doesn't work anymore (PROJ 6.1.0 in reproj)
# test_that("globe conversion works", {
#   expect_equivalent(reproj::reproj(cbind(cds), source = "+proj=longlat +a=6378137.0",
#                                    target = "+proj=geocent +a=6378137.0"), llh2xyz(cbind(cds, 0)))
#
# })
#
