% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{tasmania_ibra_data}
\alias{tasmania_ibra_data}
\title{Thylacine vignette Tasmania IBRA data}
\format{
A data frame with 9 rows and 4 variables:
\describe{
\item{index}{Cross-reference index for each bioregion}
\item{key}{Additional alphabetical cross-reference for each bioregion}
\item{abbr}{Abbreviated name for each bioregion}
\item{name}{Full name for each bioregion}
}
}
\source{
https://doi.org/10.1111/2041-210X.13720
}
\description{
A dataset describing the nine Interim Bioregionalisation of Australia (IBRA)
bioregions for the Tasmanian study region of the Thylacine example vignette.
}
\examples{
data(tasmania_ibra_data)
data(tasmania_ibra_raster)
raster::values(tasmania_ibra_raster)[!is.na(raster::values(tasmania_ibra_raster))] |>
  table() |>
  as.data.frame() |>
  merge(tasmania_ibra_data, by.x = "Var1", by.y = "index")

}
