% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{layer_white_bg}
\alias{layer_white_bg}
\alias{layer_bg}
\alias{layer_reticle}
\alias{layer_dot}
\alias{layer_bars}
\alias{layer_pie}
\alias{layer_boxviolin}
\title{Heatmap layer functions used to draw on the heatmap cells}
\usage{
layer_white_bg(j, i, x, y, w, h, fill)

layer_bg(j, i, x, y, w, h, fill, alpha)

layer_reticle(j, i, x, y, w, h, fill, color)

layer_dot(
  j,
  i,
  x,
  y,
  w,
  h,
  fill,
  data,
  dot_size,
  alpha,
  row_names = NULL,
  col_names = NULL
)

layer_bars(j, i, x, y, w, h, fill, flip, col_fun, data, alpha)

layer_pie(j, i, x, y, w, h, fill, palette, palcolor, data, pie_size)

layer_boxviolin(j, i, x, y, w, h, fill, flip, data, colors, fn)
}
\arguments{
\item{j}{An integer specifying the column index}

\item{i}{An integer specifying the row index}

\item{x}{A numeric vector specifying the x position}

\item{y}{A numeric vector specifying the y position}

\item{w}{A numeric vector specifying the width}

\item{h}{A numeric vector specifying the height}

\item{fill}{A character vector specifying the fill color}

\item{alpha}{A numeric value between 0 and 1 specifying the transparency of the fill color}

\item{color}{A character vector specifying the color of the reticle}

\item{data}{A dataframe used to create the annotation. Different from the data used to
create the heatmap itself, which is aggregated data. This dataframe is the original data,
where each cell could have multiple values.}

\item{dot_size}{A numeric value specifying the size of the dot or a function to calculate the size
from the values in the cell. The function can take 1, 3, or 5 arguments: the first argument is
the values in the cell before aggregation; the 2nd and 3rd arguments are the row and column
indices; the 4th and 5th arguments are the row and column names.}

\item{row_names}{Row names from the heatmap matrix.}

\item{col_names}{Column names from the heatmap matrix.}

\item{col_fun}{A function to calculate the color of the bars}

\item{colors}{A character vector specifying the fill color of the violin plot.
If not provided, the fill color of row/column annotation will be used}
}
\description{
Heatmap layer functions used to draw on the heatmap cells
}
\keyword{internal}
