% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_piece_obj.R
\name{save_piece_obj}
\alias{save_piece_obj}
\title{Save Wavefront OBJ files of board game pieces}
\usage{
save_piece_obj(
  piece_side = "tile_face",
  suit = 1,
  rank = 1,
  cfg = getOption("piecepackr.cfg", pp_cfg()),
  ...,
  x = 0,
  y = 0,
  z = 0,
  angle = 0,
  axis_x = 0,
  axis_y = 0,
  width = NA,
  height = NA,
  depth = NA,
  envir = getOption("piecepackr.envir"),
  filename = tempfile(fileext = "\%03d.obj"),
  scale = 1,
  res = 72
)
}
\arguments{
\item{piece_side}{A string with piece and side separated by a underscore e.g. "coin_face"}

\item{suit}{Number of suit (starting from 1).}

\item{rank}{Number of rank (starting from 1)}

\item{cfg}{Piecepack configuration list or \code{pp_cfg} object,
a list of \code{pp_cfg} objects,
or a character vector referring to names in \code{envir}
or a character vector referring to object names that
can be retrieved by \code{base::dynGet()}.}

\item{...}{Ignored.}

\item{x}{Where to place piece on x axis of viewport}

\item{y}{Where to place piece on y axis of viewport}

\item{z}{z-coordinate of the piece.  Has no effect if \code{op_scale} is \code{0}.}

\item{angle}{Angle (on xy plane) to draw piece at}

\item{axis_x}{First coordinate of the axis unit vector.}

\item{axis_y}{Second coordinate of the axis unit vector.}

\item{width}{Width of piece}

\item{height}{Height of piece}

\item{depth}{Depth (thickness) of piece.  Has no effect if \code{op_scale} is \code{0}.}

\item{envir}{Environment (or named list) containing configuration list(s).}

\item{filename}{Name of Wavefront OBJ object.  By default \code{tempfile(fileext = ".obj")}.}

\item{scale}{Multiplicative scaling factor to apply to width, height, and depth.}

\item{res}{Resolution of the faces.}
}
\value{
A data frame with named elements "obj", "mtl", "png" with the created filenames.
}
\description{
\code{save_piece_obj()} saves Wavefront OBJ files (including associated MTL and texture image) of board game pieces.
}
\examples{
    if (all(capabilities(c("cairo", "png")))) {
      cfg <- game_systems("sans", border = FALSE)$dominoes
      files <- save_piece_obj("tile_face", suit = 3+1, rank=6+1, cfg = cfg)
      print(files)
    }
}
\seealso{
See \code{\link{geometry_utils}} for a discussion of the 3D rotation parameterization.
}
