% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphtest-functions.R
\name{format_fortify}
\alias{format_fortify}
\title{format_fortify}
\usage{
format_fortify(
  model,
  nodes = NULL,
  weights = NULL,
  arrow.gap = 0,
  by = NULL,
  scale = TRUE,
  stringsAsFactors = getOption("stringsAsFactors", FALSE),
  .list_vertex_attributes_fun = NULL,
  .get_vertex_attributes_fun = NULL,
  .list_edges_attributes_fun = NULL,
  .get_edges_attributes_fun = NULL,
  .as_edges_list_fun = NULL
)
}
\arguments{
\item{model}{an object of class \code{\link[network]{network}}
or \code{\link[igraph:igraph-package]{igraph}}.}

\item{nodes}{a nodes object from a call to fortify.}

\item{weights}{the name of an edge attribute to use as edge weights when
computing the network layout, if the layout supports such weights (see
'Details').
Defaults to \code{NULL} (no edge weights).}

\item{arrow.gap}{a parameter that will shorten the network edges in order to
avoid overplotting edge arrows and nodes; defaults to \code{0} when the
network is undirected (no edge shortening), or to \code{0.025} when the
network is directed. Small values near \code{0.025} will generally achieve
good results when the size of the nodes is reasonably small.}

\item{by}{a character vector that matches an edge attribute, which will be
used to generate a data frame that can be plotted with
\code{\link[ggplot2]{facet_wrap}} or \code{\link[ggplot2]{facet_grid}}. The
nodes of the network will appear in all facets, at the same coordinates.
Defaults to \code{NULL} (no faceting).}

\item{scale}{whether to (re)scale the layout coordinates. Defaults to
\code{TRUE}, but should be set to \code{FALSE} if \code{layout} contains
meaningful spatial coordinates, such as latitude and longitude.}

\item{stringsAsFactors}{whether vertex and edge attributes should be
converted to factors if they are of class \code{character}. Defaults to
the value of \code{getOption("stringsAsFactors")}, which is \code{FALSE}
by default: see \code{\link[base]{data.frame}}.}

\item{.list_vertex_attributes_fun}{a "list vertex attributes" function.}

\item{.get_vertex_attributes_fun}{a "get vertex attributes" function.}

\item{.list_edges_attributes_fun}{a "get edges attributes" function.}

\item{.get_edges_attributes_fun}{a "get edges attributes" function.}

\item{.as_edges_list_fun}{a "as edges list" function.}
}
\value{
a \code{\link[base]{data.frame}} object.
}
\description{
a unified function to format \code{\link[network]{network}} or
\code{\link[igraph:igraph-package]{igraph}} object. Copied with
very slight modification from
https://github.com/briatte/ggnetwork/blob/master/R/utilities.R to
fix the same CRAN problem as new_fortify.igraph.
}
\keyword{internal}
