% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pensynth.R
\name{pensynth}
\alias{pensynth}
\title{Penalized synthetic control estimator}
\usage{
pensynth(
  X1,
  X0,
  v = 1,
  lambda = 0,
  opt_pars = clarabel::clarabel_control(),
  standardize = TRUE,
  verbose = interactive()
)
}
\arguments{
\item{X1}{\verb{N_covars by N_treated matrix} of treated unit covariates}

\item{X0}{\verb{N_covars by N_donors matrix} of donor unit covariates}

\item{v}{\verb{N_covars vector} of variable weights (default 1)}

\item{lambda}{\code{numeric} penalization parameter}

\item{opt_pars}{\code{clarabel} settings using \code{\link[clarabel:clarabel_control]{clarabel::clarabel_control()}}}

\item{standardize}{\code{boolean} whether to standardize the input matrices (default TRUE)}

\item{verbose}{\code{boolean} whether to print progress messages. Default on if in an interactive session.}
}
\value{
A list with two values: \code{w}, the estimated weights; and
\code{solution}, the result of the optimization.
}
\description{
For a given set of variable weights (v) this function estimates
the unit weights for a synthetic control with penalization
according to Abadie & L'Hour (2021). This function deals with only a
single treated unit.
}
\details{
This routine uses the same notation of the original \code{\link[Synth:synth]{Synth::synth()}} implementation
but uses a different, faster quadratic program solver (namely, \code{\link[clarabel:clarabel]{clarabel::clarabel()}}).
Additionally, it implements the penalization procedure described in Abadie & L'Hour (2021),
such that the loss function is as in equation 5 of that paper.

Variable weights are not optimized by this function, meaning they need to be pre-specified.
This is by design.

The original synthetic control method can be recovered by setting lambda = 0. For determining
lambda based on hold-out data, see \code{\link[=cv_pensynth]{cv_pensynth()}}.
}
\examples{
# generate some data
X0 <- matrix(
  c(1, 1.3,
    0.5, 1.8,
    1.1, 2.4,
    1.8, 1.8,
    1.3, 1.8), 2)
X1 <- matrix(c(0.8, 1.65), 2)

# run classic synthetic control (no penalization)
res <- pensynth(X1, X0)

# plot donor units in covariate space
plot(t(X0), asp = 1, xlab = "X1", ylab = "X2",
     main = "Covariate space plot")
# add the treated unit
points(t(X1), pch = 2)
# add the synthetic control
points(t(X0\%*\%res$w), pch = 3)

# run synthetic control with penalty
res <- pensynth(X1, X0, lambda = 0.5)
# the resulting synthetic control is
# biased towards its closest neighbours
points(t(X0 \%*\% res$w), pch = 4)
}
\references{
Abadie, A., & L’Hour, J. (2021).
A penalized synthetic control estimator for disaggregated data.
\emph{Journal of the American Statistical Association, 116}(536), 1817-1834.
}
\seealso{
\code{\link[=cv_pensynth]{cv_pensynth()}}, \code{\link[=placebo_test]{placebo_test()}}, \code{\link[=simulate_data_synth]{simulate_data_synth()}}, \code{\link[Synth:synth]{Synth::synth()}}
}
