% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proj_rank_r.R
\name{proj_rank_r}
\alias{proj_rank_r}
\title{Project matrix to rank r}
\usage{
proj_rank_r(D, r)
}
\arguments{
\item{D}{The input data matrix (cannot have \code{NA} values).}

\item{r}{The rank that \code{D} should be projected/truncated to.}
}
\value{
The best rank-\code{r} approximation to \code{D} via a truncated SVD.
}
\description{
\code{proj_rank_r()} implements a best (i.e. closest) rank-\code{r} approximation of
an input matrix.

This is computed via a simple truncated singular value decomposition (SVD),
retaining the first \code{r} leading singular values/vectors of \code{D}.
This is equivalent to solving the following optimization problem:
\eqn{min ||X-D||_F s.t. rank(X) <= r}, where \code{X} is the approximated solution
and \code{D} is the input matrix.

\code{proj_rank_r()} is used to iteratively model the low-rank \code{L} matrix in the
non-convex PCP function \code{\link[=rrmc]{rrmc()}}, providing a non-convex replacement for the
\code{prox_nuclear()} method used in the convex PCP function \code{\link[=root_pcp]{root_pcp()}}.

Intuitively, \code{proj_rank_r()} can also be thought of as providing a PCA
estimate of a rank-\code{r} matrix \code{L} from observed data \code{D}.
}
\examples{
# Simulating a simple dataset D with the sim_data() function.
# The dataset will be a 10x5 matrix comprised of:
# 1. A rank-1 component as the ground truth L matrix; and
# 2. A dense Gaussian noise component corrupting L, making L full-rank
data <- sim_data(10, 5, 1, numeric(), 0.01)
# The observed matrix D is full-rank, while L is rank-1:
data.frame("D_rank" = matrix_rank(data$D), "L_rank" = matrix_rank(data$L))
before_proj_err <- norm(data$D - data$L, "F") / norm(data$L, "F")
# Projecting D onto the nearest rank-1 approximation, X, via proj_rank_r()
X <- proj_rank_r(data$D, r = 1)
after_proj_err <- norm(X - data$L, "F") / norm(data$L, "F")
proj_v_obs_err <- norm(X - data$D, "F") / norm(data$D, "F")
data.frame(
  "Observed_error" = before_proj_err,
  "Projected_error" = after_proj_err,
  "Projected_vs_observed_error" = proj_v_obs_err
)
}
\seealso{
\code{\link[=rrmc]{rrmc()}}
}
