% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patternboxplot.R
\name{patternboxplot}
\alias{patternboxplot}
\title{Plot a boxplot using patterns and colors to fill the boxes.}
\usage{
patternboxplot(
  data,
  x,
  y,
  group = NULL,
  xlab = "",
  ylab = "",
  label.size = 3.5,
  linetype = rep("solid", ifelse(is.null(group), length(unique(x)),
    length(unique(group)))),
  outlier.shape = 21,
  outlier.color = "black",
  outlier.size = 1,
  pattern.type,
  pattern.color = rep("black", ifelse(is.null(group), length(unique(x)),
    length(unique(group)))),
  pattern.line.size = rep(5, ifelse(is.null(group), length(x), length(unique(group)))),
  background.color = rep("white", ifelse(is.null(group), length(unique(x)),
    length(unique(group)))),
  frame.color = rep("black", ifelse(is.null(group), length(unique(x)),
    length(unique(group)))),
  frame.size = 1,
  pixel = 20,
  density = rep(7, ifelse(is.null(group), length(unique(x)), length(unique(group)))),
  legend.type = "h",
  legend.h = 6,
  legend.x.pos = 1.1,
  legend.y.pos = 0.49,
  legend.w = 0.2,
  legend.pixel = 20,
  legend.label
)
}
\arguments{
\item{data}{the data to be used.}

\item{x}{the variable used on x axis.}

\item{y}{the variable used on y axis.}

\item{group}{the variable used as the second grouping variable on x axis.}

\item{xlab}{a character string to give x axis label.}

\item{ylab}{a character string to give y axis label.}

\item{label.size}{the font size of legend labels shown above the boxplots.}

\item{linetype}{the linetype for the borders of boxplots.}

\item{outlier.shape}{the shape of outlier dots.}

\item{outlier.color}{the color of outlier dots.}

\item{outlier.size}{the size of outlier dots.}

\item{pattern.type}{a vector of patterns to be filled in the boxes 
The pattern types include: 'blank', 'bricks', 'vdashes', 'hdashes', 'crosshatch','dots', 
'grid','hlines','nelines', 'nwlines', 'vlines', 'waves' and more.}

\item{pattern.color}{a vector of colors for the lines/dots of patterns.}

\item{pattern.line.size}{a vector of numeric values, the line size for the lines/dots of patterns.}

\item{background.color}{a vector of colors to be filled in the boxes.}

\item{frame.color}{the color for the borders of boxes.}

\item{frame.size}{a numeric value, the line size for the borders of boxes.}

\item{pixel}{a numeric value, the pixel resolution of boxplot.}

\item{density}{a numeric vector, the density for the lines/dots of patterns.}

\item{legend.type}{if legend.type='h', the layout of legends is horizontal; if legend.type='v', the layout of legends is vertical.}

\item{legend.h}{a numeric value to change the height of legend boxes.}

\item{legend.x.pos}{a numeric value to change the position of legends on x axis.}

\item{legend.y.pos}{a numeric value to change the position of legends on y axis.}

\item{legend.w}{a numeric value to change the width of legends.}

\item{legend.pixel}{a numeric value to change pixel of legends.}

\item{legend.label}{a vector to name legend labels.}
}
\value{
A ggplot object.
}
\description{
The \code{patternboxplot} function is a tool for creating versatile boxplots 
by filling the boxplots with colors and patterns.
}
\details{
\code{patternboxplot} function offers flexible ways of doing boxplots.
}
\examples{
library(patternplot)
library(png)
library(ggplot2)

#Example 1
data <- read.csv(system.file("extdata", "fruits.csv", package="patternplot"))
group<-data$Fruit
y<-data$Weight
x<-data$Store

pattern.type<-c('nwlines', 'blank', 'waves')
pattern.color=c('black','black', 'black')
background.color=c('white','gray80', 'white')
frame.color=c('black', 'black', 'black')
pattern.line.size<-c(6, 1,6)
density<-c(6, 1, 8)
patternboxplot(data,x, y,group,pattern.type=pattern.type,pattern.line.size=pattern.line.size,
pattern.color=pattern.color,background.color=background.color,frame.color=frame.color, 
density=density,legend.h=2,legend.x.pos=1.1,legend.y.pos=0.495,legend.pixel=10, legend.w=0.2, 
legend.label=c("Orange", "Strawberry", "Watermelon"))

#Example 2
pattern.color=c('black','white', 'grey20')
background.color=c('gold','lightpink', 'lightgreen')
patternboxplot(data,x, y,group=group,pattern.type=pattern.type,pattern.line.size=pattern.line.size, 
pattern.color=pattern.color, background.color=background.color,frame.color=frame.color, 
density=density,legend.h=2,legend.x.pos=1.1,legend.y.pos=0.495,legend.pixel=10,legend.w=0.2, 
legend.label=c("Orange", "Strawberry", "Watermelon"))

}
\seealso{
Function \code{imageboxplot}
}
\author{
Chunqiao Luo (chunqiaoluo@gmail.com)
}
