% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patArea.R
\name{patArea}
\alias{patArea}
\title{This fucntion calculates the area in which the color pattern is expressed in each sample as the
relative proportion using the provided outline of the considered trait or structure.}
\usage{
patArea(
  rList,
  IDlist,
  refShape,
  type,
  outline = NULL,
  landList = NULL,
  adjustCoords = FALSE,
  cartoonID = NULL,
  crop = c(0, 0, 0, 0),
  flipRaster = NULL,
  flipOutline = NULL,
  imageList = NULL
)
}
\arguments{
\item{rList}{List of RasterLayers as obtained from the main patternize functions.}

\item{IDlist}{List of sample IDs.}

\item{refShape}{This can be 'target' in case the reference shape is a single sample (for
registration analysis) or 'mean' if the images were transformed to a mean shape using landmark
transformation.}

\item{type}{Type of rasterlist; 'RGB' or 'k' (result from RGB or k-means analysis, respectively).}

\item{outline}{xy coordinates that define outline.}

\item{landList}{Landmark list as returned by \code{\link[patternize]{makeList}}.}

\item{adjustCoords}{Adjust landmark coordinates in case they are reversed compared to pixel
coordinates (default = FALSE).}

\item{cartoonID}{ID of the sample for which the cartoon was drawn.}

\item{crop}{Vector c(xmin, xmax, ymin, ymax) that specifies the pixel coordinates to crop the
original image used in landmark or registration analysis.}

\item{flipRaster}{Whether to flip raster along xy axis (in case there is an inconsistency between
raster and outline coordinates).}

\item{flipOutline}{Whether to flip plot along x, y or xy axis.}

\item{imageList}{List of images as obtained from \code{\link[patternize]{makeList}} should be given
if one wants to flip the outline or adjust landmark coordinates.}
}
\value{
Table or list of tables with sample IDs and relative area of color pattern or kmeans cluster.
}
\description{
This fucntion calculates the area in which the color pattern is expressed in each sample as the
relative proportion using the provided outline of the considered trait or structure.
}
\examples{

data(rasterList_lanRGB)
#data(rasterList_regRGB)
#data(rasterList_lanK)
#data(rasterList_regK)

data(imageList)

IDlist <- c('BC0077','BC0071','BC0050','BC0049','BC0004')

outline_BC0077 <- read.table(paste(system.file("extdata",  package = 'patternize'),
'/BC0077_outline.txt', sep=''), header = FALSE)

prepath <- system.file("extdata", package = 'patternize')
extension <- '_landmarks_LFW.txt'

landmarkList <- makeList(IDlist, 'landmark', prepath, extension)

\dontrun{
area_lanRGB <- patArea(rasterList_lanRGB, IDlist, refShape = 'mean', type = 'RGB',
outline = outline_BC0077, landList = landmarkList, adjustCoords = TRUE,
imageList = imageList, cartoonID = 'BC0077')

area_regRGB <- patArea(rasterList_regRGB, IDlist, refShape = 'target', type = 'RGB',
outline = outline_BC0077, crop = c(100,400,40,250), adjustCoords = TRUE,
imageList = imageList, cartoonID = 'BC0077', flipRaster = 'xy')

areaList_lanK <- patArea(rasterList_lanK, IDlist, refShape = 'mean', type = 'k',
outline = outline_BC0077, landList = landmarkList, adjustCoords = TRUE,
imageList = imageList, cartoonID = 'BC0077')

areaList_regK <- patArea(rasterList_regK, IDlist, refShape = 'target', type = 'k',
outline = outline_BC0077, crop = c(100,400,40,250), adjustCoords = TRUE,
imageList = imageList, cartoonID = 'BC0077', flipRaster = 'xy')
}

}
