% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_parsnip.R
\name{control_parsnip}
\alias{control_parsnip}
\title{Control the fit function}
\usage{
control_parsnip(verbosity = 1L, catch = FALSE)
}
\arguments{
\item{verbosity}{An integer to control how verbose the output is. For a
value of zero, no messages or output are shown when packages are loaded or
when the model is fit. For a value of 1, package loading is quiet but model
fits can produce output to the screen (depending on if they contain their
own \code{verbose}-type argument). For a value of 2 or more, any output at all
is displayed and the execution time of the fit is recorded and printed.}

\item{catch}{A logical where a value of \code{TRUE} will evaluate the model
inside of \code{try(, silent = TRUE)}. If the model fails, an object is still
returned (without an error) that inherits the class "try-error".}
}
\value{
An S3 object with class "control_parsnip" that is a named list
with the results of the function call
}
\description{
Pass options to the \code{\link[=fit.model_spec]{fit.model_spec()}} function to control its
output and computations
}
\examples{
\dontshow{if (!parsnip:::is_cran_check()) withAutoprint(\{ # examplesIf}
control_parsnip(verbosity = 2L)
\dontshow{\}) # examplesIf}
}
