% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_hooks_linter.R
\name{package_hooks_linter}
\alias{package_hooks_linter}
\title{Package hooks linter}
\usage{
package_hooks_linter()
}
\description{
Check various common "gotchas" in \code{\link[=.onLoad]{.onLoad()}}, \code{\link[=.onAttach]{.onAttach()}}, \code{\link[=.Last.lib]{.Last.lib()}}, \code{\link[=.onDetach]{.onDetach()}}, and \code{\link[=.onUnload]{.onUnload()}}
namespace hooks that will cause \verb{R CMD check} issues. See Writing R Extensions for details.
}
\details{
\enumerate{
\item \code{.onLoad()} shouldn't call \code{\link[=cat]{cat()}}, \code{\link[=message]{message()}}, \code{\link[=print]{print()}}, \code{\link[=writeLines]{writeLines()}}, \code{\link[=packageStartupMessage]{packageStartupMessage()}},
\code{\link[=require]{require()}}, \code{\link[=library]{library()}}, or \code{\link[=installed.packages]{installed.packages()}}.
\item \code{.onAttach()} shouldn't call \code{cat()}, \code{message()}, \code{print()}, \code{writeLines()}, \code{\link[=library.dynam]{library.dynam()}},
\code{require()}, \code{library()}, or \code{installed.packages()}.
\item \code{.Last.lib()} and \code{.onDetach()} shouldn't call \code{\link[=library.dynam.unload]{library.dynam.unload()}}.
\item \code{.onLoad()} and \code{.onAttach()} should take two arguments, with names matching \verb{^lib} and \verb{^pkg};
\code{.Last.lib()}, \code{.onDetach()}, and \code{.onUnload()} should take one argument with name matching \verb{^lib}.
}
}
\examples{
# will produce lints
lint(
  text = ".onLoad <- function(lib, ...) { }",
  linters = package_hooks_linter()
)

lint(
  text = ".onAttach <- function(lib, pkg) { require(foo) }",
  linters = package_hooks_linter()
)

lint(
  text = ".onDetach <- function(pkg) { }",
  linters = package_hooks_linter()
)

lint(
  text = ".onUnload <- function() { }",
  linters = package_hooks_linter()
)

# okay
lint(
  text = ".onLoad <- function(lib, pkg) { }",
  linters = package_hooks_linter()
)

lint(
  text = '.onAttach <- function(lib, pkg) { loadNamespace("foo") }',
  linters = package_hooks_linter()
)

lint(
  text = ".onDetach <- function(lib) { }",
  linters = package_hooks_linter()
)

lint(
  text = ".onUnload <- function(libpath) { }",
  linters = package_hooks_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=correctness_linters]{correctness}, \link[=package_development_linters]{package_development}, \link[=style_linters]{style}
}
