% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivolcano.R
\name{ivolcano_point}
\alias{ivolcano_point}
\title{ivolcano_point}
\usage{
ivolcano_point(
  data,
  logFC_col = "logFC",
  pval_col = "adj.P.Val",
  gene_col = "gene",
  title = "Volcano Plot",
  interactive = TRUE,
  onclick_fun = NULL,
  pval_cutoff = 0.05,
  logFC_cutoff = 1,
  pval_cutoff2 = NULL,
  logFC_cutoff2 = NULL,
  size_by = "none",
  point_size = list(base = 2, medium = 4, large = 6)
)
}
\arguments{
\item{data}{A data frame that contains minimal information with gene id, logFC and adjusted P values}

\item{logFC_col}{column name in 'data' that stored the logFC values}

\item{pval_col}{column name in 'data' that stored the adjusted P values}

\item{gene_col}{column name in 'data' that stored the gene IDs}

\item{title}{plot title}

\item{interactive}{whether plot the graph in interactive mode}

\item{onclick_fun}{effects when click on the dot (gene), default is NULL}

\item{pval_cutoff}{cutoff of the adjusted P values}

\item{logFC_cutoff}{cutoff of the logFC values}

\item{pval_cutoff2}{second cutoff of the adjusted P values for advanced mode}

\item{logFC_cutoff2}{second cutoff of the logFC values for advanced mode}

\item{size_by}{one of "none" (default), "manual" (set by \code{point_size}), "negLogP", "absLogFC", or other variable in the input data to scale dot sizes.}

\item{point_size}{set point size when \code{size_by} is "manual", a list with three elements: base, medium, large.}
}
\value{
base plot of a volcano plot
}
\description{
Visualize points in volcano plot
}
