% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdsPlottly.R
\name{mdsPlottly}
\alias{mdsPlottly}
\title{mdsPlottly}
\usage{
mdsPlottly(x, Sample, Group, title, palette, top, gene.selection)
}
\arguments{
\item{x}{A DGEList object from edgeR.}

\item{Sample}{Character vector. Sample names corresponding to columns of  "x ".}

\item{Group}{Factor or character vector. Group or condition for each sample.}

\item{title}{Character. Title for the plot.}

\item{palette}{Character. Name of a discrete palette from the  "paletteer " package.}

\item{top}{Integer. Number of top most variable genes (by logFC) to include in MDS.}

\item{gene.selection}{Character. Gene selection method: one of  ""pairwise" ",  ""common" ", or  ""logFC" ".}
}
\value{
A Plotly object ( "plotly::ggplotly ") representing the interactive MDS scatterplot.
}
\description{
Generate an interactive MDS plot using Plotly based on expression data.
}
\details{
This function computes multidimensional scaling (MDS) coordinates with limma's  "plotMDS() "
and then renders an interactive scatterplot via  "plotly::ggplotly() ".
\enumerate{
\item Compute MDS on the input data with  "limma::plotMDS() ".
\item Extract eigenvalues and first two dimensions for variance annotation.
\item Build a ggplot2 scatterplot with axis labels showing percent variance explained.
\item Convert the ggplot to an interactive Plotly graph.
}
}
