% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galamm-object.R
\docType{class}
\name{galammObject}
\alias{galammObject}
\title{Class "galamm"}
\description{
An S3 class for objects returned by \code{\link[=galamm]{galamm()}}.
Contains information about the fitted model, random effects, parameters, and
smooth terms.
}
\section{Components}{

\itemize{
\item \code{call}: the matched call used when fitting the model.
\item \code{random_effects}: a list with:
\itemize{
\item \code{b}: random effects in original parametrization.
\item \code{u}: random effects standardized to have identity covariance matrix.
}
\item \code{model}: a list containing:
\itemize{
\item \code{deviance}: deviance of final model.
\item \code{deviance_residuals}: deviance residuals.
\item \code{df}: degrees of freedom.
\item \code{family}: one or more family objects.
\item \code{factor_interactions}: list of formulas for latent-observed interactions.
\item \code{fit}: fitted values.
\item \code{fit_population}: fitted values excluding random effects.
\item \code{hessian}: Hessian matrix of the final model.
\item \code{lmod}: linear model object from \code{\link[lme4:modular]{lme4::lFormula()}}.
\item \code{loglik}: log-likelihood of the final model.
\item \code{n}: number of observations.
\item \code{pearson_residual}: Pearson residuals.
\item \code{reduced_hessian}: logical; whether full Hessian or reduced version.
\item \code{response}: numeric vector of response values.
\item \code{weights_object}: object with weights (or \code{NULL}).
}
\item \code{parameters}: a list with model parameters and metadata:
\itemize{
\item \code{beta_inds}: indices of fixed regression coefficients.
\item \code{dispersion_parameter}: dispersion parameters.
\item \code{lambda_dummy}: dummy factor loading matrix.
\item \code{lambda_inds}: indices of factor loadings.
\item \code{lambda_interaction_inds}: indices of latent-observed interactions.
\item \code{parameter_estimates}: numeric vector of parameter estimates.
\item \code{parameter_names}: names of all parameters.
\item \code{theta_inds}: indices of variance components (Cholesky entries).
\item \code{weights_inds}: indices of estimated weights.
}
\item \code{gam}: list of smooth term info (empty list if none).
}
}

\seealso{
Other modeling functions: 
\code{\link{galamm}()},
\code{\link{gfam}()},
\code{\link{s}()},
\code{\link{t2}()}
}
\concept{modeling functions}
