% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_species.R
\name{select_species}
\alias{select_species}
\title{Selection of species based on its characteristics and distribution}
\usage{
select_species(data,
                      include_subspecies = FALSE, include_variety = FALSE,
                      kingdom = "Plantae", group = "All", subgroup = "All",
                      phylum = "All", class ="All", order = "All",
                      family = "All", genus = "All",
                      lifeForm = "All", filter_lifeForm = "in",
                      habitat = "All", filter_habitat = "in",
                      biome = "All", filter_biome = "in",
                      state = "All", filter_state = "in",
                      vegetation = "All", filter_vegetation = "in",
                      endemism = "All", origin = "All",
                      taxonomicStatus = "Accepted",
                      nomenclaturalStatus = "All")
}
\arguments{
\item{data}{(data.frame) the data.frame imported with the
\code{\link{load_florabr}} function.}

\item{include_subspecies}{(logical) include subspecies?
Default = FALSE}

\item{include_variety}{(logical) include varieties of the species?
Default = FALSE}

\item{kingdom}{(character) The kingdom for filtering the dataset. It can be
"Plantae" or "Fungi". Default = "Plantae". To include both,
use c("Plantae", "Fungi")}

\item{group}{(character) The groups for filtering the datasets. It can be
"Fungi", "Angiosperms", "Gymnosperms", "Ferns and Lycophytes",
"Bryophytes" and "Algae". To use more than one group, put the available
items in a vector, for example: group = c(Angiosperms", "Gymnosperms").
Default = "All".}

\item{subgroup}{(character) The subgroups for filtering the dataset.
Only available if the group is "Fungi" or "Bryophytes". For Fungi, it can be
"stricto sensu" or "lato sensu". For Bryophytes, it can be "Mosses",
"Hornworts" and "Liverworts" . To use more than one group, put the available
items in a vector, for example: subgroup = c("Mosses", "Hornworts").
Default = "All".}

\item{phylum}{(character) The phyla for filtering the dataset. It can
be included more than one phylum. Default = "All".}

\item{class}{(character) The classes for filtering the dataset. It can
be included more than one class. Default = "All".}

\item{order}{(character) The orders for filtering the dataset. It can
be included more than one order. Default = "All".}

\item{family}{(character) The families for filtering the dataset. It can
be included more than one family. Default = "All".}

\item{genus}{(character) The genus for filtering the dataset. It can
be included more than one genus. Default = "All".}

\item{lifeForm}{(character) The life forms for filtering the dataset. It can
be included more than one lifeForm. Default = "All"}

\item{filter_lifeForm}{(character) The type of filtering for life forms. It
can be "in", "only", "not_in" and "and". See details for more about this
argument.}

\item{habitat}{(character) The life habitat for filtering the dataset. It can
be included more than one habitat. Default = "All"}

\item{filter_habitat}{(character) The type of filtering for habitat. It
can be "in", "only", "not_in" and "and". See details for more about this
argument.}

\item{biome}{(character) The biomes for filtering the dataset. It can
be included more than one biome. Default = "All"}

\item{filter_biome}{(character) The type of filtering for biome. It
can be "in", "only", "not_in" and "and". See details for more about this
argument.}

\item{state}{(character) The states for filtering the dataset. It can
be included more than one state. Default = "All".}

\item{filter_state}{(character) The type of filtering for state. It
can be "in", "only", "not_in" and "and". See Details for more about this
argument.}

\item{vegetation}{(character) The vegetation types for filtering the
dataset. It can be included more than one vegetation type. Default = "All".}

\item{filter_vegetation}{(character) The type of filtering for
vegetation type. It can be "in", "only", "not_in" and "and". See details for
more about this argument.}

\item{endemism}{(character) The endemism (endemic or non-endemic to Brazil)
for filtering the dataset. It can be "All", "Endemic" or "Non-endemic".
Default = "All".}

\item{origin}{(character) The origin for filtering the dataset. It can
be "All", "Native", "Cultivated" and "Naturalized". Default = "All".}

\item{taxonomicStatus}{(character) The taxonomic status for filtering the
dataset. It can be "All", "Accepted" or "Synonym". Default = "Accepted".}

\item{nomenclaturalStatus}{(character) The nomenclatural status for
filtering the dataset. Default = "Accepted"}
}
\value{
A new dataframe with the filtered species.
}
\description{
select_species allows filter species based on its
characteristics and distribution available in Flora e Funga do Brasil
}
\details{
It's possible to choose 4 ways to filter by lifeForm, by habitat,
by biome, by state and by vegetation type:
"in": selects species that have any occurrence of the determined values. It
allows multiple matches. For example, if biome = c("Amazon", Cerrado" and
filter_biome = "in", it will select all species that occur in the Amazon and
Cerrado, some of which may also occur in other biomes.

"only": selects species that have only occurrence of the determined values.
It allows only single matches. For example, if biome = c("Amazon", "Cerrado")
and filter_biome = "only", it will select all species that occur exclusively
in both the Amazon and Cerrado biomes, without any occurrences in other
biomes.

"not_in": selects species that don't have occurrence of the determined
values. It allows single and multiple matches. For example,
if biome = c("Amazon", "Cerrado") and filter_biome = "not_in", it will select
all species without occurrences in the Amazon and Cerrado biomes.

"and": selects species that have occurrence in all determined values. It
allows single and multiple matches. For example,
if biome = c("Amazon", "Cerrado") and filter_biome = "and", it will select
all species that occurs only in both the Amazon and Cerrado biomes,
including species that occurs in other biomes too.

To get the complete list of arguments available for family, genus, lifeForm,
habitat, biome, state, and nomenclaturalStatus, use the function
\code{\link{get_attributes}}
}
\examples{
data("bf_data") #Load Flora e Funga do Brasil data
#'Select endemic and native species of trees with disjunct occurrence in
# Atlantic Forest and Amazon
am_af_only <- select_species(data = bf_data,
                             include_subspecies = FALSE,
                             include_variety = FALSE,
                             kingdom = "Plantae",
                             group = "All", subgroup = "All",
                             phylum = "All", class ="All", order = "All",
                             family = "All", genus = "All",
                             lifeForm = "Tree", filter_lifeForm = "only",
                             habitat = "All", filter_habitat = "in",
                             biome = c("Atlantic_Forest","Amazon"),
                             filter_biome = "only",
                             state = "All", filter_state = "and",
                             vegetation = "All",
                             filter_vegetation = "in",
                             endemism = "Endemic", origin = "Native",
                             taxonomicStatus = "All",
                             nomenclaturalStatus = "All")
}
\references{
Flora e Funga do Brasil. Jardim Botânico do Rio de Janeiro. Available at:
http://floradobrasil.jbrj.gov.br/
}
