% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chol2inv.r
\name{chol2inv}
\alias{chol2inv}
\alias{chol2inv,float32-method}
\title{chol2inv}
\usage{
\S4method{chol2inv}{float32}(x, size = NCOL(x), LINPACK = FALSE)
}
\arguments{
\item{x}{A float vector/matrix.}

\item{size}{The number of columns to use.}

\item{LINPACK}{Ignored.}
}
\value{
A float vector/matrix.
}
\description{
Return the inverse of the original matrix using the Cholesky factorization of
a float vector/matrix.
}
\examples{
library(float)

s = flrunif(10, 3)
cp = crossprod(s)
cp \%*\% chol2inv(chol(cp))

}
