% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intrinsic_selection.R
\name{intrinsic_selection}
\alias{intrinsic_selection}
\title{Perform intrinsic, ensemble-based variable selection}
\usage{
intrinsic_selection(
  spvim_ests = NULL,
  sample_size = NULL,
  feature_names = "",
  alpha = 0.05,
  control = list(quantity = "gFWER", base_method = "Holm", fdr_method = NULL, q = NULL, k
    = NULL)
)
}
\arguments{
\item{spvim_ests}{the estimated SPVIM values (an object of class \code{vim},
resulting from a call to \code{vimp::sp_vim}). Can also be a list of
estimated SPVIMs, if multiple imputation was used to handle missing data; in
this case, Rubin's rules will be used to combine the estimated SPVIMs, and
then selection will be based on the combined SPVIMs.}

\item{sample_size}{the number of independent observations used to estimate
the SPVIM values.}

\item{feature_names}{the names of the features (a character vector of
length \code{p} (the total number of features)); only used if the
fitted Super Learner ensemble was fit on a \code{matrix} rather than on a
\code{data.frame}, \code{tibble}, etc.}

\item{alpha}{the nominal generalized family-wise error rate, proportion of
false positives, or false discovery rate level to control at (e.g., 0.05).}

\item{control}{a list of parameters to control the variable selection process.
Parameters include \code{quantity}, \code{base_method}, \code{q}, and
\code{k}. See \code{\link[flevr]{intrinsic_control}} for details.}
}
\value{
a tibble with the estimated intrinsic variable importance,
the corresponding variable importance ranks, and the selected
variables.
}
\description{
Based on estimated SPVIM values, do variable selection using the
specified error-controlling method.
}
\examples{
\donttest{
data("biomarkers")
# subset to complete cases for illustration
cc <- complete.cases(biomarkers)
dat_cc <- biomarkers[cc, ]
# use only the mucinous outcome, not the high-malignancy outcome
y <- dat_cc$mucinous
x <- dat_cc[, !(names(dat_cc) \%in\% c("mucinous", "high_malignancy"))]
feature_nms <- names(x)
# estimate SPVIMs (using simple library and V = 2 for illustration only)
set.seed(20231129)
library("SuperLearner")
est <- vimp::sp_vim(Y = y, X = x, V = 2, type = "auc", SL.library = "SL.glm", 
                    cvControl = list(V = 2))
# do intrinsic selection
intrinsic_set <- intrinsic_selection(spvim_ests = est, sample_size = nrow(dat_cc), alpha = 0.2, 
                                     feature_names = feature_nms, 
                                     control = list(quantity = "gFWER", base_method = "Holm", 
                                                    k = 1))
intrinsic_set
}
}
\seealso{
\code{\link[vimp]{sp_vim}} for specific usage of
the \code{sp_vim} function and the \code{vimp} package for estimating
intrinsic variable importance.
}
