% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fee.R
\name{fee}
\alias{fee}
\title{First-Exposure Effect}
\usage{
fee(model, data, at = "AE")
}
\arguments{
\item{model}{A fitted model object of class \code{"oneinfl"}.}

\item{data}{The original data frame used to fit the model.}

\item{at}{A character string or list. Specifies how the first-exposure effect should be evaluated.
Options are \code{"AE"} (average effect across the data), \code{"EM"} (effect at means), or
a named list specifying covariate values for evaluating a representative case.}
}
\value{
A list with components:
\describe{
  \item{\code{fee}}{The estimated first-exposure effect.}
  \item{\code{sefee}}{The standard error of the estimated effect.}
  \item{\code{where}}{A character string describing the evaluation point.}
  \item{\code{treatment_visits}}{(Optional) Total implied treatment visits if \code{at = "AE"}.}
}
}
\description{
Computes the first-exposure effect (FEE) from a fitted `oneinfl` model object.
The FEE measures the difference between the expected count for a first-time exposure
and the expected count under the baseline (non-inflated) model. The function supports
models estimated using either a one-inflated positive Poisson distribution or a one-inflated
zero-truncated negative binomial distribution.
}
\details{
The effect can be evaluated in three ways, determined by the `at` argument:
\itemize{
  \item \code{"AE"}: Average the FEE over all data points (default).
  \item \code{"EM"}: Evaluate the FEE at the sample means of the covariates.
  \item \code{list}: Evaluate the FEE at a user-specified set of covariate values.
}

If `at = "AE"`, the returned object also includes the total number of treatment visits
implied by the FEE across all observations.
}
\examples{
# Example usage
df <- data.frame(x = runif(10,0,10), d = sample(c(0,1), 10, replace=TRUE), y = rpois(10, 3) + 1)
model <- oneinfl::oneinfl(formula = y ~ x + d | x + d, df = df, dist = "Poisson")
fee(model, data = df)

}
