% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resource_frequency.R
\name{resource_frequency}
\alias{resource_frequency}
\alias{resource_frequency.eventlog}
\alias{resource_frequency.grouped_eventlog}
\alias{resource_frequency.activitylog}
\alias{resource_frequency.grouped_activitylog}
\title{Resource Frequency}
\usage{
resource_frequency(
  log,
  level = c("log", "case", "activity", "resource", "resource-activity"),
  sort = TRUE
)

\method{resource_frequency}{eventlog}(
  log,
  level = c("log", "case", "activity", "resource", "resource-activity"),
  sort = TRUE
)

\method{resource_frequency}{grouped_eventlog}(
  log,
  level = c("log", "case", "activity", "resource", "resource-activity"),
  sort = TRUE
)

\method{resource_frequency}{activitylog}(
  log,
  level = c("log", "case", "activity", "resource", "resource-activity"),
  sort = TRUE
)

\method{resource_frequency}{grouped_activitylog}(
  log,
  level = c("log", "case", "activity", "resource", "resource-activity"),
  sort = TRUE
)
}
\arguments{
\item{log}{\code{\link[bupaR]{log}}: Object of class \code{\link[bupaR]{log}} or derivatives (\code{\link[bupaR]{grouped_log}}, \code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.).}

\item{level}{\code{\link{character}} (default \code{"log"}): Level of granularity for the analysis: \code{"log"} (default),
\code{"case"}, \code{"activity"}, \code{"resource"}, or \code{"resource-activity"}. For more information,
see \code{vignette("metrics", "edeaR")} and 'Details' below.}

\item{sort}{\code{\link{logical}} (default \code{TRUE}): Sort output on count. Only for levels with frequency count output.}
}
\description{
Analyses the frequency of resources at different levels of analysis.
}
\details{
Argument \code{level} has the following options:
\itemize{
\item At \code{"log"} level, summary statistics show the number of times a resource executes an activity in the complete log.
\item On \code{"case"} level, summary statistics of the frequency of resources can be used to get a better view on the
variance between the different cases, to get an insight into the number of different resources working on each case together
with the number of activities a resource executes per case.
\item On \code{"activity"} level, the resource frequency states how many different resources are executing a specific
activity in the complete log.
\item On \code{"resource"} level, this metric simply shows the absolute and relative frequency of occurrences of each
resource in the complete log.
\item On \code{"resource-activity"} level, the absolute and relative number of times each resource-activity combination
occurs in the complete log can be calculated. Two different relative numbers are provided here, one from the resource
perspective and one from the activity perspective. At the resource perspective, the denominator is the total number of
executions by the resource under consideration. At the activity perspective, the denominator is the total number of
occurrences of the activity under consideration.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{resource_frequency(eventlog)}: Computes the resource frequency for an \code{\link[bupaR]{eventlog}}.

\item \code{resource_frequency(grouped_eventlog)}: Computes the resource frequency for a \code{\link[bupaR]{grouped_eventlog}}.

\item \code{resource_frequency(activitylog)}: Computes the resource frequency for an \code{\link[bupaR]{activitylog}}.

\item \code{resource_frequency(grouped_activitylog)}: Computes the resource frequency for a \code{\link[bupaR]{grouped_activitylog}}.

}}
\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
\seealso{
\code{\link{resource_involvement}}

Other metrics: 
\code{\link{activity_frequency}()},
\code{\link{activity_presence}()},
\code{\link{end_activities}()},
\code{\link{idle_time}()},
\code{\link{number_of_repetitions}()},
\code{\link{number_of_selfloops}()},
\code{\link{number_of_traces}()},
\code{\link{processing_time}()},
\code{\link{resource_involvement}()},
\code{\link{resource_specialisation}()},
\code{\link{start_activities}()},
\code{\link{throughput_time}()},
\code{\link{trace_coverage}()},
\code{\link{trace_length}()}
}
\concept{metrics}
\concept{metrics_organizational}
