% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgm_plot_class.R
\name{structure}
\alias{structure}
\alias{plot_structure}
\title{Structure plot}
\usage{
plot_structure(output, ...)
}
\arguments{
\item{output}{Output object from the easybgm function. Supports also objects from the bgm function of the \code{bgms} package.}

\item{...}{Additional arguments passed onto \code{qgraph}}
}
\value{
Returns a plot
}
\description{
The plot shows the resulting graph structure, i.e. all edges with some evidence of inclusion (i.e., inclusion Bayes factor greater than 1).
}
\examples{
\donttest{

library(easybgm)
library(bgms)

data <- na.omit(Wenchuan)
fit <- easybgm(data, type = "ordinal",
                iter = 100  # for demonstration only (> 5e4 recommended)
               )

plot_structure(fit)
}
}
